---@meta
---@diagnostic disable

---@class ABaseQuestObjectiveWrapper : AJournalEntryWrapper
---@field questObjective gameJournalQuestObjectiveBase
---@field objectiveStatus gameJournalEntryState
---@field isTracked Bool
---@field currentCounter Int32
---@field totalCounter Int32
ABaseQuestObjectiveWrapper = {}

---@return String
function ABaseQuestObjectiveWrapper:GetCounterText() return end

---@return String
function ABaseQuestObjectiveWrapper:GetDescription() return end

---@return gameJournalQuestObjectiveBase
function ABaseQuestObjectiveWrapper:GetQuestObjective() return end

---@return gameJournalEntryState
function ABaseQuestObjectiveWrapper:GetStatus() return end

---@param questObjective gameJournalQuestObjectiveBase
---@param objectiveStatus gameJournalEntryState
---@param isTracked Bool
---@param uniqueId Int32
---@param currentCounter Int32
---@param totalCounter Int32
function ABaseQuestObjectiveWrapper:Init(questObjective, objectiveStatus, isTracked, uniqueId, currentCounter, totalCounter) return end

---@return Bool
function ABaseQuestObjectiveWrapper:IsActive() return end

---@return Bool
function ABaseQuestObjectiveWrapper:IsTracked() return end

---@return Bool
function ABaseQuestObjectiveWrapper:IsTrackedInHierarchy() return end

---@class ABaseWrapper : IScriptable
ABaseWrapper = {}

---@return String
function ABaseWrapper:ToString() return end

---@class AGenericTooltipController : inkWidgetLogicController
---@field Root inkCompoundWidget
AGenericTooltipController = {}

---@return Bool
function AGenericTooltipController:OnInitialize() return end

function AGenericTooltipController:Hide() return end

function AGenericTooltipController:Refresh() return end

---@param tooltipData ATooltipData
function AGenericTooltipController:SetData(tooltipData) return end

---@param styleResPath redResourceReferenceScriptToken
function AGenericTooltipController:SetStyle(styleResPath) return end

function AGenericTooltipController:Show() return end

---@class AGenericTooltipControllerWithDebug : AGenericTooltipController
---@field DEBUG_showDebug Bool
---@field DEBUG_openInVSCode Bool
---@field DEBUG_openInVSCodeBlocked Bool
AGenericTooltipControllerWithDebug = {}

---@param evt inkPointerEvent
---@return Bool
function AGenericTooltipControllerWithDebug:OnGlobalPress_DEBUG(evt) return end

---@param evt inkPointerEvent
---@return Bool
function AGenericTooltipControllerWithDebug:OnGlobalRelease_DEBUG(evt) return end

---@return Bool
function AGenericTooltipControllerWithDebug:OnInitialize() return end

---@return Bool
function AGenericTooltipControllerWithDebug:OnUninitialize() return end

function AGenericTooltipControllerWithDebug:DEBUG_UpdateDebugInfo() return end

---@param tdbID TweakDBID|string
function AGenericTooltipControllerWithDebug:OpenTweakDBRecordInVSCodeIfRequested(tdbID) return end

---@class AHintItemController : inkWidgetLogicController
---@field Icon inkImageWidgetReference
---@field UnavaliableText inkTextWidgetReference
---@field Root inkWidget
AHintItemController = {}

---@return Bool
function AHintItemController:OnInitialize() return end

---@param isEnabled Bool
function AHintItemController:Animate(isEnabled) return end

function AHintItemController:CacheAnimations() return end

---@param anim inkanimProxy
function AHintItemController:OnAnimFinished(anim) return end

---@param atlasPath CName|string
---@param iconName CName|string
function AHintItemController:SetIcon(atlasPath, iconName) return end

---@class AIAIBlackboardSerializableID
---@field id gameBlackboardSerializableID
AIAIBlackboardSerializableID = {}

---@return AIAIBlackboardSerializableID
function AIAIBlackboardSerializableID.new() return end

---@param props table
---@return AIAIBlackboardSerializableID
function AIAIBlackboardSerializableID.new(props) return end

---@class AIAIEvent : redEvent
---@field name CName
---@field timeToLive Float
AIAIEvent = {}

---@return AIAIEvent
function AIAIEvent.new() return end

---@param props table
---@return AIAIEvent
function AIAIEvent.new(props) return end

---@return Float
function AIAIEvent:GetTimeToLive() return end

---@param tag CName|string
---@return Bool
function AIAIEvent:HasTag(tag) return end

---@class AIAbsoluteZLimiter : AICoverSelectionParameters
AIAbsoluteZLimiter = {}

---@return AIAbsoluteZLimiter
function AIAbsoluteZLimiter.new() return end

---@param props table
---@return AIAbsoluteZLimiter
function AIAbsoluteZLimiter.new(props) return end

---@class AIActionBossDataDef : AIBlackboardDef
---@field excludedWaypointPosition gamebbScriptID_Variant
AIActionBossDataDef = {}

---@return AIActionBossDataDef
function AIActionBossDataDef.new() return end

---@param props table
---@return AIActionBossDataDef
function AIActionBossDataDef.new(props) return end

---@return Bool
function AIActionBossDataDef:AutoCreateInSystem() return end

---@class AIActionChecks : IScriptable
AIActionChecks = {}

---@return AIActionChecks
function AIActionChecks.new() return end

---@param props table
---@return AIActionChecks
function AIActionChecks.new(props) return end

---@param puppet ScriptedPuppet
---@param npcStates AIActionNPCStates
---@return Bool
function AIActionChecks.CheckAllNPCStateTypes(puppet, npcStates) return end

---@param playerPuppet ScriptedPuppet
---@param playerStates AIActionPlayerStates
---@return Bool
function AIActionChecks.CheckAllPlayerStateTypes(playerPuppet, playerStates) return end

---@param puppet ScriptedPuppet
---@param behaviorStates gamedataNPCBehaviorState[]
---@return Bool
function AIActionChecks.CheckBehaviorState(puppet, behaviorStates) return end

---@param puppet ScriptedPuppet
---@param defenseMode gamedataDefenseMode[]
---@return Bool
function AIActionChecks.CheckDefenseMode(puppet, defenseMode) return end

---@param puppet ScriptedPuppet
---@param highLevelStates gamedataNPCHighLevelState[]
---@return Bool
function AIActionChecks.CheckHighLevelState(puppet, highLevelStates) return end

---@param puppet ScriptedPuppet
---@param locomotionMode gamedataLocomotionMode[]
---@return Bool
function AIActionChecks.CheckLocomotionMode(puppet, locomotionMode) return end

---@param puppet ScriptedPuppet
---@param desiredTags CName[]|string[]
---@return Bool
function AIActionChecks.CheckMountedVehicleDesiredTags(puppet, desiredTags) return end

---@param puppet ScriptedPuppet
---@param npcStates AIActionNPCStates
---@return Bool
function AIActionChecks.CheckNPCState(puppet, npcStates) return end

---@param puppet ScriptedPuppet
---@param npcStates AIActionNPCStates
---@param checkAll Bool
---@return Bool
function AIActionChecks.CheckOwnerState(puppet, npcStates, checkAll) return end

---@param playerPuppet ScriptedPuppet
---@param bodyCarryStates gamePSMBodyCarrying[]
---@return Bool
function AIActionChecks.CheckPSMBodyCarryState(playerPuppet, bodyCarryStates) return end

---@param playerPuppet ScriptedPuppet
---@param combatStates gamePSMCombat[]
---@return Bool
function AIActionChecks.CheckPSMCombatState(playerPuppet, combatStates) return end

---@param playerPuppet ScriptedPuppet
---@param locomotionStates gamePSMLocomotionStates[]
---@return Bool
function AIActionChecks.CheckPSMLocomotionState(playerPuppet, locomotionStates) return end

---@param playerPuppet ScriptedPuppet
---@param meleeStates gamePSMMelee[]
---@return Bool
function AIActionChecks.CheckPSMMeleeState(playerPuppet, meleeStates) return end

---@param playerPuppet ScriptedPuppet
---@param upperBodyStates gamePSMUpperBodyStates[]
---@return Bool
function AIActionChecks.CheckPSMUpperBodyState(playerPuppet, upperBodyStates) return end

---@param playerPuppet ScriptedPuppet
---@param zoneStates gamePSMZones[]
---@return Bool
function AIActionChecks.CheckPSMZoneState(playerPuppet, zoneStates) return end

---@param playerPuppet ScriptedPuppet
---@param playerStates AIActionPlayerStates
---@return Bool
function AIActionChecks.CheckPlayerState(playerPuppet, playerStates) return end

---@param puppet ScriptedPuppet
---@param stanceStates gamedataNPCStanceState[]
---@return Bool
function AIActionChecks.CheckStanceState(puppet, stanceStates) return end

---@param target ScriptedPuppet
---@param targetStates AIActionTargetStates
---@param checkAll Bool
---@return Bool
function AIActionChecks.CheckTargetState(target, targetStates, checkAll) return end

---@param puppet ScriptedPuppet
---@param upperBodyStates gamedataNPCUpperBodyState[]
---@return Bool
function AIActionChecks.CheckUpperBodyState(puppet, upperBodyStates) return end

---@param playerPuppet ScriptedPuppet
---@param id gamebbScriptID_Int32
---@return Int32
function AIActionChecks.GetPSMBlackbordInt(playerPuppet, id) return end

---@class AIActionDataDef : AIBlackboardDef
---@field ownerMeleeAttackBlockedCount gamebbScriptID_Int32
---@field ownerMeleeAttackParriedCount gamebbScriptID_Int32
---@field ownerMeleeAttackDodgedCount gamebbScriptID_Int32
---@field ownerLastAttackTimeStamp gamebbScriptID_Float
---@field ownerLastAttackName gamebbScriptID_CName
---@field ownerInTumble gamebbScriptID_Bool
---@field ownerCurrentAnimVariationSet gamebbScriptID_Bool
---@field ownerLastAnimVariationAction gamebbScriptID_CName
---@field ownerLastAnimVariation gamebbScriptID_Int32
---@field ownerLastBlockAnimVariation gamebbScriptID_Int32
---@field ownerItemsToEquip gamebbScriptID_Variant
---@field ownerItemsUnequipped gamebbScriptID_Variant
---@field ownerItemsForceUnequipped gamebbScriptID_Variant
---@field ownerLastEquippedItems gamebbScriptID_Variant
---@field ownerLastUnequipTimestamp gamebbScriptID_Float
---@field ownerEquipItemTime gamebbScriptID_Float
---@field ownerEquipDuration gamebbScriptID_Float
---@field dropItemOnUnequip gamebbScriptID_Bool
---@field archetypeEffectorsApplied gamebbScriptID_Bool
---@field ownerTimeDilation gamebbScriptID_Float
---@field ownerGlobalTimeDilation gamebbScriptID_Float
---@field operationHasBeenProcessed gamebbScriptID_Bool
---@field weaponTrailInitialised gamebbScriptID_Bool
---@field weaponTrailAborted gamebbScriptID_Bool
---@field netrunner gamebbScriptID_Variant
---@field netrunnerProxy gamebbScriptID_Variant
---@field netrunnerTarget gamebbScriptID_Variant
---@field ignoreInCombatMoveCommand gamebbScriptID_Bool
---@field avoidLOSTimeStamp gamebbScriptID_Float
---@field attackBlocked gamebbScriptID_Bool
---@field attackParried gamebbScriptID_Bool
---@field lastGrenadeThrowTimestamp gamebbScriptID_Float
AIActionDataDef = {}

---@return AIActionDataDef
function AIActionDataDef.new() return end

---@param props table
---@return AIActionDataDef
function AIActionDataDef.new(props) return end

---@return Bool
function AIActionDataDef:AutoCreateInSystem() return end

---@param blackboard gameIBlackboard
function AIActionDataDef:Initialize(blackboard) return end

---@class AIActionHelper : IScriptable
AIActionHelper = {}

---@return AIActionHelper
function AIActionHelper.new() return end

---@param props table
---@return AIActionHelper
function AIActionHelper.new(props) return end

---@param entity entEntity
---@param actionName String
---@return Bool
function AIActionHelper.ActionDebugHelper(entity, actionName) return end

---@param actionNameCheck String
---@param actionName String
---@return Bool
function AIActionHelper.ActionDebugHelper(actionNameCheck, actionName) return end

---@param actionNameCheck String
---@param entity entEntity
---@param actionName String
---@return Bool
function AIActionHelper.ActionDebugHelper(actionNameCheck, entity, actionName) return end

---@param ownerPuppet ScriptedPuppet
function AIActionHelper.AnimationsLoadedSignal(ownerPuppet) return end

---@param weapon gameweaponObject
---@param effectName CName|string
function AIActionHelper.BreakWeaponEffectLoop(weapon, effectName) return end

---@param owner gameObject
---@param squadMembers entEntityID[]
function AIActionHelper.ChangeAttitudeToFriendlyAllSquad(owner, squadMembers) return end

---@param object gameObject
---@param ability gamedataGameplayAbility_Record
---@return Bool
function AIActionHelper.CheckAbility(object, ability) return end

---@param actionName String
---@return Bool
function AIActionHelper.CheckFlatheadStatPoolRequirements(actionName) return end

---@param context AIbehaviorScriptExecutionContext
---@param persistenceSource Uint32
---@param ignoreCombatTargetCommand Bool
function AIActionHelper.ClearCommandCombatTarget(context, persistenceSource, ignoreCombatTargetCommand) return end

---@param puppet ScriptedPuppet
function AIActionHelper.ClearItemsForceUnequipped(puppet) return end

---@param puppet ScriptedPuppet
function AIActionHelper.ClearItemsToEquip(puppet) return end

---@param puppet ScriptedPuppet
function AIActionHelper.ClearItemsToUnequip(puppet) return end

---@param puppet ScriptedPuppet
function AIActionHelper.ClearItemsUnequipped(puppet) return end

---@param puppet ScriptedPuppet
---@param doNotRepeat Bool
---@return Bool
function AIActionHelper.ClearWorkspotCommand(puppet, doNotRepeat) return end

---@param ownerPuppet ScriptedPuppet
function AIActionHelper.CombatQueriesInit(ownerPuppet) return end

---@param owner ScriptedPuppet
---@return gameIBlackboard
function AIActionHelper.GetActionBlackboard(owner) return end

---@param puppet ScriptedPuppet
---@param threat AITrackedLocation
---@return Bool
function AIActionHelper.GetActiveTopHostilePuppetThreat(puppet, threat) return end

---@param value gamedataAIAdditionalTraceType
---@return senseAdditionalTraceType
function AIActionHelper.GetAdditionalTraceTypeValueFromTweakEnum(value) return end

---@param itemID ItemID
---@return CName
function AIActionHelper.GetAnimWrapperNameBasedOnItemID(itemID) return end

---@param itemID ItemID
---@return CName
function AIActionHelper.GetAnimWrapperNameBasedOnItemTag(itemID) return end

---@param patternPackages gamedataAIPatternsPackage_Record[]
---@return Bool
function AIActionHelper.GetBaseShootingPatternPackages(patternPackages) return end

---@param postCombatStart Bool
---@return Float
function AIActionHelper.GetCallingAlliesToCombatDelay(postCombatStart) return end

---@param weapon gameItemObject
---@return CName
function AIActionHelper.GetCurrentStrongArmsTrailEffect(weapon) return end

---@param record gamedataMovementPolicy_Record
---@return Bool, Float, Float
function AIActionHelper.GetDistanceAndToleranceFromRingType(record) return end

---@param ringRecord gamedataAIRingType_Record
---@param condition gamedataMovementPolicy_Record
---@return Bool, Vector2
function AIActionHelper.GetDistanceRangeFromRingType(ringRecord, condition) return end

---@param ringRecord gamedataAIRingType_Record
---@param condition gamedataAIOptimalDistanceCond_Record
---@return Bool, Vector2
function AIActionHelper.GetDistanceRangeFromRingType(ringRecord, condition) return end

---@param ringRecord gamedataAIRingType_Record
---@return Bool, Vector2
function AIActionHelper.GetDistanceRangeFromRingType(ringRecord) return end

---@param owner gameObject
---@param items gameItemObject[]
---@return Bool
function AIActionHelper.GetItemsFromWeaponSlots(owner, items) return end

---@param weapon gameweaponObject
---@return gamedataTriggerMode
function AIActionHelper.GetLastRequestedTriggerMode(weapon) return end

---@param puppet ScriptedPuppet
---@return gamedataAIRingType_Record
function AIActionHelper.GetLatestActiveRingTypeRecord(puppet) return end

---@param object gameObject
---@return gamedataAIRingType_Record
function AIActionHelper.GetLatestActiveRingTypeRecordHelper(object) return end

---@param puppet ScriptedPuppet
---@return String
function AIActionHelper.GetReactionPresetGroup(puppet) return end

---@param owner ScriptedPuppet
---@return gameIBlackboard
function AIActionHelper.GetShootingBlackboard(owner) return end

---@param target gameObject
---@param delay Float
---@return Bool, Vector4
function AIActionHelper.GetTargetPositionFromPast(target, delay) return end

---@param target gameObject
---@param slotName CName|string
---@return Bool, Vector4
function AIActionHelper.GetTargetSlotPosition(target, slotName) return end

---@param target gameObject
---@param slotName CName|string
---@return Bool, WorldTransform
function AIActionHelper.GetTargetSlotTransform(target, slotName) return end

---@param owner ScriptedPuppet
---@return Bool
function AIActionHelper.HasCombatAICommand(owner) return end

---@param owner gameObject
---@param tag CName|string
---@return Bool
function AIActionHelper.HasEquippedWeaponWithTag(owner, tag) return end

---@param owner ScriptedPuppet
---@return Bool
function AIActionHelper.HasFollowerCombatAICommand(owner) return end

---@param owner ScriptedPuppet
---@param target gameObject
---@return Bool
function AIActionHelper.HasLostTarget(owner, target) return end

---@param owner ScriptedPuppet
---@return Bool
function AIActionHelper.HasWorkspotAICommand(owner) return end

---@param context AIbehaviorScriptExecutionContext
---@param commandName CName|string
---@return Bool
function AIActionHelper.IsCommandCombatTargetValid(context, commandName) return end

---@param self_ gameObject
---@param record gamedataAIActionCooldown_Record
---@return Bool
function AIActionHelper.IsCooldownActive(self_, record) return end

---@param puppet ScriptedPuppet
---@return Bool
function AIActionHelper.IsCurrentlyCrouching(puppet) return end

---@param puppet ScriptedPuppet
---@return Bool
function AIActionHelper.IsCurrentlyExposedInCover(puppet) return end

---@param puppet ScriptedPuppet
---@return Bool
function AIActionHelper.IsCurrentlyInCoverAttackAction(puppet) return end

---@param owner gameObject
---@return Bool
function AIActionHelper.IsInWorkspot(owner) return end

---@param commandName CName|string
---@return Bool
function AIActionHelper.IsMoveCommand(commandName) return end

---@param ownerPuppet ScriptedPuppet
---@param point Vector4
---@return Bool
function AIActionHelper.IsPointInRMA(ownerPuppet, point) return end

---@param ownerPuppet ScriptedPuppet
---@param point Vector4
---@return Bool
function AIActionHelper.IsPointInRestrictedMovementArea(ownerPuppet, point) return end

---@param weapon gameweaponObject
---@param effectName CName|string
function AIActionHelper.KillWeaponEffect(weapon, effectName) return end

---@param weapon gameweaponObject
---@param effectName CName|string
function AIActionHelper.PlayWeaponEffect(weapon, effectName) return end

---@param puppet ScriptedPuppet
function AIActionHelper.PreloadAllBaseAnimations(puppet) return end

---@param puppet ScriptedPuppet
---@param streamingContextName CName|string
---@param highPriority Bool
---@return Bool
function AIActionHelper.PreloadAnimations(puppet, streamingContextName, highPriority) return end

---@param puppet ScriptedPuppet
---@param melee Bool
---@return Bool
function AIActionHelper.PreloadBaseAnimations(puppet, melee) return end

---@param puppet ScriptedPuppet
---@param melee Bool
---@return Bool
function AIActionHelper.PreloadCoreAnimations(puppet, melee) return end

---@param owner gameObject
---@return gameDelayID
function AIActionHelper.QueueNearbyCombatNotification(owner) return end

---@param puppet ScriptedPuppet
function AIActionHelper.QueuePreloadBaseAnimationsEvent(puppet) return end

---@param puppet ScriptedPuppet
function AIActionHelper.QueuePreloadCoreAnimationsEvent(puppet) return end

---@param owner gameObject
---@param postCombatStart Bool
---@return gameDelayID
function AIActionHelper.QueuePullSquadSync(owner, postCombatStart) return end

---@param owner gameObject
---@param postCombatStart Bool
function AIActionHelper.QueueSecuritySystemCombatNotification(owner, postCombatStart) return end

---@param owner gameObject
---@param itemRecord gamedataItem_Record
---@param animFeatureName CName|string
---@param equipped Bool
function AIActionHelper.SendItemHandling(owner, itemRecord, animFeatureName, equipped) return end

---@param owner gameObject
---@param active Bool
function AIActionHelper.SetActionExclusivity(owner, active) return end

---@param context AIbehaviorScriptExecutionContext
---@param target gameObject
---@param isPersistant Bool
---@param persistenceSource Uint32
---@return Bool
function AIActionHelper.SetCommandCombatTarget(context, target, isPersistant, persistenceSource) return end

---@param owner gameObject
function AIActionHelper.SetFriendlyTargetAllSquadMembers(owner) return end

---@param puppet ScriptedPuppet
---@param itemsToEquip NPCItemToEquip[]
function AIActionHelper.SetItemsEquipData(puppet, itemsToEquip) return end

---@param puppet ScriptedPuppet
---@param itemsToUnequip NPCItemToEquip[]
---@param dropItem Bool
function AIActionHelper.SetItemsUnequipData(puppet, itemsToUnequip, dropItem) return end

---@param weaponOwner gameObject
---@param weapon gameweaponObject
---@param targetPosition Vector4
---@return Bool
function AIActionHelper.ShouldShootDirectlyAtTarget(weaponOwner, weapon, targetPosition) return end

---@param self_ gameObject
---@param cooldownName CName|string
---@param duration Float
---@return Int32
function AIActionHelper.StartCooldown(self_, cooldownName, duration) return end

---@param self_ gameObject
---@param record gamedataAIActionCooldown_Record
---@return Int32
function AIActionHelper.StartCooldown(self_, record) return end

---@param owner gameObject
function AIActionHelper.TargetAllSquadMembers(owner) return end

---@param owner ScriptedPuppet
---@param target gameObject
---@return Bool
function AIActionHelper.TryChangingAttitudeToHostile(owner, target) return end

---@param owner ScriptedPuppet
---@param target gameObject
---@return Bool
function AIActionHelper.TryStartCombatWithTarget(owner, target) return end

---@param owner gameObject
---@param linkedStatusEffect LinkedStatusEffect
function AIActionHelper.UpdateLinkedStatusEffects(owner, linkedStatusEffect) return end

---@param weapon gameweaponObject
---@param triggerMode gamedataTriggerMode
---@return Bool
function AIActionHelper.WeaponHasTriggerMode(weapon, triggerMode) return end

---@param weapon gameweaponObject
---@param weaponRecord gamedataWeaponItem_Record
---@param triggerMode gamedataTriggerMode
---@return Bool
function AIActionHelper.WeaponHasTriggerMode(weapon, weaponRecord, triggerMode) return end

---@param weapon gameweaponObject
---@param weaponRecord gamedataWeaponItem_Record
---@param triggerMode gamedataTriggerMode_Record
---@return Bool
function AIActionHelper.WeaponHasTriggerMode(weapon, weaponRecord, triggerMode) return end

---@param weapon gameweaponObject
---@param triggerMode gamedataTriggerMode_Record
---@return Bool
function AIActionHelper.WeaponHasTriggerMode(weapon, triggerMode) return end

---@param weapon gameweaponObject
---@param weaponRecord gamedataWeaponItem_Record
---@param triggerModes gamedataTriggerMode_Record[]
---@return Bool
function AIActionHelper.WeaponHasTriggerModes(weapon, weaponRecord, triggerModes) return end

---@class AIActionHelperTask : AIbehaviortaskScript
---@field actionTweakIDMapping AIArgumentMapping
---@field actionStringName String
---@field initialized Bool
---@field actionName CName
---@field actionID TweakDBID
AIActionHelperTask = {}

---@return TweakDBID
function AIActionHelperTask:GetActionID() return end

---@return AIactionParamsPackageTypes
function AIActionHelperTask:GetActionPackageType() return end

---@param context AIbehaviorScriptExecutionContext
---@return String
function AIActionHelperTask:GetActionStringName(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIActionHelperTask:Initialize(context) return end

---@class AIActionLookat : IScriptable
AIActionLookat = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionLookAtData_Record
---@return entLookAtAddEvent
function AIActionLookat.Activate(context, record) return end

---@param owner gameObject
---@param lookAtAddEvents entLookAtAddEvent[]
function AIActionLookat.Deactivate(owner, lookAtAddEvents) return end

---@param lookatPresetRecord gamedataLookAtPreset_Record
---@param lookAtParts animLookAtPartRequest[]
function AIActionLookat.GetLookatPartsRequests(lookatPresetRecord, lookAtParts) return end

---@class AIActionLookatParams
---@field useLookat Bool
---@field useLeftHand Bool
---@field useRightHand Bool
---@field attachRightHandtoLeftHand Bool
---@field attachLeftHandtoRightHand Bool
---@field slotName CName
---@field lookatStyle animLookAtStyle
---@field hasOutTransition Bool
---@field outTransitionStyle animLookAtStyle
---@field softLimitDegrees animLookAtLimitDegreesType
---@field hardLimitDegrees animLookAtLimitDegreesType
---@field hardLimitDistance animLookAtLimitDistanceType
---@field backLimitDegrees animLookAtLimitDegreesType
---@field additionalParts animLookAtPartRequest[]
AIActionLookatParams = {}

---@return AIActionLookatParams
function AIActionLookatParams.new() return end

---@param props table
---@return AIActionLookatParams
function AIActionLookatParams.new(props) return end

---@class AIActionMovePolicy : IScriptable
AIActionMovePolicy = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataMovementPolicy_Record
---@return movePolicies
function AIActionMovePolicy.Add(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AIActionMovePolicy.CheckCondition(context, condition) return end

---@param owner ScriptedPuppet
---@param target gameObject
---@param trackingMode gamedataTrackingMode
---@return entIPositionProvider
function AIActionMovePolicy.GetTargetPositionProvider(owner, target, trackingMode) return end

---@param context AIbehaviorScriptExecutionContext
---@return movePolicies
function AIActionMovePolicy.Pop(context) return end

---@class AIActionNPCStates
---@field highLevelStates gamedataNPCHighLevelState[]
---@field upperBodyStates gamedataNPCUpperBodyState[]
---@field stanceStates gamedataNPCStanceState[]
---@field behaviorStates gamedataNPCBehaviorState[]
---@field defenseMode gamedataDefenseMode[]
---@field locomotionMode gamedataLocomotionMode[]
AIActionNPCStates = {}

---@return AIActionNPCStates
function AIActionNPCStates.new() return end

---@param props table
---@return AIActionNPCStates
function AIActionNPCStates.new(props) return end

---@class AIActionParams : IScriptable
AIActionParams = {}

---@return AIActionParams
function AIActionParams.new() return end

---@param props table
---@return AIActionParams
function AIActionParams.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param puppet ScriptedPuppet
---@param actionStringName String
---@param actionPackageType AIactionParamsPackageTypes
---@return TweakDBID, CName
function AIActionParams.CreateActionID(context, puppet, actionStringName, actionPackageType) return end

---@param nameParam CName|string
---@return gamedataNPCBehaviorState
function AIActionParams.GetBehaviorStateFromName(nameParam) return end

---@param nameParam CName|string
---@return gamedataDefenseMode
function AIActionParams.GetDefenseModeFromName(nameParam) return end

---@param nameParam CName|string
---@return gamedataNPCHighLevelState
function AIActionParams.GetHighLevelStateFromName(nameParam) return end

---@param nameParam CName|string
---@return gamedataLocomotionMode
function AIActionParams.GetLocomotionModeFromName(nameParam) return end

---@param ownerStates CName[]|string[]
---@return AIActionNPCStates
function AIActionParams.GetOwnerStatesFromArray(ownerStates) return end

---@param nameParam CName|string
---@return Bool, gamePSMBodyCarrying
function AIActionParams.GetPSMBodyCarryStateFromName(nameParam) return end

---@param nameParam CName|string
---@return Bool, gamePSMCombat
function AIActionParams.GetPSMCombatStateFromName(nameParam) return end

---@param nameParam CName|string
---@return Bool, gamePSMLocomotionStates
function AIActionParams.GetPSMLocomotionStateFromName(nameParam) return end

---@param nameParam CName|string
---@return Bool, gamePSMMelee
function AIActionParams.GetPSMMeleeStateFromName(nameParam) return end

---@param nameParam CName|string
---@return Bool, gamePSMUpperBodyStates
function AIActionParams.GetPSMUpperBodyStateFromName(nameParam) return end

---@param nameParam CName|string
---@return Bool, gamePSMZones
function AIActionParams.GetPSMZoneStateFromName(nameParam) return end

---@param nameParam CName|string
---@return gamedataNPCStanceState
function AIActionParams.GetStanceStateFromName(nameParam) return end

---@param targetStates CName[]|string[]
---@param target gameObject
---@return AIActionTargetStates
function AIActionParams.GetTargetStatesFromArray(targetStates, target) return end

---@param targetStates CName[]|string[]
---@return AIActionTargetStates
function AIActionParams.GetTargetStatesFromArray(targetStates) return end

---@param nameParam CName|string
---@return gamedataNPCUpperBodyState
function AIActionParams.GetUpperBodyStateFromName(nameParam) return end

---@param npcStates AIActionNPCStates
---@param stateName CName|string
function AIActionParams.PushBackNPCState(npcStates, stateName) return end

---@param playerStates AIActionPlayerStates
---@param stateName CName|string
function AIActionParams.PushBackPlayerState(playerStates, stateName) return end

---@param actionID TweakDBID|string
---@return Bool
function AIActionParams.TempGetIsValid(actionID) return end

---@class AIActionPlayerStates
---@field locomotionStates gamePSMLocomotionStates[]
---@field upperBodyStates gamePSMUpperBodyStates[]
---@field meleeStates gamePSMMelee[]
---@field zoneStates gamePSMZones[]
---@field bodyCarryStates gamePSMBodyCarrying[]
---@field combatStates gamePSMCombat[]
AIActionPlayerStates = {}

---@return AIActionPlayerStates
function AIActionPlayerStates.new() return end

---@param props table
---@return AIActionPlayerStates
function AIActionPlayerStates.new(props) return end

---@class AIActionSlideParams
---@field distance Float
---@field directionAngle Float
---@field duration Float
---@field offset Float
---@field slideToTarget Bool
---@field debugDrawSlideLines Bool
AIActionSlideParams = {}

---@return AIActionSlideParams
function AIActionSlideParams.new() return end

---@param props table
---@return AIActionSlideParams
function AIActionSlideParams.new(props) return end

---@class AIActionSpot : AISmartSpot
---@field resource workWorkspotResource
---@field ActorBodytypeE3 AISocketsForRig
---@field masterNodeRef NodeRef
---@field enabledWhenMasterOccupied Bool
---@field snapToGround Bool
---@field useClippingSpace Bool
---@field clippingSpaceOrientation Float
---@field clippingSpaceRange Float
AIActionSpot = {}

---@return AIActionSpot
function AIActionSpot.new() return end

---@param props table
---@return AIActionSpot
function AIActionSpot.new(props) return end

---@class AIActionSpotInstance : AISmartSpotInstance
AIActionSpotInstance = {}

---@return AIActionSpotInstance
function AIActionSpotInstance.new() return end

---@param props table
---@return AIActionSpotInstance
function AIActionSpotInstance.new(props) return end

---@class AIActionTarget : IScriptable
AIActionTarget = {}

---@param owner ScriptedPuppet
---@param ownerPos Vector4
---@param targetTrackerComponent AITargetTrackerComponent
---@param newTargetObject gameObject
---@param threat gameObject
---@param timeSinceTargetChange Float
---@param currentTime Float
---@return Float
function AIActionTarget.BossThreatCalculation(owner, ownerPos, targetTrackerComponent, newTargetObject, threat, timeSinceTargetChange, currentTime) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@param predictionTime Float
---@return Bool, gameObject, Vector4, Uint64
function AIActionTarget.Get(context, record, predictionTime) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@param getSlotPosition Bool
---@param predictionTime Float
---@return Bool, gameObject, Vector4
function AIActionTarget.Get(context, record, getSlotPosition, predictionTime) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@param getSlotPosition Bool
---@param predictionTime Float
---@return Bool, gameObject, Vector4, Uint64
function AIActionTarget.Get(context, record, getSlotPosition, predictionTime) return end

---@param smi AISquadScriptInterface
---@param pos Vector4
---@return entEntityID
function AIActionTarget.GetClosestMemberId(smi, pos) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@return Bool, Uint64
function AIActionTarget.GetCoverID(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@return Bool, Uint64, Vector4
function AIActionTarget.GetCoverID(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param coverID Uint64
---@return Bool, Vector4
function AIActionTarget.GetCoverPosition(context, coverID) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool, Uint64, Vector4
function AIActionTarget.GetCurrentCoverID(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool, Uint64
function AIActionTarget.GetCurrentCoverID(context) return end

---@param ownerPos Vector4
---@param threat gameObject
---@param positionOfRoot Bool
---@return Float, Float
function AIActionTarget.GetDistanceToThreat(ownerPos, threat, positionOfRoot) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@param getSlotPosition Bool
---@param predictionTime Float
---@return Bool, gameObject, Vector4, Uint64
function AIActionTarget.GetLegacy(context, record, getSlotPosition, predictionTime) return end

---@param context AIbehaviorScriptExecutionContext
---@return gameObject
function AIActionTarget.GetNetrunnerProxy(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@return Bool, gameObject
function AIActionTarget.GetObject(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@return Bool, gameObject
function AIActionTarget.GetObjectLegacy(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@param getSlotPosition Bool
---@param predictionTime Float
---@return Bool, Vector4
function AIActionTarget.GetPosition(context, record, getSlotPosition, predictionTime) return end

---@param puppet ScriptedPuppet
---@param threat gameObject
---@return Float
function AIActionTarget.GetThreatAccessibilityFromCoverModifier(puppet, threat) return end

---@param targetTrackerComponent AITargetTrackerComponent
---@param puppet ScriptedPuppet
---@param threat gameObject
---@return Float
function AIActionTarget.GetThreatAttackersModifier(targetTrackerComponent, puppet, threat) return end

---@param targetTrackerComponent AITargetTrackerComponent
---@param puppet ScriptedPuppet
---@param threat gameObject
---@param distance Float
---@param currentTime Float
---@return Float
function AIActionTarget.GetThreatDamageModifier(targetTrackerComponent, puppet, threat, distance, currentTime) return end

---@param targetTrackerComponent AITargetTrackerComponent
---@param distance Float
---@return Float
function AIActionTarget.GetThreatDistanceModifier(targetTrackerComponent, distance) return end

---@param targetTrackerComponent AITargetTrackerComponent
---@param threat gameObject
---@param currentTarget gameObject
---@param timeSinceTargetChange Float
---@return Float
function AIActionTarget.GetThreatHisteresisModifier(targetTrackerComponent, threat, currentTarget, timeSinceTargetChange) return end

---@param puppet ScriptedPuppet
---@param threat gameObject
---@return Float
function AIActionTarget.GetThreatLastVisibilityModifier(puppet, threat) return end

---@param zDiff Float
---@return Float
function AIActionTarget.GetThreatZDiffModifier(zDiff) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@return Bool, vehicleBaseObject
function AIActionTarget.GetVehicleObject(context, record) return end

---@param owner gameObject
---@return Bool
function AIActionTarget.HasWeaponInInventory(owner) return end

---@param ownerPos Vector4
---@param threat gameObject
---@return Bool
function AIActionTarget.IsThreatCloseOrVisibleByPlayer(ownerPos, threat) return end

---@param owner ScriptedPuppet
---@param ownerPos Vector4
---@param targetTrackerComponent AITargetTrackerComponent
---@param newTargetObject gameObject
---@param threat gameObject
---@param timeSinceTargetChange Float
---@param currentTime Float
---@return Float
function AIActionTarget.MadnessThreatCalculation(owner, ownerPos, targetTrackerComponent, newTargetObject, threat, timeSinceTargetChange, currentTime) return end

---@param owner ScriptedPuppet
---@param ownerPos Vector4
---@param targetTrackerComponent AITargetTrackerComponent
---@param newTargetObject gameObject
---@param threat gameObject
---@param timeSinceTargetChange Float
---@param currentTime Float
---@return Float
function AIActionTarget.RegularThreatCalculation(owner, ownerPos, targetTrackerComponent, newTargetObject, threat, timeSinceTargetChange, currentTime) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAIActionTarget_Record
---@param entity entEntity
---@param pos Vector4
---@param coverID Uint32
---@return Bool
function AIActionTarget.Set(context, record, entity, pos, coverID) return end

---@param puppet NPCPuppet
---@param newTargetObject gameObject
---@param timeSinceTargetChange Float
function AIActionTarget.UpdateThreatsValue(puppet, newTargetObject, timeSinceTargetChange) return end

---@class AIActionTargetStates
---@field npcStates AIActionNPCStates
---@field playerStates AIActionPlayerStates
AIActionTargetStates = {}

---@return AIActionTargetStates
function AIActionTargetStates.new() return end

---@param props table
---@return AIActionTargetStates
function AIActionTargetStates.new(props) return end

---@class AIActionTransactionSystem : IScriptable
AIActionTransactionSystem = {}

---@param puppet ScriptedPuppet
---@param equipmentGroupName CName|string
---@param powerLevel Int32
---@return gamedataNPCEquipmentItem_Record[]
function AIActionTransactionSystem.CalculateEquipmentItems(puppet, equipmentGroupName, powerLevel) return end

---@param puppet ScriptedPuppet
---@param equipmentGroupRecord gamedataNPCEquipmentGroup_Record
---@param powerLevel Int32
---@return gamedataNPCEquipmentItem_Record[]
function AIActionTransactionSystem.CalculateEquipmentItems(puppet, equipmentGroupRecord, powerLevel) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIItemCond_Record
---@return Bool
function AIActionTransactionSystem.CheckEquipmentGroupForEquipment(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param equipmentGroup CName|string
---@return Bool
function AIActionTransactionSystem.CheckSlotsForEquipment(context, equipmentGroup) return end

---@param powerLevel Int32
---@param seed Uint32
---@param itemPool gamedataNPCEquipmentItemPool_Record
---@return gamedataNPCEquipmentItem_Record[]
function AIActionTransactionSystem.ChooseSingleItemsSetFromPool(powerLevel, seed, itemPool) return end

---@param weaponItemID ItemID
---@param condition gamedataAIItemCond_Record
---@param evolution gamedataWeaponEvolution_Record
---@return Bool
function AIActionTransactionSystem.DoesItemMeetRequirements(weaponItemID, condition, evolution) return end

---@param context AIbehaviorScriptExecutionContext
---@param characterRecord gamedataCharacter_Record
---@param checkForUnequip Bool
---@param itemsList NPCItemToEquip[]
---@return Bool
function AIActionTransactionSystem.GetDefaultEquipment(context, characterRecord, checkForUnequip, itemsList) return end

---@param context AIbehaviorScriptExecutionContext
---@param checkPrimaryEquipment Bool
---@param itemsList NPCItemToEquip[]
---@return Bool
function AIActionTransactionSystem.GetEquipment(context, checkPrimaryEquipment, itemsList) return end

---@param context AIbehaviorScriptExecutionContext
---@param checkPrimaryEquipment Bool
---@param checkForUnequip Bool
---@param itemsList NPCItemToEquip[]
---@return Bool
function AIActionTransactionSystem.GetEquipmentWithCondition(context, checkPrimaryEquipment, checkForUnequip, itemsList) return end

---@param owner gameObject
---@param itemTag CName|string
---@return Bool, ItemID
function AIActionTransactionSystem.GetFirstItemID(owner, itemTag) return end

---@param owner gameObject
---@param itemType gamedataItemType_Record
---@param itemTag CName|string
---@return Bool, ItemID
function AIActionTransactionSystem.GetFirstItemID(owner, itemType, itemTag) return end

---@param owner gameObject
---@param itemCategory gamedataItemCategory_Record
---@param itemTag CName|string
---@return Bool, ItemID
function AIActionTransactionSystem.GetFirstItemID(owner, itemCategory, itemTag) return end

---@param obj ScriptedPuppet
---@param itemRecord gamedataItem_Record
---@param onBodySlotID TweakDBID|string
---@return Bool, ItemID
function AIActionTransactionSystem.GetItemID(obj, itemRecord, onBodySlotID) return end

---@param itemRecord gamedataItem_Record
---@return Bool, ItemID
function AIActionTransactionSystem.GetItemIDFromRecord(itemRecord) return end

---@param owner ScriptedPuppet
---@param itemID ItemID
---@return Bool, TweakDBID
function AIActionTransactionSystem.GetItemsBodySlot(owner, itemID) return end

---@param obj ScriptedPuppet
---@param itemsToEquip NPCItemToEquip[]
---@return Bool
function AIActionTransactionSystem.GetOnBodyEquipment(obj, itemsToEquip) return end

---@param obj ScriptedPuppet
---@param outEquipmentRecords gamedataNPCEquipmentItem_Record[]
---@return Bool
function AIActionTransactionSystem.GetOnBodyEquipmentRecords(obj, outEquipmentRecords) return end

---@param owner gameObject
---@param slotID TweakDBID|string
---@return Bool
function AIActionTransactionSystem.IsSlotEmptySpawningItem(owner, slotID) return end

---@param obj ScriptedPuppet
---@param equipmentGroup CName|string
---@return Bool
function AIActionTransactionSystem.ShouldPerformEquipmentCheck(obj, equipmentGroup) return end

---@class AIAddedAsHostileThreat : AIAIEvent
---@field threateningEntity AITargetTrackerComponent
---@field threateningEntityCanTriggersCombat Bool
AIAddedAsHostileThreat = {}

---@return AIAddedAsHostileThreat
function AIAddedAsHostileThreat.new() return end

---@param props table
---@return AIAddedAsHostileThreat
function AIAddedAsHostileThreat.new(props) return end

---@class AIAdjustableStreamingRangeTarget : gameObject
---@field minStreamingDistance Float
AIAdjustableStreamingRangeTarget = {}

---@return AIAdjustableStreamingRangeTarget
function AIAdjustableStreamingRangeTarget.new() return end

---@param props table
---@return AIAdjustableStreamingRangeTarget
function AIAdjustableStreamingRangeTarget.new(props) return end

---@class AIAggressiveReactionPresetCondition : AIbehaviorconditionScript
AIAggressiveReactionPresetCondition = {}

---@return AIAggressiveReactionPresetCondition
function AIAggressiveReactionPresetCondition.new() return end

---@param props table
---@return AIAggressiveReactionPresetCondition
function AIAggressiveReactionPresetCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIAggressiveReactionPresetCondition:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AIAggressiveReactionPresetCondition:Check(context) return end

---@class AIAimAtTargetCommand : AICombatRelatedCommand
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
AIAimAtTargetCommand = {}

---@return AIAimAtTargetCommand
function AIAimAtTargetCommand.new() return end

---@param props table
---@return AIAimAtTargetCommand
function AIAimAtTargetCommand.new(props) return end

---@class AIAimAtTargetCommandParams : questScriptedAICommandParams
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
AIAimAtTargetCommandParams = {}

---@return AIAimAtTargetCommandParams
function AIAimAtTargetCommandParams.new() return end

---@param props table
---@return AIAimAtTargetCommandParams
function AIAimAtTargetCommandParams.new(props) return end

---@return AICommand
function AIAimAtTargetCommandParams:CreateCommand() return end

---@return String
function AIAimAtTargetCommandParams:GetCommandName() return end

---@class AIAlertedPatrolDef : AIBlackboardDef
---@field patrolPathOverride gamebbScriptID_Variant
---@field sprint gamebbScriptID_Bool
---@field selectedPath gamebbScriptID_Variant
---@field closestPathPoint gamebbScriptID_Vector4
---@field workspotData gamebbScriptID_Variant
---@field workspotEntryPosition gamebbScriptID_Vector4
---@field workspotExitPosition gamebbScriptID_Vector4
---@field patrolAction gamebbScriptID_Variant
---@field forceAlerted gamebbScriptID_Bool
---@field patrolInProgress gamebbScriptID_Bool
AIAlertedPatrolDef = {}

---@return AIAlertedPatrolDef
function AIAlertedPatrolDef.new() return end

---@param props table
---@return AIAlertedPatrolDef
function AIAlertedPatrolDef.new(props) return end

---@class AIAlertedStateDelegate : AIbehaviorScriptBehaviorDelegate
---@field attackInstigatorPosition Vector4
AIAlertedStateDelegate = {}

---@return AIAlertedStateDelegate
function AIAlertedStateDelegate.new() return end

---@param props table
---@return AIAlertedStateDelegate
function AIAlertedStateDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAlertedStateDelegate:DoLowerWeapon(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAlertedStateDelegate:DoSetExplosionInstigatorPositionAsStimSource(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAlertedStateDelegate:DoSetRandomAimPointLeft(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAlertedStateDelegate:DoSetRandomAimPointRight(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param xOffset Float
---@param yOffset Float
---@param zOffset Float
---@return Vector4
function AIAlertedStateDelegate:GetPositionAroundInstigator(context, xOffset, yOffset, zOffset) return end

---@class AIAngleDistanceCoverSelection : AICoverSelectionParameters
AIAngleDistanceCoverSelection = {}

---@return AIAngleDistanceCoverSelection
function AIAngleDistanceCoverSelection.new() return end

---@param props table
---@return AIAngleDistanceCoverSelection
function AIAngleDistanceCoverSelection.new(props) return end

---@class AIAngleDistanceCoverSelectionRuntimeData : AICoverSelectionRuntimeData
AIAngleDistanceCoverSelectionRuntimeData = {}

---@return AIAngleDistanceCoverSelectionRuntimeData
function AIAngleDistanceCoverSelectionRuntimeData.new() return end

---@param props table
---@return AIAngleDistanceCoverSelectionRuntimeData
function AIAngleDistanceCoverSelectionRuntimeData.new(props) return end

---@class AIAnimMoveOnSplineCommand : AIMoveCommand
---@field spline NodeRef
---@field useStart Bool
---@field useStop Bool
---@field controllerSetupName CName
---@field blendTime Float
---@field globalInBlendTime Float
---@field globalOutBlendTime Float
---@field turnCharacterToMatchVelocity Bool
---@field customStartAnimationName CName
---@field customMainAnimationName CName
---@field customStopAnimationName CName
---@field startSnapToTerrain Bool
---@field mainSnapToTerrain Bool
---@field stopSnapToTerrain Bool
---@field startSnapToTerrainBlendTime Float
---@field stopSnapToTerrainBlendTime Float
AIAnimMoveOnSplineCommand = {}

---@return AIAnimMoveOnSplineCommand
function AIAnimMoveOnSplineCommand.new() return end

---@param props table
---@return AIAnimMoveOnSplineCommand
function AIAnimMoveOnSplineCommand.new(props) return end

---@class AIAnimationTask : AIbehaviortaskScript
---@field record TweakDBID
---@field animVariation AIArgumentMapping
---@field actionRecord gamedataAIAction_Record
---@field actionDebugName String
---@field animVariationValue Int32
---@field phaseRecord gamedataAIActionPhase_Record
---@field actionPhase EAIActionPhase
---@field phaseActivationTime Float
---@field phaseDuration Float
AIAnimationTask = {}

---@return AIAnimationTask
function AIAnimationTask.new() return end

---@param props table
---@return AIAnimationTask
function AIAnimationTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIAnimationTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIAnimationTask:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return String
function AIAnimationTask:GetDescription(context) return end

---@return Float
function AIAnimationTask:GetPhaseDuration() return end

---@param context AIbehaviorScriptExecutionContext
---@param animData gamedataAIActionAnimData_Record
function AIAnimationTask:SendAnimData(context, animData) return end

---@param context AIbehaviorScriptExecutionContext
---@param newPhase EAIActionPhase
function AIAnimationTask:StartPhase(context, newPhase) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIAnimationTask:Update(context) return end

---@class AIApproachingAreaEvent : AIAIEvent
---@field isApproachCancellation Bool
---@field areaComponent gameStaticAreaShapeComponent
---@field responseTarget entEntity
AIApproachingAreaEvent = {}

---@return AIApproachingAreaEvent
function AIApproachingAreaEvent.new() return end

---@param props table
---@return AIApproachingAreaEvent
function AIApproachingAreaEvent.new(props) return end

---@class AIApproachingAreaResponseEvent : redEvent
---@field sender entEntity
---@field areaComponent gameStaticAreaShapeComponent
---@field isPassingThrough Bool
AIApproachingAreaResponseEvent = {}

---@return AIApproachingAreaResponseEvent
function AIApproachingAreaResponseEvent.new() return end

---@param props table
---@return AIApproachingAreaResponseEvent
function AIApproachingAreaResponseEvent.new(props) return end

---@class AIArchetype : CResource
---@field behaviorDefinition AIbehaviorParameterizedBehavior
---@field movementParameters moveMovementParameters[]
AIArchetype = {}

---@return AIArchetype
function AIArchetype.new() return end

---@param props table
---@return AIArchetype
function AIArchetype.new(props) return end

---@class AIArchetypeSet : CResource
---@field archetypeResources AIArchetypeSetEntry[]
AIArchetypeSet = {}

---@return AIArchetypeSet
function AIArchetypeSet.new() return end

---@param props table
---@return AIArchetypeSet
function AIArchetypeSet.new(props) return end

---@class AIArchetypeSetEntry
---@field name CName
---@field resource AIArchetype
AIArchetypeSetEntry = {}

---@return AIArchetypeSetEntry
function AIArchetypeSetEntry.new() return end

---@param props table
---@return AIArchetypeSetEntry
function AIArchetypeSetEntry.new(props) return end

---@class AIArgumentBoolValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue Bool
AIArgumentBoolValue = {}

---@return AIArgumentBoolValue
function AIArgumentBoolValue.new() return end

---@param props table
---@return AIArgumentBoolValue
function AIArgumentBoolValue.new(props) return end

---@class AIArgumentCNameValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue CName
AIArgumentCNameValue = {}

---@return AIArgumentCNameValue
function AIArgumentCNameValue.new() return end

---@param props table
---@return AIArgumentCNameValue
function AIArgumentCNameValue.new(props) return end

---@class AIArgumentDefinition : ISerializable
---@field name CName
---@field isPersistent Bool
---@field behaviorCallbackName CName
AIArgumentDefinition = {}

---@class AIArgumentEnumValue : AIArgumentDefinition
---@field type AIArgumentType
---@field enumClass CName
---@field defaultValue Int64
AIArgumentEnumValue = {}

---@return AIArgumentEnumValue
function AIArgumentEnumValue.new() return end

---@param props table
---@return AIArgumentEnumValue
function AIArgumentEnumValue.new(props) return end

---@class AIArgumentFloatValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue Float
AIArgumentFloatValue = {}

---@return AIArgumentFloatValue
function AIArgumentFloatValue.new() return end

---@param props table
---@return AIArgumentFloatValue
function AIArgumentFloatValue.new(props) return end

---@class AIArgumentGlobalNodeIdValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue worldGlobalNodeID
AIArgumentGlobalNodeIdValue = {}

---@return AIArgumentGlobalNodeIdValue
function AIArgumentGlobalNodeIdValue.new() return end

---@param props table
---@return AIArgumentGlobalNodeIdValue
function AIArgumentGlobalNodeIdValue.new(props) return end

---@class AIArgumentInstancePS : ISerializable
---@field name CName
AIArgumentInstancePS = {}

---@class AIArgumentIntValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue Int32
AIArgumentIntValue = {}

---@return AIArgumentIntValue
function AIArgumentIntValue.new() return end

---@param props table
---@return AIArgumentIntValue
function AIArgumentIntValue.new(props) return end

---@class AIArgumentMapping : IScriptable
---@field type AIArgumentType
---@field parameterizationType AIParameterizationType
---@field defaultValue Variant
---@field prefixValue AIArgumentMapping
---@field customTypeName CName
AIArgumentMapping = {}

---@return AIArgumentMapping
function AIArgumentMapping.new() return end

---@param props table
---@return AIArgumentMapping
function AIArgumentMapping.new(props) return end

---@return CName
function AIArgumentMapping:GetArgumentName() return end

---@return AIArgumentType
function AIArgumentMapping:GetArgumentType() return end

---@return AIParameterizationType
function AIArgumentMapping:GetParameterizationType() return end

---@class AIArgumentNodeRefValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue NodeRef
AIArgumentNodeRefValue = {}

---@return AIArgumentNodeRefValue
function AIArgumentNodeRefValue.new() return end

---@param props table
---@return AIArgumentNodeRefValue
function AIArgumentNodeRefValue.new(props) return end

---@class AIArgumentObjectValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue gameObject
AIArgumentObjectValue = {}

---@return AIArgumentObjectValue
function AIArgumentObjectValue.new() return end

---@param props table
---@return AIArgumentObjectValue
function AIArgumentObjectValue.new(props) return end

---@class AIArgumentOverrideWrapper
---@field name CName
---@field type AIArgumentType
---@field definition AIArgumentDefinition
AIArgumentOverrideWrapper = {}

---@return AIArgumentOverrideWrapper
function AIArgumentOverrideWrapper.new() return end

---@param props table
---@return AIArgumentOverrideWrapper
function AIArgumentOverrideWrapper.new(props) return end

---@class AIArgumentPuppetRefValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue gameEntityReference
AIArgumentPuppetRefValue = {}

---@return AIArgumentPuppetRefValue
function AIArgumentPuppetRefValue.new() return end

---@param props table
---@return AIArgumentPuppetRefValue
function AIArgumentPuppetRefValue.new(props) return end

---@class AIArgumentReference : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue Variant
---@field rttiClassName CName
AIArgumentReference = {}

---@return AIArgumentReference
function AIArgumentReference.new() return end

---@param props table
---@return AIArgumentReference
function AIArgumentReference.new(props) return end

---@class AIArgumentSerializableValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue ISerializable
AIArgumentSerializableValue = {}

---@return AIArgumentSerializableValue
function AIArgumentSerializableValue.new() return end

---@param props table
---@return AIArgumentSerializableValue
function AIArgumentSerializableValue.new(props) return end

---@class AIArgumentTreeRefValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue AIbehaviorParameterizedBehavior
AIArgumentTreeRefValue = {}

---@return AIArgumentTreeRefValue
function AIArgumentTreeRefValue.new() return end

---@param props table
---@return AIArgumentTreeRefValue
function AIArgumentTreeRefValue.new(props) return end

---@class AIArgumentUint64Value : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue Uint64
AIArgumentUint64Value = {}

---@return AIArgumentUint64Value
function AIArgumentUint64Value.new() return end

---@param props table
---@return AIArgumentUint64Value
function AIArgumentUint64Value.new(props) return end

---@class AIArgumentVectorValue : AIArgumentDefinition
---@field type AIArgumentType
---@field defaultValue Vector3
AIArgumentVectorValue = {}

---@return AIArgumentVectorValue
function AIArgumentVectorValue.new() return end

---@param props table
---@return AIArgumentVectorValue
function AIArgumentVectorValue.new(props) return end

---@class AIAssignGuardAreaCommand : AICommand
---@field restrictMovementAreaRef NodeRef
AIAssignGuardAreaCommand = {}

---@return AIAssignGuardAreaCommand
function AIAssignGuardAreaCommand.new() return end

---@param props table
---@return AIAssignGuardAreaCommand
function AIAssignGuardAreaCommand.new(props) return end

---@class AIAssignRoleCommand : AICommand
---@field role AIRole
AIAssignRoleCommand = {}

---@return AIAssignRoleCommand
function AIAssignRoleCommand.new() return end

---@param props table
---@return AIAssignRoleCommand
function AIAssignRoleCommand.new(props) return end

---@class AIAssignRoleCommandParams : questScriptedAICommandParams
---@field role AIRole
AIAssignRoleCommandParams = {}

---@return AIAssignRoleCommandParams
function AIAssignRoleCommandParams.new() return end

---@param props table
---@return AIAssignRoleCommandParams
function AIAssignRoleCommandParams.new(props) return end

---@return AICommand
function AIAssignRoleCommandParams:CreateCommand() return end

---@return String
function AIAssignRoleCommandParams:GetCommandName() return end

---@class AIAssignRoleTask : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AIAssignRoleTask = {}

---@return AIAssignRoleTask
function AIAssignRoleTask.new() return end

---@param props table
---@return AIAssignRoleTask
function AIAssignRoleTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIAssignRoleTask:Update(context) return end

---@class AIAudioSquad : AISquadBase
AIAudioSquad = {}

---@return AIAudioSquad
function AIAudioSquad.new() return end

---@param props table
---@return AIAudioSquad
function AIAudioSquad.new(props) return end

---@class AIAutonomousConditions : AIbehaviorconditionScript
AIAutonomousConditions = {}

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.AlertedCondition(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.CombatCondition(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.CrowdCombatConditions(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.HasCombatAICommand(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param onlyEntities Bool
---@return Bool
function AIAutonomousConditions.HasHostileThreats(context, onlyEntities) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.HasWeaponInInventory(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.IsPlayerInCombat(context) return end

---@param owner gameObject
---@return Bool
function AIAutonomousConditions.IsPlayerRecentlyDroppedThreat(owner) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.NoWeaponCombatConditions(context) return end

---@param puppet ScriptedPuppet
---@param delay Float
function AIAutonomousConditions.SchedulePassiveConditionEvaluation(puppet, delay) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions.WaitForAnimationToFinish(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIAutonomousConditions:HasUnknownThreats(context) return end

---@class AIAvoidLineOfSightCoverSelection : AICoverSelectionParameters
AIAvoidLineOfSightCoverSelection = {}

---@return AIAvoidLineOfSightCoverSelection
function AIAvoidLineOfSightCoverSelection.new() return end

---@param props table
---@return AIAvoidLineOfSightCoverSelection
function AIAvoidLineOfSightCoverSelection.new(props) return end

---@class AIBackgroundCombatCommand : AICommand
---@field steps AIBackgroundCombatStep[]
AIBackgroundCombatCommand = {}

---@return AIBackgroundCombatCommand
function AIBackgroundCombatCommand.new() return end

---@param props table
---@return AIBackgroundCombatCommand
function AIBackgroundCombatCommand.new(props) return end

---@class AIBackgroundCombatCommandParams : questScriptedAICommandParams
---@field steps AIBackgroundCombatStep[]
AIBackgroundCombatCommandParams = {}

---@return AIBackgroundCombatCommandParams
function AIBackgroundCombatCommandParams.new() return end

---@param props table
---@return AIBackgroundCombatCommandParams
function AIBackgroundCombatCommandParams.new(props) return end

---@return AICommand
function AIBackgroundCombatCommandParams:CreateCommand() return end

---@return String
function AIBackgroundCombatCommandParams:GetCommandName() return end

---@class AIBackgroundCombatDelegate : AIbehaviorScriptBehaviorDelegate
---@field command AIBackgroundCombatCommand
---@field execute Bool
---@field steps AIBackgroundCombatStep[]
---@field currentStep Int32
---@field desiredCover NodeRef
---@field desiredCoverExposureMethod AICoverExposureMethod
---@field desiredDestination NodeRef
---@field hasDesiredTarget Bool
---@field desiredTarget gameEntityReference
---@field desiredCoverId Uint64
---@field currentCoverId Uint64
---@field currentTarget gameObject
---@field canFireFromCover Bool
---@field canFireOutOfCover Bool
AIBackgroundCombatDelegate = {}

---@return AIBackgroundCombatDelegate
function AIBackgroundCombatDelegate.new() return end

---@param props table
---@return AIBackgroundCombatDelegate
function AIBackgroundCombatDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoAllowCoverChange(context) return end

---@return Bool
function AIBackgroundCombatDelegate:DoCompleteCoverChange() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoCompleteTargetChange(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoDisableShootingFromCover(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoEnableShootingFromCover(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoEndCommand(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoExecuteCurrentStep(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoStartCommand(context) return end

---@return Bool
function AIBackgroundCombatDelegate:DoStartCoverChange() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBackgroundCombatDelegate:DoStartNextStep(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param cover NodeRef
---@param exposureMethod AICoverExposureMethod
function AIBackgroundCombatDelegate:SetDesiredCover(context, cover, exposureMethod) return end

---@param context AIbehaviorScriptExecutionContext
---@param destination NodeRef
function AIBackgroundCombatDelegate:SetDesiredDestination(context, destination) return end

---@param context AIbehaviorScriptExecutionContext
---@param target gameEntityReference
function AIBackgroundCombatDelegate:SetDesiredTarget(context, target) return end

---@param context AIbehaviorScriptExecutionContext
---@param value Bool
function AIBackgroundCombatDelegate:SetExecute(context, value) return end

---@class AIBackgroundCombatStep
---@field timeMin Float
---@field timeMax Float
---@field type EAIBackgroundCombatStep
---@field argument gameEntityReference
---@field exposureMethod AICoverExposureMethod
AIBackgroundCombatStep = {}

---@return AIBackgroundCombatStep
function AIBackgroundCombatStep.new() return end

---@param props table
---@return AIBackgroundCombatStep
function AIBackgroundCombatStep.new(props) return end

---@class AIBaseMountCommand : AICommand
---@field mountData gameMountEventData
AIBaseMountCommand = {}

---@class AIBaseUseWorkspotCommand : AICommand
---@field moveToWorkspot Bool
---@field forceEntryAnimName CName
---@field workExcludedGestures workWorkEntryId[]
---@field infiniteSequenceEntryId workWorkEntryId
---@field idleOnlyMode Bool
---@field continueInCombat Bool
---@field movementType moveMovementType
AIBaseUseWorkspotCommand = {}

---@class AIBehaviorCallbackExpression : AIbehaviorexpressionScript
---@field callbackName CName
---@field initialValue Bool
---@field callbackAction ECallbackExpressionActions
---@field callbackId Uint32
---@field value Bool
AIBehaviorCallbackExpression = {}

---@return AIBehaviorCallbackExpression
function AIBehaviorCallbackExpression.new() return end

---@param props table
---@return AIBehaviorCallbackExpression
function AIBehaviorCallbackExpression.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIBehaviorCallbackExpression:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Variant
function AIBehaviorCallbackExpression:CalculateValue(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIBehaviorCallbackExpression:Deactivate(context) return end

---@param cbName CName|string
---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIBehaviorCallbackExpression:OnBehaviorCallback(cbName, context) return end

---@class AIBehaviorScript : IScriptable
AIBehaviorScript = {}

---@param context AIbehaviorScriptExecutionContext
---@return ScriptGameInstance
function AIBehaviorScript:GetGame(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return ScriptedPuppet
function AIBehaviorScript:GetPuppet(context) return end

---@class AIBehaviourSpot : AISmartSpot
---@field behaviour AIResourceReference
AIBehaviourSpot = {}

---@return AIBehaviourSpot
function AIBehaviourSpot.new() return end

---@param props table
---@return AIBehaviourSpot
function AIBehaviourSpot.new(props) return end

---@class AIBehaviourSpotInstance : AISmartSpotInstance
AIBehaviourSpotInstance = {}

---@return AIBehaviourSpotInstance
function AIBehaviourSpotInstance.new() return end

---@param props table
---@return AIBehaviourSpotInstance
function AIBehaviourSpotInstance.new(props) return end

---@class AIBlackboardDef : gamebbScriptDefinition
AIBlackboardDef = {}

---@class AIBoolArgumentInstancePS : AIArgumentInstancePS
---@field value Bool
AIBoolArgumentInstancePS = {}

---@return AIBoolArgumentInstancePS
function AIBoolArgumentInstancePS.new() return end

---@param props table
---@return AIBoolArgumentInstancePS
function AIBoolArgumentInstancePS.new(props) return end

---@class AICAgent : gameComponent
AICAgent = {}

---@return AICAgent
function AICAgent.new() return end

---@param props table
---@return AICAgent
function AICAgent.new(props) return end

---@param obj ScriptedPuppet
---@param cmd AICommand
function AICAgent.CancelCommand(obj, cmd) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICAgent.DebugLogEnabled(puppet) return end

---@param obj ScriptedPuppet
---@param cbName CName|string
function AICAgent.InvokeBehaviorCallback(obj, cbName) return end

---@param obj ScriptedPuppet
---@param cmd AICommand
function AICAgent.SendCommand(obj, cmd) return end

---@param cmd AICommand
---@return Bool
function AICAgent:CancelCommand(cmd) return end

---@param cmdId Uint32
---@param doNotRepeat Bool
---@return Bool
function AICAgent:CancelCommandById(cmdId, doNotRepeat) return end

---@param commandName CName|string
---@param useInheritance Bool
---@param success Bool
---@return Bool
function AICAgent:CancelOrInterruptCommand(commandName, useInheritance, success) return end

---@param category CName|string
---@param message String
function AICAgent:DebugLog(category, message) return end

---@return Bool
function AICAgent:DebugLogEnabled() return end

function AICAgent:DisableCollider() return end

function AICAgent:EnableCollider() return end

function AICAgent:ForceTickNextFrame() return end

---@return AIRole
function AICAgent:GetAIRole() return end

---@param n CName|string
---@return Variant
function AICAgent:GetBehaviorArgument(n) return end

---@return AIbehaviorCombatModes
function AICAgent:GetCombatMode() return end

---@return AICombatSpaceSize
function AICAgent:GetCombatSpaceSize() return end

---@return Float
function AICAgent:GetCombatSpaceSizeMultiplier() return end

---@param cmd AICommand
---@return AICommandState
function AICAgent:GetCommandState(cmd) return end

---@param commandName CName|string
---@param useInheritance Bool
---@return AICommand
function AICAgent:GetEnqueuedOrExecutingCommand(commandName, useInheritance) return end

---@return gameIFriendlyFireSystem
function AICAgent:GetFriendlyFireSystem() return end

---@return gamedataNPCHighLevelState
function AICAgent:GetHighLevelState() return end

---@return Int32
function AICAgent:GetLOD() return end

---@return gameLoSIFinderSystem
function AICAgent:GetLoSFinderSystem() return end

---@param definition gamebbScriptDefinition
---@param cache gameIBlackboard
---@return gameIBlackboard
function AICAgent:GetOrCreateBlackboard(definition, cache) return end

---@return gameBoolSignalTable
function AICAgent:GetSignals() return end

---@return gameStoryTier
function AICAgent:GetStoryTier() return end

---@return Uint32
function AICAgent:GetUpdateTickCount() return end

---@param cbName CName|string
function AICAgent:InvokeBehaviorCallback(cbName) return end

---@param commandName CName|string
---@param useInheritance Bool
---@return Bool
function AICAgent:IsCommandExecuting(commandName, useInheritance) return end

---@param commandName CName|string
---@param useInheritance Bool
---@return Bool
function AICAgent:IsCommandWaiting(commandName, useInheritance) return end

---@param cmd AICommand
---@return Bool
function AICAgent:SendCommand(cmd) return end

---@param role AIRole
function AICAgent:SetAIRole(role) return end

---@param n CName|string
---@param nv Variant
function AICAgent:SetBehaviorArgument(n, nv) return end

---@param combatSpaceSize AICombatSpaceSize
function AICAgent:SetCombatSpaceSize(combatSpaceSize) return end

---@param multiplier Float
function AICAgent:SetCombatSpaceSizeMultiplier(multiplier) return end

---@param cmd AICommand
---@return Bool
function AICAgent:StartExecutingCommand(cmd) return end

---@param cmd AICommand
---@param success Bool
---@return Bool
function AICAgent:StopExecutingCommand(cmd, success) return end

---@param cmdId Uint32
---@param success Bool
---@return Bool
function AICAgent:StopExecutingCommandById(cmdId, success) return end

---@return gamedataReactionPreset_Record
function AICAgent:GetCurrentReactionPreset() return end

---@class AICArchetypeManager : AIIArchetypeManager
AICArchetypeManager = {}

---@return AICArchetypeManager
function AICArchetypeManager.new() return end

---@param props table
---@return AICArchetypeManager
function AICArchetypeManager.new(props) return end

---@class AICMovementTarget : AIPosition
AICMovementTarget = {}

---@return AICMovementTarget
function AICMovementTarget.new() return end

---@param props table
---@return AICMovementTarget
function AICMovementTarget.new(props) return end

---@class AICNameArgumentInstancePS : AIArgumentInstancePS
---@field value CName
AICNameArgumentInstancePS = {}

---@return AICNameArgumentInstancePS
function AICNameArgumentInstancePS.new() return end

---@param props table
---@return AICNameArgumentInstancePS
function AICNameArgumentInstancePS.new(props) return end

---@class AICTreeExtendableNodeDefinition : AICTreeNodeDefinition
---@field optionalChild LibTreeINodeDefinition
AICTreeExtendableNodeDefinition = {}

---@class AICTreeInstance
AICTreeInstance = {}

---@return AICTreeInstance
function AICTreeInstance.new() return end

---@param props table
---@return AICTreeInstance
function AICTreeInstance.new(props) return end

---@class AICTreeLazyNodeDefinition : AICTreeNodeDefinition
---@field tree LibTreeCTreeResource
AICTreeLazyNodeDefinition = {}

---@return AICTreeLazyNodeDefinition
function AICTreeLazyNodeDefinition.new() return end

---@param props table
---@return AICTreeLazyNodeDefinition
function AICTreeLazyNodeDefinition.new(props) return end

---@class AICTreeNodeActionAnimationCurvePathDefinition : AICTreeNodeActionDefinition
---@field nodeReference LibTreeDefNodeRef
---@field controllersSetupName LibTreeDefCName
---@field useStart LibTreeDefBool
---@field useStop LibTreeDefBool
---@field blendTime LibTreeDefFloat
---@field globalInBlendTime LibTreeDefFloat
---@field globalOutBlendTime LibTreeDefFloat
---@field turnCharacterToMatchVelocity LibTreeDefBool
---@field customStartAnimationName LibTreeDefCName
---@field customMainAnimationName LibTreeDefCName
---@field customStopAnimationName LibTreeDefCName
---@field startSnapToTerrain LibTreeDefBool
---@field mainSnapToTerrain LibTreeDefBool
---@field stopSnapToTerrain LibTreeDefBool
---@field startSnapToTerrainBlendTime LibTreeDefFloat
---@field stopSnapToTerrainBlendTime LibTreeDefFloat
AICTreeNodeActionAnimationCurvePathDefinition = {}

---@return AICTreeNodeActionAnimationCurvePathDefinition
function AICTreeNodeActionAnimationCurvePathDefinition.new() return end

---@param props table
---@return AICTreeNodeActionAnimationCurvePathDefinition
function AICTreeNodeActionAnimationCurvePathDefinition.new(props) return end

---@class AICTreeNodeActionAnimationCurvePathDynamicDefinition : AICTreeNodeActionDefinition
---@field targetSplineVarName CName
---@field controlerVarName CName
---@field startAnimVarName CName
---@field stopAnimVarName CName
---@field blendTime Float
---@field globalInBlendTime Float
---@field globalOutBlendTime Float
---@field turnCharacterToMatchVelocity Bool
---@field startSnapToTerrain Bool
---@field mainSnapToTerrain Bool
---@field stopSnapToTerrain Bool
---@field startSnapToTerrainBlendTime Float
---@field stopSnapToTerrainBlendTime Float
AICTreeNodeActionAnimationCurvePathDynamicDefinition = {}

---@return AICTreeNodeActionAnimationCurvePathDynamicDefinition
function AICTreeNodeActionAnimationCurvePathDynamicDefinition.new() return end

---@param props table
---@return AICTreeNodeActionAnimationCurvePathDynamicDefinition
function AICTreeNodeActionAnimationCurvePathDynamicDefinition.new(props) return end

---@class AICTreeNodeActionDefinition : AICTreeExtendableNodeDefinition
AICTreeNodeActionDefinition = {}

---@class AICTreeNodeActionDieDefinition : AICTreeNodeActionDefinition
AICTreeNodeActionDieDefinition = {}

---@return AICTreeNodeActionDieDefinition
function AICTreeNodeActionDieDefinition.new() return end

---@param props table
---@return AICTreeNodeActionDieDefinition
function AICTreeNodeActionDieDefinition.new(props) return end

---@class AICTreeNodeActionDynamicMoveToDefinition : AICTreeNodeActionDefinition
---@field moveType moveMovementType
---@field tolerance Float
---@field target CName
---@field keepDistance Bool
AICTreeNodeActionDynamicMoveToDefinition = {}

---@return AICTreeNodeActionDynamicMoveToDefinition
function AICTreeNodeActionDynamicMoveToDefinition.new() return end

---@param props table
---@return AICTreeNodeActionDynamicMoveToDefinition
function AICTreeNodeActionDynamicMoveToDefinition.new(props) return end

---@class AICTreeNodeActionReloadWeaponDefinition : AICTreeNodeActionDefinition
AICTreeNodeActionReloadWeaponDefinition = {}

---@return AICTreeNodeActionReloadWeaponDefinition
function AICTreeNodeActionReloadWeaponDefinition.new() return end

---@param props table
---@return AICTreeNodeActionReloadWeaponDefinition
function AICTreeNodeActionReloadWeaponDefinition.new(props) return end

---@class AICTreeNodeActionTeleportToNodeDefinition : AICTreeNodeActionDefinition
---@field nodeRef LibTreeDefNodeRef
---@field offset LibTreeDefVector
---@field doNavTest Bool
AICTreeNodeActionTeleportToNodeDefinition = {}

---@return AICTreeNodeActionTeleportToNodeDefinition
function AICTreeNodeActionTeleportToNodeDefinition.new() return end

---@param props table
---@return AICTreeNodeActionTeleportToNodeDefinition
function AICTreeNodeActionTeleportToNodeDefinition.new(props) return end

---@class AICTreeNodeActionTeleportToPositionDefinition : AICTreeNodeActionDefinition
---@field positionName CName
---@field doNavTest Bool
AICTreeNodeActionTeleportToPositionDefinition = {}

---@return AICTreeNodeActionTeleportToPositionDefinition
function AICTreeNodeActionTeleportToPositionDefinition.new() return end

---@param props table
---@return AICTreeNodeActionTeleportToPositionDefinition
function AICTreeNodeActionTeleportToPositionDefinition.new(props) return end

---@class AICTreeNodeAtomicDefinition : AICTreeNodeDefinition
AICTreeNodeAtomicDefinition = {}

---@class AICTreeNodeBoolSharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodeBoolSharedVarDecoratorDefinition = {}

---@return AICTreeNodeBoolSharedVarDecoratorDefinition
function AICTreeNodeBoolSharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeBoolSharedVarDecoratorDefinition
function AICTreeNodeBoolSharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeBrainDefinition : AICTreeNodeCompositeDefinition
---@field children LibTreeINodeDefinition[]
---@field useScoring Bool
AICTreeNodeBrainDefinition = {}

---@return AICTreeNodeBrainDefinition
function AICTreeNodeBrainDefinition.new() return end

---@param props table
---@return AICTreeNodeBrainDefinition
function AICTreeNodeBrainDefinition.new(props) return end

---@class AICTreeNodeChildrenListDefinition : AICTreeNodeCompositeDefinition
---@field children LibTreeINodeDefinition[]
AICTreeNodeChildrenListDefinition = {}

---@return AICTreeNodeChildrenListDefinition
function AICTreeNodeChildrenListDefinition.new() return end

---@param props table
---@return AICTreeNodeChildrenListDefinition
function AICTreeNodeChildrenListDefinition.new(props) return end

---@class AICTreeNodeCompleteImmediatelyDefinition : AICTreeNodeAtomicDefinition
---@field completeWithSuccess Bool
AICTreeNodeCompleteImmediatelyDefinition = {}

---@return AICTreeNodeCompleteImmediatelyDefinition
function AICTreeNodeCompleteImmediatelyDefinition.new() return end

---@param props table
---@return AICTreeNodeCompleteImmediatelyDefinition
function AICTreeNodeCompleteImmediatelyDefinition.new(props) return end

---@class AICTreeNodeCompositeDefinition : AICTreeNodeDefinition
AICTreeNodeCompositeDefinition = {}

---@class AICTreeNodeConditionDefinition : AICTreeNodeCompositeDefinition
---@field expressions LibTreeINodeDefinition[]
---@field trueBranch LibTreeINodeDefinition
---@field falseBranch LibTreeINodeDefinition
---@field reevaluateOnExecution Bool
AICTreeNodeConditionDefinition = {}

---@return AICTreeNodeConditionDefinition
function AICTreeNodeConditionDefinition.new() return end

---@param props table
---@return AICTreeNodeConditionDefinition
function AICTreeNodeConditionDefinition.new(props) return end

---@class AICTreeNodeDebugLogDefinition : AICTreeExtendableNodeDefinition
---@field text String
---@field timeOnScreen Float
---@field useVisualDebug Bool
AICTreeNodeDebugLogDefinition = {}

---@return AICTreeNodeDebugLogDefinition
function AICTreeNodeDebugLogDefinition.new() return end

---@param props table
---@return AICTreeNodeDebugLogDefinition
function AICTreeNodeDebugLogDefinition.new(props) return end

---@class AICTreeNodeDecisionDefinition : AICTreeNodeCompositeDefinition
---@field child LibTreeINodeDefinition
---@field expressions LibTreeINodeDefinition[]
---@field interruption AIInterruptionSignal
AICTreeNodeDecisionDefinition = {}

---@return AICTreeNodeDecisionDefinition
function AICTreeNodeDecisionDefinition.new() return end

---@param props table
---@return AICTreeNodeDecisionDefinition
function AICTreeNodeDecisionDefinition.new(props) return end

---@class AICTreeNodeDecoratorDefinition : AICTreeNodeDefinition
---@field child LibTreeINodeDefinition
AICTreeNodeDecoratorDefinition = {}

---@class AICTreeNodeDefinition : LibTreeINodeDefinition
AICTreeNodeDefinition = {}

---@class AICTreeNodeDoNothingDefinition : AICTreeNodeAtomicDefinition
AICTreeNodeDoNothingDefinition = {}

---@return AICTreeNodeDoNothingDefinition
function AICTreeNodeDoNothingDefinition.new() return end

---@param props table
---@return AICTreeNodeDoNothingDefinition
function AICTreeNodeDoNothingDefinition.new(props) return end

---@class AICTreeNodeDynamicBindDefinition : AICTreeNodeDynamicDefinition
AICTreeNodeDynamicBindDefinition = {}

---@return AICTreeNodeDynamicBindDefinition
function AICTreeNodeDynamicBindDefinition.new() return end

---@param props table
---@return AICTreeNodeDynamicBindDefinition
function AICTreeNodeDynamicBindDefinition.new(props) return end

---@class AICTreeNodeDynamicDefinition : AICTreeNodeDefinition
AICTreeNodeDynamicDefinition = {}

---@class AICTreeNodeFSMDefinition : AICTreeNodeCompositeDefinition
---@field defaultState Uint16
---@field transitions AIFSMTransitionDefinition[]
---@field onEventTransitions AIFSMEventTransitionsListDefinition[]
---@field states AIFSMStateDefinition[]
---@field sharedVars AISharedVarTableDefinition
AICTreeNodeFSMDefinition = {}

---@return AICTreeNodeFSMDefinition
function AICTreeNodeFSMDefinition.new() return end

---@param props table
---@return AICTreeNodeFSMDefinition
function AICTreeNodeFSMDefinition.new(props) return end

---@class AICTreeNodeFloatSharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodeFloatSharedVarDecoratorDefinition = {}

---@return AICTreeNodeFloatSharedVarDecoratorDefinition
function AICTreeNodeFloatSharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeFloatSharedVarDecoratorDefinition
function AICTreeNodeFloatSharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeForcedBehaviourDefinition : AICTreeNodeDynamicDefinition
AICTreeNodeForcedBehaviourDefinition = {}

---@return AICTreeNodeForcedBehaviourDefinition
function AICTreeNodeForcedBehaviourDefinition.new() return end

---@param props table
---@return AICTreeNodeForcedBehaviourDefinition
function AICTreeNodeForcedBehaviourDefinition.new(props) return end

---@class AICTreeNodeIncludedTreeDefinition : AICTreeNodeDefinition
---@field tree LibTreeDefTree
AICTreeNodeIncludedTreeDefinition = {}

---@return AICTreeNodeIncludedTreeDefinition
function AICTreeNodeIncludedTreeDefinition.new() return end

---@param props table
---@return AICTreeNodeIncludedTreeDefinition
function AICTreeNodeIncludedTreeDefinition.new(props) return end

---@class AICTreeNodeInt32SharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodeInt32SharedVarDecoratorDefinition = {}

---@return AICTreeNodeInt32SharedVarDecoratorDefinition
function AICTreeNodeInt32SharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeInt32SharedVarDecoratorDefinition
function AICTreeNodeInt32SharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeNameSharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodeNameSharedVarDecoratorDefinition = {}

---@return AICTreeNodeNameSharedVarDecoratorDefinition
function AICTreeNodeNameSharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeNameSharedVarDecoratorDefinition
function AICTreeNodeNameSharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeParallelDefinition : AICTreeNodeChildrenListDefinition
---@field forwardChildrenCompleteness Bool
AICTreeNodeParallelDefinition = {}

---@return AICTreeNodeParallelDefinition
function AICTreeNodeParallelDefinition.new() return end

---@param props table
---@return AICTreeNodeParallelDefinition
function AICTreeNodeParallelDefinition.new(props) return end

---@class AICTreeNodePlayerControlledDefinition : AICTreeNodeAtomicDefinition
AICTreeNodePlayerControlledDefinition = {}

---@return AICTreeNodePlayerControlledDefinition
function AICTreeNodePlayerControlledDefinition.new() return end

---@param props table
---@return AICTreeNodePlayerControlledDefinition
function AICTreeNodePlayerControlledDefinition.new(props) return end

---@class AICTreeNodePositionSharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodePositionSharedVarDecoratorDefinition = {}

---@return AICTreeNodePositionSharedVarDecoratorDefinition
function AICTreeNodePositionSharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodePositionSharedVarDecoratorDefinition
function AICTreeNodePositionSharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeReadWorkspotParamsDefinition : AICTreeNodeDecoratorDefinition
---@field workspotNodeVarName CName
---@field prevWorkspotNodeVarName CName
---@field splineNodeVarName CName
---@field workspotEntryAnimVar CName
---@field animControllerVarName CName
---@field splineStartAnimVarName CName
---@field splineStopAnimVarName CName
---@field moveTargetVarName CName
AICTreeNodeReadWorkspotParamsDefinition = {}

---@return AICTreeNodeReadWorkspotParamsDefinition
function AICTreeNodeReadWorkspotParamsDefinition.new() return end

---@param props table
---@return AICTreeNodeReadWorkspotParamsDefinition
function AICTreeNodeReadWorkspotParamsDefinition.new(props) return end

---@class AICTreeNodeScriptDecoratorDefinition : AICTreeExtendableNodeDefinition
---@field script gameActionScript
---@field scriptName CName
AICTreeNodeScriptDecoratorDefinition = {}

---@return AICTreeNodeScriptDecoratorDefinition
function AICTreeNodeScriptDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeScriptDecoratorDefinition
function AICTreeNodeScriptDecoratorDefinition.new(props) return end

---@class AICTreeNodeSequenceDefinition : AICTreeNodeChildrenListDefinition
AICTreeNodeSequenceDefinition = {}

---@return AICTreeNodeSequenceDefinition
function AICTreeNodeSequenceDefinition.new() return end

---@param props table
---@return AICTreeNodeSequenceDefinition
function AICTreeNodeSequenceDefinition.new(props) return end

---@class AICTreeNodeSetSplineMovementTargetDefinition : AICTreeNodeDecoratorDefinition
---@field splineNode LibTreeSharedVarReferenceName
---@field movementTarget LibTreeSharedVarRegistrationName
AICTreeNodeSetSplineMovementTargetDefinition = {}

---@return AICTreeNodeSetSplineMovementTargetDefinition
function AICTreeNodeSetSplineMovementTargetDefinition.new() return end

---@param props table
---@return AICTreeNodeSetSplineMovementTargetDefinition
function AICTreeNodeSetSplineMovementTargetDefinition.new(props) return end

---@class AICTreeNodeSharedVarsBaseDecoratorDefinition : AICTreeNodeDecoratorDefinition
AICTreeNodeSharedVarsBaseDecoratorDefinition = {}

---@class AICTreeNodeSharedVarsDecoratorDefinition : AICTreeNodeSharedVarsBaseDecoratorDefinition
---@field sharedVars AISharedVarTableDefinition
AICTreeNodeSharedVarsDecoratorDefinition = {}

---@return AICTreeNodeSharedVarsDecoratorDefinition
function AICTreeNodeSharedVarsDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeSharedVarsDecoratorDefinition
function AICTreeNodeSharedVarsDecoratorDefinition.new(props) return end

---@class AICTreeNodeSimpleSelectorDefinition : AICTreeNodeChildrenListDefinition
AICTreeNodeSimpleSelectorDefinition = {}

---@return AICTreeNodeSimpleSelectorDefinition
function AICTreeNodeSimpleSelectorDefinition.new() return end

---@param props table
---@return AICTreeNodeSimpleSelectorDefinition
function AICTreeNodeSimpleSelectorDefinition.new(props) return end

---@class AICTreeNodeSingleSharedVarDecoratorDefinition : AICTreeNodeSharedVarsBaseDecoratorDefinition
---@field sharedVarName LibTreeSharedVarRegistrationName
AICTreeNodeSingleSharedVarDecoratorDefinition = {}

---@class AICTreeNodeTargetNodeSharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodeTargetNodeSharedVarDecoratorDefinition = {}

---@return AICTreeNodeTargetNodeSharedVarDecoratorDefinition
function AICTreeNodeTargetNodeSharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeTargetNodeSharedVarDecoratorDefinition
function AICTreeNodeTargetNodeSharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeTargetSharedVarDecoratorDefinition : AICTreeNodeSingleSharedVarDecoratorDefinition
AICTreeNodeTargetSharedVarDecoratorDefinition = {}

---@return AICTreeNodeTargetSharedVarDecoratorDefinition
function AICTreeNodeTargetSharedVarDecoratorDefinition.new() return end

---@param props table
---@return AICTreeNodeTargetSharedVarDecoratorDefinition
function AICTreeNodeTargetSharedVarDecoratorDefinition.new(props) return end

---@class AICTreeNodeTimeoutDefinition : AICTreeExtendableNodeDefinition
---@field timeout Float
AICTreeNodeTimeoutDefinition = {}

---@return AICTreeNodeTimeoutDefinition
function AICTreeNodeTimeoutDefinition.new() return end

---@param props table
---@return AICTreeNodeTimeoutDefinition
function AICTreeNodeTimeoutDefinition.new(props) return end

---@class AIClearLineOfSightCoverSelection : AICoverSelectionParameters
AIClearLineOfSightCoverSelection = {}

---@return AIClearLineOfSightCoverSelection
function AIClearLineOfSightCoverSelection.new() return end

---@param props table
---@return AIClearLineOfSightCoverSelection
function AIClearLineOfSightCoverSelection.new(props) return end

---@class AIClearLineOfSightCoverSelectionRuntimeData : AICoverSelectionRuntimeData
AIClearLineOfSightCoverSelectionRuntimeData = {}

---@return AIClearLineOfSightCoverSelectionRuntimeData
function AIClearLineOfSightCoverSelectionRuntimeData.new() return end

---@param props table
---@return AIClearLineOfSightCoverSelectionRuntimeData
function AIClearLineOfSightCoverSelectionRuntimeData.new(props) return end

---@class AIClearRoleCommandParams : questScriptedAICommandParams
AIClearRoleCommandParams = {}

---@return AIClearRoleCommandParams
function AIClearRoleCommandParams.new() return end

---@param props table
---@return AIClearRoleCommandParams
function AIClearRoleCommandParams.new(props) return end

---@return AICommand
function AIClearRoleCommandParams:CreateCommand() return end

---@return String
function AIClearRoleCommandParams:GetCommandName() return end

---@class AICodeInterface : IScriptable
AICodeInterface = {}

---@param context AIbehaviorScriptExecutionContext
---@param puppet gamePuppet
---@param equipmentGroup CName|string
---@return AIbehaviorConditionOutcomes
function AICodeInterface.CheckSlotsForEquipment(context, puppet, equipmentGroup) return end

---@param weapon gameweaponObject
---@return gamedataTriggerMode
function AICodeInterface.GetLastRequestedTriggerMode(weapon) return end

---@class AICombatAlley : IScriptable
AICombatAlley = {}

---@return AICombatAlley
function AICombatAlley.new() return end

---@param props table
---@return AICombatAlley
function AICombatAlley.new(props) return end

---@param sector AICombatSectorType
---@return entEntity
function AICombatAlley:GetClosestMemberFromSector(sector) return end

---@param sector AICombatSectorType
---@param pos Vector4
---@return Float
function AICombatAlley:GetDistanceFromSector(sector, pos) return end

---@param sector AICombatSectorType
---@return entEntity
function AICombatAlley:GetFurtherstMemberFromSector(sector) return end

---@return Vector4
function AICombatAlley:GetReferencePoint() return end

---@param pos Vector4
---@return AICombatSectorType
function AICombatAlley:GetSector(pos) return end

---@return Vector4
function AICombatAlley:GetTargetPoint() return end

---@class AICombatGuardAreaConnectedCommunity
---@field communityArea gameEntityReference
---@field conditions AIICombatGuardAreaCondition[]
AICombatGuardAreaConnectedCommunity = {}

---@return AICombatGuardAreaConnectedCommunity
function AICombatGuardAreaConnectedCommunity.new() return end

---@param props table
---@return AICombatGuardAreaConnectedCommunity
function AICombatGuardAreaConnectedCommunity.new(props) return end

---@class AICombatGuardAreaScriptCondition : AIICombatGuardAreaCondition
AICombatGuardAreaScriptCondition = {}

---@return AICombatGuardAreaScriptCondition
function AICombatGuardAreaScriptCondition.new() return end

---@param props table
---@return AICombatGuardAreaScriptCondition
function AICombatGuardAreaScriptCondition.new(props) return end

---@param entityId entEntityID
---@param area AIScriptGuardArea
---@param entityEntered Bool
---@return Bool
function AICombatGuardAreaScriptCondition:IsFulfilled(entityId, area, entityEntered) return end

---@class AICombatRelatedCommand : AICommand
---@field immediately Bool
AICombatRelatedCommand = {}

---@return AICombatRelatedCommand
function AICombatRelatedCommand.new() return end

---@param props table
---@return AICombatRelatedCommand
function AICombatRelatedCommand.new(props) return end

---@class AICombatSquad : AISquadBase
AICombatSquad = {}

---@return AICombatSquad
function AICombatSquad.new() return end

---@param props table
---@return AICombatSquad
function AICombatSquad.new(props) return end

---@class AICombatSquadScriptInterface : AISquadScriptInterface
AICombatSquadScriptInterface = {}

---@return AICombatSquadScriptInterface
function AICombatSquadScriptInterface.new() return end

---@param props table
---@return AICombatSquadScriptInterface
function AICombatSquadScriptInterface.new(props) return end

---@param et entEntity
---@return Bool
function AICombatSquadScriptInterface:AddEnemy(et) return end

---@return entEntity[]
function AICombatSquadScriptInterface:EnemyList() return end

---@return entEntity[]
function AICombatSquadScriptInterface:EnemyListWeak() return end

---@return AICombatAlley
function AICombatSquadScriptInterface:GetDefensiveCombatAlley() return end

---@return Uint32
function AICombatSquadScriptInterface:GetEnemiesCount() return end

---@param enemy entEntity
---@return Uint32
function AICombatSquadScriptInterface:GetEnemyAttackersCount(enemy) return end

---@return AICombatAlley
function AICombatSquadScriptInterface:GetOffensiveCombatAlley() return end

---@return AICombatSquadTacticRatio
function AICombatSquadScriptInterface:GetTacticRatio() return end

---@param potentialEnemy entEntity
---@return Bool
function AICombatSquadScriptInterface:IsEnemy(potentialEnemy) return end

---@param sourceSquadName CName|string
function AICombatSquadScriptInterface:PullEnemies(sourceSquadName) return end

---@param sqAction CName|string
---@param sectors AICombatSectorType[]
---@param alley AICombatAlley
---@param timeout Float
function AICombatSquadScriptInterface:RegisterTactic(sqAction, sectors, alley, timeout) return end

---@param et entEntity
---@return Bool
function AICombatSquadScriptInterface:RemoveEnemy(et) return end

---@param squadMember entEntity
---@param enemy entEntity
function AICombatSquadScriptInterface:SetAsEnemyAttacker(squadMember, enemy) return end

---@param sqAction CName|string
function AICombatSquadScriptInterface:UnregisterTactic(sqAction) return end

---@return Bool
function AICombatSquadScriptInterface:ValidCombatSquad() return end

---@class AICombatSquadTacticRatio
---@field ratioSum Float
---@field reachSum Float
---@field area Float
AICombatSquadTacticRatio = {}

---@return AICombatSquadTacticRatio
function AICombatSquadTacticRatio.new() return end

---@param props table
---@return AICombatSquadTacticRatio
function AICombatSquadTacticRatio.new(props) return end

---@class AICombatTargetHelper : IScriptable
AICombatTargetHelper = {}

---@param context AIbehaviorScriptExecutionContext
function AICombatTargetHelper.SetCombatTargetChangeSignal(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param target gameObject
---@return Bool
function AICombatTargetHelper.SetNewCombatTarget(context, target) return end

---@class AICommand : IScriptable
---@field id Uint32
---@field state AICommandState
---@field questBlockId Uint64
---@field category CName
AICommand = {}

---@return AICommand
function AICommand.new() return end

---@param props table
---@return AICommand
function AICommand.new(props) return end

---@return AICommand
function AICommand:Copy() return end

---@return CName
function AICommand:GetCategory() return end

---@param value CName|string
function AICommand:SetCategory(value) return end

---@class AICommandDeviceHandler : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AICommandDeviceHandler = {}

---@return AICommandDeviceHandler
function AICommandDeviceHandler.new() return end

---@param props table
---@return AICommandDeviceHandler
function AICommandDeviceHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AICommandDeviceHandler:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AICommandDeviceHandler:Update(context) return end

---@class AICommandHandlerBase : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AICommandHandlerBase = {}

---@return AICommandHandlerBase
function AICommandHandlerBase.new() return end

---@param props table
---@return AICommandHandlerBase
function AICommandHandlerBase.new(props) return end

---@param argument AIArgumentMapping
---@param argName CName|string
---@return Bool
function AICommandHandlerBase:CheckArgument(argument, argName) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AICommandHandlerBase:Update(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AICommandHandlerBase:UpdateCommand(context, command) return end

---@class AICommandQueuePS : gameComponentPS
---@field behaviorArgumentList AIArgumentInstancePS[]
---@field aiRole AIRole
AICommandQueuePS = {}

---@return AICommandQueuePS
function AICommandQueuePS.new() return end

---@param props table
---@return AICommandQueuePS
function AICommandQueuePS.new(props) return end

---@class AICommandsManager : AIICommandsManager
AICommandsManager = {}

---@return AICommandsManager
function AICommandsManager.new() return end

---@param props table
---@return AICommandsManager
function AICommandsManager.new(props) return end

---@class AICommsCallMoveToCommand : AIMoveToCommand
AICommsCallMoveToCommand = {}

---@return AICommsCallMoveToCommand
function AICommsCallMoveToCommand.new() return end

---@param props table
---@return AICommsCallMoveToCommand
function AICommsCallMoveToCommand.new(props) return end

---@class AICondition : IScriptable
AICondition = {}

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
---@return Bool
function AICondition.ActivationCheck(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
---@return Bool
function AICondition.AnimationStreamedInCheck(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIIsShootingBlockedFromPrevention_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIVelocitiesDotCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAICanShootInCarChaseCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIVehicleCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIOptimalDistanceCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIExtendTargetCirclingCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIEverPerformedChase_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAISpatialCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIMovementCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAICoverCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIDodgeCountCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIStatusEffectCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIVelocityDotCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAISignalCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIGoToCoverCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAISecurityCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAITargetCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIAssignedVehicleInRace_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAITresspassingCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIFriendlyFireCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAINPCRarityCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAINPCTypeCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIIsFromDynamicSpawnSystem_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAITargetInPreventionFreeArea_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIDriverCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIReactionCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIIsOnNavmeshCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIIsFromPreventionSystem_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAICalculatePathCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAILookAtCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIHitCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAINPCDifficultyCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIStateCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIAssignedVehicleCanReachTargetCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIAssignedVehicleInPanicDriving_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIWeakSpotCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIItemCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIRestrictedMovementAreaCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAISlotCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAICalculateLineOfSightVector_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIMovingInCirclesCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIThrowCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAISquadCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIPreviousAttackCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIAmmoCountCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIStatPoolCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIIsHeatStage5Active_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAITargetInUnmountingRangeCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIAbilityCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIWeaponLockedOnTargetCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIHasWeapon_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIVelocityCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIBlockCountCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIInTacticPositionCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAICommandCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIPercentageChanceCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIVehicleInsideInnerAreaOfAreaSpeedLimiter_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAILoSPositionCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIInArmedVehicleCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIValidCoversCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIGameDifficultyCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIIsInActiveCameraCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIWorkspotCond_Record
---@return Bool
function AICondition.Check(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckAbilities(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param ability gamedataGameplayAbility_Record
---@return Bool
function AICondition.CheckAbility(context, ability) return end

---@param puppet ScriptedPuppet
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckActionCondition(puppet, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckActionCondition(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param conditions gamedataAIActionCondition_Record[]
---@return Bool
function AICondition.CheckActionConditions(context, conditions) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckAmmoCounts(context, condition) return end

---@param owner gamePuppet
---@param source gameObject
---@param sourcePosition Vector4
---@param sourceCoverID Uint64
---@param target gameObject
---@param targetPosition Vector4
---@param targetCoverID Uint64
---@param coneAngleRange Vector2
---@param condition gamedataAISpatialCond_Record
---@return Bool, Bool
function AICondition.CheckAngle2ObjInternal(owner, source, sourcePosition, sourceCoverID, target, targetPosition, targetCoverID, coneAngleRange, condition) return end

---@param owner gamePuppet
---@param source gameObject
---@param sourcePosition Vector4
---@param sourceCoverID Uint64
---@param target gameObject
---@param targetPosition Vector4
---@param targetCoverID Uint64
---@param targetOpt gameObject
---@param targetPositionOpt Vector4
---@param targetCoverIDOpt Uint64
---@param coneAngleRange Vector2
---@param condition gamedataAISpatialCond_Record
---@return Bool, Bool
function AICondition.CheckAngle3ObjInternal(owner, source, sourcePosition, sourceCoverID, target, targetPosition, targetCoverID, targetOpt, targetPositionOpt, targetCoverIDOpt, coneAngleRange, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckCalculateLineOfSightVector(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckCalculatePaths(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckCommands(context, condition) return end

---@param owner gamePuppet
---@param sourcePosition Vector4
---@param targetPosition Vector4
---@param distanceRange Vector2
---@param condition gamedataAISpatialCond_Record
---@return Bool, Bool
function AICondition.CheckDistanceInternal(owner, sourcePosition, targetPosition, distanceRange, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckItems(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckLookats(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckMovements(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckReactions(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckRestrictedMovementAreas(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckSignals(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckSlots(context, condition) return end

---@param ownerContext AIbehaviorScriptExecutionContext
---@param targetContext AIbehaviorScriptExecutionContext
---@param condition gamedataAISpatialCond_Record
---@return Bool
function AICondition.CheckSpatial(ownerContext, targetContext, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckSpatials(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckStatPools(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckStates(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckStatusEffects(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckTickets(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckTresspassings(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckVehicles(context, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AICondition.CheckWeakSpots(context, condition) return end

---@param sourcePosition Vector4
---@param targetPosition Vector4
---@param ZDiffRange Vector2
---@param condition gamedataAISpatialCond_Record
---@return Bool, Bool
function AICondition.CheckZDiffInternal(sourcePosition, targetPosition, ZDiffRange, condition) return end

---@param difficulty gameDifficulty
---@return Int32
function AICondition.GetDifficultyValue(difficulty) return end

---@param difficulty gameEPowerDifferential
---@return Int32
function AICondition.GetPowerDifferentialValue(difficulty) return end

---@param puppet ScriptedPuppet
---@param timePeriod Float
---@return Vector4
function AICondition.GetPuppetVelocity(puppet, timePeriod) return end

---@param ownerPuppet ScriptedPuppet
---@param threats AITrackedLocation[]
---@return Bool
function AICondition.IsAwareOfBeingFlankedByAnyThreat(ownerPuppet, threats) return end

---@param ownerPuppet ScriptedPuppet
---@param threat AITrackedLocation
---@return Bool
function AICondition.IsAwareOfBeingFlankedByThreat(ownerPuppet, threat) return end

---@param context AIbehaviorScriptExecutionContext
---@param phase Uint32
---@param actionRecord gamedataAIAction_Record
---@return Bool
function AICondition.NextPhaseCheck(context, phase, actionRecord) return end

---@param conditionName CName|string
function AICondition.OnCantFindProperCheck(conditionName) return end

---@param context AIbehaviorScriptExecutionContext
---@param phase Uint32
---@param actionRecord gamedataAIAction_Record
---@return Bool
function AICondition.RepeatPhaseCheck(context, phase, actionRecord) return end

---@class AICooldown : AITimeCondition
---@field cooldown Float
---@field timestamp Float
AICooldown = {}

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AICooldown:Check(context) return end

---@param context AIbehaviorScriptExecutionContext
function AICooldown:UpdateTimeStamp(context) return end

---@class AICoreTasks : AIbehaviortaskScript
AICoreTasks = {}

---@class AICoverDataDef : AIBlackboardDef
---@field exposureMethod gamebbScriptID_CName
---@field fallbackExposureMethod gamebbScriptID_CName
---@field lastAvailableMethods gamebbScriptID_Uint32
---@field currentlyExposed gamebbScriptID_Bool
---@field commandExposureMethods gamebbScriptID_Variant
---@field commandCoverOverride gamebbScriptID_Bool
---@field currentCoverStance gamebbScriptID_CName
---@field desiredCoverStance gamebbScriptID_CName
---@field lastCoverPreset gamebbScriptID_CName
---@field lastInitialCoverPreset gamebbScriptID_CName
---@field lastCoverChangeThreshold gamebbScriptID_Float
---@field lastVisibilityCheckTimestamp gamebbScriptID_Float
---@field currentRing gamebbScriptID_Variant
---@field lastCoverRing gamebbScriptID_Variant
---@field lastDebugCoverPreset gamebbScriptID_Int32
---@field firstCoverEvaluationDone gamebbScriptID_Bool
---@field startCoverEvaluationTimeStamp gamebbScriptID_Float
AICoverDataDef = {}

---@return AICoverDataDef
function AICoverDataDef.new() return end

---@param props table
---@return AICoverDataDef
function AICoverDataDef.new(props) return end

---@return Bool
function AICoverDataDef:AutoCreateInSystem() return end

---@param blackboard gameIBlackboard
function AICoverDataDef:Initialize(blackboard) return end

---@class AICoverDemandHolder : IScriptable
AICoverDemandHolder = {}

---@return AICoverDemandHolder
function AICoverDemandHolder.new() return end

---@param props table
---@return AICoverDemandHolder
function AICoverDemandHolder.new(props) return end

---@return Uint64
function AICoverDemandHolder:GetCoverID() return end

---@class AICoverHealthCoverSelection : AICoverSelectionParameters
AICoverHealthCoverSelection = {}

---@return AICoverHealthCoverSelection
function AICoverHealthCoverSelection.new() return end

---@param props table
---@return AICoverHealthCoverSelection
function AICoverHealthCoverSelection.new(props) return end

---@class AICoverHelper : IScriptable
AICoverHelper = {}

---@return AICoverHelper
function AICoverHelper.new() return end

---@param props table
---@return AICoverHelper
function AICoverHelper.new(props) return end

---@param puppet ScriptedPuppet
---@param target gameObject
---@param coverID Uint64
---@param record gamedataAISubActionCover_Record
---@param lineOfSightTolerance Float
---@param trackedLocation AITrackedLocation
---@param exposureMethods AICoverExposureMethod[]
---@return AICoverExposureMethod
function AICoverHelper.CalculateCoverExposureMethod(puppet, target, coverID, record, lineOfSightTolerance, trackedLocation, exposureMethods) return end

---@param actionName CName|string
---@return EAICoverAction
function AICoverHelper.CoverActionNameToEnum(actionName) return end

---@param exposureMethodName CName|string
---@return AICoverExposureMethod
function AICoverHelper.CoverExposureMethodNameToEnum(exposureMethodName) return end

---@param coverHeight CName|string
---@return gameCoverHeight
function AICoverHelper.CoverHeightNameToEnum(coverHeight) return end

---@return AICoverExposureMethod[]
function AICoverHelper.FillEmptyCoverExposureMethodArray() return end

---@return CName[]
function AICoverHelper.FillEmptyCoverExposureMethodNameArray() return end

---@param puppet ScriptedPuppet
---@param targetPosition Vector4
---@param coverID Uint64
---@return Float
function AICoverHelper.GetAbsAngleFromCoverToCombatTarget(puppet, targetPosition, coverID) return end

---@param puppet ScriptedPuppet
---@param movementTargetPos Vector4
---@param coverID Uint64
---@return Float
function AICoverHelper.GetAbsAngleFromCoverToMovementTarget(puppet, movementTargetPos, coverID) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param targetPosition Vector4
---@return Float
function AICoverHelper.GetAbsAngleFromCoverToTargetPosition(puppet, coverID, targetPosition) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param target gameObject
---@param requestedExposureMethods AICoverExposureMethod[]
---@param lineOfSightTolerance Float
---@param exposureMethodPriority gamedataAIExposureMethodType_Record[]
---@return AICoverExposureMethod[]
function AICoverHelper.GetAvailableExposureSpots(puppet, coverID, target, requestedExposureMethods, lineOfSightTolerance, exposureMethodPriority) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param target gameObject
---@param record gamedataAISubActionCover_Record
---@param lineOfSightTolerance Float
---@param exposureMethodPriority gamedataAIExposureMethodType_Record[]
---@return AICoverExposureMethod[]
function AICoverHelper.GetAvailableExposureSpots(puppet, coverID, target, record, lineOfSightTolerance, exposureMethodPriority) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param target gameObject
---@param record gamedataAISubActionCover_Record
---@param lineOfSightTolerance Float
---@param exposureMethodPriority gamedataAIExposureMethodType_Record[]
---@param allAvailableExposureMethods AICoverExposureMethod[]
---@return AICoverExposureMethod[]
function AICoverHelper.GetAvailableExposureSpots(puppet, coverID, target, record, lineOfSightTolerance, exposureMethodPriority, allAvailableExposureMethods) return end

---@param puppet ScriptedPuppet
---@return gameIBlackboard
function AICoverHelper.GetCoverBlackboard(puppet) return end

---@param puppet ScriptedPuppet
---@return AICoverExposureMethod
function AICoverHelper.GetCoverExposureMethod(puppet) return end

---@param puppet ScriptedPuppet
---@return CName
function AICoverHelper.GetCoverExposureMethod(puppet) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@return gameCoverHeight
function AICoverHelper.GetCoverHeight(puppet, coverID) return end

---@param puppet ScriptedPuppet
---@return AISmartCoverManager
function AICoverHelper.GetCoverManager(puppet) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICoverHelper.GetCoverNPCCurrentlyExposed(puppet) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@return Float
function AICoverHelper.GetCoverRemainingHealthPerc(puppet, coverID) return end

---@param puppet ScriptedPuppet
---@param exposureSpot AICoverExposureMethod
---@return gameCoverHeight
function AICoverHelper.GetCoverStanceFromExposureSpot(puppet, exposureSpot) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@return gameCoverHeight, Bool
function AICoverHelper.GetCoverType(puppet, coverID) return end

---@param puppet ScriptedPuppet
---@return Uint64
function AICoverHelper.GetCurrentCover(puppet) return end

---@param puppet ScriptedPuppet
---@return Uint64
function AICoverHelper.GetCurrentCoverId(puppet) return end

---@param puppet ScriptedPuppet
---@return CName
function AICoverHelper.GetCurrentCoverStance(puppet) return end

---@param puppet ScriptedPuppet
---@return gameCoverHeight
function AICoverHelper.GetCurrentCoverStance(puppet) return end

---@param puppet ScriptedPuppet
---@return gameCoverHeight
function AICoverHelper.GetDesiredCoverStance(puppet) return end

---@param puppet ScriptedPuppet
---@return CName
function AICoverHelper.GetDesiredCoverStance(puppet) return end

---@param puppet ScriptedPuppet
---@return AICoverExposureMethod
function AICoverHelper.GetFallbackCoverExposureMethod(puppet) return end

---@param puppet ScriptedPuppet
---@return AICoverExposureMethod
function AICoverHelper.GetRandomCoverLastAvailableExposureMethod(puppet) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICoverHelper.HasAnyCoverLastAvailableExposureMethod(puppet) return end

---@param ownerPuppet ScriptedPuppet
---@param coverID Uint64
---@param target gameObject
---@param exposureMethods CName[]|string[]
---@return Bool
function AICoverHelper.HasCoverExposureMethods(ownerPuppet, coverID, target, exposureMethods) return end

---@param puppetOwner ScriptedPuppet
---@param coverID Uint64
---@param target gameObject
---@param exposureMethods AICoverExposureMethod[]
---@return Bool
function AICoverHelper.HasCoverExposureMethods(puppetOwner, coverID, target, exposureMethods) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICoverHelper.IsCurrentlyInCover(puppet) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICoverHelper.IsCurrentlyInShootingSpot(puppet) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICoverHelper.IsCurrentlyInSmartObject(puppet) return end

---@param exposureMethodName CName|string
---@return Bool
function AICoverHelper.IsStandingExposureMethod(exposureMethodName) return end

---@param exposureMethodName CName|string
---@return Bool
function AICoverHelper.IsUnsafeExposureMethod(exposureMethodName) return end

---@param puppet ScriptedPuppet
---@return Bool
function AICoverHelper.LeaveCoverImmediately(puppet) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param damageTime EngineTime
---@param executingCoverAction Bool
function AICoverHelper.NotifyGotDamageInCover(puppet, coverID, damageTime, executingCoverAction) return end

---@param puppet ScriptedPuppet
---@param coverId Uint64
function AICoverHelper.RegisterNewCover(puppet, coverId) return end

---@param puppet ScriptedPuppet
---@param record gamedataAISubActionCover_Record
---@param exposureMethods AICoverExposureMethod[]
---@return AICoverExposureMethod[]
function AICoverHelper.ReturnHighestPriorityMethods(puppet, record, exposureMethods) return end

---@param puppet ScriptedPuppet
---@param value AICoverExposureMethod
function AICoverHelper.SetCoverExposureMethod(puppet, value) return end

---@param puppet ScriptedPuppet
---@param value CName|string
function AICoverHelper.SetCoverExposureMethod(puppet, value) return end

---@param puppet ScriptedPuppet
---@param exposureMethods AICoverExposureMethod[]
function AICoverHelper.SetCoverLastAvailableExposureMethod(puppet, exposureMethods) return end

---@param puppet ScriptedPuppet
---@param value Bool
function AICoverHelper.SetCoverNPCCurrentlyExposed(puppet, value) return end

---@param puppet ScriptedPuppet
---@param value gameCoverHeight
function AICoverHelper.SetCurrentCoverStance(puppet, value) return end

---@param puppet ScriptedPuppet
---@param value CName|string
function AICoverHelper.SetCurrentCoverStance(puppet, value) return end

---@param puppet ScriptedPuppet
---@param value CName|string
function AICoverHelper.SetDesiredCoverStance(puppet, value) return end

---@param puppet ScriptedPuppet
---@param value gameCoverHeight
function AICoverHelper.SetDesiredCoverStance(puppet, value) return end

---@param puppet ScriptedPuppet
---@param value AICoverExposureMethod
function AICoverHelper.SetFallbackCoverExposureMethod(puppet, value) return end

---@param puppet ScriptedPuppet
function AICoverHelper.UnregisterLastCover(puppet) return end

---@class AICoverScoringData
AICoverScoringData = {}

---@return AICoverScoringData
function AICoverScoringData.new() return end

---@param props table
---@return AICoverScoringData
function AICoverScoringData.new(props) return end

---@class AICoverSelectionParameters
AICoverSelectionParameters = {}

---@class AICoverSelectionRuntimeData
AICoverSelectionRuntimeData = {}

---@class AICoverSelectionSystem : AIICoverSelectionSystem
AICoverSelectionSystem = {}

---@return AICoverSelectionSystem
function AICoverSelectionSystem.new() return end

---@param props table
---@return AICoverSelectionSystem
function AICoverSelectionSystem.new(props) return end

---@class AICoverTypeCoverSelection : AICoverSelectionParameters
AICoverTypeCoverSelection = {}

---@return AICoverTypeCoverSelection
function AICoverTypeCoverSelection.new() return end

---@param props table
---@return AICoverTypeCoverSelection
function AICoverTypeCoverSelection.new(props) return end

---@class AICustomComponents : AIRelatedComponents
AICustomComponents = {}

---@class AIDeathConditions : AIbehaviorconditionScript
AIDeathConditions = {}

---@class AIDeathReactionsTask : AIbehaviortaskScript
---@field fastForwardAnimation AIArgumentMapping
---@field hitData animAnimFeature_HitReactionsData
---@field hitReactionAction ActionHitReactionScriptProxy
---@field previousRagdollTimeStamp Float
---@field deathHasBeenPlayed Bool
---@field updateFrame Int32
AIDeathReactionsTask = {}

---@param owner ScriptedPuppet
---@return Bool
function AIDeathReactionsTask.ShouldUseRagdoll(owner) return end

---@param context AIbehaviorScriptExecutionContext
function AIDeathReactionsTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param hitData animAnimFeature_HitReactionsData
---@return Float
function AIDeathReactionsTask:AngleToAttackSource(context, hitData) return end

---@param context AIbehaviorScriptExecutionContext
---@return animAnimFeature_HitReactionsData
function AIDeathReactionsTask:BrainMeltDeathData(context) return end

---@return Bool
function AIDeathReactionsTask:CanSkipDeathAnimation() return end

---@param context AIbehaviorScriptExecutionContext
function AIDeathReactionsTask:ChangeHighLevelState(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIDeathReactionsTask:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Int32
function AIDeathReactionsTask:GetDeathReactionType(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return animAnimFeature_HitReactionsData
function AIDeathReactionsTask:GetHitData(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDeathReactionsTask:IsFloorSteepEnoughToRagdoll(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDeathReactionsTask:PlayHitReactionAction(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDeathReactionsTask:ShouldFastForward(context) return end

---@param puppet ScriptedPuppet
function AIDeathReactionsTask:SpawnBloodPuddle(puppet) return end

---@param context AIbehaviorScriptExecutionContext
function AIDeathReactionsTask:StopMotionExtraction(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param activationReason CName|string
function AIDeathReactionsTask:TurnOnRagdoll(context, activationReason) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIDeathReactionsTask:Update(context) return end

---@class AIDebugConditions : AIbehaviorconditionScript
AIDebugConditions = {}

---@class AIDebugLogScope
---@field index Uint32
---@field id Uint32
AIDebugLogScope = {}

---@return AIDebugLogScope
function AIDebugLogScope.new() return end

---@param props table
---@return AIDebugLogScope
function AIDebugLogScope.new(props) return end

---@class AIDefAI : AIResourceReference
AIDefAI = {}

---@return AIDefAI
function AIDefAI.new() return end

---@param props table
---@return AIDefAI
function AIDefAI.new(props) return end

---@class AIDefTreeVariableComparison : LibTreeDefTreeVariableBoolBase
---@field exportAsProperty Bool
---@field referenceVariableId Uint16
---@field referenceVariableName CName
---@field referenceVariableShortName CName
---@field referenceType CName
---@field operator EComparisonType
---@field referenceValue Variant
AIDefTreeVariableComparison = {}

---@return AIDefTreeVariableComparison
function AIDefTreeVariableComparison.new() return end

---@param props table
---@return AIDefTreeVariableComparison
function AIDefTreeVariableComparison.new(props) return end

---@class AIDeviceFeedbackData : AIbehaviortaskScript
AIDeviceFeedbackData = {}

---@return AIDeviceFeedbackData
function AIDeviceFeedbackData.new() return end

---@param props table
---@return AIDeviceFeedbackData
function AIDeviceFeedbackData.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIDeviceFeedbackData:Activate(context) return end

---@class AIDirectorSystemSquadAudioMember : AISquadAudioMemberBase
AIDirectorSystemSquadAudioMember = {}

---@return AIDirectorSystemSquadAudioMember
function AIDirectorSystemSquadAudioMember.new() return end

---@param props table
---@return AIDirectorSystemSquadAudioMember
function AIDirectorSystemSquadAudioMember.new(props) return end

---@class AIDistanceFromOthersCoverSelection : AICoverSelectionParameters
AIDistanceFromOthersCoverSelection = {}

---@return AIDistanceFromOthersCoverSelection
function AIDistanceFromOthersCoverSelection.new() return end

---@param props table
---@return AIDistanceFromOthersCoverSelection
function AIDistanceFromOthersCoverSelection.new(props) return end

---@class AIDriveCommandUpdate : IScriptable
---@field minSpeed Float
---@field maxSpeed Float
---@field clearTrafficOnPath Bool
AIDriveCommandUpdate = {}

---@return AIDriveCommandUpdate
function AIDriveCommandUpdate.new() return end

---@param props table
---@return AIDriveCommandUpdate
function AIDriveCommandUpdate.new(props) return end

---@class AIDriveCommandsDelegate : AIbehaviorScriptBehaviorDelegate
---@field useKinematic Bool
---@field needDriver Bool
---@field splineRef NodeRef
---@field secureTimeOut Float
---@field forcedStartSpeed Float
---@field stopAtPathEnd Bool
---@field driveBackwards Bool
---@field reverseSpline Bool
---@field startFromClosest Bool
---@field keepDistanceBool Bool
---@field keepDistanceCompanion gameObject
---@field keepDistanceDistance Float
---@field rubberBandingBool Bool
---@field rubberBandingTargetRef gameObject
---@field rubberBandingMinDistance Float
---@field rubberBandingMaxDistance Float
---@field rubberBandingStopAndWait Bool
---@field rubberBandingTeleportToCatchUp Bool
---@field rubberBandingStayInFront Bool
---@field audioCurvesParam vehicleAudioCurvesParam
---@field allowSimplifiedMovement Bool
---@field ignoreTickets Bool
---@field disabeStuckDetection Bool
---@field aggressiveRammingEnabled Bool
---@field useSpeedBasedLookupRange Bool
---@field tryDriveAwayFromPlayer Bool
---@field targetPosition Vector3
---@field maxSpeed Float
---@field minSpeed Float
---@field clearTrafficOnPath Bool
---@field minimumDistanceToTarget Float
---@field emergencyPatrol Bool
---@field numPatrolLoops Uint32
---@field driveDownTheRoadIndefinitely Bool
---@field ignoreChaseVehiclesLimit Bool
---@field boostDrivingStats Bool
---@field driveOnSplineCommand AIVehicleOnSplineCommand
---@field useTraffic Bool
---@field speedInTraffic Float
---@field target gameObject
---@field distanceMin Float
---@field distanceMax Float
---@field stopWhenTargetReached Bool
---@field trafficTryNeighborsForStart Bool
---@field trafficTryNeighborsForEnd Bool
---@field driveFollowCommand AIVehicleFollowCommand
---@field driveChaseCommand AIVehicleChaseCommand
---@field drivePanicCommand AIVehiclePanicCommand
---@field driveToPointAutonomousCommand AIVehicleDriveToPointAutonomousCommand
---@field drivePatrolCommand AIVehicleDrivePatrolCommand
---@field nodeRef NodeRef
---@field isPlayer Bool
---@field forceGreenLights Bool
---@field portals vehiclePortalsList
---@field driveToNodeCommand AIVehicleToNodeCommand
---@field driveRacingCommand AIVehicleRacingCommand
---@field driveJoinTrafficCommand AIVehicleJoinTrafficCommand
AIDriveCommandsDelegate = {}

---@return AIDriveCommandsDelegate
function AIDriveCommandsDelegate.new() return end

---@param props table
---@return AIDriveCommandsDelegate
function AIDriveCommandsDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate.DoEndDriveChase(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate.DoEndDrivePanic(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate.DoEndDrivePatrol(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate.DoEndDriveToPointAutonomous(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoEndDriveFollow(context) return end

---@return Bool
function AIDriveCommandsDelegate:DoEndDriveJoinTraffic() return end

---@return Bool
function AIDriveCommandsDelegate:DoEndDriveOnSpline() return end

---@return Bool
function AIDriveCommandsDelegate:DoEndDriveRacing() return end

---@return Bool
function AIDriveCommandsDelegate:DoEndDriveToNode() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveChase(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveFollow(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveJoinTraffic(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveOnSpline(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDrivePanic(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDrivePatrol(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveRacing(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveToNode(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStartDriveToPointAutonomous(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStopDriveChase(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStopDriveFollow(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStopDrivePanic(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStopDrivePatrol(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoStopDriveToPointAutonomous(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoUpdateDriveChase(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoUpdateDriveFollow(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoUpdateDrivePanic(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoUpdateDrivePatrol(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIDriveCommandsDelegate:DoUpdateDriveToPointAutonomous(context) return end

---@class AIDriveFollowCommandHandler : AICommandHandlerBase
---@field outUseKinematic AIArgumentMapping
---@field outNeedDriver AIArgumentMapping
---@field outTarget AIArgumentMapping
---@field outSecureTimeOut AIArgumentMapping
---@field outDistanceMin AIArgumentMapping
---@field outDistanceMax AIArgumentMapping
---@field outStopWhenTargetReached AIArgumentMapping
---@field outUseTraffic AIArgumentMapping
---@field outTrafficTryNeighborsForStart AIArgumentMapping
---@field outTrafficTryNeighborsForEnd AIArgumentMapping
AIDriveFollowCommandHandler = {}

---@return AIDriveFollowCommandHandler
function AIDriveFollowCommandHandler.new() return end

---@param props table
---@return AIDriveFollowCommandHandler
function AIDriveFollowCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIDriveFollowCommandHandler:UpdateCommand(context, command) return end

---@class AIDriveJoinTrafficCommandHandler : AICommandHandlerBase
---@field outUseKinematic AIArgumentMapping
---@field outNeedDriver AIArgumentMapping
AIDriveJoinTrafficCommandHandler = {}

---@return AIDriveJoinTrafficCommandHandler
function AIDriveJoinTrafficCommandHandler.new() return end

---@param props table
---@return AIDriveJoinTrafficCommandHandler
function AIDriveJoinTrafficCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIDriveJoinTrafficCommandHandler:UpdateCommand(context, command) return end

---@class AIDriveOnSplineCommandHandler : AICommandHandlerBase
---@field outUseKinematic AIArgumentMapping
---@field outNeedDriver AIArgumentMapping
---@field outSpline AIArgumentMapping
---@field outSecureTimeOut AIArgumentMapping
---@field outDriveBackwards AIArgumentMapping
---@field outReverseSpline AIArgumentMapping
---@field outStartFromClosest AIArgumentMapping
---@field outForcedStartSpeed AIArgumentMapping
---@field outStopAtPathEnd AIArgumentMapping
---@field outKeepDistanceBool AIArgumentMapping
---@field outKeepDistanceCompanion AIArgumentMapping
---@field outKeepDistanceDistance AIArgumentMapping
---@field outRubberBandingBool AIArgumentMapping
---@field outRubberBandingTargetRef AIArgumentMapping
---@field outRubberBandingMinDistance AIArgumentMapping
---@field outRubberBandingMaxDistance AIArgumentMapping
---@field outRubberBandingStopAndWait AIArgumentMapping
---@field outRubberBandingTeleportToCatchUp AIArgumentMapping
---@field outRubberBandingStayInFront AIArgumentMapping
---@field outAudioCurvesParam AIArgumentMapping
AIDriveOnSplineCommandHandler = {}

---@return AIDriveOnSplineCommandHandler
function AIDriveOnSplineCommandHandler.new() return end

---@param props table
---@return AIDriveOnSplineCommandHandler
function AIDriveOnSplineCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIDriveOnSplineCommandHandler:UpdateCommand(context, command) return end

---@class AIDrivePanicCommandHandler : AICommandHandlerBase
---@field outAllowSimplifiedMovement AIArgumentMapping
---@field outIgnoreTickets AIArgumentMapping
---@field outDisableStuckDetection AIArgumentMapping
---@field outUseSpeedBasedLookupRange AIArgumentMapping
---@field outTryDriveAwayFromPlayer AIArgumentMapping
AIDrivePanicCommandHandler = {}

---@return AIDrivePanicCommandHandler
function AIDrivePanicCommandHandler.new() return end

---@param props table
---@return AIDrivePanicCommandHandler
function AIDrivePanicCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIDrivePanicCommandHandler:UpdateCommand(context, command) return end

---@class AIDrivePatrolUpdate : AIDriveCommandUpdate
---@field numPatrolLoops Uint32
---@field emergencyPatrol Bool
AIDrivePatrolUpdate = {}

---@return AIDrivePatrolUpdate
function AIDrivePatrolUpdate.new() return end

---@param props table
---@return AIDrivePatrolUpdate
function AIDrivePatrolUpdate.new(props) return end

---@return AIVehicleDrivePatrolCommand
function AIDrivePatrolUpdate:CreateCmd() return end

---@class AIDriveRacingCommandHandler : AICommandHandlerBase
---@field outUseKinematic AIArgumentMapping
---@field outNeedDriver AIArgumentMapping
---@field outSpline AIArgumentMapping
---@field outSecureTimeOut AIArgumentMapping
---@field outDriveBackwards AIArgumentMapping
---@field outReverseSpline AIArgumentMapping
---@field outStartFromClosest AIArgumentMapping
---@field outRubberBandingBool AIArgumentMapping
---@field outRubberBandingTargetRef AIArgumentMapping
---@field outRubberBandingMinDistance AIArgumentMapping
---@field outRubberBandingMaxDistance AIArgumentMapping
---@field outRubberBandingStopAndWait AIArgumentMapping
---@field outRubberBandingTeleportToCatchUp AIArgumentMapping
---@field outRubberBandingStayInFront AIArgumentMapping
AIDriveRacingCommandHandler = {}

---@return AIDriveRacingCommandHandler
function AIDriveRacingCommandHandler.new() return end

---@param props table
---@return AIDriveRacingCommandHandler
function AIDriveRacingCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIDriveRacingCommandHandler:UpdateCommand(context, command) return end

---@class AIDriveToNodeCommandHandler : AICommandHandlerBase
---@field outUseKinematic AIArgumentMapping
---@field outNeedDriver AIArgumentMapping
---@field outNodeRef AIArgumentMapping
---@field outSecureTimeOut AIArgumentMapping
---@field outIsPlayer AIArgumentMapping
---@field outUseTraffic AIArgumentMapping
---@field forceGreenLights AIArgumentMapping
---@field portals AIArgumentMapping
---@field outTrafficTryNeighborsForStart AIArgumentMapping
---@field outTrafficTryNeighborsForEnd AIArgumentMapping
AIDriveToNodeCommandHandler = {}

---@return AIDriveToNodeCommandHandler
function AIDriveToNodeCommandHandler.new() return end

---@param props table
---@return AIDriveToNodeCommandHandler
function AIDriveToNodeCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIDriveToNodeCommandHandler:UpdateCommand(context, command) return end

---@class AIDriveToPointAutonomousUpdate : AIDriveCommandUpdate
---@field targetPosition Vector4
---@field minimumDistanceToTarget Float
---@field driveDownTheRoadIndefinitely Bool
AIDriveToPointAutonomousUpdate = {}

---@return AIDriveToPointAutonomousUpdate
function AIDriveToPointAutonomousUpdate.new() return end

---@param props table
---@return AIDriveToPointAutonomousUpdate
function AIDriveToPointAutonomousUpdate.new(props) return end

---@return AIVehicleDriveToPointAutonomousCommand
function AIDriveToPointAutonomousUpdate:CreateCmd() return end

---@class AIDroppedThreatData
---@field threat entEntity
---@field position Vector4
AIDroppedThreatData = {}

---@return AIDroppedThreatData
function AIDroppedThreatData.new() return end

---@param props table
---@return AIDroppedThreatData
function AIDroppedThreatData.new(props) return end

---@class AIEnemy : ISerializable
AIEnemy = {}

---@return AIEnemy
function AIEnemy.new() return end

---@param props table
---@return AIEnemy
function AIEnemy.new(props) return end

---@class AIEnemyPushedToSquad : AIAIEvent
---@field threat entEntity
AIEnemyPushedToSquad = {}

---@return AIEnemyPushedToSquad
function AIEnemyPushedToSquad.new() return end

---@param props table
---@return AIEnemyPushedToSquad
function AIEnemyPushedToSquad.new(props) return end

---@class AIEnemyThreatDetected : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field status Bool
AIEnemyThreatDetected = {}

---@return AIEnemyThreatDetected
function AIEnemyThreatDetected.new() return end

---@param props table
---@return AIEnemyThreatDetected
function AIEnemyThreatDetected.new(props) return end

---@class AIEntityLost : AIAIEvent
---@field spotter entEntity
---@field spotted entEntity
---@field isHostile Bool
AIEntityLost = {}

---@return AIEntityLost
function AIEntityLost.new() return end

---@param props table
---@return AIEntityLost
function AIEntityLost.new(props) return end

---@class AIEntityReuseEvent : AIAIEvent
---@field destination worldGlobalNodeID
AIEntityReuseEvent = {}

---@return AIEntityReuseEvent
function AIEntityReuseEvent.new() return end

---@param props table
---@return AIEntityReuseEvent
function AIEntityReuseEvent.new(props) return end

---@class AIEntitySpotted : AIAIEvent
---@field spotter entEntity
---@field spotted entEntity
---@field isHostile Bool
AIEntitySpotted = {}

---@return AIEntitySpotted
function AIEntitySpotted.new() return end

---@param props table
---@return AIEntitySpotted
function AIEntitySpotted.new(props) return end

---@class AIEntityStubHandlerProviderSystem : AIIEntityStubHandlerProviderSystem
AIEntityStubHandlerProviderSystem = {}

---@return AIEntityStubHandlerProviderSystem
function AIEntityStubHandlerProviderSystem.new() return end

---@param props table
---@return AIEntityStubHandlerProviderSystem
function AIEntityStubHandlerProviderSystem.new(props) return end

---@class AIEquipCommand : AICommand
---@field slotId TweakDBID
---@field itemId TweakDBID
---@field failIfItemNotFound Bool
---@field durationOverride Float
AIEquipCommand = {}

---@return AIEquipCommand
function AIEquipCommand.new() return end

---@param props table
---@return AIEquipCommand
function AIEquipCommand.new(props) return end

---@class AIEvents : IScriptable
AIEvents = {}

---@return AIAIEvent
function AIEvents.ExitVehicleEvent() return end

---@class AIFSMEventTransitionsListDefinition
---@field eventName CName
---@field transitions AIFSMTransitionListDefinition
AIFSMEventTransitionsListDefinition = {}

---@return AIFSMEventTransitionsListDefinition
function AIFSMEventTransitionsListDefinition.new() return end

---@param props table
---@return AIFSMEventTransitionsListDefinition
function AIFSMEventTransitionsListDefinition.new(props) return end

---@class AIFSMStateDefinition
---@field onUpdateTransition AIFSMTransitionListDefinition
---@field onCompleteTransition AIFSMTransitionListDefinition
---@field onSuccessTransition AIFSMTransitionListDefinition
---@field onFailureTransition AIFSMTransitionListDefinition
---@field onInterruptionTransition AIFSMTransitionListDefinition
---@field onEventTransitions AIFSMTransitionListDefinition
---@field childNode AICTreeNodeDefinition
AIFSMStateDefinition = {}

---@return AIFSMStateDefinition
function AIFSMStateDefinition.new() return end

---@param props table
---@return AIFSMStateDefinition
function AIFSMStateDefinition.new(props) return end

---@class AIFSMTransitionDefinition
---@field destination Uint16
---@field condition Uint16
AIFSMTransitionDefinition = {}

---@return AIFSMTransitionDefinition
function AIFSMTransitionDefinition.new() return end

---@param props table
---@return AIFSMTransitionDefinition
function AIFSMTransitionDefinition.new(props) return end

---@class AIFSMTransitionListDefinition
---@field firstTransitionIndex Uint16
---@field transitionsCount Uint16
AIFSMTransitionListDefinition = {}

---@return AIFSMTransitionListDefinition
function AIFSMTransitionListDefinition.new() return end

---@param props table
---@return AIFSMTransitionListDefinition
function AIFSMTransitionListDefinition.new(props) return end

---@class AIFearInPlaceEvent : AIAIEvent
AIFearInPlaceEvent = {}

---@return AIFearInPlaceEvent
function AIFearInPlaceEvent.new() return end

---@param props table
---@return AIFearInPlaceEvent
function AIFearInPlaceEvent.new(props) return end

---@class AIFindForwardPositionAround : AIbehaviortaskScript
AIFindForwardPositionAround = {}

---@return AIFindForwardPositionAround
function AIFindForwardPositionAround.new() return end

---@param props table
---@return AIFindForwardPositionAround
function AIFindForwardPositionAround.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIFindForwardPositionAround:Update(context) return end

---@class AIFindPositionAroundSelf : AIbehaviortaskScript
---@field distanceMin AIArgumentMapping
---@field distanceMax AIArgumentMapping
---@field angle Float
---@field angleOffset Float
---@field outPositionArgument AIArgumentMapping
---@field finalPosition Vector4
AIFindPositionAroundSelf = {}

---@return AIFindPositionAroundSelf
function AIFindPositionAroundSelf.new() return end

---@param props table
---@return AIFindPositionAroundSelf
function AIFindPositionAroundSelf.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIFindPositionAroundSelf:AdditionalOutcomeVerification(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIFindPositionAroundSelf:Update(context) return end

---@class AIFindPositionAroundTarget : AIbehaviortaskScript
AIFindPositionAroundTarget = {}

---@return AIFindPositionAroundTarget
function AIFindPositionAroundTarget.new() return end

---@param props table
---@return AIFindPositionAroundTarget
function AIFindPositionAroundTarget.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIFindPositionAroundTarget:Update(context) return end

---@class AIFlatheadSetSoloModeCommand : AIFollowerCommand
---@field soloModeState Bool
AIFlatheadSetSoloModeCommand = {}

---@return AIFlatheadSetSoloModeCommand
function AIFlatheadSetSoloModeCommand.new() return end

---@param props table
---@return AIFlatheadSetSoloModeCommand
function AIFlatheadSetSoloModeCommand.new(props) return end

---@class AIFlatheadSetSoloModeCommandParams : questScriptedAICommandParams
---@field soloMode Bool
AIFlatheadSetSoloModeCommandParams = {}

---@return AIFlatheadSetSoloModeCommandParams
function AIFlatheadSetSoloModeCommandParams.new() return end

---@param props table
---@return AIFlatheadSetSoloModeCommandParams
function AIFlatheadSetSoloModeCommandParams.new(props) return end

---@return AICommand
function AIFlatheadSetSoloModeCommandParams:CreateCommand() return end

---@return String
function AIFlatheadSetSoloModeCommandParams:GetCommandName() return end

---@class AIFloatArgumentInstancePS : AIArgumentInstancePS
---@field value Float
AIFloatArgumentInstancePS = {}

---@return AIFloatArgumentInstancePS
function AIFloatArgumentInstancePS.new() return end

---@param props table
---@return AIFloatArgumentInstancePS
function AIFloatArgumentInstancePS.new(props) return end

---@class AIFollowSlotDef : gamebbScriptDefinition
---@field slotID gamebbScriptID_Int32
---@field slotTransform gamebbScriptID_Variant
AIFollowSlotDef = {}

---@return AIFollowSlotDef
function AIFollowSlotDef.new() return end

---@param props table
---@return AIFollowSlotDef
function AIFollowSlotDef.new(props) return end

---@return Bool
function AIFollowSlotDef:AutoCreateInSystem() return end

---@class AIFollowTargetCommand : AIMoveCommand
---@field target gameObject
---@field desiredDistance Float
---@field tolerance Float
---@field stopWhenDestinationReached Bool
---@field movementType moveMovementType
---@field lookAtTarget gameObject
---@field matchSpeed Bool
---@field teleport Bool
AIFollowTargetCommand = {}

---@return AIFollowTargetCommand
function AIFollowTargetCommand.new() return end

---@param props table
---@return AIFollowTargetCommand
function AIFollowTargetCommand.new(props) return end

---@class AIFollowerBeforeTakedown : AIbehaviortaskScript
AIFollowerBeforeTakedown = {}

---@return AIFollowerBeforeTakedown
function AIFollowerBeforeTakedown.new() return end

---@param props table
---@return AIFollowerBeforeTakedown
function AIFollowerBeforeTakedown.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIFollowerBeforeTakedown:Update(context) return end

---@class AIFollowerCombatCommand : AIFollowerCommand
AIFollowerCombatCommand = {}

---@return AIFollowerCombatCommand
function AIFollowerCombatCommand.new() return end

---@param props table
---@return AIFollowerCombatCommand
function AIFollowerCombatCommand.new(props) return end

---@class AIFollowerCommand : AICommand
---@field combatCommand Bool
AIFollowerCommand = {}

---@return AIFollowerCommand
function AIFollowerCommand.new() return end

---@param props table
---@return AIFollowerCommand
function AIFollowerCommand.new(props) return end

---@return Bool
function AIFollowerCommand:IsCombatCommand() return end

---@class AIFollowerDeviceCommand : AIFollowerCommand
---@field target gameObject
---@field overrideMovementTarget gameObject
AIFollowerDeviceCommand = {}

---@return AIFollowerDeviceCommand
function AIFollowerDeviceCommand.new() return end

---@param props table
---@return AIFollowerDeviceCommand
function AIFollowerDeviceCommand.new(props) return end

---@class AIFollowerInterpolateFollowingSpeed : AIbehaviortaskScript
---@field enterCondition TweakDBID
---@field exitCondition TweakDBID
---@field minInterpolationDistanceToDestination Float
---@field maxInterpolationDistanceToDestination Float
---@field maxTimeDilation Float
---@field enterConditionInstance gamedataAIActionCondition_Record
---@field exitConditionInstace gamedataAIActionCondition_Record
---@field isActive Bool
---@field reason CName
AIFollowerInterpolateFollowingSpeed = {}

---@return AIFollowerInterpolateFollowingSpeed
function AIFollowerInterpolateFollowingSpeed.new() return end

---@param props table
---@return AIFollowerInterpolateFollowingSpeed
function AIFollowerInterpolateFollowingSpeed.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIFollowerInterpolateFollowingSpeed:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIFollowerInterpolateFollowingSpeed:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIFollowerInterpolateFollowingSpeed:MakeActive(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIFollowerInterpolateFollowingSpeed:MakeInactive(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIFollowerInterpolateFollowingSpeed:Update(context) return end

---@class AIFollowerRole : AIRole
---@field followerRef gameEntityReference
---@field followTarget gameObject
---@field owner gameObject
---@field attitudeGroupName CName
---@field followTargetSquads CName[]
---@field playerCombatListener redCallbackObject
---@field lastStealthLeaveTimeStamp EngineTime
---@field friendlyTargetSlotListener gameAttachmentSlotsScriptListener
---@field ownerTargetSlotListener gameAttachmentSlotsScriptListener
---@field isFriendMelee Bool
---@field isOwnerSniper Bool
AIFollowerRole = {}

---@return AIFollowerRole
function AIFollowerRole.new() return end

---@param props table
---@return AIFollowerRole
function AIFollowerRole.new(props) return end

---@param owner gameObject
---@param ownAttitudeAgent gameAttitudeAgent
---@param followTarget gameObject
---@return Bool
function AIFollowerRole:ChangeAttitude(owner, ownAttitudeAgent, followTarget) return end

---@param owner gameObject
---@return Bool, gameObject
function AIFollowerRole:FindFollowTarget(owner) return end

---@return gameObject
function AIFollowerRole:GetFollowTarget() return end

---@return gameEntityReference
function AIFollowerRole:GetFollowerRef() return end

---@return EAIRole
function AIFollowerRole:GetRoleEnum() return end

---@return TweakDBID
function AIFollowerRole:GetTweakRecordId() return end

---@param owner ScriptedPuppet
function AIFollowerRole:JoinFollowTargetSquads(owner) return end

---@param owner ScriptedPuppet
function AIFollowerRole:LeaveFollowTargetSquads(owner) return end

---@param itemID ItemID
function AIFollowerRole:OnFriendlyTargetWeaponChange(itemID) return end

---@param owner gameObject
---@param newState gamedataNPCHighLevelState
---@param previousState gamedataNPCHighLevelState
function AIFollowerRole:OnHighLevelStateEnter(owner, newState, previousState) return end

---@param owner gameObject
---@param leftState gamedataNPCHighLevelState
---@param nextState gamedataNPCHighLevelState
function AIFollowerRole:OnHighLevelStateExit(owner, leftState, nextState) return end

---@param itemID ItemID
function AIFollowerRole:OnOwnerWeaponChange(itemID) return end

---@param owner gameObject
function AIFollowerRole:OnRoleCleared(owner) return end

---@param owner gameObject
function AIFollowerRole:OnRoleSet(owner) return end

---@param owner ScriptedPuppet
---@param player PlayerPuppet
function AIFollowerRole:RegisterToPlayerCombat(owner, player) return end

---@param followTarget gameObject
function AIFollowerRole:SetFollowTarget(followTarget) return end

---@param owner ScriptedPuppet
---@param player PlayerPuppet
function AIFollowerRole:UnregisterToPlayerCombat(owner, player) return end

function AIFollowerRole:UpdateSpatialsMultiplier() return end

---@class AIFollowerSquad : AISquadBase
AIFollowerSquad = {}

---@return AIFollowerSquad
function AIFollowerSquad.new() return end

---@param props table
---@return AIFollowerSquad
function AIFollowerSquad.new(props) return end

---@class AIFollowerSquadMember : AISquadNPCMember
AIFollowerSquadMember = {}

---@return AIFollowerSquadMember
function AIFollowerSquadMember.new() return end

---@param props table
---@return AIFollowerSquadMember
function AIFollowerSquadMember.new(props) return end

---@class AIFollowerTakedownCommand : AIFollowerCommand
---@field targetRef gameEntityReference
---@field approachBeforeTakedown Bool
---@field doNotTeleportIfTargetIsVisible Bool
---@field target gameObject
AIFollowerTakedownCommand = {}

---@return AIFollowerTakedownCommand
function AIFollowerTakedownCommand.new() return end

---@param props table
---@return AIFollowerTakedownCommand
function AIFollowerTakedownCommand.new(props) return end

---@class AIFollowerTakedownCommandDelegate : AIbehaviorScriptBehaviorDelegate
---@field inCommand AIArgumentMapping
---@field approachBeforeTakedown Bool
---@field doNotTeleportIfTargetIsVisible Bool
AIFollowerTakedownCommandDelegate = {}

---@return AIFollowerTakedownCommandDelegate
function AIFollowerTakedownCommandDelegate.new() return end

---@param props table
---@return AIFollowerTakedownCommandDelegate
function AIFollowerTakedownCommandDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIFollowerTakedownCommandDelegate:OnActivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIFollowerTakedownCommandDelegate:OnDeactivate(context) return end

---@class AIFollowerTakedownCommandHandler : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AIFollowerTakedownCommandHandler = {}

---@return AIFollowerTakedownCommandHandler
function AIFollowerTakedownCommandHandler.new() return end

---@param props table
---@return AIFollowerTakedownCommandHandler
function AIFollowerTakedownCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIFollowerTakedownCommandHandler:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIFollowerTakedownCommandHandler:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param targetEntityIds entEntityID[]
---@return Bool, gameObject
function AIFollowerTakedownCommandHandler:SelectBestTarget(context, targetEntityIds) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIFollowerTakedownCommandHandler:Update(context) return end

---@class AIFollowerTakedownCommandParams : questScriptedAICommandParams
---@field targetRef gameEntityReference
---@field approachBeforeTakedown Bool
---@field doNotTeleportIfTargetIsVisible Bool
AIFollowerTakedownCommandParams = {}

---@return AIFollowerTakedownCommandParams
function AIFollowerTakedownCommandParams.new() return end

---@param props table
---@return AIFollowerTakedownCommandParams
function AIFollowerTakedownCommandParams.new(props) return end

---@return AICommand
function AIFollowerTakedownCommandParams:CreateCommand() return end

---@return String
function AIFollowerTakedownCommandParams:GetCommandName() return end

---@class AIForceShootCommand : AICombatRelatedCommand
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
AIForceShootCommand = {}

---@return AIForceShootCommand
function AIForceShootCommand.new() return end

---@param props table
---@return AIForceShootCommand
function AIForceShootCommand.new(props) return end

---@class AIForceShootCommandParams : questScriptedAICommandParams
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
AIForceShootCommandParams = {}

---@return AIForceShootCommandParams
function AIForceShootCommandParams.new() return end

---@param props table
---@return AIForceShootCommandParams
function AIForceShootCommandParams.new(props) return end

---@return AICommand
function AIForceShootCommandParams:CreateCommand() return end

---@return String
function AIForceShootCommandParams:GetCommandName() return end

---@class AIFriendlyTargetAngleDistanceCoverSelection : AICoverSelectionParameters
AIFriendlyTargetAngleDistanceCoverSelection = {}

---@return AIFriendlyTargetAngleDistanceCoverSelection
function AIFriendlyTargetAngleDistanceCoverSelection.new() return end

---@param props table
---@return AIFriendlyTargetAngleDistanceCoverSelection
function AIFriendlyTargetAngleDistanceCoverSelection.new(props) return end

---@class AIFriendlyTargetDistanceCoverSelection : AICoverSelectionParameters
AIFriendlyTargetDistanceCoverSelection = {}

---@return AIFriendlyTargetDistanceCoverSelection
function AIFriendlyTargetDistanceCoverSelection.new() return end

---@param props table
---@return AIFriendlyTargetDistanceCoverSelection
function AIFriendlyTargetDistanceCoverSelection.new(props) return end

---@class AIGameToneDetectorSquadAudioMember : AISquadAudioMemberBase
AIGameToneDetectorSquadAudioMember = {}

---@return AIGameToneDetectorSquadAudioMember
function AIGameToneDetectorSquadAudioMember.new() return end

---@param props table
---@return AIGameToneDetectorSquadAudioMember
function AIGameToneDetectorSquadAudioMember.new(props) return end

---@class AIGateSignal
---@field tags CName[]
---@field flags AISignalFlags
---@field priority Float
---@field lifeTime Float
AIGateSignal = {}

---@return AIGateSignal
function AIGateSignal.new() return end

---@param props table
---@return AIGateSignal
function AIGateSignal.new(props) return end

---@param self_ AIGateSignal
---@param flag AISignalFlags
function AIGateSignal.AddFlag(self_, flag) return end

---@param self_ AIGateSignal
---@param tag CName|string
function AIGateSignal.AddTag(self_, tag) return end

---@param self_ AIGateSignal
---@param index Uint32
---@return CName
function AIGateSignal.GetTag(self_, index) return end

---@param self_ AIGateSignal
---@return Uint32
function AIGateSignal.GetTagCount(self_) return end

---@param self_ AIGateSignal
---@param other AIGateSignal
---@return Bool
function AIGateSignal.HasAllTagsOf(self_, other) return end

---@param self_ AIGateSignal
---@param flag AISignalFlags
---@return Bool
function AIGateSignal.HasFlag(self_, flag) return end

---@param self_ AIGateSignal
---@param tag CName|string
---@return Bool
function AIGateSignal.HasTag(self_, tag) return end

---@param self_ AIGateSignal
---@return Bool
function AIGateSignal.IsEmpty(self_) return end

---@class AIGateSignalSender : AIbehaviortaskStackScript
---@field tags CName[]
---@field flags EAIGateSignalFlags[]
---@field priority Float
AIGateSignalSender = {}

---@return AIGateSignalSender
function AIGateSignalSender.new() return end

---@param props table
---@return AIGateSignalSender
function AIGateSignalSender.new(props) return end

---@return String
function AIGateSignalSender:GetEditorSubCaption() return end

---@return CName
function AIGateSignalSender:GetInstanceTypeName() return end

---@return Float
function AIGateSignalSender:GetSignalLifeTime() return end

---@param context AIbehaviorScriptExecutionContext
---@param signalId Uint32
function AIGateSignalSender:OnActivate(context, signalId) return end

---@param context AIbehaviorScriptExecutionContext
---@param signalId Uint32
function AIGateSignalSender:OnDeactivate(context, signalId) return end

---@class AIGenericAdvancedLookatTask : AIGenericLookatTask
---@field lookAtEvent entLookAtAddEvent
---@field activationTimeStamp Float
---@field lookatTarget entEntity
AIGenericAdvancedLookatTask = {}

---@param context AIbehaviorScriptExecutionContext
function AIGenericAdvancedLookatTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIGenericAdvancedLookatTask:ActivateLookat(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param instant Bool
function AIGenericAdvancedLookatTask:DeactivateLookat(context, instant) return end

---@param context AIbehaviorScriptExecutionContext
---@return gameObject
function AIGenericAdvancedLookatTask:GetAimingLookatTarget(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIGenericAdvancedLookatTask:ShouldLookatBeActive(context) return end

---@class AIGenericEntityLookatTask : AIGenericLookatTask
---@field lookAtEvent entLookAtAddEvent
---@field activationTimeStamp Float
---@field lookatTarget entEntity
AIGenericEntityLookatTask = {}

---@param context AIbehaviorScriptExecutionContext
function AIGenericEntityLookatTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIGenericEntityLookatTask:ActivateLookat(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param instant Bool
function AIGenericEntityLookatTask:DeactivateLookat(context, instant) return end

---@param context AIbehaviorScriptExecutionContext
---@return gameObject
function AIGenericEntityLookatTask:GetAimingLookatTarget(context) return end

---@return entLookAtAddEvent
function AIGenericEntityLookatTask:GetLookAtEvent() return end

---@param lookAtEvent entLookAtAddEvent
function AIGenericEntityLookatTask:SetLookAtEvent(lookAtEvent) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIGenericEntityLookatTask:ShouldLookatBeActive(context) return end

---@class AIGenericLookatTask : AILookatTask
AIGenericLookatTask = {}

---@param context AIbehaviorScriptExecutionContext
function AIGenericLookatTask:ActivateLookat(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIGenericLookatTask:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param instant Bool
function AIGenericLookatTask:DeactivateLookat(context, instant) return end

---@param context AIbehaviorScriptExecutionContext
---@param instant Bool
function AIGenericLookatTask:DeactivateLookatInternal(context, instant) return end

---@return animLookAtLimitDegreesType
function AIGenericLookatTask:GetBackLimitDegreesType() return end

---@return animLookAtLimitDegreesType
function AIGenericLookatTask:GetHardLimitDegreesType() return end

---@return animLookAtLimitDistanceType
function AIGenericLookatTask:GetHardLimitDistanceType() return end

---@return Bool
function AIGenericLookatTask:GetHasOutTransition() return end

---@return Float
function AIGenericLookatTask:GetLookActivationDelay() return end

---@return Float
function AIGenericLookatTask:GetLookAtDeactivationDelay() return end

---@return entLookAtAddEvent
function AIGenericLookatTask:GetLookAtEvent() return end

---@return CName
function AIGenericLookatTask:GetLookAtSlotName() return end

---@return animLookAtStyle
function AIGenericLookatTask:GetLookatStyle() return end

---@return animLookAtStyle
function AIGenericLookatTask:GetOutTransitionStyle() return end

---@return animLookAtLimitDegreesType
function AIGenericLookatTask:GetSoftLimitDegreesType() return end

---@param lookAtEvent entLookAtAddEvent
function AIGenericLookatTask:SetLookAtEvent(lookAtEvent) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIGenericLookatTask:ShouldLookatBeActive(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIGenericLookatTask:Update(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIGenericLookatTask:UpdateLookat(context) return end

---@class AIGenericStaticLookatTask : AIGenericLookatTask
---@field lookAtEvent entLookAtAddEvent
---@field activationTimeStamp Float
---@field lookatTarget Vector4
---@field currentLookatTarget Vector4
AIGenericStaticLookatTask = {}

---@param context AIbehaviorScriptExecutionContext
function AIGenericStaticLookatTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIGenericStaticLookatTask:ActivateLookat(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param instant Bool
function AIGenericStaticLookatTask:DeactivateLookat(context, instant) return end

---@param context AIbehaviorScriptExecutionContext
---@return Vector4
function AIGenericStaticLookatTask:GetAimingLookatTarget(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIGenericStaticLookatTask:ShouldLookatBeActive(context) return end

---@class AIGuardArea
AIGuardArea = {}

---@return AIGuardArea
function AIGuardArea.new() return end

---@param props table
---@return AIGuardArea
function AIGuardArea.new(props) return end

---@class AIGuardAreaConnectedCommunity
---@field communityArea gameEntityReference
---@field isPrimary Bool
AIGuardAreaConnectedCommunity = {}

---@return AIGuardAreaConnectedCommunity
function AIGuardAreaConnectedCommunity.new() return end

---@param props table
---@return AIGuardAreaConnectedCommunity
function AIGuardAreaConnectedCommunity.new(props) return end

---@class AIGuardAreaManager : AIIGuardAreaManager
AIGuardAreaManager = {}

---@return AIGuardAreaManager
function AIGuardAreaManager.new() return end

---@param props table
---@return AIGuardAreaManager
function AIGuardAreaManager.new(props) return end

---@param npcEntityID entEntityID
---@param restrictMovementArea NodeRef
---@return Bool
function AIGuardAreaManager:AssignRestrictMovementArea(npcEntityID, restrictMovementArea) return end

---@param npcEntityID entEntityID
---@param referencePoint Vector4
---@return Bool, Vector4
function AIGuardAreaManager:FindPointInRestrictMovementArea(npcEntityID, referencePoint) return end

---@param area AIScriptGuardArea
---@return entEntityID[]
function AIGuardAreaManager:GetAllPuppetsInRestrictMovementArea(area) return end

---@param npcEntityID entEntityID
---@return Bool
function AIGuardAreaManager:HasAssignedRestrictMovementArea(npcEntityID) return end

---@param npcEntityID entEntityID
---@param point Vector4
---@return Bool
function AIGuardAreaManager:IsPointInPursuitZone(npcEntityID, point) return end

---@param npcEntityID entEntityID
---@param point Vector4
---@param onlyActualArea Bool
---@return Bool
function AIGuardAreaManager:IsPointInRestrictMovementArea(npcEntityID, point, onlyActualArea) return end

---@class AIGuardAreaSavedData
---@field puppetId entEntityID
---@field nodeRef NodeRef
AIGuardAreaSavedData = {}

---@return AIGuardAreaSavedData
function AIGuardAreaSavedData.new() return end

---@param props table
---@return AIGuardAreaSavedData
function AIGuardAreaSavedData.new(props) return end

---@class AIGuardAreasSavedState : ISerializable
---@field data AIGuardAreaSavedData[]
---@field cleared entEntityID[]
AIGuardAreasSavedState = {}

---@return AIGuardAreasSavedState
function AIGuardAreasSavedState.new() return end

---@param props table
---@return AIGuardAreasSavedState
function AIGuardAreasSavedState.new(props) return end

---@class AIHitReactionTask : AIbehaviortaskScript
---@field activationTimeStamp Float
---@field reactionDuration Float
---@field hitReactionAction ActionHitReactionScriptProxy
---@field hitReactionType animHitReactionType
AIHitReactionTask = {}

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param hitData animAnimFeature_HitReactionsData
---@return Float
function AIHitReactionTask:AngleToAttackSource(context, hitData) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIHitReactionTask:CheckForReevaluation(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:Deactivate(context) return end

function AIHitReactionTask:Dispose() return end

---@param context AIbehaviorScriptExecutionContext
---@return CName
function AIHitReactionTask:GetBCVOName(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AIHitReactionTask:GetDesiredHitReactionDuration(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AIHitReactionTask:GetHitReactionDurationWithInterrupt(context) return end

---@return animHitReactionType
function AIHitReactionTask:GetHitReactionType() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIHitReactionTask:HasDismemberedLeg(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:InitialiseReaction(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIHitReactionTask:IsThisFrameActivationFrame(context) return end

---@param hitReaction animAnimFeature_HitReactionsData
---@return Bool
function AIHitReactionTask:IsTumbleStagger(hitReaction) return end

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:OnActivate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:OnDeactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param aiTime Float
function AIHitReactionTask:OnUpdate(context, aiTime) return end

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:SendDataToAnimationGraph(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIHitReactionTask:SendDataToHitReactionComponent(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param gameEffect gameEffectRef
---@param startPosition Vector4
---@param endPosition Vector4
---@param duration Float
---@param colliderBoxSize Vector4
---@param statusEffect String
function AIHitReactionTask:SpawnAttackGameEffect(context, gameEffect, startPosition, endPosition, duration, colliderBoxSize, statusEffect) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIHitReactionTask:Update(context) return end

---@class AIHoldPositionCommand : AIMoveCommand
---@field duration Float
AIHoldPositionCommand = {}

---@return AIHoldPositionCommand
function AIHoldPositionCommand.new() return end

---@param props table
---@return AIHoldPositionCommand
function AIHoldPositionCommand.new(props) return end

---@class AIHoldPositionCommandParams : questScriptedAICommandParams
---@field duration Float
AIHoldPositionCommandParams = {}

---@return AIHoldPositionCommandParams
function AIHoldPositionCommandParams.new() return end

---@param props table
---@return AIHoldPositionCommandParams
function AIHoldPositionCommandParams.new(props) return end

---@return AICommand
function AIHoldPositionCommandParams:CreateCommand() return end

---@return String
function AIHoldPositionCommandParams:GetCommandName() return end

---@class AIHostJoinedSquad : AIAIEvent
---@field squad CName
AIHostJoinedSquad = {}

---@return AIHostJoinedSquad
function AIHostJoinedSquad.new() return end

---@param props table
---@return AIHostJoinedSquad
function AIHostJoinedSquad.new(props) return end

---@class AIHostLeftSquad : AIAIEvent
---@field squadInterface AISquadScriptInterface
AIHostLeftSquad = {}

---@return AIHostLeftSquad
function AIHostLeftSquad.new() return end

---@param props table
---@return AIHostLeftSquad
function AIHostLeftSquad.new(props) return end

---@class AIHostileThreatDetected : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field status Bool
AIHostileThreatDetected = {}

---@return AIHostileThreatDetected
function AIHostileThreatDetected.new() return end

---@param props table
---@return AIHostileThreatDetected
function AIHostileThreatDetected.new(props) return end

---@class AIHumanComponent : AICAgent
---@field movementParamsRecord TweakDBID
---@field shootingBlackboard gameIBlackboard
---@field gadgetBlackboard gameIBlackboard
---@field coverBlackboard gameIBlackboard
---@field actionBlackboard gameIBlackboard
---@field patrolBlackboard gameIBlackboard
---@field alertedPatrolBlackboard gameIBlackboard
---@field prereqsBlackboard gameIBlackboard
---@field friendlyFireCheckID Uint32
---@field ffs gameIFriendlyFireSystem
---@field LoSFinderCheckID Uint32
---@field loSFinderSystem gameLoSIFinderSystem
---@field LoSFinderVisibleObject senseVisibleObject
---@field actionAnimationScriptProxy ActionAnimationScriptProxy
---@field lastOwnerBlockedAttackEventID gameDelayID
---@field lastOwnerParriedAttackEventID gameDelayID
---@field lastOwnerDodgedAttackEventID gameDelayID
---@field grenadeThrowQueryTarget gameObject
---@field grenadeThrowQueryId Int32
---@field scriptContext AIbehaviorScriptExecutionContext
---@field scriptContextInitialized Bool
---@field kerenzikovAbilityRecord gamedataGameplayAbility_Record
---@field highLevelCb Uint32
---@field lastReservedSeatVehicle entEntityID
---@field assignedVehicleStuck Bool
---@field activeCommands AIbehaviorUniqueActiveCommandList
AIHumanComponent = {}

---@return AIHumanComponent
function AIHumanComponent.new() return end

---@param props table
---@return AIHumanComponent
function AIHumanComponent.new(props) return end

---@param owner ScriptedPuppet
---@return Bool, AIHumanComponent
function AIHumanComponent.Get(owner) return end

---@param owner ScriptedPuppet
---@return Bool, gameObject
function AIHumanComponent.GetAssignedVehicle(owner) return end

---@param owner ScriptedPuppet
---@return Bool, CName
function AIHumanComponent.GetLastUsedVehicleSlot(owner) return end

---@param owner ScriptedPuppet
---@return Bool, gamemountingMountingSlotId
function AIHumanComponent.GetLastUsedVehicleSlot(owner) return end

---@param puppet ScriptedPuppet
---@return Bool, AIbehaviorScriptExecutionContext
function AIHumanComponent.GetScriptContext(puppet) return end

---@param owner gameObject
---@param newRole AIRole
function AIHumanComponent.SetCurrentRole(owner, newRole) return end

---@return entEntityID
function AIHumanComponent:GetAssignedVehicleId() return end

---@return gamemountingMountingSlotId
function AIHumanComponent:GetAssignedVehicleSlot() return end

---@param type moveMovementType
---@return moveMovementParameters
function AIHumanComponent:GetMovementParams(type) return end

---@return Bool
function AIHumanComponent:HasVehicleAssigned() return end

---@param params moveMovementParameters
function AIHumanComponent:SetMovementParams(params) return end

---@param paramsID TweakDBID|string
---@return Bool
function AIHumanComponent:SetTDBMovementParams(paramsID) return end

---@return Bool
function AIHumanComponent:WasForcedToEnterCrowd() return end

---@param evt entAnimParamsEvent
---@return Bool
function AIHumanComponent:OnAnimParamsEvent(evt) return end

---@param evt gameeventsDeathEvent
---@return Bool
function AIHumanComponent:OnDeath(evt) return end

---@param evt gameeventsDefeatedEvent
---@return Bool
function AIHumanComponent:OnDefeated(evt) return end

---@param evt DelayPassiveConditionEvaluationEvent
---@return Bool
function AIHumanComponent:OnDelayPassiveConditionEvaluationEvent(evt) return end

---@param evt AIEnemyThreatDetected
---@return Bool
function AIHumanComponent:OnEnemyThreatDetected(evt) return end

---@param hitAIEvent AIAIEvent
---@return Bool
function AIHumanComponent:OnHitAiEventReceived(hitAIEvent) return end

---@param evt AIHostileThreatDetected
---@return Bool
function AIHumanComponent:OnHostileThreatDetected(evt) return end

---@param evt AINewThreat
---@return Bool
function AIHumanComponent:OnNewThreat(evt) return end

---@param value Int32
---@return Bool
function AIHumanComponent:OnPlayerCombatChanged(value) return end

---@param evt ReserveAssignedSeat
---@return Bool
function AIHumanComponent:OnReserveAssignedSeat(evt) return end

---@param evt SetScriptExecutionContextEvent
---@return Bool
function AIHumanComponent:OnSetScriptExecutionContext(evt) return end

---@param evt StartGrenadeThrowQueryEvent
---@return Bool
function AIHumanComponent:OnStartGrenadeThrowQueryEvent(evt) return end

---@param evt gameeventsApplyStatusEffectEvent
---@return Bool
function AIHumanComponent:OnStatusEffectApplied(evt) return end

---@param evt gameeventsApplyStatusEffectEvent
---@return Bool
function AIHumanComponent:OnStatusEffectRemoved(evt) return end

---@param evt vehicleVehicleStuckEvent
---@return Bool
function AIHumanComponent:OnStuckEvent(evt) return end

---@param evt AIThreatRemoved
---@return Bool
function AIHumanComponent:OnThreatRemoved(evt) return end

---@param evt gameMountAIEvent
---@return Bool
function AIHumanComponent:OnVehicleAssign(evt) return end

---@param target gameObject
---@return Bool
function AIHumanComponent:CacheThrowGrenadeAtTargetQuery(target) return end

---@param target gameObject
---@return Bool, Vector4, Float, gameGrenadeThrowStartType
function AIHumanComponent:CanThrowGrenadeAtTarget(target) return end

---@param ActionConditionName String
---@return Bool
function AIHumanComponent:CheckTweakCondition(ActionConditionName) return end

---@param commandClassNames CName[]|string[]
function AIHumanComponent:ClearActionCommandID(commandClassNames) return end

---@return Bool
function AIHumanComponent:CombatQueriesSystemInit() return end

---@return Bool
function AIHumanComponent:FriendlyFireCheck() return end

---@return Bool
function AIHumanComponent:FriendlyFireCheckInit() return end

function AIHumanComponent:FriendlyFireTargetUpdateInit() return end

---@return gameIBlackboard
function AIHumanComponent:GetAIAlertedPatrolBlackboard() return end

---@return gameIBlackboard
function AIHumanComponent:GetAIPatrolBlackboard() return end

---@return gameIBlackboard
function AIHumanComponent:GetAIPrereqsBlackboard() return end

---@return ActionAnimationScriptProxy
function AIHumanComponent:GetActionAnimationScriptProxy() return end

---@return gameIBlackboard
function AIHumanComponent:GetActionBlackboard() return end

---@param commandClassName CName|string
---@return Int32
function AIHumanComponent:GetActiveCommandID(commandClassName) return end

---@return Int32
function AIHumanComponent:GetActiveCommandsCount() return end

---@return Bool, gameObject
function AIHumanComponent:GetAssignedVehicle() return end

---@return Bool, entEntityID, gamemountingMountingSlotId
function AIHumanComponent:GetAssignedVehicleData() return end

---@return gameIBlackboard
function AIHumanComponent:GetCombatGadgetBlackboard() return end

---@return gameIBlackboard
function AIHumanComponent:GetCoverBlackboard() return end

---@return AIRole
function AIHumanComponent:GetCurrentRole() return end

---@return Uint32
function AIHumanComponent:GetFriendlyFireCheckID() return end

---@return Bool, gameObject
function AIHumanComponent:GetFriendlyTarget() return end

---@return Bool, PlayerPuppet
function AIHumanComponent:GetFriendlyTargetAsPlayer() return end

---@return ScriptGameInstance
function AIHumanComponent:GetGame() return end

---@param ownerId entEntityID
---@param entityPos Vector4
---@param losMode Int32
---@param radiusXY Float
---@param radiusZ Float
---@param maxNotFoundTime Float
---@return Bool
function AIHumanComponent:GetReachedLoSPosition(ownerId, entityPos, losMode, radiusXY, radiusZ, maxNotFoundTime) return end

---@return Bool, AIbehaviorScriptExecutionContext
function AIHumanComponent:GetScriptContext() return end

---@return gameIBlackboard
function AIHumanComponent:GetShootingBlackboard() return end

---@param entityID entEntityID
---@return Bool, vehicleBaseObject
function AIHumanComponent:GetVehicleHandle(entityID) return end

---@return Bool
function AIHumanComponent:IsAssignedVehicleStuck() return end

---@param commandClassName CName|string
---@return Bool
function AIHumanComponent:IsCommandActive(commandClassName) return end

---@param commandID Uint32
---@return Bool
function AIHumanComponent:IsCommandActive(commandID) return end

---@param commandClassName CName|string
---@return Bool
function AIHumanComponent:IsCommandReceivedOrOverriden(commandClassName) return end

---@param commandID Uint32
---@return Bool
function AIHumanComponent:IsCommandReceivedOrOverriden(commandID) return end

---@return Bool
function AIHumanComponent:IsFriendlyFiring() return end

---@return Bool
function AIHumanComponent:IsPlayerCompanion() return end

---@return Bool
function AIHumanComponent:LoSFinderCheckInit() return end

function AIHumanComponent:NULLCachedThrowGrenadeAtTargetQuery() return end

---@param newRole AIRole
---@param oldRole AIRole
function AIHumanComponent:OnAIRoleChanged(newRole, oldRole) return end

function AIHumanComponent:OnAttach() return end

---@param command AICommand
---@param oldState AICommandState
---@param newState AICommandState
function AIHumanComponent:OnCommandStateChanged(command, oldState, newState) return end

function AIHumanComponent:OnDetach() return end

---@param vehicleID entEntityID
function AIHumanComponent:OnSeatReserved(vehicleID) return end

---@param signalId Uint16
---@param newValue Bool
function AIHumanComponent:OnSignalCombatQueriesRequest(signalId, newValue) return end

---@param signalId Uint16
---@param newValue Bool
function AIHumanComponent:OnSignalCommandSignal(signalId, newValue) return end

function AIHumanComponent:ReleaseReservedSeat() return end

function AIHumanComponent:ResetBehaviorCoverArguments() return end

---@param target gameObject
function AIHumanComponent:StartGrenadeThrowQuery(target) return end

---@param commandClassNames CName[]|string[]
function AIHumanComponent:TrackActionCommandID(commandClassNames) return end

---@return Bool
function AIHumanComponent:TryBulletDodgeOpportunity() return end

---@param resetBB Bool
function AIHumanComponent:UpdateMyAttackBlockedCount(resetBB) return end

---@param resetBB Bool
function AIHumanComponent:UpdateMyAttackDodgedCount(resetBB) return end

---@param resetBB Bool
function AIHumanComponent:UpdateMyAttackParriedCount(resetBB) return end

---@class AIHumanComponentPS : AICommandQueuePS
---@field spotUsageToken AISpotUsageToken
AIHumanComponentPS = {}

---@return AIHumanComponentPS
function AIHumanComponentPS.new() return end

---@param props table
---@return AIHumanComponentPS
function AIHumanComponentPS.new(props) return end

---@class AIIArchetypeManager : gameIGameSystem
AIIArchetypeManager = {}

---@class AIICombatGuardAreaCondition : IScriptable
AIICombatGuardAreaCondition = {}

---@class AIICommandsManager : gameIGameSystem
AIICommandsManager = {}

---@class AIICoverSelectionSystem : gameIGameSystem
AIICoverSelectionSystem = {}

---@class AIIEntityStubHandlerProviderSystem : gameIGameSystem
AIIEntityStubHandlerProviderSystem = {}

---@class AIIGuardAreaManager : gameIGameSystem
AIIGuardAreaManager = {}

---@class AIIInformationSpreadSystem : gameIGameSystem
AIIInformationSpreadSystem = {}

---@class AIINavigationSystem : gameIGameSystem
AIINavigationSystem = {}

function AIINavigationSystem:GetResult() return end

function AIINavigationSystem:StartPathfinding() return end

function AIINavigationSystem:StopPathfinding() return end

---@class AIIObjectSelectionDebugProxy
AIIObjectSelectionDebugProxy = {}

---@class AIIReactionSystem : gameIGameSystem
AIIReactionSystem = {}

---@class AIISafeAreaManager : gameIGameSystem
AIISafeAreaManager = {}

---@class AIISerializableArgumentInstancePS : AIArgumentInstancePS
---@field value ISerializable
AIISerializableArgumentInstancePS = {}

---@return AIISerializableArgumentInstancePS
function AIISerializableArgumentInstancePS.new() return end

---@param props table
---@return AIISerializableArgumentInstancePS
function AIISerializableArgumentInstancePS.new(props) return end

---@class AIISmartCoverManager : gameIGameSystem
AIISmartCoverManager = {}

---@class AIISmartObjectManager : gameIGameSystem
AIISmartObjectManager = {}

---@class AIISquadManager : gameIGameSystem
AIISquadManager = {}

---@class AIISystem : gameIGameSystem
AIISystem = {}

---@class AIITarget
AIITarget = {}

---@class AIITargetTrackingListener : IScriptable
AIITargetTrackingListener = {}

---@class AIITrafficMovementSystem : gameIGameSystem
AIITrafficMovementSystem = {}

---@class AIIVehicleCoversSystem : gameIGameSystem
AIIVehicleCoversSystem = {}

---@class AIIWorkspotManager : gameIGameSystem
AIIWorkspotManager = {}

---@class AIInjectCombatTargetCommand : AICombatRelatedCommand
---@field targetNodeRef NodeRef
---@field targetPuppetRef gameEntityReference
---@field duration Float
AIInjectCombatTargetCommand = {}

---@return AIInjectCombatTargetCommand
function AIInjectCombatTargetCommand.new() return end

---@param props table
---@return AIInjectCombatTargetCommand
function AIInjectCombatTargetCommand.new(props) return end

---@class AIInjectCombatThreatCommand : AICombatRelatedCommand
---@field targetNodeRef NodeRef
---@field targetPuppetRef gameEntityReference
---@field dontForceHostileAttitude Bool
---@field duration Float
---@field isPersistent Bool
AIInjectCombatThreatCommand = {}

---@return AIInjectCombatThreatCommand
function AIInjectCombatThreatCommand.new() return end

---@param props table
---@return AIInjectCombatThreatCommand
function AIInjectCombatThreatCommand.new(props) return end

---@class AIInjectCombatThreatCommandParams : questScriptedAICommandParams
---@field targetNodeRef NodeRef
---@field targetPuppetRef gameEntityReference
---@field dontForceHostileAttitude Bool
---@field duration Float
---@field isPersistent Bool
AIInjectCombatThreatCommandParams = {}

---@return AIInjectCombatThreatCommandParams
function AIInjectCombatThreatCommandParams.new() return end

---@param props table
---@return AIInjectCombatThreatCommandParams
function AIInjectCombatThreatCommandParams.new(props) return end

---@return AICommand
function AIInjectCombatThreatCommandParams:CreateCommand() return end

---@return String
function AIInjectCombatThreatCommandParams:GetCommandName() return end

---@class AIInjectLookatTargetCommand : AICombatRelatedCommand
---@field targetNodeRef NodeRef
---@field targetPuppetRef gameEntityReference
---@field duration Float
AIInjectLookatTargetCommand = {}

---@return AIInjectLookatTargetCommand
function AIInjectLookatTargetCommand.new() return end

---@param props table
---@return AIInjectLookatTargetCommand
function AIInjectLookatTargetCommand.new(props) return end

---@class AIInt32ArgumentInstancePS : AIArgumentInstancePS
---@field value Int32
AIInt32ArgumentInstancePS = {}

---@return AIInt32ArgumentInstancePS
function AIInt32ArgumentInstancePS.new() return end

---@param props table
---@return AIInt32ArgumentInstancePS
function AIInt32ArgumentInstancePS.new(props) return end

---@class AIInt64ArgumentInstancePS : AIArgumentInstancePS
---@field value Int64
AIInt64ArgumentInstancePS = {}

---@return AIInt64ArgumentInstancePS
function AIInt64ArgumentInstancePS.new() return end

---@param props table
---@return AIInt64ArgumentInstancePS
function AIInt64ArgumentInstancePS.new(props) return end

---@class AIInterruptionHandlerAllowDefinition : AIInterruptionHandlerDefinition
AIInterruptionHandlerAllowDefinition = {}

---@return AIInterruptionHandlerAllowDefinition
function AIInterruptionHandlerAllowDefinition.new() return end

---@param props table
---@return AIInterruptionHandlerAllowDefinition
function AIInterruptionHandlerAllowDefinition.new(props) return end

---@class AIInterruptionHandlerBehaviorDefinition : AIInterruptionHandlerDefinition
---@field ai LibTreeINodeDefinition
---@field parallelActivation Bool
---@field parallelExecution Bool
---@field blockInterruption Bool
AIInterruptionHandlerBehaviorDefinition = {}

---@return AIInterruptionHandlerBehaviorDefinition
function AIInterruptionHandlerBehaviorDefinition.new() return end

---@param props table
---@return AIInterruptionHandlerBehaviorDefinition
function AIInterruptionHandlerBehaviorDefinition.new(props) return end

---@class AIInterruptionHandlerDefinition : LibTreeINodeDefinition
---@field signal AIInterruptionSignal
---@field supportLessImportantSignals Bool
AIInterruptionHandlerDefinition = {}

---@class AIInterruptionHandlerDenyDefinition : AIInterruptionHandlerDefinition
AIInterruptionHandlerDenyDefinition = {}

---@return AIInterruptionHandlerDenyDefinition
function AIInterruptionHandlerDenyDefinition.new() return end

---@param props table
---@return AIInterruptionHandlerDenyDefinition
function AIInterruptionHandlerDenyDefinition.new(props) return end

---@class AIInterruptionSignal
---@field importance AIEInterruptionImportance
---@field signal CName
AIInterruptionSignal = {}

---@return AIInterruptionSignal
function AIInterruptionSignal.new() return end

---@param props table
---@return AIInterruptionSignal
function AIInterruptionSignal.new(props) return end

---@class AIItemHandlingCondition : AIbehaviorconditionScript
AIItemHandlingCondition = {}

---@class AIJoinCrowdCommand : AIMoveCommand
AIJoinCrowdCommand = {}

---@return AIJoinCrowdCommand
function AIJoinCrowdCommand.new() return end

---@param props table
---@return AIJoinCrowdCommand
function AIJoinCrowdCommand.new(props) return end

---@class AIJoinTargetsSquad : AICommand
---@field targetPuppetRef gameEntityReference
AIJoinTargetsSquad = {}

---@return AIJoinTargetsSquad
function AIJoinTargetsSquad.new() return end

---@param props table
---@return AIJoinTargetsSquad
function AIJoinTargetsSquad.new(props) return end

---@class AIJoinTargetsSquadCommandParams : questScriptedAICommandParams
---@field targetPuppetRef gameEntityReference
AIJoinTargetsSquadCommandParams = {}

---@return AIJoinTargetsSquadCommandParams
function AIJoinTargetsSquadCommandParams.new() return end

---@param props table
---@return AIJoinTargetsSquadCommandParams
function AIJoinTargetsSquadCommandParams.new(props) return end

---@return AICommand
function AIJoinTargetsSquadCommandParams:CreateCommand() return end

---@return String
function AIJoinTargetsSquadCommandParams:GetCommandName() return end

---@class AIJoinTargetsSquadTask : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AIJoinTargetsSquadTask = {}

---@return AIJoinTargetsSquadTask
function AIJoinTargetsSquadTask.new() return end

---@param props table
---@return AIJoinTargetsSquadTask
function AIJoinTargetsSquadTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param typedCommand AIJoinTargetsSquad
function AIJoinTargetsSquadTask:CancelCommand(context, typedCommand) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIJoinTargetsSquadTask:Update(context) return end

---@class AIJoinTrafficEvent : AIAIEvent
AIJoinTrafficEvent = {}

---@return AIJoinTrafficEvent
function AIJoinTrafficEvent.new() return end

---@param props table
---@return AIJoinTrafficEvent
function AIJoinTrafficEvent.new(props) return end

---@class AIKeepCurrentCoverSelection : AICoverSelectionParameters
AIKeepCurrentCoverSelection = {}

---@return AIKeepCurrentCoverSelection
function AIKeepCurrentCoverSelection.new() return end

---@param props table
---@return AIKeepCurrentCoverSelection
function AIKeepCurrentCoverSelection.new(props) return end

---@class AILocationInformation
---@field position Vector4
---@field direction Vector4
AILocationInformation = {}

---@return AILocationInformation
function AILocationInformation.new() return end

---@param props table
---@return AILocationInformation
function AILocationInformation.new(props) return end

---@class AILookatTask : AIbehaviortaskScript
AILookatTask = {}

---@class AIMandatoryComponents : AIRelatedComponents
AIMandatoryComponents = {}

---@class AIMeleeAttackCommand : AICombatRelatedCommand
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
AIMeleeAttackCommand = {}

---@return AIMeleeAttackCommand
function AIMeleeAttackCommand.new() return end

---@param props table
---@return AIMeleeAttackCommand
function AIMeleeAttackCommand.new(props) return end

---@class AIMeleeAttackCommandParams : questScriptedAICommandParams
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
AIMeleeAttackCommandParams = {}

---@return AIMeleeAttackCommandParams
function AIMeleeAttackCommandParams.new() return end

---@param props table
---@return AIMeleeAttackCommandParams
function AIMeleeAttackCommandParams.new(props) return end

---@return AICommand
function AIMeleeAttackCommandParams:CreateCommand() return end

---@return String
function AIMeleeAttackCommandParams:GetCommandName() return end

---@class AIMixingOutputSystemSquadAudioMember : AISquadAudioMemberBase
AIMixingOutputSystemSquadAudioMember = {}

---@return AIMixingOutputSystemSquadAudioMember
function AIMixingOutputSystemSquadAudioMember.new() return end

---@param props table
---@return AIMixingOutputSystemSquadAudioMember
function AIMixingOutputSystemSquadAudioMember.new(props) return end

---@class AIMountCommand : AIBaseMountCommand
AIMountCommand = {}

---@return AIMountCommand
function AIMountCommand.new() return end

---@param props table
---@return AIMountCommand
function AIMountCommand.new(props) return end

---@class AIMoveCommand : AICommand
---@field removeAfterCombat Bool
---@field ignoreInCombat Bool
---@field alwaysUseStealth Bool
AIMoveCommand = {}

---@return AIMoveCommand
function AIMoveCommand.new() return end

---@param props table
---@return AIMoveCommand
function AIMoveCommand.new(props) return end

---@class AIMoveCommandsDelegate : AIbehaviorScriptBehaviorDelegate
---@field animMoveOnSplineCommand AIAnimMoveOnSplineCommand
---@field spline NodeRef
---@field useStart Bool
---@field useStop Bool
---@field reverse Bool
---@field controllerSetupName CName
---@field blendTime Float
---@field globalInBlendTime Float
---@field globalOutBlendTime Float
---@field turnCharacterToMatchVelocity Bool
---@field customStartAnimationName CName
---@field customMainAnimationName CName
---@field customStopAnimationName CName
---@field startSnapToTerrain Bool
---@field mainSnapToTerrain Bool
---@field stopSnapToTerrain Bool
---@field startSnapToTerrainBlendTime Float
---@field stopSnapToTerrainBlendTime Float
---@field moveOnSplineCommand AIMoveOnSplineCommand
---@field strafingTarget gameObject
---@field movementType moveMovementType
---@field ignoreNavigation Bool
---@field startFromClosestPoint Bool
---@field splineRecalculation Bool
---@field disableFootIK Bool
---@field useCombatState Bool
---@field useAlertedState Bool
---@field noWaitToEndDistance Float
---@field noWaitToEndCompanionDistance Float
---@field lowestCompanionDistanceToEnd Float
---@field previousCompanionDistanceToEnd Float
---@field maxCompanionDistanceOnSpline Float
---@field companion gameObject
---@field ignoreLineOfSightCheck Bool
---@field shootingTarget gameObject
---@field minSearchAngle Float
---@field maxSearchAngle Float
---@field desiredDistance Float
---@field deadZoneRadius Float
---@field shouldBeInFrontOfCompanion Bool
---@field useMatchForSpeedForPlayer Bool
---@field lookAtTarget gameObject
---@field distanceToCompanion Float
---@field splineEndPoint Vector4
---@field hasSplineEndPoint Bool
---@field playerCompanion PlayerPuppet
---@field firstWaitingDemandTimestamp Float
---@field useOffMeshLinkReservation Bool
---@field allowCrowdOnPath Bool
---@field sprint Bool
---@field run Bool
---@field waitForCompanion Bool
---@field followTargetCommand AIFollowTargetCommand
---@field stopWhenDestinationReached Bool
---@field teleportToTarget Bool
---@field shouldTeleportNow Bool
---@field teleportDestination Vector4
---@field matchTargetSpeed Bool
AIMoveCommandsDelegate = {}

---@return AIMoveCommandsDelegate
function AIMoveCommandsDelegate.new() return end

---@param props table
---@return AIMoveCommandsDelegate
function AIMoveCommandsDelegate.new(props) return end

---@return Bool
function AIMoveCommandsDelegate:DoEndAnimMoveOnSpline() return end

---@return Bool
function AIMoveCommandsDelegate:DoEndMoveOnSpline() return end

---@return Bool
function AIMoveCommandsDelegate:DoEndTeleportToCompanionOnSpline() return end

---@return Bool
function AIMoveCommandsDelegate:DoEndWaitForCompanion() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoFindClosestPointOnSpline(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoFindEndOfTheSpline(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoFindStartOfTheSpline(context) return end

---@return Bool
function AIMoveCommandsDelegate:DoStartAnimMoveOnSpline() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoStartFollowTarget(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoStartMoveOnSpline(context) return end

---@return Bool
function AIMoveCommandsDelegate:DoStartWaitForCompanion() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoUpdateDistanceToCompanionOnSpline(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIMoveCommandsDelegate:DoUpdateSpeed(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:DoUpdateWaitForCompanionOnSpline(context) return end

---@param owner ScriptedPuppet
---@param distanceToDestination Float
---@param companionDistance Float
---@return Bool
function AIMoveCommandsDelegate:DontWaitToCompanionNearEnd(owner, distanceToDestination, companionDistance) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:GetIsMoveToSplineNeeded(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:GetRotateEntity(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AIMoveCommandsDelegate:GetRunSpeedDistance(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AIMoveCommandsDelegate:GetSprintSpeedDistance(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AIMoveCommandsDelegate:GetTeleportDistance(context) return end

---@param target ScriptedPuppet
---@param tolerance Float
---@return Bool
function AIMoveCommandsDelegate:IsOnTheSpline(target, tolerance) return end

---@param context AIbehaviorScriptExecutionContext
---@param success Bool
---@param isCompanionProgressing Bool
function AIMoveCommandsDelegate:OnWalkingOnSpline(context, success, isCompanionProgressing) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:SelectFollowTeleportTarget(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:SelectSplineTeleportTarget(context) return end

---@param owner ScriptedPuppet
---@param value Bool
function AIMoveCommandsDelegate:SetWaitForCompanion(owner, value) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIMoveCommandsDelegate:ShouldBeWaitingDelayed(context) return end

---@class AIMoveOnSplineCommand : AIMoveCommand
---@field spline NodeRef
---@field movementType AIMovementTypeSpec
---@field rotateEntityTowardsFacingTarget Bool
---@field facingTarget gameObject
---@field shootingTarget gameObject
---@field companion gameObject
---@field desiredDistance Float
---@field deadZoneRadius Float
---@field catchUpWithCompanion Bool
---@field teleportToCompanion Bool
---@field useMatchForSpeedForPlayer Bool
---@field startFromClosestPoint Bool
---@field splineRecalculation Bool
---@field ignoreNavigation Bool
---@field snapToTerrain Bool
---@field ignoreLineOfSightCheck Bool
---@field useAlertedState Bool
---@field useStart Bool
---@field useStop Bool
---@field useCombatState Bool
---@field reverse Bool
---@field useOMLReservation Bool
---@field disableFootIK Bool
---@field allowCrowdOnPath Bool
---@field lookAtTarget gameObject
---@field minSearchAngle Float
---@field maxSearchAngle Float
---@field noWaitToEndDistance Float
---@field noWaitToEndCompanionDistance Float
---@field maxCompanionDistanceOnSpline Float
AIMoveOnSplineCommand = {}

---@return AIMoveOnSplineCommand
function AIMoveOnSplineCommand.new() return end

---@param props table
---@return AIMoveOnSplineCommand
function AIMoveOnSplineCommand.new(props) return end

---@class AIMoveOnSplineCommandHandler : AICommandHandlerBase
---@field outSpline AIArgumentMapping
---@field outMovementType AIArgumentMapping
---@field outRotateTowardsFacingTarget AIArgumentMapping
---@field outFacingTarget AIArgumentMapping
---@field outSnapToTerrain AIArgumentMapping
---@field allowCrowdOnPath AIArgumentMapping
AIMoveOnSplineCommandHandler = {}

---@return AIMoveOnSplineCommandHandler
function AIMoveOnSplineCommandHandler.new() return end

---@param props table
---@return AIMoveOnSplineCommandHandler
function AIMoveOnSplineCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIMoveOnSplineCommandHandler:UpdateCommand(context, command) return end

---@class AIMoveRotateToCommandHandler : AICommandHandlerBase
---@field target AIArgumentMapping
---@field angleTolerance AIArgumentMapping
---@field angleOffset AIArgumentMapping
---@field speed AIArgumentMapping
AIMoveRotateToCommandHandler = {}

---@return AIMoveRotateToCommandHandler
function AIMoveRotateToCommandHandler.new() return end

---@param props table
---@return AIMoveRotateToCommandHandler
function AIMoveRotateToCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIMoveRotateToCommandHandler:UpdateCommand(context, command) return end

---@class AIMoveToCommand : AIMoveCommand
---@field movementTarget AIPositionSpec
---@field rotateEntityTowardsFacingTarget Bool
---@field facingTarget AIPositionSpec
---@field movementType moveMovementType
---@field ignoreNavigation Bool
---@field useStart Bool
---@field useStop Bool
---@field desiredDistanceFromTarget Float
---@field finishWhenDestinationReached Bool
AIMoveToCommand = {}

---@return AIMoveToCommand
function AIMoveToCommand.new() return end

---@param props table
---@return AIMoveToCommand
function AIMoveToCommand.new(props) return end

---@class AIMoveToCommandHandler : AICommandHandlerBase
---@field outIsDynamicMove AIArgumentMapping
---@field outMovementTarget AIArgumentMapping
---@field outMovementTargetPos AIArgumentMapping
---@field outRotateEntityTowardsFacingTarget AIArgumentMapping
---@field outFacingTarget AIArgumentMapping
---@field outMovementType AIArgumentMapping
---@field outIgnoreNavigation AIArgumentMapping
---@field outUseStart AIArgumentMapping
---@field outUseStop AIArgumentMapping
---@field outDesiredDistanceFromTarget AIArgumentMapping
---@field outFinishWhenDestinationReached AIArgumentMapping
AIMoveToCommandHandler = {}

---@return AIMoveToCommandHandler
function AIMoveToCommandHandler.new() return end

---@param props table
---@return AIMoveToCommandHandler
function AIMoveToCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIMoveToCommandHandler:UpdateCommand(context, command) return end

---@class AIMoveToCoverCommand : AIMoveCommand
---@field coverNodeRef NodeRef
---@field specialAction ECoverSpecialAction
AIMoveToCoverCommand = {}

---@return AIMoveToCoverCommand
function AIMoveToCoverCommand.new() return end

---@param props table
---@return AIMoveToCoverCommand
function AIMoveToCoverCommand.new(props) return end

---@class AIMoveToCoverCommandParams : questScriptedAICommandParams
---@field coverNodeRef NodeRef
---@field alwaysUseStealth Bool
---@field specialAction ECoverSpecialAction
AIMoveToCoverCommandParams = {}

---@return AIMoveToCoverCommandParams
function AIMoveToCoverCommandParams.new() return end

---@param props table
---@return AIMoveToCoverCommandParams
function AIMoveToCoverCommandParams.new(props) return end

---@return AICommand
function AIMoveToCoverCommandParams:CreateCommand() return end

---@return String
function AIMoveToCoverCommandParams:GetCommandName() return end

---@class AIMovementTypeSpec
---@field useNPCMovementParams Bool
---@field movementType moveMovementType
AIMovementTypeSpec = {}

---@return AIMovementTypeSpec
function AIMovementTypeSpec.new() return end

---@param props table
---@return AIMovementTypeSpec
function AIMovementTypeSpec.new(props) return end

---@param spec AIMovementTypeSpec
---@param puppet gamePuppet
---@return moveMovementType
function AIMovementTypeSpec.Resolve(spec, puppet) return end

---@class AIMusicSystemSquadAudioMember : AISquadAudioMemberBase
AIMusicSystemSquadAudioMember = {}

---@return AIMusicSystemSquadAudioMember
function AIMusicSystemSquadAudioMember.new() return end

---@param props table
---@return AIMusicSystemSquadAudioMember
function AIMusicSystemSquadAudioMember.new(props) return end

---@class AINPCCommandEvent : AIAIEvent
---@field command AICommand
AINPCCommandEvent = {}

---@return AINPCCommandEvent
function AINPCCommandEvent.new() return end

---@param props table
---@return AINPCCommandEvent
function AINPCCommandEvent.new(props) return end

---@class AINPCCommandStateEvent : redEvent
---@field command AICommand
---@field newState AICommandState
AINPCCommandStateEvent = {}

---@return AINPCCommandStateEvent
function AINPCCommandStateEvent.new() return end

---@param props table
---@return AINPCCommandStateEvent
function AINPCCommandStateEvent.new(props) return end

---@class AINPCHighLevelStateCheck : AINPCStateCheck
---@field blackboard gameIBlackboard
AINPCHighLevelStateCheck = {}

---@param context AIbehaviorScriptExecutionContext
function AINPCHighLevelStateCheck:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AINPCHighLevelStateCheck:Check(context) return end

---@return gamedataNPCHighLevelState
function AINPCHighLevelStateCheck:GetStateToCheck() return end

---@class AINPCPreviousHighLevelStateCheck : AINPCStateCheck
AINPCPreviousHighLevelStateCheck = {}

---@return AINPCPreviousHighLevelStateCheck
function AINPCPreviousHighLevelStateCheck.new() return end

---@param props table
---@return AINPCPreviousHighLevelStateCheck
function AINPCPreviousHighLevelStateCheck.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AINPCPreviousHighLevelStateCheck:Check(context) return end

---@return gamedataNPCHighLevelState
function AINPCPreviousHighLevelStateCheck:GetStateToCheck() return end

---@class AINPCStanceStateCheck : AINPCStateCheck
---@field blackboard gameIBlackboard
AINPCStanceStateCheck = {}

---@param context AIbehaviorScriptExecutionContext
function AINPCStanceStateCheck:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AINPCStanceStateCheck:Check(context) return end

---@return gamedataNPCStanceState
function AINPCStanceStateCheck:GetStateToCheck() return end

---@class AINPCStateCheck : AIbehaviorconditionScript
AINPCStateCheck = {}

---@class AINPCUpperBodyStateCheck : AINPCStateCheck
---@field blackboard gameIBlackboard
AINPCUpperBodyStateCheck = {}

---@param context AIbehaviorScriptExecutionContext
function AINPCUpperBodyStateCheck:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AINPCUpperBodyStateCheck:Check(context) return end

---@return gamedataNPCUpperBodyState
function AINPCUpperBodyStateCheck:GetStateToCheck() return end

---@class AINavigationSystem : AIINavigationSystem
AINavigationSystem = {}

---@return AINavigationSystem
function AINavigationSystem.new() return end

---@param props table
---@return AINavigationSystem
function AINavigationSystem.new(props) return end

---@param owner entEntity
---@param originPoint Vector4
---@param targetPoint Vector4
---@return Bool
function AINavigationSystem.HasPathFromAtoB(owner, originPoint, targetPoint) return end

---@param startPoint Vector4
---@param endPoint Vector4
---@param findPointTolerance Float
---@param owner entEntity
---@param costModCircle worldNavigationScriptCostModCircle
---@return worldNavigationScriptPath
function AINavigationSystem:CalculatePathForCharacter(startPoint, endPoint, findPointTolerance, owner, costModCircle) return end

---@param center Vector4
---@param extents Vector4
---@param owner entEntity
---@return worldNavigationScriptFindPointResult
function AINavigationSystem:FindPointInBoxForCharacter(center, extents, owner) return end

---@param center Vector4
---@param radius Float
---@param owner entEntity
---@return worldNavigationScriptFindPointResult
function AINavigationSystem:FindPointInSphereForCharacter(center, radius, owner) return end

---@param startPoint Vector4
---@param endPoint Vector4
---@param findPointTolerance Float
---@param owner entEntity
---@return worldNavigationScriptFindWallResult
function AINavigationSystem:FindWallInLineForCharacter(startPoint, endPoint, findPointTolerance, owner) return end

---@param id Uint32
---@param result AINavigationSystemResult
---@return Bool
function AINavigationSystem:GetResult(id, result) return end

---@param query AINavigationSystemQuery
---@return Uint32
function AINavigationSystem:StartPathfinding(query) return end

---@param id Uint32
---@return Bool
function AINavigationSystem:StopPathfinding(id) return end

---@param origin Vector4
---@param querySphereRadius Float
---@param numberOfSpheres Int32
---@param character entEntity
---@return worldNavigationScriptFindPointResult, Float
function AINavigationSystem:FindPointBelowForCharacter(origin, querySphereRadius, numberOfSpheres, character) return end

---@param origin Vector4
---@param querySphereRadius Float
---@param numberOfSpheres Int32
---@param character entEntity
---@return worldNavigationScriptFindPointResult
function AINavigationSystem:FindPointBelowForCharacter(origin, querySphereRadius, numberOfSpheres, character) return end

---@param origin entEntity
---@param querySphereRadius Float
---@param numberOfSpheres Int32
---@param offsetFromOrigin Vector4
---@param checkPathToOrigin Bool
---@param ratioCurveName CName|string
---@return Bool, Vector4
function AINavigationSystem:GetFurthestNavmeshPointBehind(origin, querySphereRadius, numberOfSpheres, offsetFromOrigin, checkPathToOrigin, ratioCurveName) return end

---@param origin entEntity
---@param querySphereRadius Float
---@param numberOfSpheres Int32
---@param offsetFromOrigin Vector4
---@param checkPathToOrigin Bool
---@param ratioCurveName CName|string
---@return Bool, Vector4
function AINavigationSystem:GetFurthestNavmeshPointInFront(origin, querySphereRadius, numberOfSpheres, offsetFromOrigin, checkPathToOrigin, ratioCurveName) return end

---@param origin entEntity
---@param querySphereRadius Float
---@param numberOfSpheres Int32
---@param checkPathToOrigin Bool
---@return Bool, Vector4
function AINavigationSystem:GetNearestNavmeshPointBehind(origin, querySphereRadius, numberOfSpheres, checkPathToOrigin) return end

---@param character entEntity
---@param origin Vector4
---@param querySphereRadius Float
---@param numberOfSpheres Int32
---@return Vector4
function AINavigationSystem:GetNearestNavmeshPointBelow(character, origin, querySphereRadius, numberOfSpheres) return end

---@param sourceObject gameObject
---@param distance Float
---@return Bool
function AINavigationSystem:HasPathForward(sourceObject, distance) return end

---@param character entEntity
---@param point Vector4
---@param tolerance Float
---@return Bool
function AINavigationSystem:IsPointOnNavmesh(character, point, tolerance) return end

---@param character entEntity
---@param point Vector4
---@param tolerance Vector4
---@return Bool
function AINavigationSystem:IsPointOnNavmesh(character, point, tolerance) return end

---@param character entEntity
---@param point Vector4
---@param tolerance Vector4
---@return Bool, Vector4
function AINavigationSystem:IsPointOnNavmesh(character, point, tolerance) return end

---@param owner entEntity
---@param originPosition Vector4
---@param originOrientation Quaternion
---@param probeDimensions Vector4
---@param numberOfSpheres Int32
---@param sphereDistanceFromOrigin Float
---@param checkPathToOrigin Bool
---@return Bool, Vector4
function AINavigationSystem:TryToFindNavmeshPointAroundPoint(owner, originPosition, originOrientation, probeDimensions, numberOfSpheres, sphereDistanceFromOrigin, checkPathToOrigin) return end

---@class AINavigationSystemQuery
---@field source AIPositionSpec
---@field target AIPositionSpec
---@field allowedTags CName[]
---@field blockedTags CName[]
---@field minDesiredDistance Float
---@field maxDesiredDistance Float
---@field useFollowSlots Bool
---@field usePredictionTime Bool
AINavigationSystemQuery = {}

---@return AINavigationSystemQuery
function AINavigationSystemQuery.new() return end

---@param props table
---@return AINavigationSystemQuery
function AINavigationSystemQuery.new(props) return end

---@class AINavigationSystemResult
---@field hasFailed Bool
---@field hasPath Bool
---@field hasClosestPointOnNavmesh Bool
---@field hasClosestReachablePoint Bool
---@field lastSourcePosition WorldPosition
---@field lastTargetPosition WorldPosition
---@field adjustedTargetPosition WorldPosition
---@field closestPointOnNavmesh WorldPosition
---@field closestReachablePoint WorldPosition
AINavigationSystemResult = {}

---@return AINavigationSystemResult
function AINavigationSystemResult.new() return end

---@param props table
---@return AINavigationSystemResult
function AINavigationSystemResult.new(props) return end

---@class AINewThreat : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field isHostile Bool
---@field isEnemy Bool
AINewThreat = {}

---@return AINewThreat
function AINewThreat.new() return end

---@param props table
---@return AINewThreat
function AINewThreat.new(props) return end

---@class AINoRole : AIRole
AINoRole = {}

---@return AINoRole
function AINoRole.new() return end

---@param props table
---@return AINoRole
function AINoRole.new(props) return end

---@class AIObjectId
---@field value Uint64
AIObjectId = {}

---@return AIObjectId
function AIObjectId.new() return end

---@param props table
---@return AIObjectId
function AIObjectId.new(props) return end

---@class AIObjectSelectionComponent : entIComponent
AIObjectSelectionComponent = {}

---@return AIObjectSelectionComponent
function AIObjectSelectionComponent.new() return end

---@param props table
---@return AIObjectSelectionComponent
function AIObjectSelectionComponent.new(props) return end

---@return Int32
function AIObjectSelectionComponent:GetCurrentCoverDebugPresetNumber() return end

---@param coverId Uint64
---@param ring gamedataAIRingType
---@return Bool
function AIObjectSelectionComponent:IsCoverPositiveScored(coverId, ring) return end

---@return Bool
function AIObjectSelectionComponent:IsCoversProcessingPaused() return end

---@param setPause Bool
function AIObjectSelectionComponent:PauseCoversProcessing(setPause) return end

---@param presetNumber Int32
function AIObjectSelectionComponent:SetCurrentCoverDebugPresetNumber(presetNumber) return end

---@param radius Float
function AIObjectSelectionComponent:SetRadius(radius) return end

---@class AIObjectSelectionManager : AIObjectSelectionManagerInterface
AIObjectSelectionManager = {}

---@return AIObjectSelectionManager
function AIObjectSelectionManager.new() return end

---@param props table
---@return AIObjectSelectionManager
function AIObjectSelectionManager.new(props) return end

---@class AIObjectSelectionManagerInterface : gameIGameSystem
AIObjectSelectionManagerInterface = {}

---@class AIOffMeshConnectionComponent : entIComponent
---@field offMeshConnectionNodesRefs NodeRef[]
---@field agentSize NavGenAgentSize
AIOffMeshConnectionComponent = {}

---@return AIOffMeshConnectionComponent
function AIOffMeshConnectionComponent.new() return end

---@param props table
---@return AIOffMeshConnectionComponent
function AIOffMeshConnectionComponent.new(props) return end

function AIOffMeshConnectionComponent:DisableForPlayer() return end

function AIOffMeshConnectionComponent:DisableOffMeshConnection() return end

function AIOffMeshConnectionComponent:EnableForPlayer() return end

function AIOffMeshConnectionComponent:EnableOffMeshConnection() return end

---@class AIOwnerAngleCoverSelection : AICoverSelectionParameters
AIOwnerAngleCoverSelection = {}

---@return AIOwnerAngleCoverSelection
function AIOwnerAngleCoverSelection.new() return end

---@param props table
---@return AIOwnerAngleCoverSelection
function AIOwnerAngleCoverSelection.new(props) return end

---@class AIOwnerDistanceCoverSelection : AICoverSelectionParameters
AIOwnerDistanceCoverSelection = {}

---@return AIOwnerDistanceCoverSelection
function AIOwnerDistanceCoverSelection.new() return end

---@param props table
---@return AIOwnerDistanceCoverSelection
function AIOwnerDistanceCoverSelection.new(props) return end

---@class AIOwnerThreatCoverSelection : AICoverSelectionParameters
AIOwnerThreatCoverSelection = {}

---@return AIOwnerThreatCoverSelection
function AIOwnerThreatCoverSelection.new() return end

---@param props table
---@return AIOwnerThreatCoverSelection
function AIOwnerThreatCoverSelection.new(props) return end

---@class AIParametrizedResourceReference : AIResourceReference
---@field overrides LibTreeParametersForwarder
AIParametrizedResourceReference = {}

---@return AIParametrizedResourceReference
function AIParametrizedResourceReference.new() return end

---@param props table
---@return AIParametrizedResourceReference
function AIParametrizedResourceReference.new(props) return end

---@class AIPathLengthCoverSelection : AICoverSelectionParameters
AIPathLengthCoverSelection = {}

---@return AIPathLengthCoverSelection
function AIPathLengthCoverSelection.new() return end

---@param props table
---@return AIPathLengthCoverSelection
function AIPathLengthCoverSelection.new(props) return end

---@class AIPathSecurityCoverSelection : AICoverSelectionParameters
AIPathSecurityCoverSelection = {}

---@return AIPathSecurityCoverSelection
function AIPathSecurityCoverSelection.new() return end

---@param props table
---@return AIPathSecurityCoverSelection
function AIPathSecurityCoverSelection.new(props) return end

---@class AIPatrolCommand : AIMoveCommand
---@field pathParams AIPatrolPathParameters
---@field alertedPathParams AIPatrolPathParameters
---@field alertedRadius Float
---@field alertedSpots NodeRef[]
---@field patrolWithWeapon Bool
---@field patrolAction TweakDBID
AIPatrolCommand = {}

---@return AIPatrolCommand
function AIPatrolCommand.new() return end

---@param props table
---@return AIPatrolCommand
function AIPatrolCommand.new(props) return end

---@class AIPatrolCommandPrologue : AICommandHandlerBase
---@field outPatrolPath AIArgumentMapping
AIPatrolCommandPrologue = {}

---@return AIPatrolCommandPrologue
function AIPatrolCommandPrologue.new() return end

---@param props table
---@return AIPatrolCommandPrologue
function AIPatrolCommandPrologue.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AICommand
---@return AIbehaviorUpdateOutcome
function AIPatrolCommandPrologue:UpdateCommand(context, command) return end

---@class AIPatrolDef : AIBlackboardDef
---@field patrolPathOverride gamebbScriptID_Variant
---@field patrolWithWeapon gamebbScriptID_Bool
---@field forceAlerted gamebbScriptID_Bool
---@field sprint gamebbScriptID_Bool
---@field selectedPath gamebbScriptID_Variant
---@field closestPathPoint gamebbScriptID_Vector4
---@field workspotData gamebbScriptID_Variant
---@field workspotEntryPosition gamebbScriptID_Vector4
---@field workspotExitPosition gamebbScriptID_Vector4
---@field patrolAction gamebbScriptID_Variant
---@field patrolInProgress gamebbScriptID_Bool
AIPatrolDef = {}

---@return AIPatrolDef
function AIPatrolDef.new() return end

---@param props table
---@return AIPatrolDef
function AIPatrolDef.new(props) return end

---@class AIPatrolPathParameters : IScriptable
---@field path NodeRef
---@field movementType moveMovementType
---@field continuationPolicy AIPatrolContinuationPolicy
---@field startFromClosestPoint Bool
---@field patrolWithWeapon Bool
---@field isBackAndForth Bool
---@field isInfinite Bool
---@field numberOfLoops Uint32
---@field sortPatrolPoints Bool
---@field patrolAction TweakDBID
AIPatrolPathParameters = {}

---@return AIPatrolPathParameters
function AIPatrolPathParameters.new() return end

---@param props table
---@return AIPatrolPathParameters
function AIPatrolPathParameters.new(props) return end

---@class AIPatrolRole : AIRole
---@field pathParams AIPatrolPathParameters
---@field alertedPathParams AIPatrolPathParameters
---@field alertedRadius Float
---@field alertedSpots AIbehaviorWorkspotList
---@field forceAlerted Bool
AIPatrolRole = {}

---@return AIPatrolRole
function AIPatrolRole.new() return end

---@param props table
---@return AIPatrolRole
function AIPatrolRole.new(props) return end

---@return AIPatrolPathParameters
function AIPatrolRole:GetAlertedPathParams() return end

---@return Float
function AIPatrolRole:GetAlertedRadius() return end

---@return AIbehaviorWorkspotList
function AIPatrolRole:GetAlertedSpots() return end

---@return AIPatrolPathParameters
function AIPatrolRole:GetPathParams() return end

---@return EAIRole
function AIPatrolRole:GetRoleEnum() return end

---@return TweakDBID
function AIPatrolRole:GetTweakRecordId() return end

---@return Bool
function AIPatrolRole:IsForceAlerted() return end

---@param owner gameObject
function AIPatrolRole:OnRoleSet(owner) return end

---@class AIPhaseStateEventHandlerComponent : AIRelatedComponents
---@field phaseStateValue ENPCPhaseState
AIPhaseStateEventHandlerComponent = {}

---@return AIPhaseStateEventHandlerComponent
function AIPhaseStateEventHandlerComponent.new() return end

---@param props table
---@return AIPhaseStateEventHandlerComponent
function AIPhaseStateEventHandlerComponent.new(props) return end

---@param evt WeakspotOnDestroyEvent
---@return Bool
function AIPhaseStateEventHandlerComponent:OnWeakspotDestroyEvent(evt) return end

---@class AIPlayMountedSlotWorkspotCommand : AICommand
---@field mountData gameMountDescriptor
AIPlayMountedSlotWorkspotCommand = {}

---@return AIPlayMountedSlotWorkspotCommand
function AIPlayMountedSlotWorkspotCommand.new() return end

---@param props table
---@return AIPlayMountedSlotWorkspotCommand
function AIPlayMountedSlotWorkspotCommand.new(props) return end

---@class AIPosition
---@field position Vector3
AIPosition = {}

---@return AIPosition
function AIPosition.new() return end

---@param props table
---@return AIPosition
function AIPosition.new(props) return end

---@class AIPositionSpec
---@field entity entEntity
---@field worldPosition WorldPosition
AIPositionSpec = {}

---@return AIPositionSpec
function AIPositionSpec.new() return end

---@param props table
---@return AIPositionSpec
function AIPositionSpec.new(props) return end

---@param position AIPositionSpec
---@return entEntity
function AIPositionSpec.GetEntity(position) return end

---@param position AIPositionSpec
---@return Vector4
function AIPositionSpec.GetWorldPosition(position) return end

---@param position AIPositionSpec
---@return Bool
function AIPositionSpec.IsEmpty(position) return end

---@param position AIPositionSpec
---@return Bool
function AIPositionSpec.IsEntity(position) return end

---@param position AIPositionSpec
---@return Bool
function AIPositionSpec.IsWorldPosition(position) return end

---@param aiPositionSpec AIPositionSpec
---@param entity entEntity
function AIPositionSpec.SetEntity(aiPositionSpec, entity) return end

---@param aiPositionSpec AIPositionSpec
---@param position WorldPosition
function AIPositionSpec.SetWorldPosition(aiPositionSpec, position) return end

---@class AIPrepareTakedownData : AIbehaviortaskScript
AIPrepareTakedownData = {}

---@return AIPrepareTakedownData
function AIPrepareTakedownData.new() return end

---@param props table
---@return AIPrepareTakedownData
function AIPrepareTakedownData.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIPrepareTakedownData:Activate(context) return end

---@class AIPrereqsDataDef : AIBlackboardDef
---@field npcHitTypeTimeout gamebbScriptID_Variant
AIPrereqsDataDef = {}

---@return AIPrereqsDataDef
function AIPrereqsDataDef.new() return end

---@param props table
---@return AIPrereqsDataDef
function AIPrereqsDataDef.new(props) return end

---@return Bool
function AIPrereqsDataDef:AutoCreateInSystem() return end

---@class AIPuppetBlackboardListener : ISerializable
AIPuppetBlackboardListener = {}

---@return AIPuppetBlackboardListener
function AIPuppetBlackboardListener.new() return end

---@param props table
---@return AIPuppetBlackboardListener
function AIPuppetBlackboardListener.new(props) return end

---@class AIPuppetSwappedEvent : redEvent
AIPuppetSwappedEvent = {}

---@return AIPuppetSwappedEvent
function AIPuppetSwappedEvent.new() return end

---@param props table
---@return AIPuppetSwappedEvent
function AIPuppetSwappedEvent.new(props) return end

---@class AIPuppetTeleportedEvent : redEvent
AIPuppetTeleportedEvent = {}

---@return AIPuppetTeleportedEvent
function AIPuppetTeleportedEvent.new() return end

---@param props table
---@return AIPuppetTeleportedEvent
function AIPuppetTeleportedEvent.new(props) return end

---@class AIQuickHackAction : PuppetAction
---@field target gameObject
---@field scaleUploadTime Bool
AIQuickHackAction = {}

---@return AIQuickHackAction
function AIQuickHackAction.new() return end

---@param props table
---@return AIQuickHackAction
function AIQuickHackAction.new(props) return end

---@param actionEffects gamedataObjectActionEffect_Record[]
function AIQuickHackAction:ProcessStatusEffects(actionEffects) return end

function AIQuickHackAction:SetRegenBehavior() return end

function AIQuickHackAction:StartUpload() return end

---@class AIRagdollDelegate : AIbehaviorScriptBehaviorDelegate
---@field ragdollInstigator gameObject
---@field closestNavmeshPoint Vector4
---@field ragdollOutOfNavmesh Bool
---@field isUnderwater Bool
---@field poseAllowsRecovery Bool
AIRagdollDelegate = {}

---@return AIRagdollDelegate
function AIRagdollDelegate.new() return end

---@param props table
---@return AIRagdollDelegate
function AIRagdollDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIRagdollDelegate:DoCheckIfPoseAllowsRecovery(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIRagdollDelegate:DoCheckWaterLevel(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIRagdollDelegate:DoClearActiveStatusEffect(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIRagdollDelegate:DoGetRagdollInstigator(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIRagdollDelegate:DoHandleDownedSignals(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIRagdollDelegate:DoHandleRagdollReaction(context) return end

---@param owner NPCPuppet
---@param queryDimensions Float[]
---@param originTransform WorldTransform
---@return Bool
function AIRagdollDelegate:HasSpaceToRecover(owner, queryDimensions, originTransform) return end

---@param context AIbehaviorScriptExecutionContext
---@param puppet ScriptedPuppet
---@param downedTypeTag CName|string
function AIRagdollDelegate:SendDownedSignal(context, puppet, downedTypeTag) return end

---@param context AIbehaviorScriptExecutionContext
---@param puppet ScriptedPuppet
---@param seTypeTag CName|string
function AIRagdollDelegate:SendStatusEffectSignal(context, puppet, seTypeTag) return end

---@param maxAllowedAngle Float
---@param hipsPosition Vector4
---@param chestPosition Vector4
---@param legsPosition Vector4
---@return Bool
function AIRagdollDelegate:TorsoAngleWithinParamters(maxAllowedAngle, hipsPosition, chestPosition, legsPosition) return end

---@class AIRandomCoverSelection : AICoverSelectionParameters
AIRandomCoverSelection = {}

---@return AIRandomCoverSelection
function AIRandomCoverSelection.new() return end

---@param props table
---@return AIRandomCoverSelection
function AIRandomCoverSelection.new(props) return end

---@class AIRandomTasks : AIbehaviortaskScript
AIRandomTasks = {}

---@return AIRandomTasks
function AIRandomTasks.new() return end

---@param props table
---@return AIRandomTasks
function AIRandomTasks.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIRandomTasks:Activate(context) return end

---@param Max Int32
---@param Min Int32
---@return Int32
function AIRandomTasks:RollInteger(Max, Min) return end

---@class AIReactionData : IScriptable
---@field reactionPriority Int32
---@field reactionBehaviorName gamedataOutput
---@field reactionBehaviorAIPriority Float
---@field reactionCooldown Float
---@field stimTarget gameObject
---@field stimSource Vector4
---@field stimType gamedataStimType
---@field stimPriority gamedataStimPriority
---@field stimRecord gamedataStim_Record
---@field stimInvestigateData senseStimInvestigateData
---@field stimEventData StimEventData
---@field stimPropagation gamedataStimPropagation
---@field initAnimInWorkspot Bool
---@field skipInitialAnimation Bool
---@field validTillTimeStamp Float
---@field recentReactionTimeStamp Float
---@field escalateProvoke Bool
AIReactionData = {}

---@return AIReactionData
function AIReactionData.new() return end

---@param props table
---@return AIReactionData
function AIReactionData.new(props) return end

---@class AIReactionSystem : AIIReactionSystem
AIReactionSystem = {}

---@return AIReactionSystem
function AIReactionSystem.new() return end

---@param props table
---@return AIReactionSystem
function AIReactionSystem.new(props) return end

---@param sourcePos Vector3
---@param halfExtend Float
---@param debugInfo CName|string
function AIReactionSystem:AddFearSource(sourcePos, halfExtend, debugInfo) return end

---@param runner gameObject
---@param threat gameObject
---@return Bool
function AIReactionSystem:AddTrafficRunnersDirectly(runner, threat) return end

---@param npcId entEntityID
---@return Bool
function AIReactionSystem:IsInImmovableWorkspot(npcId) return end

---@param npcId entEntityID
---@return Bool
function AIReactionSystem:IsRegisteredAsAggressive(npcId) return end

---@param id entEntityID
---@param isAggressive Bool
---@param isInScene Bool
function AIReactionSystem:MarkDeadBody(id, isAggressive, isInScene) return end

---@param id entEntityID
function AIReactionSystem:MarkDespawnCandidate(id) return end

---@param npc gameObject
---@param threat gameObject
function AIReactionSystem:RegisterFearReaction(npc, threat) return end

---@param reaction CName|string
---@return AIReactionCountOutcome
function AIReactionSystem:RegisterReaction(reaction) return end

---@param npc gameObject
---@param threatPos Vector3
---@param shouldRunInTraffic Bool
---@return Bool
function AIReactionSystem:TryAndJoinTraffic(npc, threatPos, shouldRunInTraffic) return end

---@param civilianNPC gameObject
---@return Bool
function AIReactionSystem:TryRegisteringAggressiveNPC(civilianNPC) return end

---@param npcId entEntityID
---@return Bool
function AIReactionSystem:TryUnregisteringAggressiveNPC(npcId) return end

---@param id entEntityID
function AIReactionSystem:UnmarkDespawnCandidate(id) return end

---@param runner gameObject
function AIReactionSystem:UnregisterFearReaction(runner) return end

---@param reaction CName|string
---@return AIReactionCountOutcome
function AIReactionSystem:UnregisterReaction(reaction) return end

---@param npcId entEntityID
---@return Bool
function AIReactionSystem:UsesLoreAnimationWorkspot(npcId) return end

---@class AIRelatedComponents : gameScriptableComponent
AIRelatedComponents = {}

---@class AIRemovedAsHostileThreat : AIAIEvent
---@field threateningEntity AITargetTrackerComponent
---@field threateningEntityCanTriggersCombat Bool
AIRemovedAsHostileThreat = {}

---@return AIRemovedAsHostileThreat
function AIRemovedAsHostileThreat.new() return end

---@param props table
---@return AIRemovedAsHostileThreat
function AIRemovedAsHostileThreat.new(props) return end

---@class AIResource : LibTreeCTreeResource
---@field root AICTreeNodeDefinition
AIResource = {}

---@return AIResource
function AIResource.new() return end

---@param props table
---@return AIResource
function AIResource.new(props) return end

---@class AIResourceReference : LibTreeCTreeReference
AIResourceReference = {}

---@return AIResourceReference
function AIResourceReference.new() return end

---@param props table
---@return AIResourceReference
function AIResourceReference.new(props) return end

---@class AIReturnToRestrictMovementArea : AIbehaviortaskScript
AIReturnToRestrictMovementArea = {}

---@return AIReturnToRestrictMovementArea
function AIReturnToRestrictMovementArea.new() return end

---@param props table
---@return AIReturnToRestrictMovementArea
function AIReturnToRestrictMovementArea.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIReturnToRestrictMovementArea:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIReturnToRestrictMovementArea:Update(context) return end

---@class AIReturnToRestrictMovementAreaCondition : RestrictedMovementAreaCondition
AIReturnToRestrictMovementAreaCondition = {}

---@return AIReturnToRestrictMovementAreaCondition
function AIReturnToRestrictMovementAreaCondition.new() return end

---@param props table
---@return AIReturnToRestrictMovementAreaCondition
function AIReturnToRestrictMovementAreaCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIReturnToRestrictMovementAreaCondition:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AIReturnToRestrictMovementAreaCondition:Check(context) return end

---@class AIRoadBlockadeMemberCommand : AICombatRelatedCommand
---@field duration Float
AIRoadBlockadeMemberCommand = {}

---@return AIRoadBlockadeMemberCommand
function AIRoadBlockadeMemberCommand.new() return end

---@param props table
---@return AIRoadBlockadeMemberCommand
function AIRoadBlockadeMemberCommand.new(props) return end

---@class AIRoadBlockadeMemberCommandParams : questScriptedAICommandParams
---@field duration Float
AIRoadBlockadeMemberCommandParams = {}

---@return AIRoadBlockadeMemberCommandParams
function AIRoadBlockadeMemberCommandParams.new() return end

---@param props table
---@return AIRoadBlockadeMemberCommandParams
function AIRoadBlockadeMemberCommandParams.new(props) return end

---@return AICommand
function AIRoadBlockadeMemberCommandParams:CreateCommand() return end

---@return String
function AIRoadBlockadeMemberCommandParams:GetCommandName() return end

---@class AIRole : IScriptable
AIRole = {}

---@return AIRole
function AIRole.new() return end

---@param props table
---@return AIRole
function AIRole.new(props) return end

---@return gamedataAIRole_Record
function AIRole:GetRoleTweakRecord() return end

---@return EAIRole
function AIRole:GetRoleEnum() return end

---@return TweakDBID
function AIRole:GetTweakRecordId() return end

---@param owner gameObject
---@param newState gamedataNPCHighLevelState
---@param previousState gamedataNPCHighLevelState
function AIRole:OnHighLevelStateEnter(owner, newState, previousState) return end

---@param owner gameObject
---@param leftState gamedataNPCHighLevelState
---@param nextState gamedataNPCHighLevelState
function AIRole:OnHighLevelStateExit(owner, leftState, nextState) return end

---@param owner gameObject
function AIRole:OnRoleCleared(owner) return end

---@param owner gameObject
function AIRole:OnRoleSet(owner) return end

---@class AIRoleCondition : AIbehaviorconditionScript
---@field role EAIRole
AIRoleCondition = {}

---@return AIRoleCondition
function AIRoleCondition.new() return end

---@param props table
---@return AIRoleCondition
function AIRoleCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AIRoleCondition:Check(context) return end

---@class AIRootMotionCommand : AIMoveCommand
---@field params gameSceneAnimationMotionActionParams
AIRootMotionCommand = {}

---@return AIRootMotionCommand
function AIRootMotionCommand.new() return end

---@param props table
---@return AIRootMotionCommand
function AIRootMotionCommand.new(props) return end

---@class AIRotateToCommand : AIMoveCommand
---@field target AIPositionSpec
---@field angleTolerance Float
---@field angleOffset Float
---@field speed Float
AIRotateToCommand = {}

---@return AIRotateToCommand
function AIRotateToCommand.new() return end

---@param props table
---@return AIRotateToCommand
function AIRotateToCommand.new(props) return end

---@class AIRunAwayEvent : AIAIEvent
AIRunAwayEvent = {}

---@return AIRunAwayEvent
function AIRunAwayEvent.new() return end

---@param props table
---@return AIRunAwayEvent
function AIRunAwayEvent.new(props) return end

---@class AISafeAreaManager : AIISafeAreaManager
AISafeAreaManager = {}

---@return AISafeAreaManager
function AISafeAreaManager.new() return end

---@param props table
---@return AISafeAreaManager
function AISafeAreaManager.new(props) return end

---@param point Vector4
---@return Bool
function AISafeAreaManager:IsPointInSafeArea(point) return end

---@class AIScanTargetCommand : AICommand
---@field targetPuppetRef gameEntityReference
AIScanTargetCommand = {}

---@return AIScanTargetCommand
function AIScanTargetCommand.new() return end

---@param props table
---@return AIScanTargetCommand
function AIScanTargetCommand.new(props) return end

---@class AIScanTargetCommandParams : questScriptedAICommandParams
---@field targetPuppetRef gameEntityReference
AIScanTargetCommandParams = {}

---@return AIScanTargetCommandParams
function AIScanTargetCommandParams.new() return end

---@param props table
---@return AIScanTargetCommandParams
function AIScanTargetCommandParams.new(props) return end

---@return AICommand
function AIScanTargetCommandParams:CreateCommand() return end

---@return String
function AIScanTargetCommandParams:GetCommandName() return end

---@class AIScanTargetTask : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AIScanTargetTask = {}

---@return AIScanTargetTask
function AIScanTargetTask.new() return end

---@param props table
---@return AIScanTargetTask
function AIScanTargetTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param typedCommand AIScanTargetCommand
function AIScanTargetTask:CancelCommand(context, typedCommand) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIScanTargetTask:Update(context) return end

---@class AIScriptActionDelegate : AIbehaviorScriptBehaviorDelegate
---@field actionPackageType AIactionParamsPackageTypes
AIScriptActionDelegate = {}

---@return AIScriptActionDelegate
function AIScriptActionDelegate.new() return end

---@param props table
---@return AIScriptActionDelegate
function AIScriptActionDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIactionParamsPackageTypes
function AIScriptActionDelegate.GetActionPackageType(context) return end

---@class AIScriptGuardArea
AIScriptGuardArea = {}

---@return AIScriptGuardArea
function AIScriptGuardArea.new() return end

---@param props table
---@return AIScriptGuardArea
function AIScriptGuardArea.new(props) return end

---@class AIScriptSquad : IScriptable
AIScriptSquad = {}

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
---@return Bool
function AIScriptSquad.CanPerformTicket(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
---@return Bool
function AIScriptSquad.CheckTickets(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.CloseTicket(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
function AIScriptSquad.CloseTickets(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.CommitToTicket(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
function AIScriptSquad.CommitToTickets(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.CompleteTicket(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
---@param succeed Bool
function AIScriptSquad.CompleteTickets(context, actionRecord, succeed) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.EvaluateTicketActivation(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.EvaluateTicketDeactivation(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
function AIScriptSquad.EvaluateTicketsActivation(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
function AIScriptSquad.EvaluateTicketsDeactivation(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.FailTicket(context, actionType) return end

---@return Bool, gamedataAISquadParams_Record
function AIScriptSquad.GetBaseSquadRecord() return end

---@param entity entEntity
---@return Bool, gamedataAISquadParams_Record
function AIScriptSquad.GetSquadRecord(entity) return end

---@param ticketName CName|string
---@param squadRecord gamedataAISquadParams_Record
---@return Bool, gamedataAITicket_Record
function AIScriptSquad.GetTicketRecord(ticketName, squadRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param ticketName CName|string
---@return Bool
function AIScriptSquad.HasOrder(context, ticketName) return end

---@param puppet ScriptedPuppet
---@param ticketName CName|string
---@return Bool
function AIScriptSquad.HasOrder(puppet, ticketName) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.OpenTicket(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
function AIScriptSquad.RequestTickets(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionType gamedataAITicketType_Record
function AIScriptSquad.RevokeTicket(context, actionType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
function AIScriptSquad.RevokeTickets(context, actionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionName CName|string
---@param verb EAISquadVerb
function AIScriptSquad.SignalSquad(context, actionName, verb) return end

---@param ticketNameCheck String
---@param entity entEntity
---@param ticketRecord gamedataAITicket_Record
---@return Bool
function AIScriptSquad.TicketDebugHelper(ticketNameCheck, entity, ticketRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionRecord gamedataAIAction_Record
---@return Bool
function AIScriptSquad.WaitForTicketsAcknowledgement(context, actionRecord) return end

---@class AIScriptsTargetTrackingListener : AIITargetTrackingListener
AIScriptsTargetTrackingListener = {}

---@return AIScriptsTargetTrackingListener
function AIScriptsTargetTrackingListener.new() return end

---@param props table
---@return AIScriptsTargetTrackingListener
function AIScriptsTargetTrackingListener.new(props) return end

---@param bound Float
function AIScriptsTargetTrackingListener:SetAccuracyBound(bound) return end

---@param bound Float
function AIScriptsTargetTrackingListener:SetSharedAccuracyBound(bound) return end

---@param above Bool
function AIScriptsTargetTrackingListener:OnAccuracyBoundReached(above) return end

---@param above Bool
function AIScriptsTargetTrackingListener:OnSharedAccuracyBoundReached(above) return end

---@class AIScriptsTargetTrackingListenerWrapper : AIITargetTrackingListener
AIScriptsTargetTrackingListenerWrapper = {}

---@return AIScriptsTargetTrackingListenerWrapper
function AIScriptsTargetTrackingListenerWrapper.new() return end

---@param props table
---@return AIScriptsTargetTrackingListenerWrapper
function AIScriptsTargetTrackingListenerWrapper.new(props) return end

---@class AISearchingLookat : AIGenericStaticLookatTask
---@field minAngleDifferenceMapping AIArgumentMapping
---@field minAngleDifference Float
---@field maxLookAroundAngleMapping AIArgumentMapping
---@field maxLookAroundAngle Float
---@field currentTarget Vector4
---@field lastTarget Vector4
---@field targetSwitchTimeStamp Float
---@field targetSwitchCooldown Float
---@field sideHorizontal Int32
---@field sideVertical Int32
AISearchingLookat = {}

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AISearchingLookat:GetAbsAngleToTarget(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Vector4
function AISearchingLookat:GetAimingLookatTarget(context) return end

---@return animLookAtLimitDegreesType
function AISearchingLookat:GetBackLimitDegreesType() return end

---@return animLookAtLimitDegreesType
function AISearchingLookat:GetHardLimitDegreesType() return end

---@return animLookAtLimitDistanceType
function AISearchingLookat:GetHardLimitDistanceType() return end

---@return animLookAtStyle
function AISearchingLookat:GetLookatStyle() return end

---@param context AIbehaviorScriptExecutionContext
---@return Vector4
function AISearchingLookat:GetLookatTargetPosition(context) return end

---@return animLookAtLimitDegreesType
function AISearchingLookat:GetSoftLimitDegreesType() return end

---@return Float
function AISearchingLookat:GetSoftLookatLimitDegrees() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AISearchingLookat:InitializeMemberVariables(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param lastTargetPosition Vector4
---@return Float, Float
function AISearchingLookat:LookatOffsetAngleLimit(context, lastTargetPosition) return end

---@param context AIbehaviorScriptExecutionContext
---@return Vector4
function AISearchingLookat:SelectNewAimingLookatTarget(context) return end

---@class AISetAutocraftingState : AIbehaviortaskScript
---@field newState Bool
AISetAutocraftingState = {}

---@return AISetAutocraftingState
function AISetAutocraftingState.new() return end

---@param props table
---@return AISetAutocraftingState
function AISetAutocraftingState.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AISetAutocraftingState:Activate(context) return end

---@class AISetCombatPresetCommand : AICombatRelatedCommand
---@field combatPreset EAICombatPreset
AISetCombatPresetCommand = {}

---@return AISetCombatPresetCommand
function AISetCombatPresetCommand.new() return end

---@param props table
---@return AISetCombatPresetCommand
function AISetCombatPresetCommand.new(props) return end

---@class AISetCombatPresetCommandParams : questScriptedAICommandParams
---@field combatPreset EAICombatPreset
AISetCombatPresetCommandParams = {}

---@return AISetCombatPresetCommandParams
function AISetCombatPresetCommandParams.new() return end

---@param props table
---@return AISetCombatPresetCommandParams
function AISetCombatPresetCommandParams.new(props) return end

---@return AICommand
function AISetCombatPresetCommandParams:CreateCommand() return end

---@return String
function AISetCombatPresetCommandParams:GetCommandName() return end

---@class AISetCombatPresetTask : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AISetCombatPresetTask = {}

---@return AISetCombatPresetTask
function AISetCombatPresetTask.new() return end

---@param props table
---@return AISetCombatPresetTask
function AISetCombatPresetTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param typedCommand AISetCombatPresetCommand
function AISetCombatPresetTask:CancelCommand(context, typedCommand) return end

---@param owner gameObject
---@return Bool
function AISetCombatPresetTask:RemovePresets(owner) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AISetCombatPresetTask:Update(context) return end

---@class AISetHealthRegenerationState : AIbehaviortaskScript
---@field healthRegeneration Bool
AISetHealthRegenerationState = {}

---@return AISetHealthRegenerationState
function AISetHealthRegenerationState.new() return end

---@param props table
---@return AISetHealthRegenerationState
function AISetHealthRegenerationState.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AISetHealthRegenerationState:Activate(context) return end

---@class AISetSoloModeHandler : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AISetSoloModeHandler = {}

---@return AISetSoloModeHandler
function AISetSoloModeHandler.new() return end

---@param props table
---@return AISetSoloModeHandler
function AISetSoloModeHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AISetSoloModeHandler:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AISetSoloModeHandler:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AISetSoloModeHandler:Update(context) return end

---@class AISharedVarDefinition
---@field type AIESharedVarDefinitionType
---@field name LibTreeSharedVarRegistrationName
AISharedVarDefinition = {}

---@return AISharedVarDefinition
function AISharedVarDefinition.new() return end

---@param props table
---@return AISharedVarDefinition
function AISharedVarDefinition.new(props) return end

---@class AISharedVarTableDefinition
---@field table AISharedVarDefinition[]
AISharedVarTableDefinition = {}

---@return AISharedVarTableDefinition
function AISharedVarTableDefinition.new() return end

---@param props table
---@return AISharedVarTableDefinition
function AISharedVarTableDefinition.new(props) return end

---@class AIShootCommand : AICombatRelatedCommand
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
---@field once Bool
AIShootCommand = {}

---@return AIShootCommand
function AIShootCommand.new() return end

---@param props table
---@return AIShootCommand
function AIShootCommand.new(props) return end

---@class AIShootingDataDef : AIBlackboardDef
---@field shootingPatternPackage gamebbScriptID_Variant
---@field shootingPattern gamebbScriptID_Variant
---@field patternList gamebbScriptID_Variant
---@field rightArmLookAtLimitReached gamebbScriptID_Int32
---@field totalShotsFired gamebbScriptID_Int32
---@field shotsInBurstFired gamebbScriptID_Int32
---@field desiredNumberOfShots gamebbScriptID_Int32
---@field nextShotTimeStamp gamebbScriptID_Float
---@field shotTimeStamp gamebbScriptID_Float
---@field maxChargedTimeStamp gamebbScriptID_Float
---@field chargeStartTimeStamp gamebbScriptID_Float
---@field pauseConditionCheckTimeStamp gamebbScriptID_Float
---@field lastChargeLevel gamebbScriptID_Float
---@field fullyCharged gamebbScriptID_Bool
---@field weaponOverheated gamebbScriptID_Bool
---@field requestedTriggerMode gamebbScriptID_Int32
---@field shootingFromCar gamebbScriptID_Bool
AIShootingDataDef = {}

---@return AIShootingDataDef
function AIShootingDataDef.new() return end

---@param props table
---@return AIShootingDataDef
function AIShootingDataDef.new(props) return end

---@return Bool
function AIShootingDataDef:AutoCreateInSystem() return end

---@param blackboard gameIBlackboard
function AIShootingDataDef:Initialize(blackboard) return end

---@class AISignalCondition : AIbehaviorconditionScript
---@field requiredFlags AISignalFlags[]
---@field consumesSignal Bool
---@field activated Bool
---@field executingSignal AIGateSignal
---@field executingSignalId Uint32
AISignalCondition = {}

---@param context AIbehaviorScriptExecutionContext
function AISignalCondition:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AISignalCondition:Check(context) return end

---@param gateSignal AIGateSignal
---@param checkAgainst AISignalFlags
---@return Bool
function AISignalCondition:CheckFlagRequirements(gateSignal, checkAgainst) return end

---@param context AIbehaviorScriptExecutionContext
function AISignalCondition:Deactivate(context) return end

---@return String
function AISignalCondition:GetEditorSubCaption() return end

---@return Bool
function AISignalCondition:GetSignalEvaluationOutcome() return end

---@param context AIbehaviorScriptExecutionContext
---@return AISignalHandlerComponent
function AISignalCondition:GetSignalHandler(context) return end

---@return CName
function AISignalCondition:GetSignalName() return end

---@param context AIbehaviorScriptExecutionContext
---@return gameBoolSignalTable
function AISignalCondition:GetSignalTable(context) return end

---@return Bool
function AISignalCondition:IsActivated() return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AISignalCondition:KeepExecuting(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AISignalCondition:StartExecuting(context) return end

---@class AISignalEvent : AITaggedAIEvent
AISignalEvent = {}

---@return AISignalEvent
function AISignalEvent.new() return end

---@param props table
---@return AISignalEvent
function AISignalEvent.new(props) return end

---@class AISignalHandlerComponent : entIComponent
AISignalHandlerComponent = {}

---@return AISignalHandlerComponent
function AISignalHandlerComponent.new() return end

---@param props table
---@return AISignalHandlerComponent
function AISignalHandlerComponent.new(props) return end

---@param entity entEntity
---@return AISignalHandlerComponent
function AISignalHandlerComponent.Get(entity) return end

---@param signal AIGateSignal
---@param keepActive Bool
---@return Uint32
function AISignalHandlerComponent:AddSignal(signal, keepActive) return end

---@param tag CName|string
function AISignalHandlerComponent:ConsumeSignal(tag) return end

---@return Bool, AIGateSignal, Uint32
function AISignalHandlerComponent:GetHighestPrioritySignal() return end

---@param signalId Uint32
---@return Bool, AIGateSignal
function AISignalHandlerComponent:GetSignal(signalId) return end

---@param tag CName|string
---@return Bool
function AISignalHandlerComponent:HasSignalWithTag(tag) return end

---@param tag CName|string
---@return Bool, Uint32
function AISignalHandlerComponent:IsHighestPriority(tag) return end

---@param id Uint32
---@return Bool
function AISignalHandlerComponent:RemoveSignal(id) return end

---@class AISignalSenderTask : AIbehaviortaskScript
---@field tags CName[]
---@field flags EAIGateSignalFlags[]
---@field priority Float
---@field signalId Uint32
AISignalSenderTask = {}

---@param context AIbehaviorScriptExecutionContext
function AISignalSenderTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AISignalSenderTask:Deactivate(context) return end

---@return Float
function AISignalSenderTask:GetSignalLifeTime() return end

---@param context AIbehaviorScriptExecutionContext
---@return gameBoolSignalTable
function AISignalSenderTask:GetSignalTable(context) return end

---@param context AIbehaviorScriptExecutionContext
function AISignalSenderTask:QueueGateSignal(context) return end

---@class AISmartCoverManager : AIISmartCoverManager
AISmartCoverManager = {}

---@return AISmartCoverManager
function AISmartCoverManager.new() return end

---@param props table
---@return AISmartCoverManager
function AISmartCoverManager.new(props) return end

---@param occupant gameObject
---@return AIUninterruptibleActionType
function AISmartCoverManager:GetCoverActionType(occupant) return end

---@param coverId Uint64
---@return gameCoverHeight
function AISmartCoverManager:GetCoverHeight(coverId) return end

---@param coverId Uint64
---@return Vector4
function AISmartCoverManager:GetCoverPosition(coverId) return end

---@param coverId Uint64
---@return Float
function AISmartCoverManager:GetCoverRemainingHealthPercentage(coverId) return end

---@param coverId Uint64
---@return Vector4
function AISmartCoverManager:GetCoverWorldForward(coverId) return end

---@param coverId Uint64
---@return Vector4
function AISmartCoverManager:GetCoverWorldUp(coverId) return end

---@param occupant gameObject
---@return Uint64
function AISmartCoverManager:GetCurrentCover(occupant) return end

---@param nodeRef NodeRef
---@return AICoverDemandHolder
function AISmartCoverManager:GetDemandCoverHolder(nodeRef) return end

---@param coverId Uint64
---@param occupant gameObject
---@param angleMultiplier Float
---@param predictionTime Float
---@param trackingMode gamedataTrackingMode
---@return AITrackedLocation[]
function AISmartCoverManager:GetThreatsNotProtectedFrom(coverId, occupant, angleMultiplier, predictionTime, trackingMode) return end

---@param coverId Uint64
---@param threat gameObject
---@return gameAvailableExposureMethodResult[]
function AISmartCoverManager:GetUsableExposureSpotsForCover(coverId, threat) return end

---@param occupant gameObject
---@param threat gameObject
---@return gameAvailableExposureMethodResult[]
function AISmartCoverManager:GetUsableExposureSpotsForCoverOccupant(occupant, threat) return end

---@param coverId Uint64
---@param threat gameObject
---@param maxTolerance Float
---@return gameAvailableExposureMethodResult[]
function AISmartCoverManager:GetUsableExposureSpotsForCoverTolerance(coverId, threat, maxTolerance) return end

---@param coverId Uint64
---@param threat gameObject
---@param maxTolerance Float
---@param useRoughCalculations Bool
---@return Uint32
function AISmartCoverManager:GetUsableExposureSpotsNumForCoverTolerance(coverId, threat, maxTolerance, useRoughCalculations) return end

---@param coverId Uint64
---@param occupant gameObject
---@return Bool
function AISmartCoverManager:IsCoverAvailable(coverId, occupant) return end

---@param coverIdValue Uint64
---@return Bool
function AISmartCoverManager:IsCoverRegular(coverIdValue) return end

---@param coverId Uint64
---@return Bool
function AISmartCoverManager:IsCoverValid(coverId) return end

---@param occupant gameObject
---@return Bool
function AISmartCoverManager:IsEnteringOrLeavingCover(occupant) return end

---@param coverId Uint64
---@param object gameObject
---@param angleMultiplier Float
---@return Bool
function AISmartCoverManager:IsProtectingHorizontallyAgainstObject(coverId, object, angleMultiplier) return end

---@param coverIdValue Uint64
---@return Bool
function AISmartCoverManager:IsShootingSpot(coverIdValue) return end

---@param occupant gameObject
function AISmartCoverManager:LeaveCoverImmediately(occupant) return end

---@param nodeRef NodeRef
---@return Uint64
function AISmartCoverManager:NodeRefToObjectId(nodeRef) return end

---@param coverId Uint64
---@param damageTime EngineTime
---@param executingCoverAction Bool
---@param isShooting Bool
function AISmartCoverManager:NotifyGotDamageInCover(coverId, damageTime, executingCoverAction, isShooting) return end

---@param coverId Uint64
---@param occupant gameObject
function AISmartCoverManager:RegisterCoverOccupant(coverId, occupant) return end

---@param globalNodeRef worldGlobalNodeRef
---@param isEnabled Bool
function AISmartCoverManager:RegisterCoverPreInstanceData(globalNodeRef, isEnabled) return end

---@param globalNodeRef worldGlobalNodeRef
function AISmartCoverManager:SetCoverDisabled(globalNodeRef) return end

---@param globalNodeRef worldGlobalNodeRef
function AISmartCoverManager:SetCoverEnabled(globalNodeRef) return end

---@param angleDeg Float
function AISmartCoverManager:SetMaxAllowedActionHalfAngleDeg(angleDeg) return end

---@param occupant gameObject
function AISmartCoverManager:UnregisterCoverOccupant(occupant) return end

---@param globalNodeRef worldGlobalNodeRef
function AISmartCoverManager:UnregisterCoverPreInstanceData(globalNodeRef) return end

---@class AISmartObjectManager : AIISmartObjectManager
AISmartObjectManager = {}

---@return AISmartObjectManager
function AISmartObjectManager.new() return end

---@param props table
---@return AISmartObjectManager
function AISmartObjectManager.new(props) return end

---@class AISmartSpot : AISpot
AISmartSpot = {}

---@class AISmartSpotInstance : AISpotInstance
AISmartSpotInstance = {}

---@class AISpiderbotCheckIfFriendlyMoved : AIAutonomousConditions
---@field maxAllowedDelta AIArgumentMapping
AISpiderbotCheckIfFriendlyMoved = {}

---@return AISpiderbotCheckIfFriendlyMoved
function AISpiderbotCheckIfFriendlyMoved.new() return end

---@param props table
---@return AISpiderbotCheckIfFriendlyMoved
function AISpiderbotCheckIfFriendlyMoved.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AISpiderbotCheckIfFriendlyMoved:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AISpiderbotCheckIfFriendlyMoved:Check(context) return end

---@class AISpiderbotFindBoredMovePosition : AIFindPositionAroundSelf
---@field maxWanderDistance AIArgumentMapping
AISpiderbotFindBoredMovePosition = {}

---@return AISpiderbotFindBoredMovePosition
function AISpiderbotFindBoredMovePosition.new() return end

---@param props table
---@return AISpiderbotFindBoredMovePosition
function AISpiderbotFindBoredMovePosition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AISpiderbotFindBoredMovePosition:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AISpiderbotFindBoredMovePosition:AdditionalOutcomeVerification(context) return end

---@class AISpot : ISerializable
AISpot = {}

---@class AISpotInstance
AISpotInstance = {}

---@class AISpotPersistentData
---@field worldPosition WorldPosition
---@field globalNodeId worldGlobalNodeID
---@field yaw Float
---@field isEnabled Bool
AISpotPersistentData = {}

---@return AISpotPersistentData
function AISpotPersistentData.new() return end

---@param props table
---@return AISpotPersistentData
function AISpotPersistentData.new(props) return end

---@class AISpotUsageToken
---@field usedSpotId worldGlobalNodeID
---@field spotUserId entEntityID
AISpotUsageToken = {}

---@return AISpotUsageToken
function AISpotUsageToken.new() return end

---@param props table
---@return AISpotUsageToken
function AISpotUsageToken.new(props) return end

---@class AISquadAudioMemberBase : AISquadMemberBase
AISquadAudioMemberBase = {}

---@return AISquadAudioMemberBase
function AISquadAudioMemberBase.new() return end

---@param props table
---@return AISquadAudioMemberBase
function AISquadAudioMemberBase.new(props) return end

---@class AISquadBase : ISerializable
AISquadBase = {}

---@return AISquadBase
function AISquadBase.new() return end

---@param props table
---@return AISquadBase
function AISquadBase.new(props) return end

---@class AISquadBlackBoardDef : gamebbScriptDefinition
---@field BarkPlayed gamebbScriptID_Bool
---@field LowHealthBarkPlayed gamebbScriptID_Bool
---@field BarkPlayedTimeStamp gamebbScriptID_Float
AISquadBlackBoardDef = {}

---@return AISquadBlackBoardDef
function AISquadBlackBoardDef.new() return end

---@param props table
---@return AISquadBlackBoardDef
function AISquadBlackBoardDef.new(props) return end

---@return Bool
function AISquadBlackBoardDef:AutoCreateInSystem() return end

---@class AISquadCoverSelection : AICoverSelectionParameters
AISquadCoverSelection = {}

---@return AISquadCoverSelection
function AISquadCoverSelection.new() return end

---@param props table
---@return AISquadCoverSelection
function AISquadCoverSelection.new(props) return end

---@class AISquadHelper : IScriptable
AISquadHelper = {}

---@return AISquadHelper
function AISquadHelper.new() return end

---@param props table
---@return AISquadHelper
function AISquadHelper.new(props) return end

---@param owner ScriptedPuppet
function AISquadHelper.EnterAlerted(owner) return end

---@param squadmate ScriptedPuppet
---@param threat entEntity
---@param threatLocation AITrackedLocation
---@return Bool
function AISquadHelper.GeThreatLocationFromSquadmate(squadmate, threat, threatLocation) return end

---@param obj gameObject
---@return AISquadScriptInterface[]
function AISquadHelper.GetAllSquadMemberInterfaces(obj) return end

---@param obj gameObject
---@return Bool, AICombatSquadScriptInterface
function AISquadHelper.GetCombatSquadInterface(obj) return end

---@param puppet ScriptedPuppet
---@return gamedataAIRingType
function AISquadHelper.GetCurrentSquadRing(puppet) return end

---@param obj gameObject
---@return Bool, PlayerSquadInterface
function AISquadHelper.GetPlayerSquadInterface(obj) return end

---@param obj gameObject
---@return Bool, PuppetSquadInterface
function AISquadHelper.GetSquadBaseInterface(obj) return end

---@param obj gameObject
---@return Bool, AISquadScriptInterface
function AISquadHelper.GetSquadMemberInterface(obj) return end

---@param obj gameObject
---@return CName
function AISquadHelper.GetSquadName(obj) return end

---@param obj gameObject
---@param membersList entEntity[]
---@param dontRemoveSelf Bool
---@return Bool
function AISquadHelper.GetSquadmates(obj, membersList, dontRemoveSelf) return end

---@param obj gameObject
---@param dontRemoveSelf Bool
---@return Bool, entEntityID[]
function AISquadHelper.GetSquadmatesID(obj, dontRemoveSelf) return end

---@param puppet ScriptedPuppet
---@param threat entEntity
---@param threatLocation AITrackedLocation
---@return Bool
function AISquadHelper.GetThreatLocationFromSquad(puppet, threat, threatLocation) return end

---@param obj gameObject
---@return Bool
function AISquadHelper.HasSquadMemberComponent(obj) return end

---@param owner ScriptedPuppet
---@param signalName CName|string
---@return Bool
function AISquadHelper.IsSignalActive(owner, signalName) return end

---@param obj gameObject
---@return Bool
function AISquadHelper.LeaveAllSquads(obj) return end

---@param obj gameObject
---@param squadType AISquadType
---@return Bool
function AISquadHelper.LeaveSquad(obj, squadType) return end

---@param puppet ScriptedPuppet
function AISquadHelper.NotifySquadOnIncapacitated(puppet) return end

---@param playerSquadOrderName String
---@return EAIPlayerSquadOrder
function AISquadHelper.PlayerSquadOrderStringToEnum(playerSquadOrderName) return end

---@param puppet ScriptedPuppet
---@param squadType AISquadType
function AISquadHelper.PullSquadSync(puppet, squadType) return end

---@param squadmate ScriptedPuppet
---@param squadType AISquadType
---@param currentTopThreat entEntity
function AISquadHelper.PullSquadSyncOnSquadmate(squadmate, squadType, currentTopThreat) return end

---@param puppet ScriptedPuppet
---@param threat AITrackedLocation
function AISquadHelper.RemoveThreatFromSquad(puppet, threat) return end

---@param squadmate ScriptedPuppet
---@param threat AITrackedLocation
function AISquadHelper.RemoveThreatOnSquadmate(squadmate, threat) return end

---@param member entEntity
---@param actionName CName|string
function AISquadHelper.SendStimFromSquadTargetToMember(member, actionName) return end

---@param type gamedataAIRingType
---@return CName
function AISquadHelper.SquadRingTypeToTicketName(type) return end

---@param type gamedataAIRingType
---@return String
function AISquadHelper.SquadRingTypeToTicketString(type) return end

---@class AISquadIsTracked : AIAIEvent
---@field isSquadTracked Bool
AISquadIsTracked = {}

---@return AISquadIsTracked
function AISquadIsTracked.new() return end

---@param props table
---@return AISquadIsTracked
function AISquadIsTracked.new(props) return end

---@class AISquadManager : AIISquadManager
AISquadManager = {}

---@return AISquadManager
function AISquadManager.new() return end

---@param props table
---@return AISquadManager
function AISquadManager.new(props) return end

---@class AISquadMemberBase : ISerializable
AISquadMemberBase = {}

---@class AISquadNPCMember : AISquadMemberBase
AISquadNPCMember = {}

---@return AISquadNPCMember
function AISquadNPCMember.new() return end

---@param props table
---@return AISquadNPCMember
function AISquadNPCMember.new(props) return end

---@class AISquadScriptInterface : IScriptable
AISquadScriptInterface = {}

---@return AISquadScriptInterface
function AISquadScriptInterface.new() return end

---@param props table
---@return AISquadScriptInterface
function AISquadScriptInterface.new(props) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:AckOrder(sqAction, et) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:Commit(sqAction, et) return end

---@param et entEntity
---@return Uint32[]
function AISquadScriptInterface:GetAllAcknowledgedOrders(et) return end

---@param et entEntity
---@return Uint32[]
function AISquadScriptInterface:GetAllCommitedOrders(et) return end

---@param et entEntity
---@return Uint32[]
function AISquadScriptInterface:GetAllOrders(et) return end

---@return Uint32
function AISquadScriptInterface:GetMembersCount() return end

---@return CName
function AISquadScriptInterface:GetName() return end

---@param orderId Uint32
---@return AIsquadsOrder
function AISquadScriptInterface:GetOrderById(orderId) return end

---@return AISquadType
function AISquadScriptInterface:GetSquadType() return end

---@return CName
function AISquadScriptInterface:GetTemplate() return end

---@param sqAction CName|string
---@param et entEntity
---@return Uint32
function AISquadScriptInterface:GiveOrder(sqAction, et) return end

---@param callThisFunction CName|string
function AISquadScriptInterface:GuardedCall(callThisFunction) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:HasAcknowledgedOrderBySquadAction(sqAction, et) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:HasOrderBySquadAction(sqAction, et) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:IsSquadActionOpen(sqAction, et) return end

---@param et entEntity
---@return Bool
function AISquadScriptInterface:Join(et) return end

---@param et entEntity
---@return Bool
function AISquadScriptInterface:Leave(et) return end

---@return entEntity[]
function AISquadScriptInterface:ListMembers() return end

---@return entEntity[]
function AISquadScriptInterface:ListMembersWeak() return end

---@param sqAction CName|string
---@return entEntity[]
function AISquadScriptInterface:ListMembersWithSquadActionWeak(sqAction) return end

---@return Bool
function AISquadScriptInterface:LockAccess() return end

---@param name CName|string
---@param et entEntity
---@param timeout Float
---@return Bool
function AISquadScriptInterface:OpenSquadAction(name, et, timeout) return end

---@param name CName|string
---@param et entEntity
---@param timeout Float
---@return Bool
function AISquadScriptInterface:RefreshSquadAction(name, et, timeout) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:ReportDone(sqAction, et) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:ReportFail(sqAction, et) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:RequestOrder(sqAction, et) return end

---@param sqAction CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:RevokeOrder(sqAction, et) return end

---@param name CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:RevokeSquadAction(name, et) return end

---@param name CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:TriggerActivation(name, et) return end

---@param name CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:TriggerDeactivation(name, et) return end

---@param name CName|string
---@param et entEntity
---@return Bool
function AISquadScriptInterface:TriggerEvaluation(name, et) return end

---@return Bool
function AISquadScriptInterface:UnlockAccess() return end

---@class AIStackSignalCondition : AIbehaviorStackScriptPassiveExpressionDefinition
---@field signalName CName
AIStackSignalCondition = {}

---@return AIStackSignalCondition
function AIStackSignalCondition.new() return end

---@param props table
---@return AIStackSignalCondition
function AIStackSignalCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return ScriptedPuppet
function AIStackSignalCondition.GetPuppet(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param data AIStackSignalConditionData
---@return Variant
function AIStackSignalCondition:CalculateValue(context, data) return end

---@return String
function AIStackSignalCondition:GetEditorSubCaption() return end

---@param context AIbehaviorScriptExecutionContext
---@return AISignalHandlerComponent
function AIStackSignalCondition:GetSignalHandler(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param data AIStackSignalConditionData
function AIStackSignalCondition:OnActivate(context, data) return end

---@param context AIbehaviorScriptExecutionContext
---@param data AIStackSignalConditionData
function AIStackSignalCondition:OnDeactivate(context, data) return end

---@class AIStackSignalConditionData
---@field callbackId Uint32
---@field lastValue Bool
AIStackSignalConditionData = {}

---@return AIStackSignalConditionData
function AIStackSignalConditionData.new() return end

---@param props table
---@return AIStackSignalConditionData
function AIStackSignalConditionData.new(props) return end

---@class AIStartedBeingTrackedAsHostile : AIAIEvent
AIStartedBeingTrackedAsHostile = {}

---@return AIStartedBeingTrackedAsHostile
function AIStartedBeingTrackedAsHostile.new() return end

---@param props table
---@return AIStartedBeingTrackedAsHostile
function AIStartedBeingTrackedAsHostile.new(props) return end

---@class AIStatListener : gameScriptStatsListener
---@field owner ScriptedPuppet
---@field behaviorCallbackName CName
AIStatListener = {}

---@return AIStatListener
function AIStatListener.new() return end

---@param props table
---@return AIStatListener
function AIStatListener.new(props) return end

---@param ownerID gameStatsObjectID
---@param statType gamedataStatType
---@param diff Float
---@param total Float
function AIStatListener:OnStatChanged(ownerID, statType, diff, total) return end

---@param owner ScriptedPuppet
---@param behaviorCallbackName CName|string
function AIStatListener:SetInitData(owner, behaviorCallbackName) return end

---@class AIStatusEffectCondition : AIbehaviorconditionScript
AIStatusEffectCondition = {}

---@return AIStatusEffectCondition
function AIStatusEffectCondition.new() return end

---@param props table
---@return AIStatusEffectCondition
function AIStatusEffectCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return gameIBlackboard
function AIStatusEffectCondition:GetShootingBlackboard(context) return end

---@class AIStopCoverCommand : AICommand
AIStopCoverCommand = {}

---@return AIStopCoverCommand
function AIStopCoverCommand.new() return end

---@param props table
---@return AIStopCoverCommand
function AIStopCoverCommand.new(props) return end

---@class AIStopCoverCommandParams : questScriptedAICommandParams
AIStopCoverCommandParams = {}

---@return AIStopCoverCommandParams
function AIStopCoverCommandParams.new() return end

---@param props table
---@return AIStopCoverCommandParams
function AIStopCoverCommandParams.new(props) return end

---@return AICommand
function AIStopCoverCommandParams:CreateCommand() return end

---@return String
function AIStopCoverCommandParams:GetCommandName() return end

---@class AIStoppedBeingTrackedAsHostile : AIAIEvent
AIStoppedBeingTrackedAsHostile = {}

---@return AIStoppedBeingTrackedAsHostile
function AIStoppedBeingTrackedAsHostile.new() return end

---@param props table
---@return AIStoppedBeingTrackedAsHostile
function AIStoppedBeingTrackedAsHostile.new(props) return end

---@class AISubActionActivateLightPreset_Record_Implementation : IScriptable
AISubActionActivateLightPreset_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateLightPreset_Record
function AISubActionActivateLightPreset_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateLightPreset_Record
function AISubActionActivateLightPreset_Record_Implementation.ActivateLightPreset(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateLightPreset_Record
---@param duration Float
---@param interrupted Bool
function AISubActionActivateLightPreset_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateLightPreset_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionActivateLightPreset_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionActivateStrongArmsFX_Record_Implementation : IScriptable
AISubActionActivateStrongArmsFX_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateStrongArmsFX_Record
function AISubActionActivateStrongArmsFX_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateStrongArmsFX_Record
---@param duration Float
---@param interrupted Bool
function AISubActionActivateStrongArmsFX_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
function AISubActionActivateStrongArmsFX_Record_Implementation.SpawnStrongArmsFX(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionActivateStrongArmsFX_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionActivateStrongArmsFX_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionAddFact_Record_Implementation : IScriptable
AISubActionAddFact_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAddFact_Record
function AISubActionAddFact_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAddFact_Record
---@param duration Float
---@param interrupted Bool
function AISubActionAddFact_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAddFact_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionAddFact_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionApplyTimeDilation_Record_Implementation : IScriptable
AISubActionApplyTimeDilation_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionApplyTimeDilation_Record
function AISubActionApplyTimeDilation_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionApplyTimeDilation_Record
---@param duration Float
---@param interrupted Bool
function AISubActionApplyTimeDilation_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionApplyTimeDilation_Record
---@return Bool
function AISubActionApplyTimeDilation_Record_Implementation.SetTimeDilation(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionApplyTimeDilation_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionApplyTimeDilation_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionAttackWithWeapon_Record_Implementation : IScriptable
AISubActionAttackWithWeapon_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAttackWithWeapon_Record
function AISubActionAttackWithWeapon_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAttackWithWeapon_Record
---@return AIbehaviorUpdateOutcome
function AISubActionAttackWithWeapon_Record_Implementation.AttackWithWeapon(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAttackWithWeapon_Record
---@param duration Float
---@param interrupted Bool
function AISubActionAttackWithWeapon_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAttackWithWeapon_Record
---@param attack gameAttack_GameEffect
---@param effect gameEffectInstance
function AISubActionAttackWithWeapon_Record_Implementation.FillEffectData(context, record, attack, effect) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAttackWithWeapon_Record
---@return Bool, gameweaponObject
function AISubActionAttackWithWeapon_Record_Implementation.GetWeapon(context, record) return end

---@param weapon gameweaponObject
function AISubActionAttackWithWeapon_Record_Implementation.PrepareContinuousAttack(weapon) return end

---@param context AIbehaviorScriptExecutionContext
---@param attackName CName|string
function AISubActionAttackWithWeapon_Record_Implementation.SetAttackNameInBlackBoard(context, attackName) return end

---@param context AIbehaviorScriptExecutionContext
---@param weapon gameweaponObject
function AISubActionAttackWithWeapon_Record_Implementation.StartContinuousAttack(context, weapon) return end

---@param context AIbehaviorScriptExecutionContext
---@param weapon gameweaponObject
function AISubActionAttackWithWeapon_Record_Implementation.StartPreparedContinuousAttack(context, weapon) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionAttackWithWeapon_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionAttackWithWeapon_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionBlockData_Record_Implementation : IScriptable
AISubActionBlockData_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionBlockData_Record
---@param duration Float
---@param interrupted Bool
function AISubActionBlockData_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionBlockData_Record
---@return Int32
function AISubActionBlockData_Record_Implementation.GetAnimVariation(context, record) return end

---@param blackBoard gameIBlackboard
---@param owner ScriptedPuppet
---@return Int32
function AISubActionBlockData_Record_Implementation.GetAnimVariationInBlackBoard(blackBoard, owner) return end

---@param owner ScriptedPuppet
---@param direction EAIBlockDirection
---@return Int32
function AISubActionBlockData_Record_Implementation.SetAnimVariation(owner, direction) return end

---@param blackBoard gameIBlackboard
---@param owner ScriptedPuppet
---@param animVariation Int32
function AISubActionBlockData_Record_Implementation.SetAnimVariationInBlackBoard(blackBoard, owner, animVariation) return end

---@class AISubActionCallReinforcements_Record_Implementation : IScriptable
AISubActionCallReinforcements_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallReinforcements_Record
function AISubActionCallReinforcements_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallReinforcements_Record
---@param duration Float
---@param interrupted Bool
function AISubActionCallReinforcements_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallReinforcements_Record
function AISubActionCallReinforcements_Record_Implementation.StartCallReinforcement(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallReinforcements_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionCallReinforcements_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionCallSquadSearchBackUp_Record_Implementation : IScriptable
AISubActionCallSquadSearchBackUp_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallSquadSearchBackUp_Record
function AISubActionCallSquadSearchBackUp_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallSquadSearchBackUp_Record
function AISubActionCallSquadSearchBackUp_Record_Implementation.CallBackup(context, record) return end

---@param source gameObject
---@param target gameObject
---@param combatVersion Bool
---@param remainingDuration Float
---@param purelyDirect Bool
function AISubActionCallSquadSearchBackUp_Record_Implementation.CallBackupOneTarget(source, target, combatVersion, remainingDuration, purelyDirect) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallSquadSearchBackUp_Record
---@param duration Float
---@param interrupted Bool
function AISubActionCallSquadSearchBackUp_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCallSquadSearchBackUp_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionCallSquadSearchBackUp_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionChangeAttitude_Record_Implementation : IScriptable
AISubActionChangeAttitude_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeAttitude_Record
function AISubActionChangeAttitude_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeAttitude_Record
function AISubActionChangeAttitude_Record_Implementation.ChangeAttitude(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeAttitude_Record
---@param duration Float
---@param interrupted Bool
function AISubActionChangeAttitude_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeAttitude_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionChangeAttitude_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionChangeCoverSelectionPreset_Record_Implementation : IScriptable
AISubActionChangeCoverSelectionPreset_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeCoverSelectionPreset_Record
function AISubActionChangeCoverSelectionPreset_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeCoverSelectionPreset_Record
---@param duration Float
---@param interrupted Bool
function AISubActionChangeCoverSelectionPreset_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChangeCoverSelectionPreset_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionChangeCoverSelectionPreset_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionChimeraMetalstorm_Record_Implementation : IScriptable
AISubActionChimeraMetalstorm_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChimeraMetalstorm_Record
function AISubActionChimeraMetalstorm_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChimeraMetalstorm_Record
---@param duration Float
---@param interrupted Bool
function AISubActionChimeraMetalstorm_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChimeraMetalstorm_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionChimeraMetalstorm_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionCompleteCommand_Record_Implementation : IScriptable
AISubActionCompleteCommand_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCompleteCommand_Record
function AISubActionCompleteCommand_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
function AISubActionCompleteCommand_Record_Implementation.CompleteCommand(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCompleteCommand_Record
---@param duration Float
---@param interrupted Bool
function AISubActionCompleteCommand_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCompleteCommand_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionCompleteCommand_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionConditionalFailure_Record_Implementation : IScriptable
AISubActionConditionalFailure_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionConditionalFailure_Record
function AISubActionConditionalFailure_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionConditionalFailure_Record
---@param duration Float
---@param interrupted Bool
function AISubActionConditionalFailure_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionConditionalFailure_Record
function AISubActionConditionalFailure_Record_Implementation.StartCooldowns(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionConditionalFailure_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionConditionalFailure_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionCover_Record_Implementation : IScriptable
AISubActionCover_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCover_Record
function AISubActionCover_Record_Implementation.Activate(context, record) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param record gamedataAISubActionCover_Record
---@param target gameObject
---@param lineOfSightTolerance Float
---@param trackedLocation AITrackedLocation
---@param exposureMethods AICoverExposureMethod[]
---@return AICoverExposureMethod
function AISubActionCover_Record_Implementation.CalculateCoverExposureMethod(puppet, coverID, record, target, lineOfSightTolerance, trackedLocation, exposureMethods) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCover_Record
---@param duration Float
---@param interrupted Bool
function AISubActionCover_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param puppet ScriptedPuppet
---@param target gameObject
---@param cm AISmartCoverManager
---@param consideredCoverID Uint64
---@return Bool
function AISubActionCover_Record_Implementation.EvaluateShootingSpot(puppet, target, cm, consideredCoverID) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCover_Record
---@return Int32
function AISubActionCover_Record_Implementation.GetAnimVariation(context, record) return end

---@return Uint64
function AISubActionCover_Record_Implementation.GetInvalidCoverID() return end

---@param context AIbehaviorScriptExecutionContext
---@param cooldown gamedataAIActionCooldown_Record
---@param consideredCoverID Uint64
---@param consideredRing gamedataAIRingType
---@param currentRing gamedataAIRingType
---@param compareRings Bool
---@return Bool
function AISubActionCover_Record_Implementation.SelectCover(context, cooldown, consideredCoverID, consideredRing, currentRing, compareRings) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCover_Record
function AISubActionCover_Record_Implementation.SetCoverData(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param puppet ScriptedPuppet
---@param coverID Uint64
---@param record gamedataAISubActionCover_Record
---@param target gameObject
---@param lineOfSightTolerance Float
function AISubActionCover_Record_Implementation.SetCoverExposureAnim(context, puppet, coverID, record, target, lineOfSightTolerance) return end

---@param context AIbehaviorScriptExecutionContext
function AISubActionCover_Record_Implementation.SetCurrentCover(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCover_Record
function AISubActionCover_Record_Implementation.SetDesiredCover(context, record) return end

---@param puppet ScriptedPuppet
---@param coverID Uint64
function AISubActionCover_Record_Implementation.SetInitialCoverData(puppet, coverID) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCover_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionCover_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionCreateGameEffect_Record_Implementation : IScriptable
AISubActionCreateGameEffect_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCreateGameEffect_Record
function AISubActionCreateGameEffect_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCreateGameEffect_Record
function AISubActionCreateGameEffect_Record_Implementation.CreateGameEffect(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCreateGameEffect_Record
---@param duration Float
---@param interrupted Bool
function AISubActionCreateGameEffect_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCreateGameEffect_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionCreateGameEffect_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionCustomEffectors_Record_Implementation : IScriptable
AISubActionCustomEffectors_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCustomEffectors_Record
function AISubActionCustomEffectors_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCustomEffectors_Record
function AISubActionCustomEffectors_Record_Implementation.ApplyEffectors(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCustomEffectors_Record
function AISubActionCustomEffectors_Record_Implementation.ApplyRemoveEffectors(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCustomEffectors_Record
---@param duration Float
---@param interrupted Bool
function AISubActionCustomEffectors_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCustomEffectors_Record
function AISubActionCustomEffectors_Record_Implementation.RemoveEffectors(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCustomEffectors_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionCustomEffectors_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionDisableAimAssist_Record_Implementation : IScriptable
AISubActionDisableAimAssist_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableAimAssist_Record
function AISubActionDisableAimAssist_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableAimAssist_Record
---@param duration Float
---@param interrupted Bool
function AISubActionDisableAimAssist_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param reason CName|string
function AISubActionDisableAimAssist_Record_Implementation.DisableAimAssist(context, reason) return end

---@param context AIbehaviorScriptExecutionContext
function AISubActionDisableAimAssist_Record_Implementation.EnableAimAssist(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableAimAssist_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionDisableAimAssist_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionDisableCollider_Record_Implementation : IScriptable
AISubActionDisableCollider_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableCollider_Record
function AISubActionDisableCollider_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableCollider_Record
---@param duration Float
---@param interrupted Bool
function AISubActionDisableCollider_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableCollider_Record
---@param duration Float
---@return Bool
function AISubActionDisableCollider_Record_Implementation.IsDelayConditionFulfilled(context, record, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDisableCollider_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionDisableCollider_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionDroneModifyAltitude_Record_Implementation : IScriptable
AISubActionDroneModifyAltitude_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDroneModifyAltitude_Record
function AISubActionDroneModifyAltitude_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDroneModifyAltitude_Record
---@param duration Float
---@param interrupted Bool
function AISubActionDroneModifyAltitude_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param desiredOffset Float
function AISubActionDroneModifyAltitude_Record_Implementation.SetDesiredAltitudeOffset(context, desiredOffset) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionDroneModifyAltitude_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionDroneModifyAltitude_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionEquipOnBody_Record_Implementation : IScriptable
AISubActionEquipOnBody_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionEquipOnBody_Record
function AISubActionEquipOnBody_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionEquipOnBody_Record
---@param duration Float
---@param interrupted Bool
function AISubActionEquipOnBody_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param itemsToEquip NPCItemToEquip[]
---@return Bool
function AISubActionEquipOnBody_Record_Implementation.EquipOnBody(context, itemsToEquip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordEquip_Record
---@param itemsToEquip NPCItemToEquip[]
---@return Bool
function AISubActionEquipOnBody_Record_Implementation.GetItemsToEquip(context, record, itemsToEquip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionEquipOnBody_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionEquipOnBody_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionEquipOnSlot_Record_Implementation : IScriptable
AISubActionEquipOnSlot_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionEquipOnSlot_Record
function AISubActionEquipOnSlot_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param itemsToEquip NPCItemToEquip[]
---@param sendAnimFeature Bool
function AISubActionEquipOnSlot_Record_Implementation.ApplyAnimFeature(context, itemsToEquip, sendAnimFeature) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionEquipOnSlot_Record
---@param duration Float
---@param interrupted Bool
function AISubActionEquipOnSlot_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param itemsToEquip NPCItemToEquip[]
---@param cacheEquipped Bool
---@return Bool
function AISubActionEquipOnSlot_Record_Implementation.Equip(context, itemsToEquip, cacheEquipped) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionEquipOnSlot_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionEquipOnSlot_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionFailIfFriendlyFire_Record_Implementation : IScriptable
AISubActionFailIfFriendlyFire_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFailIfFriendlyFire_Record
function AISubActionFailIfFriendlyFire_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFailIfFriendlyFire_Record
---@param duration Float
---@param interrupted Bool
function AISubActionFailIfFriendlyFire_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFailIfFriendlyFire_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionFailIfFriendlyFire_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionFail_Record_Implementation : IScriptable
AISubActionFail_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFail_Record
function AISubActionFail_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFail_Record
---@param duration Float
---@param interrupted Bool
function AISubActionFail_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFail_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionFail_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionFastExitWorkspot_Record_Implementation : IScriptable
AISubActionFastExitWorkspot_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFastExitWorkspot_Record
function AISubActionFastExitWorkspot_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFastExitWorkspot_Record
---@param duration Float
---@param interrupted Bool
function AISubActionFastExitWorkspot_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFastExitWorkspot_Record
function AISubActionFastExitWorkspot_Record_Implementation.ExitWorkspot(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionFastExitWorkspot_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionFastExitWorkspot_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionForceDeath_Record_Implementation : IScriptable
AISubActionForceDeath_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceDeath_Record
function AISubActionForceDeath_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceDeath_Record
---@param duration Float
---@param interrupted Bool
function AISubActionForceDeath_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceDeath_Record
function AISubActionForceDeath_Record_Implementation.ForceDeath(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceDeath_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionForceDeath_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionForceEquip_Record_Implementation : IScriptable
AISubActionForceEquip_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceEquip_Record
function AISubActionForceEquip_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param itemsToEquip NPCItemToEquip[]
---@param record gamedataAISubActionForceEquip_Record
function AISubActionForceEquip_Record_Implementation.ApplyAnimFeature(context, itemsToEquip, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceEquip_Record
---@param duration Float
---@param interrupted Bool
function AISubActionForceEquip_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceEquip_Record
---@return Bool
function AISubActionForceEquip_Record_Implementation.Equip(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceEquip_Record
---@return Bool, ItemID
function AISubActionForceEquip_Record_Implementation.GetItemID(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceEquip_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionForceEquip_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionForceHitReaction_Record_Implementation : IScriptable
AISubActionForceHitReaction_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceHitReaction_Record
function AISubActionForceHitReaction_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceHitReaction_Record
---@param duration Float
---@param interrupted Bool
function AISubActionForceHitReaction_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param target gameObject
---@param hitDirection Int32
---@param hitIntensity Int32
---@param hitType Int32
---@param hitBodyPart Int32
---@param stance Int32
---@param animVariation Int32
---@param hitSource Int32
function AISubActionForceHitReaction_Record_Implementation.SendForcedHitDataToAIBehavior(target, hitDirection, hitIntensity, hitType, hitBodyPart, stance, animVariation, hitSource) return end

---@param target gameObject
---@param hitDirection Int32
---@param hitIntensity Int32
---@param hitType Int32
---@param hitBodyPart Int32
---@param stance Int32
---@param animVariation Int32
---@param hitSource Int32
function AISubActionForceHitReaction_Record_Implementation.SendForcedTwitchDataToAnimationGraph(target, hitDirection, hitIntensity, hitType, hitBodyPart, stance, animVariation, hitSource) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceHitReaction_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionForceHitReaction_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionForceUnequip_Record_Implementation : IScriptable
AISubActionForceUnequip_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceUnequip_Record
function AISubActionForceUnequip_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceUnequip_Record
function AISubActionForceUnequip_Record_Implementation.ApplyAnimFeature(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceUnequip_Record
---@param duration Float
---@param interrupted Bool
function AISubActionForceUnequip_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceUnequip_Record
---@return Bool
function AISubActionForceUnequip_Record_Implementation.Drop(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceUnequip_Record
---@return Bool
function AISubActionForceUnequip_Record_Implementation.Unequip(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionForceUnequip_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionForceUnequip_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionGameplayLogicPackage_Record_Implementation : IScriptable
AISubActionGameplayLogicPackage_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGameplayLogicPackage_Record
function AISubActionGameplayLogicPackage_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGameplayLogicPackage_Record
function AISubActionGameplayLogicPackage_Record_Implementation.ApplyGameplayLogicPackage(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGameplayLogicPackage_Record
---@param duration Float
---@param interrupted Bool
function AISubActionGameplayLogicPackage_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGameplayLogicPackage_Record
function AISubActionGameplayLogicPackage_Record_Implementation.RemoveGameplayLogicPackage(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGameplayLogicPackage_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionGameplayLogicPackage_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionGeneratePointOfInterestTarget_Record_Implementation : IScriptable
AISubActionGeneratePointOfInterestTarget_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
---@param duration Float
---@param interrupted Bool
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
---@return gameObject
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.GetClosestThreat(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
---@return gameObject
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.GetFriendlyTarget(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
---@return gameObject
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.GetSquadMate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.SetPointOfInterest(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionGeneratePointOfInterestTarget_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionGeneratePointOfInterestTarget_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionHitData_Record_Implementation : IScriptable
AISubActionHitData_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionHitData_Record
---@return Int32
function AISubActionHitData_Record_Implementation.GetAnimVariation(context, record) return end

---@class AISubActionInAir_Record_Implementation : IScriptable
AISubActionInAir_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionInAir_Record
function AISubActionInAir_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionInAir_Record
---@param duration Float
---@param interrupted Bool
function AISubActionInAir_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionInAir_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionInAir_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionInitialReactionParams_Record_Implementation : IScriptable
AISubActionInitialReactionParams_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionInitialReaction_Record
---@return Float
function AISubActionInitialReactionParams_Record_Implementation.GetAnimDirection(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionInitialReaction_Record
---@return Int32
function AISubActionInitialReactionParams_Record_Implementation.GetAnimVariation(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionInitialReaction_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionInitialReactionParams_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionLeaveCover_Record_Implementation : IScriptable
AISubActionLeaveCover_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionLeaveCover_Record
function AISubActionLeaveCover_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionLeaveCover_Record
---@param duration Float
---@param interrupted Bool
function AISubActionLeaveCover_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionLeaveCover_Record
---@return Bool
function AISubActionLeaveCover_Record_Implementation.LeaveCover(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionLeaveCover_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionLeaveCover_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionMeleeAttackAttemptEvent_Record_Implementation : IScriptable
AISubActionMeleeAttackAttemptEvent_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMeleeAttackAttemptEvent_Record
function AISubActionMeleeAttackAttemptEvent_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMeleeAttackAttemptEvent_Record
---@param duration Float
---@param interrupted Bool
function AISubActionMeleeAttackAttemptEvent_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMeleeAttackAttemptEvent_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionMeleeAttackAttemptEvent_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionMeleeAttackManager_Record_Implementation : IScriptable
AISubActionMeleeAttackManager_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMeleeAttackManager_Record
function AISubActionMeleeAttackManager_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMeleeAttackManager_Record
---@param duration Float
---@param interrupted Bool
function AISubActionMeleeAttackManager_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param owner gameObject
---@param weapon gameItemObject
function AISubActionMeleeAttackManager_Record_Implementation.StartStrongArmsTrailEffect(owner, weapon) return end

---@param context AIbehaviorScriptExecutionContext
---@param weapons gameItemObject[]
function AISubActionMeleeAttackManager_Record_Implementation.StartWeaponTrailEffect(context, weapons) return end

---@param context AIbehaviorScriptExecutionContext
---@param weapons gameItemObject[]
function AISubActionMeleeAttackManager_Record_Implementation.StopWeaponTrailEffect(context, weapons) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMeleeAttackManager_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionMeleeAttackManager_Record_Implementation.Update(context, record, duration) return end

---@param owner gameObject
---@param weapon gameItemObject
function AISubActionMeleeAttackManager_Record_Implementation.stopStrongArmsTrailEffect(owner, weapon) return end

---@class AISubActionMissileRainCircular_Record_Implementation : IScriptable
AISubActionMissileRainCircular_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainCircular_Record
function AISubActionMissileRainCircular_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainCircular_Record
---@param duration Float
---@param interrupted Bool
function AISubActionMissileRainCircular_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainCircular_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionMissileRainCircular_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionMissileRainGrid_Record_Implementation : IScriptable
AISubActionMissileRainGrid_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainGrid_Record
function AISubActionMissileRainGrid_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainGrid_Record
---@param duration Float
---@param interrupted Bool
function AISubActionMissileRainGrid_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainGrid_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionMissileRainGrid_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionModifyStatPool_Record_Implementation : IScriptable
AISubActionModifyStatPool_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionModifyStatPool_Record
function AISubActionModifyStatPool_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionModifyStatPool_Record
---@param duration Float
---@param interrupted Bool
function AISubActionModifyStatPool_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionModifyStatPool_Record
function AISubActionModifyStatPool_Record_Implementation.ModifyStatPool(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionModifyStatPool_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionModifyStatPool_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionMountVehicle_Record_Implementation : IScriptable
AISubActionMountVehicle_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMountVehicle_Record
function AISubActionMountVehicle_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMountVehicle_Record
---@param duration Float
---@param interrupted Bool
function AISubActionMountVehicle_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIHumanComponent
function AISubActionMountVehicle_Record_Implementation.GetAIComponent(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMountVehicle_Record
---@return Bool
function AISubActionMountVehicle_Record_Implementation.MountVehicle(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMountVehicle_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionMountVehicle_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionPlaySound_Record_Implementation : IScriptable
AISubActionPlaySound_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlaySound_Record
function AISubActionPlaySound_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlaySound_Record
---@param duration Float
---@param interrupted Bool
function AISubActionPlaySound_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlaySound_Record
function AISubActionPlaySound_Record_Implementation.PlaySound(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlaySound_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionPlaySound_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionPlayVoiceOver_Record_Implementation : IScriptable
AISubActionPlayVoiceOver_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
function AISubActionPlayVoiceOver_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@param duration Float
---@param interrupted Bool
function AISubActionPlayVoiceOver_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@return Bool
function AISubActionPlayVoiceOver_Record_Implementation.IsConditionFulfilled(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@return Bool
function AISubActionPlayVoiceOver_Record_Implementation.IsCooldownConditionFulfilled(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@param duration Float
---@return Bool
function AISubActionPlayVoiceOver_Record_Implementation.IsDelayConditionFulfilled(context, record, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@return Bool
function AISubActionPlayVoiceOver_Record_Implementation.IsSquadmateConditionFulfilled(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@param debugInitContext CName|string
function AISubActionPlayVoiceOver_Record_Implementation.SendVoiceOverEvent(context, record, debugInitContext) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionPlayVoiceOver_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionPlayVoiceOver_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionQueueAIEvent_Record_Implementation : IScriptable
AISubActionQueueAIEvent_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueAIEvent_Record
function AISubActionQueueAIEvent_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueAIEvent_Record
---@param duration Float
---@param interrupted Bool
function AISubActionQueueAIEvent_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueAIEvent_Record
function AISubActionQueueAIEvent_Record_Implementation.QueueAIEvent(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueAIEvent_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionQueueAIEvent_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionQueueCommunicationEvent_Record_Implementation : IScriptable
AISubActionQueueCommunicationEvent_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueCommunicationEvent_Record
function AISubActionQueueCommunicationEvent_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueCommunicationEvent_Record
---@param duration Float
---@param interrupted Bool
function AISubActionQueueCommunicationEvent_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueCommunicationEvent_Record
function AISubActionQueueCommunicationEvent_Record_Implementation.QueueCommunicationEvent(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQueueCommunicationEvent_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionQueueCommunicationEvent_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionQuickHack_Record_Implementation : IScriptable
AISubActionQuickHack_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQuickHack_Record
function AISubActionQuickHack_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQuickHack_Record
function AISubActionQuickHack_Record_Implementation.CancelConnection(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQuickHack_Record
---@param duration Float
---@param interrupted Bool
function AISubActionQuickHack_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQuickHack_Record
function AISubActionQuickHack_Record_Implementation.Hack(context, record) return end

---@param netrunner gameObject
---@param proxy gameObject
---@param target gameObject
---@param from gameObject
---@param to gameObject
function AISubActionQuickHack_Record_Implementation.SendNetworkLinkEvent(netrunner, proxy, target, from, to) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQuickHack_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionQuickHack_Record_Implementation.Update(context, record, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionQuickHack_Record
function AISubActionQuickHack_Record_Implementation.VisualiseConnection(context, record) return end

---@class AISubActionRandomize_Record_Implementation : IScriptable
AISubActionRandomize_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionRandomize_Record
---@param duration Float
---@param interrupted Bool
function AISubActionRandomize_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionRandomize_Record
---@return Int32
function AISubActionRandomize_Record_Implementation.GetAnimVariation(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionRandomize_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionRandomize_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionRegisterActionName_Record_Implementation : IScriptable
AISubActionRegisterActionName_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionRegisterActionName_Record
function AISubActionRegisterActionName_Record_Implementation.Activate(context, record) return end

---@class AISubActionReloadWeapon_Record_Implementation : IScriptable
AISubActionReloadWeapon_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionReloadWeapon_Record
function AISubActionReloadWeapon_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionReloadWeapon_Record
---@param duration Float
---@param interrupted Bool
function AISubActionReloadWeapon_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionReloadWeapon_Record
---@return Bool, gameweaponObject
function AISubActionReloadWeapon_Record_Implementation.GetWeapon(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionReloadWeapon_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionReloadWeapon_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionScaleDurationWithDistance_Record_Implementation : IScriptable
AISubActionScaleDurationWithDistance_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionScaleDurationWithDistance_Record
function AISubActionScaleDurationWithDistance_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionScaleDurationWithDistance_Record
---@param duration Float
---@param interrupted Bool
function AISubActionScaleDurationWithDistance_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionScaleDurationWithDistance_Record
---@param actionPhase Int32
---@param baseDuration Float
---@return Float
function AISubActionScaleDurationWithDistance_Record_Implementation.GetPhaseDuration(context, record, actionPhase, baseDuration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionScaleDurationWithDistance_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionScaleDurationWithDistance_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSecuritySystemNotification_Record_Implementation : IScriptable
AISubActionSecuritySystemNotification_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSecuritySystemNotification_Record
function AISubActionSecuritySystemNotification_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSecuritySystemNotification_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSecuritySystemNotification_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSecuritySystemNotification_Record
function AISubActionSecuritySystemNotification_Record_Implementation.NotifySecuritySystem(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSecuritySystemNotification_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSecuritySystemNotification_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSendSignal_Record_Implementation : IScriptable
AISubActionSendSignal_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSendSignal_Record
function AISubActionSendSignal_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSendSignal_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSendSignal_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSendSignal_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSendSignal_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetEquipPrimaryWeapons_Record_Implementation : IScriptable
AISubActionSetEquipPrimaryWeapons_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetEquipPrimaryWeapons_Record
function AISubActionSetEquipPrimaryWeapons_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetEquipPrimaryWeapons_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetEquipPrimaryWeapons_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordEquip_Record
---@param itemsToEquip NPCItemToEquip[]
---@return Bool
function AISubActionSetEquipPrimaryWeapons_Record_Implementation.GetItemsToEquip(context, record, itemsToEquip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetEquipPrimaryWeapons_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetEquipPrimaryWeapons_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetEquipSecondaryWeapons_Record_Implementation : IScriptable
AISubActionSetEquipSecondaryWeapons_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetEquipSecondaryWeapons_Record
function AISubActionSetEquipSecondaryWeapons_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetEquipSecondaryWeapons_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetEquipSecondaryWeapons_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordEquip_Record
---@param itemsToEquip NPCItemToEquip[]
---@return Bool
function AISubActionSetEquipSecondaryWeapons_Record_Implementation.GetItemsToEquip(context, record, itemsToEquip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetEquipSecondaryWeapons_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetEquipSecondaryWeapons_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetEquipWeaponsUtils : IScriptable
AISubActionSetEquipWeaponsUtils = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordEquip_Record
---@param itemsToEquip NPCItemToEquip[]
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetEquipWeaponsUtils.Update(context, record, itemsToEquip, duration) return end

---@class AISubActionSetInfluenceMap_Record_Implementation : IScriptable
AISubActionSetInfluenceMap_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInfluenceMap_Record
function AISubActionSetInfluenceMap_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInfluenceMap_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetInfluenceMap_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInfluenceMap_Record
function AISubActionSetInfluenceMap_Record_Implementation.SetInfluenceMap(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInfluenceMap_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetInfluenceMap_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetInt_Record_Implementation : IScriptable
AISubActionSetInt_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInt_Record
function AISubActionSetInt_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInt_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetInt_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetInt_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetInt_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetStimSource_Record_Implementation : IScriptable
AISubActionSetStimSource_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetStimSource_Record
function AISubActionSetStimSource_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetStimSource_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetStimSource_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetStimSource_Record
function AISubActionSetStimSource_Record_Implementation.SetStimSource(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetStimSource_Record
---@param position Vector4
function AISubActionSetStimSource_Record_Implementation.SetStimSourcePosition(context, record, position) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetStimSource_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetStimSource_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetTargetByTag_Record_Implementation : IScriptable
AISubActionSetTargetByTag_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTargetByTag_Record
function AISubActionSetTargetByTag_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param startPosition Vector4
---@param endPosition Vector4
---@param offMeshTags CName[]|string[]
---@return Bool
function AISubActionSetTargetByTag_Record_Implementation.CheckPath(context, startPosition, endPosition, offMeshTags) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTargetByTag_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetTargetByTag_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param minOwnerDistance Float
---@param maxOwnerDistance Float
---@param ownerDistances Float[]
---@param minDistanceObj Float
---@param maxDistanceObj Float
---@param distancesObj Float[]
---@param targetsPosition Vector4[]
---@param allowedOffMeshTags CName[]|string[]
---@param lineOfSightTarget Vector4
---@param blockLoSByNonPenetrableObj Bool
---@return Int32
function AISubActionSetTargetByTag_Record_Implementation.GetClosestIndexInRange(context, minOwnerDistance, maxOwnerDistance, ownerDistances, minDistanceObj, maxDistanceObj, distancesObj, targetsPosition, allowedOffMeshTags, lineOfSightTarget, blockLoSByNonPenetrableObj) return end

---@param context AIbehaviorScriptExecutionContext
---@param targets entEntity[]
---@param distances Float[]
---@return Bool
function AISubActionSetTargetByTag_Record_Implementation.GetDistancesFromEntity(context, targets, distances) return end

---@param context AIbehaviorScriptExecutionContext
---@param target Vector4
---@param positions Vector4[]
---@param outDistances Float[]
---@return Bool
function AISubActionSetTargetByTag_Record_Implementation.GetDistancesFromTargetToPositions(context, target, positions, outDistances) return end

---@param context AIbehaviorScriptExecutionContext
---@param minOwnerDistance Float
---@param maxOwnerDistance Float
---@param ownerDistances Float[]
---@param minDistanceObj Float
---@param maxDistanceObj Float
---@param distancesObj Float[]
---@param targetsPosition Vector4[]
---@param allowedOffMeshTags CName[]|string[]
---@param lineOfSightTarget Vector4
---@param blockLoSByNonPenetrableObj Bool
---@return Int32
function AISubActionSetTargetByTag_Record_Implementation.GetFarthestIndexInRange(context, minOwnerDistance, maxOwnerDistance, ownerDistances, minDistanceObj, maxDistanceObj, distancesObj, targetsPosition, allowedOffMeshTags, lineOfSightTarget, blockLoSByNonPenetrableObj) return end

---@param context AIbehaviorScriptExecutionContext
---@param targets entEntity[]
---@param positions Vector4[]
---@return Bool
function AISubActionSetTargetByTag_Record_Implementation.GetPositionsFromEntity(context, targets, positions) return end

---@param context AIbehaviorScriptExecutionContext
---@param minOwnerDistance Float
---@param maxOwnerDistance Float
---@param ownerDistances Float[]
---@param minDistanceObj Float
---@param maxDistanceObj Float
---@param distancesObj Float[]
---@param allowedOffMeshTags CName[]|string[]
---@param targetsPosition Vector4[]
---@param lineOfSightTarget Vector4
---@param blockLoSByNonPenetrableObj Bool
---@return Int32
function AISubActionSetTargetByTag_Record_Implementation.GetRandomIndexInRange(context, minOwnerDistance, maxOwnerDistance, ownerDistances, minDistanceObj, maxDistanceObj, distancesObj, allowedOffMeshTags, targetsPosition, lineOfSightTarget, blockLoSByNonPenetrableObj) return end

---@param context AIbehaviorScriptExecutionContext
---@param selectionPreference CName|string
---@param minDistance Float
---@param maxDistance Float
---@param distances Float[]
---@param minDistanceObj Float
---@param maxDistanceObj Float
---@param distancesObj Float[]
---@param targetsPosition Vector4[]
---@param allowedOffMeshTags CName[]|string[]
---@param lineOfSightTarget Vector4
---@param blockLoSByNonPenetrableObj Bool
---@return Int32
function AISubActionSetTargetByTag_Record_Implementation.SelectIndex(context, selectionPreference, minDistance, maxDistance, distances, minDistanceObj, maxDistanceObj, distancesObj, targetsPosition, allowedOffMeshTags, lineOfSightTarget, blockLoSByNonPenetrableObj) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTargetByTag_Record
---@return Bool
function AISubActionSetTargetByTag_Record_Implementation.SetTargetByTag(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTargetByTag_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetTargetByTag_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetTopThreatPersistance_Record_Implementation : IScriptable
AISubActionSetTopThreatPersistance_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTopThreatPersistance_Record
function AISubActionSetTopThreatPersistance_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTopThreatPersistance_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetTopThreatPersistance_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTopThreatPersistance_Record
function AISubActionSetTopThreatPersistance_Record_Implementation.ResetAllThreatsPersistenceForSource(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTopThreatPersistance_Record
---@param set Bool
function AISubActionSetTopThreatPersistance_Record_Implementation.SetTopThreatPersistance(context, record, set) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetTopThreatPersistance_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetTopThreatPersistance_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetUnequipPrimaryWeapons_Record_Implementation : IScriptable
AISubActionSetUnequipPrimaryWeapons_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetUnequipPrimaryWeapons_Record
function AISubActionSetUnequipPrimaryWeapons_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetUnequipPrimaryWeapons_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetUnequipPrimaryWeapons_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordUnequip_Record
---@param itemsToUnequip NPCItemToEquip[]
---@return Bool
function AISubActionSetUnequipPrimaryWeapons_Record_Implementation.GetItemsToUnequip(context, record, itemsToUnequip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetUnequipPrimaryWeapons_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetUnequipPrimaryWeapons_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetUnequipSecondaryWeapons_Record_Implementation : IScriptable
AISubActionSetUnequipSecondaryWeapons_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetUnequipSecondaryWeapons_Record
function AISubActionSetUnequipSecondaryWeapons_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetUnequipSecondaryWeapons_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetUnequipSecondaryWeapons_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordUnequip_Record
---@param itemsToUnequip NPCItemToEquip[]
---@return Bool
function AISubActionSetUnequipSecondaryWeapons_Record_Implementation.GetItemsToUnequip(context, record, itemsToUnequip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetUnequipSecondaryWeapons_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetUnequipSecondaryWeapons_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetUnequipWeaponsUtils : IScriptable
AISubActionSetUnequipWeaponsUtils = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionCharacterRecordUnequip_Record
---@param itemsToUnequip NPCItemToEquip[]
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetUnequipWeaponsUtils.Update(context, record, itemsToUnequip, duration) return end

---@class AISubActionSetWaypointByTag_Record_Implementation : IScriptable
AISubActionSetWaypointByTag_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWaypointByTag_Record
function AISubActionSetWaypointByTag_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWaypointByTag_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSetWaypointByTag_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWaypointByTag_Record
---@return Bool
function AISubActionSetWaypointByTag_Record_Implementation.SetWaypointByTag(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWaypointByTag_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetWaypointByTag_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSetWorldPosition_Record_Implementation : IScriptable
AISubActionSetWorldPosition_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWorldPosition_Record
function AISubActionSetWorldPosition_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWorldPosition_Record
---@return Vector4
function AISubActionSetWorldPosition_Record_Implementation.CalculateWorldPosition(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool, Vector4
function AISubActionSetWorldPosition_Record_Implementation.GetNavmeshPosition(context) return end

---@param minOffset Vector3
---@param maxOffset Vector3
---@return Vector3
function AISubActionSetWorldPosition_Record_Implementation.GetRandomOffset(minOffset, maxOffset) return end

---@param context AIbehaviorScriptExecutionContext
---@param referenceTarget gamedataAIActionTarget_Record
---@param offset Vector3
---@param useLocalSpace Bool
---@return Vector4
function AISubActionSetWorldPosition_Record_Implementation.GetWorldPositionWithOffset(context, referenceTarget, offset, useLocalSpace) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSetWorldPosition_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSetWorldPosition_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionShootFromCar_Record_Implementation : IScriptable
AISubActionShootFromCar_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootFromCar_Record
function AISubActionShootFromCar_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootFromCar_Record
---@param duration Float
---@param interrupted Bool
function AISubActionShootFromCar_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootFromCar_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionShootFromCar_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionShootToPoint_Record_Implementation : IScriptable
AISubActionShootToPoint_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootToPoint_Record
function AISubActionShootToPoint_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootToPoint_Record
---@param duration Float
---@param interrupted Bool
function AISubActionShootToPoint_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootToPoint_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionShootToPoint_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionShootWithWeapon_Record_Implementation : IScriptable
AISubActionShootWithWeapon_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootWithWeapon_Record
function AISubActionShootWithWeapon_Record_Implementation.Activate(context, record) return end

---@param v3 Vector3[]
---@return Vector4[]
function AISubActionShootWithWeapon_Record_Implementation.ConvertVector3ArrayToVector4Array(v3) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootWithWeapon_Record
---@param duration Float
---@param interrupted Bool
function AISubActionShootWithWeapon_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootWithWeapon_Record
---@param weaponsList gameweaponObject[]
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.GetWeapon(context, record, weaponsList) return end

---@param weapon gameweaponObject
function AISubActionShootWithWeapon_Record_Implementation.QueueFirstShot(weapon) return end

---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param duration Float
function AISubActionShootWithWeapon_Record_Implementation.QueueNextShot(weapon, requestedTriggerMode, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param target gameObject
---@param coordinateArray Vector4[]
---@param shootPointPosition Vector4[]
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.SetShootPointsByCoordinate(context, target, coordinateArray, shootPointPosition) return end

---@param context AIbehaviorScriptExecutionContext
---@param tags CName[]|string[]
---@param shootPointPosition Vector4[]
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.SetShootPointsBytag(context, tags, shootPointPosition) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootWithWeapon_Record
---@param duration Float
---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param targetPosition Vector4
---@param target gameObject
---@param offset Vector4
---@param predictionTime Float
---@param muzzleOffset Vector4
---@param weaponCustomEvent CName|string
function AISubActionShootWithWeapon_Record_Implementation.Shoot(context, record, duration, weapon, requestedTriggerMode, targetPosition, target, offset, predictionTime, muzzleOffset, weaponCustomEvent) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionChimeraMetalstorm_Record
---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param target gameObject
---@param targetPosition Vector4
---@param duration Float
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.ShootChimeraMetalstorm(context, record, weapon, requestedTriggerMode, target, targetPosition, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainCircular_Record
---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param target gameObject
---@param targetPosition Vector4
---@param duration Float
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.ShootMissileRainCircular(context, record, weapon, requestedTriggerMode, target, targetPosition, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionMissileRainGrid_Record
---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param target gameObject
---@param targetPosition Vector4
---@param duration Float
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.ShootMissileRainGrid(context, record, weapon, requestedTriggerMode, target, targetPosition, duration) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootToPoint_Record
---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param duration Float
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.ShootToPoints(context, record, weapon, requestedTriggerMode, duration) return end

---@param owner gamePuppet
---@param record gamedataAISubActionShootWithWeapon_Record
---@param weapon gameweaponObject
---@return Bool
function AISubActionShootWithWeapon_Record_Implementation.ShouldTrackTarget(owner, record, weapon) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionShootWithWeapon_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionShootWithWeapon_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSpawnFX_Record_Implementation : IScriptable
AISubActionSpawnFX_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSpawnFX_Record
function AISubActionSpawnFX_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSpawnFX_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSpawnFX_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSpawnFX_Record
function AISubActionSpawnFX_Record_Implementation.DespawnFX(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSpawnFX_Record
function AISubActionSpawnFX_Record_Implementation.SpawnFX(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSpawnFX_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSpawnFX_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionSquadSync_Record_Implementation : IScriptable
AISubActionSquadSync_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSquadSync_Record
function AISubActionSquadSync_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSquadSync_Record
---@param duration Float
---@param interrupted Bool
function AISubActionSquadSync_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSquadSync_Record
function AISubActionSquadSync_Record_Implementation.SquadSync(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionSquadSync_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionSquadSync_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionStartCooldown_Record_Implementation : IScriptable
AISubActionStartCooldown_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStartCooldown_Record
function AISubActionStartCooldown_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStartCooldown_Record
---@param duration Float
---@param interrupted Bool
function AISubActionStartCooldown_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStartCooldown_Record
function AISubActionStartCooldown_Record_Implementation.StartCooldowns(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStartCooldown_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionStartCooldown_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionStatusEffect_Record_Implementation : IScriptable
AISubActionStatusEffect_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStatusEffect_Record
function AISubActionStatusEffect_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStatusEffect_Record
function AISubActionStatusEffect_Record_Implementation.ApplyRemoveStatusEffect(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStatusEffect_Record
function AISubActionStatusEffect_Record_Implementation.ApplyStatusEffect(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStatusEffect_Record
---@param duration Float
---@param interrupted Bool
function AISubActionStatusEffect_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStatusEffect_Record
function AISubActionStatusEffect_Record_Implementation.RemoveStatusEffect(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionStatusEffect_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionStatusEffect_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionThrowItem_Record_Implementation : IScriptable
AISubActionThrowItem_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionThrowItem_Record
function AISubActionThrowItem_Record_Implementation.Activate(context, record) return end

---@param target gameObject
---@param paramsTDBRecord TweakDBID|string
---@param predictionTime Float
---@return gameprojectileTrajectoryParams
function AISubActionThrowItem_Record_Implementation.CreateCurvedTrajectory(target, paramsTDBRecord, predictionTime) return end

---@param target gameObject
---@param slotName CName|string
---@param paramsTDBRecord TweakDBID|string
---@return gameprojectileTrajectoryParams
function AISubActionThrowItem_Record_Implementation.CreateCurvedTrajectoryFollowTargetSlot(target, slotName, paramsTDBRecord) return end

---@param record gamedataAISubActionThrowItem_Record
---@param targetPosition Vector4
---@param throwAngle Float
---@return gameprojectileTrajectoryParams
function AISubActionThrowItem_Record_Implementation.CreateParabolicTrajectory(record, targetPosition, throwAngle) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionThrowItem_Record
---@param duration Float
---@param interrupted Bool
function AISubActionThrowItem_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionThrowItem_Record
function AISubActionThrowItem_Record_Implementation.DropItem(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param outStartType gameGrenadeThrowStartType
---@return Bool, Vector4, Float
function AISubActionThrowItem_Record_Implementation.GetCachedGrenadeQuery(context, outStartType) return end

---@param paramsTDBRecord TweakDBID|string
---@return gameprojectileFollowCurveTrajectoryParams
function AISubActionThrowItem_Record_Implementation.ReadCurvedTrajectoryTDBParams(paramsTDBRecord) return end

---@param context AIbehaviorScriptExecutionContext
function AISubActionThrowItem_Record_Implementation.SetNPCThrowingGrenade(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionThrowItem_Record
function AISubActionThrowItem_Record_Implementation.ThrowInit(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionThrowItem_Record
---@return Bool
function AISubActionThrowItem_Record_Implementation.ThrowItem(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionThrowItem_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionThrowItem_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionTriggerItemActivation_Record_Implementation : IScriptable
AISubActionTriggerItemActivation_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerItemActivation_Record
function AISubActionTriggerItemActivation_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerItemActivation_Record
---@param duration Float
---@param interrupted Bool
function AISubActionTriggerItemActivation_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerItemActivation_Record
function AISubActionTriggerItemActivation_Record_Implementation.TriggerActivation(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerItemActivation_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionTriggerItemActivation_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionTriggerStim_Record_Implementation : IScriptable
AISubActionTriggerStim_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerStim_Record
function AISubActionTriggerStim_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerStim_Record
---@param duration Float
---@param interrupted Bool
function AISubActionTriggerStim_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerStim_Record
function AISubActionTriggerStim_Record_Implementation.TriggerStim(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionTriggerStim_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionTriggerStim_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionUnequipOnSlot_Record_Implementation : IScriptable
AISubActionUnequipOnSlot_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUnequipOnSlot_Record
function AISubActionUnequipOnSlot_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param itemsToUnequip NPCItemToEquip[]
function AISubActionUnequipOnSlot_Record_Implementation.ApplyAnimFeature(context, itemsToUnequip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUnequipOnSlot_Record
---@param duration Float
---@param interrupted Bool
function AISubActionUnequipOnSlot_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param itemToUnequip NPCItemToEquip
---@return Bool
function AISubActionUnequipOnSlot_Record_Implementation.Drop(context, itemToUnequip) return end

---@param context AIbehaviorScriptExecutionContext
---@param dropItem Bool
---@param itemsToUnequip NPCItemToEquip[]
---@return Bool
function AISubActionUnequipOnSlot_Record_Implementation.Unequip(context, dropItem, itemsToUnequip) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUnequipOnSlot_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionUnequipOnSlot_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionUpdateFriendlyFireParams_Record_Implementation : IScriptable
AISubActionUpdateFriendlyFireParams_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUpdateFriendlyFireParams_Record
function AISubActionUpdateFriendlyFireParams_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUpdateFriendlyFireParams_Record
---@param duration Float
---@param interrupted Bool
function AISubActionUpdateFriendlyFireParams_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param equippedItemType gamedataItemType
---@param ffs gameIFriendlyFireSystem
function AISubActionUpdateFriendlyFireParams_Record_Implementation.SetFriendlyFireGeometry(equippedItemType, ffs) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUpdateFriendlyFireParams_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionUpdateFriendlyFireParams_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionUseSensePreset_Record_Implementation : IScriptable
AISubActionUseSensePreset_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUseSensePreset_Record
function AISubActionUseSensePreset_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUseSensePreset_Record
---@param duration Float
---@param interrupted Bool
function AISubActionUseSensePreset_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionUseSensePreset_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionUseSensePreset_Record_Implementation.Update(context, record, duration) return end

---@class AISubActionWorkspot_Record_Implementation : IScriptable
AISubActionWorkspot_Record_Implementation = {}

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionWorkspot_Record
function AISubActionWorkspot_Record_Implementation.Activate(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionWorkspot_Record
---@param duration Float
---@param interrupted Bool
function AISubActionWorkspot_Record_Implementation.Deactivate(context, record, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionWorkspot_Record
function AISubActionWorkspot_Record_Implementation.ReleaseWorkspot(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionWorkspot_Record
function AISubActionWorkspot_Record_Implementation.ReserveWorkspot(context, record) return end

---@param context AIbehaviorScriptExecutionContext
---@param record gamedataAISubActionWorkspot_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AISubActionWorkspot_Record_Implementation.Update(context, record, duration) return end

---@class AISwitchToPrimaryWeaponCommand : AICommand
---@field unEquip Bool
AISwitchToPrimaryWeaponCommand = {}

---@return AISwitchToPrimaryWeaponCommand
function AISwitchToPrimaryWeaponCommand.new() return end

---@param props table
---@return AISwitchToPrimaryWeaponCommand
function AISwitchToPrimaryWeaponCommand.new(props) return end

---@class AISwitchToSecondaryWeaponCommand : AICommand
---@field unEquip Bool
AISwitchToSecondaryWeaponCommand = {}

---@return AISwitchToSecondaryWeaponCommand
function AISwitchToSecondaryWeaponCommand.new() return end

---@param props table
---@return AISwitchToSecondaryWeaponCommand
function AISwitchToSecondaryWeaponCommand.new(props) return end

---@class AISystemImpl : AIISystem
AISystemImpl = {}

---@return AISystemImpl
function AISystemImpl.new() return end

---@param props table
---@return AISystemImpl
function AISystemImpl.new(props) return end

---@class AITacticLimiter : AICoverSelectionParameters
AITacticLimiter = {}

---@return AITacticLimiter
function AITacticLimiter.new() return end

---@param props table
---@return AITacticLimiter
function AITacticLimiter.new(props) return end

---@class AITaggedAIEvent : AIAIEvent
---@field tags CName[]
AITaggedAIEvent = {}

---@return AITaggedAIEvent
function AITaggedAIEvent.new() return end

---@param props table
---@return AITaggedAIEvent
function AITaggedAIEvent.new(props) return end

---@param tag CName|string
function AITaggedAIEvent:AddTag(tag) return end

---@class AITakedownHandler : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AITakedownHandler = {}

---@return AITakedownHandler
function AITakedownHandler.new() return end

---@param props table
---@return AITakedownHandler
function AITakedownHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AITakedownHandler:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AITakedownHandler:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AITakedownHandler:Update(context) return end

---@class AITarget : AIITarget
AITarget = {}

---@return AITarget
function AITarget.new() return end

---@param props table
---@return AITarget
function AITarget.new(props) return end

---@class AITargetNodeInstance : AIITarget
AITargetNodeInstance = {}

---@return AITargetNodeInstance
function AITargetNodeInstance.new() return end

---@param props table
---@return AITargetNodeInstance
function AITargetNodeInstance.new(props) return end

---@class AITargetTrackerComponent : gameComponent
---@field TriggersCombat Bool
AITargetTrackerComponent = {}

---@return AITargetTrackerComponent
function AITargetTrackerComponent.new() return end

---@param props table
---@return AITargetTrackerComponent
function AITargetTrackerComponent.new(props) return end

---@param et entEntity
function AITargetTrackerComponent:ActivateThreat(et) return end

---@param et entEntity
---@param value Float
function AITargetTrackerComponent:AddDroppingCooldown(et, value) return end

---@param et entEntity
---@param isHostile Bool
---@param pos Vector4
---@param accuracy Float
---@param cooldown Float
---@param isPersistent Bool
---@return Uint32
function AITargetTrackerComponent:AddThreat(et, isHostile, pos, accuracy, cooldown, isPersistent) return end

---@param pos Vector4
---@param timeToLive Float
---@return Uint32
function AITargetTrackerComponent:AddThreatOnPosition(pos, timeToLive) return end

function AITargetTrackerComponent:ClearForceDetected() return end

function AITargetTrackerComponent:ClearThreats() return end

---@param onlyHostiles Bool
---@param onlyInContact Bool
---@return entEntity[]
function AITargetTrackerComponent:CollectTrackers(onlyHostiles, onlyInContact) return end

---@param et entEntity
function AITargetTrackerComponent:DeactivateThreat(et) return end

---@return TweakDBID
function AITargetTrackerComponent:GetCurrentPreset() return end

---@param et entEntity
---@return Float
function AITargetTrackerComponent:GetDroppingCooldown(et) return end

---@param onlyVisible Bool
---@return AITrackedLocation[]
function AITargetTrackerComponent:GetHostileThreats(onlyVisible) return end

---@return AIDroppedThreatData
function AITargetTrackerComponent:GetRecentlyDroppedThreat() return end

---@param threat entEntity
---@param offset Vector3
---@param failIfVisible Bool
---@param slotName CName|string
---@param failSafeProvider entIPositionProvider
---@return entIPositionProvider
function AITargetTrackerComponent:GetThreatBeliefPositionProvider(threat, offset, failIfVisible, slotName, failSafeProvider) return end

---@param threat entEntity
---@param offset Vector3
---@param failIfVisible Bool
---@param slotName CName|string
---@param failSafeProvider entIPositionProvider
---@return entIPositionProvider
function AITargetTrackerComponent:GetThreatLastKnownPositionProvider(threat, offset, failIfVisible, slotName, failSafeProvider) return end

---@param et entEntity
---@return AIThreatPersistenceStatus
function AITargetTrackerComponent:GetThreatPersistence(et) return end

---@param et entEntity
---@param src Uint32
---@return AIThreatPersistenceStatus
function AITargetTrackerComponent:GetThreatPersistenceBySource(et, src) return end

---@param attackers Uint32
---@return Float
function AITargetTrackerComponent:GetThreatPriorityModFromAttackersCurve(attackers) return end

---@param distanceFromThreat Float
---@return Float
function AITargetTrackerComponent:GetThreatPriorityModFromDistCurve(distanceFromThreat) return end

---@param timeSinceLastDmg Float
---@return Float
function AITargetTrackerComponent:GetThreatPriorityModFromDmgCurve(timeSinceLastDmg) return end

---@param timeSinceTargetChange Float
---@return Float
function AITargetTrackerComponent:GetThreatPriorityModFromHisteresisCurve(timeSinceTargetChange) return end

---@param threat entEntity
---@param offset Vector3
---@param failIfVisible Bool
---@param slotName CName|string
---@param failSafeProvider entIPositionProvider
---@return entIPositionProvider
function AITargetTrackerComponent:GetThreatSharedBeliefPositionProvider(threat, offset, failIfVisible, slotName, failSafeProvider) return end

---@param threat entEntity
---@param offset Vector3
---@param failIfVisible Bool
---@param slotName CName|string
---@param failSafeProvider entIPositionProvider
---@return entIPositionProvider
function AITargetTrackerComponent:GetThreatSharedLastKnownPositionProvider(threat, offset, failIfVisible, slotName, failSafeProvider) return end

---@param onlyVisible Bool
---@return AITrackedLocation[]
function AITargetTrackerComponent:GetThreats(onlyVisible) return end

---@param onlyVisible Bool
---@return Bool, AITrackedLocation
function AITargetTrackerComponent:GetTopHostileThreat(onlyVisible) return end

---@param et entEntity
---@return Float
function AITargetTrackerComponent:GetVisibleThreatBeliefAccuracy(et) return end

---@param onlyVisible Bool
---@param onlyEntities Bool
---@return Bool
function AITargetTrackerComponent:HasHostileThreat(onlyVisible, onlyEntities) return end

---@param pos Vector4
---@return Bool
function AITargetTrackerComponent:IsPositionValid(pos) return end

---@param et entEntity
---@return Uint32
function AITargetTrackerComponent:MapThreat(et) return end

---@param sqType AISquadType
function AITargetTrackerComponent:PullSquadSync(sqType) return end

---@param sqType AISquadType
function AITargetTrackerComponent:PushSquadSync(sqType) return end

---@param et entEntity
---@param listener AIScriptsTargetTrackingListener
function AITargetTrackerComponent:RegisterListener(et, listener) return end

---@param id Uint32
function AITargetTrackerComponent:RemoveThreat(id) return end

---@param et entEntity
---@param reason CName|string
function AITargetTrackerComponent:RemoveThreatBeliefAccuracyMinValue(et, reason) return end

---@param et entEntity
---@param reason CName|string
---@param minAccuracy Float
function AITargetTrackerComponent:RequestThreatBeliefAccuracyMinValue(et, reason, minAccuracy) return end

---@param et entEntity
function AITargetTrackerComponent:ResetDroppingCooldown(et) return end

---@param delay Float
function AITargetTrackerComponent:ResetRecentlyDroppedThreat(delay) return end

function AITargetTrackerComponent:ResetRecentlyDroppedThreatNoCallbacks() return end

---@param presetId TweakDBID|string
function AITargetTrackerComponent:SetCurrentPreset(presetId) return end

---@param isPersistent Bool
---@param src Uint32
function AITargetTrackerComponent:SetCurrentThreatsPersistence(isPersistent, src) return end

function AITargetTrackerComponent:SetForceDetect() return end

---@param threat entEntity
---@param position Vector4
---@param validFor Float
function AITargetTrackerComponent:SetRecentlyDroppedThreat(threat, position, validFor) return end

---@param et entEntity
---@param accuracy Float
function AITargetTrackerComponent:SetThreatAccuracy(et, accuracy) return end

---@param et entEntity
---@param threatValue Float
function AITargetTrackerComponent:SetThreatBaseMul(et, threatValue) return end

---@param et entEntity
---@param accuracy Float
function AITargetTrackerComponent:SetThreatBeliefAccuracy(et, accuracy) return end

---@param et entEntity
---@param isPersistent Bool
---@param src Uint32
function AITargetTrackerComponent:SetThreatPersistence(et, isPersistent, src) return end

---@param curveName CName|string
---@return Bool
function AITargetTrackerComponent:SetThreatPriorityAttackersCurve(curveName) return end

---@param curveName CName|string
---@return Bool
function AITargetTrackerComponent:SetThreatPriorityDistCurve(curveName) return end

---@param curveName CName|string
---@return Bool
function AITargetTrackerComponent:SetThreatPriorityDmgCurve(curveName) return end

---@param curveName CName|string
---@return Bool
function AITargetTrackerComponent:SetThreatPriorityHisteresisCurve(curveName) return end

---@param et entEntity
---@return Bool, AITrackedLocation
function AITargetTrackerComponent:ThreatFromEntity(et) return end

---@class AITargetTrackerComponentPS : gameComponentPS
---@field threatsSaveData AIThreatSaveData[]
AITargetTrackerComponentPS = {}

---@return AITargetTrackerComponentPS
function AITargetTrackerComponentPS.new() return end

---@param props table
---@return AITargetTrackerComponentPS
function AITargetTrackerComponentPS.new(props) return end

---@class AITargetTrackerManager : AITargetTrackerManagerInterface
AITargetTrackerManager = {}

---@return AITargetTrackerManager
function AITargetTrackerManager.new() return end

---@param props table
---@return AITargetTrackerManager
function AITargetTrackerManager.new(props) return end

---@class AITargetTrackerManagerInterface : gameIGameSystem
AITargetTrackerManagerInterface = {}

---@class AITeleportCommand : AICommand
---@field position Vector4
---@field rotation Float
---@field doNavTest Bool
AITeleportCommand = {}

---@return AITeleportCommand
function AITeleportCommand.new() return end

---@param props table
---@return AITeleportCommand
function AITeleportCommand.new(props) return end

---@class AIThreatBeliefPositionProvider : AIThreatPositionProvider
AIThreatBeliefPositionProvider = {}

---@return AIThreatBeliefPositionProvider
function AIThreatBeliefPositionProvider.new() return end

---@param props table
---@return AIThreatBeliefPositionProvider
function AIThreatBeliefPositionProvider.new(props) return end

---@class AIThreatCalculationEvent : redEvent
---@field set Bool
---@field temporaryThreatCalculationType EAIThreatCalculationType
AIThreatCalculationEvent = {}

---@return AIThreatCalculationEvent
function AIThreatCalculationEvent.new() return end

---@param props table
---@return AIThreatCalculationEvent
function AIThreatCalculationEvent.new(props) return end

---@class AIThreatDeath : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field id Uint32
---@field detected Bool
AIThreatDeath = {}

---@return AIThreatDeath
function AIThreatDeath.new() return end

---@param props table
---@return AIThreatDeath
function AIThreatDeath.new(props) return end

---@class AIThreatDefeated : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field id Uint32
---@field detected Bool
AIThreatDefeated = {}

---@return AIThreatDefeated
function AIThreatDefeated.new() return end

---@param props table
---@return AIThreatDefeated
function AIThreatDefeated.new(props) return end

---@class AIThreatDistanceCoverSelection : AICoverSelectionParameters
AIThreatDistanceCoverSelection = {}

---@return AIThreatDistanceCoverSelection
function AIThreatDistanceCoverSelection.new() return end

---@param props table
---@return AIThreatDistanceCoverSelection
function AIThreatDistanceCoverSelection.new(props) return end

---@class AIThreatExpectationInvalid : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field threatId Uint32
AIThreatExpectationInvalid = {}

---@return AIThreatExpectationInvalid
function AIThreatExpectationInvalid.new() return end

---@param props table
---@return AIThreatExpectationInvalid
function AIThreatExpectationInvalid.new(props) return end

---@class AIThreatInvalid : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field isEnemy Bool
---@field isHostile Bool
AIThreatInvalid = {}

---@return AIThreatInvalid
function AIThreatInvalid.new() return end

---@param props table
---@return AIThreatInvalid
function AIThreatInvalid.new(props) return end

---@class AIThreatLastKnownPositionProvider : AIThreatPositionProvider
AIThreatLastKnownPositionProvider = {}

---@return AIThreatLastKnownPositionProvider
function AIThreatLastKnownPositionProvider.new() return end

---@param props table
---@return AIThreatLastKnownPositionProvider
function AIThreatLastKnownPositionProvider.new(props) return end

---@class AIThreatPositionProvider : entIPositionProvider
AIThreatPositionProvider = {}

---@class AIThreatRemoved : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field isHostile Bool
---@field isEnemy Bool
---@field isDead Bool
---@field distanceBasedInstantDrop Bool
AIThreatRemoved = {}

---@return AIThreatRemoved
function AIThreatRemoved.new() return end

---@param props table
---@return AIThreatRemoved
function AIThreatRemoved.new(props) return end

---@class AIThreatSaveData
---@field entityId entEntityID
---@field persistenceSourceBitMask Uint32
AIThreatSaveData = {}

---@return AIThreatSaveData
function AIThreatSaveData.new() return end

---@param props table
---@return AIThreatSaveData
function AIThreatSaveData.new(props) return end

---@class AIThreatSharedBeliefPositionProvider : AIThreatPositionProvider
AIThreatSharedBeliefPositionProvider = {}

---@return AIThreatSharedBeliefPositionProvider
function AIThreatSharedBeliefPositionProvider.new() return end

---@param props table
---@return AIThreatSharedBeliefPositionProvider
function AIThreatSharedBeliefPositionProvider.new(props) return end

---@class AIThreatSharedLastKnownPositionProvider : AIThreatPositionProvider
AIThreatSharedLastKnownPositionProvider = {}

---@return AIThreatSharedLastKnownPositionProvider
function AIThreatSharedLastKnownPositionProvider.new() return end

---@param props table
---@return AIThreatSharedLastKnownPositionProvider
function AIThreatSharedLastKnownPositionProvider.new(props) return end

---@class AIThreatUnconscious : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field id Uint32
---@field detected Bool
AIThreatUnconscious = {}

---@return AIThreatUnconscious
function AIThreatUnconscious.new() return end

---@param props table
---@return AIThreatUnconscious
function AIThreatUnconscious.new(props) return end

---@class AIThreatValid : AIAIEvent
---@field owner entEntity
---@field threat entEntity
---@field isEnemy Bool
---@field isHostile Bool
AIThreatValid = {}

---@return AIThreatValid
function AIThreatValid.new() return end

---@param props table
---@return AIThreatValid
function AIThreatValid.new(props) return end

---@class AIThrowGrenadeCommand : AICombatRelatedCommand
---@field targetOverrideNodeRef NodeRef
---@field targetOverridePuppetRef gameEntityReference
---@field duration Float
---@field once Bool
AIThrowGrenadeCommand = {}

---@return AIThrowGrenadeCommand
function AIThrowGrenadeCommand.new() return end

---@param props table
---@return AIThrowGrenadeCommand
function AIThrowGrenadeCommand.new(props) return end

---@class AIThrowGrenadeForcedCommand : AIThrowGrenadeCommand
AIThrowGrenadeForcedCommand = {}

---@return AIThrowGrenadeForcedCommand
function AIThrowGrenadeForcedCommand.new() return end

---@param props table
---@return AIThrowGrenadeForcedCommand
function AIThrowGrenadeForcedCommand.new(props) return end

---@class AITicketCondition : IScriptable
AITicketCondition = {}

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param check gamedataAITicketCheck_Record
---@param ticketRecord gamedataAITicket_Record
---@return Bool, entEntity[]
function AITicketCondition.Check(entity, interface, check, ticketRecord) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param check gamedataAISquadANDCondition_Record
---@param ticketRecord gamedataAITicket_Record
---@return Bool, entEntity[]
function AITicketCondition.CheckAND(entity, interface, check, ticketRecord) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param check gamedataAISquadContainsSelfCheck_Record
---@param squadMembers entEntity[]
---@return Bool
function AITicketCondition.CheckContainsSelf(entity, interface, check, squadMembers) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param condition gamedataAISquadDistanceRelationToSectorCheck_Record
---@param closest Bool
---@param ticketRecord gamedataAITicket_Record
---@param squadMembers entEntity[]
---@return Bool
function AITicketCondition.CheckDistanceRelationToSector(entity, interface, condition, closest, ticketRecord, squadMembers) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param condition gamedataAISquadDistanceRelationToTargetCheck_Record
---@param closest Bool
---@param squadMembers entEntity[]
---@return Bool
function AITicketCondition.CheckDistanceRelationToTarget(entity, interface, condition, closest, squadMembers) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param check gamedataAISquadMembersAmountCheck_Record
---@param squadMembers entEntity[]
---@return Bool
function AITicketCondition.CheckMembersAmount(entity, interface, check, squadMembers) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param ticketRecord gamedataAITicket_Record
---@return Bool
function AITicketCondition.CheckNumberOfTickets(entity, interface, ticketRecord) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param check gamedataAISquadORCondition_Record
---@param ticketRecord gamedataAITicket_Record
---@return Bool, entEntity[]
function AITicketCondition.CheckOR(entity, interface, check, ticketRecord) return end

---@param condition gamedataAISquadFilterByAICondition_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterAICondition(condition, squadMembers) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param condition gamedataAISquadAvoidLastFilter_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterAgainstChoosingPreviouslySelected(entity, interface, condition, squadMembers) return end

---@param interface PuppetSquadInterface
---@param condition gamedataAISquadInSectorFilter_Record
---@param ticketRecord gamedataAITicket_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterInSector(interface, condition, ticketRecord, squadMembers) return end

---@param condition gamedataAISquadItemPriorityFilter_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterItemPriority(condition, squadMembers) return end

---@param itemRecord gamedataItem_Record
---@param condition gamedataAISquadItemTypePriorityFilter_Record
---@param index Int32
---@return Bool
function AITicketCondition.FilterItemTypePredicate(itemRecord, condition, index) return end

---@param itemRecord gamedataItem_Record
---@param condition gamedataAISquadItemCategoryPriorityFilter_Record
---@param index Int32
---@return Bool
function AITicketCondition.FilterItemTypePredicate(itemRecord, condition, index) return end

---@param entity entEntity
---@param condition gamedataAISquadJustSelfFilter_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterJustSelf(entity, condition, squadMembers) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param filter gamedataAITicketFilter_Record
---@param ticketRecord gamedataAITicket_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterOut(entity, interface, filter, ticketRecord, squadMembers) return end

---@param entity entEntity
---@param condition gamedataAISquadSpatialForOwnTarget_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterSpatialForOwnTarget(entity, condition, squadMembers) return end

---@param entity entEntity
---@param condition gamedataAISquadFilterOwnTargetSpotted_Record
---@param squadMembers entEntity[]
function AITicketCondition.FilterTargetSpotted(entity, condition, squadMembers) return end

---@param entity entEntity
---@return gameItemObject
function AITicketCondition.GetItem(entity) return end

---@param context AIbehaviorScriptExecutionContext
---@param target gameObject
---@return Bool
function AITicketCondition.IsTargetSpotted(context, target) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param conditions gamedataAITicketCondition_Record[]
---@param ticketRecord gamedataAITicket_Record
---@param squadRecord gamedataAISquadParams_Record
---@return Bool
function AITicketCondition.PerformChecking(entity, interface, conditions, ticketRecord, squadRecord) return end

---@param entity entEntity
---@param interface PuppetSquadInterface
---@param conditions gamedataAITicketCondition_Record[]
---@param ticketRecord gamedataAITicket_Record
---@return Bool
function AITicketCondition.PerformChecking(entity, interface, conditions, ticketRecord) return end

---@class AITimeCondition : AIbehaviorconditionScript
AITimeCondition = {}

---@class AITimeoutCondition : AITimeCondition
---@field timestamp Float
AITimeoutCondition = {}

---@param context AIbehaviorScriptExecutionContext
function AITimeoutCondition:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AITimeoutCondition:Check(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Float
function AITimeoutCondition:GetTimeoutValue(context) return end

---@param context AIbehaviorScriptExecutionContext
function AITimeoutCondition:UpdateTimeStamp(context) return end

---@class AITrackedLocation
---@field lastKnown AILocationInformation
---@field location AILocationInformation
---@field sharedLocation AILocationInformation
---@field entity entEntity
---@field accuracy Float
---@field sharedAccuracy Float
---@field sharedTimeDelay Float
---@field threat Float
---@field speed Vector4
---@field visible Bool
---@field invalidExpectation Bool
---@field status AITrackedStatusType
---@field sharedLastKnown AILocationInformation
AITrackedLocation = {}

---@return AITrackedLocation
function AITrackedLocation.new() return end

---@param props table
---@return AITrackedLocation
function AITrackedLocation.new(props) return end

---@class AITrafficExternalWorkspotDefinition : worldTrafficSpotDefinition
---@field nearestPointEntry Bool
---@field globalWorkspotNodeRef NodeRef
AITrafficExternalWorkspotDefinition = {}

---@return AITrafficExternalWorkspotDefinition
function AITrafficExternalWorkspotDefinition.new() return end

---@param props table
---@return AITrafficExternalWorkspotDefinition
function AITrafficExternalWorkspotDefinition.new(props) return end

---@class AITrafficMovementSystem : AIITrafficMovementSystem
AITrafficMovementSystem = {}

---@return AITrafficMovementSystem
function AITrafficMovementSystem.new() return end

---@param props table
---@return AITrafficMovementSystem
function AITrafficMovementSystem.new(props) return end

---@class AITrafficWorkspotCompiled : worldTrafficSpotCompiled
AITrafficWorkspotCompiled = {}

---@return AITrafficWorkspotCompiled
function AITrafficWorkspotCompiled.new() return end

---@param props table
---@return AITrafficWorkspotCompiled
function AITrafficWorkspotCompiled.new(props) return end

---@class AITrafficWorkspotDefinition : worldTrafficSpotDefinition
---@field workspotResource workWorkspotResource
AITrafficWorkspotDefinition = {}

---@return AITrafficWorkspotDefinition
function AITrafficWorkspotDefinition.new() return end

---@param props table
---@return AITrafficWorkspotDefinition
function AITrafficWorkspotDefinition.new(props) return end

---@class AITreeArgumentsDefinition
---@field args AIArgumentDefinition[]
AITreeArgumentsDefinition = {}

---@return AITreeArgumentsDefinition
function AITreeArgumentsDefinition.new() return end

---@param props table
---@return AITreeArgumentsDefinition
function AITreeArgumentsDefinition.new(props) return end

---@class AITreeNodeDeathDefinition : AICTreeNodeActionDefinition
AITreeNodeDeathDefinition = {}

---@return AITreeNodeDeathDefinition
function AITreeNodeDeathDefinition.new() return end

---@param props table
---@return AITreeNodeDeathDefinition
function AITreeNodeDeathDefinition.new(props) return end

---@class AITreeNodeInterruptionDecoratorDefinition : AICTreeNodeDecoratorDefinition
---@field interruptions AIInterruptionHandlerDefinition[]
AITreeNodeInterruptionDecoratorDefinition = {}

---@return AITreeNodeInterruptionDecoratorDefinition
function AITreeNodeInterruptionDecoratorDefinition.new() return end

---@param props table
---@return AITreeNodeInterruptionDecoratorDefinition
function AITreeNodeInterruptionDecoratorDefinition.new(props) return end

---@class AITreeNodeRepeatDefinition : AICTreeNodeDecoratorDefinition
---@field limit LibTreeDefInt32
AITreeNodeRepeatDefinition = {}

---@return AITreeNodeRepeatDefinition
function AITreeNodeRepeatDefinition.new() return end

---@param props table
---@return AITreeNodeRepeatDefinition
function AITreeNodeRepeatDefinition.new(props) return end

---@class AITweakParams : IScriptable
AITweakParams = {}

---@return AITweakParams
function AITweakParams.new() return end

---@param props table
---@return AITweakParams
function AITweakParams.new(props) return end

---@param actionID TweakDBID|string
---@param paramName String
---@param defaultValue Bool
---@return Bool
function AITweakParams.GetBoolFromTweak(actionID, paramName, defaultValue) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return CName[]
function AITweakParams.GetCNameArrayFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return CName
function AITweakParams.GetCNameFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return Float[]
function AITweakParams.GetFloatArrayFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return Float
function AITweakParams.GetFloatFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return Int32[]
function AITweakParams.GetIntArrayFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return Int32
function AITweakParams.GetIntFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return String[]
function AITweakParams.GetStringArrayFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return String
function AITweakParams.GetStringFromTweak(actionID, paramName) return end

---@param actionID TweakDBID|string
---@param paramName String
---@return Vector3
function AITweakParams.GetVectorFromTweak(actionID, paramName) return end

---@class AIUint64ArgumentInstancePS : AIArgumentInstancePS
---@field value Uint64
AIUint64ArgumentInstancePS = {}

---@return AIUint64ArgumentInstancePS
function AIUint64ArgumentInstancePS.new() return end

---@param props table
---@return AIUint64ArgumentInstancePS
function AIUint64ArgumentInstancePS.new(props) return end

---@class AIUnequipCommand : AICommand
---@field slotId TweakDBID
---@field durationOverride Float
AIUnequipCommand = {}

---@return AIUnequipCommand
function AIUnequipCommand.new() return end

---@param props table
---@return AIUnequipCommand
function AIUnequipCommand.new(props) return end

---@class AIUnmountCommand : AIBaseMountCommand
AIUnmountCommand = {}

---@return AIUnmountCommand
function AIUnmountCommand.new() return end

---@param props table
---@return AIUnmountCommand
function AIUnmountCommand.new(props) return end

---@class AIUseCoverCommand : AICombatRelatedCommand
---@field coverNodeRef NodeRef
---@field oneTimeSelection Bool
---@field forcedEntryAnimation CName
---@field exposureMethods AICoverExposureMethod[]
---@field limitToTheseExposureMethods CoverCommandParams
AIUseCoverCommand = {}

---@return AIUseCoverCommand
function AIUseCoverCommand.new() return end

---@param props table
---@return AIUseCoverCommand
function AIUseCoverCommand.new(props) return end

---@class AIUseWorkspotCommand : AIBaseUseWorkspotCommand
---@field workspotNode NodeRef
---@field jumpToEntry Bool
---@field entryId workWorkEntryId
---@field entryTag CName
AIUseWorkspotCommand = {}

---@return AIUseWorkspotCommand
function AIUseWorkspotCommand.new() return end

---@param props table
---@return AIUseWorkspotCommand
function AIUseWorkspotCommand.new(props) return end

---@class AIUtilityLossCoverSelection : AICoverSelectionParameters
AIUtilityLossCoverSelection = {}

---@return AIUtilityLossCoverSelection
function AIUtilityLossCoverSelection.new() return end

---@param props table
---@return AIUtilityLossCoverSelection
function AIUtilityLossCoverSelection.new(props) return end

---@class AIUtilsCachedBoolValue
AIUtilsCachedBoolValue = {}

---@return AIUtilsCachedBoolValue
function AIUtilsCachedBoolValue.new() return end

---@param props table
---@return AIUtilsCachedBoolValue
function AIUtilsCachedBoolValue.new(props) return end

---@param cachedValue AIUtilsCachedBoolValue
---@return Bool, Bool
function AIUtilsCachedBoolValue.GetIfNotDirty(cachedValue) return end

---@param cachedValue AIUtilsCachedBoolValue
---@param value Bool
function AIUtilsCachedBoolValue.Set(cachedValue, value) return end

---@param cachedValue AIUtilsCachedBoolValue
function AIUtilsCachedBoolValue.SetDirty(cachedValue) return end

---@class AIUtilsCombatSpaceHelper
AIUtilsCombatSpaceHelper = {}

---@return AIUtilsCombatSpaceHelper
function AIUtilsCombatSpaceHelper.new() return end

---@param props table
---@return AIUtilsCombatSpaceHelper
function AIUtilsCombatSpaceHelper.new(props) return end

---@param owner gameObject
---@param multipliers Vector3
---@return Float
function AIUtilsCombatSpaceHelper.GetDistanceMultiplier(owner, multipliers) return end

---@class AIVehicleAgent : AICAgent
---@field keepStrategyOnSearch Bool
---@field initCmd AIVehicleCommand
AIVehicleAgent = {}

---@return AIVehicleAgent
function AIVehicleAgent.new() return end

---@param props table
---@return AIVehicleAgent
function AIVehicleAgent.new(props) return end

---@return Uint32
function AIVehicleAgent:GetReservedSeatsCount() return end

---@param seatName CName|string
---@return Bool
function AIVehicleAgent:IsSeatReserved(seatName) return end

---@param seatName CName|string
function AIVehicleAgent:ReleaseSeat(seatName) return end

---@param reserver entEntityID
function AIVehicleAgent:ReleaseSeatReservedBy(reserver) return end

---@param update AIDrivePatrolUpdate
function AIVehicleAgent:SetDrivePatrolUpdate(update) return end

---@param update AIDriveToPointAutonomousUpdate
function AIVehicleAgent:SetDriveToPointAutonomousUpdate(update) return end

---@param reserver entEntityID
---@param preferredSeatName CName|string
---@return CName
function AIVehicleAgent:TryReserveSeatOrFirstAvailable(reserver, preferredSeatName) return end

---@return AIVehicleCommand
function AIVehicleAgent:GetInitCmd() return end

---@param commandClassName CName|string
---@return Bool
function AIVehicleAgent:InitCommandIsA(commandClassName) return end

---@return Bool
function AIVehicleAgent:KeepStrategyOnSearch() return end

---@param cmd AIVehicleCommand
function AIVehicleAgent:SetInitCmd(cmd) return end

---@param keep Bool
function AIVehicleAgent:SetKeepStrategyOnSearch(keep) return end

---@class AIVehicleChaseCommand : AIVehicleCommand
---@field target gameObject
---@field distanceMin Float
---@field distanceMax Float
---@field forcedStartSpeed Float
---@field aggressiveRamming Bool
---@field ignoreChaseVehiclesLimit Bool
---@field boostDrivingStats Bool
AIVehicleChaseCommand = {}

---@return AIVehicleChaseCommand
function AIVehicleChaseCommand.new() return end

---@param props table
---@return AIVehicleChaseCommand
function AIVehicleChaseCommand.new(props) return end

---@class AIVehicleCommand : AICommand
---@field useKinematic Bool
---@field needDriver Bool
AIVehicleCommand = {}

---@class AIVehicleConditionAbstract : AIbehaviorconditionScript
AIVehicleConditionAbstract = {}

---@param context AIbehaviorScriptExecutionContext
---@return AIVehicleAgent
function AIVehicleConditionAbstract:GetMountedVehicleAIComponent(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param vehicleID entEntityID
---@return Bool
function AIVehicleConditionAbstract:IsVehicleOccupiedByHostile(context, vehicleID) return end

---@class AIVehicleCoversComponent : entIComponent
AIVehicleCoversComponent = {}

---@return AIVehicleCoversComponent
function AIVehicleCoversComponent.new() return end

---@param props table
---@return AIVehicleCoversComponent
function AIVehicleCoversComponent.new(props) return end

---@class AIVehicleCoversSystem : AIIVehicleCoversSystem
AIVehicleCoversSystem = {}

---@return AIVehicleCoversSystem
function AIVehicleCoversSystem.new() return end

---@param props table
---@return AIVehicleCoversSystem
function AIVehicleCoversSystem.new(props) return end

---@class AIVehicleDrivePatrolCommand : AIVehicleCommand
---@field maxSpeed Float
---@field minSpeed Float
---@field clearTrafficOnPath Bool
---@field emergencyPatrol Bool
---@field numPatrolLoops Uint32
---@field forcedStartSpeed Float
AIVehicleDrivePatrolCommand = {}

---@return AIVehicleDrivePatrolCommand
function AIVehicleDrivePatrolCommand.new() return end

---@param props table
---@return AIVehicleDrivePatrolCommand
function AIVehicleDrivePatrolCommand.new(props) return end

---@class AIVehicleDriveToPointAutonomousCommand : AIVehicleCommand
---@field targetPosition Vector3
---@field maxSpeed Float
---@field minSpeed Float
---@field clearTrafficOnPath Bool
---@field minimumDistanceToTarget Float
---@field forcedStartSpeed Float
---@field driveDownTheRoadIndefinitely Bool
AIVehicleDriveToPointAutonomousCommand = {}

---@return AIVehicleDriveToPointAutonomousCommand
function AIVehicleDriveToPointAutonomousCommand.new() return end

---@param props table
---@return AIVehicleDriveToPointAutonomousCommand
function AIVehicleDriveToPointAutonomousCommand.new(props) return end

---@class AIVehicleFollowCommand : AIVehicleCommand
---@field target gameObject
---@field secureTimeOut Float
---@field distanceMin Float
---@field distanceMax Float
---@field stopWhenTargetReached Bool
---@field useTraffic Bool
---@field trafficTryNeighborsForStart Bool
---@field trafficTryNeighborsForEnd Bool
AIVehicleFollowCommand = {}

---@return AIVehicleFollowCommand
function AIVehicleFollowCommand.new() return end

---@param props table
---@return AIVehicleFollowCommand
function AIVehicleFollowCommand.new(props) return end

---@class AIVehicleJoinTrafficCommand : AIVehicleCommand
AIVehicleJoinTrafficCommand = {}

---@return AIVehicleJoinTrafficCommand
function AIVehicleJoinTrafficCommand.new() return end

---@param props table
---@return AIVehicleJoinTrafficCommand
function AIVehicleJoinTrafficCommand.new(props) return end

---@class AIVehicleOnSplineCommand : AIVehicleCommand
---@field splineRef NodeRef
---@field secureTimeOut Float
---@field driveBackwards Bool
---@field reverseSpline Bool
---@field startFromClosest Bool
---@field forcedStartSpeed Float
---@field stopAtPathEnd Bool
---@field keepDistanceBool Bool
---@field keepDistanceCompanion gameObject
---@field keepDistanceDistance Float
---@field rubberBandingBool Bool
---@field rubberBandingTargetRef gameObject
---@field rubberBandingMinDistance Float
---@field rubberBandingMaxDistance Float
---@field rubberBandingStopAndWait Bool
---@field rubberBandingTeleportToCatchUp Bool
---@field rubberBandingStayInFront Bool
---@field audioCurvesParam vehicleAudioCurvesParam
AIVehicleOnSplineCommand = {}

---@return AIVehicleOnSplineCommand
function AIVehicleOnSplineCommand.new() return end

---@param props table
---@return AIVehicleOnSplineCommand
function AIVehicleOnSplineCommand.new(props) return end

---@class AIVehiclePanicCommand : AIVehicleCommand
---@field allowSimplifiedMovement Bool
---@field ignoreTickets Bool
---@field disableStuckDetection Bool
---@field useSpeedBasedLookupRange Bool
---@field tryDriveAwayFromPlayer Bool
AIVehiclePanicCommand = {}

---@return AIVehiclePanicCommand
function AIVehiclePanicCommand.new() return end

---@param props table
---@return AIVehiclePanicCommand
function AIVehiclePanicCommand.new(props) return end

---@class AIVehicleRacingCommand : AIVehicleCommand
---@field splineRef NodeRef
---@field secureTimeOut Float
---@field reverseSpline Bool
---@field driveBackwards Bool
---@field startFromClosest Bool
---@field rubberBandingBool Bool
---@field rubberBandingTargetRef gameObject
---@field rubberBandingMinDistance Float
---@field rubberBandingMaxDistance Float
---@field rubberBandingStopAndWait Bool
---@field rubberBandingTeleportToCatchUp Bool
---@field rubberBandingStayInFront Bool
AIVehicleRacingCommand = {}

---@return AIVehicleRacingCommand
function AIVehicleRacingCommand.new() return end

---@param props table
---@return AIVehicleRacingCommand
function AIVehicleRacingCommand.new(props) return end

---@class AIVehicleTaskAbstract : AIbehaviortaskScript
AIVehicleTaskAbstract = {}

---@param context AIbehaviorScriptExecutionContext
---@return AIVehicleAgent
function AIVehicleTaskAbstract:GetMountedVehicleAIComponent(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AIVehicleCommand
function AIVehicleTaskAbstract:InterruptMountedVehicleCommand(context, command) return end

---@param context AIbehaviorScriptExecutionContext
function AIVehicleTaskAbstract:InterruptMountedVehicleDriveChaseTargetCommand(context) return end

---@param context AIbehaviorScriptExecutionContext
function AIVehicleTaskAbstract:InterruptMountedVehicleDriveToPointCommand(context) return end

---@param vehAIComponent AICAgent
---@param command AIVehicleCommand
function AIVehicleTaskAbstract:InterruptVehicleCommand(vehAIComponent, command) return end

---@param context AIbehaviorScriptExecutionContext
---@param command AIVehicleCommand
---@return Bool
function AIVehicleTaskAbstract:SendAICommandToMountedVehicle(context, command) return end

---@param context AIbehaviorScriptExecutionContext
---@param eventName CName|string
---@return Bool
function AIVehicleTaskAbstract:SendAIEventToMountedVehicle(context, eventName) return end

---@class AIVehicleToNodeCommand : AIVehicleCommand
---@field nodeRef NodeRef
---@field stopAtPathEnd Bool
---@field secureTimeOut Float
---@field isPlayer Bool
---@field useTraffic Bool
---@field speedInTraffic Float
---@field forceGreenLights Bool
---@field portals vehiclePortalsList
---@field trafficTryNeighborsForStart Bool
---@field trafficTryNeighborsForEnd Bool
AIVehicleToNodeCommand = {}

---@return AIVehicleToNodeCommand
function AIVehicleToNodeCommand.new() return end

---@param props table
---@return AIVehicleToNodeCommand
function AIVehicleToNodeCommand.new(props) return end

---@class AIWeapon : IScriptable
AIWeapon = {}

---@param gameObject gameweaponObject
---@return Bool
function AIWeapon.CanWeaponOverheat(gameObject) return end

---@param arr1 gamedataAIPattern_Record[]
---@param arr2 gamedataAIPattern_Record[]
---@return Bool
function AIWeapon.CompareAIPatternRecordArrays(arr1, arr2) return end

---@param weaponOwner gameObject
---@param weapon gameweaponObject
---@param timeStamp Float
---@param tbhCoefficient Float
---@param requestedTriggerMode gamedataTriggerMode
---@param targetPosition Vector4
---@param target gameObject
---@param rangedAttack TweakDBID|string
---@param maxSpreadOverride Float
---@param aimingDelay Float
---@param offset Vector4
---@param shouldTrackTarget Bool
---@param predictionTime Float
---@param posProviderOverride entIPositionProvider
---@param muzzleOffset Vector4
---@param weaponCustomEvent CName|string
function AIWeapon.Fire(weaponOwner, weapon, timeStamp, tbhCoefficient, requestedTriggerMode, targetPosition, target, rangedAttack, maxSpreadOverride, aimingDelay, offset, shouldTrackTarget, predictionTime, posProviderOverride, muzzleOffset, weaponCustomEvent) return end

---@param weapon gameweaponObject
---@param weaponOwner gameObject
function AIWeapon.ForceWeaponOverheat(weapon, weaponOwner) return end

---@param weapon gameweaponObject
---@param actionDuration Float
---@return Bool, Float
function AIWeapon.GetChargeLevel(weapon, actionDuration) return end

---@param weapon gameweaponObject
---@return Int32
function AIWeapon.GetDesiredNumberOfShots(weapon) return end

---@param weapon gameweaponObject
---@return Bool
function AIWeapon.GetIsFullyCharged(weapon) return end

---@param weapon gameweaponObject
---@return Float
function AIWeapon.GetNextShotTimeStamp(weapon) return end

---@param weaponOwner gameObject
---@param records gamedataAIPatternsPackage_Record[]
---@return Bool, gamedataAIPatternsPackage_Record
function AIWeapon.GetPatternPackagesMeetingConditionChecks(weaponOwner, records) return end

---@param weapon gameweaponObject
---@return gamedataAIPattern_Record[]
function AIWeapon.GetPatternRange(weapon) return end

---@param weapon gameweaponObject
---@return gamedataAIPattern_Record
function AIWeapon.GetShootingPattern(weapon) return end

---@param totalShotsFired Int32
---@param pattern gamedataAIPattern_Record
---@return Float
function AIWeapon.GetShootingPatternDelayBetweenShots(totalShotsFired, pattern) return end

---@param weapon gameweaponObject
---@return gamedataAIPatternsPackage_Record
function AIWeapon.GetShootingPatternPackage(weapon) return end

---@param weaponOwner gameObject
---@param weapon gameweaponObject
---@param chosenPackage gamedataAIPatternsPackage_Record
---@param patternsList gamedataAIPattern_Record[]
---@return Bool
function AIWeapon.GetShootingPatternsList(weaponOwner, weapon, chosenPackage, patternsList) return end

---@param weapon gameweaponObject
---@return Float
function AIWeapon.GetShotTimeStamp(weapon) return end

---@param weapon gameweaponObject
---@return Int32
function AIWeapon.GetTotalNumberOfShots(weapon) return end

---@param weapon gameweaponObject
---@return Bool
function AIWeapon.GetWeaponOverheatBB(weapon) return end

---@param gameObject gameweaponObject
---@return Float
function AIWeapon.GetWeaponOverheatStatPool(gameObject) return end

---@param weapon gameweaponObject
---@return Bool
function AIWeapon.HasExceededDesiredNumberOfShots(weapon) return end

---@param weapon gameweaponObject
function AIWeapon.OnFullyCharged(weapon) return end

---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param timeStamp Float
function AIWeapon.OnShotFired(weapon, requestedTriggerMode, timeStamp) return end

---@param weapon gameweaponObject
---@param desiredNumberOfShots Int32
function AIWeapon.OnStartShooting(weapon, desiredNumberOfShots) return end

---@param weapon gameweaponObject
---@param actionDuration Float
function AIWeapon.OnStopShooting(weapon, actionDuration) return end

---@param gameObject gameweaponObject
---@param weaponOwner gameObject
---@param forceOverheat Bool
function AIWeapon.ProcessWeaponOverheatStatPool(gameObject, weaponOwner, forceOverheat) return end

---@param weapon gameweaponObject
---@param requestedTriggerMode gamedataTriggerMode
---@param timeStamp Float
---@param delayForNextShot Float
function AIWeapon.QueueNextShot(weapon, requestedTriggerMode, timeStamp, delayForNextShot) return end

---@param record gamedataAISubActionShootWithWeapon_Record
---@param weapon gameweaponObject
---@param weaponOwner gameObject
---@param forceReselection Bool
function AIWeapon.SelectShootingPattern(record, weapon, weaponOwner, forceReselection) return end

---@param weapon gameweaponObject
---@param patternsList gamedataAIPattern_Record[]
---@return gamedataAIPattern_Record
function AIWeapon.SelectShootingPatternFromList(weapon, patternsList) return end

---@param weaponOwner gameObject
---@param weapon gameweaponObject
---@param records gamedataAIPatternsPackage_Record[]
---@return gamedataAIPatternsPackage_Record
function AIWeapon.SelectShootingPatternPackage(weaponOwner, weapon, records) return end

---@param owner gameObject
---@param weapon gameweaponObject
---@param overrideRangedAttack TweakDBID|string
function AIWeapon.SetAttackBasedOnTimeDilation(owner, weapon, overrideRangedAttack) return end

---@param weapon gameweaponObject
---@param patternList gamedataAIPattern_Record[]
function AIWeapon.SetPatternRange(weapon, patternList) return end

---@param weapon gameweaponObject
---@param pattern gamedataAIPattern_Record
function AIWeapon.SetShootingPattern(weapon, pattern) return end

---@param weapon gameweaponObject
---@param patternPackage gamedataAIPatternsPackage_Record
function AIWeapon.SetShootingPatternPackage(weapon, patternPackage) return end

---@param weapon gameweaponObject
---@param timeStamp Float
---@param weaponOwner gameObject
---@return Bool, Float
function AIWeapon.UpdateCharging(weapon, timeStamp, weaponOwner) return end

---@param weapon gameweaponObject
---@param duration Float
---@return Bool
function AIWeapon.UpdateSniperEffect(weapon, duration) return end

---@param weapon gameweaponObject
function AIWeapon.WeaponCooledDownFromOverheat(weapon) return end

---@param weapon gameweaponObject
function AIWeapon.WeaponOverheated(weapon) return end

---@class AIWorkspotManager : AIIWorkspotManager
AIWorkspotManager = {}

---@return AIWorkspotManager
function AIWorkspotManager.new() return end

---@param props table
---@return AIWorkspotManager
function AIWorkspotManager.new(props) return end

---@class AIbehaviorActionAnimationCurvePathDefinition : AIbehaviorActionTreeNodeDefinition
---@field nodeReference AIArgumentMapping
---@field controllersSetupName AIArgumentMapping
---@field useStart AIArgumentMapping
---@field useStop AIArgumentMapping
---@field blendTime AIArgumentMapping
---@field globalInBlendTime AIArgumentMapping
---@field globalOutBlendTime AIArgumentMapping
---@field turnCharacterToMatchVelocity AIArgumentMapping
---@field customStartAnimationName AIArgumentMapping
---@field customMainAnimationName AIArgumentMapping
---@field customStopAnimationName AIArgumentMapping
---@field startSnapToTerrain AIArgumentMapping
---@field mainSnapToTerrain AIArgumentMapping
---@field stopSnapToTerrain AIArgumentMapping
---@field startSnapToTerrainBlendTime AIArgumentMapping
---@field stopSnapToTerrainBlendTime AIArgumentMapping
AIbehaviorActionAnimationCurvePathDefinition = {}

---@return AIbehaviorActionAnimationCurvePathDefinition
function AIbehaviorActionAnimationCurvePathDefinition.new() return end

---@param props table
---@return AIbehaviorActionAnimationCurvePathDefinition
function AIbehaviorActionAnimationCurvePathDefinition.new(props) return end

---@class AIbehaviorActionDieTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
AIbehaviorActionDieTreeNodeDefinition = {}

---@return AIbehaviorActionDieTreeNodeDefinition
function AIbehaviorActionDieTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionDieTreeNodeDefinition
function AIbehaviorActionDieTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionDroneMoveSplineTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field spline AIArgumentMapping
AIbehaviorActionDroneMoveSplineTreeNodeDefinition = {}

---@return AIbehaviorActionDroneMoveSplineTreeNodeDefinition
function AIbehaviorActionDroneMoveSplineTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionDroneMoveSplineTreeNodeDefinition
function AIbehaviorActionDroneMoveSplineTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionDroneMoveTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field moveType AIArgumentMapping
---@field target AIArgumentMapping
---@field movementTarget AIArgumentMapping
---@field toleranceRadius AIArgumentMapping
---@field desiredDistanceFromTarget AIArgumentMapping
---@field strafingTarget AIArgumentMapping
---@field stopWhenDestinationReached AIArgumentMapping
---@field rotateEntity AIArgumentMapping
AIbehaviorActionDroneMoveTreeNodeDefinition = {}

---@return AIbehaviorActionDroneMoveTreeNodeDefinition
function AIbehaviorActionDroneMoveTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionDroneMoveTreeNodeDefinition
function AIbehaviorActionDroneMoveTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionDynamicMoveTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field moveType AIArgumentMapping
---@field target AIArgumentMapping
---@field targetPosition AIArgumentMapping
---@field toleranceRadius AIArgumentMapping
---@field desiredDistanceFromTarget AIArgumentMapping
---@field strafingTarget AIArgumentMapping
---@field stopWhenDestinationReached AIArgumentMapping
---@field rotateEntity AIArgumentMapping
---@field ignoreNavigation AIArgumentMapping
AIbehaviorActionDynamicMoveTreeNodeDefinition = {}

---@return AIbehaviorActionDynamicMoveTreeNodeDefinition
function AIbehaviorActionDynamicMoveTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionDynamicMoveTreeNodeDefinition
function AIbehaviorActionDynamicMoveTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionEquipItemNodeDefinition : AIbehaviorActionItemHandlingNodeDefinition
---@field slotId AIArgumentMapping
---@field itemId AIArgumentMapping
---@field duration AIArgumentMapping
---@field failIfItemNotFound AIArgumentMapping
---@field spawnDelay AIArgumentMapping
AIbehaviorActionEquipItemNodeDefinition = {}

---@return AIbehaviorActionEquipItemNodeDefinition
function AIbehaviorActionEquipItemNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionEquipItemNodeDefinition
function AIbehaviorActionEquipItemNodeDefinition.new(props) return end

---@class AIbehaviorActionItemHandlingNodeDefinition : AIbehaviorActionTreeNodeDefinition
AIbehaviorActionItemHandlingNodeDefinition = {}

---@class AIbehaviorActionMountHandlingNodeDefinition : AIbehaviorActionTreeNodeDefinition
AIbehaviorActionMountHandlingNodeDefinition = {}

---@class AIbehaviorActionMountNodeDefinition : AIbehaviorActionMountHandlingNodeDefinition
---@field mountData AIArgumentMapping
AIbehaviorActionMountNodeDefinition = {}

---@return AIbehaviorActionMountNodeDefinition
function AIbehaviorActionMountNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionMountNodeDefinition
function AIbehaviorActionMountNodeDefinition.new(props) return end

---@class AIbehaviorActionMoveOnSplineNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field spline AIArgumentMapping
---@field strafingTarget AIArgumentMapping
---@field movementType AIArgumentMapping
---@field ignoreNavigation AIArgumentMapping
---@field snapToTerrain AIArgumentMapping
---@field rotateEntity AIArgumentMapping
---@field startFromClosestPoint AIArgumentMapping
---@field splineRecalculation AIArgumentMapping
---@field useStart AIArgumentMapping
---@field useStop AIArgumentMapping
---@field reverse AIArgumentMapping
---@field isBackAndForth AIArgumentMapping
---@field isInfinite AIArgumentMapping
---@field numberOfLoops AIArgumentMapping
---@field useOffMeshLinkReservation AIArgumentMapping
---@field disableFootIK AIArgumentMapping
---@field allowCrowdOnPath AIArgumentMapping
AIbehaviorActionMoveOnSplineNodeDefinition = {}

---@return AIbehaviorActionMoveOnSplineNodeDefinition
function AIbehaviorActionMoveOnSplineNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionMoveOnSplineNodeDefinition
function AIbehaviorActionMoveOnSplineNodeDefinition.new(props) return end

---@class AIbehaviorActionMoveToSmartObjectNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field smartObjectId AIArgumentMapping
---@field lookAtTarget AIArgumentMapping
---@field movementType AIArgumentMapping
---@field tolerance AIArgumentMapping
---@field ignoreNavigation AIArgumentMapping
---@field rotateEntity AIArgumentMapping
---@field useStart AIArgumentMapping
---@field useStop AIArgumentMapping
---@field forcedEntryAnimation AIArgumentMapping
AIbehaviorActionMoveToSmartObjectNodeDefinition = {}

---@return AIbehaviorActionMoveToSmartObjectNodeDefinition
function AIbehaviorActionMoveToSmartObjectNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionMoveToSmartObjectNodeDefinition
function AIbehaviorActionMoveToSmartObjectNodeDefinition.new(props) return end

---@class AIbehaviorActionMoveToWorkspotNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field workspotSetup AIArgumentMapping
---@field lookAtTarget AIArgumentMapping
---@field movementType AIArgumentMapping
---@field tolerance AIArgumentMapping
---@field ignoreNavigation AIArgumentMapping
---@field rotateEntity AIArgumentMapping
---@field useStart AIArgumentMapping
---@field spotReservation AIArgumentMapping
---@field startTangent AIArgumentMapping
---@field fastForwardAfterTeleport AIArgumentMapping
---@field ignoreExploration AIArgumentMapping
---@field failWhenStoppedByCollision AIArgumentMapping
AIbehaviorActionMoveToWorkspotNodeDefinition = {}

---@return AIbehaviorActionMoveToWorkspotNodeDefinition
function AIbehaviorActionMoveToWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionMoveToWorkspotNodeDefinition
function AIbehaviorActionMoveToWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorActionMoveTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field movementTarget AIArgumentMapping
---@field lookAtTarget AIArgumentMapping
---@field movementType AIArgumentMapping
---@field tolerance AIArgumentMapping
---@field ignoreNavigation AIArgumentMapping
---@field rotateEntity AIArgumentMapping
---@field useStart AIArgumentMapping
---@field useStop AIArgumentMapping
---@field destinationTangent AIArgumentMapping
---@field startTangent AIArgumentMapping
---@field spotReservation AIArgumentMapping
---@field ignoreRestrictedArea AIArgumentMapping
---@field ignoreCollisionsWhenCloseToTarget AIArgumentMapping
---@field failWhenStoppedByCollision AIArgumentMapping
AIbehaviorActionMoveTreeNodeDefinition = {}

---@return AIbehaviorActionMoveTreeNodeDefinition
function AIbehaviorActionMoveTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionMoveTreeNodeDefinition
function AIbehaviorActionMoveTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionMoveWithPolicyTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field stopWhenDestinationReached Bool
AIbehaviorActionMoveWithPolicyTreeNodeDefinition = {}

---@return AIbehaviorActionMoveWithPolicyTreeNodeDefinition
function AIbehaviorActionMoveWithPolicyTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionMoveWithPolicyTreeNodeDefinition
function AIbehaviorActionMoveWithPolicyTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionRotateBaseTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field target AIArgumentMapping
---@field angleOffset AIArgumentMapping
---@field angleTolerance AIArgumentMapping
---@field speed AIArgumentMapping
AIbehaviorActionRotateBaseTreeNodeDefinition = {}

---@class AIbehaviorActionRotateByAngleTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field angle AIArgumentMapping
---@field angleTolerance AIArgumentMapping
AIbehaviorActionRotateByAngleTreeNodeDefinition = {}

---@return AIbehaviorActionRotateByAngleTreeNodeDefinition
function AIbehaviorActionRotateByAngleTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionRotateByAngleTreeNodeDefinition
function AIbehaviorActionRotateByAngleTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field target AIArgumentMapping
---@field angleOffset AIArgumentMapping
---@field angleTolerance AIArgumentMapping
---@field time AIArgumentMapping
---@field keepUpdatingTarget AIArgumentMapping
AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition = {}

---@return AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition
function AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition
function AIbehaviorActionRotateToObjectConstTimeTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition : AIbehaviorActionRotateBaseTreeNodeDefinition
AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition = {}

---@return AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition
function AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition
function AIbehaviorActionRotateToObjectHeadingTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionRotateToObjectTreeNodeDefinition : AIbehaviorActionRotateBaseTreeNodeDefinition
---@field completeWhenRotated AIArgumentMapping
AIbehaviorActionRotateToObjectTreeNodeDefinition = {}

---@return AIbehaviorActionRotateToObjectTreeNodeDefinition
function AIbehaviorActionRotateToObjectTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionRotateToObjectTreeNodeDefinition
function AIbehaviorActionRotateToObjectTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionRotateToPositionTreeNodeDefinition : AIbehaviorActionRotateBaseTreeNodeDefinition
AIbehaviorActionRotateToPositionTreeNodeDefinition = {}

---@return AIbehaviorActionRotateToPositionTreeNodeDefinition
function AIbehaviorActionRotateToPositionTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionRotateToPositionTreeNodeDefinition
function AIbehaviorActionRotateToPositionTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionSceneAnimationMotionNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field params AIArgumentMapping
---@field mountData AIArgumentMapping
AIbehaviorActionSceneAnimationMotionNodeDefinition = {}

---@return AIbehaviorActionSceneAnimationMotionNodeDefinition
function AIbehaviorActionSceneAnimationMotionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionSceneAnimationMotionNodeDefinition
function AIbehaviorActionSceneAnimationMotionNodeDefinition.new(props) return end

---@class AIbehaviorActionSlideNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field duration AIArgumentMapping
---@field ignoreNavigation AIArgumentMapping
---@field rotateTowardsMovementDirection AIArgumentMapping
AIbehaviorActionSlideNodeDefinition = {}

---@class AIbehaviorActionSlideToLocalPositionNodeDefinition : AIbehaviorActionSlideNodeDefinition
---@field localOffset AIArgumentMapping
AIbehaviorActionSlideToLocalPositionNodeDefinition = {}

---@return AIbehaviorActionSlideToLocalPositionNodeDefinition
function AIbehaviorActionSlideToLocalPositionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionSlideToLocalPositionNodeDefinition
function AIbehaviorActionSlideToLocalPositionNodeDefinition.new(props) return end

---@class AIbehaviorActionSlideToObjectNodeDefinition : AIbehaviorActionSlideNodeDefinition
---@field destination AIArgumentMapping
---@field offset AIArgumentMapping
AIbehaviorActionSlideToObjectNodeDefinition = {}

---@return AIbehaviorActionSlideToObjectNodeDefinition
function AIbehaviorActionSlideToObjectNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionSlideToObjectNodeDefinition
function AIbehaviorActionSlideToObjectNodeDefinition.new(props) return end

---@class AIbehaviorActionSlideToWorldPositionNodeDefinition : AIbehaviorActionSlideNodeDefinition
---@field worldPosition AIArgumentMapping
---@field useMovePlanner Bool
AIbehaviorActionSlideToWorldPositionNodeDefinition = {}

---@return AIbehaviorActionSlideToWorldPositionNodeDefinition
function AIbehaviorActionSlideToWorldPositionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionSlideToWorldPositionNodeDefinition
function AIbehaviorActionSlideToWorldPositionNodeDefinition.new(props) return end

---@class AIbehaviorActionTeleportTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field destinationPoint AIArgumentMapping
---@field doNavTest AIArgumentMapping
---@field rotation AIArgumentMapping
---@field waitForPositionUpdate AIArgumentMapping
AIbehaviorActionTeleportTreeNodeDefinition = {}

---@return AIbehaviorActionTeleportTreeNodeDefinition
function AIbehaviorActionTeleportTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionTeleportTreeNodeDefinition
function AIbehaviorActionTeleportTreeNodeDefinition.new(props) return end

---@class AIbehaviorActionTreeNodeDefinition : AIbehaviorLeafTreeNodeDefinition
---@field command AIArgumentMapping
AIbehaviorActionTreeNodeDefinition = {}

---@class AIbehaviorActionUnequipItemNodeDefinition : AIbehaviorActionItemHandlingNodeDefinition
---@field slotId AIArgumentMapping
---@field duration AIArgumentMapping
AIbehaviorActionUnequipItemNodeDefinition = {}

---@return AIbehaviorActionUnequipItemNodeDefinition
function AIbehaviorActionUnequipItemNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionUnequipItemNodeDefinition
function AIbehaviorActionUnequipItemNodeDefinition.new(props) return end

---@class AIbehaviorActionUnmountNodeDefinition : AIbehaviorActionMountHandlingNodeDefinition
---@field mountData AIArgumentMapping
AIbehaviorActionUnmountNodeDefinition = {}

---@return AIbehaviorActionUnmountNodeDefinition
function AIbehaviorActionUnmountNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionUnmountNodeDefinition
function AIbehaviorActionUnmountNodeDefinition.new(props) return end

---@class AIbehaviorActionUseCommunityWorkspotNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field workspotData AIArgumentMapping
---@field dependentWorkspotData AIArgumentMapping
---@field playExitAutomatically AIArgumentMapping
---@field fastForwardAfterTeleport AIArgumentMapping
AIbehaviorActionUseCommunityWorkspotNodeDefinition = {}

---@return AIbehaviorActionUseCommunityWorkspotNodeDefinition
function AIbehaviorActionUseCommunityWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionUseCommunityWorkspotNodeDefinition
function AIbehaviorActionUseCommunityWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorActionUseWorkspotNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field eventData AIArgumentMapping
---@field playStartAnimationAfterwards AIArgumentMapping
---@field mountData AIArgumentMapping
---@field dependentWorkspotData AIArgumentMapping
---@field playExitAutomatically AIArgumentMapping
---@field markUninterruptable AIArgumentMapping
---@field fastForwardAfterTeleport AIArgumentMapping
AIbehaviorActionUseWorkspotNodeDefinition = {}

---@return AIbehaviorActionUseWorkspotNodeDefinition
function AIbehaviorActionUseWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorActionUseWorkspotNodeDefinition
function AIbehaviorActionUseWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorAdvancedParameterizedBehavior : AIbehaviorParameterizedBehavior
AIbehaviorAdvancedParameterizedBehavior = {}

---@return AIbehaviorAdvancedParameterizedBehavior
function AIbehaviorAdvancedParameterizedBehavior.new() return end

---@param props table
---@return AIbehaviorAdvancedParameterizedBehavior
function AIbehaviorAdvancedParameterizedBehavior.new(props) return end

---@class AIbehaviorAgentInfoDebuggerCommand : AIbehaviorIDebuggerCommand
---@field entityId entEntityID
---@field agentName String
---@field isSelected Bool
---@field entries AIbehaviorAgentInfoDebuggerCommandEntry[]
AIbehaviorAgentInfoDebuggerCommand = {}

---@return AIbehaviorAgentInfoDebuggerCommand
function AIbehaviorAgentInfoDebuggerCommand.new() return end

---@param props table
---@return AIbehaviorAgentInfoDebuggerCommand
function AIbehaviorAgentInfoDebuggerCommand.new(props) return end

---@class AIbehaviorAgentInfoDebuggerCommandEntry
---@field callStack AIbehaviorBehaviorInstanceCallStack
---@field behaviorResourcePath String
AIbehaviorAgentInfoDebuggerCommandEntry = {}

---@return AIbehaviorAgentInfoDebuggerCommandEntry
function AIbehaviorAgentInfoDebuggerCommandEntry.new() return end

---@param props table
---@return AIbehaviorAgentInfoDebuggerCommandEntry
function AIbehaviorAgentInfoDebuggerCommandEntry.new(props) return end

---@class AIbehaviorAndConditionDefinition : AIbehaviorCompositeConditionDefinition
AIbehaviorAndConditionDefinition = {}

---@return AIbehaviorAndConditionDefinition
function AIbehaviorAndConditionDefinition.new() return end

---@param props table
---@return AIbehaviorAndConditionDefinition
function AIbehaviorAndConditionDefinition.new(props) return end

---@class AIbehaviorAssignTaskDefinition : AIbehaviorTaskDefinition
---@field assignments AIbehaviorAssignTaskItem[]
---@field endAssignments AIbehaviorAssignTaskItem[]
AIbehaviorAssignTaskDefinition = {}

---@return AIbehaviorAssignTaskDefinition
function AIbehaviorAssignTaskDefinition.new() return end

---@param props table
---@return AIbehaviorAssignTaskDefinition
function AIbehaviorAssignTaskDefinition.new(props) return end

---@class AIbehaviorAssignTaskItem
---@field leftHandSide AIArgumentMapping
---@field rightHandSide AIArgumentMapping
AIbehaviorAssignTaskItem = {}

---@return AIbehaviorAssignTaskItem
function AIbehaviorAssignTaskItem.new() return end

---@param props table
---@return AIbehaviorAssignTaskItem
function AIbehaviorAssignTaskItem.new(props) return end

---@class AIbehaviorAsyncCallbackToken
AIbehaviorAsyncCallbackToken = {}

---@return AIbehaviorAsyncCallbackToken
function AIbehaviorAsyncCallbackToken.new() return end

---@param props table
---@return AIbehaviorAsyncCallbackToken
function AIbehaviorAsyncCallbackToken.new(props) return end

---@class AIbehaviorAttachToElevatorCommandTaskDefinition : AIbehaviorTaskDefinition
---@field command AIArgumentMapping
AIbehaviorAttachToElevatorCommandTaskDefinition = {}

---@return AIbehaviorAttachToElevatorCommandTaskDefinition
function AIbehaviorAttachToElevatorCommandTaskDefinition.new() return end

---@param props table
---@return AIbehaviorAttachToElevatorCommandTaskDefinition
function AIbehaviorAttachToElevatorCommandTaskDefinition.new(props) return end

---@class AIbehaviorAvoidPlayerTaskDefinition : AIbehaviorTaskDefinition
---@field threatRadius AIArgumentMapping
AIbehaviorAvoidPlayerTaskDefinition = {}

---@return AIbehaviorAvoidPlayerTaskDefinition
function AIbehaviorAvoidPlayerTaskDefinition.new() return end

---@param props table
---@return AIbehaviorAvoidPlayerTaskDefinition
function AIbehaviorAvoidPlayerTaskDefinition.new(props) return end

---@class AIbehaviorBehaviorBlackboard : IScriptable
AIbehaviorBehaviorBlackboard = {}

---@class AIbehaviorBehaviorComponentDefinition : ISerializable
AIbehaviorBehaviorComponentDefinition = {}

---@class AIbehaviorBehaviorDebugInfo : AIbehaviorDebugInfoBase
AIbehaviorBehaviorDebugInfo = {}

---@return AIbehaviorBehaviorDebugInfo
function AIbehaviorBehaviorDebugInfo.new() return end

---@param props table
---@return AIbehaviorBehaviorDebugInfo
function AIbehaviorBehaviorDebugInfo.new(props) return end

---@class AIbehaviorBehaviorDelegate : AIbehaviorBehaviorBlackboard
AIbehaviorBehaviorDelegate = {}

---@return AIbehaviorBehaviorDelegate
function AIbehaviorBehaviorDelegate:GetParent() return end

---@class AIbehaviorBehaviorIncludedDebuggerCommand : AIbehaviorIDebuggerCommand
---@field entries AIbehaviorBehaviorIncludedDebuggerCommandEntry[]
AIbehaviorBehaviorIncludedDebuggerCommand = {}

---@return AIbehaviorBehaviorIncludedDebuggerCommand
function AIbehaviorBehaviorIncludedDebuggerCommand.new() return end

---@param props table
---@return AIbehaviorBehaviorIncludedDebuggerCommand
function AIbehaviorBehaviorIncludedDebuggerCommand.new(props) return end

---@class AIbehaviorBehaviorIncludedDebuggerCommandEntry
---@field nodeId CGUID
---@field includedBehaviorResourcePath String
AIbehaviorBehaviorIncludedDebuggerCommandEntry = {}

---@return AIbehaviorBehaviorIncludedDebuggerCommandEntry
function AIbehaviorBehaviorIncludedDebuggerCommandEntry.new() return end

---@param props table
---@return AIbehaviorBehaviorIncludedDebuggerCommandEntry
function AIbehaviorBehaviorIncludedDebuggerCommandEntry.new(props) return end

---@class AIbehaviorBehaviorInstanceCallStack
---@field resourceHashes Uint32[]
AIbehaviorBehaviorInstanceCallStack = {}

---@return AIbehaviorBehaviorInstanceCallStack
function AIbehaviorBehaviorInstanceCallStack.new() return end

---@param props table
---@return AIbehaviorBehaviorInstanceCallStack
function AIbehaviorBehaviorInstanceCallStack.new(props) return end

---@class AIbehaviorCTreeNodeControlledByQuestNodeDefinition : AIbehaviorActionTreeNodeDefinition
AIbehaviorCTreeNodeControlledByQuestNodeDefinition = {}

---@return AIbehaviorCTreeNodeControlledByQuestNodeDefinition
function AIbehaviorCTreeNodeControlledByQuestNodeDefinition.new() return end

---@param props table
---@return AIbehaviorCTreeNodeControlledByQuestNodeDefinition
function AIbehaviorCTreeNodeControlledByQuestNodeDefinition.new(props) return end

---@class AIbehaviorCancelWorkspotCommandNodeDefinition : AIbehaviorDecoratorNodeDefinition
AIbehaviorCancelWorkspotCommandNodeDefinition = {}

---@return AIbehaviorCancelWorkspotCommandNodeDefinition
function AIbehaviorCancelWorkspotCommandNodeDefinition.new() return end

---@param props table
---@return AIbehaviorCancelWorkspotCommandNodeDefinition
function AIbehaviorCancelWorkspotCommandNodeDefinition.new(props) return end

---@class AIbehaviorChangeGuardAreaTaskDefinition : AIbehaviorTaskDefinition
---@field guardAreaNodeRef AIArgumentMapping
AIbehaviorChangeGuardAreaTaskDefinition = {}

---@return AIbehaviorChangeGuardAreaTaskDefinition
function AIbehaviorChangeGuardAreaTaskDefinition.new() return end

---@param props table
---@return AIbehaviorChangeGuardAreaTaskDefinition
function AIbehaviorChangeGuardAreaTaskDefinition.new(props) return end

---@class AIbehaviorCheckDistanceToCompanionConditionDefinition : AIbehaviorCompanionConditionDefinition
---@field distance AIArgumentMapping
---@field comparisonOperator EComparisonType
AIbehaviorCheckDistanceToCompanionConditionDefinition = {}

---@return AIbehaviorCheckDistanceToCompanionConditionDefinition
function AIbehaviorCheckDistanceToCompanionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorCheckDistanceToCompanionConditionDefinition
function AIbehaviorCheckDistanceToCompanionConditionDefinition.new(props) return end

---@class AIbehaviorCheckLineOfFireTaskDefinition : AIbehaviorTaskDefinition
---@field slotName AIArgumentMapping
---@field attachmentName AIArgumentMapping
---@field spread AIArgumentMapping
---@field maxRange AIArgumentMapping
AIbehaviorCheckLineOfFireTaskDefinition = {}

---@return AIbehaviorCheckLineOfFireTaskDefinition
function AIbehaviorCheckLineOfFireTaskDefinition.new() return end

---@param props table
---@return AIbehaviorCheckLineOfFireTaskDefinition
function AIbehaviorCheckLineOfFireTaskDefinition.new(props) return end

---@class AIbehaviorClearActiveNodesDebuggerCommand : AIbehaviorIDebuggerCommand
AIbehaviorClearActiveNodesDebuggerCommand = {}

---@return AIbehaviorClearActiveNodesDebuggerCommand
function AIbehaviorClearActiveNodesDebuggerCommand.new() return end

---@param props table
---@return AIbehaviorClearActiveNodesDebuggerCommand
function AIbehaviorClearActiveNodesDebuggerCommand.new(props) return end

---@class AIbehaviorClearSearchInfluenceTaskDefinition : AIbehaviorTaskDefinition
---@field clearedAreaRadius AIArgumentMapping
---@field clearedAreaDistance AIArgumentMapping
---@field clearedAreaAngle AIArgumentMapping
AIbehaviorClearSearchInfluenceTaskDefinition = {}

---@return AIbehaviorClearSearchInfluenceTaskDefinition
function AIbehaviorClearSearchInfluenceTaskDefinition.new() return end

---@param props table
---@return AIbehaviorClearSearchInfluenceTaskDefinition
function AIbehaviorClearSearchInfluenceTaskDefinition.new(props) return end

---@class AIbehaviorClearUsedAlertedSpotsTaskDefinition : AIbehaviorTaskDefinition
---@field usedTokens AIArgumentMapping
AIbehaviorClearUsedAlertedSpotsTaskDefinition = {}

---@return AIbehaviorClearUsedAlertedSpotsTaskDefinition
function AIbehaviorClearUsedAlertedSpotsTaskDefinition.new() return end

---@param props table
---@return AIbehaviorClearUsedAlertedSpotsTaskDefinition
function AIbehaviorClearUsedAlertedSpotsTaskDefinition.new(props) return end

---@class AIbehaviorCombatModeTaskDefinition : AIbehaviorTaskDefinition
---@field mode AIbehaviorCombatModes
---@field priority Int32
---@field timeToLive Float
AIbehaviorCombatModeTaskDefinition = {}

---@return AIbehaviorCombatModeTaskDefinition
function AIbehaviorCombatModeTaskDefinition.new() return end

---@param props table
---@return AIbehaviorCombatModeTaskDefinition
function AIbehaviorCombatModeTaskDefinition.new(props) return end

---@class AIbehaviorCommandConditionDefinition : AIbehaviorConditionDefinition
---@field commandName AIArgumentMapping
---@field useInheritance Bool
---@field isWaiting Bool
---@field isExecuting Bool
---@field commandOut AIArgumentMapping
AIbehaviorCommandConditionDefinition = {}

---@return AIbehaviorCommandConditionDefinition
function AIbehaviorCommandConditionDefinition.new() return end

---@param props table
---@return AIbehaviorCommandConditionDefinition
function AIbehaviorCommandConditionDefinition.new(props) return end

---@class AIbehaviorCommandConditionExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field commandName CName
---@field useInheritance Bool
---@field isEnqueued Bool
---@field isExecuting Bool
AIbehaviorCommandConditionExpressionDefinition = {}

---@return AIbehaviorCommandConditionExpressionDefinition
function AIbehaviorCommandConditionExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorCommandConditionExpressionDefinition
function AIbehaviorCommandConditionExpressionDefinition.new(props) return end

---@class AIbehaviorCommandHandlerNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field commandName CName
---@field useInheritance Bool
---@field contexts AICommandContextsType[]
---@field commandOut AIArgumentMapping
---@field runningSignal CName
---@field waitForCommand Bool
---@field retryIfCommandEnqueued Bool
---@field resultIfNoCommand AIbehaviorCompletionStatus
---@field resultIfChildFailed AIbehaviorCompletionStatus
AIbehaviorCommandHandlerNodeDefinition = {}

---@return AIbehaviorCommandHandlerNodeDefinition
function AIbehaviorCommandHandlerNodeDefinition.new() return end

---@param props table
---@return AIbehaviorCommandHandlerNodeDefinition
function AIbehaviorCommandHandlerNodeDefinition.new(props) return end

---@class AIbehaviorCompanionConditionDefinition : AIbehaviorConditionDefinition
---@field spline AIArgumentMapping
---@field companion AIArgumentMapping
AIbehaviorCompanionConditionDefinition = {}

---@class AIbehaviorComparisonExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field leftHandSide AIbehaviorExpressionSocket
---@field operator EComparisonType
---@field rightHandSide AIbehaviorExpressionSocket
AIbehaviorComparisonExpressionDefinition = {}

---@return AIbehaviorComparisonExpressionDefinition
function AIbehaviorComparisonExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorComparisonExpressionDefinition
function AIbehaviorComparisonExpressionDefinition.new(props) return end

---@class AIbehaviorCompleteOnEventNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field eventName CName
---@field resultOnEvent AIbehaviorCompletionStatus
AIbehaviorCompleteOnEventNodeDefinition = {}

---@return AIbehaviorCompleteOnEventNodeDefinition
function AIbehaviorCompleteOnEventNodeDefinition.new() return end

---@param props table
---@return AIbehaviorCompleteOnEventNodeDefinition
function AIbehaviorCompleteOnEventNodeDefinition.new(props) return end

---@class AIbehaviorCompositeConditionDefinition : AIbehaviorConditionDefinition
---@field conditions AIbehaviorConditionDefinition[]
AIbehaviorCompositeConditionDefinition = {}

---@class AIbehaviorCompositeTreeNodeDefinition : AIbehaviorTreeNodeDefinition
---@field children AIbehaviorTreeNodeDefinition[]
AIbehaviorCompositeTreeNodeDefinition = {}

---@class AIbehaviorConditionDefinition : AIbehaviorBehaviorComponentDefinition
---@field isInverted Bool
AIbehaviorConditionDefinition = {}

---@class AIbehaviorConditionNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field condition AIbehaviorConditionDefinition
---@field resultIfFailed AIbehaviorCompletionStatus
AIbehaviorConditionNodeDefinition = {}

---@class AIbehaviorConstantExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field type AIbehaviorTypeRef
---@field value Variant
AIbehaviorConstantExpressionDefinition = {}

---@return AIbehaviorConstantExpressionDefinition
function AIbehaviorConstantExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorConstantExpressionDefinition
function AIbehaviorConstantExpressionDefinition.new(props) return end

---@class AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition : AIbehaviorTaskDefinition
---@field command AIArgumentMapping
---@field outWorkspotData AIArgumentMapping
AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition = {}

---@return AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition
function AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition.new() return end

---@param props table
---@return AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition
function AIbehaviorConvertCommandToDynamicWorkspotTaskDefinition.new(props) return end

---@class AIbehaviorConvertToDynamicWorkspotTaskDefinition : AIbehaviorTaskDefinition
---@field workspotData AIArgumentMapping
---@field spotInstance AIArgumentMapping
---@field jumpToEntry AIArgumentMapping
---@field entryId AIArgumentMapping
AIbehaviorConvertToDynamicWorkspotTaskDefinition = {}

---@return AIbehaviorConvertToDynamicWorkspotTaskDefinition
function AIbehaviorConvertToDynamicWorkspotTaskDefinition.new() return end

---@param props table
---@return AIbehaviorConvertToDynamicWorkspotTaskDefinition
function AIbehaviorConvertToDynamicWorkspotTaskDefinition.new(props) return end

---@class AIbehaviorCreateAlertedInfluenceMapTaskDefinition : AIbehaviorTaskDefinition
AIbehaviorCreateAlertedInfluenceMapTaskDefinition = {}

---@return AIbehaviorCreateAlertedInfluenceMapTaskDefinition
function AIbehaviorCreateAlertedInfluenceMapTaskDefinition.new() return end

---@param props table
---@return AIbehaviorCreateAlertedInfluenceMapTaskDefinition
function AIbehaviorCreateAlertedInfluenceMapTaskDefinition.new(props) return end

---@class AIbehaviorCrowdSettingsNameVehicleExpressionDefinition : AIbehaviorVehicleExpressionDefinition
---@field settingsName CName
AIbehaviorCrowdSettingsNameVehicleExpressionDefinition = {}

---@return AIbehaviorCrowdSettingsNameVehicleExpressionDefinition
function AIbehaviorCrowdSettingsNameVehicleExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorCrowdSettingsNameVehicleExpressionDefinition
function AIbehaviorCrowdSettingsNameVehicleExpressionDefinition.new(props) return end

---@class AIbehaviorDebugFailsafeConditionDefinition : AIbehaviorConditionDefinition
---@field logMessage AIArgumentMapping
AIbehaviorDebugFailsafeConditionDefinition = {}

---@return AIbehaviorDebugFailsafeConditionDefinition
function AIbehaviorDebugFailsafeConditionDefinition.new() return end

---@param props table
---@return AIbehaviorDebugFailsafeConditionDefinition
function AIbehaviorDebugFailsafeConditionDefinition.new(props) return end

---@class AIbehaviorDebugInfoBase : ISerializable
---@field caption String
AIbehaviorDebugInfoBase = {}

---@return AIbehaviorDebugInfoBase
function AIbehaviorDebugInfoBase.new() return end

---@param props table
---@return AIbehaviorDebugInfoBase
function AIbehaviorDebugInfoBase.new(props) return end

---@class AIbehaviorDebugger : AIbehaviorIDebugger
AIbehaviorDebugger = {}

---@return AIbehaviorDebugger
function AIbehaviorDebugger.new() return end

---@param props table
---@return AIbehaviorDebugger
function AIbehaviorDebugger.new(props) return end

---@class AIbehaviorDecoratorNodeDefinition : AIbehaviorTreeNodeDefinition
---@field child AIbehaviorTreeNodeDefinition
AIbehaviorDecoratorNodeDefinition = {}

---@class AIbehaviorDelegateAttrRef
---@field name CName
AIbehaviorDelegateAttrRef = {}

---@return AIbehaviorDelegateAttrRef
function AIbehaviorDelegateAttrRef.new() return end

---@param props table
---@return AIbehaviorDelegateAttrRef
function AIbehaviorDelegateAttrRef.new(props) return end

---@class AIbehaviorDelegateExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field delegateAttribute AIbehaviorDelegateAttrRef
---@field behaviorCallbackNames CName[]
AIbehaviorDelegateExpressionDefinition = {}

---@return AIbehaviorDelegateExpressionDefinition
function AIbehaviorDelegateExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorDelegateExpressionDefinition
function AIbehaviorDelegateExpressionDefinition.new(props) return end

---@class AIbehaviorDelegateTaskDefinition : AIbehaviorTaskDefinition
---@field onActivate AIbehaviorDelegateTaskRef
---@field onUpdate AIbehaviorDelegateTaskRef
---@field onDeactivate AIbehaviorDelegateTaskRef
AIbehaviorDelegateTaskDefinition = {}

---@return AIbehaviorDelegateTaskDefinition
function AIbehaviorDelegateTaskDefinition.new() return end

---@param props table
---@return AIbehaviorDelegateTaskDefinition
function AIbehaviorDelegateTaskDefinition.new(props) return end

---@class AIbehaviorDelegateTaskRef
---@field name CName
AIbehaviorDelegateTaskRef = {}

---@return AIbehaviorDelegateTaskRef
function AIbehaviorDelegateTaskRef.new() return end

---@param props table
---@return AIbehaviorDelegateTaskRef
function AIbehaviorDelegateTaskRef.new(props) return end

---@class AIbehaviorDistanceToExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field target AIbehaviorExpressionSocket
---@field tolerance Float
---@field updatePeriod Float
AIbehaviorDistanceToExpressionDefinition = {}

---@return AIbehaviorDistanceToExpressionDefinition
function AIbehaviorDistanceToExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorDistanceToExpressionDefinition
function AIbehaviorDistanceToExpressionDefinition.new(props) return end

---@class AIbehaviorDistanceToTargetConditionDefinition : AIbehaviorConditionDefinition
---@field target AIArgumentMapping
---@field distance AIArgumentMapping
---@field comparisonOperator EComparisonType
AIbehaviorDistanceToTargetConditionDefinition = {}

---@class AIbehaviorDistanceToTargetObjectConditionDefinition : AIbehaviorDistanceToTargetConditionDefinition
AIbehaviorDistanceToTargetObjectConditionDefinition = {}

---@return AIbehaviorDistanceToTargetObjectConditionDefinition
function AIbehaviorDistanceToTargetObjectConditionDefinition.new() return end

---@param props table
---@return AIbehaviorDistanceToTargetObjectConditionDefinition
function AIbehaviorDistanceToTargetObjectConditionDefinition.new(props) return end

---@class AIbehaviorDistanceToTargetPositionConditionDefinition : AIbehaviorDistanceToTargetConditionDefinition
AIbehaviorDistanceToTargetPositionConditionDefinition = {}

---@return AIbehaviorDistanceToTargetPositionConditionDefinition
function AIbehaviorDistanceToTargetPositionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorDistanceToTargetPositionConditionDefinition
function AIbehaviorDistanceToTargetPositionConditionDefinition.new(props) return end

---@class AIbehaviorDriveAvSimpleTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field timeToTravel AIArgumentMapping
---@field distanceToTravel AIArgumentMapping
---@field useEaseInFunction AIArgumentMapping
---@field useEaseOutFunction AIArgumentMapping
---@field movementDirection AIArgumentMapping
---@field useForwardDirection AIArgumentMapping
---@field easeBounceMultiplier AIArgumentMapping
---@field despawnAtTheEnd AIArgumentMapping
---@field disableVFXs AIArgumentMapping
---@field facePlayer AIArgumentMapping
---@field doLandingRotation AIArgumentMapping
---@field interruptTaskOnLandingFound AIArgumentMapping
---@field attemptToSendEarlyDismountCommand AIArgumentMapping
AIbehaviorDriveAvSimpleTreeNodeDefinition = {}

---@return AIbehaviorDriveAvSimpleTreeNodeDefinition
function AIbehaviorDriveAvSimpleTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveAvSimpleTreeNodeDefinition
function AIbehaviorDriveAvSimpleTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveChaseTargetTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field target AIArgumentMapping
---@field distanceMin AIArgumentMapping
---@field distanceMax AIArgumentMapping
---@field forcedStartSpeed AIArgumentMapping
---@field needDriver AIArgumentMapping
---@field aggressiveRammingEnabled AIArgumentMapping
---@field ignoreChaseVehiclesLimit AIArgumentMapping
---@field boostDrivingStats AIArgumentMapping
AIbehaviorDriveChaseTargetTreeNodeDefinition = {}

---@return AIbehaviorDriveChaseTargetTreeNodeDefinition
function AIbehaviorDriveChaseTargetTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveChaseTargetTreeNodeDefinition
function AIbehaviorDriveChaseTargetTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition = {}

---@return AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition
function AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition
function AIbehaviorDriveCreateTrafficSlotTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveFollowPositionTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveFollowPositionTreeNodeDefinition = {}

---@return AIbehaviorDriveFollowPositionTreeNodeDefinition
function AIbehaviorDriveFollowPositionTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveFollowPositionTreeNodeDefinition
function AIbehaviorDriveFollowPositionTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveFollowSlotTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveFollowSlotTreeNodeDefinition = {}

---@return AIbehaviorDriveFollowSlotTreeNodeDefinition
function AIbehaviorDriveFollowSlotTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveFollowSlotTreeNodeDefinition
function AIbehaviorDriveFollowSlotTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveFollowSplineTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field useKinematic AIArgumentMapping
---@field needDriver AIArgumentMapping
---@field spline AIArgumentMapping
---@field secureTimeOut AIArgumentMapping
---@field backwards AIArgumentMapping
---@field reverse AIArgumentMapping
---@field closest AIArgumentMapping
---@field forcedStartSpeed AIArgumentMapping
---@field stopAtPathEnd AIArgumentMapping
---@field keepDistanceParamBool AIArgumentMapping
---@field keepDistanceParamCompanion AIArgumentMapping
---@field keepDistanceParamDistance AIArgumentMapping
---@field rubberBandingBool AIArgumentMapping
---@field rubberBandingTargetRef AIArgumentMapping
---@field rubberBandingMinDistance AIArgumentMapping
---@field rubberBandingMaxDistance AIArgumentMapping
---@field rubberBandingStopAndWait AIArgumentMapping
---@field rubberBandingTeleportToCatchUp AIArgumentMapping
---@field audioCurvesParam AIArgumentMapping
AIbehaviorDriveFollowSplineTreeNodeDefinition = {}

---@return AIbehaviorDriveFollowSplineTreeNodeDefinition
function AIbehaviorDriveFollowSplineTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveFollowSplineTreeNodeDefinition
function AIbehaviorDriveFollowSplineTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveFollowTargetTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field useKinematic AIArgumentMapping
---@field needDriver AIArgumentMapping
---@field target AIArgumentMapping
---@field secureTimeOut AIArgumentMapping
---@field distanceMin AIArgumentMapping
---@field distanceMax AIArgumentMapping
---@field isPlayer AIArgumentMapping
---@field stopHasReachedTarget AIArgumentMapping
---@field useTraffic AIArgumentMapping
---@field allowStubMovement AIArgumentMapping
AIbehaviorDriveFollowTargetTreeNodeDefinition = {}

---@return AIbehaviorDriveFollowTargetTreeNodeDefinition
function AIbehaviorDriveFollowTargetTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveFollowTargetTreeNodeDefinition
function AIbehaviorDriveFollowTargetTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveIdleTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveIdleTreeNodeDefinition = {}

---@return AIbehaviorDriveIdleTreeNodeDefinition
function AIbehaviorDriveIdleTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveIdleTreeNodeDefinition
function AIbehaviorDriveIdleTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveJoinTrafficTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveJoinTrafficTreeNodeDefinition = {}

---@return AIbehaviorDriveJoinTrafficTreeNodeDefinition
function AIbehaviorDriveJoinTrafficTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveJoinTrafficTreeNodeDefinition
function AIbehaviorDriveJoinTrafficTreeNodeDefinition.new(props) return end

---@class AIbehaviorDrivePanicTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field allowSimplifiedMovement AIArgumentMapping
---@field ignoreTickets AIArgumentMapping
---@field disableStuckDetection AIArgumentMapping
---@field useSpeedBasedLookupRange AIArgumentMapping
---@field tryDriveAwayFromPlayer AIArgumentMapping
AIbehaviorDrivePanicTreeNodeDefinition = {}

---@return AIbehaviorDrivePanicTreeNodeDefinition
function AIbehaviorDrivePanicTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDrivePanicTreeNodeDefinition
function AIbehaviorDrivePanicTreeNodeDefinition.new(props) return end

---@class AIbehaviorDrivePatrolTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field maxSpeed AIArgumentMapping
---@field minSpeed AIArgumentMapping
---@field clearTrafficOnPath AIArgumentMapping
---@field emergencyPatrol AIArgumentMapping
---@field numPatrolLoops AIArgumentMapping
---@field forcedStartSpeed AIArgumentMapping
AIbehaviorDrivePatrolTreeNodeDefinition = {}

---@return AIbehaviorDrivePatrolTreeNodeDefinition
function AIbehaviorDrivePatrolTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDrivePatrolTreeNodeDefinition
function AIbehaviorDrivePatrolTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveRacingTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field useKinematic AIArgumentMapping
---@field needDriver AIArgumentMapping
---@field spline AIArgumentMapping
---@field secureTimeOut AIArgumentMapping
---@field backwards AIArgumentMapping
---@field reverse AIArgumentMapping
---@field closest AIArgumentMapping
---@field forcedStartSpeed AIArgumentMapping
---@field stopAtPathEnd AIArgumentMapping
---@field keepDistanceParamBool AIArgumentMapping
---@field keepDistanceParamCompanion AIArgumentMapping
---@field keepDistanceParamDistance AIArgumentMapping
---@field rubberBandingBool AIArgumentMapping
---@field rubberBandingTargetRef AIArgumentMapping
---@field rubberBandingMinDistance AIArgumentMapping
---@field rubberBandingMaxDistance AIArgumentMapping
---@field rubberBandingStopAndWait AIArgumentMapping
---@field rubberBandingTeleportToCatchUp AIArgumentMapping
---@field rubberBandingStayInFront AIArgumentMapping
AIbehaviorDriveRacingTreeNodeDefinition = {}

---@return AIbehaviorDriveRacingTreeNodeDefinition
function AIbehaviorDriveRacingTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveRacingTreeNodeDefinition
function AIbehaviorDriveRacingTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveSplineReverseTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field spline AIArgumentMapping
AIbehaviorDriveSplineReverseTreeNodeDefinition = {}

---@return AIbehaviorDriveSplineReverseTreeNodeDefinition
function AIbehaviorDriveSplineReverseTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveSplineReverseTreeNodeDefinition
function AIbehaviorDriveSplineReverseTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveStunnedTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveStunnedTreeNodeDefinition = {}

---@return AIbehaviorDriveStunnedTreeNodeDefinition
function AIbehaviorDriveStunnedTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveStunnedTreeNodeDefinition
function AIbehaviorDriveStunnedTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveSummoningTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
AIbehaviorDriveSummoningTreeNodeDefinition = {}

---@return AIbehaviorDriveSummoningTreeNodeDefinition
function AIbehaviorDriveSummoningTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveSummoningTreeNodeDefinition
function AIbehaviorDriveSummoningTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveToNodeTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field useKinematic AIArgumentMapping
---@field needDriver AIArgumentMapping
---@field nodeRef AIArgumentMapping
---@field stopAtPathEnd AIArgumentMapping
---@field secureTimeOut AIArgumentMapping
---@field isPlayer AIArgumentMapping
---@field useTraffic AIArgumentMapping
---@field speedInTraffic AIArgumentMapping
---@field forceGreenLights AIArgumentMapping
---@field portals AIArgumentMapping
---@field trafficTryNeighborsForStart AIArgumentMapping
---@field trafficTryNeighborsForEnd AIArgumentMapping
AIbehaviorDriveToNodeTreeNodeDefinition = {}

---@return AIbehaviorDriveToNodeTreeNodeDefinition
function AIbehaviorDriveToNodeTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveToNodeTreeNodeDefinition
function AIbehaviorDriveToNodeTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveToPointAutonomousTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field targetPosition AIArgumentMapping
---@field maxSpeed AIArgumentMapping
---@field minSpeed AIArgumentMapping
---@field clearTrafficOnPath AIArgumentMapping
---@field minimumDistanceToTarget AIArgumentMapping
---@field forcedStartSpeed AIArgumentMapping
---@field driveDownTheRoadIndefinitely AIArgumentMapping
AIbehaviorDriveToPointAutonomousTreeNodeDefinition = {}

---@return AIbehaviorDriveToPointAutonomousTreeNodeDefinition
function AIbehaviorDriveToPointAutonomousTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveToPointAutonomousTreeNodeDefinition
function AIbehaviorDriveToPointAutonomousTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveToPointTreeNodeDefinition : AIbehaviorDriveTreeNodeDefinition
---@field targetPosition AIArgumentMapping
---@field secureTimeOut AIArgumentMapping
---@field useTraffic AIArgumentMapping
---@field speedInTraffic AIArgumentMapping
---@field forceGreenLights AIArgumentMapping
---@field portals AIArgumentMapping
---@field trafficTryNeighborsForStart AIArgumentMapping
---@field trafficTryNeighborsForEnd AIArgumentMapping
AIbehaviorDriveToPointTreeNodeDefinition = {}

---@return AIbehaviorDriveToPointTreeNodeDefinition
function AIbehaviorDriveToPointTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorDriveToPointTreeNodeDefinition
function AIbehaviorDriveToPointTreeNodeDefinition.new(props) return end

---@class AIbehaviorDriveTreeNodeDefinition : AIbehaviorActionTreeNodeDefinition
AIbehaviorDriveTreeNodeDefinition = {}

---@class AIbehaviorEdgeConditionDefinition : AIbehaviorUnaryConditionDefinition
---@field risingEdgeAction AIbehaviorEdgeConditionAction
---@field fallingEdgeAction AIbehaviorEdgeConditionAction
---@field initialValue Bool
AIbehaviorEdgeConditionDefinition = {}

---@return AIbehaviorEdgeConditionDefinition
function AIbehaviorEdgeConditionDefinition.new() return end

---@param props table
---@return AIbehaviorEdgeConditionDefinition
function AIbehaviorEdgeConditionDefinition.new(props) return end

---@class AIbehaviorEntityLODConditionDefinition : AIbehaviorConditionDefinition
---@field any AIbehaviorEntityLODConditions[]
---@field all AIbehaviorEntityLODConditions[]
---@field none AIbehaviorEntityLODConditions[]
AIbehaviorEntityLODConditionDefinition = {}

---@return AIbehaviorEntityLODConditionDefinition
function AIbehaviorEntityLODConditionDefinition.new() return end

---@param props table
---@return AIbehaviorEntityLODConditionDefinition
function AIbehaviorEntityLODConditionDefinition.new(props) return end

---@class AIbehaviorEntityReuseEventResolverDefinition : AIbehaviorEventResolverDefinition
---@field destination AIArgumentMapping
---@field fastForwardAfterTeleport AIArgumentMapping
AIbehaviorEntityReuseEventResolverDefinition = {}

---@return AIbehaviorEntityReuseEventResolverDefinition
function AIbehaviorEntityReuseEventResolverDefinition.new() return end

---@param props table
---@return AIbehaviorEntityReuseEventResolverDefinition
function AIbehaviorEntityReuseEventResolverDefinition.new(props) return end

---@class AIbehaviorEventConditionDefinition : ISerializable
---@field condition AIbehaviorConditionDefinition
---@field eventName CName
AIbehaviorEventConditionDefinition = {}

---@return AIbehaviorEventConditionDefinition
function AIbehaviorEventConditionDefinition.new() return end

---@param props table
---@return AIbehaviorEventConditionDefinition
function AIbehaviorEventConditionDefinition.new(props) return end

---@class AIbehaviorEventHandler
AIbehaviorEventHandler = {}

---@return AIbehaviorEventHandler
function AIbehaviorEventHandler.new() return end

---@param props table
---@return AIbehaviorEventHandler
function AIbehaviorEventHandler.new(props) return end

---@class AIbehaviorEventHandlerNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field eventName CName
---@field resolver AIbehaviorEventResolverDefinition
AIbehaviorEventHandlerNodeDefinition = {}

---@return AIbehaviorEventHandlerNodeDefinition
function AIbehaviorEventHandlerNodeDefinition.new() return end

---@param props table
---@return AIbehaviorEventHandlerNodeDefinition
function AIbehaviorEventHandlerNodeDefinition.new(props) return end

---@class AIbehaviorEventResolverDefinition : ISerializable
AIbehaviorEventResolverDefinition = {}

---@class AIbehaviorEventWithTagConditionDefinition : AIbehaviorConditionDefinition
---@field tag CName
---@field consumeEvent Bool
AIbehaviorEventWithTagConditionDefinition = {}

---@return AIbehaviorEventWithTagConditionDefinition
function AIbehaviorEventWithTagConditionDefinition.new() return end

---@param props table
---@return AIbehaviorEventWithTagConditionDefinition
function AIbehaviorEventWithTagConditionDefinition.new(props) return end

---@class AIbehaviorExitWorkspotNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field skipExitAnimation AIArgumentMapping
---@field useSlowExitAnimation AIArgumentMapping
---@field doSlowIfFastExitFails AIArgumentMapping
---@field stayInWorkspotIfExitFails AIArgumentMapping
---@field tryBlendFastExitToWalk AIArgumentMapping
---@field dontRequestExit AIArgumentMapping
---@field cancelQueuedCommand AIArgumentMapping
---@field target AIArgumentMapping
AIbehaviorExitWorkspotNodeDefinition = {}

---@return AIbehaviorExitWorkspotNodeDefinition
function AIbehaviorExitWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorExitWorkspotNodeDefinition
function AIbehaviorExitWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorExpressionSocket : ISerializable
---@field typeHint AIbehaviorTypeRef
---@field expression AIbehaviorPassiveExpressionDefinition
AIbehaviorExpressionSocket = {}

---@return AIbehaviorExpressionSocket
function AIbehaviorExpressionSocket.new() return end

---@param props table
---@return AIbehaviorExpressionSocket
function AIbehaviorExpressionSocket.new(props) return end

---@class AIbehaviorExtractMountDataTaskDefinition : AIbehaviorTaskDefinition
---@field mountEventData AIArgumentMapping
---@field outWorkspotData AIArgumentMapping
---@field outIsInstant AIArgumentMapping
---@field outAllowFailsafeTeleport AIArgumentMapping
AIbehaviorExtractMountDataTaskDefinition = {}

---@return AIbehaviorExtractMountDataTaskDefinition
function AIbehaviorExtractMountDataTaskDefinition.new() return end

---@param props table
---@return AIbehaviorExtractMountDataTaskDefinition
function AIbehaviorExtractMountDataTaskDefinition.new(props) return end

---@class AIbehaviorExtractMountParentStubPositionTaskDefinition : AIbehaviorTaskDefinition
---@field mountData AIArgumentMapping
---@field position AIArgumentMapping
AIbehaviorExtractMountParentStubPositionTaskDefinition = {}

---@return AIbehaviorExtractMountParentStubPositionTaskDefinition
function AIbehaviorExtractMountParentStubPositionTaskDefinition.new() return end

---@param props table
---@return AIbehaviorExtractMountParentStubPositionTaskDefinition
function AIbehaviorExtractMountParentStubPositionTaskDefinition.new(props) return end

---@class AIbehaviorExtractVehicleSlotWorkspotTaskDefinition : AIbehaviorTaskDefinition
---@field outWorkspotData AIArgumentMapping
AIbehaviorExtractVehicleSlotWorkspotTaskDefinition = {}

---@return AIbehaviorExtractVehicleSlotWorkspotTaskDefinition
function AIbehaviorExtractVehicleSlotWorkspotTaskDefinition.new() return end

---@param props table
---@return AIbehaviorExtractVehicleSlotWorkspotTaskDefinition
function AIbehaviorExtractVehicleSlotWorkspotTaskDefinition.new(props) return end

---@class AIbehaviorFSMStateDefinition : AIbehaviorTreeNodeDefinition
---@field behaviorRoot AIbehaviorTreeNodeDefinition
---@field isInitial Bool
---@field isExit Bool
---@field completionStatus AIbehaviorStateCompletionStatus
AIbehaviorFSMStateDefinition = {}

---@return AIbehaviorFSMStateDefinition
function AIbehaviorFSMStateDefinition.new() return end

---@param props table
---@return AIbehaviorFSMStateDefinition
function AIbehaviorFSMStateDefinition.new(props) return end

---@class AIbehaviorFSMStateWrapper
AIbehaviorFSMStateWrapper = {}

---@return AIbehaviorFSMStateWrapper
function AIbehaviorFSMStateWrapper.new() return end

---@param props table
---@return AIbehaviorFSMStateWrapper
function AIbehaviorFSMStateWrapper.new(props) return end

---@class AIbehaviorFSMTransitionDefinition : AIbehaviorBehaviorComponentDefinition
---@field inState Uint16
---@field outState Uint16
---@field evaluationOrder Int32
---@field instantConditions AIbehaviorInstantConditionDefinition[]
---@field monitorConditions AIbehaviorMonitorConditionDefinition[]
---@field eventConditions AIbehaviorEventConditionDefinition[]
---@field passiveConditions AIbehaviorExpressionSocket[]
AIbehaviorFSMTransitionDefinition = {}

---@return AIbehaviorFSMTransitionDefinition
function AIbehaviorFSMTransitionDefinition.new() return end

---@param props table
---@return AIbehaviorFSMTransitionDefinition
function AIbehaviorFSMTransitionDefinition.new(props) return end

---@class AIbehaviorFSMTreeNodeDefinition : AIbehaviorTreeNodeDefinition
---@field states AIbehaviorFSMStateDefinition[]
---@field transitions AIbehaviorFSMTransitionDefinition[]
---@field initialState AIbehaviorFSMStateDefinition
AIbehaviorFSMTreeNodeDefinition = {}

---@return AIbehaviorFSMTreeNodeDefinition
function AIbehaviorFSMTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorFSMTreeNodeDefinition
function AIbehaviorFSMTreeNodeDefinition.new(props) return end

---@class AIbehaviorFailerNodeDefinition : AIbehaviorLeafTreeNodeDefinition
AIbehaviorFailerNodeDefinition = {}

---@return AIbehaviorFailerNodeDefinition
function AIbehaviorFailerNodeDefinition.new() return end

---@param props table
---@return AIbehaviorFailerNodeDefinition
function AIbehaviorFailerNodeDefinition.new(props) return end

---@class AIbehaviorFindAlertedWorkspotTaskDefinition : AIbehaviorTaskDefinition
---@field usedTokens AIArgumentMapping
---@field spots AIArgumentMapping
---@field radius AIArgumentMapping
---@field outWorkspotData AIArgumentMapping
AIbehaviorFindAlertedWorkspotTaskDefinition = {}

---@return AIbehaviorFindAlertedWorkspotTaskDefinition
function AIbehaviorFindAlertedWorkspotTaskDefinition.new() return end

---@param props table
---@return AIbehaviorFindAlertedWorkspotTaskDefinition
function AIbehaviorFindAlertedWorkspotTaskDefinition.new(props) return end

---@class AIbehaviorFindClosestPointOnPathTaskDefinition : AIbehaviorTaskDefinition
---@field path AIArgumentMapping
---@field forceStartFromClosest AIArgumentMapping
---@field patrolProgress AIArgumentMapping
---@field positionOnPath AIArgumentMapping
---@field entryTangent AIArgumentMapping
AIbehaviorFindClosestPointOnPathTaskDefinition = {}

---@return AIbehaviorFindClosestPointOnPathTaskDefinition
function AIbehaviorFindClosestPointOnPathTaskDefinition.new() return end

---@param props table
---@return AIbehaviorFindClosestPointOnPathTaskDefinition
function AIbehaviorFindClosestPointOnPathTaskDefinition.new(props) return end

---@class AIbehaviorFindClosestPointOnTrafficPathTaskDefinition : AIbehaviorTaskDefinition
---@field enterClosest AIArgumentMapping
---@field avoidedPosition AIArgumentMapping
---@field useThreatPosAsAvoidedPos AIArgumentMapping
---@field avoidedPositionDistance AIArgumentMapping
---@field usePreviousPosition AIArgumentMapping
---@field checkRoadIntersection AIArgumentMapping
---@field workspotData AIArgumentMapping
---@field positionOnPath AIArgumentMapping
---@field pathDirection AIArgumentMapping
---@field joinTrafficSettings AIArgumentMapping
AIbehaviorFindClosestPointOnTrafficPathTaskDefinition = {}

---@return AIbehaviorFindClosestPointOnTrafficPathTaskDefinition
function AIbehaviorFindClosestPointOnTrafficPathTaskDefinition.new() return end

---@param props table
---@return AIbehaviorFindClosestPointOnTrafficPathTaskDefinition
function AIbehaviorFindClosestPointOnTrafficPathTaskDefinition.new(props) return end

---@class AIbehaviorFindLaneTaskDefinition : AIbehaviorTaskDefinition
---@field pointOnLane AIArgumentMapping
---@field filter worldFindLaneFilter
AIbehaviorFindLaneTaskDefinition = {}

---@return AIbehaviorFindLaneTaskDefinition
function AIbehaviorFindLaneTaskDefinition.new() return end

---@param props table
---@return AIbehaviorFindLaneTaskDefinition
function AIbehaviorFindLaneTaskDefinition.new(props) return end

---@class AIbehaviorFindNavigablePointTaskDefinition : AIbehaviorTaskDefinition
---@field destination AIArgumentMapping
---@field outAdjustedDestination AIArgumentMapping
---@field outWasAdjusted AIArgumentMapping
AIbehaviorFindNavigablePointTaskDefinition = {}

---@return AIbehaviorFindNavigablePointTaskDefinition
function AIbehaviorFindNavigablePointTaskDefinition.new() return end

---@param props table
---@return AIbehaviorFindNavigablePointTaskDefinition
function AIbehaviorFindNavigablePointTaskDefinition.new(props) return end

---@class AIbehaviorFindTeleportPositionTaskDefinition : AIbehaviorTaskDefinition
---@field patrolPath AIArgumentMapping
---@field teleportPosition AIArgumentMapping
---@field teleportRotation AIArgumentMapping
AIbehaviorFindTeleportPositionTaskDefinition = {}

---@return AIbehaviorFindTeleportPositionTaskDefinition
function AIbehaviorFindTeleportPositionTaskDefinition.new() return end

---@param props table
---@return AIbehaviorFindTeleportPositionTaskDefinition
function AIbehaviorFindTeleportPositionTaskDefinition.new(props) return end

---@class AIbehaviorForcedBehaviorNodeDefinition : AIbehaviorTreeNodeDefinition
AIbehaviorForcedBehaviorNodeDefinition = {}

---@return AIbehaviorForcedBehaviorNodeDefinition
function AIbehaviorForcedBehaviorNodeDefinition.new() return end

---@param props table
---@return AIbehaviorForcedBehaviorNodeDefinition
function AIbehaviorForcedBehaviorNodeDefinition.new(props) return end

---@class AIbehaviorFreeReservedWorkspotNodeDefinition : AIbehaviorDecoratorNodeDefinition
AIbehaviorFreeReservedWorkspotNodeDefinition = {}

---@return AIbehaviorFreeReservedWorkspotNodeDefinition
function AIbehaviorFreeReservedWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorFreeReservedWorkspotNodeDefinition
function AIbehaviorFreeReservedWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorGenerateSearchInfluenceTaskDefinition : AIbehaviorTaskDefinition
---@field position AIArgumentMapping
---@field path AIArgumentMapping
---@field radius AIArgumentMapping
AIbehaviorGenerateSearchInfluenceTaskDefinition = {}

---@return AIbehaviorGenerateSearchInfluenceTaskDefinition
function AIbehaviorGenerateSearchInfluenceTaskDefinition.new() return end

---@param props table
---@return AIbehaviorGenerateSearchInfluenceTaskDefinition
function AIbehaviorGenerateSearchInfluenceTaskDefinition.new(props) return end

---@class AIbehaviorGetEntryPointOnPathTaskDefinition : AIbehaviorTaskDefinition
---@field patrolProgress AIArgumentMapping
---@field positionOnPath AIArgumentMapping
---@field entryTangent AIArgumentMapping
AIbehaviorGetEntryPointOnPathTaskDefinition = {}

---@return AIbehaviorGetEntryPointOnPathTaskDefinition
function AIbehaviorGetEntryPointOnPathTaskDefinition.new() return end

---@param props table
---@return AIbehaviorGetEntryPointOnPathTaskDefinition
function AIbehaviorGetEntryPointOnPathTaskDefinition.new(props) return end

---@class AIbehaviorGetFollowTrailPointTaskDefinition : AIbehaviorTaskDefinition
---@field inTrailDelay AIArgumentMapping
---@field outFollowTrailPoint AIArgumentMapping
AIbehaviorGetFollowTrailPointTaskDefinition = {}

---@return AIbehaviorGetFollowTrailPointTaskDefinition
function AIbehaviorGetFollowTrailPointTaskDefinition.new() return end

---@param props table
---@return AIbehaviorGetFollowTrailPointTaskDefinition
function AIbehaviorGetFollowTrailPointTaskDefinition.new(props) return end

---@class AIbehaviorGetNextPointOnPathTaskDefinition : AIbehaviorTaskDefinition
---@field patrolProgress AIArgumentMapping
---@field positionOnPath AIArgumentMapping
---@field entryTangent AIArgumentMapping
AIbehaviorGetNextPointOnPathTaskDefinition = {}

---@return AIbehaviorGetNextPointOnPathTaskDefinition
function AIbehaviorGetNextPointOnPathTaskDefinition.new() return end

---@param props table
---@return AIbehaviorGetNextPointOnPathTaskDefinition
function AIbehaviorGetNextPointOnPathTaskDefinition.new(props) return end

---@class AIbehaviorGetPatrolPointTaskDefinition : AIbehaviorTaskDefinition
---@field inPatrolDistance AIArgumentMapping
---@field inLastKnownPosition AIArgumentMapping
---@field outFollowTrailPoint AIArgumentMapping
AIbehaviorGetPatrolPointTaskDefinition = {}

---@return AIbehaviorGetPatrolPointTaskDefinition
function AIbehaviorGetPatrolPointTaskDefinition.new() return end

---@param props table
---@return AIbehaviorGetPatrolPointTaskDefinition
function AIbehaviorGetPatrolPointTaskDefinition.new(props) return end

---@class AIbehaviorGetSearchPointTaskDefinition : AIbehaviorTaskDefinition
---@field inPlayerPositionDelay AIArgumentMapping
---@field inSearchPositionMaxRadius AIArgumentMapping
---@field inNearestNavmeshPolyExtent AIArgumentMapping
---@field inPavementsOnly AIArgumentMapping
---@field inLastKnownPosition AIArgumentMapping
---@field outSearchPosition AIArgumentMapping
AIbehaviorGetSearchPointTaskDefinition = {}

---@return AIbehaviorGetSearchPointTaskDefinition
function AIbehaviorGetSearchPointTaskDefinition.new() return end

---@param props table
---@return AIbehaviorGetSearchPointTaskDefinition
function AIbehaviorGetSearchPointTaskDefinition.new(props) return end

---@class AIbehaviorGetSelectedAgentDebuggerCommand : AIbehaviorIDebuggerCommand
AIbehaviorGetSelectedAgentDebuggerCommand = {}

---@return AIbehaviorGetSelectedAgentDebuggerCommand
function AIbehaviorGetSelectedAgentDebuggerCommand.new() return end

---@param props table
---@return AIbehaviorGetSelectedAgentDebuggerCommand
function AIbehaviorGetSelectedAgentDebuggerCommand.new(props) return end

---@class AIbehaviorHasDriverConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorHasDriverConditionDefinition = {}

---@return AIbehaviorHasDriverConditionDefinition
function AIbehaviorHasDriverConditionDefinition.new() return end

---@param props table
---@return AIbehaviorHasDriverConditionDefinition
function AIbehaviorHasDriverConditionDefinition.new(props) return end

---@class AIbehaviorHasPendingForcedBehaviorConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorHasPendingForcedBehaviorConditionDefinition = {}

---@return AIbehaviorHasPendingForcedBehaviorConditionDefinition
function AIbehaviorHasPendingForcedBehaviorConditionDefinition.new() return end

---@param props table
---@return AIbehaviorHasPendingForcedBehaviorConditionDefinition
function AIbehaviorHasPendingForcedBehaviorConditionDefinition.new(props) return end

---@class AIbehaviorHostilesDetectedConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorHostilesDetectedConditionDefinition = {}

---@return AIbehaviorHostilesDetectedConditionDefinition
function AIbehaviorHostilesDetectedConditionDefinition.new() return end

---@param props table
---@return AIbehaviorHostilesDetectedConditionDefinition
function AIbehaviorHostilesDetectedConditionDefinition.new(props) return end

---@class AIbehaviorIDebugger : ISerializable
AIbehaviorIDebugger = {}

---@class AIbehaviorIDebuggerCommand : ISerializable
AIbehaviorIDebuggerCommand = {}

---@class AIbehaviorIdleTreeNodeDefinition : AIbehaviorLeafTreeNodeDefinition
AIbehaviorIdleTreeNodeDefinition = {}

---@return AIbehaviorIdleTreeNodeDefinition
function AIbehaviorIdleTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorIdleTreeNodeDefinition
function AIbehaviorIdleTreeNodeDefinition.new(props) return end

---@class AIbehaviorIfElseNodeDefinition : AIbehaviorCompositeTreeNodeDefinition
---@field condition AIbehaviorExpressionSocket
AIbehaviorIfElseNodeDefinition = {}

---@return AIbehaviorIfElseNodeDefinition
function AIbehaviorIfElseNodeDefinition.new() return end

---@param props table
---@return AIbehaviorIfElseNodeDefinition
function AIbehaviorIfElseNodeDefinition.new(props) return end

---@class AIbehaviorIncludedTreeDefinition : AIbehaviorNestedTreeDefinition
---@field treeReference AIArgumentMapping
AIbehaviorIncludedTreeDefinition = {}

---@return AIbehaviorIncludedTreeDefinition
function AIbehaviorIncludedTreeDefinition.new() return end

---@param props table
---@return AIbehaviorIncludedTreeDefinition
function AIbehaviorIncludedTreeDefinition.new(props) return end

---@class AIbehaviorInfluenceExcludeObstaclePointTaskDefinition : AIbehaviorTaskDefinition
---@field workspotData AIArgumentMapping
---@field mountData AIArgumentMapping
AIbehaviorInfluenceExcludeObstaclePointTaskDefinition = {}

---@return AIbehaviorInfluenceExcludeObstaclePointTaskDefinition
function AIbehaviorInfluenceExcludeObstaclePointTaskDefinition.new() return end

---@param props table
---@return AIbehaviorInfluenceExcludeObstaclePointTaskDefinition
function AIbehaviorInfluenceExcludeObstaclePointTaskDefinition.new(props) return end

---@class AIbehaviorInstance
AIbehaviorInstance = {}

---@return AIbehaviorInstance
function AIbehaviorInstance.new() return end

---@param props table
---@return AIbehaviorInstance
function AIbehaviorInstance.new(props) return end

---@class AIbehaviorInstantConditionDefinition : ISerializable
---@field condition AIbehaviorConditionDefinition
AIbehaviorInstantConditionDefinition = {}

---@return AIbehaviorInstantConditionDefinition
function AIbehaviorInstantConditionDefinition.new() return end

---@param props table
---@return AIbehaviorInstantConditionDefinition
function AIbehaviorInstantConditionDefinition.new(props) return end

---@class AIbehaviorInstantConditionNodeDefinition : AIbehaviorConditionNodeDefinition
AIbehaviorInstantConditionNodeDefinition = {}

---@return AIbehaviorInstantConditionNodeDefinition
function AIbehaviorInstantConditionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorInstantConditionNodeDefinition
function AIbehaviorInstantConditionNodeDefinition.new(props) return end

---@class AIbehaviorInstantJoinTrafficConditionDefinition : AIbehaviorConditionDefinition
---@field joinTrafficSettings AIArgumentMapping
---@field closestPointOnPath AIArgumentMapping
---@field pathDirection AIArgumentMapping
---@field runOnTraffic AIArgumentMapping
AIbehaviorInstantJoinTrafficConditionDefinition = {}

---@return AIbehaviorInstantJoinTrafficConditionDefinition
function AIbehaviorInstantJoinTrafficConditionDefinition.new() return end

---@param props table
---@return AIbehaviorInstantJoinTrafficConditionDefinition
function AIbehaviorInstantJoinTrafficConditionDefinition.new(props) return end

---@class AIbehaviorInstantMountConditionDefinition : AIbehaviorConditionDefinition
---@field mountData AIArgumentMapping
AIbehaviorInstantMountConditionDefinition = {}

---@return AIbehaviorInstantMountConditionDefinition
function AIbehaviorInstantMountConditionDefinition.new() return end

---@param props table
---@return AIbehaviorInstantMountConditionDefinition
function AIbehaviorInstantMountConditionDefinition.new(props) return end

---@class AIbehaviorInstantRunAwayConditionDefinition : AIbehaviorConditionDefinition
---@field destination AIArgumentMapping
---@field runOnNavmesh AIArgumentMapping
AIbehaviorInstantRunAwayConditionDefinition = {}

---@return AIbehaviorInstantRunAwayConditionDefinition
function AIbehaviorInstantRunAwayConditionDefinition.new() return end

---@param props table
---@return AIbehaviorInstantRunAwayConditionDefinition
function AIbehaviorInstantRunAwayConditionDefinition.new(props) return end

---@class AIbehaviorInstantTaskNodeDefinition : AIbehaviorTaskNodeDefinition
AIbehaviorInstantTaskNodeDefinition = {}

---@return AIbehaviorInstantTaskNodeDefinition
function AIbehaviorInstantTaskNodeDefinition.new() return end

---@param props table
---@return AIbehaviorInstantTaskNodeDefinition
function AIbehaviorInstantTaskNodeDefinition.new(props) return end

---@class AIbehaviorIsAutopilotActiveVehicleExpressionDefinition : AIbehaviorVehicleExpressionDefinition
AIbehaviorIsAutopilotActiveVehicleExpressionDefinition = {}

---@return AIbehaviorIsAutopilotActiveVehicleExpressionDefinition
function AIbehaviorIsAutopilotActiveVehicleExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorIsAutopilotActiveVehicleExpressionDefinition
function AIbehaviorIsAutopilotActiveVehicleExpressionDefinition.new(props) return end

---@class AIbehaviorIsBeingSummonedDefinition : AIbehaviorVehicleExpressionDefinition
AIbehaviorIsBeingSummonedDefinition = {}

---@return AIbehaviorIsBeingSummonedDefinition
function AIbehaviorIsBeingSummonedDefinition.new() return end

---@param props table
---@return AIbehaviorIsBeingSummonedDefinition
function AIbehaviorIsBeingSummonedDefinition.new(props) return end

---@class AIbehaviorIsBlockedByCompanionConditionDefinition : AIbehaviorCompanionConditionDefinition
---@field distance AIArgumentMapping
AIbehaviorIsBlockedByCompanionConditionDefinition = {}

---@return AIbehaviorIsBlockedByCompanionConditionDefinition
function AIbehaviorIsBlockedByCompanionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorIsBlockedByCompanionConditionDefinition
function AIbehaviorIsBlockedByCompanionConditionDefinition.new(props) return end

---@class AIbehaviorIsInDesiredRangeConditionDefinition : AIbehaviorCompanionConditionDefinition
---@field desiredDistance AIArgumentMapping
---@field deadZoneRadius AIArgumentMapping
AIbehaviorIsInDesiredRangeConditionDefinition = {}

---@return AIbehaviorIsInDesiredRangeConditionDefinition
function AIbehaviorIsInDesiredRangeConditionDefinition.new() return end

---@param props table
---@return AIbehaviorIsInDesiredRangeConditionDefinition
function AIbehaviorIsInDesiredRangeConditionDefinition.new(props) return end

---@class AIbehaviorIsNodeStreamedConditionDefinition : AIbehaviorConditionDefinition
---@field nodeRef AIArgumentMapping
AIbehaviorIsNodeStreamedConditionDefinition = {}

---@return AIbehaviorIsNodeStreamedConditionDefinition
function AIbehaviorIsNodeStreamedConditionDefinition.new() return end

---@param props table
---@return AIbehaviorIsNodeStreamedConditionDefinition
function AIbehaviorIsNodeStreamedConditionDefinition.new(props) return end

---@class AIbehaviorIsStunnedVehicleDefinition : AIbehaviorVehicleExpressionDefinition
AIbehaviorIsStunnedVehicleDefinition = {}

---@return AIbehaviorIsStunnedVehicleDefinition
function AIbehaviorIsStunnedVehicleDefinition.new() return end

---@param props table
---@return AIbehaviorIsStunnedVehicleDefinition
function AIbehaviorIsStunnedVehicleDefinition.new(props) return end

---@class AIbehaviorIsThreatOnPathConditionDefinition : AIbehaviorConditionDefinition
---@field threatObject AIArgumentMapping
---@field threatRadius AIArgumentMapping
AIbehaviorIsThreatOnPathConditionDefinition = {}

---@return AIbehaviorIsThreatOnPathConditionDefinition
function AIbehaviorIsThreatOnPathConditionDefinition.new() return end

---@param props table
---@return AIbehaviorIsThreatOnPathConditionDefinition
function AIbehaviorIsThreatOnPathConditionDefinition.new(props) return end

---@class AIbehaviorIsValueValidConditionDefinition : AIbehaviorConditionDefinition
---@field value AIArgumentMapping
AIbehaviorIsValueValidConditionDefinition = {}

---@return AIbehaviorIsValueValidConditionDefinition
function AIbehaviorIsValueValidConditionDefinition.new() return end

---@param props table
---@return AIbehaviorIsValueValidConditionDefinition
function AIbehaviorIsValueValidConditionDefinition.new(props) return end

---@class AIbehaviorJoinFollowerSquadWithTargetDefinition : AIbehaviorTaskDefinition
---@field follower AIArgumentMapping
AIbehaviorJoinFollowerSquadWithTargetDefinition = {}

---@return AIbehaviorJoinFollowerSquadWithTargetDefinition
function AIbehaviorJoinFollowerSquadWithTargetDefinition.new() return end

---@param props table
---@return AIbehaviorJoinFollowerSquadWithTargetDefinition
function AIbehaviorJoinFollowerSquadWithTargetDefinition.new(props) return end

---@class AIbehaviorLeafTreeNodeDefinition : AIbehaviorTreeNodeDefinition
AIbehaviorLeafTreeNodeDefinition = {}

---@class AIbehaviorLeaveCoverImmediatelyNodeDefinition : AIbehaviorDecoratorNodeDefinition
AIbehaviorLeaveCoverImmediatelyNodeDefinition = {}

---@return AIbehaviorLeaveCoverImmediatelyNodeDefinition
function AIbehaviorLeaveCoverImmediatelyNodeDefinition.new() return end

---@param props table
---@return AIbehaviorLeaveCoverImmediatelyNodeDefinition
function AIbehaviorLeaveCoverImmediatelyNodeDefinition.new(props) return end

---@class AIbehaviorLimiterNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field activationLimitPerFrame Uint32
---@field delayChildActivation Bool
---@field delayChildActivationIfAttaching Bool
AIbehaviorLimiterNodeDefinition = {}

---@return AIbehaviorLimiterNodeDefinition
function AIbehaviorLimiterNodeDefinition.new() return end

---@param props table
---@return AIbehaviorLimiterNodeDefinition
function AIbehaviorLimiterNodeDefinition.new(props) return end

---@class AIbehaviorLineOfSightClearConditionDefinition : AIbehaviorConditionDefinition
---@field collisionFilters CName[]
---@field offset Vector3
---@field target AIArgumentMapping
AIbehaviorLineOfSightClearConditionDefinition = {}

---@return AIbehaviorLineOfSightClearConditionDefinition
function AIbehaviorLineOfSightClearConditionDefinition.new() return end

---@param props table
---@return AIbehaviorLineOfSightClearConditionDefinition
function AIbehaviorLineOfSightClearConditionDefinition.new(props) return end

---@class AIbehaviorMappingConditionDefinition : AIbehaviorConditionDefinition
---@field value AIArgumentMapping
AIbehaviorMappingConditionDefinition = {}

---@return AIbehaviorMappingConditionDefinition
function AIbehaviorMappingConditionDefinition.new() return end

---@param props table
---@return AIbehaviorMappingConditionDefinition
function AIbehaviorMappingConditionDefinition.new(props) return end

---@class AIbehaviorMappingExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field mapping AIArgumentMapping
---@field update Bool
---@field updatePeriod Float
---@field behaviorCallbackNames CName[]
AIbehaviorMappingExpressionDefinition = {}

---@return AIbehaviorMappingExpressionDefinition
function AIbehaviorMappingExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorMappingExpressionDefinition
function AIbehaviorMappingExpressionDefinition.new(props) return end

---@class AIbehaviorMaybeNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field onChildSuccess AIbehaviorMaybeNodeAction
---@field onChildFailure AIbehaviorMaybeNodeAction
AIbehaviorMaybeNodeDefinition = {}

---@return AIbehaviorMaybeNodeDefinition
function AIbehaviorMaybeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorMaybeNodeDefinition
function AIbehaviorMaybeNodeDefinition.new(props) return end

---@class AIbehaviorMonitorConditionDefinition : ISerializable
---@field condition AIbehaviorConditionDefinition
---@field timeout Float
AIbehaviorMonitorConditionDefinition = {}

---@return AIbehaviorMonitorConditionDefinition
function AIbehaviorMonitorConditionDefinition.new() return end

---@param props table
---@return AIbehaviorMonitorConditionDefinition
function AIbehaviorMonitorConditionDefinition.new(props) return end

---@class AIbehaviorMonitorConditionNodeDefinition : AIbehaviorConditionNodeDefinition
---@field timeout Float
AIbehaviorMonitorConditionNodeDefinition = {}

---@return AIbehaviorMonitorConditionNodeDefinition
function AIbehaviorMonitorConditionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorMonitorConditionNodeDefinition
function AIbehaviorMonitorConditionNodeDefinition.new(props) return end

---@class AIbehaviorMonitorTaskNodeDefinition : AIbehaviorTaskNodeDefinition
---@field timeout Float
AIbehaviorMonitorTaskNodeDefinition = {}

---@return AIbehaviorMonitorTaskNodeDefinition
function AIbehaviorMonitorTaskNodeDefinition.new() return end

---@param props table
---@return AIbehaviorMonitorTaskNodeDefinition
function AIbehaviorMonitorTaskNodeDefinition.new(props) return end

---@class AIbehaviorMountEventResolverDefinition : AIbehaviorEventResolverDefinition
---@field mountData AIArgumentMapping
---@field workspotData AIArgumentMapping
---@field isInstant AIArgumentMapping
---@field behaviorCallbackName CName
AIbehaviorMountEventResolverDefinition = {}

---@return AIbehaviorMountEventResolverDefinition
function AIbehaviorMountEventResolverDefinition.new() return end

---@param props table
---@return AIbehaviorMountEventResolverDefinition
function AIbehaviorMountEventResolverDefinition.new(props) return end

---@class AIbehaviorMountRequestConditionDefinition : AIbehaviorConditionDefinition
---@field testMountRequest Bool
---@field testUnmountRequest Bool
---@field acceptInstant Bool
---@field acceptNotInstant Bool
AIbehaviorMountRequestConditionDefinition = {}

---@return AIbehaviorMountRequestConditionDefinition
function AIbehaviorMountRequestConditionDefinition.new() return end

---@param props table
---@return AIbehaviorMountRequestConditionDefinition
function AIbehaviorMountRequestConditionDefinition.new(props) return end

---@class AIbehaviorMountToEntTaskDefinition : AIbehaviorTaskDefinition
---@field mountData AIArgumentMapping
AIbehaviorMountToEntTaskDefinition = {}

---@return AIbehaviorMountToEntTaskDefinition
function AIbehaviorMountToEntTaskDefinition.new() return end

---@param props table
---@return AIbehaviorMountToEntTaskDefinition
function AIbehaviorMountToEntTaskDefinition.new(props) return end

---@class AIbehaviorMoveAlongTrafficPathActionNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field joinTrafficSettings AIArgumentMapping
---@field ignoreTrafficSpots AIArgumentMapping
---@field useCrowdAnimationGraph AIArgumentMapping
---@field workspotData AIArgumentMapping
---@field workspotExitPositionWS AIArgumentMapping
---@field workspotReturnPositionVector AIArgumentMapping
---@field workspotExitTangent AIArgumentMapping
---@field trafficLaneReturnTangent AIArgumentMapping
---@field trafficLaneExitTangent AIArgumentMapping
AIbehaviorMoveAlongTrafficPathActionNodeDefinition = {}

---@return AIbehaviorMoveAlongTrafficPathActionNodeDefinition
function AIbehaviorMoveAlongTrafficPathActionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorMoveAlongTrafficPathActionNodeDefinition
function AIbehaviorMoveAlongTrafficPathActionNodeDefinition.new(props) return end

---@class AIbehaviorMovementPolicyTaskDefinition : AIbehaviorTaskDefinition
---@field useCurrentPolicy Bool
---@field waitForPolicy Bool
---@field stopWhenDestinationReached AIArgumentMapping
---@field policies AIbehaviorMovementPolicyTaskItemDefinition[]
AIbehaviorMovementPolicyTaskDefinition = {}

---@return AIbehaviorMovementPolicyTaskDefinition
function AIbehaviorMovementPolicyTaskDefinition.new() return end

---@param props table
---@return AIbehaviorMovementPolicyTaskDefinition
function AIbehaviorMovementPolicyTaskDefinition.new(props) return end

---@class AIbehaviorMovementPolicyTaskItemDefinition : ISerializable
---@field function AIbehaviorMovementPolicyTaskFunctions
---@field params AIbehaviorExpressionSocket[]
AIbehaviorMovementPolicyTaskItemDefinition = {}

---@return AIbehaviorMovementPolicyTaskItemDefinition
function AIbehaviorMovementPolicyTaskItemDefinition.new() return end

---@param props table
---@return AIbehaviorMovementPolicyTaskItemDefinition
function AIbehaviorMovementPolicyTaskItemDefinition.new(props) return end

---@class AIbehaviorNaryOperatorExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field operator AIbehaviorNaryExpressionOperators
---@field operands AIbehaviorExpressionSocket[]
AIbehaviorNaryOperatorExpressionDefinition = {}

---@return AIbehaviorNaryOperatorExpressionDefinition
function AIbehaviorNaryOperatorExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorNaryOperatorExpressionDefinition
function AIbehaviorNaryOperatorExpressionDefinition.new(props) return end

---@class AIbehaviorNestedTreeDefinition : AIbehaviorTreeNodeDefinition
---@field lateInitialization Bool
---@field initializeOnEvent CName[]
AIbehaviorNestedTreeDefinition = {}

---@class AIbehaviorNodeRefConverterTaskDefinition : AIbehaviorTaskDefinition
---@field nodeRef AIArgumentMapping
---@field result AIArgumentMapping
AIbehaviorNodeRefConverterTaskDefinition = {}

---@class AIbehaviorNodeRefToInstanceTaskDefinition : AIbehaviorNodeRefConverterTaskDefinition
AIbehaviorNodeRefToInstanceTaskDefinition = {}

---@return AIbehaviorNodeRefToInstanceTaskDefinition
function AIbehaviorNodeRefToInstanceTaskDefinition.new() return end

---@param props table
---@return AIbehaviorNodeRefToInstanceTaskDefinition
function AIbehaviorNodeRefToInstanceTaskDefinition.new(props) return end

---@class AIbehaviorNodeRefToObjectTaskDefinition : AIbehaviorNodeRefConverterTaskDefinition
AIbehaviorNodeRefToObjectTaskDefinition = {}

---@return AIbehaviorNodeRefToObjectTaskDefinition
function AIbehaviorNodeRefToObjectTaskDefinition.new() return end

---@param props table
---@return AIbehaviorNodeRefToObjectTaskDefinition
function AIbehaviorNodeRefToObjectTaskDefinition.new(props) return end

---@class AIbehaviorNodeStatusDebuggerCommand : AIbehaviorIDebuggerCommand
---@field behaviorResourceHash Uint32
---@field generation Uint32
---@field entries AIbehaviorNodeStatusDebuggerCommandEntry[]
AIbehaviorNodeStatusDebuggerCommand = {}

---@return AIbehaviorNodeStatusDebuggerCommand
function AIbehaviorNodeStatusDebuggerCommand.new() return end

---@param props table
---@return AIbehaviorNodeStatusDebuggerCommand
function AIbehaviorNodeStatusDebuggerCommand.new(props) return end

---@class AIbehaviorNodeStatusDebuggerCommandEntry
---@field nodeId CGUID
---@field status AIbehaviorDebugNodeStatus
---@field generation Uint32
---@field failure gamedebugFailure
AIbehaviorNodeStatusDebuggerCommandEntry = {}

---@return AIbehaviorNodeStatusDebuggerCommandEntry
function AIbehaviorNodeStatusDebuggerCommandEntry.new() return end

---@param props table
---@return AIbehaviorNodeStatusDebuggerCommandEntry
function AIbehaviorNodeStatusDebuggerCommandEntry.new(props) return end

---@class AIbehaviorOrConditionDefinition : AIbehaviorCompositeConditionDefinition
AIbehaviorOrConditionDefinition = {}

---@return AIbehaviorOrConditionDefinition
function AIbehaviorOrConditionDefinition.new() return end

---@param props table
---@return AIbehaviorOrConditionDefinition
function AIbehaviorOrConditionDefinition.new(props) return end

---@class AIbehaviorParallelNodeDefinition : AIbehaviorCompositeTreeNodeDefinition
---@field waitFor AIbehaviorParallelNodeWaitFor
AIbehaviorParallelNodeDefinition = {}

---@return AIbehaviorParallelNodeDefinition
function AIbehaviorParallelNodeDefinition.new() return end

---@param props table
---@return AIbehaviorParallelNodeDefinition
function AIbehaviorParallelNodeDefinition.new(props) return end

---@class AIbehaviorParameterizedBehavior : ISerializable
---@field treeDefinition AIbehaviorResource
---@field argumentsOverrides AIArgumentOverrideWrapper[]
AIbehaviorParameterizedBehavior = {}

---@return AIbehaviorParameterizedBehavior
function AIbehaviorParameterizedBehavior.new() return end

---@param props table
---@return AIbehaviorParameterizedBehavior
function AIbehaviorParameterizedBehavior.new(props) return end

---@class AIbehaviorPassiveConditionDefinition : ISerializable
---@field invert Bool
AIbehaviorPassiveConditionDefinition = {}

---@class AIbehaviorPassiveConditionNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field condition AIbehaviorPassiveConditionDefinition
---@field resultIfFailed AIbehaviorCompletionStatus
AIbehaviorPassiveConditionNodeDefinition = {}

---@return AIbehaviorPassiveConditionNodeDefinition
function AIbehaviorPassiveConditionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorPassiveConditionNodeDefinition
function AIbehaviorPassiveConditionNodeDefinition.new(props) return end

---@class AIbehaviorPassiveEventTagConditionDefinition : AIbehaviorPassiveConditionDefinition
---@field tag CName
---@field deactivateEvents Bool
AIbehaviorPassiveEventTagConditionDefinition = {}

---@return AIbehaviorPassiveEventTagConditionDefinition
function AIbehaviorPassiveEventTagConditionDefinition.new() return end

---@param props table
---@return AIbehaviorPassiveEventTagConditionDefinition
function AIbehaviorPassiveEventTagConditionDefinition.new(props) return end

---@class AIbehaviorPassiveExpressionDefinition : IScriptable
AIbehaviorPassiveExpressionDefinition = {}

---@class AIbehaviorPassiveSignalConditionDefinition : AIbehaviorPassiveConditionDefinition
---@field tag CName
---@field deactivateSignal Bool
AIbehaviorPassiveSignalConditionDefinition = {}

---@return AIbehaviorPassiveSignalConditionDefinition
function AIbehaviorPassiveSignalConditionDefinition.new() return end

---@param props table
---@return AIbehaviorPassiveSignalConditionDefinition
function AIbehaviorPassiveSignalConditionDefinition.new(props) return end

---@class AIbehaviorPatrolActionNodeDefinition : AIbehaviorActionTreeNodeDefinition
---@field path AIArgumentMapping
---@field patrolProgress AIArgumentMapping
---@field startFromClosestPoint AIArgumentMapping
---@field patrolContinuationPolicy AIArgumentMapping
---@field playStartAnimation AIArgumentMapping
---@field fastForwardAfterTeleport AIArgumentMapping
---@field workspotData AIArgumentMapping
---@field dependentWorkspotData AIArgumentMapping
---@field lookAtTarget AIArgumentMapping
---@field usePathContext AIArgumentMapping
---@field useOffMeshLinkReservation AIArgumentMapping
AIbehaviorPatrolActionNodeDefinition = {}

---@return AIbehaviorPatrolActionNodeDefinition
function AIbehaviorPatrolActionNodeDefinition.new() return end

---@param props table
---@return AIbehaviorPatrolActionNodeDefinition
function AIbehaviorPatrolActionNodeDefinition.new(props) return end

---@class AIbehaviorPickSearchDestinationTaskDefinition : AIbehaviorTaskDefinition
---@field destinationPosition AIArgumentMapping
---@field desiredDistance AIArgumentMapping
---@field maxDistance AIArgumentMapping
---@field clearedAreaRadius AIArgumentMapping
---@field clearedAreaDistance AIArgumentMapping
---@field clearedAreaAngle AIArgumentMapping
---@field ignoreRestrictMovementArea AIArgumentMapping
AIbehaviorPickSearchDestinationTaskDefinition = {}

---@return AIbehaviorPickSearchDestinationTaskDefinition
function AIbehaviorPickSearchDestinationTaskDefinition.new() return end

---@param props table
---@return AIbehaviorPickSearchDestinationTaskDefinition
function AIbehaviorPickSearchDestinationTaskDefinition.new(props) return end

---@class AIbehaviorPredictTargetMovementDefinition : AIbehaviorTaskDefinition
---@field target AIArgumentMapping
---@field timeInterval AIArgumentMapping
---@field result AIArgumentMapping
AIbehaviorPredictTargetMovementDefinition = {}

---@return AIbehaviorPredictTargetMovementDefinition
function AIbehaviorPredictTargetMovementDefinition.new() return end

---@param props table
---@return AIbehaviorPredictTargetMovementDefinition
function AIbehaviorPredictTargetMovementDefinition.new(props) return end

---@class AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field workspotData AIArgumentMapping
---@field returnPosition AIArgumentMapping
---@field returnPositionVector AIArgumentMapping
---@field workspotExitTangent AIArgumentMapping
---@field joinTrafficSettings AIArgumentMapping
---@field overrideExit AIArgumentMapping
AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition = {}

---@return AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition
function AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition
function AIbehaviorPrepareReservedCrowdWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorPuppetRefToGameObjectTaskDefinition : AIbehaviorTaskDefinition
---@field puppetRef AIArgumentMapping
---@field result AIArgumentMapping
AIbehaviorPuppetRefToGameObjectTaskDefinition = {}

---@return AIbehaviorPuppetRefToGameObjectTaskDefinition
function AIbehaviorPuppetRefToGameObjectTaskDefinition.new() return end

---@param props table
---@return AIbehaviorPuppetRefToGameObjectTaskDefinition
function AIbehaviorPuppetRefToGameObjectTaskDefinition.new(props) return end

---@class AIbehaviorRandomConditionDefinition : AIbehaviorConditionDefinition
---@field chance Float
AIbehaviorRandomConditionDefinition = {}

---@return AIbehaviorRandomConditionDefinition
function AIbehaviorRandomConditionDefinition.new() return end

---@param props table
---@return AIbehaviorRandomConditionDefinition
function AIbehaviorRandomConditionDefinition.new(props) return end

---@class AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition : AIbehaviorTaskDefinition
---@field mountData AIArgumentMapping
---@field workspotData AIArgumentMapping
AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition = {}

---@return AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition
function AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition.new() return end

---@param props table
---@return AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition
function AIbehaviorRecalculateVehicleWorkspotPositionTaskDefinition.new(props) return end

---@class AIbehaviorReevaluateOnEventNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field eventName CName
AIbehaviorReevaluateOnEventNodeDefinition = {}

---@return AIbehaviorReevaluateOnEventNodeDefinition
function AIbehaviorReevaluateOnEventNodeDefinition.new() return end

---@param props table
---@return AIbehaviorReevaluateOnEventNodeDefinition
function AIbehaviorReevaluateOnEventNodeDefinition.new(props) return end

---@class AIbehaviorRepeatNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field limit AIArgumentMapping
---@field repeatChildOnFailure Bool
AIbehaviorRepeatNodeDefinition = {}

---@return AIbehaviorRepeatNodeDefinition
function AIbehaviorRepeatNodeDefinition.new() return end

---@param props table
---@return AIbehaviorRepeatNodeDefinition
function AIbehaviorRepeatNodeDefinition.new(props) return end

---@class AIbehaviorResource : CResource
---@field root AIbehaviorTreeNodeDefinition
---@field arguments AITreeArgumentsDefinition
---@field delegate AIbehaviorBehaviorDelegate
---@field initializationEvents CName[]
AIbehaviorResource = {}

---@return AIbehaviorResource
function AIbehaviorResource.new() return end

---@param props table
---@return AIbehaviorResource
function AIbehaviorResource.new(props) return end

---@class AIbehaviorSaveEventResolverDefinition : AIbehaviorEventResolverDefinition
---@field eventData AIArgumentMapping
AIbehaviorSaveEventResolverDefinition = {}

---@return AIbehaviorSaveEventResolverDefinition
function AIbehaviorSaveEventResolverDefinition.new() return end

---@param props table
---@return AIbehaviorSaveEventResolverDefinition
function AIbehaviorSaveEventResolverDefinition.new(props) return end

---@class AIbehaviorScriptBase : IScriptable
AIbehaviorScriptBase = {}

---@return AIbehaviorScriptBase
function AIbehaviorScriptBase.new() return end

---@param props table
---@return AIbehaviorScriptBase
function AIbehaviorScriptBase.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIHumanComponent
function AIbehaviorScriptBase.GetAIComponent(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return gameObject
function AIbehaviorScriptBase.GetCombatTarget(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return gameObject
function AIbehaviorScriptBase.GetCompanion(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return ScriptGameInstance
function AIbehaviorScriptBase.GetGame(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return HitReactionComponent
function AIbehaviorScriptBase.GetHitReactionComponent(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return NPCPuppet
function AIbehaviorScriptBase.GetNPCPuppet(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return ScriptedPuppet
function AIbehaviorScriptBase.GetPuppet(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param statPoolType gamedataStatPoolType
---@return Float
function AIbehaviorScriptBase.GetStatPoolPercentage(context, statPoolType) return end

---@param context AIbehaviorScriptExecutionContext
---@param statPoolType gamedataStatPoolType
---@return Float
function AIbehaviorScriptBase.GetStatPoolValue(context, statPoolType) return end

---@param context AIbehaviorScriptExecutionContext
---@return gamedataNPCUpperBodyState
function AIbehaviorScriptBase.GetUpperBodyState(context) return end

---@param interval Float
---@return Float
function AIbehaviorScriptBase.RandomizeOffsetForUpdateInterval(interval) return end

---@param context AIbehaviorScriptExecutionContext
---@return String
function AIbehaviorScriptBase:GetDescription(context) return end

---@class AIbehaviorScriptBehaviorDelegate : AIbehaviorBehaviorDelegate
AIbehaviorScriptBehaviorDelegate = {}

---@return AIbehaviorScriptBehaviorDelegate
function AIbehaviorScriptBehaviorDelegate.new() return end

---@param props table
---@return AIbehaviorScriptBehaviorDelegate
function AIbehaviorScriptBehaviorDelegate.new(props) return end

---@class AIbehaviorScriptConditionDefinition : AIbehaviorConditionDefinition
---@field script AIbehaviorconditionScript
---@field disableLazyInitialization Bool
AIbehaviorScriptConditionDefinition = {}

---@return AIbehaviorScriptConditionDefinition
function AIbehaviorScriptConditionDefinition.new() return end

---@param props table
---@return AIbehaviorScriptConditionDefinition
function AIbehaviorScriptConditionDefinition.new(props) return end

---@class AIbehaviorScriptEventResolverDefinition : AIbehaviorEventResolverDefinition
---@field script AIbehavioreventResolverScript
AIbehaviorScriptEventResolverDefinition = {}

---@return AIbehaviorScriptEventResolverDefinition
function AIbehaviorScriptEventResolverDefinition.new() return end

---@param props table
---@return AIbehaviorScriptEventResolverDefinition
function AIbehaviorScriptEventResolverDefinition.new(props) return end

---@class AIbehaviorScriptExecutionContext
AIbehaviorScriptExecutionContext = {}

---@return AIbehaviorScriptExecutionContext
function AIbehaviorScriptExecutionContext.new() return end

---@param props table
---@return AIbehaviorScriptExecutionContext
function AIbehaviorScriptExecutionContext.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param cbName CName|string
---@param callback IScriptable
---@return Uint32
function AIbehaviorScriptExecutionContext.AddBehaviorCallback(context, cbName, callback) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionStringName String
---@param actionPackageType AIactionParamsPackageTypes
---@return TweakDBID
function AIbehaviorScriptExecutionContext.CreateActionID(context, actionStringName, actionPackageType) return end

---@param context AIbehaviorScriptExecutionContext
---@param actionStringName String
---@param paramName String
---@return TweakDBID
function AIbehaviorScriptExecutionContext.CreateActionParamID(context, actionStringName, paramName) return end

---@param context AIbehaviorScriptExecutionContext
---@param category CName|string
---@param message String
function AIbehaviorScriptExecutionContext.DebugLog(context, category, message) return end

---@param context AIbehaviorScriptExecutionContext
---@return EngineTime
function AIbehaviorScriptExecutionContext.GetAITime(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return EngineTime
function AIbehaviorScriptExecutionContext.GetAITimeLastFrame(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return Bool
function AIbehaviorScriptExecutionContext.GetArgumentBool(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return Float
function AIbehaviorScriptExecutionContext.GetArgumentFloat(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return worldGlobalNodeID
function AIbehaviorScriptExecutionContext.GetArgumentGlobalNodeId(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return Int32
function AIbehaviorScriptExecutionContext.GetArgumentInt(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return CName
function AIbehaviorScriptExecutionContext.GetArgumentName(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return NodeRef
function AIbehaviorScriptExecutionContext.GetArgumentNodeRef(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return gameObject
function AIbehaviorScriptExecutionContext.GetArgumentObject(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return IScriptable
function AIbehaviorScriptExecutionContext.GetArgumentScriptable(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return Uint64
function AIbehaviorScriptExecutionContext.GetArgumentUint64(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@return Vector4
function AIbehaviorScriptExecutionContext.GetArgumentVector(context, entry) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorBehaviorDelegate
function AIbehaviorScriptExecutionContext.GetClosestDelegate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorBehaviorDelegate
function AIbehaviorScriptExecutionContext.GetDelegate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return Int32
function AIbehaviorScriptExecutionContext.GetLOD(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param mapping AIArgumentMapping
---@return Variant
function AIbehaviorScriptExecutionContext.GetMappingValue(context, mapping) return end

---@param context AIbehaviorScriptExecutionContext
---@param nodeId TweakDBID|string
---@param lookupDefault Bool
---@return Bool, gamedataAIRecord_Record
function AIbehaviorScriptExecutionContext.GetOverriddenNode(context, nodeId, lookupDefault) return end

---@param context AIbehaviorScriptExecutionContext
---@return gamePuppet
function AIbehaviorScriptExecutionContext.GetOwner(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param mapping AIArgumentMapping
---@return IScriptable
function AIbehaviorScriptExecutionContext.GetScriptableMappingValue(context, mapping) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviortweakTweakActionSystem
function AIbehaviorScriptExecutionContext.GetTweakActionSystem(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param mapping AIArgumentMapping
---@return TweakDBID
function AIbehaviorScriptExecutionContext.GetTweakDBIDMappingValue(context, mapping) return end

---@param context AIbehaviorScriptExecutionContext
---@param cbName CName|string
function AIbehaviorScriptExecutionContext.InvokeBehaviorCallback(context, cbName) return end

function AIbehaviorScriptExecutionContext.IsTraceFlagSet() return end

---@param context AIbehaviorScriptExecutionContext
---@param puppetRef gameEntityReference
---@return gameObject
function AIbehaviorScriptExecutionContext.PuppetRefToObject(context, puppetRef) return end

---@param context AIbehaviorScriptExecutionContext
---@param id Uint32
---@return Bool
function AIbehaviorScriptExecutionContext.RemoveBehaviorCallback(context, id) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value Bool
function AIbehaviorScriptExecutionContext.SetArgumentBool(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value Float
function AIbehaviorScriptExecutionContext.SetArgumentFloat(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value worldGlobalNodeID
function AIbehaviorScriptExecutionContext.SetArgumentGlobalNodeId(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value Int32
function AIbehaviorScriptExecutionContext.SetArgumentInt(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value CName|string
function AIbehaviorScriptExecutionContext.SetArgumentName(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value NodeRef
function AIbehaviorScriptExecutionContext.SetArgumentNodeRef(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value gameObject
function AIbehaviorScriptExecutionContext.SetArgumentObject(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value IScriptable
function AIbehaviorScriptExecutionContext.SetArgumentScriptable(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value Uint64
function AIbehaviorScriptExecutionContext.SetArgumentUint64(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param entry CName|string
---@param value Vector4
function AIbehaviorScriptExecutionContext.SetArgumentVector(context, entry, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param mapping AIArgumentMapping
---@param value Int64
---@return Bool
function AIbehaviorScriptExecutionContext.SetEnumMappingValue(context, mapping, value) return end

---@param context AIbehaviorScriptExecutionContext
---@param mapping AIArgumentMapping
---@param value Variant
---@return Bool
function AIbehaviorScriptExecutionContext.SetMappingValue(context, mapping, value) return end

---@class AIbehaviorScriptPassiveExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field script AIbehaviorexpressionScript
AIbehaviorScriptPassiveExpressionDefinition = {}

---@return AIbehaviorScriptPassiveExpressionDefinition
function AIbehaviorScriptPassiveExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorScriptPassiveExpressionDefinition
function AIbehaviorScriptPassiveExpressionDefinition.new(props) return end

---@class AIbehaviorScriptTaskDefinition : AIbehaviorTaskDefinition
---@field script AIbehaviortaskScript
---@field disableLazyInitialization Bool
AIbehaviorScriptTaskDefinition = {}

---@return AIbehaviorScriptTaskDefinition
function AIbehaviorScriptTaskDefinition.new() return end

---@param props table
---@return AIbehaviorScriptTaskDefinition
function AIbehaviorScriptTaskDefinition.new(props) return end

---@class AIbehaviorScriptUtils
AIbehaviorScriptUtils = {}

---@return AIbehaviorScriptUtils
function AIbehaviorScriptUtils.new() return end

---@param props table
---@return AIbehaviorScriptUtils
function AIbehaviorScriptUtils.new(props) return end

---@param a Vector4
---@param b Vector4
---@return Bool
function AIbehaviorScriptUtils.ArePositionsEqual(a, b) return end

---@param splineRef NodeRef
---@param refPoint Vector4
---@return Bool, Float
function AIbehaviorScriptUtils.CalculateDistanceToEndFrom(splineRef, refPoint) return end

---@param context AIbehaviorScriptExecutionContext
---@param subAction gamedataAISubAction_Record
function AIbehaviorScriptUtils.CallActivateSubAction(context, subAction) return end

---@param context AIbehaviorScriptExecutionContext
---@param check gamedataAIActionSubCondition_Record
---@return Bool
function AIbehaviorScriptUtils.CallCheckSubCondition(context, check) return end

---@param context AIbehaviorScriptExecutionContext
---@param subAction gamedataAISubAction_Record
---@param duration Float
---@param interrupted Bool
function AIbehaviorScriptUtils.CallDeactivateSubAction(context, subAction, duration, interrupted) return end

---@param context AIbehaviorScriptExecutionContext
---@param subActionRecord gamedataAISubAction_Record
---@return Int32
function AIbehaviorScriptUtils.CallGetAnimVariation(context, subActionRecord) return end

---@param context AIbehaviorScriptExecutionContext
---@param subActionRecord gamedataAISubAction_Record
---@param actionPhase Int32
---@param baseDuration Float
---@return Float
function AIbehaviorScriptUtils.CallGetPhaseDuration(context, subActionRecord, actionPhase, baseDuration) return end

---@param context AIbehaviorScriptExecutionContext
---@param subAction gamedataAISubAction_Record
---@param duration Float
---@return AIbehaviorUpdateOutcome
function AIbehaviorScriptUtils.CallUpdateSubAction(context, subAction, duration) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param condition gamedataAIActionCondition_Record
---@return Bool
function AIbehaviorScriptUtils.CheckActionCondition(ctx, condition) return end

---@param context AIbehaviorScriptExecutionContext
---@param check gamedataAIAction_Record
---@return Bool
function AIbehaviorScriptUtils.CheckActionCooldowns(context, check) return end

---@param context AIbehaviorScriptExecutionContext
---@param animFeatureName CName|string
---@param animVariation Int32
---@param animState Int32
---@param triggerPreload Bool
---@return Bool
function AIbehaviorScriptUtils.CheckAnimation(context, animFeatureName, animVariation, animState, triggerPreload) return end

---@param context AIbehaviorScriptExecutionContext
---@param check gamedataAICooldownCond_Record
---@return Bool
function AIbehaviorScriptUtils.CheckCooldownConditions(context, check) return end

---@param entityId entEntityID
---@param category CName|string
---@param message String
function AIbehaviorScriptUtils.DebugLog(entityId, category, message) return end

---@param recordId TweakDBID|string
---@return Bool, TweakDBID
function AIbehaviorScriptUtils.GetActionNameFromRecord(recordId) return end

---@param context AIbehaviorScriptExecutionContext
---@param target gamedataAIActionTarget_Record
---@return Bool, gameObject
function AIbehaviorScriptUtils.GetActionTarget(context, target) return end

---@param context AIbehaviorScriptExecutionContext
---@param targetId TweakDBID|string
---@param predictionTime Float
---@return Bool, gameObject, Vector4, Uint64
function AIbehaviorScriptUtils.GetActionTarget2(context, targetId, predictionTime) return end

---@param splineRef NodeRef
---@param refPoint Vector4
---@return Bool, Vector4
function AIbehaviorScriptUtils.GetClosestPointOnSpline(splineRef, refPoint) return end

---@param splineRef NodeRef
---@return Bool, Vector4
function AIbehaviorScriptUtils.GetEndPointOfSpline(splineRef) return end

---@param splineRef NodeRef
---@return Bool, Vector4
function AIbehaviorScriptUtils.GetStartPointOfSpline(splineRef) return end

---@param ticketName CName|string
---@param puppet gamePuppet
---@param fallbackSquad gamedataAISquadParams_Record
---@return Bool, gamedataAITicket_Record, gamedataAISquadParams_Record
function AIbehaviorScriptUtils.GetTicketType(ticketName, puppet, fallbackSquad) return end

---@param position Vector3
---@return Bool, Float
function AIbehaviorScriptUtils.GetWaterLevel(position) return end

---@param recordId TweakDBID|string
---@return Bool
function AIbehaviorScriptUtils.IsArchetypeAction(recordId) return end

---@param context AIbehaviorScriptExecutionContext
---@param splineRef NodeRef
---@param splineRecalculation Bool
---@return Bool
function AIbehaviorScriptUtils.IsSplineStartRecalculated(context, splineRef, splineRecalculation) return end

---@class AIbehaviorSelectCombatTargetTaskDefinition : AIbehaviorTaskDefinition
---@field target AIArgumentMapping
---@field targetClosest Bool
AIbehaviorSelectCombatTargetTaskDefinition = {}

---@return AIbehaviorSelectCombatTargetTaskDefinition
function AIbehaviorSelectCombatTargetTaskDefinition.new() return end

---@param props table
---@return AIbehaviorSelectCombatTargetTaskDefinition
function AIbehaviorSelectCombatTargetTaskDefinition.new(props) return end

---@class AIbehaviorSelectCoverTaskDefinition : AIbehaviorTaskDefinition
---@field cover AIArgumentMapping
---@field coverID AIArgumentMapping
---@field multiCoverID AIArgumentMapping
---@field combatTarget AIArgumentMapping
---@field friendlyTarget AIArgumentMapping
---@field combatZone AIArgumentMapping
---@field sectorSelection CName
---@field ignoreRestrictMovementArea AIArgumentMapping
---@field selectionPreset AIArgumentMapping
---@field onActivationSelectionPreset AIArgumentMapping
---@field secondStagePreset AIArgumentMapping
---@field coverChangeThreshold AIArgumentMapping
---@field coverGatheringCenterObject AIArgumentMapping
---@field coverDisablingDuration AIArgumentMapping
AIbehaviorSelectCoverTaskDefinition = {}

---@return AIbehaviorSelectCoverTaskDefinition
function AIbehaviorSelectCoverTaskDefinition.new() return end

---@param props table
---@return AIbehaviorSelectCoverTaskDefinition
function AIbehaviorSelectCoverTaskDefinition.new(props) return end

---@class AIbehaviorSelectWorkspotEntryTaskDefinition : AIbehaviorTaskDefinition
---@field workspotData AIArgumentMapping
---@field destinationPosition AIArgumentMapping
---@field tangentPoint AIArgumentMapping
---@field entranceFromStand AIArgumentMapping
AIbehaviorSelectWorkspotEntryTaskDefinition = {}

---@return AIbehaviorSelectWorkspotEntryTaskDefinition
function AIbehaviorSelectWorkspotEntryTaskDefinition.new() return end

---@param props table
---@return AIbehaviorSelectWorkspotEntryTaskDefinition
function AIbehaviorSelectWorkspotEntryTaskDefinition.new(props) return end

---@class AIbehaviorSelectWorkspotNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field spotInstance AIArgumentMapping
---@field workspotData AIArgumentMapping
---@field dependentWorkspotData AIArgumentMapping
---@field repeatChild Bool
---@field fastForwardAfterTeleport AIArgumentMapping
AIbehaviorSelectWorkspotNodeDefinition = {}

---@return AIbehaviorSelectWorkspotNodeDefinition
function AIbehaviorSelectWorkspotNodeDefinition.new() return end

---@param props table
---@return AIbehaviorSelectWorkspotNodeDefinition
function AIbehaviorSelectWorkspotNodeDefinition.new(props) return end

---@class AIbehaviorSelectedCoversData : IScriptable
---@field selectedCovers Uint64[]
---@field coverRingTypes gamedataAIRingType[]
---@field coversUseLOS Bool[]
---@field sourcePresetName CName[]
AIbehaviorSelectedCoversData = {}

---@return AIbehaviorSelectedCoversData
function AIbehaviorSelectedCoversData.new() return end

---@param props table
---@return AIbehaviorSelectedCoversData
function AIbehaviorSelectedCoversData.new(props) return end

---@class AIbehaviorSelectionStagePtrWrapper
AIbehaviorSelectionStagePtrWrapper = {}

---@return AIbehaviorSelectionStagePtrWrapper
function AIbehaviorSelectionStagePtrWrapper.new() return end

---@param props table
---@return AIbehaviorSelectionStagePtrWrapper
function AIbehaviorSelectionStagePtrWrapper.new(props) return end

---@class AIbehaviorSelectorTreeNodeDefinition : AIbehaviorCompositeTreeNodeDefinition
AIbehaviorSelectorTreeNodeDefinition = {}

---@return AIbehaviorSelectorTreeNodeDefinition
function AIbehaviorSelectorTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorSelectorTreeNodeDefinition
function AIbehaviorSelectorTreeNodeDefinition.new(props) return end

---@class AIbehaviorSendActionEventTaskDefinition : AIbehaviorTaskDefinition
---@field event gameActionEvent
AIbehaviorSendActionEventTaskDefinition = {}

---@return AIbehaviorSendActionEventTaskDefinition
function AIbehaviorSendActionEventTaskDefinition.new() return end

---@param props table
---@return AIbehaviorSendActionEventTaskDefinition
function AIbehaviorSendActionEventTaskDefinition.new(props) return end

---@class AIbehaviorSendSignalTaskDefinition : AIbehaviorTaskDefinition
---@field signalName CName
---@field startAction gameBoolSignalAction
---@field startActionUserData gameSignalUserDataDefinition
---@field endAction gameBoolSignalAction
---@field endActionUserData gameSignalUserDataDefinition
AIbehaviorSendSignalTaskDefinition = {}

---@return AIbehaviorSendSignalTaskDefinition
function AIbehaviorSendSignalTaskDefinition.new() return end

---@param props table
---@return AIbehaviorSendSignalTaskDefinition
function AIbehaviorSendSignalTaskDefinition.new(props) return end

---@class AIbehaviorSequenceTreeNodeDefinition : AIbehaviorCompositeTreeNodeDefinition
AIbehaviorSequenceTreeNodeDefinition = {}

---@return AIbehaviorSequenceTreeNodeDefinition
function AIbehaviorSequenceTreeNodeDefinition.new() return end

---@param props table
---@return AIbehaviorSequenceTreeNodeDefinition
function AIbehaviorSequenceTreeNodeDefinition.new(props) return end

---@class AIbehaviorShouldEnterCrowdConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorShouldEnterCrowdConditionDefinition = {}

---@return AIbehaviorShouldEnterCrowdConditionDefinition
function AIbehaviorShouldEnterCrowdConditionDefinition.new() return end

---@param props table
---@return AIbehaviorShouldEnterCrowdConditionDefinition
function AIbehaviorShouldEnterCrowdConditionDefinition.new(props) return end

---@class AIbehaviorShouldFollowSlotDefinition : AIbehaviorVehicleExpressionDefinition
AIbehaviorShouldFollowSlotDefinition = {}

---@return AIbehaviorShouldFollowSlotDefinition
function AIbehaviorShouldFollowSlotDefinition.new() return end

---@param props table
---@return AIbehaviorShouldFollowSlotDefinition
function AIbehaviorShouldFollowSlotDefinition.new(props) return end

---@class AIbehaviorShouldJoinTrafficDefinition : AIbehaviorVehicleExpressionDefinition
AIbehaviorShouldJoinTrafficDefinition = {}

---@return AIbehaviorShouldJoinTrafficDefinition
function AIbehaviorShouldJoinTrafficDefinition.new() return end

---@param props table
---@return AIbehaviorShouldJoinTrafficDefinition
function AIbehaviorShouldJoinTrafficDefinition.new(props) return end

---@class AIbehaviorSignalConditionDefinition : AIbehaviorConditionDefinition
---@field signalName CName
---@field mode AIbehaviorSignalConditionModes
---@field tagSignal Bool
AIbehaviorSignalConditionDefinition = {}

---@return AIbehaviorSignalConditionDefinition
function AIbehaviorSignalConditionDefinition.new() return end

---@param props table
---@return AIbehaviorSignalConditionDefinition
function AIbehaviorSignalConditionDefinition.new(props) return end

---@class AIbehaviorSimpleParameterizedBehavior : AIbehaviorParameterizedBehavior
AIbehaviorSimpleParameterizedBehavior = {}

---@return AIbehaviorSimpleParameterizedBehavior
function AIbehaviorSimpleParameterizedBehavior.new() return end

---@param props table
---@return AIbehaviorSimpleParameterizedBehavior
function AIbehaviorSimpleParameterizedBehavior.new(props) return end

---@class AIbehaviorSlotOccupiedConditionDefinition : AIbehaviorConditionDefinition
---@field slot AIArgumentMapping
AIbehaviorSlotOccupiedConditionDefinition = {}

---@return AIbehaviorSlotOccupiedConditionDefinition
function AIbehaviorSlotOccupiedConditionDefinition.new() return end

---@param props table
---@return AIbehaviorSlotOccupiedConditionDefinition
function AIbehaviorSlotOccupiedConditionDefinition.new(props) return end

---@class AIbehaviorStackScriptPassiveExpressionDefinition : AIbehaviorPassiveExpressionDefinition
AIbehaviorStackScriptPassiveExpressionDefinition = {}

---@return AIbehaviorStackScriptPassiveExpressionDefinition
function AIbehaviorStackScriptPassiveExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorStackScriptPassiveExpressionDefinition
function AIbehaviorStackScriptPassiveExpressionDefinition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param callbackName CName|string
---@return Uint32
function AIbehaviorStackScriptPassiveExpressionDefinition:AddBehaviorCallback(context, callbackName) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIbehaviorStackScriptPassiveExpressionDefinition:AddToUpdateQueue(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param signalName CName|string
---@return Uint16
function AIbehaviorStackScriptPassiveExpressionDefinition:ListenToSignal(context, signalName) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviorStackScriptPassiveExpressionDefinition:MarkDirty(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param callbackId Uint32
---@return Bool
function AIbehaviorStackScriptPassiveExpressionDefinition:RemoveBehaviorCallback(context, callbackId) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIbehaviorStackScriptPassiveExpressionDefinition:RemoveFromUpdateQueue(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param signalId Uint16
---@return Bool
function AIbehaviorStackScriptPassiveExpressionDefinition:StopListeningToSignal(context, signalId) return end

---@class AIbehaviorStackScriptTaskDefinition : AIbehaviorTaskDefinition
---@field script AIbehaviortaskStackScript
AIbehaviorStackScriptTaskDefinition = {}

---@return AIbehaviorStackScriptTaskDefinition
function AIbehaviorStackScriptTaskDefinition.new() return end

---@param props table
---@return AIbehaviorStackScriptTaskDefinition
function AIbehaviorStackScriptTaskDefinition.new(props) return end

---@class AIbehaviorStoryActionConditionDefinition : AIbehaviorConditionDefinition
---@field action AIbehaviorStoryActionType
AIbehaviorStoryActionConditionDefinition = {}

---@return AIbehaviorStoryActionConditionDefinition
function AIbehaviorStoryActionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorStoryActionConditionDefinition
function AIbehaviorStoryActionConditionDefinition.new(props) return end

---@class AIbehaviorStoryEventResolverDefinition : AIbehaviorEventResolverDefinition
---@field storyTier AIArgumentMapping
AIbehaviorStoryEventResolverDefinition = {}

---@return AIbehaviorStoryEventResolverDefinition
function AIbehaviorStoryEventResolverDefinition.new() return end

---@param props table
---@return AIbehaviorStoryEventResolverDefinition
function AIbehaviorStoryEventResolverDefinition.new(props) return end

---@class AIbehaviorStoryTierConditionDefinition : AIbehaviorConditionDefinition
---@field tier gameStoryTier
---@field storyTier AIArgumentMapping
AIbehaviorStoryTierConditionDefinition = {}

---@return AIbehaviorStoryTierConditionDefinition
function AIbehaviorStoryTierConditionDefinition.new() return end

---@param props table
---@return AIbehaviorStoryTierConditionDefinition
function AIbehaviorStoryTierConditionDefinition.new(props) return end

---@class AIbehaviorSubtreeDefinition : AIbehaviorNestedTreeDefinition
---@field tree AIbehaviorParameterizedBehavior
AIbehaviorSubtreeDefinition = {}

---@return AIbehaviorSubtreeDefinition
function AIbehaviorSubtreeDefinition.new() return end

---@param props table
---@return AIbehaviorSubtreeDefinition
function AIbehaviorSubtreeDefinition.new(props) return end

---@class AIbehaviorSucceederNodeDefinition : AIbehaviorLeafTreeNodeDefinition
AIbehaviorSucceederNodeDefinition = {}

---@return AIbehaviorSucceederNodeDefinition
function AIbehaviorSucceederNodeDefinition.new() return end

---@param props table
---@return AIbehaviorSucceederNodeDefinition
function AIbehaviorSucceederNodeDefinition.new(props) return end

---@class AIbehaviorSuspiciousObjectEvent : redEvent
---@field target gameObject
---@field description CName
AIbehaviorSuspiciousObjectEvent = {}

---@return AIbehaviorSuspiciousObjectEvent
function AIbehaviorSuspiciousObjectEvent.new() return end

---@param props table
---@return AIbehaviorSuspiciousObjectEvent
function AIbehaviorSuspiciousObjectEvent.new(props) return end

---@class AIbehaviorSystemVariableExpressionDefinition : AIbehaviorPassiveExpressionDefinition
---@field variable AIbehaviorSystemVariableExpressionTypes
AIbehaviorSystemVariableExpressionDefinition = {}

---@return AIbehaviorSystemVariableExpressionDefinition
function AIbehaviorSystemVariableExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorSystemVariableExpressionDefinition
function AIbehaviorSystemVariableExpressionDefinition.new(props) return end

---@class AIbehaviorTaskDefinition : ISerializable
---@field ignoreTaskCompletion Bool
AIbehaviorTaskDefinition = {}

---@class AIbehaviorTaskNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field task AIbehaviorTaskDefinition
AIbehaviorTaskNodeDefinition = {}

---@class AIbehaviorTimeoutNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field time AIArgumentMapping
AIbehaviorTimeoutNodeDefinition = {}

---@return AIbehaviorTimeoutNodeDefinition
function AIbehaviorTimeoutNodeDefinition.new() return end

---@param props table
---@return AIbehaviorTimeoutNodeDefinition
function AIbehaviorTimeoutNodeDefinition.new(props) return end

---@class AIbehaviorTrackPatrolProgressNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field pathParameters AIArgumentMapping
---@field patrolProgress AIArgumentMapping
---@field startFromClosestPoint AIArgumentMapping
---@field patrolContinuationPolicy AIArgumentMapping
---@field teleportPositionAfterTimeSkipping AIArgumentMapping
---@field teleportRotationAfterTimeSkipping AIArgumentMapping
---@field handleTeleportRequest AIArgumentMapping
---@field fastForwardAfterTeleport AIArgumentMapping
AIbehaviorTrackPatrolProgressNodeDefinition = {}

---@return AIbehaviorTrackPatrolProgressNodeDefinition
function AIbehaviorTrackPatrolProgressNodeDefinition.new() return end

---@param props table
---@return AIbehaviorTrackPatrolProgressNodeDefinition
function AIbehaviorTrackPatrolProgressNodeDefinition.new(props) return end

---@class AIbehaviorTreeNodeDebugInfo : AIbehaviorDebugInfoBase
AIbehaviorTreeNodeDebugInfo = {}

---@return AIbehaviorTreeNodeDebugInfo
function AIbehaviorTreeNodeDebugInfo.new() return end

---@param props table
---@return AIbehaviorTreeNodeDebugInfo
function AIbehaviorTreeNodeDebugInfo.new(props) return end

---@class AIbehaviorTreeNodeDefinition : AIbehaviorBehaviorComponentDefinition
AIbehaviorTreeNodeDefinition = {}

---@class AIbehaviorTrueConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorTrueConditionDefinition = {}

---@return AIbehaviorTrueConditionDefinition
function AIbehaviorTrueConditionDefinition.new() return end

---@param props table
---@return AIbehaviorTrueConditionDefinition
function AIbehaviorTrueConditionDefinition.new(props) return end

---@class AIbehaviorTryGetChasePointTaskDefinition : AIbehaviorTaskDefinition
---@field inPlayerPositionDelay AIArgumentMapping
---@field inPlayerPositionMaxDistance AIArgumentMapping
---@field inNearestNavmeshPolyExtent AIArgumentMapping
---@field outChasePosition AIArgumentMapping
AIbehaviorTryGetChasePointTaskDefinition = {}

---@return AIbehaviorTryGetChasePointTaskDefinition
function AIbehaviorTryGetChasePointTaskDefinition.new() return end

---@param props table
---@return AIbehaviorTryGetChasePointTaskDefinition
function AIbehaviorTryGetChasePointTaskDefinition.new(props) return end

---@class AIbehaviorTweakConditionDefinition : AIbehaviorConditionDefinition
---@field recordId TweakDBID
AIbehaviorTweakConditionDefinition = {}

---@return AIbehaviorTweakConditionDefinition
function AIbehaviorTweakConditionDefinition.new() return end

---@param props table
---@return AIbehaviorTweakConditionDefinition
function AIbehaviorTweakConditionDefinition.new(props) return end

---@class AIbehaviorTypeRef
---@field isSet Bool
---@field customType CName
---@field enumeratedType AIArgumentType
AIbehaviorTypeRef = {}

---@return AIbehaviorTypeRef
function AIbehaviorTypeRef.new() return end

---@param props table
---@return AIbehaviorTypeRef
function AIbehaviorTypeRef.new(props) return end

---@class AIbehaviorUnaryConditionDefinition : AIbehaviorConditionDefinition
---@field child AIbehaviorConditionDefinition
AIbehaviorUnaryConditionDefinition = {}

---@class AIbehaviorUniqueActiveCommandList
AIbehaviorUniqueActiveCommandList = {}

---@return AIbehaviorUniqueActiveCommandList
function AIbehaviorUniqueActiveCommandList.new() return end

---@param props table
---@return AIbehaviorUniqueActiveCommandList
function AIbehaviorUniqueActiveCommandList.new(props) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param command AICommand
function AIbehaviorUniqueActiveCommandList.Add(list, command) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param commandName CName|string
function AIbehaviorUniqueActiveCommandList.ClearActionCommand(list, commandName) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param command CName|string
---@return Bool
function AIbehaviorUniqueActiveCommandList.Contains(list, command) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param commandId Uint32
---@return Bool
function AIbehaviorUniqueActiveCommandList.ContainsById(list, commandId) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param command CName|string
---@return Bool, Uint32
function AIbehaviorUniqueActiveCommandList.GetId(list, command) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param commandId Uint32
---@return Bool
function AIbehaviorUniqueActiveCommandList.IsActionCommandById(list, commandId) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param commandName CName|string
---@return Bool
function AIbehaviorUniqueActiveCommandList.IsActionCommandByName(list, commandName) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param commandName CName|string
function AIbehaviorUniqueActiveCommandList.Remove(list, commandName) return end

---@param list AIbehaviorUniqueActiveCommandList
---@return Int32
function AIbehaviorUniqueActiveCommandList.Size(list) return end

---@param list AIbehaviorUniqueActiveCommandList
---@param commandName CName|string
function AIbehaviorUniqueActiveCommandList.TrackActionCommand(list, commandName) return end

---@class AIbehaviorUnmountImmediatelyNodeDefinition : AIbehaviorDecoratorNodeDefinition
---@field mountData AIArgumentMapping
AIbehaviorUnmountImmediatelyNodeDefinition = {}

---@return AIbehaviorUnmountImmediatelyNodeDefinition
function AIbehaviorUnmountImmediatelyNodeDefinition.new() return end

---@param props table
---@return AIbehaviorUnmountImmediatelyNodeDefinition
function AIbehaviorUnmountImmediatelyNodeDefinition.new(props) return end

---@class AIbehaviorUsedSpotTokensList : ISerializable
---@field tokens AISpotUsageToken[]
AIbehaviorUsedSpotTokensList = {}

---@return AIbehaviorUsedSpotTokensList
function AIbehaviorUsedSpotTokensList.new() return end

---@param props table
---@return AIbehaviorUsedSpotTokensList
function AIbehaviorUsedSpotTokensList.new(props) return end

---@class AIbehaviorVehicleExpressionDefinition : AIbehaviorPassiveExpressionDefinition
AIbehaviorVehicleExpressionDefinition = {}

---@return AIbehaviorVehicleExpressionDefinition
function AIbehaviorVehicleExpressionDefinition.new() return end

---@param props table
---@return AIbehaviorVehicleExpressionDefinition
function AIbehaviorVehicleExpressionDefinition.new(props) return end

---@class AIbehaviorWaitConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitConditionDefinition = {}

---@return AIbehaviorWaitConditionDefinition
function AIbehaviorWaitConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitConditionDefinition
function AIbehaviorWaitConditionDefinition.new(props) return end

---@class AIbehaviorWaitFormationPositionConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitFormationPositionConditionDefinition = {}

---@return AIbehaviorWaitFormationPositionConditionDefinition
function AIbehaviorWaitFormationPositionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitFormationPositionConditionDefinition
function AIbehaviorWaitFormationPositionConditionDefinition.new(props) return end

---@class AIbehaviorWaitJoinTrafficConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitJoinTrafficConditionDefinition = {}

---@return AIbehaviorWaitJoinTrafficConditionDefinition
function AIbehaviorWaitJoinTrafficConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitJoinTrafficConditionDefinition
function AIbehaviorWaitJoinTrafficConditionDefinition.new(props) return end

---@class AIbehaviorWaitRefPositionConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitRefPositionConditionDefinition = {}

---@return AIbehaviorWaitRefPositionConditionDefinition
function AIbehaviorWaitRefPositionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitRefPositionConditionDefinition
function AIbehaviorWaitRefPositionConditionDefinition.new(props) return end

---@class AIbehaviorWaitSlotConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitSlotConditionDefinition = {}

---@return AIbehaviorWaitSlotConditionDefinition
function AIbehaviorWaitSlotConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitSlotConditionDefinition
function AIbehaviorWaitSlotConditionDefinition.new(props) return end

---@class AIbehaviorWaitSplineBackwardToFollowConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitSplineBackwardToFollowConditionDefinition = {}

---@return AIbehaviorWaitSplineBackwardToFollowConditionDefinition
function AIbehaviorWaitSplineBackwardToFollowConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitSplineBackwardToFollowConditionDefinition
function AIbehaviorWaitSplineBackwardToFollowConditionDefinition.new(props) return end

---@class AIbehaviorWaitSplineToFollowConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitSplineToFollowConditionDefinition = {}

---@return AIbehaviorWaitSplineToFollowConditionDefinition
function AIbehaviorWaitSplineToFollowConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitSplineToFollowConditionDefinition
function AIbehaviorWaitSplineToFollowConditionDefinition.new(props) return end

---@class AIbehaviorWaitStunnedConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitStunnedConditionDefinition = {}

---@return AIbehaviorWaitStunnedConditionDefinition
function AIbehaviorWaitStunnedConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitStunnedConditionDefinition
function AIbehaviorWaitStunnedConditionDefinition.new(props) return end

---@class AIbehaviorWaitSummonConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitSummonConditionDefinition = {}

---@return AIbehaviorWaitSummonConditionDefinition
function AIbehaviorWaitSummonConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitSummonConditionDefinition
function AIbehaviorWaitSummonConditionDefinition.new(props) return end

---@class AIbehaviorWaitTargetToFollowConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitTargetToFollowConditionDefinition = {}

---@return AIbehaviorWaitTargetToFollowConditionDefinition
function AIbehaviorWaitTargetToFollowConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitTargetToFollowConditionDefinition
function AIbehaviorWaitTargetToFollowConditionDefinition.new(props) return end

---@class AIbehaviorWaitTargetToReachConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitTargetToReachConditionDefinition = {}

---@return AIbehaviorWaitTargetToReachConditionDefinition
function AIbehaviorWaitTargetToReachConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitTargetToReachConditionDefinition
function AIbehaviorWaitTargetToReachConditionDefinition.new(props) return end

---@class AIbehaviorWaitWorldPositionConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitWorldPositionConditionDefinition = {}

---@return AIbehaviorWaitWorldPositionConditionDefinition
function AIbehaviorWaitWorldPositionConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitWorldPositionConditionDefinition
function AIbehaviorWaitWorldPositionConditionDefinition.new(props) return end

---@class AIbehaviorWaitingKeepMountedCommandConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitingKeepMountedCommandConditionDefinition = {}

---@return AIbehaviorWaitingKeepMountedCommandConditionDefinition
function AIbehaviorWaitingKeepMountedCommandConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitingKeepMountedCommandConditionDefinition
function AIbehaviorWaitingKeepMountedCommandConditionDefinition.new(props) return end

---@class AIbehaviorWaitingMountCommandConditionDefinition : AIbehaviorConditionDefinition
---@field requestArgument AIArgumentMapping
---@field callbackName CName
AIbehaviorWaitingMountCommandConditionDefinition = {}

---@return AIbehaviorWaitingMountCommandConditionDefinition
function AIbehaviorWaitingMountCommandConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitingMountCommandConditionDefinition
function AIbehaviorWaitingMountCommandConditionDefinition.new(props) return end

---@class AIbehaviorWaitingNotMountedCommandConditionDefinition : AIbehaviorConditionDefinition
AIbehaviorWaitingNotMountedCommandConditionDefinition = {}

---@return AIbehaviorWaitingNotMountedCommandConditionDefinition
function AIbehaviorWaitingNotMountedCommandConditionDefinition.new() return end

---@param props table
---@return AIbehaviorWaitingNotMountedCommandConditionDefinition
function AIbehaviorWaitingNotMountedCommandConditionDefinition.new(props) return end

---@class AIbehaviorWorkspotList : IScriptable
---@field spots NodeRef[]
AIbehaviorWorkspotList = {}

---@return AIbehaviorWorkspotList
function AIbehaviorWorkspotList.new() return end

---@param props table
---@return AIbehaviorWorkspotList
function AIbehaviorWorkspotList.new(props) return end

---@class AIbehaviorWorkspotListenerWrapper
AIbehaviorWorkspotListenerWrapper = {}

---@return AIbehaviorWorkspotListenerWrapper
function AIbehaviorWorkspotListenerWrapper.new() return end

---@param props table
---@return AIbehaviorWorkspotListenerWrapper
function AIbehaviorWorkspotListenerWrapper.new(props) return end

---@class AIbehaviorconditionScript : AIbehaviorScriptBase
AIbehaviorconditionScript = {}

---@return AIbehaviorconditionScript
function AIbehaviorconditionScript.new() return end

---@param props table
---@return AIbehaviorconditionScript
function AIbehaviorconditionScript.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@param signalName CName|string
---@return Uint16
function AIbehaviorconditionScript:ListenToSignal(context, signalName) return end

---@param context AIbehaviorScriptExecutionContext
---@param interval Float
---@return Bool
function AIbehaviorconditionScript:SetUpdateInterval(context, interval) return end

---@param context AIbehaviorScriptExecutionContext
---@param signalName CName|string
---@param callbackId Uint16
function AIbehaviorconditionScript:StopListeningToSignal(context, signalName, callbackId) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviorconditionScript:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AIbehaviorconditionScript:Check(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param behaviorEvent AIAIEvent
---@return AIbehaviorConditionOutcomes
function AIbehaviorconditionScript:CheckOnEvent(context, behaviorEvent) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviorconditionScript:Deactivate(context) return end

---@class AIbehavioreventResolverScript : IScriptable
AIbehavioreventResolverScript = {}

---@return AIbehavioreventResolverScript
function AIbehavioreventResolverScript.new() return end

---@param props table
---@return AIbehavioreventResolverScript
function AIbehavioreventResolverScript.new(props) return end

---@class AIbehaviorexpressionScript : AIbehaviorScriptBase
AIbehaviorexpressionScript = {}

---@return AIbehaviorexpressionScript
function AIbehaviorexpressionScript.new() return end

---@param props table
---@return AIbehaviorexpressionScript
function AIbehaviorexpressionScript.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviorexpressionScript:MarkDirty(context) return end

---@param cbName CName|string
---@param context AIbehaviorScriptExecutionContext
---@return Bool
function AIbehaviorexpressionScript:OnBehaviorCallback(cbName, context) return end

---@class AIbehaviortaskScript : AIbehaviorScriptBase
AIbehaviortaskScript = {}

---@return AIbehaviortaskScript
function AIbehaviortaskScript.new() return end

---@param props table
---@return AIbehaviortaskScript
function AIbehaviortaskScript.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviortaskScript:CutSelector(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param interval Float
---@return Bool
function AIbehaviortaskScript:SetUpdateInterval(context, interval) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviortaskScript:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param status AIbehaviorCompletionStatus
function AIbehaviortaskScript:ChildCompleted(context, status) return end

---@param context AIbehaviorScriptExecutionContext
function AIbehaviortaskScript:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AIbehaviortaskScript:Update(context) return end

---@class AIbehaviortaskStackScript : AIbehaviorScriptBase
AIbehaviortaskStackScript = {}

---@return AIbehaviortaskStackScript
function AIbehaviortaskStackScript.new() return end

---@param props table
---@return AIbehaviortaskStackScript
function AIbehaviortaskStackScript.new(props) return end

---@return CName
function AIbehaviortaskStackScript:GetInstanceTypeName() return end

---@class AIbehaviortweakAmmoCountConditionData
AIbehaviortweakAmmoCountConditionData = {}

---@return AIbehaviortweakAmmoCountConditionData
function AIbehaviortweakAmmoCountConditionData.new() return end

---@param props table
---@return AIbehaviortweakAmmoCountConditionData
function AIbehaviortweakAmmoCountConditionData.new(props) return end

---@class AIbehaviortweakAttachmentSlotsListener : gameIAttachmentSlotsListener
AIbehaviortweakAttachmentSlotsListener = {}

---@return AIbehaviortweakAttachmentSlotsListener
function AIbehaviortweakAttachmentSlotsListener.new() return end

---@param props table
---@return AIbehaviortweakAttachmentSlotsListener
function AIbehaviortweakAttachmentSlotsListener.new(props) return end

---@class AIbehaviortweakCompiledActionConditionData
AIbehaviortweakCompiledActionConditionData = {}

---@return AIbehaviortweakCompiledActionConditionData
function AIbehaviortweakCompiledActionConditionData.new() return end

---@param props table
---@return AIbehaviortweakCompiledActionConditionData
function AIbehaviortweakCompiledActionConditionData.new(props) return end

---@class AIbehaviortweakConditionStatusEffectListener : gameIStatusEffectListener
AIbehaviortweakConditionStatusEffectListener = {}

---@return AIbehaviortweakConditionStatusEffectListener
function AIbehaviortweakConditionStatusEffectListener.new() return end

---@param props table
---@return AIbehaviortweakConditionStatusEffectListener
function AIbehaviortweakConditionStatusEffectListener.new(props) return end

---@class AIbehaviortweakDetectionListenerWrapper
AIbehaviortweakDetectionListenerWrapper = {}

---@return AIbehaviortweakDetectionListenerWrapper
function AIbehaviortweakDetectionListenerWrapper.new() return end

---@param props table
---@return AIbehaviortweakDetectionListenerWrapper
function AIbehaviortweakDetectionListenerWrapper.new(props) return end

---@class AIbehaviortweakExecutionContext
AIbehaviortweakExecutionContext = {}

---@return AIbehaviortweakExecutionContext
function AIbehaviortweakExecutionContext.new() return end

---@param props table
---@return AIbehaviortweakExecutionContext
function AIbehaviortweakExecutionContext.new(props) return end

---@class AIbehaviortweakInstanceRef
AIbehaviortweakInstanceRef = {}

---@return AIbehaviortweakInstanceRef
function AIbehaviortweakInstanceRef.new() return end

---@param props table
---@return AIbehaviortweakInstanceRef
function AIbehaviortweakInstanceRef.new(props) return end

---@class AIbehaviortweakItemsInInventoryListener : gameIInventoryListener
AIbehaviortweakItemsInInventoryListener = {}

---@return AIbehaviortweakItemsInInventoryListener
function AIbehaviortweakItemsInInventoryListener.new() return end

---@param props table
---@return AIbehaviortweakItemsInInventoryListener
function AIbehaviortweakItemsInInventoryListener.new(props) return end

---@class AIbehaviortweakNPCCallbacks
AIbehaviortweakNPCCallbacks = {}

---@return AIbehaviortweakNPCCallbacks
function AIbehaviortweakNPCCallbacks.new() return end

---@param props table
---@return AIbehaviortweakNPCCallbacks
function AIbehaviortweakNPCCallbacks.new(props) return end

---@class AIbehaviortweakPlayerCallbacks
AIbehaviortweakPlayerCallbacks = {}

---@return AIbehaviortweakPlayerCallbacks
function AIbehaviortweakPlayerCallbacks.new() return end

---@param props table
---@return AIbehaviortweakPlayerCallbacks
function AIbehaviortweakPlayerCallbacks.new(props) return end

---@class AIbehaviortweakStateCallback
AIbehaviortweakStateCallback = {}

---@return AIbehaviortweakStateCallback
function AIbehaviortweakStateCallback.new() return end

---@param props table
---@return AIbehaviortweakStateCallback
function AIbehaviortweakStateCallback.new(props) return end

---@class AIbehaviortweakStateConditionData
AIbehaviortweakStateConditionData = {}

---@return AIbehaviortweakStateConditionData
function AIbehaviortweakStateConditionData.new() return end

---@param props table
---@return AIbehaviortweakStateConditionData
function AIbehaviortweakStateConditionData.new(props) return end

---@class AIbehaviortweakTargetHelper
AIbehaviortweakTargetHelper = {}

---@return AIbehaviortweakTargetHelper
function AIbehaviortweakTargetHelper.new() return end

---@param props table
---@return AIbehaviortweakTargetHelper
function AIbehaviortweakTargetHelper.new(props) return end

---@class AIbehaviortweakTargetLocation
---@field object gameObject
---@field position Vector3
---@field speed Vector3
---@field coverId AIObjectId
---@field hasPosition Bool
---@field hasSpeed Bool
AIbehaviortweakTargetLocation = {}

---@return AIbehaviortweakTargetLocation
function AIbehaviortweakTargetLocation.new() return end

---@param props table
---@return AIbehaviortweakTargetLocation
function AIbehaviortweakTargetLocation.new(props) return end

---@class AIbehaviortweakTargetStates
AIbehaviortweakTargetStates = {}

---@return AIbehaviortweakTargetStates
function AIbehaviortweakTargetStates.new() return end

---@param props table
---@return AIbehaviortweakTargetStates
function AIbehaviortweakTargetStates.new(props) return end

---@class AIbehaviortweakTweakActionSystem : gameIGameSystem
AIbehaviortweakTweakActionSystem = {}

---@return AIbehaviortweakTweakActionSystem
function AIbehaviortweakTweakActionSystem.new() return end

---@param props table
---@return AIbehaviortweakTweakActionSystem
function AIbehaviortweakTweakActionSystem.new(props) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param actionRecordId TweakDBID|string
---@return Bool
function AIbehaviortweakTweakActionSystem:ActivationCheck(ctx, actionRecordId) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@return Uint32
function AIbehaviortweakTweakActionSystem:Debug_OnActionEnded(ctx, recordId) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@param phase Uint32
---@param value Bool
---@return Uint32
function AIbehaviortweakTweakActionSystem:Debug_OnActionNextPhase(ctx, recordId, phase, value) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@param phase Uint32
---@return Uint32
function AIbehaviortweakTweakActionSystem:Debug_OnActionPhaseStarted(ctx, recordId, phase) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@param phase Uint32
---@param value Bool
---@return Uint32
function AIbehaviortweakTweakActionSystem:Debug_OnActionRepeatPhase(ctx, recordId, phase, value) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@param baseId TweakDBID|string
---@param compositeId TweakDBID|string
---@return Uint32
function AIbehaviortweakTweakActionSystem:Debug_OnActionStarted(ctx, recordId, baseId, compositeId) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param record gamedataAIActionCondition_Record
---@return Bool
function AIbehaviortweakTweakActionSystem:EvaluateActionCondition(ctx, record) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@param predictionTime Float
---@return Bool, gameObject, Vector4, Uint64
function AIbehaviortweakTweakActionSystem:EvaluateActionTargetAll(ctx, recordId, predictionTime) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@return Bool, gameObject
function AIbehaviortweakTweakActionSystem:EvaluateActionTargetObject(ctx, recordId) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param recordId TweakDBID|string
---@return Bool
function AIbehaviortweakTweakActionSystem:ForceDirty(ctx, recordId) return end

---@param ctx AIbehaviorScriptExecutionContext
---@return Uint32
function AIbehaviortweakTweakActionSystem:GetTweakCompositeAlternativesLimit(ctx) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param playerInCombat Bool
---@return Bool
function AIbehaviortweakTweakActionSystem:IsTweakCompositeAlternativesLimitEnabled(ctx, playerInCombat) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param actionRecordId TweakDBID|string
---@param phase Uint32
---@return Bool
function AIbehaviortweakTweakActionSystem:NextPhaseCheck(ctx, actionRecordId, phase) return end

---@param ctx AIbehaviorScriptExecutionContext
---@param actionRecordId TweakDBID|string
---@param phase Uint32
---@return Bool
function AIbehaviortweakTweakActionSystem:RepeatPhaseCheck(ctx, actionRecordId, phase) return end

---@class AIsquadsOrder
---@field squadAction CName
---@field state Uint32
---@field id Uint32
AIsquadsOrder = {}

---@return AIsquadsOrder
function AIsquadsOrder.new() return end

---@param props table
---@return AIsquadsOrder
function AIsquadsOrder.new(props) return end

---@class AJournalEntryWrapper : ABaseWrapper
---@field UniqueId Int32
AJournalEntryWrapper = {}

---@return Int32
function AJournalEntryWrapper:GetUniqueId() return end

---@param uniqueId Int32
function AJournalEntryWrapper:SetUniqueId(uniqueId) return end

---@class AOEArea : InteractiveMasterDevice
---@field areaComponent gameStaticTriggerAreaComponent
---@field gameEffect gameEffectInstance
---@field highLightActive Bool
---@field visionBlockerComponent entIComponent
---@field obstacleComponent gameinfluenceObstacleComponent
---@field activeStatusEffects gamedataStatusEffect_Record[]
---@field extendPercentAABB Float
---@field isAABBExtended Bool
AOEArea = {}

---@return AOEArea
function AOEArea.new() return end

---@param props table
---@return AOEArea
function AOEArea.new(props) return end

---@param evt ActivateDevice
---@return Bool
function AOEArea:OnActivateDevice(evt) return end

---@param evt entAreaEnteredEvent
---@return Bool
function AOEArea:OnAreaEnter(evt) return end

---@param evt entAreaExitedEvent
---@return Bool
function AOEArea:OnAreaExit(evt) return end

---@param evt DeactivateDevice
---@return Bool
function AOEArea:OnDeactivateDevice(evt) return end

---@return Bool
function AOEArea:OnDetach() return end

---@return Bool
function AOEArea:OnGameAttached() return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AOEArea:OnRequestComponents(ri) return end

---@param evt RevealDeviceRequest
---@return Bool
function AOEArea:OnRevealDeviceRequest(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AOEArea:OnTakeControl(ri) return end

function AOEArea:ActivateArea() return end

function AOEArea:ActivateEffect() return end

---@param entityID entEntityID
function AOEArea:ApplyActiveStatusEffectsToEntity(entityID) return end

---@param highlightType EFocusForcedHighlightType
---@return FocusForcedHighlightData
function AOEArea:CreateHighlight(highlightType) return end

function AOEArea:DeactivateArea() return end

function AOEArea:ExtendBoundingBox() return end

---@return AOEAreaController
function AOEArea:GetController() return end

---@return FocusForcedHighlightData
function AOEArea:GetDefaultHighlight() return end

---@return AOEAreaControllerPS
function AOEArea:GetDevicePS() return end

---@param effectData AreaEffectData
---@return entEntity
function AOEArea:GetDistractionControllerSource(effectData) return end

---@param defaultValue Float
---@return Float
function AOEArea:GetDistractionStimLifetime(defaultValue) return end

---@return entEntity[]
function AOEArea:GetEntitiesInArea() return end

---@return entIComponent
function AOEArea:GetObstacleComponent() return end

---@return gameObject
function AOEArea:GetStimTarget() return end

---@return entIComponent
function AOEArea:GetVisionBlockerComponent() return end

---@return Bool
function AOEArea:IsGameplayRelevant() return end

---@param entityID entEntityID
function AOEArea:RemoveActiveStatusEffectsFromEntity(entityID) return end

function AOEArea:StopGameEffect() return end

---@param toggle Bool
---@param id entEntityID
function AOEArea:ToggleHighlightOnSingleTarget(toggle, id) return end

---@param toggle Bool
function AOEArea:ToggleHighlightOnTargets(toggle) return end

function AOEArea:UpdateWillingInvestigator() return end

---@class AOEAreaController : MasterController
AOEAreaController = {}

---@return AOEAreaController
function AOEAreaController.new() return end

---@param props table
---@return AOEAreaController
function AOEAreaController.new(props) return end

---@return AOEAreaControllerPS
function AOEAreaController:GetPS() return end

---@class AOEAreaControllerPS : MasterControllerPS
---@field AOEAreaSetup AOEAreaSetup
AOEAreaControllerPS = {}

---@return AOEAreaControllerPS
function AOEAreaControllerPS.new() return end

---@param props table
---@return AOEAreaControllerPS
function AOEAreaControllerPS.new(props) return end

---@return DeactivateDevice
function AOEAreaControllerPS:ActionDeactivateDevice() return end

---@return Bool
function AOEAreaControllerPS:BlocksVisibility() return end

---@return Bool
function AOEAreaControllerPS:EffectsOnlyActiveInArea() return end

function AOEAreaControllerPS:GameAttached() return end

---@return CName
function AOEAreaControllerPS:GetActionName() return end

---@param context gameGetActionsContext
---@return Bool, gamedeviceAction[]
function AOEAreaControllerPS:GetActions(context) return end

---@return TweakDBID
function AOEAreaControllerPS:GetAreaEffect() return end

---@return TweakDBID
function AOEAreaControllerPS:GetDeviceIconTweakDBID() return end

---@return Float
function AOEAreaControllerPS:GetEffectDuration() return end

---@param context gameGetActionsContext
---@return TweakDBID
function AOEAreaControllerPS:GetInkWidgetTweakDBID(context) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function AOEAreaControllerPS:GetQuestActions(context) return end

---@return Bool
function AOEAreaControllerPS:IsAreaActive() return end

---@return Bool
function AOEAreaControllerPS:IsDangerous() return end

---@param evt ActionForceResetDevice
---@return EntityNotificationType
function AOEAreaControllerPS:OnActionForceResetDevice(evt) return end

---@param evt ActivateDevice
---@return EntityNotificationType
function AOEAreaControllerPS:OnActivateDevice(evt) return end

---@param evt DeactivateDevice
---@return EntityNotificationType
function AOEAreaControllerPS:OnDeactivateDevice(evt) return end

---@param delayTime Float
function AOEAreaControllerPS:QueueDeactivateAction(delayTime) return end

function AOEAreaControllerPS:ToggleEffectors() return end

---@class AOEAreaSetup
---@field areaEffect TweakDBID
---@field actionName TweakDBID
---@field blocksVisibility Bool
---@field isDangerous Bool
---@field activateOnStartup Bool
---@field effectsOnlyActiveInArea Bool
---@field duration Float
---@field actionWidgetRecord TweakDBID
---@field deviceWidgetRecord TweakDBID
---@field thumbnailWidgetRecord TweakDBID
AOEAreaSetup = {}

---@return AOEAreaSetup
function AOEAreaSetup.new() return end

---@param props table
---@return AOEAreaSetup
function AOEAreaSetup.new(props) return end

---@class AOEEffector : ActivatedDeviceTransfromAnim
AOEEffector = {}

---@return AOEEffector
function AOEEffector.new() return end

---@param props table
---@return AOEEffector
function AOEEffector.new(props) return end

---@return Bool
function AOEEffector:OnGameAttached() return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AOEEffector:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AOEEffector:OnTakeControl(ri) return end

---@param evt ToggleAOEEffect
---@return Bool
function AOEEffector:OnToggleAOEEffect(evt) return end

function AOEEffector:BreakEffects() return end

---@return EGameplayRole
function AOEEffector:DeterminGameplayRole() return end

---@return AOEEffectorController
function AOEEffector:GetController() return end

---@return AOEEffectorControllerPS
function AOEEffector:GetDevicePS() return end

---@return Bool
function AOEEffector:IsGameplayRelevant() return end

function AOEEffector:PushPersistentData() return end

function AOEEffector:StartEffects() return end

---@class AOEEffectorController : ScriptableDeviceComponent
AOEEffectorController = {}

---@return AOEEffectorController
function AOEEffectorController.new() return end

---@param props table
---@return AOEEffectorController
function AOEEffectorController.new(props) return end

---@return AOEEffectorControllerPS
function AOEEffectorController:GetPS() return end

---@class AOEEffectorControllerPS : ActivatedDeviceControllerPS
---@field effectsToPlay CName[]
AOEEffectorControllerPS = {}

---@return AOEEffectorControllerPS
function AOEEffectorControllerPS.new() return end

---@param props table
---@return AOEEffectorControllerPS
function AOEEffectorControllerPS.new(props) return end

---@return ToggleAOEEffect
function AOEEffectorControllerPS:ActionToggleAOEEffect() return end

---@param context gameGetActionsContext
---@return Bool, gamedeviceAction[]
function AOEEffectorControllerPS:GetActions(context) return end

---@return CName[]
function AOEEffectorControllerPS:GetEffectsToPlay() return end

---@param evt ToggleAOEEffect
---@return EntityNotificationType
function AOEEffectorControllerPS:OnToggleAOEEffect(evt) return end

---@class ATooltipData : IScriptable
ATooltipData = {}

---@class AVComponent : VehicleComponent
AVComponent = {}

---@return AVComponent
function AVComponent.new() return end

---@param props table
---@return AVComponent
function AVComponent.new(props) return end

---@class AVSpawnedRequest : gameScriptableSystemRequest
---@field spawnedObjects gameObject[]
AVSpawnedRequest = {}

---@return AVSpawnedRequest
function AVSpawnedRequest.new() return end

---@param props table
---@return AVSpawnedRequest
function AVSpawnedRequest.new(props) return end

---@class AbilityData
---@field Empty Bool
---@field ID ItemID
---@field Name String
---@field IconPath String
---@field CategoryName String
---@field Description String
---@field EquipmentArea gamedataEquipmentArea
---@field IsEquipped Bool
---@field GameItemData gameItemData
---@field AssignedIndex Int32
AbilityData = {}

---@return AbilityData
function AbilityData.new() return end

---@param props table
---@return AbilityData
function AbilityData.new(props) return end

---@class AbilityUserData : IScriptable
---@field abilityID TweakDBID
---@field locKeyName CName
---@field asyncSpawnRequest inkAsyncSpawnRequest
AbilityUserData = {}

---@return AbilityUserData
function AbilityUserData.new() return end

---@param props table
---@return AbilityUserData
function AbilityUserData.new(props) return end

---@class AbsolutePathSerializable
---@field Path String
AbsolutePathSerializable = {}

---@return AbsolutePathSerializable
function AbsolutePathSerializable.new() return end

---@param props table
---@return AbsolutePathSerializable
function AbsolutePathSerializable.new(props) return end

---@class AbstractApplyQuickhackEffector : ModifyAttackEffector
---@field blackboard gameIBlackboard
---@field applyQuickhackDelayConst Float
AbstractApplyQuickhackEffector = {}

---@param owner gameObject
function AbstractApplyQuickhackEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function AbstractApplyQuickhackEffector:Initialize(record, parentRecord) return end

---@param owner gameObject
function AbstractApplyQuickhackEffector:ProcessAction(owner) return end

---@param hitEvent gameeventsHitEvent
---@param playerPuppet PlayerPuppet
---@param targetScriptedPuppet ScriptedPuppet
function AbstractApplyQuickhackEffector:ProcessApplyQuickhackAction(hitEvent, playerPuppet, targetScriptedPuppet) return end

---@param owner gameObject
function AbstractApplyQuickhackEffector:RepeatedAction(owner) return end

---@param playerOwnerPuppet PlayerPuppet
---@param quickhackData QuickhackData
---@param applyQuickhackDelay Float
function AbstractApplyQuickhackEffector:TriggerSpecialQuickHackAttack(playerOwnerPuppet, quickhackData, applyQuickhackDelay) return end

---@class AbstractLandDecisions : LocomotionGroundDecisions
AbstractLandDecisions = {}

---@class AbstractLandEvents : LocomotionGroundEvents
---@field blockLandingStimBroadcasting Bool
AbstractLandEvents = {}

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@param stimType gamedataStimType
function AbstractLandEvents:BroadcastLandingStim(stateContext, scriptInterface, stimType) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AbstractLandEvents:EvaluatePlayingLandingVFX(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AbstractLandEvents:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AbstractLandEvents:OnExit(stateContext, scriptInterface) return end

---@class AccessBreach : PuppetAction
---@field attempt Int32
---@field networkName String
---@field npcCount Int32
---@field isRemote Bool
---@field isSuicide Bool
AccessBreach = {}

---@return AccessBreach
function AccessBreach.new() return end

---@param props table
---@return AccessBreach
function AccessBreach.new(props) return end

function AccessBreach:CompleteAction() return end

---@return gameIBlackboard
function AccessBreach:GetNetworkBlackboard() return end

---@return NetworkBlackboardDef
function AccessBreach:GetNetworkBlackboardDef() return end

---@param id CName|string
---@param isActive Bool
function AccessBreach:SendNanoWireBreachEventToPSM(id, isActive) return end

---@param amount Int32
function AccessBreach:SetAttemptCount(amount) return end

---@param networkName String
---@param npcCount Int32
---@param attemptsCount Int32
---@param isRemote Bool
---@param isSuicide Bool
function AccessBreach:SetProperties(networkName, npcCount, attemptsCount, isRemote, isSuicide) return end

function AccessBreach:StartUpload() return end

---@class AccessBreachListener : QuickHackUploadListener
AccessBreachListener = {}

---@return AccessBreachListener
function AccessBreachListener.new() return end

---@param props table
---@return AccessBreachListener
function AccessBreachListener.new(props) return end

---@class AccessPoint : InteractiveMasterDevice
---@field networkName String
---@field isPlayerInBreachView Bool
---@field isRevealed Bool
---@field breachViewTimeListener BreachViewTimeListener
---@field upload_program_listener_id Uint32
AccessPoint = {}

---@return AccessPoint
function AccessPoint.new() return end

---@param props table
---@return AccessPoint
function AccessPoint.new(props) return end

---@param evt gameuiAccessPointMiniGameStatus
---@return Bool
function AccessPoint:OnAccessPointMiniGameStatus(evt) return end

---@param evt DebugRemoteConnectionEvent
---@return Bool
function AccessPoint:OnDebugRemoteConnectionEvent(evt) return end

---@param evt gameFactChangedEvent
---@return Bool
function AccessPoint:OnFactChangedEvent(evt) return end

---@return Bool
function AccessPoint:OnGameDetached() return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AccessPoint:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AccessPoint:OnTakeControl(ri) return end

---@param evt Validate
---@return Bool
function AccessPoint:OnValidate(evt) return end

---@param module Int32
function AccessPoint:BootModule(module) return end

---@return Bool
function AccessPoint:CanRevealRemoteActionsWheel() return end

---@return EGameplayRole
function AccessPoint:DeterminGameplayRole() return end

function AccessPoint:EvaluateProximityRevealInteractionLayerState() return end

---@return BackDoorDeviceBlackboardDef
function AccessPoint:GetBlackboardDef() return end

---@return AccessPointController
function AccessPoint:GetController() return end

---@return AccessPointControllerPS
function AccessPoint:GetDevicePS() return end

---@param puppet gameObject
function AccessPoint:InitiatePersonalLinkWorkspot(puppet) return end

---@return Bool
function AccessPoint:IsAccessPoint() return end

---@return Bool
function AccessPoint:IsControllingDevices() return end

---@return Bool
function AccessPoint:IsRevealed() return end

---@param reason CName|string
function AccessPoint:OnDiveFinished(reason) return end

---@param attempt Int32
---@param isRemote Bool
function AccessPoint:PerformDive(attempt, isRemote) return end

function AccessPoint:ResolveGameplayState() return end

---@return Bool
function AccessPoint:ShouldRegisterToHUD() return end

function AccessPoint:TerminateConnection() return end

---@param on Bool
function AccessPoint:ToggleLights(on) return end

---@param toggle Bool
---@param puppet gameObject
function AccessPoint:TogglePersonalLink(toggle, puppet) return end

function AccessPoint:UploadProgram() return end

---@class AccessPointCompatibleWithUser : gameinteractionsInteractionScriptedCondition
AccessPointCompatibleWithUser = {}

---@return AccessPointCompatibleWithUser
function AccessPointCompatibleWithUser.new() return end

---@param props table
---@return AccessPointCompatibleWithUser
function AccessPointCompatibleWithUser.new(props) return end

---@param activatorObject gameObject
---@param hotSpotObject gameObject
---@param hotSpotLayer gameinteractionsCHotSpotLayerDefinition
---@return Bool
function AccessPointCompatibleWithUser:Test(activatorObject, hotSpotObject, hotSpotLayer) return end

---@class AccessPointController : MasterController
AccessPointController = {}

---@return AccessPointController
function AccessPointController.new() return end

---@param props table
---@return AccessPointController
function AccessPointController.new(props) return end

---@return AccessPointControllerPS
function AccessPointController:GetPS() return end

---@class AccessPointControllerPS : MasterControllerPS
---@field rewardNotificationIcons String[]
---@field rewardNotificationString String
---@field accessPointSkillChecks HackingContainer
---@field isBreached Bool
---@field moneyAwarded Bool
---@field isVirtual Bool
---@field pingedSquads CName[]
AccessPointControllerPS = {}

---@return AccessPointControllerPS
function AccessPointControllerPS.new() return end

---@param props table
---@return AccessPointControllerPS
function AccessPointControllerPS.new(props) return end

---@return Bool
function AccessPointControllerPS:OnInstantiated() return end

---@return ResetNetworkBreachState
function AccessPointControllerPS:ActionResetNetworkBreachState() return end

---@return RevealEnemiesProgram
function AccessPointControllerPS:ActionRevealEnemiesProgram() return end

---@return SpiderbotEnableAccessPoint
function AccessPointControllerPS:ActionSpiderbotEnableAccessPoint() return end

---@param TS gameTransactionSystem
---@param itemTweakID TweakDBID|string
---@param amount Uint32
function AccessPointControllerPS:AddHackReward(TS, itemTweakID, amount) return end

---@param squadName CName|string
function AccessPointControllerPS:AddPingedSquad(squadName) return end

---@param TS gameTransactionSystem
---@param itemQueryTDBID TweakDBID|string
---@param amount Uint32
function AccessPointControllerPS:AddReward(TS, itemQueryTDBID, amount) return end

function AccessPointControllerPS:BreachConnectedDevices() return end

---@return Bool
function AccessPointControllerPS:CanCreateAnyQuickHackActions() return end

---@return Bool
function AccessPointControllerPS:CanCreateAnySpiderbotActions() return end

---@return ConnectedClassTypes
function AccessPointControllerPS:CheckConnectedClassTypes() return end

---@param minigameProgramsCompleted Int32
function AccessPointControllerPS:CheckMasterRunnerAchievement(minigameProgramsCompleted) return end

function AccessPointControllerPS:CleanRewardNotification() return end

function AccessPointControllerPS:ClearPingedSquads() return end

function AccessPointControllerPS:DebugBreachConnectedDevices() return end

---@return gamedeviceAction[]
function AccessPointControllerPS:ExtractActions() return end

---@param programs TweakDBID[]|string[]
function AccessPointControllerPS:FilterRedundantPrograms(programs) return end

---@param state gameuiHackingMinigameState
function AccessPointControllerPS:FinalizeNetrunnerDive(state) return end

function AccessPointControllerPS:GameAttached() return end

---@param playerLevel Float
---@param TS gameTransactionSystem
function AccessPointControllerPS:GenerateMaterialDrops(playerLevel, TS) return end

---@return AccessPointControllerPS
function AccessPointControllerPS:GetBackdoorAccessPoint() return end

---@return BackDoorDeviceBlackboardDef
function AccessPointControllerPS:GetBlackboardDef() return end

---@return gamedeviceClearance
function AccessPointControllerPS:GetClearance() return end

---@return CommunityProxyPS[]
function AccessPointControllerPS:GetCommunityProxies() return end

---@return ScriptableDeviceComponentPS[]
function AccessPointControllerPS:GetDevicesThatPlayerCanBreach() return end

---@return TweakDBID
function AccessPointControllerPS:GetMinigameDefinition() return end

---@return NetworkAreaControllerPS
function AccessPointControllerPS:GetNetworkArea() return end

---@return String
function AccessPointControllerPS:GetNetworkName() return end

---@return Int32
function AccessPointControllerPS:GetNetworkSizeCount() return end

---@param TS gameTransactionSystem
---@param hacksPool TweakDBID[]|string[]
---@param quality gamedataQuality
---@return TweakDBID[], TweakDBID[]
function AccessPointControllerPS:GetPlayersUniqueHacks(TS, hacksPool, quality) return end

---@param actionName CName|string
---@return gamedeviceAction
function AccessPointControllerPS:GetQuestActionByName(actionName) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function AccessPointControllerPS:GetQuestActions(context) return end

---@param playerLevel Float
---@param TS gameTransactionSystem
function AccessPointControllerPS:GetQuickhackReward(playerLevel, TS) return end

---@return BaseSkillCheckContainer
function AccessPointControllerPS:GetSkillCheckContainerForSetup() return end

---@return Bool
function AccessPointControllerPS:HasNetworkBackdoor() return end

---@param slaveToCheck gamePersistentID
---@return Bool
function AccessPointControllerPS:IsAccessPointOf(slaveToCheck) return end

---@return Bool
function AccessPointControllerPS:IsBreached() return end

---@return Bool
function AccessPointControllerPS:IsConnectedToBackdoorDevice() return end

---@return Bool
function AccessPointControllerPS:IsMainframe() return end

---@return Bool
function AccessPointControllerPS:IsNetworkBreached() return end

---@return Bool
function AccessPointControllerPS:IsSpiderbotHackingConditionFullfilled() return end

---@param squadName CName|string
---@return Bool
function AccessPointControllerPS:IsSquadMarkedWithPing(squadName) return end

---@return Bool
function AccessPointControllerPS:IsVirtual() return end

---@param evt BreachAccessPointEvent
---@return EntityNotificationType
function AccessPointControllerPS:OnBreachAccessPointEvent(evt) return end

---@param evt FillTakeOverChainBBoardEvent
---@return EntityNotificationType
function AccessPointControllerPS:OnFillTakeOverChainBBoardEvent(evt) return end

---@param evt NPCBreachEvent
---@return EntityNotificationType
function AccessPointControllerPS:OnNPCBreachEvent(evt) return end

---@param evt NetworkMoneySiphoned
---@return EntityNotificationType
function AccessPointControllerPS:OnNetworkMoneySiphoned(evt) return end

---@param evt QuestBreachAccessPoint
---@return EntityNotificationType
function AccessPointControllerPS:OnQuestBreachAccessPoint(evt) return end

---@param evt QuestRemoveQuickHacks
---@return EntityNotificationType
function AccessPointControllerPS:OnQuestRemoveQuickHacks(evt) return end

---@param evt RefreshSlavesEvent
---@return EntityNotificationType
function AccessPointControllerPS:OnRefreshSlavesEvent(evt) return end

---@param evt ResetNetworkBreachState
---@return EntityNotificationType
function AccessPointControllerPS:OnResetNetworkBreachState(evt) return end

---@param evt RevealEnemiesProgram
---@return EntityNotificationType
function AccessPointControllerPS:OnRevealEnemiesProgram(evt) return end

---@param evt SetExposeQuickHacks
---@return EntityNotificationType
function AccessPointControllerPS:OnSetExposeQuickHacks(evt) return end

---@param evt SpiderbotEnableAccessPoint
---@return EntityNotificationType
function AccessPointControllerPS:OnSpiderbotEnableAccessPoint(evt) return end

---@param evt Validate
---@return EntityNotificationType
function AccessPointControllerPS:OnValidate(evt) return end

function AccessPointControllerPS:PingSquad() return end

---@param baseMoney Float
---@param craftingMaterial Bool
---@param baseShardDropChance Float
---@param TS gameTransactionSystem
function AccessPointControllerPS:ProcessLoot(baseMoney, craftingMaterial, baseShardDropChance, TS) return end

---@param device gameDeviceComponentPS
function AccessPointControllerPS:ProcessMinigameNetworkActions(device) return end

---@param devices gameDeviceComponentPS[]
function AccessPointControllerPS:RefreshSlaves(devices) return end

---@param squadName CName|string
function AccessPointControllerPS:RemovePingedSquad(squadName) return end

---@param isRemote Bool
function AccessPointControllerPS:ResolveDive(isRemote) return end

---@param shouldDraw Bool
---@param ownerEntityPosition Vector4
---@param fxDefault gameFxResource
---@param isPing Bool
---@param lifetime Float
---@param revealSlave Bool
---@param revealMaster Bool
---@param ignoreRevealed Bool
function AccessPointControllerPS:RevealDevicesGrid(shouldDraw, ownerEntityPosition, fxDefault, isPing, lifetime, revealSlave, revealMaster, ignoreRevealed) return end

---@param baseMoney Float
function AccessPointControllerPS:RewardMoney(baseMoney) return end

function AccessPointControllerPS:SendMinigameFailedToAllNPCs() return end

---@param isBreached Bool
function AccessPointControllerPS:SetIsBreached(isBreached) return end

---@return Bool
function AccessPointControllerPS:ShouldRevealNetworkGrid() return end

---@return Bool
function AccessPointControllerPS:ShouldRewardMoney() return end

function AccessPointControllerPS:ShowRewardNotification() return end

---@param programID Int32
function AccessPointControllerPS:UploadProgram(programID) return end

---@return Bool
function AccessPointControllerPS:WasMoneyAwarded() return end

---@class AccessPointHasCPOMissionDataPrereq : gameIScriptablePrereq
AccessPointHasCPOMissionDataPrereq = {}

---@return AccessPointHasCPOMissionDataPrereq
function AccessPointHasCPOMissionDataPrereq.new() return end

---@param props table
---@return AccessPointHasCPOMissionDataPrereq
function AccessPointHasCPOMissionDataPrereq.new(props) return end

---@param context IScriptable
---@return Bool
function AccessPointHasCPOMissionDataPrereq:IsFulfilled(context) return end

---@class AccessPointIsBlocked : gameIScriptablePrereq
AccessPointIsBlocked = {}

---@return AccessPointIsBlocked
function AccessPointIsBlocked.new() return end

---@param props table
---@return AccessPointIsBlocked
function AccessPointIsBlocked.new(props) return end

---@param context IScriptable
---@return Bool
function AccessPointIsBlocked:IsFulfilled(context) return end

---@class AccumulatedDamageDigitLogicController : inkWidgetLogicController
---@field critWidget inkTextWidgetReference
---@field headshotWidget inkTextWidgetReference
---@field rootWidget inkWidget
---@field panelWidget inkWidget
---@field textWidget inkTextWidget
---@field owner gameObject
---@field gameController DamageDigitsGameController
---@field active Bool
---@field successful Bool
---@field successfulCritical Bool
---@field damageAccumulated Float
---@field showingBothDigits Bool
---@field stickToTarget Bool
---@field currentlySticking Bool
---@field projection inkScreenProjection
---@field showAnimProxy inkanimProxy
---@field critAnimProxy inkanimProxy
---@field blinkProxy inkanimProxy
---@field headshotAnimProxy inkanimProxy
---@field distanceModifier Float
---@field calculatedDistanceHeightBias Float
---@field stickingDistanceHeightBias Float
---@field projectionInterpolationOffset inkMargin
---@field projectionInterpolationOffsetTotal inkMargin
---@field projectionInterpolationProgress Float
---@field projectionFreezePosition Bool
---@field positionUpdated Bool
---@field currentEngineTime Float
---@field lastEngineTime Float
---@field arrayPosition Int32
---@field showPositiveAnimDef inkanimDefinition
---@field showPositiveAnimFadeInInterpolator inkanimTransparencyInterpolator
---@field showPositiveAnimFadeOutInterpolator inkanimTransparencyInterpolator
---@field showPositiveAnimMarginInterpolator inkanimMarginInterpolator
---@field showPositiveAnimScaleUpInterpolator inkanimScaleInterpolator
---@field showPositiveAnimScaleDownInterpolator inkanimScaleInterpolator
---@field showNegativeAnimDef inkanimDefinition
---@field showNegativeAnimFadeInInterpolator inkanimTransparencyInterpolator
---@field showNegativeAnimFadeOutInterpolator inkanimTransparencyInterpolator
---@field showNegativeAnimMarginInterpolator inkanimMarginInterpolator
---@field showCritAnimDef inkanimDefinition
---@field showCritAnimFadeOutInterpolator inkanimTransparencyInterpolator
---@field animStickTargetOffset Vector4
---@field animTimeFadeIn Float
---@field animTimeFadeOut Float
---@field animBothTimeFadeIn Float
---@field animBothTimeFadeOut Float
---@field animTimeDelay Float
---@field animBothTimeDelay Float
---@field animStartHeight Float
---@field animEndHeight Float
---@field animPopScale Float
---@field animPopEndScale Float
---@field animPopInDuration Float
---@field animPopOutDuration Float
---@field animBothOffsetX Float
---@field animBothOffsetY Float
---@field animBothStickingOffsetY Float
---@field animTimeCritDelay Float
---@field animBothTimeCritDelay Float
---@field animTimeCritFade Float
---@field animBothTimeCritFade Float
---@field animMaxScreenDistanceFromLast Float
---@field animScreenInterpolationTime Float
---@field animMinScreenDistanceFromLast Float
---@field animStickTargetWorldZOffset Float
---@field animStickingOffsetY Float
---@field animDistanceModifierMinDistance Float
---@field animDistanceModifierMaxDistance Float
---@field animDistanceModifierMinValue Float
---@field animDistanceModifierMaxValue Float
---@field animDistanceHeightBias Float
---@field animStickingDistanceHeightBias Float
---@field animPositiveOpacity Float
---@field animNegativeOpacity Float
---@field animDynamicFadeInDuration Float
AccumulatedDamageDigitLogicController = {}

---@return AccumulatedDamageDigitLogicController
function AccumulatedDamageDigitLogicController.new() return end

---@param props table
---@return AccumulatedDamageDigitLogicController
function AccumulatedDamageDigitLogicController.new(props) return end

---@param anim inkanimProxy
---@return Bool
function AccumulatedDamageDigitLogicController:OnHide(anim) return end

---@return Bool
function AccumulatedDamageDigitLogicController:OnInitialize() return end

---@param projection inkScreenProjection
---@return Bool
function AccumulatedDamageDigitLogicController:OnScreenProjectionUpdate(projection) return end

---@return Bool
function AccumulatedDamageDigitLogicController:OnUninitialize() return end

---@param damageType gamedataDamageType
---@param hitType gameuiHitType
---@param showingBothDigits Bool
---@param flags SHitFlag[]
---@return CName
function AccumulatedDamageDigitLogicController:BuildStateName(damageType, hitType, showingBothDigits, flags) return end

---@param fromVec Vector4
---@param toVec Vector4
function AccumulatedDamageDigitLogicController:CalculateDistanceModifier(fromVec, toVec) return end

function AccumulatedDamageDigitLogicController:CreateShowAnimation() return end

---@param entity gameObject
---@return Bool
function AccumulatedDamageDigitLogicController:IsProjectedEntity(entity) return end

---@param active Bool
function AccumulatedDamageDigitLogicController:SetActive(active) return end

---@param projection inkScreenProjection
---@param gameController DamageDigitsGameController
function AccumulatedDamageDigitLogicController:SetProjection(projection, gameController) return end

---@param damageInfo gameuiDamageInfo
---@param showingBothDigits Bool
---@param oneInstance Bool
---@param forceStickToTarget Bool
function AccumulatedDamageDigitLogicController:Show(damageInfo, showingBothDigits, oneInstance, forceStickToTarget) return end

---@param damageInfo gameuiDamageInfo
---@param showingBothDigits Bool
function AccumulatedDamageDigitLogicController:UpdateDamageInfo(damageInfo, showingBothDigits) return end

---@param showingBothDigits Bool
function AccumulatedDamageDigitLogicController:UpdateDuration(showingBothDigits) return end

---@param showingBothDigits Bool
function AccumulatedDamageDigitLogicController:UpdatePositionAndScale(showingBothDigits) return end

---@class AccumulatedDamageDigitsNode
---@field used Bool
---@field entityID entEntityID
---@field controller AccumulatedDamageDigitLogicController
---@field isDamageOverTime Bool
AccumulatedDamageDigitsNode = {}

---@return AccumulatedDamageDigitsNode
function AccumulatedDamageDigitsNode.new() return end

---@param props table
---@return AccumulatedDamageDigitsNode
function AccumulatedDamageDigitsNode.new(props) return end

---@class AcquireDeviceLink : redEvent
AcquireDeviceLink = {}

---@return AcquireDeviceLink
function AcquireDeviceLink.new() return end

---@param props table
---@return AcquireDeviceLink
function AcquireDeviceLink.new(props) return end

---@class ActionAnimationScriptProxy : CActionScriptProxy
ActionAnimationScriptProxy = {}

---@return ActionAnimationScriptProxy
function ActionAnimationScriptProxy.new() return end

---@param props table
---@return ActionAnimationScriptProxy
function ActionAnimationScriptProxy.new(props) return end

---@param animFeatureName CName|string
---@param animFeature animAnimFeature_AIAction
---@param useRootMotion Bool
---@param usePoseMatching Bool
---@param resetRagdollOnStart Bool
---@param motionDynamicObjectsCheck Bool
---@param slideParams gameActionAnimationSlideParams
---@param targetObject gameObject
---@param marginToPlayer Float
---@param tagetPositionProvider entIPositionProvider
function ActionAnimationScriptProxy:ForceLaunch(animFeatureName, animFeature, useRootMotion, usePoseMatching, resetRagdollOnStart, motionDynamicObjectsCheck, slideParams, targetObject, marginToPlayer, tagetPositionProvider) return end

---@param animFeatureName CName|string
---@param animFeature animAnimFeature_AIAction
---@return Float
function ActionAnimationScriptProxy:GetPhaseDuration(animFeatureName, animFeature) return end

---@param animFeatureName CName|string
---@param animFeature animAnimFeature_AIAction
---@param useRootMotion Bool
---@param usePoseMatching Bool
---@param resetRagdollOnStart Bool
---@param motionDynamicObjectsCheck Bool
---@param updadeMovePolicy Bool
---@param slideParams gameActionAnimationSlideParams
---@param targetObject gameObject
---@param marginToPlayer Float
---@param tagetPositionProvider entIPositionProvider
---@return Bool
function ActionAnimationScriptProxy:Setup(animFeatureName, animFeature, useRootMotion, usePoseMatching, resetRagdollOnStart, motionDynamicObjectsCheck, updadeMovePolicy, slideParams, targetObject, marginToPlayer, tagetPositionProvider) return end

function ActionAnimationScriptProxy:Terminate() return end

---@class ActionBool : ScriptableDeviceAction
ActionBool = {}

---@param actions gamedeviceAction[]
function ActionBool:CreateActionWidgetPackage(actions) return end

---@param actions gamedeviceAction[]
---@param customName1 String
---@param customName2 String
---@param customID1 TweakDBID|string
---@param customID2 TweakDBID|string
function ActionBool:CreateCustomInteraction(actions, customName1, customName2, customID1, customID2) return end

---@return String
function ActionBool:GetCurrentDisplayString() return end

---@return gamedeviceActionProperty[]
function ActionBool:GetProperties() return end

---@return Bool
function ActionBool:GetValue() return end

---@param newRecordforTrue TweakDBID|string
---@param newRecordForFalse TweakDBID|string
function ActionBool:OverrideInteractionRecord(newRecordforTrue, newRecordForFalse) return end

---@class ActionCooldownEvent : redEvent
---@field storageID CooldownStorageID
ActionCooldownEvent = {}

---@return ActionCooldownEvent
function ActionCooldownEvent.new() return end

---@param props table
---@return ActionCooldownEvent
function ActionCooldownEvent.new(props) return end

---@class ActionDemolition : ActionSkillCheck
---@field slotID gamemountingMountingSlotId
ActionDemolition = {}

---@return ActionDemolition
function ActionDemolition.new() return end

---@param props table
---@return ActionDemolition
function ActionDemolition.new(props) return end

---@return CName
function ActionDemolition:GetDefaultActionName() return end

---@return gamedataChoiceCaptionIconPart_Record
function ActionDemolition:GetInteractionIcon() return end

---@class ActionDisposal : ActionBool
ActionDisposal = {}

---@return ActionDisposal
function ActionDisposal.new() return end

---@param props table
---@return ActionDisposal
function ActionDisposal.new(props) return end

function ActionDisposal:CompleteAction() return end

---@class ActionDodgeScriptProxy : CActionScriptProxy
ActionDodgeScriptProxy = {}

---@return ActionDodgeScriptProxy
function ActionDodgeScriptProxy.new() return end

---@param props table
---@return ActionDodgeScriptProxy
function ActionDodgeScriptProxy.new(props) return end

---@param DodgeData animAnimFeature_DodgeData
---@return Bool
function ActionDodgeScriptProxy:Setup(DodgeData) return end

---@class ActionEngineering : ActionSkillCheck
ActionEngineering = {}

---@return ActionEngineering
function ActionEngineering.new() return end

---@param props table
---@return ActionEngineering
function ActionEngineering.new(props) return end

---@return CName
function ActionEngineering:GetDefaultActionName() return end

---@return gamedataChoiceCaptionIconPart_Record
function ActionEngineering:GetInteractionIcon() return end

---@class ActionEntityReference : ScriptableDeviceAction
ActionEntityReference = {}

---@return String
function ActionEntityReference:GetCurrentDisplayString() return end

---@return gamedeviceActionProperty[]
function ActionEntityReference:GetProperties() return end

---@class ActionEnum : ActionInt
ActionEnum = {}

---@class ActionFloat : ScriptableDeviceAction
ActionFloat = {}

---@return String
function ActionFloat:GetCurrentDisplayString() return end

---@return gamedeviceActionProperty[]
function ActionFloat:GetProperties() return end

---@class ActionForceResetDevice : ActionBool
---@field restartDuration Int32
ActionForceResetDevice = {}

---@return ActionForceResetDevice
function ActionForceResetDevice.new() return end

---@param props table
---@return ActionForceResetDevice
function ActionForceResetDevice.new(props) return end

---@class ActionHacking : ActionSkillCheck
ActionHacking = {}

---@return ActionHacking
function ActionHacking.new() return end

---@param props table
---@return ActionHacking
function ActionHacking.new(props) return end

---@return CName
function ActionHacking:GetDefaultActionName() return end

---@return gamedataChoiceCaptionIconPart_Record
function ActionHacking:GetInteractionIcon() return end

---@class ActionHitReactionScriptProxy : CActionScriptProxy
ActionHitReactionScriptProxy = {}

---@return ActionHitReactionScriptProxy
function ActionHitReactionScriptProxy.new() return end

---@param props table
---@return ActionHitReactionScriptProxy
function ActionHitReactionScriptProxy.new(props) return end

---@param hitReactionsData animAnimFeature_HitReactionsData
---@param fastForward Bool
---@return Bool
function ActionHitReactionScriptProxy:Setup(hitReactionsData, fastForward) return end

---@class ActionInt : ScriptableDeviceAction
ActionInt = {}

---@return String
function ActionInt:GetCurrentDisplayString() return end

---@return gamedeviceActionProperty[]
function ActionInt:GetProperties() return end

---@class ActionInteractivityInfo
---@field isExternal Bool
---@field isRemote Bool
---@field isDirect Bool
ActionInteractivityInfo = {}

---@return ActionInteractivityInfo
function ActionInteractivityInfo.new() return end

---@param props table
---@return ActionInteractivityInfo
function ActionInteractivityInfo.new(props) return end

---@class ActionName : ScriptableDeviceAction
ActionName = {}

---@return String
function ActionName:GetCurrentDisplayString() return end

---@return gamedeviceActionProperty[]
function ActionName:GetProperties() return end

---@class ActionNodeRef : ScriptableDeviceAction
ActionNodeRef = {}

---@return String
function ActionNodeRef:GetCurrentDisplayString() return end

---@return gamedeviceActionProperty[]
function ActionNodeRef:GetProperties() return end

---@class ActionNotifier : IScriptable
---@field external Bool
---@field internal Bool
---@field failed Bool
ActionNotifier = {}

---@return ActionNotifier
function ActionNotifier.new() return end

---@param props table
---@return ActionNotifier
function ActionNotifier.new(props) return end

---@return Bool
function ActionNotifier:IsAll() return end

---@return Bool
function ActionNotifier:IsExternalOnly() return end

---@return Bool
function ActionNotifier:IsFailed() return end

---@return Bool
function ActionNotifier:IsInternalOnly() return end

---@return Bool
function ActionNotifier:IsNone() return end

function ActionNotifier:SetAll() return end

function ActionNotifier:SetExternalOnly() return end

function ActionNotifier:SetFailed() return end

function ActionNotifier:SetInternalOnly() return end

function ActionNotifier:SetNone() return end

---@class ActionOverride : ActionBool
ActionOverride = {}

---@return ActionOverride
function ActionOverride.new() return end

---@param props table
---@return ActionOverride
function ActionOverride.new(props) return end

---@return String
function ActionOverride:GetTweakDBChoiceRecord() return end

function ActionOverride:SetProperties() return end

---@class ActionScavenge : ActionInt
ActionScavenge = {}

---@return ActionScavenge
function ActionScavenge.new() return end

---@param props table
---@return ActionScavenge
function ActionScavenge.new(props) return end

---@param device ScriptableDeviceComponentPS
---@return Bool
function ActionScavenge.IsAvailable(device) return end

---@param device ScriptableDeviceComponentPS
---@return Bool
function ActionScavenge.IsDefaultConditionMet(device) return end

---@return String
function ActionScavenge:GetTweakDBChoiceRecord() return end

---@param amoutOfScraps Int32
function ActionScavenge:SetProperties(amoutOfScraps) return end

---@class ActionSkillCheck : ActionBool
---@field skillCheck SkillCheckBase
---@field skillCheckName EDeviceChallengeSkill
---@field localizedName String
---@field skillcheckDescription UIInteractionSkillCheck
---@field wasPassed Bool
---@field availableUnpowered Bool
ActionSkillCheck = {}

---@param device ScriptableDeviceComponentPS
---@param availableUnpowered Bool
---@return Bool
function ActionSkillCheck.IsAvailable(device, availableUnpowered) return end

---@param device ScriptableDeviceComponentPS
---@param context gameGetActionsContext
---@param availableUnpowered Bool
---@return Bool
function ActionSkillCheck.IsDefaultConditionMet(device, context, availableUnpowered) return end

---@return Bool
function ActionSkillCheck:AvailableOnUnpowered() return end

---@param requester gameObject
---@param actions gamedeviceAction[]
---@param alternativeMainChoiceRecord String
---@param alternativeMainChoiceRecordID TweakDBID|string
function ActionSkillCheck:CreateInteraction(requester, actions, alternativeMainChoiceRecord, alternativeMainChoiceRecordID) return end

---@param requester gameObject
---@return UIInteractionSkillCheck
function ActionSkillCheck:CreateSkillcheckInfo(requester) return end

---@return EDeviceChallengeSkill
function ActionSkillCheck:GetAttributeCheckType() return end

---@return CName
function ActionSkillCheck:GetDefaultActionName() return end

---@param requester gameObject
---@return gameIBlackboard
function ActionSkillCheck:GetPlayerStateMachine(requester) return end

---@return UIInteractionSkillCheck
function ActionSkillCheck:GetSkillcheckInfo() return end

---@return String
function ActionSkillCheck:GetTweakDBChoiceRecord() return end

function ActionSkillCheck:ResetCaption() return end

function ActionSkillCheck:SetAvailableOnUnpowered() return end

---@param skillCheck SkillCheckBase
function ActionSkillCheck:SetProperties(skillCheck) return end

function ActionSkillCheck:SetSkillCheckReadyToPresentOnScreen() return end

---@return Bool
function ActionSkillCheck:WasPassed() return end

---@class ActionSlideToScriptProxy : CActionScriptProxy
ActionSlideToScriptProxy = {}

---@return ActionSlideToScriptProxy
function ActionSlideToScriptProxy.new() return end

---@param props table
---@return ActionSlideToScriptProxy
function ActionSlideToScriptProxy.new(props) return end

---@param gameObject gameObject
---@param duration Float
---@param ignoreNavigation Bool
---@param rotateTowardsMovementDirection Bool
---@return Bool
function ActionSlideToScriptProxy:SetupObject(gameObject, duration, ignoreNavigation, rotateTowardsMovementDirection) return end

---@param localPosition Vector4
---@param duration Float
---@param ignoreNavigation Bool
---@param rotateTowardsMovementDirection Bool
---@return Bool
function ActionSlideToScriptProxy:SetupPosition(localPosition, duration, ignoreNavigation, rotateTowardsMovementDirection) return end

---@param worldPosition Vector4
---@param duration Float
---@param ignoreNavigation Bool
---@param rotateTowardsMovementDirection Bool
---@return Bool
function ActionSlideToScriptProxy:SetupWorldPosition(worldPosition, duration, ignoreNavigation, rotateTowardsMovementDirection) return end

---@class ActionTargetInDistancePrereq : gameIScriptablePrereq
---@field targetRecord gamedataAIActionTarget_Record
---@field distance Float
---@field distanceStat gamedataStatType
---@field invert Bool
ActionTargetInDistancePrereq = {}

---@return ActionTargetInDistancePrereq
function ActionTargetInDistancePrereq.new() return end

---@param props table
---@return ActionTargetInDistancePrereq
function ActionTargetInDistancePrereq.new(props) return end

---@param recordID TweakDBID|string
function ActionTargetInDistancePrereq:Initialize(recordID) return end

---@param context IScriptable
---@return Bool
function ActionTargetInDistancePrereq:IsFulfilled(context) return end

---@param state gamePrereqState
---@param context IScriptable
function ActionTargetInDistancePrereq:OnApplied(state, context) return end

---@class ActionTargetPrereq : gameIScriptablePrereq
---@field targetRecord gamedataAIActionTarget_Record
---@field invert Bool
ActionTargetPrereq = {}

---@return ActionTargetPrereq
function ActionTargetPrereq.new() return end

---@param props table
---@return ActionTargetPrereq
function ActionTargetPrereq.new(props) return end

---@param recordID TweakDBID|string
function ActionTargetPrereq:Initialize(recordID) return end

---@param context IScriptable
---@return Bool
function ActionTargetPrereq:IsFulfilled(context) return end

---@param state gamePrereqState
---@param context IScriptable
function ActionTargetPrereq:OnApplied(state, context) return end

---@class ActionTeleportScriptProxy : CActionScriptProxy
ActionTeleportScriptProxy = {}

---@return ActionTeleportScriptProxy
function ActionTeleportScriptProxy.new() return end

---@param props table
---@return ActionTeleportScriptProxy
function ActionTeleportScriptProxy.new(props) return end

---@param targetPosition Vector4
---@param rotation Float
---@param doNavTest Bool
---@return Bool
function ActionTeleportScriptProxy:Setup(targetPosition, rotation, doNavTest) return end

---@class ActionUploadListener : gameCustomValueStatPoolsListener
---@field action ScriptableDeviceAction
---@field gameInstance ScriptGameInstance
ActionUploadListener = {}

---@return ActionUploadListener
function ActionUploadListener.new() return end

---@param props table
---@return ActionUploadListener
function ActionUploadListener.new(props) return end

---@class ActionWeightCondition : AIbehaviorconditionScript
---@field selectedActionIndex AIArgumentMapping
---@field thisIndex Int32
ActionWeightCondition = {}

---@return ActionWeightCondition
function ActionWeightCondition.new() return end

---@param props table
---@return ActionWeightCondition
function ActionWeightCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function ActionWeightCondition:Check(context) return end

---@class ActionWeightManagerDelegate : AIbehaviorScriptBehaviorDelegate
---@field actionsConditions String[]
---@field actionsWeights Int32[]
---@field lowestWeight Int32
---@field selectedActionIndex Int32
ActionWeightManagerDelegate = {}

---@return ActionWeightManagerDelegate
function ActionWeightManagerDelegate.new() return end

---@param props table
---@return ActionWeightManagerDelegate
function ActionWeightManagerDelegate.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return Bool
function ActionWeightManagerDelegate:ProcessActionToPlay(context) return end

---@return Bool
function ActionWeightManagerDelegate:WeightUpdate() return end

---@class ActionWorkSpot : ActionBool
---@field workspotTarget gamePuppet
ActionWorkSpot = {}

---@return gamePuppet
function ActionWorkSpot:GetWorkspotTarget() return end

---@param owner gameDeviceComponentPS
---@param workspotTarget gamePuppet
function ActionWorkSpot:SetUp(owner, workspotTarget) return end

---@class ActionsSequence
---@field sequenceInitiator entEntityID
---@field maxActionsInSequence Int32
---@field actionsTriggeredCount Int32
---@field delayIDs gameDelayID[]
ActionsSequence = {}

---@return ActionsSequence
function ActionsSequence.new() return end

---@param props table
---@return ActionsSequence
function ActionsSequence.new(props) return end

---@class ActionsSequencer : InteractiveMasterDevice
ActionsSequencer = {}

---@return ActionsSequencer
function ActionsSequencer.new() return end

---@param props table
---@return ActionsSequencer
function ActionsSequencer.new(props) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActionsSequencer:OnTakeControl(ri) return end

---@return ActionsSequencerController
function ActionsSequencer:GetController() return end

---@return ActionsSequencerControllerPS
function ActionsSequencer:GetDevicePS() return end

---@class ActionsSequencerController : ScriptableDeviceComponent
ActionsSequencerController = {}

---@return ActionsSequencerController
function ActionsSequencerController.new() return end

---@param props table
---@return ActionsSequencerController
function ActionsSequencerController.new(props) return end

---@return ActionsSequencerControllerPS
function ActionsSequencerController:GetPS() return end

---@class ActionsSequencerControllerPS : MasterControllerPS
---@field sequenceDuration Float
---@field sequencerMode EActionsSequencerMode
---@field actionTypeToForward SActionTypeForward
---@field ongoingSequence ActionsSequence
ActionsSequencerControllerPS = {}

---@return ActionsSequencerControllerPS
function ActionsSequencerControllerPS.new() return end

---@param props table
---@return ActionsSequencerControllerPS
function ActionsSequencerControllerPS.new(props) return end

function ActionsSequencerControllerPS:CleanupSequence() return end

---@param actionToForward ScriptableDeviceAction
---@param eligibleSlaves gameDeviceComponentPS[]
---@param delays Float[]
function ActionsSequencerControllerPS:CommenceSequence(actionToForward, eligibleSlaves, delays) return end

function ActionsSequencerControllerPS:ForceLockOnAllSlaves() return end

---@param persistentID gamePersistentID
---@param className CName|string
function ActionsSequencerControllerPS:ForceUnlockSlave(persistentID, className) return end

---@param amountOfIntervals Int32
---@param delays Float[]
function ActionsSequencerControllerPS:GetAcceleratingDelays(amountOfIntervals, delays) return end

---@param amountOfIntervals Int32
---@param delays Float[]
function ActionsSequencerControllerPS:GetDecceleratingDelays(amountOfIntervals, delays) return end

---@param intervals Int32
---@return Float[]
function ActionsSequencerControllerPS:GetDelayTimeStamps(intervals) return end

---@param sequenceInitiator gamePersistentID
---@return gameDeviceComponentPS[]
function ActionsSequencerControllerPS:GetEligibleSlaves(sequenceInitiator) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ActionsSequencerControllerPS:GetQuestActions(context) return end

---@param amountOfIntervals Int32
---@param delays Float[]
function ActionsSequencerControllerPS:GetRandomDelays(amountOfIntervals, delays) return end

---@param amountOfIntervals Int32
---@param delays Float[]
function ActionsSequencerControllerPS:GetRegularDelays(amountOfIntervals, delays) return end

function ActionsSequencerControllerPS:Initialize() return end

---@param forwardEvent ForwardAction
---@return Bool
function ActionsSequencerControllerPS:IsActionTypeMachingPreferences(forwardEvent) return end

---@return Bool
function ActionsSequencerControllerPS:IsSequenceOngoing() return end

---@param evt ActivateDevice
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnActivateDevice(evt) return end

---@param evt DeactivateDevice
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnDeactivateDevice(evt) return end

---@param evt ForwardAction
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnForwardAction(evt) return end

---@param evt QuestForceOFF
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnQuestForceOFF(evt) return end

---@param evt QuestForceON
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnQuestForceON(evt) return end

---@param evt QuestForcePower
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnQuestForcePower(evt) return end

---@param evt QuestForceUnpower
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnQuestForceUnpower(evt) return end

---@param evt SequenceCallback
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnSequenceCallback(evt) return end

---@param evt SetDeviceOFF
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnSetDeviceOFF(evt) return end

---@param evt SetDeviceON
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnSetDeviceON(evt) return end

---@param evt SetDevicePowered
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnSetDevicePowered(evt) return end

---@param evt SetDeviceUnpowered
---@return EntityNotificationType
function ActionsSequencerControllerPS:OnSetDeviceUnpowered(evt) return end

---@param forwardEvent ForwardAction
---@return Bool
function ActionsSequencerControllerPS:WasExecutedByMaster(forwardEvent) return end

---@class ActivateC4 : ActionBool
---@field itemID ItemID
ActivateC4 = {}

---@return ActivateC4
function ActivateC4.new() return end

---@param props table
---@return ActivateC4
function ActivateC4.new(props) return end

---@param device ScriptableDeviceComponentPS
---@return Bool
function ActivateC4.IsAvailable(device) return end

---@param device ScriptableDeviceComponentPS
---@param context gameGetActionsContext
---@return Bool
function ActivateC4.IsDefaultConditionMet(device, context) return end

---@return String
function ActivateC4:GetTweakDBChoiceRecord() return end

function ActivateC4:SetProperties() return end

---@class ActivateCoverDecisions : CoverActionTransition
ActivateCoverDecisions = {}

---@return ActivateCoverDecisions
function ActivateCoverDecisions.new() return end

---@param props table
---@return ActivateCoverDecisions
function ActivateCoverDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function ActivateCoverDecisions:EnterCondition(stateContext, scriptInterface) return end

---@class ActivateCoverEvents : CoverActionEventsTransition
---@field usingCover Bool
ActivateCoverEvents = {}

---@return ActivateCoverEvents
function ActivateCoverEvents.new() return end

---@param props table
---@return ActivateCoverEvents
function ActivateCoverEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function ActivateCoverEvents:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function ActivateCoverEvents:OnExit(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function ActivateCoverEvents:OnForcedExit(stateContext, scriptInterface) return end

---@param timeDelta Float
---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function ActivateCoverEvents:OnUpdate(timeDelta, stateContext, scriptInterface) return end

---@class ActivateDevice : ActionBool
---@field tweakDBChoiceName String
ActivateDevice = {}

---@return ActivateDevice
function ActivateDevice.new() return end

---@param props table
---@return ActivateDevice
function ActivateDevice.new(props) return end

---@param device ScriptableDeviceComponentPS
---@param context gameGetActionsContext
---@return Bool
function ActivateDevice.IsDefaultConditionMet(device, context) return end

---@return String
function ActivateDevice:GetTweakDBChoiceRecord() return end

---@param action_name CName|string
function ActivateDevice:SetProperties(action_name) return end

---@class ActivateLink : redEvent
ActivateLink = {}

---@return ActivateLink
function ActivateLink.new() return end

---@param props table
---@return ActivateLink
function ActivateLink.new(props) return end

---@class ActivateLinksRequest : gameScriptableSystemRequest
---@field linksIDs Int32[]
ActivateLinksRequest = {}

---@return ActivateLinksRequest
function ActivateLinksRequest.new() return end

---@param props table
---@return ActivateLinksRequest
function ActivateLinksRequest.new(props) return end

---@class ActivateMapLink : redEvent
ActivateMapLink = {}

---@return ActivateMapLink
function ActivateMapLink.new() return end

---@param props table
---@return ActivateMapLink
function ActivateMapLink.new(props) return end

---@class ActivateNetworkLinkTaskData : gameScriptTaskData
---@field linkIndex Int32
ActivateNetworkLinkTaskData = {}

---@return ActivateNetworkLinkTaskData
function ActivateNetworkLinkTaskData.new() return end

---@param props table
---@return ActivateNetworkLinkTaskData
function ActivateNetworkLinkTaskData.new(props) return end

---@class ActivatedDeviceAnimSetup
---@field animationTime Float
ActivatedDeviceAnimSetup = {}

---@return ActivatedDeviceAnimSetup
function ActivatedDeviceAnimSetup.new() return end

---@param props table
---@return ActivatedDeviceAnimSetup
function ActivatedDeviceAnimSetup.new(props) return end

---@class ActivatedDeviceController : ScriptableDeviceComponent
ActivatedDeviceController = {}

---@return ActivatedDeviceController
function ActivatedDeviceController.new() return end

---@param props table
---@return ActivatedDeviceController
function ActivatedDeviceController.new(props) return end

---@return ActivatedDeviceControllerPS
function ActivatedDeviceController:GetPS() return end

---@class ActivatedDeviceControllerPS : ScriptableDeviceComponentPS
---@field animationSetup ActivatedDeviceAnimSetup
---@field activatedDeviceSetup ActivatedDeviceSetup
---@field spiderbotInteractionLocationOverride NodeRef
---@field industrialArmAnimationOverride Int32
ActivatedDeviceControllerPS = {}

---@return ActivatedDeviceControllerPS
function ActivatedDeviceControllerPS.new() return end

---@param props table
---@return ActivatedDeviceControllerPS
function ActivatedDeviceControllerPS.new(props) return end

---@param interactionTDBID TweakDBID|string
---@return ActivateDevice
function ActivatedDeviceControllerPS:ActionActivateDevice(interactionTDBID) return end

---@param context gameGetActionsContext
---@return ActionEngineering
function ActivatedDeviceControllerPS:ActionEngineering(context) return end

---@return QuestSetIndustrialArmAnimationOverride
function ActivatedDeviceControllerPS:ActionQuestSetIndustrialArmAnimationOverride() return end

---@param toggle Bool
---@return QuestToggleAutomaticAttack
function ActivatedDeviceControllerPS:ActionQuestToggleAutomaticAttack(toggle) return end

---@param interactionTDBID TweakDBID|string
---@return ActivateDevice
function ActivatedDeviceControllerPS:ActionQuickHackActivateDevice(interactionTDBID) return end

---@param interactionTDBID TweakDBID|string
---@return QuickHackDistraction
function ActivatedDeviceControllerPS:ActionQuickHackDistraction(interactionTDBID) return end

---@param interactionTDBID TweakDBID|string
---@return SpiderbotActivateActivator
function ActivatedDeviceControllerPS:ActionSpiderbotActivateActivator(interactionTDBID) return end

function ActivatedDeviceControllerPS:ActivateThisDevice() return end

---@return Bool
function ActivatedDeviceControllerPS:CanCreateAnyQuickHackActions() return end

---@return Bool
function ActivatedDeviceControllerPS:CanCreateAnySpiderbotActions() return end

---@return CName
function ActivatedDeviceControllerPS:GetActionName() return end

---@param context gameGetActionsContext
---@return Bool, gamedeviceAction[]
function ActivatedDeviceControllerPS:GetActions(context) return end

---@return CName
function ActivatedDeviceControllerPS:GetActivationVFXname() return end

---@return Float
function ActivatedDeviceControllerPS:GetAnimationTime() return end

---@return TweakDBID
function ActivatedDeviceControllerPS:GetAttackType() return end

---@return TweakDBID
function ActivatedDeviceControllerPS:GetDeviceIconTweakDBID() return end

---@return Int32
function ActivatedDeviceControllerPS:GetIndustrialArmAnimationOverride() return end

---@param context gameGetActionsContext
---@return TweakDBID
function ActivatedDeviceControllerPS:GetInkWidgetTweakDBID(context) return end

---@return TweakDBID
function ActivatedDeviceControllerPS:GetInteractionName() return end

---@return gameObject
function ActivatedDeviceControllerPS:GetNearestViableParent() return end

---@param actionName CName|string
---@return gamedeviceAction
function ActivatedDeviceControllerPS:GetQuestActionByName(actionName) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ActivatedDeviceControllerPS:GetQuestActions(context) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ActivatedDeviceControllerPS:GetQuickHackActions(context) return end

---@return TweakDBID
function ActivatedDeviceControllerPS:GetQuickHackName() return end

---@return BaseSkillCheckContainer
function ActivatedDeviceControllerPS:GetSkillCheckContainerForSetup() return end

---@return TweakDBID
function ActivatedDeviceControllerPS:GetSpidebotInteractionName() return end

---@param outActions gamedeviceAction[]
---@param context gameGetActionsContext
function ActivatedDeviceControllerPS:GetSpiderbotActions(outActions, context) return end

---@return NodeRef
function ActivatedDeviceControllerPS:GetSpiderbotInteractionLocationOverride() return end

---@return gameFxResource
function ActivatedDeviceControllerPS:GetVFX() return end

---@return Bool
function ActivatedDeviceControllerPS:HasQuickHack() return end

---@return Bool
function ActivatedDeviceControllerPS:HasQuickHackDistraction() return end

---@return Bool
function ActivatedDeviceControllerPS:HasSpiderbotInteraction() return end

---@param evt ActionEngineering
---@return EntityNotificationType
function ActivatedDeviceControllerPS:OnActionEngineering(evt) return end

---@param evt ActivateDevice
---@return EntityNotificationType
function ActivatedDeviceControllerPS:OnActivateDevice(evt) return end

---@param evt QuestSetIndustrialArmAnimationOverride
---@return EntityNotificationType
function ActivatedDeviceControllerPS:OnQuestSetIndustrialArmAnimationOverride(evt) return end

---@param evt QuestToggleAutomaticAttack
---@return EntityNotificationType
function ActivatedDeviceControllerPS:OnQuestToggleAutomaticAttack(evt) return end

---@param evt SpiderbotActivateActivator
---@return EntityNotificationType
function ActivatedDeviceControllerPS:OnSpiderbotActivateActivator(evt) return end

---@return Bool
function ActivatedDeviceControllerPS:ShouldActivateTrapOnAreaEnter() return end

---@return Bool
function ActivatedDeviceControllerPS:ShouldGlitchOnActivation() return end

---@return Bool
function ActivatedDeviceControllerPS:ShouldRadgollOnAttack() return end

---@class ActivatedDeviceCover : ActivatedDeviceTransfromAnim
---@field offMeshConnection AIOffMeshConnectionComponent
ActivatedDeviceCover = {}

---@return ActivatedDeviceCover
function ActivatedDeviceCover.new() return end

---@param props table
---@return ActivatedDeviceCover
function ActivatedDeviceCover.new(props) return end

---@param evt ActivateDevice
---@return Bool
function ActivatedDeviceCover:OnActivateDevice(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ActivatedDeviceCover:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActivatedDeviceCover:OnTakeControl(ri) return end

---@class ActivatedDeviceIndustrialArm : ActivatedDeviceTrap
---@field loopAnimation EIndustrialArmAnimations
ActivatedDeviceIndustrialArm = {}

---@return ActivatedDeviceIndustrialArm
function ActivatedDeviceIndustrialArm.new() return end

---@param props table
---@return ActivatedDeviceIndustrialArm
function ActivatedDeviceIndustrialArm.new(props) return end

---@param evt entAreaEnteredEvent
---@return Bool
function ActivatedDeviceIndustrialArm:OnAreaEnter(evt) return end

---@param evt entAreaExitedEvent
---@return Bool
function ActivatedDeviceIndustrialArm:OnAreaExit(evt) return end

---@param evt IndustrialArmDamageEvent
---@return Bool
function ActivatedDeviceIndustrialArm:OnIndustrialArmDamageEvent(evt) return end

---@param evt QuestSetIndustrialArmAnimationOverride
---@return Bool
function ActivatedDeviceIndustrialArm:OnQuestSetIndustrialArmAnimationOverride(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ActivatedDeviceIndustrialArm:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActivatedDeviceIndustrialArm:OnTakeControl(ri) return end

---@return EGameplayRole
function ActivatedDeviceIndustrialArm:DeterminGameplayRole() return end

function ActivatedDeviceIndustrialArm:RefreshAnimation() return end

function ActivatedDeviceIndustrialArm:ResolveGameplayState() return end

---@param idleAnimNumber Int32
---@param isRotate Bool
---@param isDistraction Bool
---@param isPoke Bool
function ActivatedDeviceIndustrialArm:SendIndustrialArmAnimFeature(idleAnimNumber, isRotate, isDistraction, isPoke) return end

function ActivatedDeviceIndustrialArm:SendIndustrialArmDamageEvent() return end

---@param glitchState EGlitchState
---@param intensity Float
function ActivatedDeviceIndustrialArm:StartGlitching(glitchState, intensity) return end

function ActivatedDeviceIndustrialArm:StopGlitching() return end

---@class ActivatedDeviceNPC : ActivatedDeviceTransfromAnim
---@field hasProperAnimations Bool
ActivatedDeviceNPC = {}

---@return ActivatedDeviceNPC
function ActivatedDeviceNPC.new() return end

---@param props table
---@return ActivatedDeviceNPC
function ActivatedDeviceNPC.new(props) return end

---@param evt ActivateDevice
---@return Bool
function ActivatedDeviceNPC:OnActivateDevice(evt) return end

---@param evt gameEntitySpawnerEvent
---@return Bool
function ActivatedDeviceNPC:OnGameEntitySpawnerEvent(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ActivatedDeviceNPC:OnRequestComponents(ri) return end

---@param evt SpiderbotOrderCompletedEvent
---@return Bool
function ActivatedDeviceNPC:OnSpiderbotOrderCompletedEvent(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActivatedDeviceNPC:OnTakeControl(ri) return end

---@param componentName CName|string
---@return Bool
function ActivatedDeviceNPC:OnWorkspotFinished(componentName) return end

---@return EGameplayRole
function ActivatedDeviceNPC:DeterminGameplayRole() return end

---@param activator gameObject
---@param freeCamera Bool
---@param componentName CName|string
---@param deviceData CName|string
---@param typeOfEvent CName|string
function ActivatedDeviceNPC:EnterWorkspot(activator, freeCamera, componentName, deviceData, typeOfEvent) return end

---@return ActivatedDeviceNPCController
function ActivatedDeviceNPC:GetController() return end

---@return ActivatedDeviceNPCControllerPS
function ActivatedDeviceNPC:GetDevicePS() return end

---@class ActivatedDeviceNPCController : ScriptableDeviceComponent
ActivatedDeviceNPCController = {}

---@return ActivatedDeviceNPCController
function ActivatedDeviceNPCController.new() return end

---@param props table
---@return ActivatedDeviceNPCController
function ActivatedDeviceNPCController.new(props) return end

---@return ActivatedDeviceNPCControllerPS
function ActivatedDeviceNPCController:GetPS() return end

---@class ActivatedDeviceNPCControllerPS : ActivatedDeviceControllerPS
---@field activatedDeviceNPCSetup ActivatedDeviceNPCSetup
ActivatedDeviceNPCControllerPS = {}

---@return ActivatedDeviceNPCControllerPS
function ActivatedDeviceNPCControllerPS.new() return end

---@param props table
---@return ActivatedDeviceNPCControllerPS
function ActivatedDeviceNPCControllerPS.new(props) return end

function ActivatedDeviceNPCControllerPS:GameAttached() return end

---@return NPCPuppet
function ActivatedDeviceNPCControllerPS:GetSpawnedNPC() return end

---@param evt gameEntitySpawnerEvent
---@return EntityNotificationType
function ActivatedDeviceNPCControllerPS:OnGameEntitySpawnerEvent(evt) return end

---@class ActivatedDeviceNPCSetup
---@field npcSpawnerNodeRef NodeRef
---@field npcSpawned NPCPuppet
ActivatedDeviceNPCSetup = {}

---@return ActivatedDeviceNPCSetup
function ActivatedDeviceNPCSetup.new() return end

---@param props table
---@return ActivatedDeviceNPCSetup
function ActivatedDeviceNPCSetup.new(props) return end

---@class ActivatedDeviceSetup
---@field actionName CName
---@field disableOnActivation Bool
---@field glitchOnActivation Bool
---@field vfxResource gameFxResource
---@field activationVFXname CName
---@field hasSimpleInteraction Bool
---@field hasSpiderbotInteraction Bool
---@field hasQuickHack Bool
---@field hasQuickHackDistraction Bool
---@field alternativeInteractionName TweakDBID
---@field alternativeSpiderbotInteractionName TweakDBID
---@field alternativeQuickHackName TweakDBID
---@field activatedDeviceSkillChecks EngDemoContainer
---@field attackType TweakDBID
---@field shouldActivateTrapOnAreaEnter Bool
---@field shouldRagdollOnAttack Bool
---@field deviceWidgetRecord TweakDBID
---@field thumbnailIconRecord TweakDBID
---@field actionWidgetRecord TweakDBID
ActivatedDeviceSetup = {}

---@return ActivatedDeviceSetup
function ActivatedDeviceSetup.new() return end

---@param props table
---@return ActivatedDeviceSetup
function ActivatedDeviceSetup.new(props) return end

---@class ActivatedDeviceTransfromAnim : InteractiveDevice
---@field animationState Int32
ActivatedDeviceTransfromAnim = {}

---@return ActivatedDeviceTransfromAnim
function ActivatedDeviceTransfromAnim.new() return end

---@param props table
---@return ActivatedDeviceTransfromAnim
function ActivatedDeviceTransfromAnim.new(props) return end

---@param evt ActionEngineering
---@return Bool
function ActivatedDeviceTransfromAnim:OnActionEngineering(evt) return end

---@param evt ActivateDevice
---@return Bool
function ActivatedDeviceTransfromAnim:OnActivateDevice(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ActivatedDeviceTransfromAnim:OnRequestComponents(ri) return end

---@param evt SpiderbotOrderCompletedEvent
---@return Bool
function ActivatedDeviceTransfromAnim:OnSpiderbotOrderCompletedEvent(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActivatedDeviceTransfromAnim:OnTakeControl(ri) return end

---@param componentName CName|string
---@return Bool
function ActivatedDeviceTransfromAnim:OnWorkspotFinished(componentName) return end

---@param data SDeviceMappinData
---@return Float
function ActivatedDeviceTransfromAnim:DeterminGameplayRoleMappinRange(data) return end

---@param activator gameObject
---@param freeCamera Bool
---@param componentName CName|string
---@param deviceData CName|string
function ActivatedDeviceTransfromAnim:EnterWorkspot(activator, freeCamera, componentName, deviceData) return end

---@return ActivatedDeviceController
function ActivatedDeviceTransfromAnim:GetController() return end

---@return ActivatedDeviceControllerPS
function ActivatedDeviceTransfromAnim:GetDevicePS() return end

function ActivatedDeviceTransfromAnim:RefreshAnimation() return end

function ActivatedDeviceTransfromAnim:ResolveGameplayState() return end

---@param bool1 Bool
---@param bool2 Bool
---@param bool3 Bool
function ActivatedDeviceTransfromAnim:SendSimpleAnimFeature(bool1, bool2, bool3) return end

---@param fx gameFxResource
function ActivatedDeviceTransfromAnim:SpawnVFXs(fx) return end

---@param glitchState EGlitchState
---@param intensity Float
function ActivatedDeviceTransfromAnim:StartGlitching(glitchState, intensity) return end

function ActivatedDeviceTransfromAnim:StopGlitching() return end

---@param isDelayed Bool
---@return Bool
function ActivatedDeviceTransfromAnim:UpdateDeviceState(isDelayed) return end

---@class ActivatedDeviceTrap : ActivatedDeviceTransfromAnim
---@field areaComponent gameStaticTriggerAreaComponent
ActivatedDeviceTrap = {}

---@return ActivatedDeviceTrap
function ActivatedDeviceTrap.new() return end

---@param props table
---@return ActivatedDeviceTrap
function ActivatedDeviceTrap.new(props) return end

---@param evt ActivateDevice
---@return Bool
function ActivatedDeviceTrap:OnActivateDevice(evt) return end

---@param evt entAreaEnteredEvent
---@return Bool
function ActivatedDeviceTrap:OnAreaEnter(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ActivatedDeviceTrap:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActivatedDeviceTrap:OnTakeControl(ri) return end

---@param evt TimerEvent
---@return Bool
function ActivatedDeviceTrap:OnTimerEvent(evt) return end

function ActivatedDeviceTrap:Distract() return end

---@param attackRecord TweakDBID|string
function ActivatedDeviceTrap:DoAttack(attackRecord) return end

---@return entEntity[]
function ActivatedDeviceTrap:GetEntitiesInArea() return end

function ActivatedDeviceTrap:RefreshAnimation() return end

function ActivatedDeviceTrap:ResolveGameplayState() return end

---@class ActivatedDeviceTrapDestruction : ActivatedDeviceTrap
---@field physicalMeshNames CName[]
---@field physicalMeshes entPhysicalMeshComponent[]
---@field hideMeshNames CName[]
---@field hideMeshes entIPlacedComponent[]
---@field hitColliderNames CName[]
---@field hitColliders entIPlacedComponent[]
---@field impulseVector Vector4
---@field physicalMeshImpactVFX gameFxResource[]
---@field componentsToEnableNames CName[]
---@field componentsToEnable entIPlacedComponent[]
---@field hitCount Int32
---@field wasAttackPerformed Bool
---@field alreadyPlayedVFXComponents CName[]
---@field shouldCheckPhysicalCollisions Bool
---@field lastEntityHit IScriptable
---@field timeToActivatePhysics Float
ActivatedDeviceTrapDestruction = {}

---@return ActivatedDeviceTrapDestruction
function ActivatedDeviceTrapDestruction.new() return end

---@param props table
---@return ActivatedDeviceTrapDestruction
function ActivatedDeviceTrapDestruction.new(props) return end

---@param evt ActivateDevice
---@return Bool
function ActivatedDeviceTrapDestruction:OnActivateDevice(evt) return end

---@return Bool
function ActivatedDeviceTrapDestruction:OnGameAttached() return end

---@param evt gameeventsHitEvent
---@return Bool
function ActivatedDeviceTrapDestruction:OnHit(evt) return end

---@param evt enteventsPhysicalCollisionEvent
---@return Bool
function ActivatedDeviceTrapDestruction:OnPhysicalCollisionEvent(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ActivatedDeviceTrapDestruction:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ActivatedDeviceTrapDestruction:OnTakeControl(ri) return end

---@param evt TimerEvent
---@return Bool
function ActivatedDeviceTrapDestruction:OnTimerEvent(evt) return end

---@param evt TrapPhysicsActivationEvent
---@return Bool
function ActivatedDeviceTrapDestruction:OnTrapPhysicsActivationEvent(evt) return end

function ActivatedDeviceTrapDestruction:ActivatePhysicalMeshes() return end

function ActivatedDeviceTrapDestruction:EnableComponents() return end

---@return IScriptable
function ActivatedDeviceTrapDestruction:GetLastEntityHit() return end

function ActivatedDeviceTrapDestruction:HideMeshes() return end

function ActivatedDeviceTrapDestruction:HidePhysicalMeshes() return end

function ActivatedDeviceTrapDestruction:RefreshAnimation() return end

---@class Activator : InteractiveMasterDevice
---@field animFeature AnimFeature_SimpleDevice
---@field hitCount Int32
---@field meshComponent entMeshComponent
---@field meshAppearence CName
---@field meshAppearenceBreaking CName
---@field meshAppearenceBroken CName
---@field defaultDelay Float
---@field yellowDelay Float
---@field redDelay Float
Activator = {}

---@return Activator
function Activator.new() return end

---@param props table
---@return Activator
function Activator.new(props) return end

---@param evt panelApperanceSwitchEvent
---@return Bool
function Activator:OnDelayApperanceSwitchEvent(evt) return end

---@param evt DisassembleDevice
---@return Bool
function Activator:OnDisassembleDevice(evt) return end

---@param evt gameeventsHitEvent
---@return Bool
function Activator:OnHit(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function Activator:OnRequestComponents(ri) return end

---@param evt SpiderbotActivateActivator
---@return Bool
function Activator:OnSpiderbotActivateActivator(evt) return end

---@param evt SpiderbotOrderCompletedEvent
---@return Bool
function Activator:OnSpiderbotOrderCompletedEvent(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function Activator:OnTakeControl(ri) return end

---@param evt ToggleActivation
---@return Bool
function Activator:OnToggleActivation(evt) return end

---@param componentName CName|string
---@return Bool
function Activator:OnWorkspotFinished(componentName) return end

---@param newApperance CName|string
---@param time Float
function Activator:DelayApperanceSwitchEvent(newApperance, time) return end

---@return EGameplayRole
function Activator:DeterminGameplayRole() return end

---@param activator gameObject
---@param freeCamera Bool
---@param componentName CName|string
---@param deviceData CName|string
function Activator:EnterWorkspot(activator, freeCamera, componentName, deviceData) return end

---@return ActivatorController
function Activator:GetController() return end

---@return EGameplayRole
function Activator:GetCurrentGameplayRole() return end

---@return ActivatorControllerPS
function Activator:GetDevicePS() return end

function Activator:UpdateAnimState() return end

---@class ActivatorController : MasterController
ActivatorController = {}

---@return ActivatorController
function ActivatorController.new() return end

---@param props table
---@return ActivatorController
function ActivatorController.new(props) return end

---@return ActivatorControllerPS
function ActivatorController:GetPS() return end

---@class ActivatorControllerPS : MasterControllerPS
---@field hasSpiderbotInteraction Bool
---@field spiderbotInteractionLocationOverride NodeRef
---@field hasSimpleInteraction Bool
---@field alternativeInteractionName TweakDBID
---@field alternativeSpiderbotInteractionName TweakDBID
---@field alternativeQuickHackName TweakDBID
---@field activatorSkillChecks GenericContainer
---@field alternativeInteractionString String
ActivatorControllerPS = {}

---@return ActivatorControllerPS
function ActivatorControllerPS.new() return end

---@param props table
---@return ActivatorControllerPS
function ActivatorControllerPS.new(props) return end

---@param context gameGetActionsContext
---@return ActionDemolition
function ActivatorControllerPS:ActionDemolition(context) return end

---@param context gameGetActionsContext
---@return ActionEngineering
function ActivatorControllerPS:ActionEngineering(context) return end

---@param interactionTDBID TweakDBID|string
---@return SpiderbotActivateActivator
function ActivatorControllerPS:ActionSpiderbotActivateActivator(interactionTDBID) return end

---@param interactionTDBID TweakDBID|string
---@return ToggleActivation
function ActivatorControllerPS:ActionToggleActivation(interactionTDBID) return end

function ActivatorControllerPS:ActivateConnectedDevices() return end

---@return Bool
function ActivatorControllerPS:CanCreateAnyQuickHackActions() return end

---@return Bool
function ActivatorControllerPS:CanCreateAnySpiderbotActions() return end

function ActivatorControllerPS:GameAttached() return end

---@param context gameGetActionsContext
---@return Bool, gamedeviceAction[]
function ActivatorControllerPS:GetActions(context) return end

---@param actionName CName|string
---@return gamedeviceAction
function ActivatorControllerPS:GetQuestActionByName(actionName) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ActivatorControllerPS:GetQuestActions(context) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ActivatorControllerPS:GetQuickHackActions(context) return end

---@return BaseSkillCheckContainer
function ActivatorControllerPS:GetSkillCheckContainerForSetup() return end

---@param actions gamedeviceAction[]
---@param context gameGetActionsContext
function ActivatorControllerPS:GetSpiderbotActions(actions, context) return end

---@return NodeRef
function ActivatorControllerPS:GetSpiderbotInteractionLocationOverride() return end

---@param evt ActionDemolition
---@return EntityNotificationType
function ActivatorControllerPS:OnActionDemolition(evt) return end

---@param evt ActionEngineering
---@return EntityNotificationType
function ActivatorControllerPS:OnActionEngineering(evt) return end

---@param evt DisassembleDevice
---@return EntityNotificationType
function ActivatorControllerPS:OnDisassembleDevice(evt) return end

---@param evt QuestForceActivate
---@return EntityNotificationType
function ActivatorControllerPS:OnQuestForceActivate(evt) return end

---@param evt SpiderbotActivateActivator
---@return EntityNotificationType
function ActivatorControllerPS:OnSpiderbotActivateActivator(evt) return end

---@param evt ToggleActivation
---@return EntityNotificationType
function ActivatorControllerPS:OnToggleActivation(evt) return end

---@param evt ActionHacking
function ActivatorControllerPS:ResolveActionHackingCompleted(evt) return end

---@class ActivatorOperationTriggerData : DeviceOperationTriggerData
ActivatorOperationTriggerData = {}

---@return ActivatorOperationTriggerData
function ActivatorOperationTriggerData.new() return end

---@param props table
---@return ActivatorOperationTriggerData
function ActivatorOperationTriggerData.new(props) return end

---@class ActivatorOperationsTrigger : DeviceOperationsTrigger
---@field triggerData ActivatorOperationTriggerData
ActivatorOperationsTrigger = {}

---@return ActivatorOperationsTrigger
function ActivatorOperationsTrigger.new() return end

---@param props table
---@return ActivatorOperationsTrigger
function ActivatorOperationsTrigger.new(props) return end

---@param owner gameObject
---@param container DeviceOperationsContainer
function ActivatorOperationsTrigger:EvaluateTrigger(owner, container) return end

---@class ActivePerkChangedEvent : redEvent
---@field perkArea gamedataPerkArea
---@field perkType gamedataPerkType
ActivePerkChangedEvent = {}

---@return ActivePerkChangedEvent
function ActivePerkChangedEvent.new() return end

---@param props table
---@return ActivePerkChangedEvent
function ActivePerkChangedEvent.new(props) return end

---@class ActiveSkillScreenChangedEvent : redEvent
ActiveSkillScreenChangedEvent = {}

---@return ActiveSkillScreenChangedEvent
function ActiveSkillScreenChangedEvent.new() return end

---@param props table
---@return ActiveSkillScreenChangedEvent
function ActiveSkillScreenChangedEvent.new(props) return end

---@class ActivityCardsHelper : IScriptable
ActivityCardsHelper = {}

---@return ActivityCardsHelper
function ActivityCardsHelper.new() return end

---@param props table
---@return ActivityCardsHelper
function ActivityCardsHelper.new(props) return end

---@return Bool
function ActivityCardsHelper:CanPlayerSkipTime() return end

---@return String
function ActivityCardsHelper:GetCurrentDisctrictName() return end

---@class AdHocAnimationDecisions : UpperBodyEventsTransition
AdHocAnimationDecisions = {}

---@return AdHocAnimationDecisions
function AdHocAnimationDecisions.new() return end

---@param props table
---@return AdHocAnimationDecisions
function AdHocAnimationDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AdHocAnimationDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@return Float
function AdHocAnimationDecisions:GetAnimationDuration(scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AdHocAnimationDecisions:ToEmptyHands(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AdHocAnimationDecisions:ToSingleWield(stateContext, scriptInterface) return end

---@class AdHocAnimationDef : gamebbScriptDefinition
---@field IsActive gamebbScriptID_Bool
---@field AnimationIndex gamebbScriptID_Int32
---@field UseBothHands gamebbScriptID_Bool
---@field UnequipWeapon gamebbScriptID_Bool
---@field AnimationDuration gamebbScriptID_Float
AdHocAnimationDef = {}

---@return AdHocAnimationDef
function AdHocAnimationDef.new() return end

---@param props table
---@return AdHocAnimationDef
function AdHocAnimationDef.new(props) return end

---@return Bool
function AdHocAnimationDef:AutoCreateInSystem() return end

---@class AdHocAnimationEvent : redEvent
---@field animationIndex Int32
---@field useBothHands Bool
---@field unequipWeapon Bool
---@field animationDuration Float
AdHocAnimationEvent = {}

---@return AdHocAnimationEvent
function AdHocAnimationEvent.new() return end

---@param props table
---@return AdHocAnimationEvent
function AdHocAnimationEvent.new(props) return end

---@class AdHocAnimationEvents : TemporaryUnequipEvents
AdHocAnimationEvents = {}

---@return AdHocAnimationEvents
function AdHocAnimationEvents.new() return end

---@param props table
---@return AdHocAnimationEvents
function AdHocAnimationEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AdHocAnimationEvents:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AdHocAnimationEvents:OnExit(stateContext, scriptInterface) return end

---@class AdamSmasherComponent : gameScriptableComponent
---@field owner NPCPuppet
---@field owner_id entEntityID
---@field statusEffect_armor1_id TweakDBID
---@field statusEffect_armor2_id TweakDBID
---@field statusEffect_armor3_id TweakDBID
---@field statusEffect_smashed_id TweakDBID
---@field statPoolSystem gameStatPoolsSystem
---@field statPoolType gamedataStatPoolType
---@field healthListener AdamSmasherHealthChangeListener
---@field phase2Threshold Float
---@field phase3Threshold Float
---@field npcCollisionComponent entSimpleColliderComponent
---@field targetTrackerComponent AITargetTrackerComponent
---@field weakspotDestroyed Bool
AdamSmasherComponent = {}

---@return AdamSmasherComponent
function AdamSmasherComponent.new() return end

---@param props table
---@return AdamSmasherComponent
function AdamSmasherComponent.new(props) return end

---@return Float
function AdamSmasherComponent.GetDefeatedHealthValue() return end

---@return Float
function AdamSmasherComponent.GetEmergencyPhaseHealthValue() return end

---@return Float
function AdamSmasherComponent.GetPhase2HealthValue() return end

---@return Float
function AdamSmasherComponent.GetPhase3HealthValue() return end

---@return Float
function AdamSmasherComponent.GetRemovePlateHealthValue() return end

---@param evt entAudioEvent
---@return Bool
function AdamSmasherComponent:OnAudioEvent(evt) return end

---@param evt gameeventsDeathEvent
---@return Bool
function AdamSmasherComponent:OnDeathAfterDefeatedSmasher(evt) return end

---@param evt gameeventsDefeatedEvent
---@return Bool
function AdamSmasherComponent:OnDefeated(evt) return end

---@param evt DisableWeakspotDelayedEvent
---@return Bool
function AdamSmasherComponent:OnDisableWeakspotDelayedEvent(evt) return end

---@param enableColliderEvent EnableColliderDelayEvent
---@return Bool
function AdamSmasherComponent:OnEnableColliderDelayEvent(enableColliderEvent) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AdamSmasherComponent:OnRequestComponents(ri) return end

---@param evt gameeventsApplyStatusEffectEvent
---@return Bool
function AdamSmasherComponent:OnStatusEffectApplied(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AdamSmasherComponent:OnTakeControl(ri) return end

function AdamSmasherComponent:ApplyNoInterrupt() return end

function AdamSmasherComponent:ApplySmashed() return end

function AdamSmasherComponent:DisableAllDefeatedHitShapes() return end

function AdamSmasherComponent:DisableAllHitShapes() return end

function AdamSmasherComponent:DisableFrontPlate() return end

function AdamSmasherComponent:DisableRipInteractionLayer() return end

function AdamSmasherComponent:DisableWeakspots() return end

function AdamSmasherComponent:EnableDefeatedHitShapes() return end

function AdamSmasherComponent:EnableRipInteractionLayer() return end

function AdamSmasherComponent:EnableTorsoWeakspot() return end

function AdamSmasherComponent:OnDeactivate() return end

function AdamSmasherComponent:OnGameAttach() return end

function AdamSmasherComponent:OnGameDetach() return end

---@param target NPCPuppet
---@param valueToSet Float
function AdamSmasherComponent:SetHealth(target, valueToSet) return end

---@param value Float
function AdamSmasherComponent:SetPercentLifeForPhase(value) return end

---@class AdamSmasherHealthChangeListener : gameCustomValueStatPoolsListener
---@field owner NPCPuppet
---@field player PlayerPuppet
---@field adamSmasherComponent AdamSmasherComponent
---@field statPoolType gamedataStatPoolType
---@field statPoolSystem gameStatPoolsSystem
AdamSmasherHealthChangeListener = {}

---@return AdamSmasherHealthChangeListener
function AdamSmasherHealthChangeListener.new() return end

---@param props table
---@return AdamSmasherHealthChangeListener
function AdamSmasherHealthChangeListener.new(props) return end

function AdamSmasherHealthChangeListener:ApplyEmergency() return end

function AdamSmasherHealthChangeListener:ApplyPhase2() return end

function AdamSmasherHealthChangeListener:ApplyPhase3() return end

function AdamSmasherHealthChangeListener:ApplySmashed() return end

---@param oldValue Float
---@param newValue Float
---@param percToPoints Float
function AdamSmasherHealthChangeListener:CheckPhase(oldValue, newValue, percToPoints) return end

function AdamSmasherHealthChangeListener:DestroyWeakspotGenerator() return end

function AdamSmasherHealthChangeListener:DisableFrontPlate() return end

function AdamSmasherHealthChangeListener:DisableLauncherWeakspot() return end

function AdamSmasherHealthChangeListener:DisableRightArm() return end

function AdamSmasherHealthChangeListener:DisableTorsoWeakspot() return end

function AdamSmasherHealthChangeListener:EnableHeadWeakspot() return end

function AdamSmasherHealthChangeListener:EnableLauncherWeakspot() return end

function AdamSmasherHealthChangeListener:EnableTorsoWeakspot() return end

---@param oldValue Float
---@param newValue Float
---@param percToPoints Float
function AdamSmasherHealthChangeListener:OnStatPoolValueChanged(oldValue, newValue, percToPoints) return end

function AdamSmasherHealthChangeListener:RemoveEmergency() return end

---@class AddAchievementRequest : gamePlayerScriptableSystemRequest
---@field achievement gamedataAchievement
---@field achievementRecord gamedataAchievement_Record
AddAchievementRequest = {}

---@return AddAchievementRequest
function AddAchievementRequest.new() return end

---@param props table
---@return AddAchievementRequest
function AddAchievementRequest.new(props) return end

---@class AddActiveContextEvent : redEvent
---@field context gamedeviceRequestType
AddActiveContextEvent = {}

---@return AddActiveContextEvent
function AddActiveContextEvent.new() return end

---@param props table
---@return AddActiveContextEvent
function AddActiveContextEvent.new(props) return end

---@class AddActiveStimuli : AIbehaviortaskScript
---@field stimType gamedataStimType
---@field lifetime Float
AddActiveStimuli = {}

---@return AddActiveStimuli
function AddActiveStimuli.new() return end

---@param props table
---@return AddActiveStimuli
function AddActiveStimuli.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AddActiveStimuli:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AddActiveStimuli:Deactivate(context) return end

---@class AddDevelopmentPointEffector : gameEffector
---@field amount Int32
---@field type gamedataDevelopmentPointType
---@field tdbid TweakDBID
AddDevelopmentPointEffector = {}

---@return AddDevelopmentPointEffector
function AddDevelopmentPointEffector.new() return end

---@param props table
---@return AddDevelopmentPointEffector
function AddDevelopmentPointEffector.new(props) return end

---@param owner gameObject
function AddDevelopmentPointEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function AddDevelopmentPointEffector:Initialize(record, parentRecord) return end

---@class AddExperience : gamePlayerScriptableSystemRequest
---@field amount Int32
---@field experienceType gamedataProficiencyType
---@field debug Bool
AddExperience = {}

---@return AddExperience
function AddExperience.new() return end

---@param props table
---@return AddExperience
function AddExperience.new(props) return end

---@param _owner gameObject
---@param expAmount Int32
---@param type gamedataProficiencyType
---@param isDebug Bool
function AddExperience:Set(_owner, expAmount, type, isDebug) return end

---@class AddForceHighlightTargetEvent : redEvent
---@field targetID entEntityID
---@field effecName CName
AddForceHighlightTargetEvent = {}

---@return AddForceHighlightTargetEvent
function AddForceHighlightTargetEvent.new() return end

---@param props table
---@return AddForceHighlightTargetEvent
function AddForceHighlightTargetEvent.new(props) return end

---@class AddHitFlagToAttackEffector : ModifyAttackEffector
---@field hitFlag hitFlag
AddHitFlagToAttackEffector = {}

---@return AddHitFlagToAttackEffector
function AddHitFlagToAttackEffector.new() return end

---@param props table
---@return AddHitFlagToAttackEffector
function AddHitFlagToAttackEffector.new(props) return end

---@param owner gameObject
function AddHitFlagToAttackEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function AddHitFlagToAttackEffector:Initialize(record, parentRecord) return end

function AddHitFlagToAttackEffector:ProcessEffector() return end

---@param owner gameObject
function AddHitFlagToAttackEffector:RepeatedAction(owner) return end

function AddHitFlagToAttackEffector:Uninitialize() return end

---@class AddInvestigatorEvent : redEvent
---@field investigator entEntityID
AddInvestigatorEvent = {}

---@return AddInvestigatorEvent
function AddInvestigatorEvent.new() return end

---@param props table
---@return AddInvestigatorEvent
function AddInvestigatorEvent.new(props) return end

---@class AddItemForPlayerToPickUp : ScriptableDeviceAction
---@field lootTable TweakDBID
---@field shouldAdd Bool
AddItemForPlayerToPickUp = {}

---@return AddItemForPlayerToPickUp
function AddItemForPlayerToPickUp.new() return end

---@param props table
---@return AddItemForPlayerToPickUp
function AddItemForPlayerToPickUp.new(props) return end

---@return String
function AddItemForPlayerToPickUp:GetFriendlyDescription() return end

---@class AddItemToVendorRequest : gameScriptableSystemRequest
---@field vendorID TweakDBID
---@field itemToAddID TweakDBID
---@field quantity Int32
AddItemToVendorRequest = {}

---@return AddItemToVendorRequest
function AddItemToVendorRequest.new() return end

---@param props table
---@return AddItemToVendorRequest
function AddItemToVendorRequest.new(props) return end

---@return String
function AddItemToVendorRequest:GetFriendlyDescription() return end

---@class AddItemsEffector : gameEffector
---@field items gamedataInventoryItem_Record[]
AddItemsEffector = {}

---@return AddItemsEffector
function AddItemsEffector.new() return end

---@param props table
---@return AddItemsEffector
function AddItemsEffector.new(props) return end

---@param owner gameObject
function AddItemsEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function AddItemsEffector:Initialize(record, parentRecord) return end

---@class AddNewPerkPoints : NewPerkPoinsActionRequest
AddNewPerkPoints = {}

---@return AddNewPerkPoints
function AddNewPerkPoints.new() return end

---@param props table
---@return AddNewPerkPoints
function AddNewPerkPoints.new(props) return end

---@class AddOrRemoveListenerEvent : redEvent
---@field listener PuppetListener
---@field add Bool
AddOrRemoveListenerEvent = {}

---@return AddOrRemoveListenerEvent
function AddOrRemoveListenerEvent.new() return end

---@param props table
---@return AddOrRemoveListenerEvent
function AddOrRemoveListenerEvent.new(props) return end

---@class AddOrRemoveListenerForGOEvent : redEvent
---@field listener GameObjectListener
---@field shouldAdd Bool
AddOrRemoveListenerForGOEvent = {}

---@return AddOrRemoveListenerForGOEvent
function AddOrRemoveListenerForGOEvent.new() return end

---@param props table
---@return AddOrRemoveListenerForGOEvent
function AddOrRemoveListenerForGOEvent.new(props) return end

---@class AddPingedSquadRequest : gameScriptableSystemRequest
---@field squadName CName
AddPingedSquadRequest = {}

---@return AddPingedSquadRequest
function AddPingedSquadRequest.new() return end

---@param props table
---@return AddPingedSquadRequest
function AddPingedSquadRequest.new(props) return end

---@class AddRecipeRequest : gamePlayerScriptableSystemRequest
---@field recipe TweakDBID
---@field amount Int32
---@field hideOnItemsAdded gamedataItem_Record[]
AddRecipeRequest = {}

---@return AddRecipeRequest
function AddRecipeRequest.new() return end

---@param props table
---@return AddRecipeRequest
function AddRecipeRequest.new(props) return end

---@class AddSpyTreePerkPoints : NewPerkPoinsActionRequest
AddSpyTreePerkPoints = {}

---@return AddSpyTreePerkPoints
function AddSpyTreePerkPoints.new() return end

---@param props table
---@return AddSpyTreePerkPoints
function AddSpyTreePerkPoints.new(props) return end

---@class AddSpyTreePowerUpPerkPoints : NewPerkPoinsActionRequest
AddSpyTreePowerUpPerkPoints = {}

---@return AddSpyTreePowerUpPerkPoints
function AddSpyTreePowerUpPerkPoints.new() return end

---@param props table
---@return AddSpyTreePowerUpPerkPoints
function AddSpyTreePowerUpPerkPoints.new(props) return end

---@class AddStatusEffectListenerEvent : redEvent
---@field listener StatusEffectTriggerListener
AddStatusEffectListenerEvent = {}

---@return AddStatusEffectListenerEvent
function AddStatusEffectListenerEvent.new() return end

---@param props table
---@return AddStatusEffectListenerEvent
function AddStatusEffectListenerEvent.new(props) return end

---@class AddStatusEffectToAttackEffector : ModifyAttackEffector
---@field isRandom Bool
---@field applicationChanceMods gamedataStatModifier_Record[]
---@field statusEffect SHitStatusEffect
---@field stacks Float
AddStatusEffectToAttackEffector = {}

---@return AddStatusEffectToAttackEffector
function AddStatusEffectToAttackEffector.new() return end

---@param props table
---@return AddStatusEffectToAttackEffector
function AddStatusEffectToAttackEffector.new(props) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function AddStatusEffectToAttackEffector:Initialize(record, parentRecord) return end

---@param owner gameObject
function AddStatusEffectToAttackEffector:RepeatedAction(owner) return end

function AddStatusEffectToAttackEffector:Uninitialize() return end

---@class AddSubCharacterRequest : gameScriptableSystemRequest
---@field subCharObject ScriptedPuppet
AddSubCharacterRequest = {}

---@return AddSubCharacterRequest
function AddSubCharacterRequest.new() return end

---@param props table
---@return AddSubCharacterRequest
function AddSubCharacterRequest.new(props) return end

---@class AddTargetToHighlightEvent : redEvent
---@field target CombatTarget
AddTargetToHighlightEvent = {}

---@return AddTargetToHighlightEvent
function AddTargetToHighlightEvent.new() return end

---@param props table
---@return AddTargetToHighlightEvent
function AddTargetToHighlightEvent.new(props) return end

---@param puppet ScriptedPuppet
function AddTargetToHighlightEvent:Create(puppet) return end

---@param puppet ScriptedPuppet
---@param highlightTime Float
function AddTargetToHighlightEvent:Create(puppet, highlightTime) return end

---@class AddToBlacklistEvent : redEvent
---@field entityIDToAdd entEntityID
---@field isPlayerEntity Bool
---@field reason BlacklistReason
AddToBlacklistEvent = {}

---@return AddToBlacklistEvent
function AddToBlacklistEvent.new() return end

---@param props table
---@return AddToBlacklistEvent
function AddToBlacklistEvent.new(props) return end

---@class AddUserEvent : redEvent
---@field userEntry SecuritySystemClearanceEntry
AddUserEvent = {}

---@return AddUserEvent
function AddUserEvent.new() return end

---@param props table
---@return AddUserEvent
function AddUserEvent.new(props) return end

---@class AddWeapon : AIbehaviortaskScript
---@field weapon EquipmentPriority
AddWeapon = {}

---@return AddWeapon
function AddWeapon.new() return end

---@param props table
---@return AddWeapon
function AddWeapon.new(props) return end

---@param puppet ScriptedPuppet
---@param weapon EquipmentPriority
function AddWeapon.Execute(puppet, weapon) return end

---@param puppet ScriptedPuppet
function AddWeapon.ExecuteForAllWeapons(puppet) return end

---@param context AIbehaviorScriptExecutionContext
function AddWeapon:Activate(context) return end

---@class AdjustAnimWrappersForDeescalatingFearPhase : AIbehaviortaskScript
AdjustAnimWrappersForDeescalatingFearPhase = {}

---@return AdjustAnimWrappersForDeescalatingFearPhase
function AdjustAnimWrappersForDeescalatingFearPhase.new() return end

---@param props table
---@return AdjustAnimWrappersForDeescalatingFearPhase
function AdjustAnimWrappersForDeescalatingFearPhase.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AdjustAnimWrappersForDeescalatingFearPhase:Activate(context) return end

---@class AdjustAnimWrappersForEscalatingFearPhase : AIbehaviortaskScript
AdjustAnimWrappersForEscalatingFearPhase = {}

---@return AdjustAnimWrappersForEscalatingFearPhase
function AdjustAnimWrappersForEscalatingFearPhase.new() return end

---@param props table
---@return AdjustAnimWrappersForEscalatingFearPhase
function AdjustAnimWrappersForEscalatingFearPhase.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AdjustAnimWrappersForEscalatingFearPhase:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AdjustAnimWrappersForEscalatingFearPhase:Deactivate(context) return end

---@class AdjustAnimWrappersForEscalatingPanicPhase : AIbehaviortaskScript
AdjustAnimWrappersForEscalatingPanicPhase = {}

---@return AdjustAnimWrappersForEscalatingPanicPhase
function AdjustAnimWrappersForEscalatingPanicPhase.new() return end

---@param props table
---@return AdjustAnimWrappersForEscalatingPanicPhase
function AdjustAnimWrappersForEscalatingPanicPhase.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AdjustAnimWrappersForEscalatingPanicPhase:Activate(context) return end

---@class AdvanceChangeLightEvent : redEvent
---@field settings EditableGameLightSettings
---@field time Float
---@field curve CName
---@field loop Bool
AdvanceChangeLightEvent = {}

---@return AdvanceChangeLightEvent
function AdvanceChangeLightEvent.new() return end

---@param props table
---@return AdvanceChangeLightEvent
function AdvanceChangeLightEvent.new(props) return end

---@class AdvanceInteractionStateResolveEvent : redEvent
---@field toggle Bool
AdvanceInteractionStateResolveEvent = {}

---@return AdvanceInteractionStateResolveEvent
function AdvanceInteractionStateResolveEvent.new() return end

---@param props table
---@return AdvanceInteractionStateResolveEvent
function AdvanceInteractionStateResolveEvent.new(props) return end

---@class AdvertisementWidgetComponent : IWorldWidgetComponent
---@field format AdvertisementFormat
---@field adGroupTDBID TweakDBID
---@field enableOverride Bool
---@field adOverrideTDBID TweakDBID
---@field adVersion Uint32
---@field useOnlyAttachedLights Bool
AdvertisementWidgetComponent = {}

---@return AdvertisementWidgetComponent
function AdvertisementWidgetComponent.new() return end

---@param props table
---@return AdvertisementWidgetComponent
function AdvertisementWidgetComponent.new(props) return end

function AdvertisementWidgetComponent:GetLocalizedDescription() return end

---@class Agent
---@field link DeviceLink
---@field reprimands ReprimandData[]
---@field supportingAgents gamePersistentID[]
---@field areas DeviceLink[]
---@field incomingFilter EFilterType
---@field cachedDelayDuration Float
Agent = {}

---@return Agent
function Agent.new() return end

---@param props table
---@return Agent
function Agent.new(props) return end

---@param self_ Agent
---@param area SecurityAreaControllerPS
function Agent.AddArea(self_, area) return end

---@param self_ Agent
---@param id gamePersistentID
---@param shouldAdd Bool
---@return Bool
function Agent.AddSupport(self_, id, shouldAdd) return end

---@param self_ Agent
function Agent.ClearSupport(self_) return end

---@param link DeviceLink
---@param areas SecurityAreaControllerPS[]
---@return Agent
function Agent.Construct(link, areas) return end

---@param self_ Agent
function Agent.ForceRelaseReprimands(self_) return end

---@param self_ Agent
---@param areas DeviceLink[]
function Agent.GetAreas(self_, areas) return end

---@param self_ Agent
---@return entEntityID
function Agent.GetReprimandReceiver(self_) return end

---@param self_ Agent
---@param target entEntityID
---@return Int32
function Agent.GetReprimandsCount(self_, target) return end

---@param self_ Agent
---@return Bool
function Agent.HasSupport(self_) return end

---@param self_ Agent
---@param state ESecuritySystemState
---@param breachedAreas SecurityAreaControllerPS[]
---@param inputsOutgoingFilter EFilterType
---@return Bool, EBreachOrigin
function Agent.IsEligible(self_, state, breachedAreas, inputsOutgoingFilter) return end

---@param self_ Agent
---@param state ESecuritySystemState
---@param breachedAreas SecurityAreaControllerPS[]
---@param inputsOutgoingFilter EFilterType
---@return Bool
function Agent.IsEligibleToShareData(self_, state, breachedAreas, inputsOutgoingFilter) return end

---@param self_ Agent
---@return Bool
function Agent.IsPerformingReprimand(self_) return end

---@param self_ Agent
---@param target entEntityID
---@return Bool
function Agent.IsPerformingReprimandAgainst(self_, target) return end

---@param self_ Agent
---@return Bool
function Agent.IsValid(self_) return end

---@param self_ Agent
---@param target entEntityID
function Agent.ReleaseFromReprimand(self_, target) return end

---@param self_ Agent
---@param remainingAreas SecurityAreaControllerPS[]
function Agent.RemoveArea(self_, remainingAreas) return end

---@param self_ Agent
---@param area SecurityAreaControllerPS
function Agent.SetIncomingFilter(self_, area) return end

---@param self_ Agent
---@param areas SecurityAreaControllerPS[]
function Agent.SetIncomingFilter(self_, areas) return end

---@param self_ Agent
---@param reprimandData ReprimandData
function Agent.StoreReprimand(self_, reprimandData) return end

---@param self_ Agent
---@param attGroup CName|string
---@param attSystem gameCAttitudeManager
function Agent.WipeReprimand(self_, attGroup, attSystem) return end

---@param self_ Agent
---@param target entEntityID
function Agent.WipeReprimand(self_, target) return end

---@class AgentBase : IScriptable
---@field id entEntityID
---@field gameObject gameObject
---@field spawnedType gameDynamicVehicleType
AgentBase = {}

---@return AgentBase
function AgentBase.new() return end

---@param props table
---@return AgentBase
function AgentBase.new(props) return end

---@class AgentDistanceToTarget
---@field distance Float
---@field index Int32
AgentDistanceToTarget = {}

---@return AgentDistanceToTarget
function AgentDistanceToTarget.new() return end

---@param props table
---@return AgentDistanceToTarget
function AgentDistanceToTarget.new(props) return end

---@class AgentMovingHitPrereqCondition : BaseHitPrereqCondition
---@field isMoving Bool
---@field object CName
AgentMovingHitPrereqCondition = {}

---@return AgentMovingHitPrereqCondition
function AgentMovingHitPrereqCondition.new() return end

---@param props table
---@return AgentMovingHitPrereqCondition
function AgentMovingHitPrereqCondition.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function AgentMovingHitPrereqCondition:Evaluate(hitEvent) return end

---@param recordID TweakDBID|string
function AgentMovingHitPrereqCondition:SetData(recordID) return end

---@class AgentRegistry : IScriptable
---@field isInitialized Bool
---@field agents Agent[]
---@field agentsLock ScriptReentrantRWLock
---@field maxReprimandsPerNPC Int32
---@field maxReprimandsPerDEVICE Int32
AgentRegistry = {}

---@return AgentRegistry
function AgentRegistry.new() return end

---@param props table
---@return AgentRegistry
function AgentRegistry.new(props) return end

---@return AgentRegistry
function AgentRegistry.Construct() return end

---@param area SecurityAreaControllerPS
---@param agents gameDeviceComponentPS[]
function AgentRegistry:AddArea(area, agents) return end

---@param newGroup CName|string
function AgentRegistry:CleanUpOnNewAttitudeGroup(newGroup) return end

function AgentRegistry:ClearSupport() return end

---@param id gamePersistentID
---@param recordCopy Agent
---@return Bool
function AgentRegistry:GetAgent(id, recordCopy) return end

---@param id gamePersistentID
---@return DeviceLink[]
function AgentRegistry:GetAgentAreas(id) return end

---@param id gamePersistentID
---@return Bool, Int32
function AgentRegistry:GetAgentIndex(id) return end

---@param id gamePersistentID
---@return Bool, Int32
function AgentRegistry:GetAgentIndex_NoLock(id) return end

---@return Agent[]
function AgentRegistry:GetAgents() return end

---@param filter SecurityAreaControllerPS[]
---@return Agent[]
function AgentRegistry:GetAgents(filter) return end

---@return gamePersistentID[]
function AgentRegistry:GetAgentsIDs() return end

---@param filter SecurityAreaControllerPS[]
---@return gamePersistentID[]
function AgentRegistry:GetAgentsIDs(filter) return end

---@param target entEntityID
---@param agent Agent
---@return Bool
function AgentRegistry:GetReprimandPerformer(target, agent) return end

---@param agentID gamePersistentID
---@return entEntityID
function AgentRegistry:GetReprimandReceiver(agentID) return end

---@return Agent[]
function AgentRegistry:GetSensors() return end

---@return Agent[]
function AgentRegistry:GetSupportedAgents() return end

---@return Agent[]
function AgentRegistry:GetTurrets() return end

---@param state ESecuritySystemState
---@param breachedAreas SecurityAreaControllerPS[]
---@return SecuritySystemOutputData[]
function AgentRegistry:GetValidAgents(state, breachedAreas) return end

---@param agent gamePersistentID
---@param target entEntityID
---@return Bool
function AgentRegistry:HasEntityBeenSpottedTooManyTimes(agent, target) return end

---@param target entEntityID
---@param agentID gamePersistentID
---@return Int32
function AgentRegistry:HowManyTimesEntityReprimandedByThisAgentAlready(target, agentID) return end

---@param tresspasser gameObject
---@param agent gamePersistentID
---@return Int32
function AgentRegistry:HowManyTimesEntityReprimandedByThisAgentAlready(tresspasser, agent) return end

---@param id gamePersistentID
---@return Bool
function AgentRegistry:IsAgent(id) return end

---@param index Int32
---@return Bool
function AgentRegistry:IsIndexOutOfBound(index) return end

---@return Bool
function AgentRegistry:IsInitialized() return end

---@return Bool
function AgentRegistry:IsReady() return end

---@return Bool
function AgentRegistry:IsReprimandOngoing() return end

---@param suspect entEntityID
---@return Bool
function AgentRegistry:IsReprimandOngoingAgainst(suspect) return end

---@param evt PlayerSpotted
---@param modifiedAgents Agent[]
---@return Bool, Bool
function AgentRegistry:ProcessOnPlayerSpotted(evt, modifiedAgents) return end

---@param agentPS DeviceLink
---@param areas SecurityAreaControllerPS[]
function AgentRegistry:RegisterAgent(agentPS, areas) return end

---@param agents Agent[]
function AgentRegistry:ReleaseAllReprimands(agents) return end

---@param target entEntityID
---@param agent gamePersistentID
function AgentRegistry:ReleaseFromReprimandAgainst(target, agent) return end

---@param data OnDisableAreaData[]
function AgentRegistry:RemoveArea(data) return end

---@param agent Agent
function AgentRegistry:SaveAgent_NoLock(agent) return end

---@param agentID gamePersistentID
---@param target entEntityID
---@param reprimandID Int32
---@param targetAttitude CName|string
function AgentRegistry:StoreReprimand(agentID, target, reprimandID, targetAttitude) return end

---@param agentID gamePersistentID
function AgentRegistry:UnregisterAgent(agentID) return end

---@param target entEntityID
function AgentRegistry:WipeReprimandData(target) return end

---@class AiControlledDecisions : HighLevelTransition
AiControlledDecisions = {}

---@return AiControlledDecisions
function AiControlledDecisions.new() return end

---@param props table
---@return AiControlledDecisions
function AiControlledDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AiControlledDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AiControlledDecisions:ExitCondition(stateContext, scriptInterface) return end

---@class AiControlledEvents : HighLevelTransition
AiControlledEvents = {}

---@return AiControlledEvents
function AiControlledEvents.new() return end

---@param props table
---@return AiControlledEvents
function AiControlledEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AiControlledEvents:OnEnter(stateContext, scriptInterface) return end

---@class AimAssist : ModuleInstance
AimAssist = {}

---@return AimAssist
function AimAssist.new() return end

---@param props table
---@return AimAssist
function AimAssist.new(props) return end

---@class AimAssistModule : HUDModule
---@field activeAssists AimAssist[]
AimAssistModule = {}

---@return AimAssistModule
function AimAssistModule.new() return end

---@param props table
---@return AimAssistModule
function AimAssistModule.new(props) return end

---@class AimAssistSettingsListener : userSettingsVarListener
---@field ctrl PlayerPuppet
---@field settings userSettingsUserSettings
---@field settingsGroup userSettingsGroup
---@field aimAssistLevel EAimAssistLevel
---@field aimAssistMeleeLevel EAimAssistLevel
---@field aimAssistDriverCombatEnabled Bool
---@field aimAssistSnapEnabled Bool
---@field currentConfig AimAssistSettingConfig
---@field settingsRecords gamedataAimAssistSettings_Record[]
AimAssistSettingsListener = {}

---@return AimAssistSettingsListener
function AimAssistSettingsListener.new() return end

---@param props table
---@return AimAssistSettingsListener
function AimAssistSettingsListener.new(props) return end

---@return Bool
function AimAssistSettingsListener:GetAimAssistDriverCombatEnabled() return end

---@return EAimAssistLevel
function AimAssistSettingsListener:GetAimAssistLevel() return end

---@return EAimAssistLevel
function AimAssistSettingsListener:GetAimAssistMeleeLevel() return end

---@return Bool
function AimAssistSettingsListener:GetAimSnapEnabled() return end

---@param ctrl PlayerPuppet
function AimAssistSettingsListener:Initialize(ctrl) return end

---@param groupPath CName|string
---@param varName CName|string
---@param varType InGameConfigVarType
---@param reason InGameConfigChangeReason
function AimAssistSettingsListener:OnVarModified(groupPath, varName, varType, reason) return end

---@class AimAtTargetCommandCleanup : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
AimAtTargetCommandCleanup = {}

---@return AimAtTargetCommandCleanup
function AimAtTargetCommandCleanup.new() return end

---@param props table
---@return AimAtTargetCommandCleanup
function AimAtTargetCommandCleanup.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AimAtTargetCommandCleanup:Deactivate(context) return end

---@class AimAtTargetCommandHandler : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
---@field currentCommand AIAimAtTargetCommand
AimAtTargetCommandHandler = {}

---@return AimAtTargetCommandHandler
function AimAtTargetCommandHandler.new() return end

---@param props table
---@return AimAtTargetCommandHandler
function AimAtTargetCommandHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AimAtTargetCommandHandler:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AimAtTargetCommandHandler:Update(context) return end

---@class AimAtTargetCommandTask : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
---@field currentCommand AIAimAtTargetCommand
---@field threatPersistenceSource gamedataAIThreatPersistenceSource_Record
---@field activationTimeStamp Float
---@field commandDuration Float
---@field target gameObject
---@field targetID entEntityID
AimAtTargetCommandTask = {}

---@return AimAtTargetCommandTask
function AimAtTargetCommandTask.new() return end

---@param props table
---@return AimAtTargetCommandTask
function AimAtTargetCommandTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AimAtTargetCommandTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AimAtTargetCommandTask:CancelCommand(context) return end

---@param context AIbehaviorScriptExecutionContext
function AimAtTargetCommandTask:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AimAtTargetCommandTask:Update(context) return end

---@class AimDecisions : CanTransitionToThrowDecisions
AimDecisions = {}

---@return AimDecisions
function AimDecisions.new() return end

---@param props table
---@return AimDecisions
function AimDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimDecisions:ToThrow(stateContext, scriptInterface) return end

---@class AimDownSightController : BasicAnimationController
---@field isAiming Bool
AimDownSightController = {}

---@return AimDownSightController
function AimDownSightController.new() return end

---@param props table
---@return AimDownSightController
function AimDownSightController.new(props) return end

---@param isAiming Bool
function AimDownSightController:OnAim(isAiming) return end

---@param playerPuppet gameObject
function AimDownSightController:OnPlayerAttach(playerPuppet) return end

---@param playerPuppet gameObject
function AimDownSightController:OnPlayerDetach(playerPuppet) return end

---@class AimEvents : CarriedObjectEvents
AimEvents = {}

---@return AimEvents
function AimEvents.new() return end

---@param props table
---@return AimEvents
function AimEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimEvents:OnEnter(stateContext, scriptInterface) return end

---@param timeDelta Float
---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimEvents:OnUpdate(timeDelta, stateContext, scriptInterface) return end

---@class AimWalkDecisions : LocomotionGroundDecisions
---@field callbackIDs redCallbackObject[]
---@field isBlocking Bool
---@field isAiming Bool
---@field inFocusMode Bool
---@field isLeftHandChanging Bool
AimWalkDecisions = {}

---@return AimWalkDecisions
function AimWalkDecisions.new() return end

---@param props table
---@return AimWalkDecisions
function AimWalkDecisions.new(props) return end

---@param value Int32
---@return Bool
function AimWalkDecisions:OnLeftHandCyberwareChanged(value) return end

---@param value Int32
---@return Bool
function AimWalkDecisions:OnMeleeChanged(value) return end

---@param value Int32
---@return Bool
function AimWalkDecisions:OnUpperBodyChanged(value) return end

---@param value Int32
---@return Bool
function AimWalkDecisions:OnVisionChanged(value) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimWalkDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimWalkDecisions:OnAttach(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimWalkDecisions:OnDetach(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimWalkDecisions:ToDodge(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimWalkDecisions:ToStand(stateContext, scriptInterface) return end

function AimWalkDecisions:UpdateEnterConditionEnabled() return end

---@class AimWalkEvents : LocomotionGroundEvents
AimWalkEvents = {}

---@return AimWalkEvents
function AimWalkEvents.new() return end

---@param props table
---@return AimWalkEvents
function AimWalkEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimWalkEvents:OnEnter(stateContext, scriptInterface) return end

---@param timeDelta Float
---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimWalkEvents:OnUpdate(timeDelta, stateContext, scriptInterface) return end

---@class AimingContextDecisions : InputContextTransitionDecisions
---@field leftHandChargeCallbackID redCallbackObject
---@field upperBodyCallbackID redCallbackObject
---@field meleeCallbackID redCallbackObject
---@field leftHandCharge Bool
---@field isAiming Bool
---@field meleeBlockActive Bool
AimingContextDecisions = {}

---@return AimingContextDecisions
function AimingContextDecisions.new() return end

---@param props table
---@return AimingContextDecisions
function AimingContextDecisions.new(props) return end

---@param value Int32
---@return Bool
function AimingContextDecisions:OnLeftHandCyberwareChanged(value) return end

---@param value Int32
---@return Bool
function AimingContextDecisions:OnMeleeChanged(value) return end

---@param value Int32
---@return Bool
function AimingContextDecisions:OnUpperBodyChanged(value) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimingContextDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingContextDecisions:OnAttach(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingContextDecisions:OnDetach(stateContext, scriptInterface) return end

---@param value Int32
function AimingContextDecisions:UpdateLeftHandCyberware(value) return end

---@param value Int32
function AimingContextDecisions:UpdateMeleeState(value) return end

function AimingContextDecisions:UpdateNeedsToBeChecked() return end

---@param value Int32
function AimingContextDecisions:UpdateUpperBodyState(value) return end

---@class AimingContextEvents : InputContextTransitionEvents
AimingContextEvents = {}

---@return AimingContextEvents
function AimingContextEvents.new() return end

---@param props table
---@return AimingContextEvents
function AimingContextEvents.new(props) return end

---@param timeDelta Float
---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingContextEvents:OnUpdate(timeDelta, stateContext, scriptInterface) return end

---@class AimingStateDecisions : UpperBodyTransition
---@field callbackIDs redCallbackObject[]
---@field executionOwner gameObject
---@field statListener DefaultTransitionStatListener
---@field statusEffectListener DefaultTransitionStatusEffectListener
---@field attachmentSlotListener gameAttachmentSlotsScriptListener
---@field sceneTier Int32
---@field vehicleState Int32
---@field highLevelState Int32
---@field combatGadgetState Int32
---@field takedownState Int32
---@field weaponState Int32
---@field cameraAimPressed Bool
---@field sceneAimForced Bool
---@field shouldAim Bool
---@field hasRightHandItemEquipped Bool
---@field isDead Bool
---@field isWeaponBlockingAiming Bool
---@field visionModeActive Bool
---@field isDodging Bool
---@field hasThrowableMeleeWeapon Bool
---@field canAimWhileDodging Bool
---@field canThrowWeapon Bool
---@field aimForced Bool
---@field beingCreated Bool
---@field mouseZoomLevel Float
AimingStateDecisions = {}

---@return AimingStateDecisions
function AimingStateDecisions.new() return end

---@param props table
---@return AimingStateDecisions
function AimingStateDecisions.new(props) return end

---@param action gameinputScriptListenerAction
---@param consumer gameinputScriptListenerActionConsumer
---@return Bool
function AimingStateDecisions:OnAction(action, consumer) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnCombatGadgetChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnHighLevelChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnLocomoatoinStateChanged(value) return end

---@param value Bool
---@return Bool
function AimingStateDecisions:OnSceneAimForcedChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnSceneTierChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnTakedownChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnVehicleChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnVisionChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnVitalsChanged(value) return end

---@param value Int32
---@return Bool
function AimingStateDecisions:OnWeaponStateChanged(value) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimingStateDecisions:EnterCondition(stateContext, scriptInterface) return end

---@return Bool
function AimingStateDecisions:GetShouldAimValue() return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateDecisions:OnAttach(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateDecisions:OnDetach(stateContext, scriptInterface) return end

---@param slot TweakDBID|string
---@param item ItemID
function AimingStateDecisions:OnItemEquipped(slot, item) return end

---@param slot TweakDBID|string
---@param item ItemID
function AimingStateDecisions:OnItemUnequipped(slot, item) return end

---@param ownerID gameStatsObjectID
---@param statType gamedataStatType
---@param diff Float
---@param value Float
function AimingStateDecisions:OnStatChanged(ownerID, statType, diff, value) return end

---@param statusEffect gamedataStatusEffect_Record
function AimingStateDecisions:OnStatusEffectApplied(statusEffect) return end

---@param statusEffect gamedataStatusEffect_Record
function AimingStateDecisions:OnStatusEffectRemoved(statusEffect) return end

---@return Bool
function AimingStateDecisions:ShouldCheckEnterCondition() return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimingStateDecisions:ToEmptyHands(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimingStateDecisions:ToForceEmptyHands(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimingStateDecisions:ToForceSafe(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AimingStateDecisions:ToSingleWield(stateContext, scriptInterface) return end

function AimingStateDecisions:UpdateEnterConditionEnabled() return end

---@class AimingStateEvents : UpperBodyEventsTransition
---@field aim gameweaponAnimFeature_AimPlayer
---@field posAnimFeature AnimFeature_ProceduralIronsightData
---@field statusEffectListener DefaultTransitionStatusEffectListener
---@field weapon gameweaponObject
---@field executionOwner gameObject
---@field localBlackboard gameIBlackboard
---@field mouseZoomLevel Float
---@field zoomLevelNum Int32
---@field numZoomLevels Int32
---@field delayAimSnap Int32
---@field isAiming Bool
---@field aimInTimeRemaining Float
---@field aimBroadcast Bool
---@field zoomLevel Float
---@field finalZoomLevel Float
---@field previousZoomLevel Float
---@field currentZoomLevel Float
---@field timeToBlendZoom Float
---@field time Float
---@field speed Float
---@field itemChanged Bool
---@field firearmsNoUnequipNoSwitch Bool
---@field shootingRangeCompetition Bool
---@field weaponHasPerfectAim Bool
---@field statsSystem gameStatsSystem
---@field statusEffectSystem gameStatusEffectSystem
---@field attachmentSlotListener gameAttachmentSlotsScriptListener
---@field prevDownwardsGravity Float
---@field downwardsGravityChanged Bool
---@field accelerationMod gameConstantStatModifierData_Deprecated
---@field decelerationMod gameConstantStatModifierData_Deprecated
AimingStateEvents = {}

---@return AimingStateEvents
function AimingStateEvents.new() return end

---@param props table
---@return AimingStateEvents
function AimingStateEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:EvaluateAimSnap(stateContext, scriptInterface) return end

---@return gameaimAssistAimRequest
function AimingStateEvents:GetPerfectAimSnapParams() return end

---@return TweakDBID
function AimingStateEvents:GetPlayerAimingStatusEffectID() return end

---@return gameaimAssistAimRequest
function AimingStateEvents:GetVehicleAimSnapParams() return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@return gameweaponObject
function AimingStateEvents:GetWeaponObject(scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@param isAiming Bool
function AimingStateEvents:NotifyWeaponObject(scriptInterface, isAiming) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:OnAimStartBegin(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:OnAttach(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:OnDetach(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:OnExit(stateContext, scriptInterface) return end

---@param slot TweakDBID|string
---@param item ItemID
function AimingStateEvents:OnItemEquipped(slot, item) return end

---@param slot TweakDBID|string
---@param item ItemID
function AimingStateEvents:OnItemUnequipped(slot, item) return end

---@param statusEffect gamedataStatusEffect_Record
function AimingStateEvents:OnStatusEffectApplied(statusEffect) return end

---@param statusEffect gamedataStatusEffect_Record
function AimingStateEvents:OnStatusEffectRemoved(statusEffect) return end

---@param timeDelta Float
---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:OnUpdate(timeDelta, stateContext, scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@param effectName CName|string
function AimingStateEvents:PlayEffectOnHeldItems(scriptInterface, effectName) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:RemoveAirKerenzikovPerk(stateContext, scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@param effectName CName|string
function AimingStateEvents:StartZoomEffect(scriptInterface, effectName) return end

---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:TriggerZoomExitSfx(scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:TryToActivateAirKerenzikovPerk(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:UpdateAimAnimFeature(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:UpdateAimDownSightsSfx(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:UpdateAimingStatusEffect(stateContext, scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:UpdateWeaponOffsetPosition(scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
function AimingStateEvents:UpdateZoomVfx(scriptInterface) return end

---@class Air : DefaultTransition
Air = {}

---@return Air
function Air.new() return end

---@param props table
---@return Air
function Air.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function Air:EnterCondition(stateContext, scriptInterface) return end

---@class AirDeathDecisions : DeathDecisionsWithResurrection
AirDeathDecisions = {}

---@return AirDeathDecisions
function AirDeathDecisions.new() return end

---@param props table
---@return AirDeathDecisions
function AirDeathDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirDeathDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirDeathDecisions:ToSwimmingDeath(stateContext, scriptInterface) return end

---@class AirDeathEvents : DeathEvents
AirDeathEvents = {}

---@return AirDeathEvents
function AirDeathEvents.new() return end

---@param props table
---@return AirDeathEvents
function AirDeathEvents.new(props) return end

---@class AirHoverDecisions : LocomotionAirDecisions
AirHoverDecisions = {}

---@return AirHoverDecisions
function AirHoverDecisions.new() return end

---@param props table
---@return AirHoverDecisions
function AirHoverDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirHoverDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirHoverDecisions:ToSuperheroFall(stateContext, scriptInterface) return end

---@class AirHoverEvents : LocomotionAirEvents
AirHoverEvents = {}

---@return AirHoverEvents
function AirHoverEvents.new() return end

---@param props table
---@return AirHoverEvents
function AirHoverEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@param verticalSpeed Float
function AirHoverEvents:AddUpwardsImpulse(stateContext, scriptInterface, verticalSpeed) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AirHoverEvents:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AirHoverEvents:OnExit(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AirHoverEvents:OnForcedExit(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@param verticalSpeed Float
function AirHoverEvents:SetDeathFallHeight(stateContext, scriptInterface, verticalSpeed) return end

---@class AirThrustersDecisions : LocomotionAirDecisions
AirThrustersDecisions = {}

---@return AirThrustersDecisions
function AirThrustersDecisions.new() return end

---@param props table
---@return AirThrustersDecisions
function AirThrustersDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirThrustersDecisions:EnterCondition(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirThrustersDecisions:IsFallHeightAcceptable(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirThrustersDecisions:ToDoubleJump(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirThrustersDecisions:ToFall(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function AirThrustersDecisions:ToStand(stateContext, scriptInterface) return end

---@class AirThrustersEvents : LocomotionAirEvents
AirThrustersEvents = {}

---@return AirThrustersEvents
function AirThrustersEvents.new() return end

---@param props table
---@return AirThrustersEvents
function AirThrustersEvents.new(props) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@return gameItemObject
function AirThrustersEvents:GetActiveFeetAreaItem(scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AirThrustersEvents:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AirThrustersEvents:OnExit(stateContext, scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@param effectName CName|string
function AirThrustersEvents:PlayEffectOnItem(scriptInterface, effectName) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@param state Int32
function AirThrustersEvents:SendAnimFeatureDataToGraph(stateContext, scriptInterface, state) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function AirThrustersEvents:SetUpwardsThrustStats(stateContext, scriptInterface) return end

---@param scriptInterface gamestateMachineGameScriptInterface
---@param effectName CName|string
function AirThrustersEvents:StopEffectOnItem(scriptInterface, effectName) return end

---@class AlarmEvent : redEvent
---@field isValid Bool
---@field ID gameDelayID
AlarmEvent = {}

---@return AlarmEvent
function AlarmEvent.new() return end

---@param props table
---@return AlarmEvent
function AlarmEvent.new(props) return end

---@class AlarmLight : BasicDistractionDevice
---@field isGlitching Bool
AlarmLight = {}

---@return AlarmLight
function AlarmLight.new() return end

---@param props table
---@return AlarmLight
function AlarmLight.new(props) return end

---@param evt QuestForceSecuritySystemArmed
---@return Bool
function AlarmLight:OnQuestForceSecuritySystemArmed(evt) return end

---@param evt QuestForceSecuritySystemSafe
---@return Bool
function AlarmLight:OnQuestForceSecuritySystemSafe(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AlarmLight:OnRequestComponents(ri) return end

---@param evt SecurityAlarmBreachResponse
---@return Bool
function AlarmLight:OnSecurityAlarmBreachResponse(evt) return end

---@param evt SecuritySystemOutput
---@return Bool
function AlarmLight:OnSecuritySystemOutput(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AlarmLight:OnTakeControl(ri) return end

function AlarmLight:CutPower() return end

---@return EGameplayRole
function AlarmLight:DeterminGameplayRole() return end

---@return AlarmLightController
function AlarmLight:GetController() return end

---@return AlarmLightControllerPS
function AlarmLight:GetDevicePS() return end

function AlarmLight:ResolveGameplayState() return end

function AlarmLight:SendStim() return end

function AlarmLight:StartBlinking() return end

---@param glitchState EGlitchState
---@param intensity Float
function AlarmLight:StartGlitching(glitchState, intensity) return end

function AlarmLight:StopBlinking() return end

function AlarmLight:StopGlitching() return end

function AlarmLight:StopStim() return end

function AlarmLight:TurnOffDevice() return end

function AlarmLight:TurnOffLights() return end

function AlarmLight:TurnOnDevice() return end

function AlarmLight:TurnOnLights() return end

function AlarmLight:UpdateLights() return end

---@class AlarmLightController : ScriptableDeviceComponent
AlarmLightController = {}

---@return AlarmLightController
function AlarmLightController.new() return end

---@param props table
---@return AlarmLightController
function AlarmLightController.new(props) return end

---@return AlarmLightControllerPS
function AlarmLightController:GetPS() return end

---@class AlarmLightControllerPS : BasicDistractionDeviceControllerPS
---@field securityAlarmState ESecuritySystemState
AlarmLightControllerPS = {}

---@return AlarmLightControllerPS
function AlarmLightControllerPS.new() return end

---@param props table
---@return AlarmLightControllerPS
function AlarmLightControllerPS.new(props) return end

---@return ESecuritySystemState
function AlarmLightControllerPS:GetAlarmState() return end

---@param evt QuestForceSecuritySystemArmed
---@return EntityNotificationType
function AlarmLightControllerPS:OnQuestForceSecuritySystemArmed(evt) return end

---@param evt QuestForceSecuritySystemSafe
---@return EntityNotificationType
function AlarmLightControllerPS:OnQuestForceSecuritySystemSafe(evt) return end

---@param evt SecurityAlarmBreachResponse
---@return EntityNotificationType
function AlarmLightControllerPS:OnSecurityAlarmBreachResponse(evt) return end

---@param evt SecuritySystemOutput
---@return EntityNotificationType
function AlarmLightControllerPS:OnSecuritySystemOutput(evt) return end

---@class AlertedAnimWrapper : AIbehaviortaskScript
AlertedAnimWrapper = {}

---@return AlertedAnimWrapper
function AlertedAnimWrapper.new() return end

---@param props table
---@return AlertedAnimWrapper
function AlertedAnimWrapper.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AlertedAnimWrapper:Activate(context) return end

---@class AlertedConditions : AIAutonomousConditions
AlertedConditions = {}

---@return AlertedConditions
function AlertedConditions.new() return end

---@param props table
---@return AlertedConditions
function AlertedConditions.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AlertedConditions:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AlertedConditions:Check(context) return end

---@class AlertedRoleHandler : AIbehaviortaskScript
---@field pathParamsModified Bool
AlertedRoleHandler = {}

---@return AlertedRoleHandler
function AlertedRoleHandler.new() return end

---@param props table
---@return AlertedRoleHandler
function AlertedRoleHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AlertedRoleHandler:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function AlertedRoleHandler:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AlertedRoleHandler:Update(context) return end

---@class AlertedState : ChangeHighLevelStateAbstract
AlertedState = {}

---@return AlertedState
function AlertedState.new() return end

---@param props table
---@return AlertedState
function AlertedState.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return gamedataNPCHighLevelState
function AlertedState:GetDesiredHighLevelState(context) return end

---@class AltimeterController : inkWidgetLogicController
---@field faceUp inkWidgetReference
---@field faceDown inkWidgetReference
---@field textWidget inkTextWidgetReference
---@field decimalPrecision Uint32
---@field faceUpStartPosition Vector2
---@field faceDownStartPosition Vector2
---@field playerPuppet gameObject
---@field warpDistance Float
---@field alitimeterValue Float
---@field precisionEpsilon Float
AltimeterController = {}

---@return AltimeterController
function AltimeterController.new() return end

---@param props table
---@return AltimeterController
function AltimeterController.new(props) return end

---@return Bool
function AltimeterController:OnUpdate() return end

---@param playerPuppet gameObject
function AltimeterController:OnPlayerAttach(playerPuppet) return end

---@param playerPuppet gameObject
function AltimeterController:OnPlayerDetach(playerPuppet) return end

function AltimeterController:Update() return end

---@class AlwaysTruePrereq : gameIScriptablePrereq
AlwaysTruePrereq = {}

---@return AlwaysTruePrereq
function AlwaysTruePrereq.new() return end

---@param props table
---@return AlwaysTruePrereq
function AlwaysTruePrereq.new(props) return end

---@param context IScriptable
---@return Bool
function AlwaysTruePrereq:IsFulfilled(context) return end

---@param state gamePrereqState
---@param context IScriptable
function AlwaysTruePrereq:OnApplied(state, context) return end

---@class AlwaysTruePrereqState : gamePrereqState
AlwaysTruePrereqState = {}

---@return AlwaysTruePrereqState
function AlwaysTruePrereqState.new() return end

---@param props table
---@return AlwaysTruePrereqState
function AlwaysTruePrereqState.new(props) return end

---@class AmbientOverrideAreaSettings : IAreaSettings
---@field color curveData[]
AmbientOverrideAreaSettings = {}

---@return AmbientOverrideAreaSettings
function AmbientOverrideAreaSettings.new() return end

---@param props table
---@return AmbientOverrideAreaSettings
function AmbientOverrideAreaSettings.new(props) return end

---@class AmmoLogicController : inkWidgetLogicController
---@field count Uint32
---@field capacity Uint32
AmmoLogicController = {}

---@param value Uint32
function AmmoLogicController:OnMagazineAmmoCapacityChanged(value) return end

---@param value Uint32
function AmmoLogicController:OnMagazineAmmoCountChanged(value) return end

---@class AmmoStateChangeEvent : redEvent
---@field weaponOwner gameObject
AmmoStateChangeEvent = {}

---@return AmmoStateChangeEvent
function AmmoStateChangeEvent.new() return end

---@param props table
---@return AmmoStateChangeEvent
function AmmoStateChangeEvent.new(props) return end

---@class AmmoStateHitCallback : HitCallback
AmmoStateHitCallback = {}

---@return AmmoStateHitCallback
function AmmoStateHitCallback.new() return end

---@param props table
---@return AmmoStateHitCallback
function AmmoStateHitCallback.new(props) return end

---@param state gamePrereqState
function AmmoStateHitCallback:RegisterState(state) return end

---@param hitEvent gameeventsHitEvent
function AmmoStateHitCallback:UpdateState(hitEvent) return end

---@class AmmoStateHitPrereqCondition : BaseHitPrereqCondition
---@field valueToListen EMagazineAmmoState
---@field ratio Float
---@field comparisonType EComparisonType
AmmoStateHitPrereqCondition = {}

---@return AmmoStateHitPrereqCondition
function AmmoStateHitPrereqCondition.new() return end

---@param props table
---@return AmmoStateHitPrereqCondition
function AmmoStateHitPrereqCondition.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function AmmoStateHitPrereqCondition:Evaluate(hitEvent) return end

---@param recordID TweakDBID|string
function AmmoStateHitPrereqCondition:SetData(recordID) return end

---@class AmmoStateHitTriggeredCallback : AmmoStateHitCallback
AmmoStateHitTriggeredCallback = {}

---@return AmmoStateHitTriggeredCallback
function AmmoStateHitTriggeredCallback.new() return end

---@param props table
---@return AmmoStateHitTriggeredCallback
function AmmoStateHitTriggeredCallback.new(props) return end

---@param hitEvent gameeventsHitEvent
function AmmoStateHitTriggeredCallback:OnHitReceived(hitEvent) return end

---@param hitEvent gameeventsHitEvent
function AmmoStateHitTriggeredCallback:OnHitTriggered(hitEvent) return end

---@class AmmoStateHitTriggeredPrereq : HitTriggeredPrereq
---@field valueToListen EMagazineAmmoState
AmmoStateHitTriggeredPrereq = {}

---@return AmmoStateHitTriggeredPrereq
function AmmoStateHitTriggeredPrereq.new() return end

---@param props table
---@return AmmoStateHitTriggeredPrereq
function AmmoStateHitTriggeredPrereq.new(props) return end

---@param recordID TweakDBID|string
function AmmoStateHitTriggeredPrereq:Initialize(recordID) return end

---@param state gamePrereqState
---@param context IScriptable
---@return Bool
function AmmoStateHitTriggeredPrereq:OnRegister(state, context) return end

---@class AmmoStateHitTriggeredPrereqState : GenericHitPrereqState
AmmoStateHitTriggeredPrereqState = {}

---@return AmmoStateHitTriggeredPrereqState
function AmmoStateHitTriggeredPrereqState.new() return end

---@param props table
---@return AmmoStateHitTriggeredPrereqState
function AmmoStateHitTriggeredPrereqState.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function AmmoStateHitTriggeredPrereqState:Evaluate(hitEvent) return end

---@class AndroidTurnOffEffector : gameEffector
AndroidTurnOffEffector = {}

---@return AndroidTurnOffEffector
function AndroidTurnOffEffector.new() return end

---@param props table
---@return AndroidTurnOffEffector
function AndroidTurnOffEffector.new(props) return end

---@param owner gameObject
function AndroidTurnOffEffector:ActionOff(owner) return end

---@param owner gameObject
function AndroidTurnOffEffector:ActionOn(owner) return end

function AndroidTurnOffEffector:Uninitialize() return end

---@class AndroidTurnOnEffector : gameEffector
AndroidTurnOnEffector = {}

---@return AndroidTurnOnEffector
function AndroidTurnOnEffector.new() return end

---@param props table
---@return AndroidTurnOnEffector
function AndroidTurnOnEffector.new(props) return end

---@param owner gameObject
function AndroidTurnOnEffector:ActionOff(owner) return end

---@param owner gameObject
function AndroidTurnOnEffector:ActionOn(owner) return end

function AndroidTurnOnEffector:Uninitialize() return end

---@class AnimFeatureCustom : animAnimFeature
AnimFeatureCustom = {}

---@class AnimFeatureDoor : animAnimFeature
---@field progress Float
---@field openingSpeed Float
---@field openingType Int32
---@field doorSide Int32
---@field malfunctioning Int32
AnimFeatureDoor = {}

---@return AnimFeatureDoor
function AnimFeatureDoor.new() return end

---@param props table
---@return AnimFeatureDoor
function AnimFeatureDoor.new(props) return end

---@class AnimFeatureServer : animAnimFeature
---@field coverState Int32
---@field serverState Int32
AnimFeatureServer = {}

---@return AnimFeatureServer
function AnimFeatureServer.new() return end

---@param props table
---@return AnimFeatureServer
function AnimFeatureServer.new(props) return end

---@class AnimFeatureShieldState : AnimFeatureCustom
---@field state Int32
AnimFeatureShieldState = {}

---@return AnimFeatureShieldState
function AnimFeatureShieldState.new() return end

---@param props table
---@return AnimFeatureShieldState
function AnimFeatureShieldState.new(props) return end

---@class AnimFeature_AdHocAnimation : animAnimFeature
---@field isActive Bool
---@field useBothHands Bool
---@field animationIndex Int32
AnimFeature_AdHocAnimation = {}

---@return AnimFeature_AdHocAnimation
function AnimFeature_AdHocAnimation.new() return end

---@param props table
---@return AnimFeature_AdHocAnimation
function AnimFeature_AdHocAnimation.new(props) return end

---@class AnimFeature_AerialTakedown : animAnimFeature
---@field state Int32
AnimFeature_AerialTakedown = {}

---@return AnimFeature_AerialTakedown
function AnimFeature_AerialTakedown.new() return end

---@param props table
---@return AnimFeature_AerialTakedown
function AnimFeature_AerialTakedown.new(props) return end

---@class AnimFeature_AirHover : animAnimFeature
---@field state Int32
AnimFeature_AirHover = {}

---@return AnimFeature_AirHover
function AnimFeature_AirHover.new() return end

---@param props table
---@return AnimFeature_AirHover
function AnimFeature_AirHover.new(props) return end

---@class AnimFeature_AirThrusterData : animAnimFeature
---@field state Int32
AnimFeature_AirThrusterData = {}

---@return AnimFeature_AirThrusterData
function AnimFeature_AirThrusterData.new() return end

---@param props table
---@return AnimFeature_AirThrusterData
function AnimFeature_AirThrusterData.new(props) return end

---@class AnimFeature_AnimatedDevice : animAnimFeature
---@field isOn Bool
---@field isOff Bool
AnimFeature_AnimatedDevice = {}

---@return AnimFeature_AnimatedDevice
function AnimFeature_AnimatedDevice.new() return end

---@param props table
---@return AnimFeature_AnimatedDevice
function AnimFeature_AnimatedDevice.new(props) return end

---@class AnimFeature_BodySlam : animAnimFeature
---@field chargeLevel Int32
AnimFeature_BodySlam = {}

---@return AnimFeature_BodySlam
function AnimFeature_BodySlam.new() return end

---@param props table
---@return AnimFeature_BodySlam
function AnimFeature_BodySlam.new(props) return end

---@class AnimFeature_BulletBend : animAnimFeature
---@field animProgression Float
---@field randomAdditive Float
---@field isResetting Bool
AnimFeature_BulletBend = {}

---@return AnimFeature_BulletBend
function AnimFeature_BulletBend.new() return end

---@param props table
---@return AnimFeature_BulletBend
function AnimFeature_BulletBend.new(props) return end

---@class AnimFeature_CamberData : animAnimFeatureMarkUnstable
---@field rightFrontCamber Float
---@field leftFrontCamber Float
---@field rightBackCamber Float
---@field leftBackCamber Float
---@field rightFrontCamberOffset Vector4
---@field leftFrontCamberOffset Vector4
---@field rightBackCamberOffset Vector4
---@field leftBackCamberOffset Vector4
AnimFeature_CamberData = {}

---@return AnimFeature_CamberData
function AnimFeature_CamberData.new() return end

---@param props table
---@return AnimFeature_CamberData
function AnimFeature_CamberData.new(props) return end

---@class AnimFeature_CameraBodyOffset : animAnimFeature
---@field lookat_pitch_forward_offset Float
---@field lookat_pitch_forward_down_ratio Float
---@field lookat_yaw_left_offset Float
---@field lookat_yaw_left_up_offset Float
---@field lookat_yaw_right_offset Float
---@field lookat_yaw_right_up_offset Float
---@field lookat_yaw_offset_active_angle Float
---@field is_paralax Float
---@field paralax_radius Float
---@field paralax_forward_offset Float
---@field lookat_offset_vertical Float
AnimFeature_CameraBodyOffset = {}

---@return AnimFeature_CameraBodyOffset
function AnimFeature_CameraBodyOffset.new() return end

---@param props table
---@return AnimFeature_CameraBodyOffset
function AnimFeature_CameraBodyOffset.new(props) return end

---@class AnimFeature_CameraBreathing : animAnimFeature
---@field amplitudeWeight Float
---@field dampIncreaseSpeed Float
---@field dampDecreaseSpeed Float
AnimFeature_CameraBreathing = {}

---@return AnimFeature_CameraBreathing
function AnimFeature_CameraBreathing.new() return end

---@param props table
---@return AnimFeature_CameraBreathing
function AnimFeature_CameraBreathing.new(props) return end

---@class AnimFeature_CameraGameplay : animAnimFeature
---@field is_forward_offset Float
---@field forward_offset_value Float
---@field upperbody_pitch_weight Float
---@field upperbody_yaw_weight Float
---@field is_pitch_off Float
---@field is_yaw_off Float
AnimFeature_CameraGameplay = {}

---@return AnimFeature_CameraGameplay
function AnimFeature_CameraGameplay.new() return end

---@param props table
---@return AnimFeature_CameraGameplay
function AnimFeature_CameraGameplay.new(props) return end

---@class AnimFeature_CameraRecoil : animAnimFeature
---@field backward_offset Float
---@field side_offset Float
---@field tilt_angle Float
---@field yaw_angle Float
---@field pitch_angle Float
---@field translate_transform_speed Float
---@field rotate_transform_speed Float
---@field is_offset Bool
AnimFeature_CameraRecoil = {}

---@return AnimFeature_CameraRecoil
function AnimFeature_CameraRecoil.new() return end

---@param props table
---@return AnimFeature_CameraRecoil
function AnimFeature_CameraRecoil.new(props) return end

---@class AnimFeature_CameraSceneMode : animAnimFeature
---@field pitch_yaw_order Float
---@field is_scene_mode Float
---@field scene_settings_mode Float
AnimFeature_CameraSceneMode = {}

---@return AnimFeature_CameraSceneMode
function AnimFeature_CameraSceneMode.new() return end

---@param props table
---@return AnimFeature_CameraSceneMode
function AnimFeature_CameraSceneMode.new(props) return end

---@class AnimFeature_Carry : animAnimFeature
---@field state Int32
---@field pickupAnimation Int32
---@field useBothHands Bool
---@field instant Bool
---@field fastMode Bool
---@field isCarryActive Bool
---@field isFriendlyCarry Bool
---@field wasThrown Bool
AnimFeature_Carry = {}

---@return AnimFeature_Carry
function AnimFeature_Carry.new() return end

---@param props table
---@return AnimFeature_Carry
function AnimFeature_Carry.new(props) return end

---@class AnimFeature_ChestPress : animAnimFeature
---@field lifting Bool
---@field kill Bool
AnimFeature_ChestPress = {}

---@return AnimFeature_ChestPress
function AnimFeature_ChestPress.new() return end

---@param props table
---@return AnimFeature_ChestPress
function AnimFeature_ChestPress.new(props) return end

---@class AnimFeature_CombatGadget : animAnimFeature
---@field isQuickthrow Bool
---@field isChargedThrow Bool
---@field isDetonated Bool
AnimFeature_CombatGadget = {}

---@return AnimFeature_CombatGadget
function AnimFeature_CombatGadget.new() return end

---@param props table
---@return AnimFeature_CombatGadget
function AnimFeature_CombatGadget.new(props) return end

---@class AnimFeature_CombatState : animAnimFeature
---@field isInCombat Bool
AnimFeature_CombatState = {}

---@return AnimFeature_CombatState
function AnimFeature_CombatState.new() return end

---@param props table
---@return AnimFeature_CombatState
function AnimFeature_CombatState.new(props) return end

---@class AnimFeature_Container : animAnimFeature
---@field opened Bool
---@field transitionDuration Float
AnimFeature_Container = {}

---@return AnimFeature_Container
function AnimFeature_Container.new() return end

---@param props table
---@return AnimFeature_Container
function AnimFeature_Container.new(props) return end

---@class AnimFeature_CoverState : animAnimFeature
---@field inCover Bool
---@field debugVar Bool
AnimFeature_CoverState = {}

---@return AnimFeature_CoverState
function AnimFeature_CoverState.new() return end

---@param props table
---@return AnimFeature_CoverState
function AnimFeature_CoverState.new(props) return end

---@class AnimFeature_CrowdRunningAway : animAnimFeature
---@field isRunningAwayFromPlayersCar Bool
AnimFeature_CrowdRunningAway = {}

---@return AnimFeature_CrowdRunningAway
function AnimFeature_CrowdRunningAway.new() return end

---@param props table
---@return AnimFeature_CrowdRunningAway
function AnimFeature_CrowdRunningAway.new(props) return end

---@class AnimFeature_DOFControl : animAnimFeature
---@field dofIntensity Float
---@field dofNearBlur Float
---@field dofNearFocus Float
---@field dofFarBlur Float
---@field dofFarFocus Float
---@field dofBlendInTime Float
---@field dofBlendOutTime Float
AnimFeature_DOFControl = {}

---@return AnimFeature_DOFControl
function AnimFeature_DOFControl.new() return end

---@param props table
---@return AnimFeature_DOFControl
function AnimFeature_DOFControl.new(props) return end

---@class AnimFeature_DelayEntry : animAnimFeature
---@field thresholdPassed Bool
AnimFeature_DelayEntry = {}

---@return AnimFeature_DelayEntry
function AnimFeature_DelayEntry.new() return end

---@param props table
---@return AnimFeature_DelayEntry
function AnimFeature_DelayEntry.new(props) return end

---@class AnimFeature_DeviceWorkspot : animAnimFeature
---@field e3_lockInReferencePose Bool
AnimFeature_DeviceWorkspot = {}

---@return AnimFeature_DeviceWorkspot
function AnimFeature_DeviceWorkspot.new() return end

---@param props table
---@return AnimFeature_DeviceWorkspot
function AnimFeature_DeviceWorkspot.new(props) return end

---@class AnimFeature_DistractionState : animAnimFeature
---@field isOn Bool
AnimFeature_DistractionState = {}

---@return AnimFeature_DistractionState
function AnimFeature_DistractionState.new() return end

---@param props table
---@return AnimFeature_DistractionState
function AnimFeature_DistractionState.new(props) return end

---@class AnimFeature_DoorDevice : animAnimFeature
---@field isOpen Bool
---@field isLocked Bool
---@field isSealed Bool
AnimFeature_DoorDevice = {}

---@return AnimFeature_DoorDevice
function AnimFeature_DoorDevice.new() return end

---@param props table
---@return AnimFeature_DoorDevice
function AnimFeature_DoorDevice.new(props) return end

---@class AnimFeature_DriverCombatWeaponData : animAnimFeature
---@field weaponType Int32
AnimFeature_DriverCombatWeaponData = {}

---@return AnimFeature_DriverCombatWeaponData
function AnimFeature_DriverCombatWeaponData.new() return end

---@param props table
---@return AnimFeature_DriverCombatWeaponData
function AnimFeature_DriverCombatWeaponData.new(props) return end

---@class AnimFeature_DroneActionAltitudeOffset : animAnimFeature
---@field desiredOffset Float
AnimFeature_DroneActionAltitudeOffset = {}

---@return AnimFeature_DroneActionAltitudeOffset
function AnimFeature_DroneActionAltitudeOffset.new() return end

---@param props table
---@return AnimFeature_DroneActionAltitudeOffset
function AnimFeature_DroneActionAltitudeOffset.new(props) return end

---@class AnimFeature_DroneProcedural : animAnimFeature
---@field mass Float
---@field size_front Float
---@field size_back Float
---@field size_left Float
---@field size_right Float
---@field walk_tilt_coef Float
---@field mass_normalized_coef Float
---@field tilt_angle_on_speed Float
---@field speed_idle_threshold Float
---@field starting_recovery_ballance Float
---@field pseudo_acceleration Float
---@field turn_inertia_damping Float
---@field combat_default_z_offset Float
AnimFeature_DroneProcedural = {}

---@return AnimFeature_DroneProcedural
function AnimFeature_DroneProcedural.new() return end

---@param props table
---@return AnimFeature_DroneProcedural
function AnimFeature_DroneProcedural.new(props) return end

---@class AnimFeature_DroneStateAnimationData : animAnimFeature
---@field statePose Int32
AnimFeature_DroneStateAnimationData = {}

---@return AnimFeature_DroneStateAnimationData
function AnimFeature_DroneStateAnimationData.new() return end

---@param props table
---@return AnimFeature_DroneStateAnimationData
function AnimFeature_DroneStateAnimationData.new(props) return end

---@class AnimFeature_EquipType : animAnimFeature
---@field firstEquip Bool
---@field equipDuration Float
---@field unequipDuration Float
AnimFeature_EquipType = {}

---@return AnimFeature_EquipType
function AnimFeature_EquipType.new() return end

---@param props table
---@return AnimFeature_EquipType
function AnimFeature_EquipType.new(props) return end

---@class AnimFeature_FacialReaction : animAnimFeature
---@field category Int32
---@field idle Int32
AnimFeature_FacialReaction = {}

---@return AnimFeature_FacialReaction
function AnimFeature_FacialReaction.new() return end

---@param props table
---@return AnimFeature_FacialReaction
function AnimFeature_FacialReaction.new(props) return end

---@class AnimFeature_Felled : animAnimFeature
---@field active Bool
AnimFeature_Felled = {}

---@return AnimFeature_Felled
function AnimFeature_Felled.new() return end

---@param props table
---@return AnimFeature_Felled
function AnimFeature_Felled.new(props) return end

---@class AnimFeature_FocusMode : animAnimFeature
---@field isFocusModeActive Bool
AnimFeature_FocusMode = {}

---@return AnimFeature_FocusMode
function AnimFeature_FocusMode.new() return end

---@param props table
---@return AnimFeature_FocusMode
function AnimFeature_FocusMode.new(props) return end

---@class AnimFeature_ForkliftDevice : animAnimFeature
---@field isUp Bool
---@field isDown Bool
---@field distract Bool
AnimFeature_ForkliftDevice = {}

---@return AnimFeature_ForkliftDevice
function AnimFeature_ForkliftDevice.new() return end

---@param props table
---@return AnimFeature_ForkliftDevice
function AnimFeature_ForkliftDevice.new(props) return end

---@class AnimFeature_Grapple : animAnimFeature
---@field inGrapple Bool
AnimFeature_Grapple = {}

---@return AnimFeature_Grapple
function AnimFeature_Grapple.new() return end

---@param props table
---@return AnimFeature_Grapple
function AnimFeature_Grapple.new(props) return end

---@class AnimFeature_HoverJumpData : animAnimFeature
---@field state Int32
AnimFeature_HoverJumpData = {}

---@return AnimFeature_HoverJumpData
function AnimFeature_HoverJumpData.new() return end

---@param props table
---@return AnimFeature_HoverJumpData
function AnimFeature_HoverJumpData.new(props) return end

---@class AnimFeature_IconicItem : animAnimFeature
---@field isScanning Bool
---@field isFreeDrilling Bool
---@field isActiveDrilling Bool
---@field isScanToInteraction Bool
---@field isItemEquipped Bool
AnimFeature_IconicItem = {}

---@return AnimFeature_IconicItem
function AnimFeature_IconicItem.new() return end

---@param props table
---@return AnimFeature_IconicItem
function AnimFeature_IconicItem.new(props) return end

---@class AnimFeature_IndustrialArm : animAnimFeature
---@field idleAnimNumber Int32
---@field isRotate Bool
---@field isDistraction Bool
---@field isPoke Bool
AnimFeature_IndustrialArm = {}

---@return AnimFeature_IndustrialArm
function AnimFeature_IndustrialArm.new() return end

---@param props table
---@return AnimFeature_IndustrialArm
function AnimFeature_IndustrialArm.new(props) return end

---@class AnimFeature_Inspection : animAnimFeature
---@field activeInspectionStage Int32
---@field rotationX Float
---@field rotationY Float
---@field offsetX Float
---@field offsetY Float
AnimFeature_Inspection = {}

---@return AnimFeature_Inspection
function AnimFeature_Inspection.new() return end

---@param props table
---@return AnimFeature_Inspection
function AnimFeature_Inspection.new(props) return end

---@class AnimFeature_KnockOffData : animAnimFeature
---@field knockedOff Bool
---@field direction Int32
---@field force Float
---@field draggedOff Bool
AnimFeature_KnockOffData = {}

---@return AnimFeature_KnockOffData
function AnimFeature_KnockOffData.new() return end

---@param props table
---@return AnimFeature_KnockOffData
function AnimFeature_KnockOffData.new(props) return end

---@class AnimFeature_LadderEnterStyleData : animAnimFeature
---@field enterStyle Int32
AnimFeature_LadderEnterStyleData = {}

---@return AnimFeature_LadderEnterStyleData
function AnimFeature_LadderEnterStyleData.new() return end

---@param props table
---@return AnimFeature_LadderEnterStyleData
function AnimFeature_LadderEnterStyleData.new(props) return end

---@class AnimFeature_Landing : animAnimFeature
---@field type Int32
---@field impactSpeed Float
AnimFeature_Landing = {}

---@return AnimFeature_Landing
function AnimFeature_Landing.new() return end

---@param props table
---@return AnimFeature_Landing
function AnimFeature_Landing.new(props) return end

---@class AnimFeature_LeftHandAnimation : animAnimFeature
---@field lockLeftHandAnimation Bool
AnimFeature_LeftHandAnimation = {}

---@return AnimFeature_LeftHandAnimation
function AnimFeature_LeftHandAnimation.new() return end

---@param props table
---@return AnimFeature_LeftHandAnimation
function AnimFeature_LeftHandAnimation.new(props) return end

---@class AnimFeature_LeftHandCyberware : animAnimFeature
---@field actionDuration Float
---@field state Int32
---@field isQuickAction Bool
---@field isChargeAction Bool
---@field isLoopAction Bool
---@field isCatchAction Bool
---@field isSafeAction Bool
---@field chargeNormalized Float
---@field hasCWPerk Bool
AnimFeature_LeftHandCyberware = {}

---@return AnimFeature_LeftHandCyberware
function AnimFeature_LeftHandCyberware.new() return end

---@param props table
---@return AnimFeature_LeftHandCyberware
function AnimFeature_LeftHandCyberware.new(props) return end

---@class AnimFeature_LookAt : animAnimFeature
---@field enableLookAt Int32
---@field enableLookAtChest Int32
---@field enableLookAtHead Int32
---@field enableLookAtLeftHanded Int32
---@field enableLookAtRightHanded Int32
---@field enableLookAtTwoHanded Int32
---@field gpLookAtTargetBlend Float
---@field gpLookAtUpBlend Float
---@field gpLookAtTarget Vector4
---@field gpLookAtUp Vector4
---@field lookAtChestMode Int32
---@field lookAtChestOverride Float
---@field lookAtHeadMode Int32
---@field lookAtHeadOverride Float
---@field lookAtLeftHandedMode Int32
---@field lookAtLeftHandedOverride Float
---@field lookAtRightHandedMode Int32
---@field lookAtRightHandedOverride Float
---@field lookAtTwoHandedMode Int32
---@field lookAtTwoHandedOverride Float
AnimFeature_LookAt = {}

---@return AnimFeature_LookAt
function AnimFeature_LookAt.new() return end

---@param props table
---@return AnimFeature_LookAt
function AnimFeature_LookAt.new(props) return end

---@class AnimFeature_MeleeAttack : animAnimFeature
---@field hit Bool
AnimFeature_MeleeAttack = {}

---@return AnimFeature_MeleeAttack
function AnimFeature_MeleeAttack.new() return end

---@param props table
---@return AnimFeature_MeleeAttack
function AnimFeature_MeleeAttack.new(props) return end

---@class AnimFeature_Mounting : animAnimFeature
---@field mountingState Int32
---@field parentSpeed Float
---@field parentHorizontalSpeed Float
AnimFeature_Mounting = {}

---@return AnimFeature_Mounting
function AnimFeature_Mounting.new() return end

---@param props table
---@return AnimFeature_Mounting
function AnimFeature_Mounting.new(props) return end

---@class AnimFeature_MuzzleData : animAnimFeature
---@field muzzleOffset Vector4
AnimFeature_MuzzleData = {}

---@return AnimFeature_MuzzleData
function AnimFeature_MuzzleData.new() return end

---@param props table
---@return AnimFeature_MuzzleData
function AnimFeature_MuzzleData.new(props) return end

---@class AnimFeature_NPCVehicleAdditionalFeatures : animAnimFeatureMarkUnstable
---@field state Bool
AnimFeature_NPCVehicleAdditionalFeatures = {}

---@return AnimFeature_NPCVehicleAdditionalFeatures
function AnimFeature_NPCVehicleAdditionalFeatures.new() return end

---@param props table
---@return AnimFeature_NPCVehicleAdditionalFeatures
function AnimFeature_NPCVehicleAdditionalFeatures.new(props) return end

---@class AnimFeature_OwnerType : animAnimFeature
---@field ownerEnum Int32
AnimFeature_OwnerType = {}

---@return AnimFeature_OwnerType
function AnimFeature_OwnerType.new() return end

---@param props table
---@return AnimFeature_OwnerType
function AnimFeature_OwnerType.new(props) return end

---@class AnimFeature_Paperdoll : animAnimFeature
---@field genderSelection Bool
---@field characterCreation Bool
---@field characterCreation_Head Bool
---@field characterCreation_Teeth Bool
---@field characterCreation_Nails Bool
---@field characterCreation_Eyes Bool
---@field characterCreation_Nose Bool
---@field characterCreation_Lips Bool
---@field characterCreation_Hair Bool
---@field characterCreation_Jaw Bool
---@field characterCreation_Summary Bool
---@field inventoryScreen Bool
---@field inventoryScreen_Weapon Bool
---@field inventoryScreen_Legs Bool
---@field inventoryScreen_Feet Bool
---@field inventoryScreen_Cyberware Bool
---@field inventoryScreen_QuickSlot Bool
---@field inventoryScreen_Consumable Bool
---@field inventoryScreen_Outfit Bool
---@field inventoryScreen_Head Bool
---@field inventoryScreen_Face Bool
---@field inventoryScreen_InnerChest Bool
---@field inventoryScreen_OuterChest Bool
AnimFeature_Paperdoll = {}

---@return AnimFeature_Paperdoll
function AnimFeature_Paperdoll.new() return end

---@param props table
---@return AnimFeature_Paperdoll
function AnimFeature_Paperdoll.new(props) return end

---@class AnimFeature_PartData : animAnimFeatureMarkUnstable
---@field state Int32
---@field duration Float
AnimFeature_PartData = {}

---@return AnimFeature_PartData
function AnimFeature_PartData.new() return end

---@param props table
---@return AnimFeature_PartData
function AnimFeature_PartData.new(props) return end

---@class AnimFeature_PerkDeviceData : animAnimFeature
---@field isUsed Bool
AnimFeature_PerkDeviceData = {}

---@return AnimFeature_PerkDeviceData
function AnimFeature_PerkDeviceData.new() return end

---@param props table
---@return AnimFeature_PerkDeviceData
function AnimFeature_PerkDeviceData.new(props) return end

---@return CName
function AnimFeature_PerkDeviceData.GetFeatureName() return end

---@class AnimFeature_PhotomodeFacial : animAnimFeature
---@field facialPoseIndex Int32
AnimFeature_PhotomodeFacial = {}

---@return AnimFeature_PhotomodeFacial
function AnimFeature_PhotomodeFacial.new() return end

---@param props table
---@return AnimFeature_PhotomodeFacial
function AnimFeature_PhotomodeFacial.new(props) return end

---@class AnimFeature_PhotomodePoseCategory : animAnimFeature
---@field poseCategoryIndex Int32
AnimFeature_PhotomodePoseCategory = {}

---@return AnimFeature_PhotomodePoseCategory
function AnimFeature_PhotomodePoseCategory.new() return end

---@param props table
---@return AnimFeature_PhotomodePoseCategory
function AnimFeature_PhotomodePoseCategory.new(props) return end

---@class AnimFeature_PlayerCoverActionWeaponHolster : animAnimFeature
---@field isWeaponHolstered Bool
AnimFeature_PlayerCoverActionWeaponHolster = {}

---@return AnimFeature_PlayerCoverActionWeaponHolster
function AnimFeature_PlayerCoverActionWeaponHolster.new() return end

---@param props table
---@return AnimFeature_PlayerCoverActionWeaponHolster
function AnimFeature_PlayerCoverActionWeaponHolster.new(props) return end

---@class AnimFeature_PlayerDeathAnimation : animAnimFeature
---@field animation Int32
AnimFeature_PlayerDeathAnimation = {}

---@return AnimFeature_PlayerDeathAnimation
function AnimFeature_PlayerDeathAnimation.new() return end

---@param props table
---@return AnimFeature_PlayerDeathAnimation
function AnimFeature_PlayerDeathAnimation.new(props) return end

---@class AnimFeature_PlayerHitReactionData : animAnimFeature
---@field hitDirection Float
---@field hitStrength Float
---@field isMeleeHit Bool
---@field isLightMeleeHit Bool
---@field isStrongMeleeHit Bool
---@field isQuickMeleeHit Bool
---@field isExplosion Bool
---@field isPressureWave Bool
---@field meleeAttackDirection Int32
AnimFeature_PlayerHitReactionData = {}

---@return AnimFeature_PlayerHitReactionData
function AnimFeature_PlayerHitReactionData.new() return end

---@param props table
---@return AnimFeature_PlayerHitReactionData
function AnimFeature_PlayerHitReactionData.new(props) return end

---@class AnimFeature_PlayerLocomotionStateMachine : animAnimFeature
---@field inAirState Bool
AnimFeature_PlayerLocomotionStateMachine = {}

---@return AnimFeature_PlayerLocomotionStateMachine
function AnimFeature_PlayerLocomotionStateMachine.new() return end

---@param props table
---@return AnimFeature_PlayerLocomotionStateMachine
function AnimFeature_PlayerLocomotionStateMachine.new(props) return end

---@class AnimFeature_PlayerPeekScale : animAnimFeature
---@field peekScale Float
AnimFeature_PlayerPeekScale = {}

---@return AnimFeature_PlayerPeekScale
function AnimFeature_PlayerPeekScale.new() return end

---@param props table
---@return AnimFeature_PlayerPeekScale
function AnimFeature_PlayerPeekScale.new(props) return end

---@class AnimFeature_PlayerVitals : animAnimFeature
---@field state Int32
---@field stateDuration Float
AnimFeature_PlayerVitals = {}

---@return AnimFeature_PlayerVitals
function AnimFeature_PlayerVitals.new() return end

---@param props table
---@return AnimFeature_PlayerVitals
function AnimFeature_PlayerVitals.new(props) return end

---@class AnimFeature_PreClimbing : animAnimFeature
---@field edgePositionLS Vector4
---@field valid Float
AnimFeature_PreClimbing = {}

---@return AnimFeature_PreClimbing
function AnimFeature_PreClimbing.new() return end

---@param props table
---@return AnimFeature_PreClimbing
function AnimFeature_PreClimbing.new(props) return end

---@class AnimFeature_ProceduralDriverCombatData : animAnimFeature
---@field isEnabled Bool
---@field yawDirectionFlipped Bool
---@field yaw Float
---@field pitch Float
---@field roll Float
AnimFeature_ProceduralDriverCombatData = {}

---@return AnimFeature_ProceduralDriverCombatData
function AnimFeature_ProceduralDriverCombatData.new() return end

---@param props table
---@return AnimFeature_ProceduralDriverCombatData
function AnimFeature_ProceduralDriverCombatData.new(props) return end

---@class AnimFeature_ProceduralIronsightData : animAnimFeature
---@field hasScope Bool
---@field isEnabled Bool
---@field offset Float
---@field scopeOffset Float
---@field position Vector4
---@field rotation Quaternion
AnimFeature_ProceduralIronsightData = {}

---@return AnimFeature_ProceduralIronsightData
function AnimFeature_ProceduralIronsightData.new() return end

---@param props table
---@return AnimFeature_ProceduralIronsightData
function AnimFeature_ProceduralIronsightData.new(props) return end

---@class AnimFeature_ProceduralLean : animAnimFeature
---@field angle_threshold Float
---@field max_turn_angle Float
---@field hips_shift_side Float
---@field hips_shift_down Float
---@field hips_tilt Float
---@field hips_turn Float
---@field spine_tilt Float
---@field spine_turn Float
---@field arms_counter_turn Float
---@field transform_multiplyer Float
---@field damp_value_walk Float
---@field damp_value_sprint Float
AnimFeature_ProceduralLean = {}

---@return AnimFeature_ProceduralLean
function AnimFeature_ProceduralLean.new() return end

---@param props table
---@return AnimFeature_ProceduralLean
function AnimFeature_ProceduralLean.new(props) return end

---@class AnimFeature_RagdollState : animAnimFeature
---@field isActive Bool
---@field hipsPolePitch Float
---@field speed Float
AnimFeature_RagdollState = {}

---@return AnimFeature_RagdollState
function AnimFeature_RagdollState.new() return end

---@param props table
---@return AnimFeature_RagdollState
function AnimFeature_RagdollState.new(props) return end

---@class AnimFeature_Reprimand : animAnimFeature
---@field state Int32
---@field isActive Bool
---@field isLocomotion Bool
---@field weaponType Int32
AnimFeature_Reprimand = {}

---@return AnimFeature_Reprimand
function AnimFeature_Reprimand.new() return end

---@param props table
---@return AnimFeature_Reprimand
function AnimFeature_Reprimand.new(props) return end

---@class AnimFeature_RoadBlock : animAnimFeature
---@field isOpening Bool
---@field duration Float
---@field initOpen Bool
AnimFeature_RoadBlock = {}

---@return AnimFeature_RoadBlock
function AnimFeature_RoadBlock.new() return end

---@param props table
---@return AnimFeature_RoadBlock
function AnimFeature_RoadBlock.new(props) return end

---@class AnimFeature_RoboticArm : animAnimFeature
---@field state Int32
AnimFeature_RoboticArm = {}

---@return AnimFeature_RoboticArm
function AnimFeature_RoboticArm.new() return end

---@param props table
---@return AnimFeature_RoboticArm
function AnimFeature_RoboticArm.new(props) return end

---@class AnimFeature_RotatingObject : animAnimFeature
---@field rotateClockwise Bool
---@field randomizeBladesRotation Bool
---@field maxRotationSpeed Float
---@field timeToMaxRotation Float
AnimFeature_RotatingObject = {}

---@return AnimFeature_RotatingObject
function AnimFeature_RotatingObject.new() return end

---@param props table
---@return AnimFeature_RotatingObject
function AnimFeature_RotatingObject.new(props) return end

---@class AnimFeature_SafeAction : animAnimFeature
---@field triggerHeld Bool
---@field inCover Bool
---@field safeActionDuration Float
AnimFeature_SafeAction = {}

---@return AnimFeature_SafeAction
function AnimFeature_SafeAction.new() return end

---@param props table
---@return AnimFeature_SafeAction
function AnimFeature_SafeAction.new(props) return end

---@class AnimFeature_SceneGameplayOverrides : animAnimFeature
---@field aimForced Bool
---@field safeForced Bool
---@field isAimOutTimeOverridden Bool
---@field aimOutTimeOverride Float
AnimFeature_SceneGameplayOverrides = {}

---@return AnimFeature_SceneGameplayOverrides
function AnimFeature_SceneGameplayOverrides.new() return end

---@param props table
---@return AnimFeature_SceneGameplayOverrides
function AnimFeature_SceneGameplayOverrides.new(props) return end

---@class AnimFeature_SceneSystem : animAnimFeature
---@field tier Int32
AnimFeature_SceneSystem = {}

---@return AnimFeature_SceneSystem
function AnimFeature_SceneSystem.new() return end

---@param props table
---@return AnimFeature_SceneSystem
function AnimFeature_SceneSystem.new(props) return end

---@class AnimFeature_SceneSystemCarrying : animAnimFeature
---@field carrying Bool
AnimFeature_SceneSystemCarrying = {}

---@return AnimFeature_SceneSystemCarrying
function AnimFeature_SceneSystemCarrying.new() return end

---@param props table
---@return AnimFeature_SceneSystemCarrying
function AnimFeature_SceneSystemCarrying.new(props) return end

---@class AnimFeature_SecurityTurretData : animAnimFeature
---@field Shoot Bool
---@field isRippedOff Bool
---@field ripOffSide Bool
---@field isOverriden Bool
AnimFeature_SecurityTurretData = {}

---@return AnimFeature_SecurityTurretData
function AnimFeature_SecurityTurretData.new() return end

---@param props table
---@return AnimFeature_SecurityTurretData
function AnimFeature_SecurityTurretData.new(props) return end

---@class AnimFeature_SelectRandomAnimSync : animAnimFeature
---@field value Int32
AnimFeature_SelectRandomAnimSync = {}

---@return AnimFeature_SelectRandomAnimSync
function AnimFeature_SelectRandomAnimSync.new() return end

---@param props table
---@return AnimFeature_SelectRandomAnimSync
function AnimFeature_SelectRandomAnimSync.new(props) return end

---@class AnimFeature_SensorDevice : animAnimFeature
---@field isCeiling Bool
---@field isInitialized Bool
---@field isTurnedOn Bool
---@field isDestroyed Bool
---@field wasHit Bool
---@field state Int32
---@field wakeState Int32
---@field isControlled Bool
---@field overrideRootRotation Float
---@field pitchAngle Float
---@field maxRotationAngle Float
---@field rotationSpeed Float
---@field currentRotation Vector4
AnimFeature_SensorDevice = {}

---@return AnimFeature_SensorDevice
function AnimFeature_SensorDevice.new() return end

---@param props table
---@return AnimFeature_SensorDevice
function AnimFeature_SensorDevice.new(props) return end

---@class AnimFeature_SimpleDevice : animAnimFeatureMarkUnstable
---@field isOpen Bool
---@field isOpenLeft Bool
---@field isOpenRight Bool
AnimFeature_SimpleDevice = {}

---@return AnimFeature_SimpleDevice
function AnimFeature_SimpleDevice.new() return end

---@param props table
---@return AnimFeature_SimpleDevice
function AnimFeature_SimpleDevice.new(props) return end

---@class AnimFeature_SimpleIkSystem : animAnimFeature
---@field isEnable Bool
---@field weight Float
---@field setPosition Bool
---@field position Vector4
---@field positionOffset Vector4
---@field setRotation Bool
---@field rotation Quaternion
---@field rotationOffset Quaternion
AnimFeature_SimpleIkSystem = {}

---@return AnimFeature_SimpleIkSystem
function AnimFeature_SimpleIkSystem.new() return end

---@param props table
---@return AnimFeature_SimpleIkSystem
function AnimFeature_SimpleIkSystem.new(props) return end

---@class AnimFeature_Stamina : animAnimFeature
---@field staminaValue Float
---@field tiredness Float
AnimFeature_Stamina = {}

---@return AnimFeature_Stamina
function AnimFeature_Stamina.new() return end

---@param props table
---@return AnimFeature_Stamina
function AnimFeature_Stamina.new(props) return end

---@class AnimFeature_StatusEffect : animAnimFeature
---@field state Int32
---@field duration Float
---@field variation Int32
---@field direction Int32
---@field impactDirection Int32
---@field knockdown Bool
---@field stunned Bool
---@field playImpact Bool
AnimFeature_StatusEffect = {}

---@return AnimFeature_StatusEffect
function AnimFeature_StatusEffect.new() return end

---@param props table
---@return AnimFeature_StatusEffect
function AnimFeature_StatusEffect.new(props) return end

function AnimFeature_StatusEffect:Clear() return end

---@class AnimFeature_StimReactions : animAnimFeature
---@field reactionType Int32
AnimFeature_StimReactions = {}

---@return AnimFeature_StimReactions
function AnimFeature_StimReactions.new() return end

---@param props table
---@return AnimFeature_StimReactions
function AnimFeature_StimReactions.new(props) return end

---@class AnimFeature_SuperheroLand : animAnimFeature
---@field state Int32
---@field type Int32
AnimFeature_SuperheroLand = {}

---@return AnimFeature_SuperheroLand
function AnimFeature_SuperheroLand.new() return end

---@param props table
---@return AnimFeature_SuperheroLand
function AnimFeature_SuperheroLand.new(props) return end

---@class AnimFeature_SwimmingData : animAnimFeature
---@field state Int32
AnimFeature_SwimmingData = {}

---@return AnimFeature_SwimmingData
function AnimFeature_SwimmingData.new() return end

---@param props table
---@return AnimFeature_SwimmingData
function AnimFeature_SwimmingData.new(props) return end

---@class AnimFeature_Throwable : animAnimFeature
---@field state Int32
AnimFeature_Throwable = {}

---@return AnimFeature_Throwable
function AnimFeature_Throwable.new() return end

---@param props table
---@return AnimFeature_Throwable
function AnimFeature_Throwable.new(props) return end

---@class AnimFeature_TriggerModeChange : animAnimFeature
---@field cycleTime Float
AnimFeature_TriggerModeChange = {}

---@return AnimFeature_TriggerModeChange
function AnimFeature_TriggerModeChange.new() return end

---@param props table
---@return AnimFeature_TriggerModeChange
function AnimFeature_TriggerModeChange.new(props) return end

---@class AnimFeature_Undead : animAnimFeature
---@field active Bool
AnimFeature_Undead = {}

---@return AnimFeature_Undead
function AnimFeature_Undead.new() return end

---@param props table
---@return AnimFeature_Undead
function AnimFeature_Undead.new(props) return end

---@class AnimFeature_VehicleData : animAnimFeature
---@field isInVehicle Bool
---@field isDriver Bool
---@field vehType Int32
---@field vehSlot Int32
---@field isInCombat Bool
---@field isInWindowCombat Bool
---@field isInDriverCombat Bool
---@field vehClass Int32
---@field isEnteringCombat Bool
---@field enteringCombatDuration Float
---@field isExitingCombat Bool
---@field exitingCombatDuration Float
---@field isEnteringVehicle Bool
---@field isExitingVehicle Bool
---@field isWorldRenderPlane Bool
AnimFeature_VehicleData = {}

---@return AnimFeature_VehicleData
function AnimFeature_VehicleData.new() return end

---@param props table
---@return AnimFeature_VehicleData
function AnimFeature_VehicleData.new(props) return end

---@class AnimFeature_VehicleNPCData : animAnimFeature
---@field isDriver Bool
---@field side Int32
---@field forcePanic Bool
AnimFeature_VehicleNPCData = {}

---@return AnimFeature_VehicleNPCData
function AnimFeature_VehicleNPCData.new() return end

---@param props table
---@return AnimFeature_VehicleNPCData
function AnimFeature_VehicleNPCData.new(props) return end

---@class AnimFeature_VehicleNPCDeathData : animAnimFeature
---@field deathType Int32
---@field side Int32
AnimFeature_VehicleNPCDeathData = {}

---@return AnimFeature_VehicleNPCDeathData
function AnimFeature_VehicleNPCDeathData.new() return end

---@param props table
---@return AnimFeature_VehicleNPCDeathData
function AnimFeature_VehicleNPCDeathData.new(props) return end

---@class AnimFeature_VehicleState : animAnimFeatureMarkUnstable
---@field tppEnabled Bool
AnimFeature_VehicleState = {}

---@return AnimFeature_VehicleState
function AnimFeature_VehicleState.new() return end

---@param props table
---@return AnimFeature_VehicleState
function AnimFeature_VehicleState.new(props) return end

---@class AnimFeature_VehicleSteeringLimit : animAnimFeatureMarkUnstable
---@field state Int32
AnimFeature_VehicleSteeringLimit = {}

---@return AnimFeature_VehicleSteeringLimit
function AnimFeature_VehicleSteeringLimit.new() return end

---@param props table
---@return AnimFeature_VehicleSteeringLimit
function AnimFeature_VehicleSteeringLimit.new(props) return end

---@class AnimFeature_WeaponBlur : animAnimFeature
---@field weaponNearPlane Float
---@field weaponFarPlane Float
---@field weaponEdgesSharpness Float
---@field weaponVignetteIntensity Float
---@field weaponVignetteRadius Float
---@field weaponVignetteCircular Float
---@field weaponBlurIntensity Float
---@field weaponNearPlane_aim Float
---@field weaponFarPlane_aim Float
---@field weaponEdgesSharpness_aim Float
---@field weaponVignetteIntensity_aim Float
---@field weaponVignetteRadius_aim Float
---@field weaponVignetteCircular_aim Float
---@field weaponBlurIntensity_aim Float
AnimFeature_WeaponBlur = {}

---@return AnimFeature_WeaponBlur
function AnimFeature_WeaponBlur.new() return end

---@param props table
---@return AnimFeature_WeaponBlur
function AnimFeature_WeaponBlur.new(props) return end

---@class AnimFeature_WeaponHandlingStats : animAnimFeature
---@field weaponRecoil Float
---@field weaponSpread Float
AnimFeature_WeaponHandlingStats = {}

---@return AnimFeature_WeaponHandlingStats
function AnimFeature_WeaponHandlingStats.new() return end

---@param props table
---@return AnimFeature_WeaponHandlingStats
function AnimFeature_WeaponHandlingStats.new(props) return end

---@class AnimFeature_WeaponOverride : animAnimFeature
---@field state Int32
AnimFeature_WeaponOverride = {}

---@return AnimFeature_WeaponOverride
function AnimFeature_WeaponOverride.new() return end

---@param props table
---@return AnimFeature_WeaponOverride
function AnimFeature_WeaponOverride.new(props) return end

---@class AnimFeature_WeaponOwnerVehicleData : animAnimFeature
---@field isOwnerDriver Bool
---@field isOwnerMountedToVehicle Bool
AnimFeature_WeaponOwnerVehicleData = {}

---@return AnimFeature_WeaponOwnerVehicleData
function AnimFeature_WeaponOwnerVehicleData.new() return end

---@param props table
---@return AnimFeature_WeaponOwnerVehicleData
function AnimFeature_WeaponOwnerVehicleData.new(props) return end

---@class AnimFeature_WeaponReload : animAnimFeature
---@field emptyReload Bool
---@field amountToReload Int32
---@field continueLoop Bool
---@field loopDuration Float
---@field emptyDuration Float
AnimFeature_WeaponReload = {}

---@return AnimFeature_WeaponReload
function AnimFeature_WeaponReload.new() return end

---@param props table
---@return AnimFeature_WeaponReload
function AnimFeature_WeaponReload.new(props) return end

---@class AnimFeature_WeaponReloadSpeedData : animAnimFeature
---@field reloadSpeed Float
---@field emptyReloadSpeed Float
AnimFeature_WeaponReloadSpeedData = {}

---@return AnimFeature_WeaponReloadSpeedData
function AnimFeature_WeaponReloadSpeedData.new() return end

---@param props table
---@return AnimFeature_WeaponReloadSpeedData
function AnimFeature_WeaponReloadSpeedData.new(props) return end

---@class AnimFeature_WeaponScopeData : animAnimFeature
---@field ironsightAngleWithScope Float
---@field hasScope Bool
AnimFeature_WeaponScopeData = {}

---@return AnimFeature_WeaponScopeData
function AnimFeature_WeaponScopeData.new() return end

---@param props table
---@return AnimFeature_WeaponScopeData
function AnimFeature_WeaponScopeData.new(props) return end

---@class AnimFeature_WeaponStats : animAnimFeature
---@field magazineCapacity Int32
---@field cycleTime Float
AnimFeature_WeaponStats = {}

---@return AnimFeature_WeaponStats
function AnimFeature_WeaponStats.new() return end

---@param props table
---@return AnimFeature_WeaponStats
function AnimFeature_WeaponStats.new(props) return end

---@class AnimFeature_Whip : animAnimFeature
---@field state Int32
---@field pullState Int32
---@field targetPoint Vector4
AnimFeature_Whip = {}

---@return AnimFeature_Whip
function AnimFeature_Whip.new() return end

---@param props table
---@return AnimFeature_Whip
function AnimFeature_Whip.new(props) return end

---@class AnimFeature_WorkspotIK : animAnimFeature
---@field rightHandPosition Vector4
---@field leftHandPosition Vector4
---@field cameraPosition Vector4
---@field rightHandRotation Quaternion
---@field leftHandRotation Quaternion
---@field cameraRotation Quaternion
---@field shouldCrouch Bool
---@field isInteractingWithDevice Bool
AnimFeature_WorkspotIK = {}

---@return AnimFeature_WorkspotIK
function AnimFeature_WorkspotIK.new() return end

---@param props table
---@return AnimFeature_WorkspotIK
function AnimFeature_WorkspotIK.new(props) return end

---@class AnimFeature_Zoom : animAnimFeature
---@field finalZoomLevel Float
---@field weaponZoomLevel Float
---@field weaponAimFOV Float
---@field worldFOV Float
---@field zoomLevelNum Int32
---@field noWeaponAimInTime Float
---@field noWeaponAimOutTime Float
---@field shouldUseWeaponZoomStats Bool
---@field focusModeActive Bool
---@field weaponScopeFov Float
AnimFeature_Zoom = {}

---@return AnimFeature_Zoom
function AnimFeature_Zoom.new() return end

---@param props table
---@return AnimFeature_Zoom
function AnimFeature_Zoom.new(props) return end

---@class AnimateAnchorOnHoverView : inkWidgetLogicController
---@field Raycaster inkWidgetReference
---@field AnimProxy inkanimProxy
---@field HoverAnchor Vector2
---@field NormalAnchor Vector2
---@field AnimTime Float
AnimateAnchorOnHoverView = {}

---@return AnimateAnchorOnHoverView
function AnimateAnchorOnHoverView.new() return end

---@param props table
---@return AnimateAnchorOnHoverView
function AnimateAnchorOnHoverView.new(props) return end

---@param e inkPointerEvent
---@return Bool
function AnimateAnchorOnHoverView:OnHoverOut(e) return end

---@param e inkPointerEvent
---@return Bool
function AnimateAnchorOnHoverView:OnHoverOver(e) return end

---@return Bool
function AnimateAnchorOnHoverView:OnInitialize() return end

---@return Bool
function AnimateAnchorOnHoverView:OnUninitialize() return end

---@param isHovered Bool
function AnimateAnchorOnHoverView:OnHoverChanged(isHovered) return end

function AnimateAnchorOnHoverView:StopAnimation() return end

---@class AnimatedListItemController : inkListItemController
---@field animOutName CName
---@field animPulseName CName
---@field animTargetHover inkWidgetReference
---@field animTargetPulse inkWidgetReference
---@field normalRootOpacity Float
---@field hoverRootOpacity Float
---@field rootWidget inkCompoundWidget
---@field animTarget_Hover inkWidget
---@field animTarget_Pulse inkWidget
---@field animHover inkanimDefinition
---@field animPulse inkanimDefinition
---@field animHoverProxy inkanimProxy
---@field animPulseProxy inkanimProxy
---@field animPulseOptions inkanimPlaybackOptions
AnimatedListItemController = {}

---@return AnimatedListItemController
function AnimatedListItemController.new() return end

---@param props table
---@return AnimatedListItemController
function AnimatedListItemController.new(props) return end

---@param target inkListItemController
---@return Bool
function AnimatedListItemController:OnAddedToList(target) return end

---@param controller inkButtonController
---@param oldState inkEButtonState
---@param newState inkEButtonState
---@return Bool
function AnimatedListItemController:OnButtonStateChanged(controller, oldState, newState) return end

---@return Bool
function AnimatedListItemController:OnInitialize() return end

---@return Bool
function AnimatedListItemController:OnUninitialize() return end

---@class AnimatedSign : InteractiveDevice
---@field animFeature AnimFeature_AnimatedDevice
AnimatedSign = {}

---@return AnimatedSign
function AnimatedSign.new() return end

---@param props table
---@return AnimatedSign
function AnimatedSign.new(props) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AnimatedSign:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AnimatedSign:OnTakeControl(ri) return end

function AnimatedSign:TurnOffDevice() return end

function AnimatedSign:TurnOnDevice() return end

function AnimatedSign:UpdateAnimState() return end

---@class AnimationChain : IScriptable
---@field data AnimationElement[]
---@field name CName
AnimationChain = {}

---@return AnimationChain
function AnimationChain.new() return end

---@param props table
---@return AnimationChain
function AnimationChain.new(props) return end

---@param name CName|string
---@param options inkanimPlaybackOptions
function AnimationChain:AddAnimation(name, options) return end

---@class AnimationChainPlayer : IScriptable
---@field animationProxy inkanimProxy
---@field current AnimationChain
---@field current_stage Int32
---@field next AnimationChain
---@field owner inkWidgetLogicController
AnimationChainPlayer = {}

---@return AnimationChainPlayer
function AnimationChainPlayer.new() return end

---@param props table
---@return AnimationChainPlayer
function AnimationChainPlayer.new(props) return end

---@param anim inkanimProxy
---@return Bool
function AnimationChainPlayer:OnNextAnimation(anim) return end

---@param animationChain AnimationChain
function AnimationChainPlayer:BeginAnimation(animationChain) return end

function AnimationChainPlayer:Clean() return end

---@param animOptions inkanimPlaybackOptions
---@return inkanimEventType
function AnimationChainPlayer:GetEndEvent(animOptions) return end

function AnimationChainPlayer:HandleInteruption() return end

---@param animationChain AnimationChain
function AnimationChainPlayer:Play(animationChain) return end

---@param stage Int32
function AnimationChainPlayer:PlayAnimationStage(stage) return end

---@param animationChain AnimationChain
function AnimationChainPlayer:PlayNow(animationChain) return end

---@class AnimationElement
---@field animation CName
---@field animOptions inkanimPlaybackOptions
AnimationElement = {}

---@return AnimationElement
function AnimationElement.new() return end

---@param props table
---@return AnimationElement
function AnimationElement.new(props) return end

---@class AnimationLogicController : inkWidgetLogicController
---@field imageView inkImageWidgetReference
AnimationLogicController = {}

---@return AnimationLogicController
function AnimationLogicController.new() return end

---@param props table
---@return AnimationLogicController
function AnimationLogicController.new(props) return end

---@param state String
---@return Bool
function AnimationLogicController:OnChangeState(state) return end

---@class AnimationSystemForcedVisibilityEntityData : IScriptable
---@field owner AnimationSystemForcedVisibilityManager
---@field entityID entEntityID
---@field forcedVisibilityInAnimSystemRequests ForcedVisibilityInAnimSystemData[]
---@field delayedForcedVisibilityInAnimSystemRequests ForcedVisibilityInAnimSystemData[]
---@field hasVisibilityForcedInAnimSystem Bool
---@field hasVisibilityForcedOnlyInFrustumInAnimSystem Bool
AnimationSystemForcedVisibilityEntityData = {}

---@return AnimationSystemForcedVisibilityEntityData
function AnimationSystemForcedVisibilityEntityData.new() return end

---@param props table
---@return AnimationSystemForcedVisibilityEntityData
function AnimationSystemForcedVisibilityEntityData.new(props) return end

---@param data ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityEntityData:AddDelayedForcedVisiblityInAnimSystemRequest(data) return end

---@param data ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityEntityData:AddForcedVisiblityInAnimSystemRequest(data) return end

function AnimationSystemForcedVisibilityEntityData:ClearAllRequests() return end

---@param sourceName CName|string
---@return ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityEntityData:GetDelayedForcedVisiblityInAnimSystemRequest(sourceName) return end

---@return entEntityID
function AnimationSystemForcedVisibilityEntityData:GetEntityID() return end

---@param sourceName CName|string
---@return ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityEntityData:GetForcedVisiblityInAnimSystemRequest(sourceName) return end

---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasActiveRequestsForForcedVisibilityInAnimSystem() return end

---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasActiveRequestsForForcedVisibilityOnlyInFrustumInAnimSystem() return end

---@param data ForcedVisibilityInAnimSystemData
---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasDelayedForcedVisiblityInAnimSystemRequest(data) return end

---@param sourceName CName|string
---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasDelayedForcedVisiblityInAnimSystemRequest(sourceName) return end

---@param data ForcedVisibilityInAnimSystemData
---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasForcedVisiblityInAnimSystemRequest(data) return end

---@param sourceName CName|string
---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasForcedVisiblityInAnimSystemRequest(sourceName) return end

---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasVisibilityForcedInAnimSystem() return end

---@return Bool
function AnimationSystemForcedVisibilityEntityData:HasVisibilityForcedOnlyInFrustumInAnimSystem() return end

---@param entityID entEntityID
---@param owner AnimationSystemForcedVisibilityManager
function AnimationSystemForcedVisibilityEntityData:Initialize(entityID, owner) return end

---@param data ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityEntityData:RemoveDelayedForcedVisiblityInAnimSystemRequest(data) return end

---@param data ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityEntityData:RemoveForcedVisiblityInAnimSystemRequest(data) return end

---@param sourceName CName|string
function AnimationSystemForcedVisibilityEntityData:RemoveForcedVisiblityInAnimSystemRequest(sourceName) return end

---@param isVisible Bool
function AnimationSystemForcedVisibilityEntityData:SetHasVisibilityForcedInAnimSystem(isVisible) return end

---@param isVisible Bool
function AnimationSystemForcedVisibilityEntityData:SetHasVisibilityForcedOnlyInFrustumInAnimSystem(isVisible) return end

---@class AnimationSystemForcedVisibilityManager : gameScriptableSystem
---@field entities AnimationSystemForcedVisibilityEntityData[]
AnimationSystemForcedVisibilityManager = {}

---@return AnimationSystemForcedVisibilityManager
function AnimationSystemForcedVisibilityManager.new() return end

---@param props table
---@return AnimationSystemForcedVisibilityManager
function AnimationSystemForcedVisibilityManager.new(props) return end

---@param data ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityManager:CancelDelayedRequestForVisilityData(data) return end

---@param id entEntityID
function AnimationSystemForcedVisibilityManager:ClearEntity(id) return end

---@param id entEntityID
---@return AnimationSystemForcedVisibilityEntityData
function AnimationSystemForcedVisibilityManager:GetEntityData(id) return end

---@param id entEntityID
---@return Bool
function AnimationSystemForcedVisibilityManager:HasVisibilityForced(id) return end

---@param id entEntityID
---@return Bool
function AnimationSystemForcedVisibilityManager:IsEntityRegistered(id) return end

---@param request ClearVisibilityInAnimSystemRequest
function AnimationSystemForcedVisibilityManager:OnClearVisibilityInAnimSystemRequest(request) return end

---@param request DelayedVisibilityInAnimSystemRequest
function AnimationSystemForcedVisibilityManager:OnHandleDelayedVisibilityInAnimSystemRequest(request) return end

---@param request ToggleVisibilityInAnimSystemRequest
function AnimationSystemForcedVisibilityManager:OnToggleVisibilityInAnimSystemRequest(request) return end

---@param entityData AnimationSystemForcedVisibilityEntityData
function AnimationSystemForcedVisibilityManager:ResovleVisibilityInAnimSystem(entityData) return end

---@param entityID entEntityID
---@param isVisible Bool
---@param transitionTime Float
---@param data ForcedVisibilityInAnimSystemData
function AnimationSystemForcedVisibilityManager:SendDelayedRequestForVisilityData(entityID, isVisible, transitionTime, data) return end

---@param entityID entEntityID
---@param sourceName CName|string
---@param isVisible Bool
---@param transitionTime Float
---@param forcedVisibleOnlyInFrustum Bool
function AnimationSystemForcedVisibilityManager:ToggleForcedVisibilityInAnimSystem(entityID, sourceName, isVisible, transitionTime, forcedVisibleOnlyInFrustum) return end

---@class AnimationsConstructor : IScriptable
---@field duration Float
---@field type inkanimInterpolationType
---@field mode inkanimInterpolationMode
---@field isAdditive Bool
AnimationsConstructor = {}

---@return AnimationsConstructor
function AnimationsConstructor.new() return end

---@param props table
---@return AnimationsConstructor
function AnimationsConstructor.new(props) return end

---@param startColor HDRColor
---@param endColor HDRColor
---@return inkanimColorInterpolator
function AnimationsConstructor:NewColorInterpolator(startColor, endColor) return end

---@param startMargin inkMargin
---@param endMargin inkMargin
---@return inkanimMarginInterpolator
function AnimationsConstructor:NewMarginInterpolator(startMargin, endMargin) return end

---@param startRotation Float
---@param endRotation Float
---@return inkanimRotationInterpolator
function AnimationsConstructor:NewRotationInterpolator(startRotation, endRotation) return end

---@param startSize Vector2
---@param endSize Vector2
---@return inkanimSizeInterpolator
function AnimationsConstructor:NewSizeInterpolator(startSize, endSize) return end

---@param animDuration Float
---@param animType inkanimInterpolationType
---@param animMode inkanimInterpolationMode
---@param isAdditive Bool
function AnimationsConstructor:SetGenericSettings(animDuration, animType, animMode, isAdditive) return end

---@class AnimationsLoaded : gameTaggedSignalUserData
AnimationsLoaded = {}

---@return AnimationsLoaded
function AnimationsLoaded.new() return end

---@param props table
---@return AnimationsLoaded
function AnimationsLoaded.new(props) return end

---@class AnimationsLoadedCondition : AIbehaviorconditionScript
---@field coreAnims Bool
---@field melee Bool
AnimationsLoadedCondition = {}

---@return AnimationsLoadedCondition
function AnimationsLoadedCondition.new() return end

---@param props table
---@return AnimationsLoadedCondition
function AnimationsLoadedCondition.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AnimationsLoadedCondition:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorConditionOutcomes
function AnimationsLoadedCondition:Check(context) return end

---@class AnimationsLoadedTask : AIbehaviortaskScript
---@field coreAnims Bool
---@field setSignal Bool
---@field melee Bool
AnimationsLoadedTask = {}

---@return AnimationsLoadedTask
function AnimationsLoadedTask.new() return end

---@param props table
---@return AnimationsLoadedTask
function AnimationsLoadedTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AnimationsLoadedTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AnimationsLoadedTask:Update(context) return end

---@class AntiRadar : gameweaponObject
---@field colliderComponent entIComponent
---@field gameEffectRef gameEffectRef
---@field gameEffectInstance gameEffectInstance
---@field jammedSensorsArray SensorDevice[]
AntiRadar = {}

---@return AntiRadar
function AntiRadar.new() return end

---@param props table
---@return AntiRadar
function AntiRadar.new(props) return end

---@param evt ChargeEndedEvent
---@return Bool
function AntiRadar:OnChargeEndedEvent(evt) return end

---@param evt ChargeStartedEvent
---@return Bool
function AntiRadar:OnChargeStartedEvent(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AntiRadar:OnRequestComponents(ri) return end

---@param evt SensorJammed
---@return Bool
function AntiRadar:OnSensorJammed(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AntiRadar:OnTakeControl(ri) return end

---@param newAppearance CName|string
function AntiRadar:ChangeAppearance(newAppearance) return end

---@class ApartmentScreen : LcdScreen
---@field timeSystemCallbackID Uint32
ApartmentScreen = {}

---@return ApartmentScreen
function ApartmentScreen.new() return end

---@param props table
---@return ApartmentScreen
function ApartmentScreen.new(props) return end

---@param evt DayPassedEvent
---@return Bool
function ApartmentScreen:OnDayPassed(evt) return end

---@return Bool
function ApartmentScreen:OnDetach() return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ApartmentScreen:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ApartmentScreen:OnTakeControl(ri) return end

---@return ApartmentScreenController
function ApartmentScreen:GetController() return end

---@return Int32
function ApartmentScreen:GetCurrentOverdueValue() return end

---@return ERentStatus
function ApartmentScreen:GetCurrentRentStatus() return end

---@return ApartmentScreenControllerPS
function ApartmentScreen:GetDevicePS() return end

function ApartmentScreen:RegisterDayUpdateCallback() return end

---@param ps gamePersistentState
---@return Bool
function ApartmentScreen:ResavePersistentData(ps) return end

function ApartmentScreen:ResolveGameplayState() return end

---@return Bool
function ApartmentScreen:ShouldShowOverdueValue() return end

function ApartmentScreen:UnregisterDayUpdateCallback() return end

---@class ApartmentScreenController : LcdScreenController
ApartmentScreenController = {}

---@return ApartmentScreenController
function ApartmentScreenController.new() return end

---@param props table
---@return ApartmentScreenController
function ApartmentScreenController.new(props) return end

---@return ApartmentScreenControllerPS
function ApartmentScreenController:GetPS() return end

---@class ApartmentScreenControllerPS : LcdScreenControllerPS
---@field initialRentStatus ERentStatus
---@field overdueMessageRecordID TweakDBID
---@field paidMessageRecordID TweakDBID
---@field evictionMessageRecordID TweakDBID
---@field paymentSchedule EPaymentSchedule
---@field showOverdueValue Bool
---@field randomizeInitialOverdue Bool
---@field initialOverdue Int32
---@field allowAutomaticRentStatusChange Bool
---@field maxDays Int32
---@field currentOverdue Int32
---@field isInitialRentStateSet Bool
---@field currentRentStatus ERentStatus
---@field lastStatusChangeDay Int32
ApartmentScreenControllerPS = {}

---@return ApartmentScreenControllerPS
function ApartmentScreenControllerPS.new() return end

---@param props table
---@return ApartmentScreenControllerPS
function ApartmentScreenControllerPS.new(props) return end

---@return Bool
function ApartmentScreenControllerPS:OnInstantiated() return end

function ApartmentScreenControllerPS:GameAttached() return end

---@return Int32
function ApartmentScreenControllerPS:GetCurrentDay() return end

---@return Int32
function ApartmentScreenControllerPS:GetCurrentOverdueValue() return end

---@return ERentStatus
function ApartmentScreenControllerPS:GetCurrentRentStatus() return end

---@return Int32
function ApartmentScreenControllerPS:GetDaysPassed() return end

---@return GameTime
function ApartmentScreenControllerPS:GetGameTime() return end

---@return Int32
function ApartmentScreenControllerPS:GetInitialOverdueValue() return end

---@return Int32
function ApartmentScreenControllerPS:GetPaymentScheduleValue() return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ApartmentScreenControllerPS:GetQuestActions(context) return end

---@return Int32
function ApartmentScreenControllerPS:GetStateChangeProbabilityValue() return end

function ApartmentScreenControllerPS:InitializeRentState() return end

---@param evt SetApartmentScreenMessageEvent
---@return EntityNotificationType
function ApartmentScreenControllerPS:OnSetApartmentScreenMessageEvent(evt) return end

---@param evt SetApartmentScreenStatusEvent
---@return EntityNotificationType
function ApartmentScreenControllerPS:OnSetApartmentScreenStatusEvent(evt) return end

function ApartmentScreenControllerPS:ReEvaluateRentStatus() return end

---@param status ERentStatus
function ApartmentScreenControllerPS:SetCurrentRentStatus(status) return end

---@return Bool
function ApartmentScreenControllerPS:ShouldShowOverdueValue() return end

function ApartmentScreenControllerPS:UpdateCurrentOverdue() return end

function ApartmentScreenControllerPS:UpdateRentState() return end

---@class ApartmentScreenInkGameController : LcdScreenInkGameController
---@field backgroundFrameWidget inkImageWidget
ApartmentScreenInkGameController = {}

---@return ApartmentScreenInkGameController
function ApartmentScreenInkGameController.new() return end

---@param props table
---@return ApartmentScreenInkGameController
function ApartmentScreenInkGameController.new(props) return end

---@return ApartmentScreen
function ApartmentScreenInkGameController:GetOwner() return end

---@param state EDeviceStatus
function ApartmentScreenInkGameController:Refresh(state) return end

---@param blackboard gameIBlackboard
function ApartmentScreenInkGameController:RegisterBlackboardCallbacks(blackboard) return end

---@param record gamedataScreenMessageData_Record
function ApartmentScreenInkGameController:ResolveMessegeRecord(record) return end

function ApartmentScreenInkGameController:SetupWidgets() return end

---@class AppearanceRandomizerComponent : gameScriptableComponent
---@field appearances CName[]
---@field isEnabled Bool
AppearanceRandomizerComponent = {}

---@return AppearanceRandomizerComponent
function AppearanceRandomizerComponent.new() return end

---@param props table
---@return AppearanceRandomizerComponent
function AppearanceRandomizerComponent.new(props) return end

---@param appearance CName|string
function AppearanceRandomizerComponent:ApplyAppearance(appearance) return end

function AppearanceRandomizerComponent:OnGameAttach() return end

---@return CName
function AppearanceRandomizerComponent:PickAppearance() return end

---@class ApplyAccumulatedDoTEffector : TriggerContinuousAttackEffector
ApplyAccumulatedDoTEffector = {}

---@return ApplyAccumulatedDoTEffector
function ApplyAccumulatedDoTEffector.new() return end

---@param props table
---@return ApplyAccumulatedDoTEffector
function ApplyAccumulatedDoTEffector.new(props) return end

---@param owner gameObject
function ApplyAccumulatedDoTEffector:ActionOff(owner) return end

---@class ApplyAnimWrappersOnWeapon : AIbehaviortaskScript
---@field wrapperName CName
---@field refOwner gamedataAIActionTarget_Record
---@field owner gameObject
---@field ownerPosition Vector4
---@field animationController entAnimationControllerComponent
ApplyAnimWrappersOnWeapon = {}

---@return ApplyAnimWrappersOnWeapon
function ApplyAnimWrappersOnWeapon.new() return end

---@param props table
---@return ApplyAnimWrappersOnWeapon
function ApplyAnimWrappersOnWeapon.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function ApplyAnimWrappersOnWeapon:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function ApplyAnimWrappersOnWeapon:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function ApplyAnimWrappersOnWeapon:Update(context) return end

---@class ApplyDamageDeviceOperation : DeviceOperationBase
---@field damages SDamageOperationData[]
ApplyDamageDeviceOperation = {}

---@return ApplyDamageDeviceOperation
function ApplyDamageDeviceOperation.new() return end

---@param props table
---@return ApplyDamageDeviceOperation
function ApplyDamageDeviceOperation.new(props) return end

---@param owner gameObject
function ApplyDamageDeviceOperation:Execute(owner) return end

---@param damagesArg SDamageOperationData[]
---@param owner gameObject
function ApplyDamageDeviceOperation:ResolveDamages(damagesArg, owner) return end

---@param owner gameObject
function ApplyDamageDeviceOperation:Restore(owner) return end

---@class ApplyDiodeLightPresetEvent : redEvent
---@field preset DiodeLightPreset
---@field delay Float
---@field duration Float
---@field force Bool
ApplyDiodeLightPresetEvent = {}

---@return ApplyDiodeLightPresetEvent
function ApplyDiodeLightPresetEvent.new() return end

---@param props table
---@return ApplyDiodeLightPresetEvent
function ApplyDiodeLightPresetEvent.new(props) return end

---@class ApplyDroneLocomotionWrapperEvent : redEvent
---@field movementType CName
ApplyDroneLocomotionWrapperEvent = {}

---@return ApplyDroneLocomotionWrapperEvent
function ApplyDroneLocomotionWrapperEvent.new() return end

---@param props table
---@return ApplyDroneLocomotionWrapperEvent
function ApplyDroneLocomotionWrapperEvent.new(props) return end

---@class ApplyDroneProceduralAnimFeatureEvent : redEvent
---@field feature AnimFeature_DroneProcedural
ApplyDroneProceduralAnimFeatureEvent = {}

---@return ApplyDroneProceduralAnimFeatureEvent
function ApplyDroneProceduralAnimFeatureEvent.new() return end

---@param props table
---@return ApplyDroneProceduralAnimFeatureEvent
function ApplyDroneProceduralAnimFeatureEvent.new(props) return end

---@class ApplyEffectToDismemberedEffector : gameEffector
ApplyEffectToDismemberedEffector = {}

---@return ApplyEffectToDismemberedEffector
function ApplyEffectToDismemberedEffector.new() return end

---@param props table
---@return ApplyEffectToDismemberedEffector
function ApplyEffectToDismemberedEffector.new(props) return end

---@return DismembermentInstigatedInfo
function ApplyEffectToDismemberedEffector:GetDismembermentInfo() return end

---@class ApplyEffectorEffector : gameEffector
---@field target entEntityID
---@field applicationTarget CName
---@field effectorToApply TweakDBID
ApplyEffectorEffector = {}

---@return ApplyEffectorEffector
function ApplyEffectorEffector.new() return end

---@param props table
---@return ApplyEffectorEffector
function ApplyEffectorEffector.new(props) return end

---@param owner gameObject
function ApplyEffectorEffector:ActionOff(owner) return end

---@param owner gameObject
function ApplyEffectorEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyEffectorEffector:Initialize(record, parentRecord) return end

function ApplyEffectorEffector:Uninitialize() return end

---@class ApplyJammer : gameEffectExecutor_Scripted
ApplyJammer = {}

---@return ApplyJammer
function ApplyJammer.new() return end

---@param props table
---@return ApplyJammer
function ApplyJammer.new(props) return end

---@param ctx gameEffectScriptContext
---@param applierCtx gameEffectExecutionScriptContext
---@return Bool
function ApplyJammer:Process(ctx, applierCtx) return end

---@class ApplyJammerFromCw : gameEffectExecutor_Scripted
ApplyJammerFromCw = {}

---@return ApplyJammerFromCw
function ApplyJammerFromCw.new() return end

---@param props table
---@return ApplyJammerFromCw
function ApplyJammerFromCw.new(props) return end

---@param ctx gameEffectScriptContext
---@param applierCtx gameEffectExecutionScriptContext
---@return Bool
function ApplyJammerFromCw:Process(ctx, applierCtx) return end

---@class ApplyLegendaryWhistleEffector : gameEffector
ApplyLegendaryWhistleEffector = {}

---@return ApplyLegendaryWhistleEffector
function ApplyLegendaryWhistleEffector.new() return end

---@param props table
---@return ApplyLegendaryWhistleEffector
function ApplyLegendaryWhistleEffector.new(props) return end

---@param owner gameObject
function ApplyLegendaryWhistleEffector:ActionOn(owner) return end

---@class ApplyLightPresetEffector : gameEffector
---@field lightPreset gamedataLightPreset_Record
ApplyLightPresetEffector = {}

---@return ApplyLightPresetEffector
function ApplyLightPresetEffector.new() return end

---@param props table
---@return ApplyLightPresetEffector
function ApplyLightPresetEffector.new(props) return end

---@param owner gameObject
function ApplyLightPresetEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyLightPresetEffector:Initialize(record, parentRecord) return end

---@param owner gameObject
---@param colorValues Int32[]
---@param strength Float
---@param time Float
---@param curve CName|string
---@param loop Bool
function ApplyLightPresetEffector:SendChangeLightEvent(owner, colorValues, strength, time, curve, loop) return end

---@class ApplyNewStatusEffectEvent : redEvent
---@field effectID TweakDBID
---@field instigatorID TweakDBID
ApplyNewStatusEffectEvent = {}

---@return ApplyNewStatusEffectEvent
function ApplyNewStatusEffectEvent.new() return end

---@param props table
---@return ApplyNewStatusEffectEvent
function ApplyNewStatusEffectEvent.new(props) return end

---@param effectName String
function ApplyNewStatusEffectEvent:SetEffectID(effectName) return end

---@class ApplyObjectActionEffector : gameEffector
---@field actionID TweakDBID
---@field triggered Bool
---@field probability Float
ApplyObjectActionEffector = {}

---@return ApplyObjectActionEffector
function ApplyObjectActionEffector.new() return end

---@param props table
---@return ApplyObjectActionEffector
function ApplyObjectActionEffector.new(props) return end

---@param owner gameObject
function ApplyObjectActionEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyObjectActionEffector:Initialize(record, parentRecord) return end

---@class ApplyQuickhackEffector : AbstractApplyQuickhackEffector
---@field quickhackObjectActionID TweakDBID
---@field quickhackObjectActionRecord gamedataObjectAction_Record
---@field MaxUploadChance Float
---@field uploadTime Float
ApplyQuickhackEffector = {}

---@return ApplyQuickhackEffector
function ApplyQuickhackEffector.new() return end

---@param props table
---@return ApplyQuickhackEffector
function ApplyQuickhackEffector.new(props) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyQuickhackEffector:Initialize(record, parentRecord) return end

---@param hitEvent gameeventsHitEvent
---@param playerPuppet PlayerPuppet
---@param targetScriptedPuppet ScriptedPuppet
function ApplyQuickhackEffector:ProcessApplyQuickhackAction(hitEvent, playerPuppet, targetScriptedPuppet) return end

---@class ApplyRandomStatusEffectEffector : gameEffector
---@field targetEntityID entEntityID
---@field applicationTarget CName
---@field effects TweakDBID[]
---@field appliedEffect TweakDBID
ApplyRandomStatusEffectEffector = {}

---@return ApplyRandomStatusEffectEffector
function ApplyRandomStatusEffectEffector.new() return end

---@param props table
---@return ApplyRandomStatusEffectEffector
function ApplyRandomStatusEffectEffector.new(props) return end

---@param owner gameObject
function ApplyRandomStatusEffectEffector:ActionOff(owner) return end

---@param owner gameObject
function ApplyRandomStatusEffectEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyRandomStatusEffectEffector:Initialize(record, parentRecord) return end

function ApplyRandomStatusEffectEffector:RemoveStatusEffect() return end

function ApplyRandomStatusEffectEffector:SetRandomStatusEffect() return end

function ApplyRandomStatusEffectEffector:Uninitialize() return end

---@class ApplyRelicMeleewareDamageOnNPCEvent : redEvent
---@field newHitEvent gameeventsHitEvent
---@field hitPosition Vector4
---@field target NPCPuppet
---@field weapon gameweaponObject
---@field weaponType gamedataItemType
ApplyRelicMeleewareDamageOnNPCEvent = {}

---@return ApplyRelicMeleewareDamageOnNPCEvent
function ApplyRelicMeleewareDamageOnNPCEvent.new() return end

---@param props table
---@return ApplyRelicMeleewareDamageOnNPCEvent
function ApplyRelicMeleewareDamageOnNPCEvent.new(props) return end

---@class ApplyShaderEffector : gameEffector
---@field overrideMaterialName CName
---@field overrideMaterialTag CName
---@field applyToOwner Bool
---@field applyToWeapon Bool
---@field owner gameObject
---@field ownerWeapons gameItemObject[]
---@field isEnabled Bool
ApplyShaderEffector = {}

---@return ApplyShaderEffector
function ApplyShaderEffector.new() return end

---@param props table
---@return ApplyShaderEffector
function ApplyShaderEffector.new(props) return end

---@param owner gameObject
function ApplyShaderEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyShaderEffector:Initialize(record, parentRecord) return end

function ApplyShaderEffector:Uninitialize() return end

---@class ApplyShaderOnEquipmentEffector : gameEffector
---@field overrideMaterialName CName
---@field overrideMaterialTag CName
---@field effectInstance gameEffectInstance
---@field owner gameObject
---@field ownerEffect gameEffectInstance
ApplyShaderOnEquipmentEffector = {}

---@return ApplyShaderOnEquipmentEffector
function ApplyShaderOnEquipmentEffector.new() return end

---@param props table
---@return ApplyShaderOnEquipmentEffector
function ApplyShaderOnEquipmentEffector.new(props) return end

---@param owner gameObject
function ApplyShaderOnEquipmentEffector:ActionOn(owner) return end

---@return TweakDBID[]
function ApplyShaderOnEquipmentEffector:GetAttachmentSlotsForEquipment() return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyShaderOnEquipmentEffector:Initialize(record, parentRecord) return end

function ApplyShaderOnEquipmentEffector:Uninitialize() return end

---@class ApplyShaderOnObjectEffector : gameEffector
---@field applicationTargetName CName
---@field applicationTarget gameObject
---@field effects gameEffectInstance[]
---@field overrideMaterialName CName
---@field overrideMaterialTag CName
---@field overrideMaterialClearOnDetach Bool
---@field effectInstance gameEffectInstance
---@field owner gameObject
---@field ownerEffect gameEffectInstance
ApplyShaderOnObjectEffector = {}

---@return ApplyShaderOnObjectEffector
function ApplyShaderOnObjectEffector.new() return end

---@param props table
---@return ApplyShaderOnObjectEffector
function ApplyShaderOnObjectEffector.new(props) return end

---@param owner gameObject
function ApplyShaderOnObjectEffector:ActionOff(owner) return end

---@param owner gameObject
function ApplyShaderOnObjectEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyShaderOnObjectEffector:Initialize(record, parentRecord) return end

function ApplyShaderOnObjectEffector:Uninitialize() return end

---@class ApplyStatGroupEffector : gameEffector
---@field target gameStatsObjectID
---@field record TweakDBID
---@field applicationTarget CName
---@field modGroupID Uint64
---@field stackCount Uint8
---@field removeWithEffector Bool
---@field reapplyOnWeaponChange Bool
---@field owner gameObject
---@field ownerSlotCallback ApplyStatGroupEffectorCallback
---@field ownerSlotListener gameAttachmentSlotsScriptListener
ApplyStatGroupEffector = {}

---@return ApplyStatGroupEffector
function ApplyStatGroupEffector.new() return end

---@param props table
---@return ApplyStatGroupEffector
function ApplyStatGroupEffector.new(props) return end

---@param owner gameObject
function ApplyStatGroupEffector:ActionOff(owner) return end

---@param owner gameObject
function ApplyStatGroupEffector:ActionOn(owner) return end

function ApplyStatGroupEffector:ApplyModifierGroup() return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyStatGroupEffector:Initialize(record, parentRecord) return end

function ApplyStatGroupEffector:ProcessEffector() return end

function ApplyStatGroupEffector:RemoveModifierGroup() return end

---@param owner gameObject
function ApplyStatGroupEffector:RepeatedAction(owner) return end

function ApplyStatGroupEffector:Uninitialize() return end

---@class ApplyStatGroupEffectorCallback : gameAttachmentSlotsScriptCallback
---@field effector ApplyStatGroupEffector
ApplyStatGroupEffectorCallback = {}

---@return ApplyStatGroupEffectorCallback
function ApplyStatGroupEffectorCallback.new() return end

---@param props table
---@return ApplyStatGroupEffectorCallback
function ApplyStatGroupEffectorCallback.new(props) return end

---@param slot TweakDBID|string
---@param item ItemID
function ApplyStatGroupEffectorCallback:OnItemEquipped(slot, item) return end

---@param slot TweakDBID|string
---@param item ItemID
function ApplyStatGroupEffectorCallback:OnItemUnequipped(slot, item) return end

---@class ApplyStatusEffectByChanceEffector : gameEffector
---@field targetEntityID entEntityID
---@field applicationTarget CName
---@field record TweakDBID
---@field removeWithEffector Bool
---@field effectorChanceMods gamedataStatModifier_Record[]
ApplyStatusEffectByChanceEffector = {}

---@return ApplyStatusEffectByChanceEffector
function ApplyStatusEffectByChanceEffector.new() return end

---@param props table
---@return ApplyStatusEffectByChanceEffector
function ApplyStatusEffectByChanceEffector.new(props) return end

---@param owner gameObject
function ApplyStatusEffectByChanceEffector:ActionOff(owner) return end

function ApplyStatusEffectByChanceEffector:ApplyStatusEffect() return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyStatusEffectByChanceEffector:Initialize(record, parentRecord) return end

function ApplyStatusEffectByChanceEffector:RemoveStatusEffect() return end

---@param owner gameObject
function ApplyStatusEffectByChanceEffector:RepeatedAction(owner) return end

function ApplyStatusEffectByChanceEffector:Uninitialize() return end

---@class ApplyStatusEffectDeviceOperation : DeviceOperationBase
---@field statusEffects SStatusEffectOperationData[]
ApplyStatusEffectDeviceOperation = {}

---@return ApplyStatusEffectDeviceOperation
function ApplyStatusEffectDeviceOperation.new() return end

---@param props table
---@return ApplyStatusEffectDeviceOperation
function ApplyStatusEffectDeviceOperation.new(props) return end

---@param owner gameObject
function ApplyStatusEffectDeviceOperation:Execute(owner) return end

---@param statusEffectsArg SStatusEffectOperationData[]
---@param owner gameObject
function ApplyStatusEffectDeviceOperation:ResolveStatusEffects(statusEffectsArg, owner) return end

---@param owner gameObject
function ApplyStatusEffectDeviceOperation:Restore(owner) return end

---@class ApplyStatusEffectEffector : gameEffector
---@field targetEntityID entEntityID
---@field applicationTarget CName
---@field record TweakDBID
---@field removeWithEffector Bool
---@field inverted Bool
---@field useCountWhenRemoving Bool
---@field count Float
---@field instigator String
ApplyStatusEffectEffector = {}

---@return ApplyStatusEffectEffector
function ApplyStatusEffectEffector.new() return end

---@param props table
---@return ApplyStatusEffectEffector
function ApplyStatusEffectEffector.new(props) return end

---@param owner gameObject
function ApplyStatusEffectEffector:ActionOff(owner) return end

---@param owner gameObject
function ApplyStatusEffectEffector:ActionOn(owner) return end

function ApplyStatusEffectEffector:ApplyStatusEffect() return end

---@return gameObject
function ApplyStatusEffectEffector:GetInstigator() return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function ApplyStatusEffectEffector:Initialize(record, parentRecord) return end

---@param owner gameObject
function ApplyStatusEffectEffector:ProcessAction(owner) return end

function ApplyStatusEffectEffector:RemoveStatusEffect() return end

---@param owner gameObject
function ApplyStatusEffectEffector:RepeatedAction(owner) return end

function ApplyStatusEffectEffector:Uninitialize() return end

---@class ApplyStatusEffectOnOwner : StatusEffectTasks
---@field statusEffectID TweakDBID
ApplyStatusEffectOnOwner = {}

---@return ApplyStatusEffectOnOwner
function ApplyStatusEffectOnOwner.new() return end

---@param props table
---@return ApplyStatusEffectOnOwner
function ApplyStatusEffectOnOwner.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function ApplyStatusEffectOnOwner:Activate(context) return end

---@class ApproachVehicleDecorator : AIVehicleTaskAbstract
---@field mountData AIArgumentMapping
---@field mountRequest AIArgumentMapping
---@field entryPoint AIArgumentMapping
---@field doorOpenRequestSent Bool
---@field closeDoor Bool
---@field mountEventData gameMountEventData
---@field mountRequestData gameMountEventData
---@field mountEntryPoint Vector4
---@field activationTime EngineTime
---@field runCompanionCheck Bool
---@field slotOccupiedTimestamp Float
ApproachVehicleDecorator = {}

---@return ApproachVehicleDecorator
function ApproachVehicleDecorator.new() return end

---@param props table
---@return ApproachVehicleDecorator
function ApproachVehicleDecorator.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function ApproachVehicleDecorator:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function ApproachVehicleDecorator:Deactivate(context) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function ApproachVehicleDecorator:Update(context) return end

---@param context AIbehaviorScriptExecutionContext
---@param ownerVehicle vehicleBaseObject
---@param delay Float
---@return Bool
function ApproachVehicleDecorator:UpdateCompanionChecks(context, ownerVehicle, delay) return end

---@class ArcadeMachine : InteractiveDevice
---@field arcadeMachineType ArcadeMachineType
---@field isShortGlitchActive Bool
---@field shortGlitchDelayID gameDelayID
---@field currentGameVideo redResourceReferenceScriptToken
---@field currentGameAudio CName
---@field currentGameAudioStop CName
---@field meshAppearanceOn CName
---@field meshAppearanceOff CName
---@field arcadeMinigameComponent workWorkspotResourceComponent
---@field minigame ArcadeMinigame
---@field combatStateListener redCallbackObject
ArcadeMachine = {}

---@return ArcadeMachine
function ArcadeMachine.new() return end

---@param props table
---@return ArcadeMachine
function ArcadeMachine.new(props) return end

---@param evt BeginArcadeMinigameUI
---@return Bool
function ArcadeMachine:OnBeginArcadeMinigameUI(evt) return end

---@param value Int32
---@return Bool
function ArcadeMachine:OnCombatStateChanged(value) return end

---@param hit gameeventsHitEvent
---@return Bool
function ArcadeMachine:OnHitEvent(hit) return end

---@param evt GameAttachedEvent
---@return Bool
function ArcadeMachine:OnPersitentStateInitialized(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function ArcadeMachine:OnRequestComponents(ri) return end

---@param evt StopShortGlitchEvent
---@return Bool
function ArcadeMachine:OnStopShortGlitch(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function ArcadeMachine:OnTakeControl(ri) return end

---@param target entEntityID
---@param statusEffect TweakDBID|string
function ArcadeMachine:ApplyActiveStatusEffect(target, statusEffect) return end

function ArcadeMachine:CreateBlackboard() return end

function ArcadeMachine:CutPower() return end

---@return EGameplayRole
function ArcadeMachine:DeterminGameplayRole() return end

---@return CName
function ArcadeMachine:GetArcadeGameAudio() return end

---@return CName
function ArcadeMachine:GetArcadeGameAudioStop() return end

---@return redResourceReferenceScriptToken
function ArcadeMachine:GetArcadeGameVideo() return end

---@return ArcadeMachineBlackboardDef
function ArcadeMachine:GetBlackboardDef() return end

---@return ArcadeMachineController
function ArcadeMachine:GetController() return end

---@return ArcadeMachineControllerPS
function ArcadeMachine:GetDevicePS() return end

---@param evt gameinteractionsInteractionActivationEvent
---@param isInteractionActive Bool
function ArcadeMachine:OnDirectInteractionActive(evt, isInteractionActive) return end

---@param ps gamePersistentState
---@return Bool
function ArcadeMachine:ResavePersistentData(ps) return end

function ArcadeMachine:ResolveGameplayState() return end

function ArcadeMachine:Setup() return end

function ArcadeMachine:SetupMinigame() return end

---@param glitchState EGlitchState
---@param intensity Float
function ArcadeMachine:StartGlitching(glitchState, intensity) return end

function ArcadeMachine:StartShortGlitch() return end

function ArcadeMachine:StopGlitching() return end

function ArcadeMachine:TurnOffDevice() return end

function ArcadeMachine:TurnOffScreen() return end

function ArcadeMachine:TurnOnDevice() return end

function ArcadeMachine:TurnOnScreen() return end

---@param targetID entEntityID
function ArcadeMachine:UploadActiveProgramOnNPC(targetID) return end

---@class ArcadeMachineBlackboardDef : DeviceBaseBlackboardDef
ArcadeMachineBlackboardDef = {}

---@return ArcadeMachineBlackboardDef
function ArcadeMachineBlackboardDef.new() return end

---@param props table
---@return ArcadeMachineBlackboardDef
function ArcadeMachineBlackboardDef.new(props) return end

---@class ArcadeMachineController : ScriptableDeviceComponent
ArcadeMachineController = {}

---@return ArcadeMachineController
function ArcadeMachineController.new() return end

---@param props table
---@return ArcadeMachineController
function ArcadeMachineController.new(props) return end

---@return ArcadeMachineControllerPS
function ArcadeMachineController:GetPS() return end

---@class ArcadeMachineControllerPS : ScriptableDeviceComponentPS
---@field gameVideosPaths redResourceReferenceScriptToken[]
---@field DEBUG_enableArcadeMinigames Bool
---@field minigame ArcadeMinigame
---@field combatStateListener redCallbackObject
ArcadeMachineControllerPS = {}

---@return ArcadeMachineControllerPS
function ArcadeMachineControllerPS.new() return end

---@param props table
---@return ArcadeMachineControllerPS
function ArcadeMachineControllerPS.new(props) return end

---@return Bool
function ArcadeMachineControllerPS:OnInstantiated() return end

---@param executor gameObject
---@return BeginArcadeMinigameUI
function ArcadeMachineControllerPS:ActionBeginArcadeMinigame(executor) return end

---@return Bool
function ArcadeMachineControllerPS:CanCreateAnyQuickHackActions() return end

---@param context gameGetActionsContext
---@return Bool, gamedeviceAction[]
function ArcadeMachineControllerPS:GetActions(context) return end

---@return TweakDBID
function ArcadeMachineControllerPS:GetBackgroundTextureTweakDBID() return end

---@return ArcadeMachineBlackboardDef
function ArcadeMachineControllerPS:GetBlackboardDef() return end

---@return TweakDBID
function ArcadeMachineControllerPS:GetDeviceIconTweakDBID() return end

---@return redResourceReferenceScriptToken
function ArcadeMachineControllerPS:GetGameVideoPath() return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ArcadeMachineControllerPS:GetQuestActions(context) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function ArcadeMachineControllerPS:GetQuickHackActions(context) return end

---@return Bool
function ArcadeMachineControllerPS:IsPlayable() return end

---@return Bool
function ArcadeMachineControllerPS:IsPlayerInteractingWithDevice() return end

---@param evt BeginArcadeMinigameUI
---@return EntityNotificationType
function ArcadeMachineControllerPS:OnBeginArcadeMinigameUI(evt) return end

---@param minigame ArcadeMinigame
function ArcadeMachineControllerPS:SetArcadeMinigame(minigame) return end

---@return Bool
function ArcadeMachineControllerPS:ShouldExposePersonalLinkAction() return end

---@class ArcadeMachineInkGameController : DeviceInkGameControllerBase
---@field defaultUI inkCanvasWidget
---@field mainDisplayWidget inkVideoWidget
---@field counterWidget inkTextWidget
---@field onGlitchingStateChangedListener redCallbackObject
ArcadeMachineInkGameController = {}

---@return ArcadeMachineInkGameController
function ArcadeMachineInkGameController.new() return end

---@param props table
---@return ArcadeMachineInkGameController
function ArcadeMachineInkGameController.new(props) return end

---@param value String
---@return Bool
function ArcadeMachineInkGameController:OnTimeToDepartChanged(value) return end

---@return Bool
function ArcadeMachineInkGameController:OnUninitialize() return end

---@return ArcadeMachine
function ArcadeMachineInkGameController:GetOwner() return end

---@param videoPath redResourceReferenceScriptToken
---@param looped Bool
---@param audioEvent CName|string
function ArcadeMachineInkGameController:PlayVideo(videoPath, looped, audioEvent) return end

---@param state EDeviceStatus
function ArcadeMachineInkGameController:Refresh(state) return end

---@param blackboard gameIBlackboard
function ArcadeMachineInkGameController:RegisterBlackboardCallbacks(blackboard) return end

function ArcadeMachineInkGameController:SetupWidgets() return end

---@param glitchData GlitchData
function ArcadeMachineInkGameController:StartGlitchingScreen(glitchData) return end

function ArcadeMachineInkGameController:StopGlitchingScreen() return end

function ArcadeMachineInkGameController:StopVideo() return end

function ArcadeMachineInkGameController:TurnOff() return end

function ArcadeMachineInkGameController:TurnOn() return end

---@param blackboard gameIBlackboard
function ArcadeMachineInkGameController:UnRegisterBlackboardCallbacks(blackboard) return end

---@param widgetsData SActionWidgetPackage[]
function ArcadeMachineInkGameController:UpdateActionWidgets(widgetsData) return end

---@class ArcadeMinigameUserData : inkUserData
---@field minigame ArcadeMinigame
ArcadeMinigameUserData = {}

---@return ArcadeMinigameUserData
function ArcadeMinigameUserData.new() return end

---@param props table
---@return ArcadeMinigameUserData
function ArcadeMinigameUserData.new(props) return end

---@return CName
function ArcadeMinigameUserData:GetMinigameName() return end

---@class AreaDisplayData : IDisplayData
---@field attributeId TweakDBID
---@field perks PerkDisplayData[]
---@field locked Bool
---@field proficency gamedataProficiencyType
---@field area gamedataPerkArea
AreaDisplayData = {}

---@return AreaDisplayData
function AreaDisplayData.new() return end

---@param props table
---@return AreaDisplayData
function AreaDisplayData.new(props) return end

---@class AreaEffectData : IScriptable
---@field action ScriptableDeviceAction
---@field actionRecordID TweakDBID
---@field areaEffectID CName
---@field indicatorEffectName CName
---@field useIndicatorEffect Bool
---@field indicatorEffectSize Float
---@field stimRange Float
---@field stimLifetime Float
---@field stimType DeviceStimType
---@field stimSource NodeRef
---@field additionaStimSources NodeRef[]
---@field investigateSpot NodeRef
---@field investigateController Bool
---@field controllerSource NodeRef
---@field highlightTargets Bool
---@field highlightType EFocusForcedHighlightType
---@field outlineType EFocusOutlineType
---@field highlightPriority EPriority
---@field effectInstance gameEffectInstance
---@field gameEffectOverrideName CName
AreaEffectData = {}

---@return AreaEffectData
function AreaEffectData.new() return end

---@param props table
---@return AreaEffectData
function AreaEffectData.new(props) return end

---@param areaEffectDataToCopy AreaEffectData
function AreaEffectData:CopyData(areaEffectDataToCopy) return end

---@param sAreaEffectDataToCopy SAreaEffectData
function AreaEffectData:CopyData(sAreaEffectDataToCopy) return end

function AreaEffectData:EffectInstanceClear() return end

---@param record gamedataObjectAction_Record
---@return CName
function AreaEffectData:GetActionNameFromRecord(record) return end

---@return CName
function AreaEffectData:GetActionNameFromRecord() return end

---@return gamedataObjectAction_Record
function AreaEffectData:GetActionRecord() return end

---@return SAreaEffectData
function AreaEffectData:GetData() return end

---@param _action BaseScriptableAction
---@return Bool
function AreaEffectData:IsMatching(_action) return end

---@param effect gameEffectInstance
function AreaEffectData:SetEffectInstance(effect) return end

---@class AreaEffectTargetData : IScriptable
---@field areaEffectID CName
---@field onSelf Bool
---@field onSlaves Bool
AreaEffectTargetData = {}

---@return AreaEffectTargetData
function AreaEffectTargetData.new() return end

---@param props table
---@return AreaEffectTargetData
function AreaEffectTargetData.new(props) return end

---@class AreaEffectVisualisationRequest : redEvent
---@field areaEffectID CName
---@field show Bool
AreaEffectVisualisationRequest = {}

---@return AreaEffectVisualisationRequest
function AreaEffectVisualisationRequest.new() return end

---@param props table
---@return AreaEffectVisualisationRequest
function AreaEffectVisualisationRequest.new(props) return end

---@class AreaEffectVisualizationComponent : gameScriptableComponent
---@field fxResourceMapper FxResourceMapperComponent
---@field forceHighlightTargetBuckets GameEffectTargetVisualizationData[]
---@field availableQuickHacks CName[]
---@field availablespiderbotActions CName[]
---@field activeAction BaseScriptableAction
---@field activeEffectIndex Int32
AreaEffectVisualizationComponent = {}

---@return AreaEffectVisualizationComponent
function AreaEffectVisualizationComponent.new() return end

---@param props table
---@return AreaEffectVisualizationComponent
function AreaEffectVisualizationComponent.new(props) return end

---@param evt AddForceHighlightTargetEvent
---@return Bool
function AreaEffectVisualizationComponent:OnAddForceHighlightTarget(evt) return end

---@param evt AreaEffectVisualisationRequest
---@return Bool
function AreaEffectVisualizationComponent:OnAreaEffectVisualisationRequest(evt) return end

---@param evt HUDInstruction
---@return Bool
function AreaEffectVisualizationComponent:OnHUDInstruction(evt) return end

---@param evt QHackWheelItemChangedEvent
---@return Bool
function AreaEffectVisualizationComponent:OnQHackWheelItemChanged(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function AreaEffectVisualizationComponent:OnRequestComponents(ri) return end

---@param evt ResponseEvent
---@return Bool
function AreaEffectVisualizationComponent:OnResponse(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function AreaEffectVisualizationComponent:OnTakeControl(ri) return end

---@param bucketName CName|string
---@param entityID entEntityID
function AreaEffectVisualizationComponent:AddTargetToBucket(bucketName, entityID) return end

---@param data FocusForcedHighlightData
function AreaEffectVisualizationComponent:CancelForcedVisionAppearance(data) return end

---@param data FocusForcedHighlightData
function AreaEffectVisualizationComponent:ForceVisionAppearance(data) return end

---@return FxResourceMapperComponent
function AreaEffectVisualizationComponent:GetFxMapper() return end

---@param bucketName CName|string
function AreaEffectVisualizationComponent:RemoveBucket(bucketName) return end

---@param activated Bool
---@param instanceState InstanceState
function AreaEffectVisualizationComponent:ResolveAreaEffectVisualisations(activated, instanceState) return end

---@param show Bool
function AreaEffectVisualizationComponent:ResolveAreaEffectsInFocusModeVisibility(show) return end

---@param show Bool
---@param instanceState InstanceState
function AreaEffectVisualizationComponent:ResolveAreaEffectsVisibility(show, instanceState) return end

---@param show Bool
function AreaEffectVisualizationComponent:ResolveAreaQuickHacksVisibility(show) return end

---@param show Bool
---@param action BaseScriptableAction
function AreaEffectVisualizationComponent:ResolveAreaQuickHacksVisibility(show, action) return end

---@param show Bool
function AreaEffectVisualizationComponent:ResolveAreaSpiderbotVisibility(show) return end

---@param bucketName CName|string
---@param evt redEvent
function AreaEffectVisualizationComponent:SendEventToBucket(bucketName, evt) return end

---@param effectData AreaEffectData
function AreaEffectVisualizationComponent:StartDrawingAreaEffectRange(effectData) return end

---@param effectDataIDX Int32
---@param responseData IScriptable
function AreaEffectVisualizationComponent:StartHighlightingTargets(effectDataIDX, responseData) return end

---@param effectData AreaEffectData
function AreaEffectVisualizationComponent:StopDrawingAreaEffectRange(effectData) return end

---@param effectDataIDX Int32
---@param responseData IScriptable
function AreaEffectVisualizationComponent:StopHighlightingTargets(effectDataIDX, responseData) return end

---@param effectDataIDX Int32
---@param show Bool
---@param responseData IScriptable
function AreaEffectVisualizationComponent:ToggleAreaEffectVisibility(effectDataIDX, show, responseData) return end

---@class AreaEntry
---@field user entEntityID
AreaEntry = {}

---@return AreaEntry
function AreaEntry.new() return end

---@param props table
---@return AreaEntry
function AreaEntry.new(props) return end

---@class AreaShapeOutline : ISerializable
---@field points Vector3[]
---@field height Float
AreaShapeOutline = {}

---@return AreaShapeOutline
function AreaShapeOutline.new() return end

---@param props table
---@return AreaShapeOutline
function AreaShapeOutline.new(props) return end

---@class AreaTypeTransition
---@field transitionTo ESecurityAreaType
---@field transitionHour Int32
---@field transitionMode ETransitionMode
---@field listenerID Uint32
---@field locked Bool
AreaTypeTransition = {}

---@return AreaTypeTransition
function AreaTypeTransition.new() return end

---@param props table
---@return AreaTypeTransition
function AreaTypeTransition.new(props) return end

---@class Arm : redEvent
---@field requester gameObject
Arm = {}

---@return Arm
function Arm.new() return end

---@param props table
---@return Arm
function Arm.new(props) return end

---@class ArmorEquipGameController : gameuiMenuGameController
---@field inventoryCanvas inkWidget
---@field inventoryList inkVerticalPanelWidget
---@field inventory gameItemData[]
---@field player PlayerPuppet
---@field equipmentSystem EquipmentSystem
---@field subCharacterSystem SubCharacterSystem
---@field transactionSystem gameTransactionSystem
---@field craftingSystem CraftingSystem
---@field buttonScrollUp inkCanvasWidget
---@field buttonScrollDn inkCanvasWidget
---@field buttonPlayer inkCanvasWidget
---@field buttonFlathead inkCanvasWidget
---@field buttonToolbox inkCanvasWidget
---@field panelPlayer inkCanvasWidget
---@field panelFlathead inkCanvasWidget
---@field panelToolbox inkCanvasWidget
---@field uiBB_Equipment UI_EquipmentDef
---@field uiBB_EquipmentBlackboard gameIBlackboard
---@field backgroundVideo inkVideoWidget
---@field paperdollVideo inkVideoWidget
---@field areaTags CName[]
---@field inventoryManager InventoryDataManager
---@field equipArea gamedataEquipmentArea
---@field slotIndex Int32
---@field recipeItemList TweakDBID[]
---@field playerCraftBook CraftBook
---@field tooltipsLibrary redResourceReferenceScriptToken
---@field itemTooltipName CName
---@field tooltipStylePath redResourceReferenceScriptToken
---@field tooltipLeft InventorySlotTooltip
---@field tooltipRight InventorySlotTooltip
---@field tooltipContainer inkCompoundWidget
---@field paperDollList CName[]
---@field scrollOffset Int32
---@field faceTags CName[]
---@field headTags CName[]
---@field chestTags CName[]
---@field legTags CName[]
---@field weaponTags CName[]
---@field consumableTags CName[]
---@field modulesTags CName[]
---@field framesTags CName[]
---@field operationsMode operationsMode
ArmorEquipGameController = {}

---@return ArmorEquipGameController
function ArmorEquipGameController.new() return end

---@param props table
---@return ArmorEquipGameController
function ArmorEquipGameController.new(props) return end

---@return Bool
function ArmorEquipGameController:OnInitialize() return end

---@return InventorySlotTooltip
function ArmorEquipGameController:CreateTooltip() return end

---@param itemID ItemID
---@param quantity Int32
function ArmorEquipGameController:DisassembleItem(itemID, quantity) return end

---@param itemData gameItemData
---@param slotId Int32
function ArmorEquipGameController:HelperAddInventoryButton(itemData, slotId) return end

---@param argTitle String
---@param containerSlot inkCanvasWidget
---@param equipArea gamedataEquipmentArea
---@param slotIndex Int32
---@param areaTags CName[]|string[]
function ArmorEquipGameController:HelperAddPaperdollButton(argTitle, containerSlot, equipArea, slotIndex, areaTags) return end

---@param slotId Int32
function ArmorEquipGameController:HelperClearButton(slotId) return end

function ArmorEquipGameController:HideTooltips() return end

---@param value Variant
function ArmorEquipGameController:OnEquipmentChange(value) return end

---@param value Variant
function ArmorEquipGameController:OnInventoryChange(value) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnInventoryItemEnter(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnInventoryItemExit(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnInventoryItemPush(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnPaperDollCursor(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnPaperdollItemEnter(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnPaperdollItemExit(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnScrollDn(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnScrollUp(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnSelectFlathead(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnSelectPlayer(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:OnSelectToolbox(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:ProcessFlatheadClick(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:ProcessPaperDollFlatheadClick(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:ProcessPaperDollPlayerClick(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:ProcessPlayerClick(e) return end

---@param e inkPointerEvent
function ArmorEquipGameController:ProcessToolboxClick(e) return end

function ArmorEquipGameController:RefreshEquipment() return end

function ArmorEquipGameController:RefreshFlatheadEquipment() return end

function ArmorEquipGameController:RefreshInventoryList() return end

function ArmorEquipGameController:RefreshPlayerEquipment() return end

---@param tooltipItemData gameItemData
---@param equippedItemId ItemID
function ArmorEquipGameController:RefreshTooltipsInventory(tooltipItemData, equippedItemId) return end

---@param tooltipItemData gameItemViewData
function ArmorEquipGameController:RefreshTooltipsPaperdoll(tooltipItemData) return end

---@param items gameItemData[]
---@return gameItemData[]
function ArmorEquipGameController:RemovedCyberware(items) return end

function ArmorEquipGameController:SetCraftList() return end

---@class ArmorEquipInventoryItemController : inkButtonDpadSupportedController
---@field itemID ItemID
---@field itemData gameItemData
---@field empty Bool
ArmorEquipInventoryItemController = {}

---@return ArmorEquipInventoryItemController
function ArmorEquipInventoryItemController.new() return end

---@param props table
---@return ArmorEquipInventoryItemController
function ArmorEquipInventoryItemController.new(props) return end

---@return Bool
function ArmorEquipInventoryItemController:OnInitialize() return end

function ArmorEquipInventoryItemController:ClearButton() return end

---@return Bool
function ArmorEquipInventoryItemController:GetIsEmpty() return end

---@return gameItemData
function ArmorEquipInventoryItemController:GetItemData() return end

---@return ItemID
function ArmorEquipInventoryItemController:GetItemID() return end

---@param itemData gameItemData
---@param itemQuantity Int32
---@param disassemblable Bool
function ArmorEquipInventoryItemController:SetButtonDetails(itemData, itemQuantity, disassemblable) return end

---@class ArmorStatListener : gameScriptStatPoolsListener
---@field ownerPuppet PlayerPuppet
ArmorStatListener = {}

---@return ArmorStatListener
function ArmorStatListener.new() return end

---@param props table
---@return ArmorStatListener
function ArmorStatListener.new(props) return end

---@param oldValue Float
---@param newValue Float
---@param percToPoints Float
function ArmorStatListener:OnStatPoolValueChanged(oldValue, newValue, percToPoints) return end

---@class ArmsCWInSlotCallback : gameAttachmentSlotsScriptCallback
---@field state ArmsCWInSlotPrereqState
ArmsCWInSlotCallback = {}

---@return ArmsCWInSlotCallback
function ArmsCWInSlotCallback.new() return end

---@param props table
---@return ArmsCWInSlotCallback
function ArmsCWInSlotCallback.new(props) return end

---@param slot TweakDBID|string
---@param item ItemID
function ArmsCWInSlotCallback:OnAttachmentRefreshed(slot, item) return end

---@param slot TweakDBID|string
---@param item ItemID
function ArmsCWInSlotCallback:OnItemEquipped(slot, item) return end

---@param slot TweakDBID|string
---@param item ItemID
function ArmsCWInSlotCallback:OnItemUnequipped(slot, item) return end

---@param state gamePrereqState
function ArmsCWInSlotCallback:RegisterState(state) return end

---@class ArmsCWInSlotPrereq : gameIScriptablePrereq
---@field equipmentArea gamedataEquipmentArea
---@field slotCheckType gamedataCheckType
---@field itemType gamedataItemType
---@field itemTag CName
---@field invert Bool
ArmsCWInSlotPrereq = {}

---@return ArmsCWInSlotPrereq
function ArmsCWInSlotPrereq.new() return end

---@param props table
---@return ArmsCWInSlotPrereq
function ArmsCWInSlotPrereq.new(props) return end

---@param itemID ItemID
---@return Bool
function ArmsCWInSlotPrereq:Evaluate(itemID) return end

---@param owner gameObject
---@return Bool
function ArmsCWInSlotPrereq:EvaluateAll(owner) return end

---@param itemID ItemID
---@param tag CName|string
---@return Bool
function ArmsCWInSlotPrereq:EvaluateTag(itemID, tag) return end

---@param itemType gamedataItemType
---@return Bool
function ArmsCWInSlotPrereq:EvaluateType(itemType) return end

---@param recordID TweakDBID|string
function ArmsCWInSlotPrereq:Initialize(recordID) return end

---@param context IScriptable
---@return Bool
function ArmsCWInSlotPrereq:IsFulfilled(context) return end

---@param state gamePrereqState
---@param context IScriptable
function ArmsCWInSlotPrereq:OnApplied(state, context) return end

---@param state gamePrereqState
---@param context IScriptable
---@return Bool
function ArmsCWInSlotPrereq:OnRegister(state, context) return end

---@param state gamePrereqState
---@param context IScriptable
function ArmsCWInSlotPrereq:OnUnregister(state, context) return end

---@class ArmsCWInSlotPrereqState : gamePrereqState
---@field listener ArmsCWInSlotCallback
---@field owner gameObject
ArmsCWInSlotPrereqState = {}

---@return ArmsCWInSlotPrereqState
function ArmsCWInSlotPrereqState.new() return end

---@param props table
---@return ArmsCWInSlotPrereqState
function ArmsCWInSlotPrereqState.new(props) return end

---@param itemID ItemID
function ArmsCWInSlotPrereqState:AreaChanged(itemID) return end

---@class ArrowButton : inkButtonController
---@field direction Direction
ArrowButton = {}

---@return ArrowButton
function ArrowButton.new() return end

---@param props table
---@return ArrowButton
function ArrowButton.new(props) return end

---@return Bool
function ArrowButton:OnInitialize() return end

---@return Bool
function ArrowButton:OnUninitialize() return end

---@param evt inkPointerEvent
function ArrowButton:OnClick(evt) return end

---@param evt inkPointerEvent
function ArrowButton:OnHoverOut(evt) return end

---@param evt inkPointerEvent
function ArrowButton:OnHoverOver(evt) return end

---@param stateName CName|string
function ArrowButton:SetState(stateName) return end

---@class ArrowClickedEvent : redEvent
---@field direction Direction
ArrowClickedEvent = {}

---@return ArrowClickedEvent
function ArrowClickedEvent.new() return end

---@param props table
---@return ArrowClickedEvent
function ArrowClickedEvent.new(props) return end

---@class AssignHotkeyIfEmptySlot : gamePlayerScriptableSystemRequest
---@field itemID ItemID
AssignHotkeyIfEmptySlot = {}

---@return AssignHotkeyIfEmptySlot
function AssignHotkeyIfEmptySlot.new() return end

---@param props table
---@return AssignHotkeyIfEmptySlot
function AssignHotkeyIfEmptySlot.new(props) return end

---@param itemID ItemID
---@param owner gameObject
---@return AssignHotkeyIfEmptySlot
function AssignHotkeyIfEmptySlot.Construct(itemID, owner) return end

---@return Bool
function AssignHotkeyIfEmptySlot:IsValid() return end

---@return ItemID
function AssignHotkeyIfEmptySlot:ItemID() return end

---@return gameObject
function AssignHotkeyIfEmptySlot:Owner() return end

---@class AssignRestrictMovementAreaHandler : AIbehaviortaskScript
---@field inCommand AIArgumentMapping
---@field resultOnNoChange AIbehaviorCompletionStatus
AssignRestrictMovementAreaHandler = {}

---@return AssignRestrictMovementAreaHandler
function AssignRestrictMovementAreaHandler.new() return end

---@param props table
---@return AssignRestrictMovementAreaHandler
function AssignRestrictMovementAreaHandler.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AssignRestrictMovementAreaHandler:Update(context) return end

---@class AssignRestrictMovementAreaTask : AIbehaviortaskScript
---@field restrictMovementAreaRef AIArgumentMapping
AssignRestrictMovementAreaTask = {}

---@return AssignRestrictMovementAreaTask
function AssignRestrictMovementAreaTask.new() return end

---@param props table
---@return AssignRestrictMovementAreaTask
function AssignRestrictMovementAreaTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
---@return AIbehaviorUpdateOutcome
function AssignRestrictMovementAreaTask:Update(context) return end

---@class AssignToCyberwareWheelRequest : gamePlayerScriptableSystemRequest
---@field itemID ItemID
---@field slotIndex Int32
AssignToCyberwareWheelRequest = {}

---@return AssignToCyberwareWheelRequest
function AssignToCyberwareWheelRequest.new() return end

---@param props table
---@return AssignToCyberwareWheelRequest
function AssignToCyberwareWheelRequest.new(props) return end

---@class AssualtRifleLookAtDecisions : lookAtPresetGunBaseDecisions
AssualtRifleLookAtDecisions = {}

---@return AssualtRifleLookAtDecisions
function AssualtRifleLookAtDecisions.new() return end

---@param props table
---@return AssualtRifleLookAtDecisions
function AssualtRifleLookAtDecisions.new(props) return end

---@class AssualtRifleLookAtEvents : lookAtPresetGunBaseEvents
AssualtRifleLookAtEvents = {}

---@return AssualtRifleLookAtEvents
function AssualtRifleLookAtEvents.new() return end

---@param props table
---@return AssualtRifleLookAtEvents
function AssualtRifleLookAtEvents.new(props) return end

---@class AsyncSpawnData : IScriptable
---@field callbackTarget IScriptable
---@field controller IScriptable
---@field functionName CName
---@field libraryID CName
---@field widgetData Variant
AsyncSpawnData = {}

---@return AsyncSpawnData
function AsyncSpawnData.new() return end

---@param props table
---@return AsyncSpawnData
function AsyncSpawnData.new(props) return end

---@param callbackTarget IScriptable
---@param functionName CName|string
---@param widgetData Variant
---@param controller IScriptable
function AsyncSpawnData:Initialize(callbackTarget, functionName, widgetData, controller) return end

---@class AtmosphereAreaSettings : IAreaSettings
---@field skydomeColor curveData
---@field skylightColor curveData
---@field groundReflectance curveData
---@field sunMinZ curveData
---@field horizonMinZ curveData
---@field horizonFalloff curveData
---@field turbidity curveData
---@field lutTurbidity curveData
---@field artisticDarkeningColor curveData
---@field artisticDarkeningStartPoint curveData
---@field artisticDarkeningEndPoint curveData
---@field artisticDarkeningExponent curveData
---@field sunColor curveData
---@field sunFalloff curveData
---@field rayTracedSunShadowRange curveData
---@field moonColor curveData
---@field moonFalloff curveData
---@field moonGlowIntensity curveData
---@field moonGlowFalloff curveData
---@field moonTexture CBitmapTexture
---@field galaxyIntensity curveData
---@field starMapIntensity curveData
---@field starMapBrightScale curveData
---@field starMapDimScale curveData
---@field starMapConstelationsScale curveData
---@field starCornerLuminanceFix curveData
---@field starMapTexture CCubeTexture
---@field galaxyTexture CBitmapTexture
---@field probeColorOverrideHorizon curveData
---@field probeAlphaOverrideHorizon curveData
---@field probeColorOverrideZenith curveData
---@field probeAlphaOverrideZenith curveData
AtmosphereAreaSettings = {}

---@return AtmosphereAreaSettings
function AtmosphereAreaSettings.new() return end

---@param props table
---@return AtmosphereAreaSettings
function AtmosphereAreaSettings.new(props) return end

---@class AttachCapsuleVisionBlockerEffector : gameEffector
---@field visionBlockerRegistrar senseVisionBlockersRegistrar
---@field visionBlockerType EVisionBlockerType
---@field visionBlockerId Uint32
---@field visionBlockerOffset Vector3
---@field visionBlockerRadius Float
---@field visionBlockerHeight Float
---@field visionBlockerDetectionModifier Float
---@field visionBlockerTBHModifier Float
---@field isBlockingCompletely Bool
---@field blocksParent Bool
AttachCapsuleVisionBlockerEffector = {}

---@return AttachCapsuleVisionBlockerEffector
function AttachCapsuleVisionBlockerEffector.new() return end

---@param props table
---@return AttachCapsuleVisionBlockerEffector
function AttachCapsuleVisionBlockerEffector.new(props) return end

---@param owner gameObject
function AttachCapsuleVisionBlockerEffector:ActionOff(owner) return end

---@param owner gameObject
function AttachCapsuleVisionBlockerEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function AttachCapsuleVisionBlockerEffector:Initialize(record, parentRecord) return end

function AttachCapsuleVisionBlockerEffector:Uninitialize() return end

function AttachCapsuleVisionBlockerEffector:UnregisterVisionBlocker() return end

---@class AttachVendorRequest : MarketSystemRequest
AttachVendorRequest = {}

---@return AttachVendorRequest
function AttachVendorRequest.new() return end

---@param props table
---@return AttachVendorRequest
function AttachVendorRequest.new(props) return end

---@class AttachmentSlotCacheData
---@field empty Bool
---@field attachmentSlotRecord gamedataAttachmentSlot_Record
---@field shouldBeAvailable Bool
---@field slotId TweakDBID
AttachmentSlotCacheData = {}

---@return AttachmentSlotCacheData
function AttachmentSlotCacheData.new() return end

---@param props table
---@return AttachmentSlotCacheData
function AttachmentSlotCacheData.new(props) return end

---@class AttackSubtypeHitPrereqCondition : BaseHitPrereqCondition
---@field attackSubtype gamedataAttackSubtype
AttackSubtypeHitPrereqCondition = {}

---@return AttackSubtypeHitPrereqCondition
function AttackSubtypeHitPrereqCondition.new() return end

---@param props table
---@return AttackSubtypeHitPrereqCondition
function AttackSubtypeHitPrereqCondition.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function AttackSubtypeHitPrereqCondition:Evaluate(hitEvent) return end

---@param recordID TweakDBID|string
function AttackSubtypeHitPrereqCondition:SetData(recordID) return end

---@class AttackTagHitPrereqCondition : BaseHitPrereqCondition
---@field attackTag CName
AttackTagHitPrereqCondition = {}

---@return AttackTagHitPrereqCondition
function AttackTagHitPrereqCondition.new() return end

---@param props table
---@return AttackTagHitPrereqCondition
function AttackTagHitPrereqCondition.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function AttackTagHitPrereqCondition:Evaluate(hitEvent) return end

---@param recordID TweakDBID|string
function AttackTagHitPrereqCondition:SetData(recordID) return end

---@class AttackTypeHitPrereqCondition : BaseHitPrereqCondition
---@field attackType gamedataAttackType
AttackTypeHitPrereqCondition = {}

---@return AttackTypeHitPrereqCondition
function AttackTypeHitPrereqCondition.new() return end

---@param props table
---@return AttackTypeHitPrereqCondition
function AttackTypeHitPrereqCondition.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function AttackTypeHitPrereqCondition:Evaluate(hitEvent) return end

---@param recordID TweakDBID|string
function AttackTypeHitPrereqCondition:SetData(recordID) return end

---@class Attack_Beam : gameAttack_Continuous
Attack_Beam = {}

---@return Attack_Beam
function Attack_Beam.new() return end

---@param props table
---@return Attack_Beam
function Attack_Beam.new(props) return end

---@param weapon gameweaponObject
function Attack_Beam:OnTick(weapon) return end

---@class AttemptedToStopFactsSet : BunkerSystemsFactsSet
AttemptedToStopFactsSet = {}

---@return AttemptedToStopFactsSet
function AttemptedToStopFactsSet.new() return end

---@param props table
---@return AttemptedToStopFactsSet
function AttemptedToStopFactsSet.new(props) return end

---@class AttributeBoughtEvent : redEvent
---@field attributeType gamedataStatType
AttributeBoughtEvent = {}

---@return AttributeBoughtEvent
function AttributeBoughtEvent.new() return end

---@param props table
---@return AttributeBoughtEvent
function AttributeBoughtEvent.new(props) return end

---@class AttributeData : IDisplayData
---@field label String
---@field icon String
---@field id TweakDBID
---@field value Int32
---@field maxValue Int32
---@field description String
---@field availableToUpgrade Bool
---@field type gamedataStatType
AttributeData = {}

---@return AttributeData
function AttributeData.new() return end

---@param props table
---@return AttributeData
function AttributeData.new(props) return end

---@param manager PlayerDevelopmentDataManager
---@return BasePerksMenuTooltipData
function AttributeData:CreateTooltipData(manager) return end

---@class AttributeDisplayData : IDisplayData
---@field attributeId TweakDBID
---@field proficiencies ProficiencyDisplayData[]
AttributeDisplayData = {}

---@return AttributeDisplayData
function AttributeDisplayData.new() return end

---@param props table
---@return AttributeDisplayData
function AttributeDisplayData.new(props) return end

---@param manager PlayerDevelopmentDataManager
---@return BasePerksMenuTooltipData
function AttributeDisplayData:CreateTooltipData(manager) return end

---@class AttributeTooltipData : BasePerksMenuTooltipData
---@field attributeId TweakDBID
---@field attributeType PerkMenuAttribute
---@field attributeData AttributeData
---@field displayData AttributeDisplayData
AttributeTooltipData = {}

---@return AttributeTooltipData
function AttributeTooltipData.new() return end

---@param props table
---@return AttributeTooltipData
function AttributeTooltipData.new(props) return end

function AttributeTooltipData:RefreshRuntimeData() return end

---@class AttributeUpdatedEvent : redEvent
---@field attributeId TweakDBID
AttributeUpdatedEvent = {}

---@return AttributeUpdatedEvent
function AttributeUpdatedEvent.new() return end

---@param props table
---@return AttributeUpdatedEvent
function AttributeUpdatedEvent.new(props) return end

---@class AttributeUpgradePurchased : redEvent
---@field attributeType PerkMenuAttribute
---@field attributeData AttributeData
AttributeUpgradePurchased = {}

---@return AttributeUpgradePurchased
function AttributeUpgradePurchased.new() return end

---@param props table
---@return AttributeUpgradePurchased
function AttributeUpgradePurchased.new(props) return end

---@class AudioFunctionalTests : IScriptable
AudioFunctionalTests = {}

---@return AudioFunctionalTests
function AudioFunctionalTests.new() return end

---@param props table
---@return AudioFunctionalTests
function AudioFunctionalTests.new(props) return end

function AudioFunctionalTests:IsSoundbankLoaded() return end

---@class AuthorisationNotification : GenericNotificationController
AuthorisationNotification = {}

---@return AuthorisationNotification
function AuthorisationNotification.new() return end

---@param props table
---@return AuthorisationNotification
function AuthorisationNotification.new(props) return end

---@param notificationData gameuiGenericNotificationViewData
function AuthorisationNotification:SetNotificationData(notificationData) return end

---@class AuthorisationNotificationEvent : redEvent
---@field type gameuiAuthorisationNotificationType
AuthorisationNotificationEvent = {}

---@return AuthorisationNotificationEvent
function AuthorisationNotificationEvent.new() return end

---@param props table
---@return AuthorisationNotificationEvent
function AuthorisationNotificationEvent.new(props) return end

---@class AuthorisationNotificationQueue : gameuiGenericNotificationGameController
---@field duration Float
AuthorisationNotificationQueue = {}

---@return AuthorisationNotificationQueue
function AuthorisationNotificationQueue.new() return end

---@param props table
---@return AuthorisationNotificationQueue
function AuthorisationNotificationQueue.new(props) return end

---@param evt AuthorisationNotificationEvent
---@return Bool
function AuthorisationNotificationQueue:OnAuthorisationNotification(evt) return end

---@class AuthorizationData
---@field isAuthorizationModuleOn Bool
---@field alwaysExposeActions Bool
---@field authorizationDataEntry SecurityAccessLevelEntryClient
AuthorizationData = {}

---@return AuthorizationData
function AuthorizationData.new() return end

---@param props table
---@return AuthorizationData
function AuthorizationData.new(props) return end

---@param self_ AuthorizationData
---@return Bool
function AuthorizationData.IsAuthorizationValid(self_) return end

---@class AuthorizationFactsSet : BunkerSystemsFactsSet
AuthorizationFactsSet = {}

---@return AuthorizationFactsSet
function AuthorizationFactsSet.new() return end

---@param props table
---@return AuthorizationFactsSet
function AuthorizationFactsSet.new(props) return end

---@class AuthorizePlayerInSecuritySystem : redEvent
---@field authorize Bool
---@field forceRemoveFromBlacklist Bool
---@field ESL ESecurityAccessLevel
AuthorizePlayerInSecuritySystem = {}

---@return AuthorizePlayerInSecuritySystem
function AuthorizePlayerInSecuritySystem.new() return end

---@param props table
---@return AuthorizePlayerInSecuritySystem
function AuthorizePlayerInSecuritySystem.new(props) return end

---@return String
function AuthorizePlayerInSecuritySystem:GetFriendlyDescription() return end

---@class AuthorizeUser : ActionBool
---@field enteredPassword CName
---@field validPasswords CName[]
---@field libraryName CName
---@field isforced Bool
AuthorizeUser = {}

---@return AuthorizeUser
function AuthorizeUser.new() return end

---@param props table
---@return AuthorizeUser
function AuthorizeUser.new(props) return end

---@param authorizationWidgetName CName|string
---@param authorizationDisplayNameOverride String
function AuthorizeUser:CreateActionWidgetPackage(authorizationWidgetName, authorizationDisplayNameOverride) return end

---@param authorizationDisplayNameOverride String
function AuthorizeUser:CreateActionWidgetPackage(authorizationDisplayNameOverride) return end

---@return CName
function AuthorizeUser:GetEnteredPassword() return end

---@return TweakDBID
function AuthorizeUser:GetInkWidgetTweakDBID() return end

---@return CName[]
function AuthorizeUser:GetValidPasswords() return end

---@return Bool
function AuthorizeUser:IsForced() return end

---@param data ResolveActionData
---@return Bool
function AuthorizeUser:ResolveAction(data) return end

---@param validPasswords CName[]|string[]
---@param isforced Bool
function AuthorizeUser:SetProperties(validPasswords, isforced) return end

---@class AutoKillDelayEvent : redEvent
AutoKillDelayEvent = {}

---@return AutoKillDelayEvent
function AutoKillDelayEvent.new() return end

---@param props table
---@return AutoKillDelayEvent
function AutoKillDelayEvent.new(props) return end

---@class AutoRevealStatListener : gameScriptStatsListener
---@field owner gameObject
AutoRevealStatListener = {}

---@return AutoRevealStatListener
function AutoRevealStatListener.new() return end

---@param props table
---@return AutoRevealStatListener
function AutoRevealStatListener.new(props) return end

---@param ownerID gameStatsObjectID
---@param statType gamedataStatType
---@param diff Float
---@param total Float
function AutoRevealStatListener:OnStatChanged(ownerID, statType, diff, total) return end

---@class AutoSaveEvent : redEvent
---@field maxAttempts Int32
---@field isForced Bool
AutoSaveEvent = {}

---@return AutoSaveEvent
function AutoSaveEvent.new() return end

---@param props table
---@return AutoSaveEvent
function AutoSaveEvent.new(props) return end

---@class AutoSaveRequest : gameScriptableSystemRequest
AutoSaveRequest = {}

---@return AutoSaveRequest
function AutoSaveRequest.new() return end

---@param props table
---@return AutoSaveRequest
function AutoSaveRequest.new(props) return end

---@class AutocraftActivateRequest : gameScriptableSystemRequest
AutocraftActivateRequest = {}

---@return AutocraftActivateRequest
function AutocraftActivateRequest.new() return end

---@param props table
---@return AutocraftActivateRequest
function AutocraftActivateRequest.new(props) return end

---@class AutocraftDeactivateRequest : gameScriptableSystemRequest
---@field resetMemory Bool
AutocraftDeactivateRequest = {}

---@return AutocraftDeactivateRequest
function AutocraftDeactivateRequest.new() return end

---@param props table
---@return AutocraftDeactivateRequest
function AutocraftDeactivateRequest.new(props) return end

---@class AutocraftEndCycleRequest : gameScriptableSystemRequest
AutocraftEndCycleRequest = {}

---@return AutocraftEndCycleRequest
function AutocraftEndCycleRequest.new() return end

---@param props table
---@return AutocraftEndCycleRequest
function AutocraftEndCycleRequest.new(props) return end

---@class AutocraftSystem : gameScriptableSystem
---@field active Bool
---@field cycleDuration Float
---@field currentDelayID gameDelayID
---@field itemsUsed ItemID[]
AutocraftSystem = {}

---@return AutocraftSystem
function AutocraftSystem.new() return end

---@param props table
---@return AutocraftSystem
function AutocraftSystem.new(props) return end

---@return ItemID[]
function AutocraftSystem:GetItemsToAutocraft() return end

---@param request AutocraftEndCycleRequest
function AutocraftSystem:OnCycleEnd(request) return end

---@param request RegisterItemUsedRequest
function AutocraftSystem:OnItemUsed(request) return end

---@param request AutocraftActivateRequest
function AutocraftSystem:OnSystemActivate(request) return end

---@param request AutocraftDeactivateRequest
function AutocraftSystem:OnSystemDeactivate(request) return end

---@class AutomaticDeescalationEvent : redEvent
---@field originalNotification SecuritySystemInput
AutomaticDeescalationEvent = {}

---@return AutomaticDeescalationEvent
function AutomaticDeescalationEvent.new() return end

---@param props table
---@return AutomaticDeescalationEvent
function AutomaticDeescalationEvent.new(props) return end

---@class AutoplayVideoController : inkWidgetLogicController
AutoplayVideoController = {}

---@return AutoplayVideoController
function AutoplayVideoController.new() return end

---@param props table
---@return AutoplayVideoController
function AutoplayVideoController.new(props) return end

---@return Bool
function AutoplayVideoController:OnInitialize() return end

---@class AvHoverIdleSFXBehaviour : AIbehaviortaskScript
AvHoverIdleSFXBehaviour = {}

---@return AvHoverIdleSFXBehaviour
function AvHoverIdleSFXBehaviour.new() return end

---@param props table
---@return AvHoverIdleSFXBehaviour
function AvHoverIdleSFXBehaviour.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AvHoverIdleSFXBehaviour:Activate(context) return end

---@class AvStartAscentSFXBehaviour : AIbehaviortaskScript
AvStartAscentSFXBehaviour = {}

---@return AvStartAscentSFXBehaviour
function AvStartAscentSFXBehaviour.new() return end

---@param props table
---@return AvStartAscentSFXBehaviour
function AvStartAscentSFXBehaviour.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AvStartAscentSFXBehaviour:Activate(context) return end

---@class AvStartDescentSFXBehaviour : AIbehaviortaskScript
AvStartDescentSFXBehaviour = {}

---@return AvStartDescentSFXBehaviour
function AvStartDescentSFXBehaviour.new() return end

---@param props table
---@return AvStartDescentSFXBehaviour
function AvStartDescentSFXBehaviour.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function AvStartDescentSFXBehaviour:Activate(context) return end

---@class AwacsAlertNotification : GenericNotificationController
---@field animation inkanimProxy
---@field zone_data VehicleAlertNotificationViewData
---@field ZoneLabelText inkTextWidgetReference
AwacsAlertNotification = {}

---@return AwacsAlertNotification
function AwacsAlertNotification.new() return end

---@param props table
---@return AwacsAlertNotification
function AwacsAlertNotification.new(props) return end

---@param notificationData gameuiGenericNotificationViewData
function AwacsAlertNotification:SetNotificationData(notificationData) return end

---@class AwacsAlertNotificationViewData : gameuiGenericNotificationViewData
---@field canBeMerged Bool
AwacsAlertNotificationViewData = {}

---@return AwacsAlertNotificationViewData
function AwacsAlertNotificationViewData.new() return end

---@param props table
---@return AwacsAlertNotificationViewData
function AwacsAlertNotificationViewData.new(props) return end

---@param data gameuiGenericNotificationViewData
---@return Bool
function AwacsAlertNotificationViewData:CanMerge(data) return end

---@class BackActionCallback : redEvent
BackActionCallback = {}

---@return BackActionCallback
function BackActionCallback.new() return end

---@param props table
---@return BackActionCallback
function BackActionCallback.new(props) return end

---@class BackDoorDeviceBlackboardDef : MasterDeviceBaseBlackboardDef
---@field isInDefaultState gamebbScriptID_Bool
---@field shutdownModule gamebbScriptID_Int32
---@field bootModule gamebbScriptID_Int32
BackDoorDeviceBlackboardDef = {}

---@return BackDoorDeviceBlackboardDef
function BackDoorDeviceBlackboardDef.new() return end

---@param props table
---@return BackDoorDeviceBlackboardDef
function BackDoorDeviceBlackboardDef.new(props) return end

---@class BackDoorObjectiveData : GemplayObjectiveData
BackDoorObjectiveData = {}

---@return BackDoorObjectiveData
function BackDoorObjectiveData.new() return end

---@param props table
---@return BackDoorObjectiveData
function BackDoorObjectiveData.new(props) return end

---@class BackdoorDataStreamController : BackdoorInkGameController
---@field idleGroup inkWidgetReference
---@field idleVPanelC1 inkWidgetReference
---@field idleVPanelC2 inkWidgetReference
---@field idleVPanelC3 inkWidgetReference
---@field idleVPanelC4 inkWidgetReference
---@field hackedGroup inkWidgetReference
---@field idleCanvas1 inkWidgetReference
---@field idleCanvas2 inkWidgetReference
---@field idleCanvas3 inkWidgetReference
---@field idleCanvas4 inkWidgetReference
---@field canvasC1 inkWidgetReference
---@field canvasC2 inkWidgetReference
---@field canvasC3 inkWidgetReference
---@field canvasC4 inkWidgetReference
BackdoorDataStreamController = {}

---@return BackdoorDataStreamController
function BackdoorDataStreamController.new() return end

---@param props table
---@return BackdoorDataStreamController
function BackdoorDataStreamController.new(props) return end

---@param module Int32
function BackdoorDataStreamController:BootModule(module) return end

function BackdoorDataStreamController:EnableHackedGroup() return end

---@param module Int32
function BackdoorDataStreamController:ShutdownModule(module) return end

function BackdoorDataStreamController:StartGlitching() return end

---@class BackdoorInkGameController : MasterDeviceInkGameControllerBase
---@field IdleGroup inkWidgetReference
---@field ConnectedGroup inkWidgetReference
---@field IntroAnimationName CName
---@field IdleAnimationName CName
---@field GlitchAnimationName CName
---@field RunningAnimation inkanimProxy
---@field onGlitchingListener redCallbackObject
---@field onIsInDefaultStateListener redCallbackObject
---@field onShutdownModuleListener redCallbackObject
---@field onBootModuleListener redCallbackObject
BackdoorInkGameController = {}

---@return BackdoorInkGameController
function BackdoorInkGameController.new() return end

---@param props table
---@return BackdoorInkGameController
function BackdoorInkGameController.new(props) return end

---@param value Int32
---@return Bool
function BackdoorInkGameController:OnBootModule(value) return end

---@param value Bool
---@return Bool
function BackdoorInkGameController:OnGlitching(value) return end

---@param e inkanimProxy
---@return Bool
function BackdoorInkGameController:OnIntroFinished(e) return end

---@param value Bool
---@return Bool
function BackdoorInkGameController:OnIsInDefaultState(value) return end

---@param value Int32
---@return Bool
function BackdoorInkGameController:OnShutdownModule(value) return end

---@param module Int32
function BackdoorInkGameController:BootModule(module) return end

function BackdoorInkGameController:EnableHackedGroup() return end

---@return AccessPoint
function BackdoorInkGameController:GetOwner() return end

---@param animName CName|string
function BackdoorInkGameController:PlayAnimation(animName) return end

function BackdoorInkGameController:PlayIntroAnimation() return end

---@param state EDeviceStatus
function BackdoorInkGameController:Refresh(state) return end

---@param blackboard gameIBlackboard
function BackdoorInkGameController:RegisterBlackboardCallbacks(blackboard) return end

---@param module Int32
function BackdoorInkGameController:ShutdownModule(module) return end

function BackdoorInkGameController:StartGlitching() return end

function BackdoorInkGameController:StopGlitching() return end

function BackdoorInkGameController:TurnOff() return end

function BackdoorInkGameController:TurnOn() return end

---@param blackboard gameIBlackboard
function BackdoorInkGameController:UnRegisterBlackboardCallbacks(blackboard) return end

---@param widgetsData SDeviceWidgetPackage[]
function BackdoorInkGameController:UpdateDeviceWidgets(widgetsData) return end

---@param widgetsData SThumbnailWidgetPackage[]
function BackdoorInkGameController:UpdateThumbnailWidgets(widgetsData) return end

---@class BackgroundDisplayVirtualController : inkVirtualCompoundBackgroundController
BackgroundDisplayVirtualController = {}

---@return BackgroundDisplayVirtualController
function BackgroundDisplayVirtualController.new() return end

---@param props table
---@return BackgroundDisplayVirtualController
function BackgroundDisplayVirtualController.new(props) return end

---@return Bool
function BackgroundDisplayVirtualController:OnInitialize() return end

---@class BackpackCraftingMaterialItemCallbackData : IScriptable
---@field craftingMaterial CachedCraftingMaterial
BackpackCraftingMaterialItemCallbackData = {}

---@return BackpackCraftingMaterialItemCallbackData
function BackpackCraftingMaterialItemCallbackData.new() return end

---@param props table
---@return BackpackCraftingMaterialItemCallbackData
function BackpackCraftingMaterialItemCallbackData.new(props) return end

---@class BackpackDataView : inkScriptableDataViewWrapper
---@field itemSortMode ItemSortMode
---@field attachmentsList gamedataItemType[]
---@field uiScriptableSystem UIScriptableSystem
---@field itemFilterType ItemFilterCategory
BackpackDataView = {}

---@return BackpackDataView
function BackpackDataView.new() return end

---@param props table
---@return BackpackDataView
function BackpackDataView.new(props) return end

---@param uiScriptableSystem UIScriptableSystem
function BackpackDataView:BindUIScriptableSystem(uiScriptableSystem) return end

---@param data IScriptable
---@return DerivedFilterResult
function BackpackDataView:DerivedFilterItem(data) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:FilterAttachments(itemData) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:FilterClothes(itemData) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:FilterConsumable(itemData) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:FilterCyberware(itemData) return end

---@param equipmentArea gamedataEquipmentArea
---@return Bool
function BackpackDataView:FilterCyberwareByEquipmentArea(equipmentArea) return end

---@param itemType gamedataItemType
---@return Bool
function BackpackDataView:FilterCyberwareByItemType(itemType) return end

---@param data IScriptable
---@return Bool
function BackpackDataView:FilterItem(data) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:FilterQuestItems(itemData) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:FilterWeapons(itemData) return end

---@return ItemFilterCategory
function BackpackDataView:GetFilterType() return end

---@return ItemSortMode
function BackpackDataView:GetSortMode() return end

---@param builder NewItemCompareBuilder
---@return NewItemCompareBuilder
function BackpackDataView:NewPreSortingInjection(builder) return end

---@param itemData gameInventoryItemData
---@return Bool
function BackpackDataView:PreFilterInjection(itemData) return end

---@param builder ItemCompareBuilder
---@return ItemCompareBuilder
function BackpackDataView:PreSortingInjection(builder) return end

---@param type ItemFilterCategory
function BackpackDataView:SetFilterType(type) return end

---@param mode ItemSortMode
function BackpackDataView:SetSortMode(mode) return end

---@param left IScriptable
---@param right IScriptable
---@return Bool
function BackpackDataView:SortItem(left, right) return end

---@param left WrappedInventoryItemData
---@param right WrappedInventoryItemData
---@return Bool
function BackpackDataView:SortItemNew(left, right) return end

---@class BackpackEquipSlotChooserCloseData : inkGameNotificationData
---@field confirm Bool
---@field itemData UIInventoryItem
---@field slotIndex Int32
BackpackEquipSlotChooserCloseData = {}

---@return BackpackEquipSlotChooserCloseData
function BackpackEquipSlotChooserCloseData.new() return end

---@param props table
---@return BackpackEquipSlotChooserCloseData
function BackpackEquipSlotChooserCloseData.new(props) return end

---@class BackpackEquipSlotChooserData : inkGameNotificationData
---@field item UIInventoryItem
---@field inventoryScriptableSystem UIInventoryScriptableSystem
BackpackEquipSlotChooserData = {}

---@return BackpackEquipSlotChooserData
function BackpackEquipSlotChooserData.new() return end

---@param props table
---@return BackpackEquipSlotChooserData
function BackpackEquipSlotChooserData.new(props) return end

---@class BackpackEquipSlotChooserPopup : gameuiWidgetGameController
---@field titleText inkTextWidgetReference
---@field buttonHintsRoot inkWidgetReference
---@field rairtyBar inkWidgetReference
---@field root inkWidgetReference
---@field background inkWidgetReference
---@field weaponSlotsContainer inkCompoundWidgetReference
---@field tooltipsManagerRef inkWidgetReference
---@field buttonHintsController ButtonHints
---@field gameData gameItemData
---@field buttonOk inkWidgetReference
---@field buttonCancel inkWidgetReference
---@field data BackpackEquipSlotChooserData
---@field selectedSlotIndex Int32
---@field tooltipsManager gameuiTooltipsManager
---@field comparisonResolver InventoryItemPreferredComparisonResolver
---@field libraryPath inkWidgetLibraryReference
---@field closeData BackpackEquipSlotChooserCloseData
BackpackEquipSlotChooserPopup = {}

---@return BackpackEquipSlotChooserPopup
function BackpackEquipSlotChooserPopup.new() return end

---@param props table
---@return BackpackEquipSlotChooserPopup
function BackpackEquipSlotChooserPopup.new(props) return end

---@param controller inkButtonController
---@return Bool
function BackpackEquipSlotChooserPopup:OnCancelClick(controller) return end

---@param proxy inkanimProxy
---@return Bool
function BackpackEquipSlotChooserPopup:OnCloseAnimationFinished(proxy) return end

---@param evt inkPointerEvent
---@return Bool
function BackpackEquipSlotChooserPopup:OnHandlePressInput(evt) return end

---@return Bool
function BackpackEquipSlotChooserPopup:OnInitialize() return end

---@param controller inkButtonController
---@return Bool
function BackpackEquipSlotChooserPopup:OnOkClick(controller) return end

---@param e inkPointerEvent
---@return Bool
function BackpackEquipSlotChooserPopup:OnSlotClick(e) return end

---@param e inkPointerEvent
---@return Bool
function BackpackEquipSlotChooserPopup:OnSlotHoverOut(e) return end

---@param e inkPointerEvent
---@return Bool
function BackpackEquipSlotChooserPopup:OnSlotHoverOver(e) return end

---@return Bool
function BackpackEquipSlotChooserPopup:OnUninitialize() return end

---@param actionName CName|string
---@param label String
function BackpackEquipSlotChooserPopup:AddButtonHints(actionName, label) return end

---@param success Bool
function BackpackEquipSlotChooserPopup:Close(success) return end

function BackpackEquipSlotChooserPopup:SetButtonHints() return end

---@param inventoryScriptableSystem UIInventoryScriptableSystem
function BackpackEquipSlotChooserPopup:SpawnWeaponSlots(inventoryScriptableSystem) return end

---@class BackpackFilterButtonController : inkWidgetLogicController
---@field icon inkImageWidgetReference
---@field text inkTextWidgetReference
---@field filterType ItemFilterCategory
---@field active Bool
---@field hovered Bool
BackpackFilterButtonController = {}

---@return BackpackFilterButtonController
function BackpackFilterButtonController.new() return end

---@param props table
---@return BackpackFilterButtonController
function BackpackFilterButtonController.new(props) return end

---@param filterType ItemFilterCategory
---@return String
function BackpackFilterButtonController.GetIcon(filterType) return end

---@param filterType ItemFilterCategory
---@return CName
function BackpackFilterButtonController.GetLabelKey(filterType) return end

---@param evt inkPointerEvent
---@return Bool
function BackpackFilterButtonController:OnHoverOut(evt) return end

---@param evt inkPointerEvent
---@return Bool
function BackpackFilterButtonController:OnHoverOver(evt) return end

---@return Bool
function BackpackFilterButtonController:OnInitialize() return end

---@return ItemFilterCategory
function BackpackFilterButtonController:GetFilterType() return end

---@return CName
function BackpackFilterButtonController:GetLabelKey() return end

---@param value Bool
function BackpackFilterButtonController:SetActive(value) return end

---@param filterType ItemFilterCategory
function BackpackFilterButtonController:Setup(filterType) return end

---@class BackpackFilterButtonSpawnedCallbackData : IScriptable
---@field category ItemFilterCategory
---@field savedFilter Int32
BackpackFilterButtonSpawnedCallbackData = {}

---@return BackpackFilterButtonSpawnedCallbackData
function BackpackFilterButtonSpawnedCallbackData.new() return end

---@param props table
---@return BackpackFilterButtonSpawnedCallbackData
function BackpackFilterButtonSpawnedCallbackData.new(props) return end

---@class BackpackInventoryListenerCallback : gameInventoryScriptCallback
---@field backpackInstance gameuiBackpackMainGameController
BackpackInventoryListenerCallback = {}

---@return BackpackInventoryListenerCallback
function BackpackInventoryListenerCallback.new() return end

---@param props table
---@return BackpackInventoryListenerCallback
function BackpackInventoryListenerCallback.new(props) return end

---@param backpackInstance gameuiBackpackMainGameController
function BackpackInventoryListenerCallback:Setup(backpackInstance) return end

---@class BakcpackImmediateNotificationListener : ImmediateNotificationListener
---@field backpackInstance gameuiBackpackMainGameController
BakcpackImmediateNotificationListener = {}

---@return BakcpackImmediateNotificationListener
function BakcpackImmediateNotificationListener.new() return end

---@param props table
---@return BakcpackImmediateNotificationListener
function BakcpackImmediateNotificationListener.new(props) return end

---@param message Int32
---@param id Uint64
---@param data IScriptable
function BakcpackImmediateNotificationListener:Notify(message, id, data) return end

---@param instance gameuiBackpackMainGameController
function BakcpackImmediateNotificationListener:SetBackpackInstance(instance) return end

---@class BarHoverOutEvent : redEvent
BarHoverOutEvent = {}

---@return BarHoverOutEvent
function BarHoverOutEvent.new() return end

---@param props table
---@return BarHoverOutEvent
function BarHoverOutEvent.new(props) return end

---@class BarHoverOverEvent : redEvent
---@field data RipperdocBarTooltipTooltipData
BarHoverOverEvent = {}

---@return BarHoverOverEvent
function BarHoverOverEvent.new() return end

---@param props table
---@return BarHoverOverEvent
function BarHoverOverEvent.new(props) return end

---@class BarbedWire : ActivatedDeviceTrap
BarbedWire = {}

---@return BarbedWire
function BarbedWire.new() return end

---@param props table
---@return BarbedWire
function BarbedWire.new(props) return end

---@param evt entAreaEnteredEvent
---@return Bool
function BarbedWire:OnAreaEnter(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BarbedWire:OnTakeControl(ri) return end

---@param activator gameObject
---@return Bool
function BarbedWire:CanAttackActivator(activator) return end

---@return BarbedWireController
function BarbedWire:GetController() return end

---@return BarbedWireControllerPS
function BarbedWire:GetDevicePS() return end

---@class BarbedWireController : ActivatedDeviceController
BarbedWireController = {}

---@return BarbedWireController
function BarbedWireController.new() return end

---@param props table
---@return BarbedWireController
function BarbedWireController.new(props) return end

---@return BarbedWireControllerPS
function BarbedWireController:GetPS() return end

---@class BarbedWireControllerPS : ActivatedDeviceControllerPS
BarbedWireControllerPS = {}

---@return BarbedWireControllerPS
function BarbedWireControllerPS.new() return end

---@param props table
---@return BarbedWireControllerPS
function BarbedWireControllerPS.new(props) return end

---@class BaseActionOperations : DeviceOperations
---@field baseActionsOperations SBaseActionOperationData[]
BaseActionOperations = {}

---@return BaseActionOperations
function BaseActionOperations.new() return end

---@param props table
---@return BaseActionOperations
function BaseActionOperations.new(props) return end

---@param operationID Int32
function BaseActionOperations:ClearDelayIdOnOperation(operationID) return end

---@param actionClassName CName|string
---@param owner gameObject
function BaseActionOperations:ExecuteOperation(actionClassName, owner) return end

---@param index Int32
---@return Bool
function BaseActionOperations:IsOperationEnabled(index) return end

---@param ri entEntityRequestComponentsInterface
function BaseActionOperations:RequestComponents(ri) return end

---@param actionClassName CName|string
---@param owner gameObject
function BaseActionOperations:RestoreOperation(actionClassName, owner) return end

---@param delayId gameDelayID
---@param operationID Int32
function BaseActionOperations:SetDelayIdOnOperation(delayId, operationID) return end

---@param ri entEntityResolveComponentsInterface
function BaseActionOperations:TakeControl(ri) return end

---@param enable Bool
---@param index Int32
function BaseActionOperations:ToggleOperation(enable, index) return end

---@class BaseAnimatedDevice : InteractiveDevice
---@field openingSpeed Float
---@field closingSpeed Float
---@field animationController entAnimationControllerComponent
---@field animFeature AnimFeature_RoadBlock
---@field animationType EAnimationType
BaseAnimatedDevice = {}

---@return BaseAnimatedDevice
function BaseAnimatedDevice.new() return end

---@param props table
---@return BaseAnimatedDevice
function BaseAnimatedDevice.new(props) return end

---@param evt ActivateDevice
---@return Bool
function BaseAnimatedDevice:OnActivateDevice(evt) return end

---@param evt DeactivateDevice
---@return Bool
function BaseAnimatedDevice:OnDeactivateDevice(evt) return end

---@param evt QuickHackToggleActivate
---@return Bool
function BaseAnimatedDevice:OnQuickHackToggleActivate(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BaseAnimatedDevice:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BaseAnimatedDevice:OnTakeControl(ri) return end

function BaseAnimatedDevice:ActivateAnimation() return end

function BaseAnimatedDevice:ActivateDevice() return end

function BaseAnimatedDevice:Animate() return end

function BaseAnimatedDevice:DeactivateDevice() return end

---@return EGameplayRole
function BaseAnimatedDevice:DeterminGameplayRole() return end

---@return BaseAnimatedDeviceController
function BaseAnimatedDevice:GetController() return end

---@return CName
function BaseAnimatedDevice:GetCurrentAnimationName() return end

---@return BaseAnimatedDeviceControllerPS
function BaseAnimatedDevice:GetDevicePS() return end

---@return Float
function BaseAnimatedDevice:GetTimeScale() return end

function BaseAnimatedDevice:InvokePlayAnimationEvent() return end

function BaseAnimatedDevice:OnPlayAnimation() return end

function BaseAnimatedDevice:ResolveGameplayState() return end

---@class BaseAnimatedDeviceController : ScriptableDeviceComponent
BaseAnimatedDeviceController = {}

---@return BaseAnimatedDeviceController
function BaseAnimatedDeviceController.new() return end

---@param props table
---@return BaseAnimatedDeviceController
function BaseAnimatedDeviceController.new(props) return end

---@return BaseAnimatedDeviceControllerPS
function BaseAnimatedDeviceController:GetPS() return end

---@class BaseAnimatedDeviceControllerPS : ScriptableDeviceComponentPS
---@field isActive Bool
---@field hasInteraction Bool
---@field randomizeAnimationTime Bool
---@field nameForActivation TweakDBID
---@field nameForDeactivation TweakDBID
BaseAnimatedDeviceControllerPS = {}

---@return BaseAnimatedDeviceControllerPS
function BaseAnimatedDeviceControllerPS.new() return end

---@param props table
---@return BaseAnimatedDeviceControllerPS
function BaseAnimatedDeviceControllerPS.new(props) return end

---@return QuickHackToggleActivate
function BaseAnimatedDeviceControllerPS:ActionQuickHackToggleActivate() return end

---@return ToggleActivate
function BaseAnimatedDeviceControllerPS:ActionToggleActivate() return end

---@return Bool
function BaseAnimatedDeviceControllerPS:CanCreateAnyQuickHackActions() return end

function BaseAnimatedDeviceControllerPS:GameAttached() return end

---@param context gameGetActionsContext
---@return Bool, gamedeviceAction[]
function BaseAnimatedDeviceControllerPS:GetActions(context) return end

---@param actionName CName|string
---@return gamedeviceAction
function BaseAnimatedDeviceControllerPS:GetQuestActionByName(actionName) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function BaseAnimatedDeviceControllerPS:GetQuestActions(context) return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function BaseAnimatedDeviceControllerPS:GetQuickHackActions(context) return end

---@return Bool
function BaseAnimatedDeviceControllerPS:IsActive() return end

---@return Bool
function BaseAnimatedDeviceControllerPS:IsNotActive() return end

---@param evt ActivateDevice
---@return EntityNotificationType
function BaseAnimatedDeviceControllerPS:OnActivateDevice(evt) return end

---@param evt DeactivateDevice
---@return EntityNotificationType
function BaseAnimatedDeviceControllerPS:OnDeactivateDevice(evt) return end

---@param evt QuickHackToggleActivate
---@return EntityNotificationType
function BaseAnimatedDeviceControllerPS:OnQuickHackToggleActivate(evt) return end

---@param evt ToggleActivate
---@return EntityNotificationType
function BaseAnimatedDeviceControllerPS:OnToggleActivate(evt) return end

---@return Bool
function BaseAnimatedDeviceControllerPS:Randomize() return end

---@param isActive Bool
function BaseAnimatedDeviceControllerPS:SetActiveState(isActive) return end

---@class BaseBullet : BaseProjectile
---@field meshComponent entIComponent
---@field countTime Float
---@field startVelocity Float
---@field acceleration Float
---@field lifetime Float
---@field alive Bool
BaseBullet = {}

---@return BaseBullet
function BaseBullet.new() return end

---@param props table
---@return BaseBullet
function BaseBullet.new(props) return end

---@param eventData gameprojectileHitEvent
---@return Bool
function BaseBullet:OnCollision(eventData) return end

---@param eventData gameprojectileSetUpEvent
---@return Bool
function BaseBullet:OnProjectileInitialize(eventData) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BaseBullet:OnRequestComponents(ri) return end

---@param eventData gameprojectileShootEvent
---@return Bool
function BaseBullet:OnShoot(eventData) return end

---@param eventData gameprojectileShootTargetEvent
---@return Bool
function BaseBullet:OnShootTarget(eventData) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BaseBullet:OnTakeControl(ri) return end

---@param eventData gameprojectileTickEvent
---@return Bool
function BaseBullet:OnTick(eventData) return end

---@param eventData gameprojectileHitEvent
function BaseBullet:DealDamage(eventData) return end

---@param eventData gameprojectileHitEvent
function BaseBullet:PerformAttack(eventData) return end

function BaseBullet:Reset() return end

function BaseBullet:StartTrailEffect() return end

---@class BaseBunkerComputerGameController : gameuiBaseBunkerComputerGameController
---@field factsSet BunkerSystemsFactsSet
---@field gateClosedFact CName
BaseBunkerComputerGameController = {}

---@return BaseBunkerComputerGameController
function BaseBunkerComputerGameController.new() return end

---@param props table
---@return BaseBunkerComputerGameController
function BaseBunkerComputerGameController.new(props) return end

---@return BunkerSystems
function BaseBunkerComputerGameController:GetCurrentSystem() return end

---@param factsSet BunkerSystemsFactsSet
---@return CName
function BaseBunkerComputerGameController:GetCurrentSystemFact(factsSet) return end

---@return ScriptGameInstance
function BaseBunkerComputerGameController:GetGame() return end

---@param controller inkWidgetLogicController
---@param fact CName|string
function BaseBunkerComputerGameController:SetStatusOffline(controller, fact) return end

---@param controller inkWidgetLogicController
---@param isOffline Bool
function BaseBunkerComputerGameController:SetStatusOffline(controller, isOffline) return end

---@class BaseButtonView : inkDiscreteNavigationController
---@field ButtonController inkButtonController
BaseButtonView = {}

---@param controller inkButtonController
---@param progress Float
---@return Bool
function BaseButtonView:OnButtonHoldProgressChanged(controller, progress) return end

---@param controller inkButtonController
---@param oldState inkEButtonState
---@param newState inkEButtonState
---@return Bool
function BaseButtonView:OnButtonStateChanged(controller, oldState, newState) return end

---@return Bool
function BaseButtonView:OnInitialize() return end

---@param progress Float
function BaseButtonView:ButtonHoldProgressChanged(progress) return end

---@param oldState inkEButtonState
---@param newState inkEButtonState
function BaseButtonView:ButtonStateChanged(oldState, newState) return end

---@return inkButtonController
function BaseButtonView:GetParentButton() return end

---@class BaseChargesStatListener : gameCustomValueStatPoolsListener
---@field player PlayerPuppet
---@field playedCueAlready Bool
---@field currentCharges Int32
---@field currentStatPoolValue Int32
---@field rechargeSoundCue CName
---@field statSystem gameStatsSystem
---@field finalString String
BaseChargesStatListener = {}

---@return BaseChargesStatListener
function BaseChargesStatListener.new() return end

---@param props table
---@return BaseChargesStatListener
function BaseChargesStatListener.new(props) return end

---@param hotkey gameEHotkey
---@return gamedataItem_Record
function BaseChargesStatListener:GetActiveItem(hotkey) return end

---@return Int32
function BaseChargesStatListener:GetCharges() return end

---@return Int32
function BaseChargesStatListener:GetRechargeDuration() return end

---@param player PlayerPuppet
function BaseChargesStatListener:Init(player) return end

---@return Int32
function BaseChargesStatListener:MaxStatPoolValue() return end

---@param oldValue Float
---@param newValue Float
---@param percToPoints Float
function BaseChargesStatListener:OnStatPoolValueChanged(oldValue, newValue, percToPoints) return end

function BaseChargesStatListener:PlayRechagedSoundEvent() return end

function BaseChargesStatListener:Recharged() return end

---@class BaseChunkGameController : gameuiWidgetGameController
---@field chunkBlackboard gameIBlackboard
---@field chunkBlackboardDef UI_ScannerModulesDef
---@field questClueBlackboardDef UI_ScannerDef
BaseChunkGameController = {}

---@return BaseChunkGameController
function BaseChunkGameController.new() return end

---@param props table
---@return BaseChunkGameController
function BaseChunkGameController.new(props) return end

---@return Bool
function BaseChunkGameController:OnInitialize() return end

---@class BaseCodexLinkController : inkWidgetLogicController
---@field linkImage inkImageWidgetReference
---@field linkLabel inkTextWidgetReference
---@field inputContainer inkWidgetReference
---@field animProxy inkanimProxy
---@field isInteractive Bool
BaseCodexLinkController = {}

---@return BaseCodexLinkController
function BaseCodexLinkController.new() return end

---@param props table
---@return BaseCodexLinkController
function BaseCodexLinkController.new(props) return end

---@param evt inkPointerEvent
---@return Bool
function BaseCodexLinkController:OnHoverOut(evt) return end

---@param evt inkPointerEvent
---@return Bool
function BaseCodexLinkController:OnHoverOver(evt) return end

---@return Bool
function BaseCodexLinkController:OnInitialize() return end

---@param e inkPointerEvent
---@return Bool
function BaseCodexLinkController:OnRelease(e) return end

function BaseCodexLinkController:Activate() return end

function BaseCodexLinkController:ActivateSecondary() return end

---@param value Bool
function BaseCodexLinkController:EnableInputHint(value) return end

---@param animationName CName|string
function BaseCodexLinkController:ForcePlayAnimation(animationName) return end

---@class BaseContextDecisions : InputContextTransitionDecisions
BaseContextDecisions = {}

---@return BaseContextDecisions
function BaseContextDecisions.new() return end

---@param props table
---@return BaseContextDecisions
function BaseContextDecisions.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function BaseContextDecisions:ToVehicleRemoteControlDriverContext(stateContext, scriptInterface) return end

---@class BaseContextEvents : InputContextTransitionEvents
BaseContextEvents = {}

---@return BaseContextEvents
function BaseContextEvents.new() return end

---@param props table
---@return BaseContextEvents
function BaseContextEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return Bool
function BaseContextEvents:IsStateValidForExploration(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BaseContextEvents:OnExit(stateContext, scriptInterface) return end

---@param timeDelta Float
---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BaseContextEvents:OnUpdate(timeDelta, stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return ActiveBaseContext
function BaseContextEvents:UpdateBodyCarryInputHints(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BaseContextEvents:UpdateHints(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return ActiveBaseContext
function BaseContextEvents:UpdateLadderInputHints(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return ActiveBaseContext
function BaseContextEvents:UpdateLocomotionInputHints(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
---@return ActiveBaseContext
function BaseContextEvents:UpdateSwimmingInputHints(stateContext, scriptInterface) return end

---@class BaseCrosshairState : DefaultTransition
BaseCrosshairState = {}

---@return BaseCrosshairState
function BaseCrosshairState.new() return end

---@param props table
---@return BaseCrosshairState
function BaseCrosshairState.new(props) return end

---@return gamePSMCrosshairStates
function BaseCrosshairState:GetCrosshairStateEnumValue() return end

---@class BaseCrosshairStateEvents : BaseCrosshairState
BaseCrosshairStateEvents = {}

---@return BaseCrosshairStateEvents
function BaseCrosshairStateEvents.new() return end

---@param props table
---@return BaseCrosshairStateEvents
function BaseCrosshairStateEvents.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BaseCrosshairStateEvents:OnEnter(stateContext, scriptInterface) return end

---@class BaseDestructibleController : ScriptableDeviceComponent
BaseDestructibleController = {}

---@return BaseDestructibleController
function BaseDestructibleController.new() return end

---@param props table
---@return BaseDestructibleController
function BaseDestructibleController.new(props) return end

---@return BaseDestructibleControllerPS
function BaseDestructibleController:GetPS() return end

---@class BaseDestructibleControllerPS : ScriptableDeviceComponentPS
---@field destroyed Bool
BaseDestructibleControllerPS = {}

---@return BaseDestructibleControllerPS
function BaseDestructibleControllerPS.new() return end

---@param props table
---@return BaseDestructibleControllerPS
function BaseDestructibleControllerPS.new(props) return end

---@return Bool
function BaseDestructibleControllerPS:OnInstantiated() return end

function BaseDestructibleControllerPS:GameAttached() return end

function BaseDestructibleControllerPS:Initialize() return end

---@return Bool
function BaseDestructibleControllerPS:IsDestroyed() return end

---@return Bool
function BaseDestructibleControllerPS:IsMasterDestroyed() return end

---@param evt MasterDeviceDestroyed
---@return EntityNotificationType
function BaseDestructibleControllerPS:OnMasterDeviceDestroyed(evt) return end

function BaseDestructibleControllerPS:SetDestroyed() return end

---@class BaseDestructibleDevice : Device
---@field minTime Float
---@field maxTime Float
---@field destroyedMesh entPhysicalMeshComponent
BaseDestructibleDevice = {}

---@return BaseDestructibleDevice
function BaseDestructibleDevice.new() return end

---@param props table
---@return BaseDestructibleDevice
function BaseDestructibleDevice.new(props) return end

---@param evt DelayEvent
---@return Bool
function BaseDestructibleDevice:OnDelayEvent(evt) return end

---@param evt MasterDeviceDestroyed
---@return Bool
function BaseDestructibleDevice:OnMasterDeviceDestroyed(evt) return end

---@param evt entPhysicalDestructionEvent
---@return Bool
function BaseDestructibleDevice:OnPhysicalDestructionEvent(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BaseDestructibleDevice:OnRequestComponents(ri) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BaseDestructibleDevice:OnTakeControl(ri) return end

function BaseDestructibleDevice:ActivateDevice() return end

function BaseDestructibleDevice:CreateDestructionEffects() return end

function BaseDestructibleDevice:CreatePhysicalBody() return end

function BaseDestructibleDevice:DeactivateDevice() return end

function BaseDestructibleDevice:DeactivateDeviceSilent() return end

---@return BaseDestructibleController
function BaseDestructibleDevice:GetController() return end

---@return BaseDestructibleControllerPS
function BaseDestructibleDevice:GetDevicePS() return end

function BaseDestructibleDevice:HidePhysicalBody() return end

function BaseDestructibleDevice:ResolveGameplayState() return end

---@class BaseDeviceData
---@field deviceState EDeviceStatus
---@field durabilityType EDeviceDurabilityType
---@field deviceName String
---@field debugName CName
---@field hackOwner gameObject
BaseDeviceData = {}

---@return BaseDeviceData
function BaseDeviceData.new() return end

---@param props table
---@return BaseDeviceData
function BaseDeviceData.new(props) return end

---@class BaseDeviceStatus : ActionEnum
---@field isRestarting Bool
BaseDeviceStatus = {}

---@return BaseDeviceStatus
function BaseDeviceStatus.new() return end

---@param props table
---@return BaseDeviceStatus
function BaseDeviceStatus.new(props) return end

---@param device ScriptableDeviceComponentPS
---@return Bool
function BaseDeviceStatus.IsAvailable(device) return end

---@param requesterClearancer gamedeviceClearance
---@return Bool
function BaseDeviceStatus.IsClearanceValid(requesterClearancer) return end

---@param context gameGetActionsContext
---@return Bool
function BaseDeviceStatus.IsContextValid(context) return end

---@param device ScriptableDeviceComponentPS
---@param context gameGetActionsContext
---@return Bool
function BaseDeviceStatus.IsDefaultConditionMet(device, context) return end

---@return String
function BaseDeviceStatus:GetCurrentDisplayString() return end

---@return TweakDBID
function BaseDeviceStatus:GetScannerStatusRecord() return end

---@return Int32
function BaseDeviceStatus:GetStatusValue() return end

---@return String
function BaseDeviceStatus:GetTweakDBChoiceRecord() return end

---@param deviceRef ScriptableDeviceComponentPS
function BaseDeviceStatus:SetProperties(deviceRef) return end

---@class BaseGameEngine : CBaseEngine
BaseGameEngine = {}

---@return BaseGameEngine
function BaseGameEngine.new() return end

---@param props table
---@return BaseGameEngine
function BaseGameEngine.new(props) return end

---@class BaseGrenade : gameweaponGrenade
---@field projectileComponent gameprojectileComponent
---@field user gameObject
---@field projectileSpawnPoint Vector4
---@field shootCollision entSimpleColliderComponent
---@field visualComponent entIComponent
---@field stickyMeshComponent entIComponent
---@field decalsStickyComponent entIComponent
---@field homingMeshComponent entIComponent
---@field targetingComponent gameTargetingComponent
---@field resourceLibraryComponent ResourceLibraryComponent
---@field mappinID gameNewMappinID
---@field timeSinceLaunch Float
---@field timeSinceExplosion Float
---@field detonationTimer Float
---@field stickyTrackerTimeout Float
---@field timeOfFreezing Float
---@field spawnBlinkEffectDelayID gameDelayID
---@field detonateRequestDelayID gameDelayID
---@field releaseRequestDelayID gameDelayID
---@field delayToDetonate Float
---@field detonationTimerActive Bool
---@field isAlive Bool
---@field isSinking Bool
---@field landedOnGround Bool
---@field isStuck Bool
---@field isTracking Bool
---@field isLockingOn Bool
---@field isLockedOn Bool
---@field readyToTrack Bool
---@field lockOnFailed Bool
---@field canBeShot Bool
---@field shotDownByThePlayer Bool
---@field forceExplosion Bool
---@field hasClearedIgnoredObject Bool
---@field detonateOnImpact Bool
---@field setStickyTracker Bool
---@field isContinuousEffect Bool
---@field additionalAttackOnDetonate Bool
---@field additionalAttackOnCollision Bool
---@field targetAcquired Bool
---@field collidedWithNPC Bool
---@field isBroadcastingStim Bool
---@field playingFastBeep Bool
---@field hasExploded Bool
---@field targetTracker gameEffectInstance
---@field potentialHomingTargets GrenadePotentialHomingTarget[]
---@field homingGrenadeTarget GrenadePotentialHomingTarget
---@field cuttingGrenadePotentialTargets CuttingGrenadePotentialTarget[]
---@field drillTargetPosition Vector4
---@field attacksSpawned gameEffectInstance[]
---@field tweakRecord gamedataGrenade_Record
---@field additionalEffect gameFxResource
---@field landedCooldownActive Bool
---@field landedCooldownTimer Float
---@field hasHitWater Bool
---@field waterHeight Float
---@field smokeEffectRadius Float
---@field smokeEffectDuration Float
---@field smokeVisionBlockerId Uint32
---@field isSmokeEffectActive Bool
---@field smokeVFXDeescalationOffset Float
---@field cpoTimeBeforeRelease Float
BaseGrenade = {}

---@return BaseGrenade
function BaseGrenade.new() return end

---@param props table
---@return BaseGrenade
function BaseGrenade.new(props) return end

---@param owner gameObject
---@param itemID ItemID
function BaseGrenade.SendGrenadeAnimFeatureChangeEvent(owner, itemID) return end

---@param evt CuttingGrenadeAddAxisRotationEvent
---@return Bool
function BaseGrenade:OnAddAxisRotationEvent(evt) return end

---@param eventData gameprojectileHitEvent
---@return Bool
function BaseGrenade:OnCollision(eventData) return end

---@param evt CuttingGrenadeDespawnEffectsEvent
---@return Bool
function BaseGrenade:OnCuttingGrenadeDespawnEffectsEvent(evt) return end

---@param evt CuttingGrenadeSpawnBlinkEffectEvent
---@return Bool
function BaseGrenade:OnCuttingGrenadeSpawnBlinkEffectEvent(evt) return end

---@param evt CuttingGrenadeStopAttackEvent
---@return Bool
function BaseGrenade:OnCuttingGrenadeStopAttackEvent(evt) return end

---@param evt GrenadeDespawnRequestEvent
---@return Bool
function BaseGrenade:OnDespawnRequest(evt) return end

---@param evt GrenadeDetonateRequestEvent
---@return Bool
function BaseGrenade:OnDetonateRequest(evt) return end

---@param eventData gameprojectileFollowEvent
---@return Bool
function BaseGrenade:OnFollowSuccess(eventData) return end

---@param evt gameprojectileForceActivationEvent
---@return Bool
function BaseGrenade:OnForceActivation(evt) return end

---@param evt GrenadeAnimFeatureChangeEvent
---@return Bool
function BaseGrenade:OnGrenadeAnimFeatureChange(evt) return end

---@param evt gameeventsHitEvent
---@return Bool
function BaseGrenade:OnHit(evt) return end

---@param eventData gameprojectileSetUpEvent
---@return Bool
function BaseGrenade:OnProjectileInitialize(eventData) return end

---@param evt GrenadeReleaseRequestEvent
---@return Bool
function BaseGrenade:OnReleaseRequestEvent(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BaseGrenade:OnRequestComponents(ri) return end

---@param eventData gameprojectileShootEvent
---@return Bool
function BaseGrenade:OnShoot(eventData) return end

---@param eventData gameprojectileShootTargetEvent
---@return Bool
function BaseGrenade:OnShootTarget(eventData) return end

---@param evt SpawnLaserAttackEvent
---@return Bool
function BaseGrenade:OnSpawnLaserAttackEvent(evt) return end

---@param evt GrenadeStopDrillingRequestEvent
---@return Bool
function BaseGrenade:OnStopDrillingRequest(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BaseGrenade:OnTakeControl(ri) return end

---@param evt GrenadeTrackerTargetAcquiredEvent
---@return Bool
function BaseGrenade:OnTargetAcquired(evt) return end

---@param evt GrenadeTrackerTargetLostEvent
---@return Bool
function BaseGrenade:OnTargetLost(evt) return end

---@param evt GrenadeSetTargetTrackerStateEvent
---@return Bool
function BaseGrenade:OnTargetTrackerStateSet(evt) return end

---@param eventData gameprojectileTickEvent
---@return Bool
function BaseGrenade:OnTick(eventData) return end

---@param evt GrenadeTriggerSmartTrajectoryEvent
---@return Bool
function BaseGrenade:OnTriggerSmartTrajectory(evt) return end

---@return Bool
function BaseGrenade:OnVisualSpawnAttached() return end

function BaseGrenade:ActivateSmartTrajectory() return end

---@param position Vector4
---@param attackRadius Float
---@param numImpulses Int32
function BaseGrenade:AddWaterImpulsesOnDetonation(position, attackRadius, numImpulses) return end

---@param attackData gamedamageAttackData
function BaseGrenade:CheckForGunslingerAchievement(attackData) return end

---@return Bool
function BaseGrenade:CheckRegularDeliveryMethodConditions() return end

---@return Bool
function BaseGrenade:CheckStickyDeliveryMethodConditions() return end

---@return GrenadePotentialHomingTarget
function BaseGrenade:ChooseSmartTrajectoryTarget() return end

---@param newState Bool
---@param delay Float
function BaseGrenade:DelayTargetTrackingStateChange(newState, delay) return end

---@return gamedataStimType
function BaseGrenade:DetermineLandedStimType() return end

---@param hitNormal Vector4
function BaseGrenade:Detonate(hitNormal) return end

---@param collisionEventData gameprojectileHitInstance
function BaseGrenade:DrillThrough(collisionEventData) return end

function BaseGrenade:DropToFloor() return end

function BaseGrenade:FloatCuttingGrenadeUp() return end

function BaseGrenade:FloatToLockOnAltitude() return end

function BaseGrenade:Freeze() return end

---@return Float
function BaseGrenade:GetAccelerationZ() return end

---@return Float
function BaseGrenade:GetAttackDuration() return end

---@return Float
function BaseGrenade:GetAttackRadius() return end

---@return gamedataAttack_Record
function BaseGrenade:GetDefaultAttack() return end

---@return gamedataGrenadeDeliveryMethodType
function BaseGrenade:GetDeliveryMethod() return end

---@return Float
function BaseGrenade:GetDistanceFromFloor() return end

---@return Float
function BaseGrenade:GetDistanceToFloat() return end

---@param currentPosition Vector4
---@param hitNormal Vector4
---@return Vector4
function BaseGrenade:GetDrillTargetPosition(currentPosition, hitNormal) return end

---@return EGrenadeType
function BaseGrenade:GetGrenadeType() return end

---@param isQuickThrow Bool
---@return Float
function BaseGrenade:GetInitialVelocity(isQuickThrow) return end

---@return Vector4
function BaseGrenade:GetLastHitNormal() return end

---@param grenadeType EGrenadeType
---@return TweakDBID
function BaseGrenade:GetMappinIconIDForGrenadeType(grenadeType) return end

---@return Vector4
function BaseGrenade:GetShootCollisionSize() return end

---@return gameObject
function BaseGrenade:GetUser() return end

function BaseGrenade:InitializeRotation() return end

---@param compareType EGrenadeType
---@return Bool
function BaseGrenade:IsGrenadeOfType(compareType) return end

---@return Bool
function BaseGrenade:IsUnderwater() return end

---@return Bool
function BaseGrenade:MultiplayerCanRelease() return end

---@param eventData gameprojectileTickEvent
function BaseGrenade:OnServerTick(eventData) return end

---@param index Int32
function BaseGrenade:PlayLaserSlotAnimation(index) return end

function BaseGrenade:PlayNPCGrenadeBeepSound() return end

function BaseGrenade:PlayStickyGrenadeLongBeepSound() return end

function BaseGrenade:PlayStickyGrenadeShortBeepSound() return end

function BaseGrenade:PreloadAttackResources() return end

---@return Bool
function BaseGrenade:ProcessProximityTargets() return end

---@param delay Float
function BaseGrenade:QueueSmartTrajectory(delay) return end

---@param position Vector4
function BaseGrenade:RegisterSmokeExplosion(position) return end

---@param isInstant Bool
function BaseGrenade:Release(isInstant) return end

function BaseGrenade:ReleaseAttackResources() return end

function BaseGrenade:ReleaseMappin() return end

function BaseGrenade:RemoveGrenadeLandedStimuli() return end

---@param delay Float
function BaseGrenade:RequestGrenadeDetonation(delay) return end

---@param delay Float
function BaseGrenade:RequestGrenadeRelease(delay) return end

function BaseGrenade:Reset() return end

function BaseGrenade:SendCombatGadgetIsAliveFeature() return end

---@param canBeShot Bool
function BaseGrenade:SetCanBeShot(canBeShot) return end

---@param newState Int32
---@param target gameObject
function BaseGrenade:SetThrowableAnimFeatureOnGrenade(newState, target) return end

---@param state Bool
function BaseGrenade:SetTracking(state) return end

function BaseGrenade:SetupDeliveryMethodMesh() return end

---@return Bool
function BaseGrenade:ShouldUsePlayerAttack() return end

---@param attackRecord gamedataAttack_Record
---@param range Float
---@param duration Float
---@param hitNormal Vector4
---@param position Vector4
---@param vfxOffset Vector4
---@return gameEffectInstance
function BaseGrenade:SpawnAttack(attackRecord, range, duration, hitNormal, position, vfxOffset) return end

---@param key CName|string
function BaseGrenade:SpawnEffectFromLibrary(key) return end

---@param groundEffect gameFxResource
function BaseGrenade:SpawnEffectOnGround(groundEffect) return end

---@param attackRecord gamedataAttack_Record
---@param numberOfLasers Int32
---@param range Float
---@param duration Float
---@param playSlotAnimation Bool
---@param delayPerLaser Float
function BaseGrenade:SpawnLaserAttack(attackRecord, numberOfLasers, range, duration, playSlotAnimation, delayPerLaser) return end

---@param attackRecord gamedataAttack_Record
---@param range Float
---@param duration Float
---@param index Int32
---@param playSlotAnimation Bool
function BaseGrenade:SpawnLaserAttackSingle(attackRecord, range, duration, index, playSlotAnimation) return end

---@param attackRecord gamedataAttack_Record
---@param targetEntity ScriptedPuppet
---@return gameEffectInstance
function BaseGrenade:SpawnOnPuppetCollisionAttack(attackRecord, targetEntity) return end

function BaseGrenade:SpawnPiercingExplosion() return end

function BaseGrenade:SpawnVisualEffectsOnDetonation() return end

function BaseGrenade:StopCuttingGrenadeAttack() return end

function BaseGrenade:StopNPCGrenadeBeepSound() return end

function BaseGrenade:StopStickyGrenadeSounds() return end

function BaseGrenade:TerminateCuttingGrenadeAttack() return end

---@param hasLifeTime Bool
function BaseGrenade:TriggerGrenadeLandedStimuli(hasLifeTime) return end

---@param radius Float
function BaseGrenade:TriggerStimuli(radius) return end

function BaseGrenade:TryToSinkAndRequestDetonation() return end

function BaseGrenade:UnregisterSmokeExplosion() return end

---@class BaseHitPrereqCondition : IScriptable
---@field invert Bool
---@field onlyOncePerShot Bool
---@field lastAttackTime Float
BaseHitPrereqCondition = {}

---@return BaseHitPrereqCondition
function BaseHitPrereqCondition.new() return end

---@param props table
---@return BaseHitPrereqCondition
function BaseHitPrereqCondition.new(props) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function BaseHitPrereqCondition:CheckOnlyOncePerShot(hitEvent) return end

---@param hitEvent gameeventsHitEvent
---@return Bool
function BaseHitPrereqCondition:Evaluate(hitEvent) return end

---@param obj CName|string
---@param hitEvent gameeventsHitEvent
---@return gameObject
function BaseHitPrereqCondition:GetObjectToCheck(obj, hitEvent) return end

---@param missEvent gameeventsMissEvent
function BaseHitPrereqCondition:OnMissTriggered(missEvent) return end

---@param recordID TweakDBID|string
function BaseHitPrereqCondition:SetData(recordID) return end

---@class BaseHubMenuController : gameuiWidgetGameController
---@field menuEventDispatcher inkMenuEventDispatcher
---@field menuData IScriptable
BaseHubMenuController = {}

---@return BaseHubMenuController
function BaseHubMenuController.new() return end

---@param props table
---@return BaseHubMenuController
function BaseHubMenuController.new(props) return end

---@param userData IScriptable
---@return Bool
function BaseHubMenuController:OnBack(userData) return end

---@return Bool
function BaseHubMenuController:OnInitialize() return end

---@param menuEventDispatcher inkMenuEventDispatcher
---@return Bool
function BaseHubMenuController:OnSetMenuEventDispatcher(menuEventDispatcher) return end

---@return Bool
function BaseHubMenuController:OnUninitialize() return end

---@class BaseInnerBunkerComputerGameController : gameuiBaseBunkerComputerGameController
BaseInnerBunkerComputerGameController = {}

---@return BaseInnerBunkerComputerGameController
function BaseInnerBunkerComputerGameController.new() return end

---@param props table
---@return BaseInnerBunkerComputerGameController
function BaseInnerBunkerComputerGameController.new(props) return end

---@return ScriptGameInstance
function BaseInnerBunkerComputerGameController:GetGame() return end

---@class BaseItemAction : BaseScriptableAction
---@field itemData gameItemData
---@field removeAfterUse Bool
---@field quantity Int32
BaseItemAction = {}

---@return gameItemData
function BaseItemAction:GetItemData() return end

---@return gamedataItemType
function BaseItemAction:GetItemType() return end

---@return Int32
function BaseItemAction:GetRequestQuantity() return end

---@param item gameItemData
function BaseItemAction:SetItemData(item) return end

function BaseItemAction:SetRemoveAfterUse() return end

---@param quantity Int32
function BaseItemAction:SetRequestQuantity(quantity) return end

---@return Bool
function BaseItemAction:ShouldRemoveAfterUse() return end

---@class BaseModalListPopupGameController : gameuiWidgetGameController
---@field content inkWidgetReference
---@field listController inkVirtualListController
---@field playerPuppet gameObject
---@field popupData inkGameNotificationData
---@field timeDilationProfile String
---@field templateClassifier BaseModalListPopupTemplateClassifier
---@field systemRequestsHandler inkISystemRequestsHandler
---@field switchAnimProxy inkanimProxy
---@field inoutTransitionAnimProxy inkanimProxy
---@field isInMenuCallbackID redCallbackObject
---@field c_scrollInputThreshold Float
---@field firstInit Bool
BaseModalListPopupGameController = {}

---@return BaseModalListPopupGameController
function BaseModalListPopupGameController.new() return end

---@param props table
---@return BaseModalListPopupGameController
function BaseModalListPopupGameController.new(props) return end

---@param action gameinputScriptListenerAction
---@param consumer gameinputScriptListenerActionConsumer
---@return Bool
function BaseModalListPopupGameController:OnAction(action, consumer) return end

---@return Bool
function BaseModalListPopupGameController:OnAllElementsSpawned() return end

---@param proxy inkanimProxy
---@return Bool
function BaseModalListPopupGameController:OnHideAnimFinished(proxy) return end

---@return Bool
function BaseModalListPopupGameController:OnInitialize() return end

---@param param Bool
---@return Bool
function BaseModalListPopupGameController:OnIsInMenuChanged(param) return end

---@param previous inkVirtualCompoundItemController
---@param next inkVirtualCompoundItemController
---@return Bool
function BaseModalListPopupGameController:OnItemSelected(previous, next) return end

---@param playerPuppet gameObject
---@return Bool
function BaseModalListPopupGameController:OnPlayerAttach(playerPuppet) return end

---@param playerPuppet gameObject
---@return Bool
function BaseModalListPopupGameController:OnPlayerDetach(playerPuppet) return end

---@return Bool
function BaseModalListPopupGameController:OnUninitialize() return end

function BaseModalListPopupGameController:Activate() return end

function BaseModalListPopupGameController:BaseSetupVirtualList() return end

function BaseModalListPopupGameController:CleanVirtualList() return end

function BaseModalListPopupGameController:Close() return end

---@param axisData Float
function BaseModalListPopupGameController:HandleScroll(axisData) return end

function BaseModalListPopupGameController:OnClose() return end

function BaseModalListPopupGameController:ScrollNext() return end

function BaseModalListPopupGameController:ScrollPrior() return end

---@param previous inkVirtualCompoundItemController
---@param next inkVirtualCompoundItemController
function BaseModalListPopupGameController:Select(previous, next) return end

function BaseModalListPopupGameController:SendPSMRadialCloseRequest() return end

---@param enable Bool
function BaseModalListPopupGameController:SetTimeDilatation(enable) return end

function BaseModalListPopupGameController:SetupData() return end

function BaseModalListPopupGameController:SetupTimeModifierConfig() return end

function BaseModalListPopupGameController:SetupVirtualList() return end

function BaseModalListPopupGameController:VirtualListReady() return end

---@class BaseModalListPopupTemplateClassifier : inkVirtualItemTemplateClassifierWrapper
BaseModalListPopupTemplateClassifier = {}

---@return BaseModalListPopupTemplateClassifier
function BaseModalListPopupTemplateClassifier.new() return end

---@param props table
---@return BaseModalListPopupTemplateClassifier
function BaseModalListPopupTemplateClassifier.new(props) return end

---@param data Variant
---@return Uint32
function BaseModalListPopupTemplateClassifier:ClassifyItem(data) return end

---@class BaseNetworkSystemController : MasterController
BaseNetworkSystemController = {}

---@return BaseNetworkSystemController
function BaseNetworkSystemController.new() return end

---@param props table
---@return BaseNetworkSystemController
function BaseNetworkSystemController.new(props) return end

---@return BaseNetworkSystemControllerPS
function BaseNetworkSystemController:GetPS() return end

---@class BaseNetworkSystemControllerPS : MasterControllerPS
BaseNetworkSystemControllerPS = {}

---@return BaseNetworkSystemControllerPS
function BaseNetworkSystemControllerPS.new() return end

---@param props table
---@return BaseNetworkSystemControllerPS
function BaseNetworkSystemControllerPS.new(props) return end

---@class BasePerkDisplayData : IDisplayData
---@field attributeId TweakDBID
---@field name CName
---@field localizedName String
---@field localizedDescription String
---@field iconID TweakDBID
---@field binkRef redResourceReferenceScriptToken
---@field level Int32
---@field maxLevel Int32
---@field locked Bool
---@field proficiency gamedataProficiencyType
BasePerkDisplayData = {}

---@return BasePerkDisplayData
function BasePerkDisplayData.new() return end

---@param props table
---@return BasePerkDisplayData
function BasePerkDisplayData.new(props) return end

---@class BasePerkLevelData_Records : IScriptable
BasePerkLevelData_Records = {}

---@param index Int32
---@return gamedataTweakDBRecord
function BasePerkLevelData_Records:GetItemAt(index) return end

---@class BasePerksMenuTooltipData : ATooltipData
---@field manager PlayerDevelopmentDataManager
BasePerksMenuTooltipData = {}

---@return BasePerksMenuTooltipData
function BasePerksMenuTooltipData.new() return end

---@param props table
---@return BasePerksMenuTooltipData
function BasePerksMenuTooltipData.new(props) return end

function BasePerksMenuTooltipData:RefreshRuntimeData() return end

---@class BaseProjectile : gameItemObject
---@field projectileComponent gameprojectileComponent
---@field user gameObject
---@field projectile gameObject
---@field projectileSpawnPoint Vector4
---@field projectilePosition Vector4
---@field initialLaunchVelocity Float
---@field lifeTime Float
---@field tweakDBPath String
BaseProjectile = {}

---@return BaseProjectile
function BaseProjectile.new() return end

---@param props table
---@return BaseProjectile
function BaseProjectile.new(props) return end

---@param eventData gameprojectileHitEvent
---@return Bool
function BaseProjectile:OnCollision(eventData) return end

---@param evt ProjectileDelayEvent
---@return Bool
function BaseProjectile:OnMaxLifetimeReached(evt) return end

---@param eventData gameprojectileSetUpEvent
---@return Bool
function BaseProjectile:OnProjectileInitialize(eventData) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BaseProjectile:OnRequestComponents(ri) return end

---@param eventData gameprojectileShootEvent
---@return Bool
function BaseProjectile:OnShoot(eventData) return end

---@param eventData gameprojectileShootTargetEvent
---@return Bool
function BaseProjectile:OnShootTarget(eventData) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BaseProjectile:OnTakeControl(ri) return end

---@param evt ProjectileTickEvent
---@return Bool
function BaseProjectile:OnUpdate(evt) return end

---@param effectName CName|string
function BaseProjectile:BreakVisualEffectLoop(effectName) return end

---@param value Bool
function BaseProjectile:CanBounceAfterCollision(value) return end

---@param value Float
function BaseProjectile:CreateCustomTickEventWithDuration(value) return end

---@param value Float
function BaseProjectile:CreateDelayEvent(value) return end

---@param hitInstance gameprojectileHitInstance
---@param value Float
function BaseProjectile:CreateProjectileDeviceBreachEvent(hitInstance, value) return end

---@param eventData gameprojectileShootEvent
---@param targetObject gameObject
---@param targetComponent entIPlacedComponent
---@param startVelocity Float
---@param linearTimeRatio Float
---@param interpolationTimeRatio Float
---@param returnTimeMargin Float
---@param bendTimeRatio Float
---@param bendFactor Float
---@param halfLeanAngle Float
---@param endLeanAngle Float
---@param angleInterpolationDuration Float
function BaseProjectile:CurvedLaunch(eventData, targetObject, targetComponent, startVelocity, linearTimeRatio, interpolationTimeRatio, returnTimeMargin, bendTimeRatio, bendFactor, halfLeanAngle, endLeanAngle, angleInterpolationDuration) return end

---@param eventData gameprojectileShootEvent
---@param targetObject gameObject
---@param targetComponent entIPlacedComponent
function BaseProjectile:CurvedLaunchToTarget(eventData, targetObject, targetComponent) return end

---@param eventData gameprojectileShootEvent
function BaseProjectile:GeneralLaunchSetup(eventData) return end

---@return gameObject
function BaseProjectile:GetInstigator() return end

---@param user gameObject
---@return EActionType
function BaseProjectile:GetLeftHandCyberwareAction(user) return end

---@param hitInstance gameprojectileHitInstance
---@return gameObject
function BaseProjectile:GetObject(hitInstance) return end

---@param object gameObject
---@return Vector4
function BaseProjectile:GetObjectWorldPosition(object) return end

---@param param String
---@return Float
function BaseProjectile:GetProjectileTweakDBFloatParameter(param) return end

---@return Bool
function BaseProjectile:HasTrajectory() return end

---@param effectName CName|string
function BaseProjectile:KillVisualEffect(effectName) return end

---@param eventData gameprojectileShootEvent
---@param startVelocity Float
function BaseProjectile:LinearLaunch(eventData, startVelocity) return end

---@param eventData gameprojectileShootEvent
---@param gravitySimulation Float
---@param startVelocity Float
---@param energyLossFactorAfterCollision Float
function BaseProjectile:ParabolicLaunch(eventData, gravitySimulation, startVelocity, energyLossFactorAfterCollision) return end

---@param hitInstance gameprojectileHitInstance
---@param value Float
function BaseProjectile:ProjectileBreachDevice(hitInstance, value) return end

---@param eventData gameprojectileHitEvent
function BaseProjectile:ProjectileHit(eventData) return end

---@param hitInstance gameprojectileHitInstance
---@param attackRadius Float
---@param attackRecord gamedataAttack_Record
function BaseProjectile:ProjectileHitAoE(hitInstance, attackRadius, attackRecord) return end

function BaseProjectile:Release() return end

---@param user gameObject
function BaseProjectile:SetInitialVelocityBasedOnActionType(user) return end

---@param value Bool
function BaseProjectile:SetMeshVisible(value) return end

function BaseProjectile:SetProjectileLifetime() return end

---@param fx gameFxResource
---@param fxposition Vector4
---@return gameFxInstance
function BaseProjectile:SpawnLandVFXs(fx, fxposition) return end

---@param effectName CName|string
---@param eventTag CName|string
function BaseProjectile:SpawnVisualEffect(effectName, eventTag) return end

function BaseProjectile:StopProjectile() return end

---@param hitInstance gameprojectileHitInstance
---@param stimToSend gamedataStimType
---@param lifetime Float
---@param radius Float
function BaseProjectile:TriggerActiveStimuliWithLifetime(hitInstance, stimToSend, lifetime, radius) return end

---@param hitInstance gameprojectileHitInstance
---@param stimToSend gamedataStimType
function BaseProjectile:TriggerSingleStimuli(hitInstance, stimToSend) return end

---@class BaseResaveData
---@field baseDeviceData BaseDeviceData
---@field tweakDBRecord TweakDBID
BaseResaveData = {}

---@return BaseResaveData
function BaseResaveData.new() return end

---@param props table
---@return BaseResaveData
function BaseResaveData.new(props) return end

---@class BaseScriptableAction : gamedeviceAction
---@field requesterID entEntityID
---@field executor gameObject
---@field proxyExecutor gameObject
---@field costComponents gamedataObjectActionCost_Record[]
---@field objectActionID TweakDBID
---@field objectActionRecord gamedataObjectAction_Record
---@field inkWidgetID TweakDBID
---@field interactionChoice gameinteractionsChoice
---@field interactionLayer CName
---@field isActionRPGCheckDissabled Bool
---@field canSkipPayCost Bool
---@field calculatedBaseCost Int32
---@field deviceActionQueue DeviceActionQueue
---@field isActionQueueingUsed Bool
---@field isQueuedAction Bool
---@field isInactive Bool
---@field isTargetDead Bool
---@field activationTimeReduction Float
---@field IsAppliedByMonowire Bool
BaseScriptableAction = {}

---@param executor gameObject
---@param actionRecord gamedataObjectAction_Record
---@return Int32
function BaseScriptableAction.GetBaseCostStatic(executor, actionRecord) return end

---@param costComponents gamedataObjectActionCost_Record[]
---@return gamedataStatModifier_Record[]
function BaseScriptableAction.GetCostMods(costComponents) return end

---@param user gameObject
---@param checkForOverclockedState Bool
---@return Bool
function BaseScriptableAction:CanPayCost(user, checkForOverclockedState) return end

---@param isJustConsulting Bool
---@return Bool
function BaseScriptableAction:CanSkipPayCost(isJustConsulting) return end

function BaseScriptableAction:CompleteAction() return end

---@return CName
function BaseScriptableAction:GetActionID() return end

---@return Float
function BaseScriptableAction:GetActivationTime() return end

---@return Int32
function BaseScriptableAction:GetBaseCost() return end

---@return Float
function BaseScriptableAction:GetCooldownDuration() return end

---@return Int32
function BaseScriptableAction:GetCost() return end

---@param legendaryPlusPlus Bool
---@return Float
function BaseScriptableAction:GetDetonateGranadeCostReduction(legendaryPlusPlus) return end

---@return Int32
function BaseScriptableAction:GetDeviceActionMaxQueueSize() return end

---@return DeviceActionQueue
function BaseScriptableAction:GetDeviceActionQueue() return end

---@return CName[]
function BaseScriptableAction:GetDeviceActionQueueNames() return end

---@return Int32
function BaseScriptableAction:GetDeviceActionQueueSize() return end

---@return Float
function BaseScriptableAction:GetDurationTime() return end

---@return gameObject
function BaseScriptableAction:GetExecutor() return end

---@return Float
function BaseScriptableAction:GetExecutorLevel() return end

---@return TweakDBID
function BaseScriptableAction:GetGameplayCategoryID() return end

---@return gamedataObjectActionGameplayCategory_Record
function BaseScriptableAction:GetGameplayCategoryRecord() return end

---@return Bool
function BaseScriptableAction:GetIsActionRPGCheckDissabled() return end

---@param targetID entEntityID
---@return Float
function BaseScriptableAction:GetMadnessLvl3ProgramCostReduction(targetID) return end

---@return TweakDBID
function BaseScriptableAction:GetObjectActionID() return end

---@return gamedataObjectAction_Record
function BaseScriptableAction:GetObjectActionRecord() return end

---@return gamePersistentState
function BaseScriptableAction:GetOwnerPS() return end

---@return Float
function BaseScriptableAction:GetPowerLevelDiff() return end

---@return gameObject
function BaseScriptableAction:GetProxyExecutor() return end

---@return entEntityID
function BaseScriptableAction:GetRequesterID() return end

---@return TweakDBID
function BaseScriptableAction:GetTweakDBChoiceID() return end

---@return String
function BaseScriptableAction:GetTweakDBChoiceRecord() return end

---@param targetID entEntityID
---@param category gamedataHackCategory
---@return Bool
function BaseScriptableAction:IsFirstUniqueCategoryInQueue(targetID, category) return end

---@return Bool
function BaseScriptableAction:IsInactive() return end

---@return Bool
function BaseScriptableAction:IsInteractionChoiceValid() return end

---@param target gameObject
---@param actionRecord gamedataObjectAction_Record
---@param objectActionsCallbackController gameObjectActionsCallbackController
---@return Bool
function BaseScriptableAction:IsPossible(target, actionRecord, objectActionsCallbackController) return end

---@param context gameGetActionsContext
---@param objectActionsCallbackController gameObjectActionsCallbackController
---@return Bool
function BaseScriptableAction:IsVisible(context, objectActionsCallbackController) return end

---@param player gameObject
---@param objectActionsCallbackController gameObjectActionsCallbackController
---@return Bool
function BaseScriptableAction:IsVisible(player, objectActionsCallbackController) return end

---@param checkForOverclockedState Bool
---@return Bool
function BaseScriptableAction:PayCost(checkForOverclockedState) return end

---@param actionEffects gamedataObjectActionEffect_Record[]
function BaseScriptableAction:ProcessEffectors(actionEffects) return end

---@param gameplayRoleComponent GameplayRoleComponent
function BaseScriptableAction:ProcessRPGAction(gameplayRoleComponent) return end

---@param actionEffects gamedataObjectActionEffect_Record[]
function BaseScriptableAction:ProcessStatusEffects(actionEffects) return end

function BaseScriptableAction:ProduceInteractionPart() return end

---@param gameplayRoleComponent GameplayRoleComponent
---@return Bool
function BaseScriptableAction:PutActionInQuickhackQueue(gameplayRoleComponent) return end

---@param id entEntityID
function BaseScriptableAction:RegisterAsRequester(id) return end

---@param entityID entEntityID
---@param statusEffectRecord gamedataStatusEffect_Record
function BaseScriptableAction:ResetStatusEffectIfActionIsQueued(entityID, statusEffectRecord) return end

function BaseScriptableAction:SetActive() return end

---@param executor gameObject
function BaseScriptableAction:SetExecutor(executor) return end

function BaseScriptableAction:SetInactive() return end

---@param value Bool
function BaseScriptableAction:SetIsActionRPGCheckDissabled(value) return end

---@param id TweakDBID|string
function BaseScriptableAction:SetObjectActionID(id) return end

---@param proxy gameObject
function BaseScriptableAction:SetProxyExecutor(proxy) return end

function BaseScriptableAction:StartAction() return end

function BaseScriptableAction:StartUpload() return end

---@class BaseSkillCheckContainer : IScriptable
---@field hackingCheckSlot HackingSkillCheck
---@field engineeringCheckSlot EngineeringSkillCheck
---@field demolitionCheckSlot DemolitionSkillCheck
---@field isInitialized Bool
BaseSkillCheckContainer = {}

---@return DemolitionSkillCheck
function BaseSkillCheckContainer:GetDemolitionSlot() return end

---@return EngineeringSkillCheck
function BaseSkillCheckContainer:GetEngineeringSlot() return end

---@return HackingSkillCheck
function BaseSkillCheckContainer:GetHackingSlot() return end

---@param container BaseSkillCheckContainer
function BaseSkillCheckContainer:Initialize(container) return end

---@param difficulty EGameplayChallengeLevel
function BaseSkillCheckContainer:InitializeBackdoor(difficulty) return end

---@return Bool
function BaseSkillCheckContainer:IsInitialized() return end

---@param slotToInitialize SkillCheckBase
function BaseSkillCheckContainer:TryToInitialize(slotToInitialize) return end

---@class BaseStatPoolPrereqListener : gameCustomValueStatPoolsListener
BaseStatPoolPrereqListener = {}

---@return BaseStatPoolPrereqListener
function BaseStatPoolPrereqListener.new() return end

---@param props table
---@return BaseStatPoolPrereqListener
function BaseStatPoolPrereqListener.new(props) return end

---@param state gamePrereqState
function BaseStatPoolPrereqListener:RegisterState(state) return end

---@class BaseStateOperationTriggerData : DeviceOperationTriggerData
---@field state EDeviceStatus
BaseStateOperationTriggerData = {}

---@return BaseStateOperationTriggerData
function BaseStateOperationTriggerData.new() return end

---@param props table
---@return BaseStateOperationTriggerData
function BaseStateOperationTriggerData.new(props) return end

---@class BaseStateOperations : DeviceOperations
---@field stateActionsOverrides SGenericDeviceActionsData
---@field baseStateOperations SBaseStateOperationData[]
---@field wasStateCached Bool
---@field cachedState EDeviceStatus
BaseStateOperations = {}

---@return BaseStateOperations
function BaseStateOperations.new() return end

---@param props table
---@return BaseStateOperations
function BaseStateOperations.new(props) return end

---@param operationID Int32
function BaseStateOperations:ClearDelayIdOnOperation(operationID) return end

---@param state EDeviceStatus
---@param owner gameObject
function BaseStateOperations:ExecuteOperation(state, owner) return end

---@param index Int32
---@return Bool
function BaseStateOperations:IsOperationEnabled(index) return end

---@param ri entEntityRequestComponentsInterface
function BaseStateOperations:RequestComponents(ri) return end

---@param delayId gameDelayID
---@param operationID Int32
function BaseStateOperations:SetDelayIdOnOperation(delayId, operationID) return end

---@param ri entEntityResolveComponentsInterface
function BaseStateOperations:TakeControl(ri) return end

---@param enable Bool
---@param index Int32
function BaseStateOperations:ToggleOperation(enable, index) return end

---@class BaseStateOperationsTrigger : DeviceOperationsTrigger
---@field triggerData BaseStateOperationTriggerData
---@field wasStateCached Bool
---@field cachedState EDeviceStatus
BaseStateOperationsTrigger = {}

---@return BaseStateOperationsTrigger
function BaseStateOperationsTrigger.new() return end

---@param props table
---@return BaseStateOperationsTrigger
function BaseStateOperationsTrigger.new(props) return end

---@param state EDeviceStatus
---@param owner gameObject
---@param container DeviceOperationsContainer
function BaseStateOperationsTrigger:EvaluateTrigger(state, owner, container) return end

---@class BaseSubtitleLineLogicController : inkWidgetLogicController
---@field root inkWidget
---@field isKiroshiEnabled Bool
---@field c_tier1_duration Float
---@field c_tier2_duration Float
BaseSubtitleLineLogicController = {}

---@return BaseSubtitleLineLogicController
function BaseSubtitleLineLogicController.new() return end

---@param props table
---@return BaseSubtitleLineLogicController
function BaseSubtitleLineLogicController.new(props) return end

---@return Bool
function BaseSubtitleLineLogicController:IsKiroshiEnabled() return end

---@param kiroshiStatus Bool
function BaseSubtitleLineLogicController:SetKiroshiStatus(kiroshiStatus) return end

---@param lineData scnDialogLineData
function BaseSubtitleLineLogicController:SetLineData(lineData) return end

---@param duration Float
---@param animCtrl inkTextKiroshiAnimationController
function BaseSubtitleLineLogicController:SetupAnimation(duration, animCtrl) return end

---@param duration Float
---@param animCtrl inkTextReplaceAnimationController
function BaseSubtitleLineLogicController:SetupAnimation(duration, animCtrl) return end

---@param textSize Int32
---@param backgroundOpacity Float
function BaseSubtitleLineLogicController:SetupSettings(textSize, backgroundOpacity) return end

---@param value Bool
function BaseSubtitleLineLogicController:ShowBackground(value) return end

---@class BaseSubtitlesGameController : gameuiProjectedHUDGameController
---@field lineMap subtitleLineMapEntry[]
---@field pendingShowLines CRUID[]
---@field pendingHideLines CRUID[]
---@field settings userSettingsUserSettings
---@field settingsListener SubtitlesSettingsListener
---@field groupPath CName
---@field gameInstance ScriptGameInstance
---@field uiBlackboard gameIBlackboard
---@field bbCbShowDialogLine redCallbackObject
---@field bbCbHideDialogLine redCallbackObject
---@field bbCbHideDialogLineByData redCallbackObject
---@field bbCbShowBackground redCallbackObject
---@field showBackgroud Bool
---@field isCreoleUnlocked Bool
---@field isPlayerJohnny Bool
---@field disabledBySettings Bool
---@field forceForeignLines Bool
---@field isRadioSubtitleEnabled Bool
---@field backgroundOpacity Float
---@field fontSize Int32
---@field factlistenerId Uint32
BaseSubtitlesGameController = {}

---@return BaseSubtitlesGameController
function BaseSubtitlesGameController.new() return end

---@param props table
---@return BaseSubtitlesGameController
function BaseSubtitlesGameController.new(props) return end

---@param value Int32
---@return Bool
function BaseSubtitlesGameController:OnCreoleFactChanged(value) return end

---@param value Variant
---@return Bool
function BaseSubtitlesGameController:OnHideDialogLine(value) return end

---@param value Variant
---@return Bool
function BaseSubtitlesGameController:OnHideDialogLineByData(value) return end

---@return Bool
function BaseSubtitlesGameController:OnInitialize() return end

---@param widget inkWidget
---@param userData IScriptable
---@return Bool
function BaseSubtitlesGameController:OnLineSpawned(widget, userData) return end

---@param playerPuppet gameObject
---@return Bool
function BaseSubtitlesGameController:OnPlayerAttach(playerPuppet) return end

---@param value Bool
---@return Bool
function BaseSubtitlesGameController:OnShowBackground(value) return end

---@param value Variant
---@return Bool
function BaseSubtitlesGameController:OnShowDialogLine(value) return end

---@return Bool
function BaseSubtitlesGameController:OnUninitialize() return end

---@param evt inkWorldAttachedEvt
---@return Bool
function BaseSubtitlesGameController:OnWorldAttached(evt) return end

function BaseSubtitlesGameController:CalculateVisibility() return end

function BaseSubtitlesGameController:Cleanup() return end

---@param lineSpawnData LineSpawnData
function BaseSubtitlesGameController:CreateLine(lineSpawnData) return end

---@param value Bool
function BaseSubtitlesGameController:DisableBySettings(value) return end

---@param value Bool
function BaseSubtitlesGameController:EnableRadioSubtilesBySettings(value) return end

---@param lineID CRUID
---@return BaseSubtitleLineLogicController
function BaseSubtitlesGameController:FindLineController(lineID) return end

---@param lineID CRUID
---@return inkWidget
function BaseSubtitlesGameController:FindLineWidget(lineID) return end

---@param value Bool
function BaseSubtitlesGameController:ForceForeignLinesBySettings(value) return end

function BaseSubtitlesGameController:ForceSettingsUpdate() return end

---@return ScriptGameInstance
function BaseSubtitlesGameController:GetGame() return end

---@return CName
function BaseSubtitlesGameController:GetTextSizeSettigId() return end

---@param linesToHide CRUID[]
function BaseSubtitlesGameController:HideDialogLine(linesToHide) return end

---@param linesToHide scnDialogLineData[]
function BaseSubtitlesGameController:HideDialogLinesByData(linesToHide) return end

---@param lineData scnDialogLineData
---@return Bool
function BaseSubtitlesGameController:IsKiroshiEnabled(lineData) return end

---@param lineData scnDialogLineData
---@return Bool
function BaseSubtitlesGameController:IsMainDialogLine(lineData) return end

---@param lineData subtitleLineMapEntry
function BaseSubtitlesGameController:OnHideLine(lineData) return end

---@param lineData subtitleLineMapEntry
function BaseSubtitlesGameController:OnHideLineByData(lineData) return end

---@param lineId CRUID
function BaseSubtitlesGameController:OnRemovalFailure(lineId) return end

---@param controller BaseSubtitleLineLogicController
function BaseSubtitlesGameController:OnSubCreated(controller) return end

---@param groupPath CName|string
---@param varName CName|string
---@param varType InGameConfigVarType
---@param reason InGameConfigChangeReason
function BaseSubtitlesGameController:OnVarModified(groupPath, varName, varType, reason) return end

---@param value Bool
function BaseSubtitlesGameController:RegisterToDialogBlackboard(value) return end

---@param lineID CRUID
---@return Bool
function BaseSubtitlesGameController:RemoveLine(lineID) return end

---@param line scnDialogLineData
---@return Bool
function BaseSubtitlesGameController:RemoveLineByData(line) return end

---@param currLine CRUID
function BaseSubtitlesGameController:ResolveShowHidePendingLines(currLine) return end

---@param value Float
function BaseSubtitlesGameController:SetBackgroundOpacitySettings(value) return end

---@param value Bool
function BaseSubtitlesGameController:SetChattersForeignLinesVisibilitySetting(value) return end

---@param value Bool
function BaseSubtitlesGameController:SetChattersVisibilitySetting(value) return end

---@param value Bool
function BaseSubtitlesGameController:SetRadioSubsVisibilitySetting(value) return end

---@param value Int32
function BaseSubtitlesGameController:SetSizeSettings(value) return end

---@param value Bool
function BaseSubtitlesGameController:SetSubsForeignLinesVisibilitySetting(value) return end

---@param value Bool
function BaseSubtitlesGameController:SetSubsVisibilitySetting(value) return end

---@param lineWidget inkWidget
---@param lineSpawnData LineSpawnData
function BaseSubtitlesGameController:SetupLine(lineWidget, lineSpawnData) return end

---@param lineData scnDialogLineData
---@return Bool
function BaseSubtitlesGameController:ShouldDisplayLine(lineData) return end

---@param linesToShow scnDialogLineData[]
function BaseSubtitlesGameController:ShowDialogLines(linesToShow) return end

---@param value Bool
function BaseSubtitlesGameController:ShowKiroshiSettings(value) return end

function BaseSubtitlesGameController:ShowPendingSubtitles() return end

---@param lineData scnDialogLineData
function BaseSubtitlesGameController:SpawnDialogLine(lineData) return end

function BaseSubtitlesGameController:TryRemovePendingHideLines() return end

function BaseSubtitlesGameController:UpdateBackgroundOpacitySettings() return end

function BaseSubtitlesGameController:UpdateChattersForeignVisibilitySettings() return end

function BaseSubtitlesGameController:UpdateChattersVisibilitySetting() return end

function BaseSubtitlesGameController:UpdateRadioSubsVisibilitySetting() return end

function BaseSubtitlesGameController:UpdateSizeSettings() return end

function BaseSubtitlesGameController:UpdateSubsForeignVisibilitySettings() return end

function BaseSubtitlesGameController:UpdateSubsVisibilitySetting() return end

---@class BaseTechCrosshairController : gameuiCrosshairBaseGameController
---@field player gameObject
---@field statsSystem gameStatsSystem
---@field fullChargeAvailable Bool
---@field overChargeAvailable Bool
---@field fullChargeListener CrosshairWeaponStatsListener
---@field overChargeListener CrosshairWeaponStatsListener
BaseTechCrosshairController = {}

---@return BaseTechCrosshairController
function BaseTechCrosshairController.new() return end

---@param props table
---@return BaseTechCrosshairController
function BaseTechCrosshairController.new(props) return end

---@return Bool
function BaseTechCrosshairController:OnInitialize() return end

---@return Bool
function BaseTechCrosshairController:OnUnitialize() return end

---@return Float
function BaseTechCrosshairController:GetCurrentChargeLimit() return end

---@return Bool
function BaseTechCrosshairController:IsFullChargeAvailable() return end

---@return Bool
function BaseTechCrosshairController:IsOverChargeAvailable() return end

---@param ownerID gameStatsObjectID
---@param statType gamedataStatType
---@param diff Float
---@param total Float
function BaseTechCrosshairController:OnCrosshairWeaponStatChanged(ownerID, statType, diff, total) return end

function BaseTechCrosshairController:OnWeaponChargingStatChanged() return end

---@class BaseToggleView : inkWidgetLogicController
---@field ToggleController inkToggleController
---@field OldState inkEToggleState
BaseToggleView = {}

---@param controller inkButtonController
---@param oldState inkEButtonState
---@param newState inkEButtonState
---@return Bool
function BaseToggleView:OnButtonStateChanged(controller, oldState, newState) return end

---@return Bool
function BaseToggleView:OnInitialize() return end

---@return inkToggleController
function BaseToggleView:GetParentButton() return end

---@param oldState inkEToggleState
---@param newState inkEToggleState
function BaseToggleView:ToggleStateChanged(oldState, newState) return end

---@class BasicAnimationController : inkWidgetLogicController
---@field showAnimation CName
---@field idleAnimation CName
---@field hideAnimation CName
---@field animationPlayer AnimationChainPlayer
---@field currentAnimation CName
BasicAnimationController = {}

---@return BasicAnimationController
function BasicAnimationController.new() return end

---@param props table
---@return BasicAnimationController
function BasicAnimationController.new(props) return end

---@return Bool
function BasicAnimationController:OnInitialize() return end

---@param immediately Bool
function BasicAnimationController:PlayHide(immediately) return end

---@param immediately Bool
function BasicAnimationController:PlayShow(immediately) return end

---@class BasicDistractionDevice : InteractiveDevice
---@field animFeatureDataDistractor AnimFeature_DistractionState
---@field animFeatureDataNameDistractor CName
---@field distractionComponentSwapNamesToON CName[]
---@field distractionComponentSwapNamesToOFF CName[]
---@field distractionComponentON entIPlacedComponent[]
---@field distractionComponentOFF entIPlacedComponent[]
---@field meshAppearanceNameON CName
---@field meshAppearanceNameOFF CName
BasicDistractionDevice = {}

---@return BasicDistractionDevice
function BasicDistractionDevice.new() return end

---@param props table
---@return BasicDistractionDevice
function BasicDistractionDevice.new(props) return end

---@return Bool
function BasicDistractionDevice:OnDetach() return end

---@return Bool
function BasicDistractionDevice:OnGameAttached() return end

---@param evt QuestStartGlitch
---@return Bool
function BasicDistractionDevice:OnQuestStartGlitch(evt) return end

---@param evt QuestStopGlitch
---@return Bool
function BasicDistractionDevice:OnQuestStopGlitch(evt) return end

---@param evt QuickHackDistraction
---@return Bool
function BasicDistractionDevice:OnQuickHackDistraction(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BasicDistractionDevice:OnRequestComponents(ri) return end

---@param evt SpiderbotDistractDevicePerformed
---@return Bool
function BasicDistractionDevice:OnSpiderbotDistractDevicePerformed(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BasicDistractionDevice:OnTakeControl(ri) return end

---@return EGameplayRole
function BasicDistractionDevice:DeterminGameplayRole() return end

function BasicDistractionDevice:EffectsOnStartPlay() return end

---@param shouldStop Bool
function BasicDistractionDevice:EffectsOnStartStop(shouldStop) return end

---@return BasicDistractionDeviceController
function BasicDistractionDevice:GetController() return end

---@return BasicDistractionDeviceControllerPS
function BasicDistractionDevice:GetDevicePS() return end

---@param start Bool
function BasicDistractionDevice:MeshSwapOnDistraction(start) return end

function BasicDistractionDevice:PlayAnimgraphTransformAnimation() return end

---@param loop Bool
function BasicDistractionDevice:PlayDistractAnimation(loop) return end

---@param animationName CName|string
---@param loop Bool
function BasicDistractionDevice:PlayTransformAnimation(animationName, loop) return end

---@param loopAnimation Bool
function BasicDistractionDevice:StartDistraction(loopAnimation) return end

function BasicDistractionDevice:StopAnimgraphTransformAnimation() return end

function BasicDistractionDevice:StopDistractAnimation() return end

function BasicDistractionDevice:StopDistraction() return end

---@param animationName CName|string
function BasicDistractionDevice:StopTransformDistractAnimation(animationName) return end

function BasicDistractionDevice:TurnOffDevice() return end

function BasicDistractionDevice:TurnOnDevice() return end

---@class BasicDistractionDeviceController : ScriptableDeviceComponent
BasicDistractionDeviceController = {}

---@return BasicDistractionDeviceController
function BasicDistractionDeviceController.new() return end

---@param props table
---@return BasicDistractionDeviceController
function BasicDistractionDeviceController.new(props) return end

---@return BasicDistractionDeviceControllerPS
function BasicDistractionDeviceController:GetPS() return end

---@class BasicDistractionDeviceControllerPS : ScriptableDeviceComponentPS
---@field distractorType EPlaystyleType
---@field basicDistractionDeviceSkillChecks EngDemoContainer
---@field effectOnStartNames CName[]
---@field animationType EAnimationType
---@field forceAnimationSystem Bool
---@field overrideDistractionActionId TweakDBID
BasicDistractionDeviceControllerPS = {}

---@return BasicDistractionDeviceControllerPS
function BasicDistractionDeviceControllerPS.new() return end

---@param props table
---@return BasicDistractionDeviceControllerPS
function BasicDistractionDeviceControllerPS.new(props) return end

---@return Bool
function BasicDistractionDeviceControllerPS:OnInstantiated() return end

---@return QuickHackDistraction
function BasicDistractionDeviceControllerPS:ActionQuickHackDistraction() return end

---@return SpiderbotDistractDevice
function BasicDistractionDeviceControllerPS:ActionSpiderbotDistractDevice() return end

---@return SpiderbotDistractDevicePerformed
function BasicDistractionDeviceControllerPS:ActionSpiderbotDistractDevicePerformed() return end

---@return Bool
function BasicDistractionDeviceControllerPS:CanCreateAnyQuickHackActions() return end

---@return Bool
function BasicDistractionDeviceControllerPS:CanCreateAnySpiderbotActions() return end

function BasicDistractionDeviceControllerPS:GameAttached() return end

---@return EAnimationType
function BasicDistractionDeviceControllerPS:GetAnimationType() return end

---@return CName[]
function BasicDistractionDeviceControllerPS:GetEffectOnStartNames() return end

---@return Bool
function BasicDistractionDeviceControllerPS:GetForceAnimationSystem() return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function BasicDistractionDeviceControllerPS:GetQuickHackActions(context) return end

---@return BaseSkillCheckContainer
function BasicDistractionDeviceControllerPS:GetSkillCheckContainerForSetup() return end

---@param actions gamedeviceAction[]
---@param context gameGetActionsContext
function BasicDistractionDeviceControllerPS:GetSpiderbotActions(actions, context) return end

function BasicDistractionDeviceControllerPS:Initialize() return end

---@param evt SpiderbotDistractDevice
---@return EntityNotificationType
function BasicDistractionDeviceControllerPS:OnSpiderbotDistractExplosiveDevice(evt) return end

---@param evt SpiderbotDistractDevicePerformed
---@return EntityNotificationType
function BasicDistractionDeviceControllerPS:OnSpiderbotDistractExplosiveDevicePerformed(evt) return end

---@class BasicInteractionInterpreter : IScriptable
BasicInteractionInterpreter = {}

---@return BasicInteractionInterpreter
function BasicInteractionInterpreter.new() return end

---@param props table
---@return BasicInteractionInterpreter
function BasicInteractionInterpreter.new(props) return end

---@param isSecured Bool
---@param actions gamedeviceAction[]
---@param allApplicableChoices gameinteractionsChoice[]
---@param onlyInteractableChoices gameinteractionsChoice[]
function BasicInteractionInterpreter.Evaluate(isSecured, actions, allApplicableChoices, onlyInteractableChoices) return end

---@class BasicViabilityInterpreter : IScriptable
BasicViabilityInterpreter = {}

---@return BasicViabilityInterpreter
function BasicViabilityInterpreter.new() return end

---@param props table
---@return BasicViabilityInterpreter
function BasicViabilityInterpreter.new(props) return end

---@param device ScriptableDeviceComponentPS
---@param hasActiveActions Bool
---@return EViabilityDecision
function BasicViabilityInterpreter.Evaluate(device, hasActiveActions) return end

---@class BeamData
---@field startDirection Vector4
---@field endDirection Vector4
---@field effect gameEffectInstance
---@field target gameObject
BeamData = {}

---@return BeamData
function BeamData.new() return end

---@param props table
---@return BeamData
function BeamData.new(props) return end

---@class BeginArcadeMinigameUI : ActionBool
BeginArcadeMinigameUI = {}

---@return BeginArcadeMinigameUI
function BeginArcadeMinigameUI.new() return end

---@param props table
---@return BeginArcadeMinigameUI
function BeginArcadeMinigameUI.new(props) return end

---@return String
function BeginArcadeMinigameUI:GetTweakDBChoiceRecord() return end

function BeginArcadeMinigameUI:SetProperties() return end

---@class BeginOne : DefaultTest
BeginOne = {}

---@return BeginOne
function BeginOne.new() return end

---@param props table
---@return BeginOne
function BeginOne.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BeginOne:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BeginOne:OnExit(stateContext, scriptInterface) return end

---@class BeginTwo : DefaultTest
BeginTwo = {}

---@return BeginTwo
function BeginTwo.new() return end

---@param props table
---@return BeginTwo
function BeginTwo.new(props) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BeginTwo:OnEnter(stateContext, scriptInterface) return end

---@param stateContext gamestateMachineStateContextScript
---@param scriptInterface gamestateMachineGameScriptInterface
function BeginTwo:OnExit(stateContext, scriptInterface) return end

---@class BeingTargetByLaserSightUpdateEvent : redEvent
---@field weapon gameweaponObject
---@field state LaserTargettingState
BeingTargetByLaserSightUpdateEvent = {}

---@return BeingTargetByLaserSightUpdateEvent
function BeingTargetByLaserSightUpdateEvent.new() return end

---@param props table
---@return BeingTargetByLaserSightUpdateEvent
function BeingTargetByLaserSightUpdateEvent.new(props) return end

---@class BenchmarkLabelController : inkWidgetLogicController
---@field labelWidget inkTextWidgetReference
---@field valueWidget inkTextWidgetReference
BenchmarkLabelController = {}

---@return BenchmarkLabelController
function BenchmarkLabelController.new() return end

---@param props table
---@return BenchmarkLabelController
function BenchmarkLabelController.new(props) return end

---@param label String
function BenchmarkLabelController:SetLabel(label) return end

---@param value String
function BenchmarkLabelController:SetValue(value) return end

---@class BenchmarkLineData : IScriptable
---@field label String
---@field value String
BenchmarkLineData = {}

---@return BenchmarkLineData
function BenchmarkLineData.new() return end

---@param props table
---@return BenchmarkLineData
function BenchmarkLineData.new(props) return end

---@class BenchmarkResultsGameController : gameuiWidgetGameController
---@field exitButton inkWidgetReference
---@field settingButton inkWidgetReference
---@field leftEntriesListContainer inkCompoundWidgetReference
---@field rightEntriesListContainer inkCompoundWidgetReference
---@field lineEntryName CName
---@field highlightLineEntryName CName
---@field sectionEntryName CName
---@field benchmarkSummary worldBenchmarkSummary
---@field exitRequestToken inkGameNotificationToken
---@field settingsAcive Bool
BenchmarkResultsGameController = {}

---@return BenchmarkResultsGameController
function BenchmarkResultsGameController.new() return end

---@param props table
---@return BenchmarkResultsGameController
function BenchmarkResultsGameController.new(props) return end

---@param e inkPointerEvent
---@return Bool
function BenchmarkResultsGameController:OnBnechmarkShowSettings(e) return end

---@param data inkGameNotificationData
---@return Bool
function BenchmarkResultsGameController:OnCloseBenchmarkResults(data) return end

---@param e inkPointerEvent
---@return Bool
function BenchmarkResultsGameController:OnGlobalRelease(e) return end

---@return Bool
function BenchmarkResultsGameController:OnInitialize() return end

---@param evt OnBnechmarkHideSettings
---@return Bool
function BenchmarkResultsGameController:OnOnBnechmarkHideSettings(evt) return end

---@param data IScriptable
---@return Bool
function BenchmarkResultsGameController:OnSetUserData(data) return end

---@param e inkPointerEvent
---@return Bool
function BenchmarkResultsGameController:OnShowExitPrompt(e) return end

function BenchmarkResultsGameController:DisplayBenchmarkSummary() return end

---@param RTLightQuality Int32
---@return String
function BenchmarkResultsGameController:GetRayTracedLightingQualityLocKey(RTLightQuality) return end

---@param windowMode Uint8
---@return String
function BenchmarkResultsGameController:GetWindowModeLocKey(windowMode) return end

---@param widget inkWidget
---@param userData IScriptable
function BenchmarkResultsGameController:OnLineSpawned(widget, userData) return end

function BenchmarkResultsGameController:ShowExitPrompt() return end

---@param entryName CName|string
---@param column EEntryColumn
---@param label String
---@param value String
function BenchmarkResultsGameController:SpawnSummaryLine(entryName, column, label, value) return end

---@class BetData
---@field chipsAmount Uint32
---@field betAmount Uint32
---@field betOn CasinoTableBet
BetData = {}

---@return BetData
function BetData.new() return end

---@param props table
---@return BetData
function BetData.new(props) return end

---@class BetOnMark
---@field betOn CasinoTableBet
---@field mark inkWidgetReference
BetOnMark = {}

---@return BetOnMark
function BetOnMark.new() return end

---@param props table
---@return BetOnMark
function BetOnMark.new(props) return end

---@class BillboardDevice : InteractiveDevice
---@field advUiComponent entIComponent
---@field isShortGlitchActive Bool
---@field shortGlitchDelayID gameDelayID
BillboardDevice = {}

---@return BillboardDevice
function BillboardDevice.new() return end

---@param props table
---@return BillboardDevice
function BillboardDevice.new(props) return end

---@param hit gameeventsHitEvent
---@return Bool
function BillboardDevice:OnHitEvent(hit) return end

---@param evt entPhysicalDestructionEvent
---@return Bool
function BillboardDevice:OnPhysicalDestructionEvent(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BillboardDevice:OnRequestComponents(ri) return end

---@param evt StopShortGlitchEvent
---@return Bool
function BillboardDevice:OnStopShortGlitch(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BillboardDevice:OnTakeControl(ri) return end

---@param target entEntityID
---@param statusEffect TweakDBID|string
function BillboardDevice:ApplyActiveStatusEffect(target, statusEffect) return end

function BillboardDevice:BreakDevice() return end

function BillboardDevice:CutPower() return end

---@return EGameplayRole
function BillboardDevice:DeterminGameplayRole() return end

---@return BillboardDeviceController
function BillboardDevice:GetController() return end

---@return BillboardDeviceControllerPS
function BillboardDevice:GetDevicePS() return end

function BillboardDevice:ResolveGameplayState() return end

---@return Bool
function BillboardDevice:ShouldRegisterToHUD() return end

---@param glitchState EGlitchState
---@param intensity Float
function BillboardDevice:StartGlitching(glitchState, intensity) return end

function BillboardDevice:StartShortGlitch() return end

function BillboardDevice:StopGlitching() return end

---@param on Bool
function BillboardDevice:ToggleLights(on) return end

function BillboardDevice:TurnOffDevice() return end

function BillboardDevice:TurnOffScreen() return end

function BillboardDevice:TurnOnDevice() return end

function BillboardDevice:TurnOnScreen() return end

---@param targetID entEntityID
function BillboardDevice:UploadActiveProgramOnNPC(targetID) return end

---@class BillboardDeviceController : ScriptableDeviceComponent
BillboardDeviceController = {}

---@return BillboardDeviceController
function BillboardDeviceController.new() return end

---@param props table
---@return BillboardDeviceController
function BillboardDeviceController.new(props) return end

---@return BillboardDeviceControllerPS
function BillboardDeviceController:GetPS() return end

---@class BillboardDeviceControllerPS : ScriptableDeviceComponentPS
---@field glitchSFX CName
---@field useLights Bool
---@field lightsSettings EditableGameLightSettings[]
---@field useDeviceAppearence Bool
BillboardDeviceControllerPS = {}

---@return BillboardDeviceControllerPS
function BillboardDeviceControllerPS.new() return end

---@param props table
---@return BillboardDeviceControllerPS
function BillboardDeviceControllerPS.new(props) return end

---@return Bool
function BillboardDeviceControllerPS:OnInstantiated() return end

---@return Bool
function BillboardDeviceControllerPS:CanCreateAnyQuickHackActions() return end

---@return TweakDBID
function BillboardDeviceControllerPS:GetBackgroundTextureTweakDBID() return end

---@return gamedeviceClearance
function BillboardDeviceControllerPS:GetClearance() return end

---@return TweakDBID
function BillboardDeviceControllerPS:GetDeviceIconTweakDBID() return end

---@return CName
function BillboardDeviceControllerPS:GetGlitchSFX() return end

---@return EditableGameLightSettings[]
function BillboardDeviceControllerPS:GetLightsSettings() return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function BillboardDeviceControllerPS:GetQuickHackActions(context) return end

---@return Bool
function BillboardDeviceControllerPS:IsUsingDeviceAppearence() return end

---@return Bool
function BillboardDeviceControllerPS:IsUsingLights() return end

---@class Bink : CResource
Bink = {}

---@return Bink
function Bink.new() return end

---@param props table
---@return Bink
function Bink.new(props) return end

---@class BinkVideoEvent : redEvent
---@field path redResourceReferenceScriptToken
---@field startingTime Float
---@field shouldPlay Bool
BinkVideoEvent = {}

---@return BinkVideoEvent
function BinkVideoEvent.new() return end

---@param props table
---@return BinkVideoEvent
function BinkVideoEvent.new(props) return end

---@class BlackBoardRequestEvent : redEvent
---@field blackBoard gameIBlackboard
---@field storageClass gameScriptedBlackboardStorage
---@field entryTag CName
BlackBoardRequestEvent = {}

---@return BlackBoardRequestEvent
function BlackBoardRequestEvent.new() return end

---@param props table
---@return BlackBoardRequestEvent
function BlackBoardRequestEvent.new(props) return end

---@return gameIBlackboard
function BlackBoardRequestEvent:GetBlackboardReference() return end

---@return CName
function BlackBoardRequestEvent:GetEntryTag() return end

---@return gameScriptedBlackboardStorage
function BlackBoardRequestEvent:GetStorageType() return end

---@param newBlackbord gameIBlackboard
---@param blackBoardName CName|string
function BlackBoardRequestEvent:PassBlackBoardReference(newBlackbord, blackBoardName) return end

---@param storageType gameScriptedBlackboardStorage
function BlackBoardRequestEvent:SetStorageType(storageType) return end

---@class Blacklist : MorphData
Blacklist = {}

---@return Blacklist
function Blacklist.new() return end

---@param props table
---@return Blacklist
function Blacklist.new(props) return end

---@class BlacklistEntry : IScriptable
---@field entryID entEntityID
---@field entryReason BlacklistReason
---@field warningsCount Int32
---@field reprimandID Int32
BlacklistEntry = {}

---@return BlacklistEntry
function BlacklistEntry.new() return end

---@param props table
---@return BlacklistEntry
function BlacklistEntry.new(props) return end

function BlacklistEntry:AddWarning() return end

function BlacklistEntry:ForgetReason() return end

---@return entEntityID
function BlacklistEntry:GetEntityID() return end

---@return BlacklistReason
function BlacklistEntry:GetReason() return end

---@return Int32
function BlacklistEntry:GetWarningsCount() return end

---@param entityID entEntityID
---@param reason BlacklistReason
---@param id Int32
function BlacklistEntry:Initialize(entityID, reason, id) return end

function BlacklistEntry:ResetWarnings() return end

---@param reason BlacklistReason
---@param id Int32
---@return Bool
function BlacklistEntry:UpdateBlacklistEntry(reason, id) return end

---@class BlacklistPeriodEnded : redEvent
---@field entityID entEntityID
BlacklistPeriodEnded = {}

---@return BlacklistPeriodEnded
function BlacklistPeriodEnded.new() return end

---@param props table
---@return BlacklistPeriodEnded
function BlacklistPeriodEnded.new(props) return end

---@class BlacklistPlayer : redEvent
---@field blacklist Bool
---@field reason BlacklistReason
---@field forceRemoveAuthorization Bool
BlacklistPlayer = {}

---@return BlacklistPlayer
function BlacklistPlayer.new() return end

---@param props table
---@return BlacklistPlayer
function BlacklistPlayer.new(props) return end

---@return String
function BlacklistPlayer:GetFriendlyDescription() return end

---@class BlackwallAnimDef : gamebbScriptDefinition
---@field deathAnimNumber gamebbScriptID_Int32
---@field handGestureAnimNumber gamebbScriptID_Int32
BlackwallAnimDef = {}

---@return BlackwallAnimDef
function BlackwallAnimDef.new() return end

---@param props table
---@return BlackwallAnimDef
function BlackwallAnimDef.new(props) return end

---@return Bool
function BlackwallAnimDef:AutoCreateInSystem() return end

---@class BlackwallForceInteractionCondition : gameinteractionsInteractionScriptedCondition
BlackwallForceInteractionCondition = {}

---@return BlackwallForceInteractionCondition
function BlackwallForceInteractionCondition.new() return end

---@param props table
---@return BlackwallForceInteractionCondition
function BlackwallForceInteractionCondition.new(props) return end

---@param activatorObject gameObject
---@param hotSpotObject gameObject
---@return Bool
function BlackwallForceInteractionCondition:BlackwallForceEnabled(activatorObject, hotSpotObject) return end

---@param activatorObject gameObject
---@param hotSpotObject gameObject
---@return Bool
function BlackwallForceInteractionCondition:CanUseBlackwall(activatorObject, hotSpotObject) return end

---@param activatorObject gameObject
---@param hotSpotObject gameObject
---@return Bool
function BlackwallForceInteractionCondition:TargetMarkedByBlackwall(activatorObject, hotSpotObject) return end

---@param activatorObject gameObject
---@param hotSpotObject gameObject
---@return Bool
function BlackwallForceInteractionCondition:Test(activatorObject, hotSpotObject) return end

---@class BleedingEffectDamageUpdate : redEvent
BleedingEffectDamageUpdate = {}

---@return BleedingEffectDamageUpdate
function BleedingEffectDamageUpdate.new() return end

---@param props table
---@return BleedingEffectDamageUpdate
function BleedingEffectDamageUpdate.new(props) return end

---@class BlindManagerTask : StatusEffectTasks
BlindManagerTask = {}

---@return BlindManagerTask
function BlindManagerTask.new() return end

---@param props table
---@return BlindManagerTask
function BlindManagerTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function BlindManagerTask:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function BlindManagerTask:Deactivate(context) return end

---@class BlindingLight : BasicDistractionDevice
---@field areaComponent gameStaticTriggerAreaComponent
---@field highLightActive Bool
BlindingLight = {}

---@return BlindingLight
function BlindingLight.new() return end

---@param props table
---@return BlindingLight
function BlindingLight.new(props) return end

---@param evt entAreaEnteredEvent
---@return Bool
function BlindingLight:OnAreaEnter(evt) return end

---@param evt entAreaExitedEvent
---@return Bool
function BlindingLight:OnAreaExit(evt) return end

---@param evt OverloadDevice
---@return Bool
function BlindingLight:OnOverloadDevice(evt) return end

---@param evt GameAttachedEvent
---@return Bool
function BlindingLight:OnPersitentStateInitialized(evt) return end

---@param ri entEntityRequestComponentsInterface
---@return Bool
function BlindingLight:OnRequestComponents(ri) return end

---@param evt RevealDeviceRequest
---@return Bool
function BlindingLight:OnRevealDeviceRequest(evt) return end

---@param ri entEntityResolveComponentsInterface
---@return Bool
function BlindingLight:OnTakeControl(ri) return end

function BlindingLight:ApplyStatusEffect() return end

---@param highlightType EFocusForcedHighlightType
---@return FocusForcedHighlightData
function BlindingLight:CreateHighlight(highlightType) return end

---@return EGameplayRole
function BlindingLight:DeterminGameplayRole() return end

---@return BlindingLightController
function BlindingLight:GetController() return end

---@return BlindingLightControllerPS
function BlindingLight:GetDevicePS() return end

---@return entEntity[]
function BlindingLight:GetEntitiesInArea() return end

function BlindingLight:StartBlinking() return end

---@param loopAnimation Bool
function BlindingLight:StartDistraction(loopAnimation) return end

function BlindingLight:StopBlinking() return end

function BlindingLight:StopDistraction() return end

---@param toggle Bool
---@param id entEntityID
function BlindingLight:ToggleHighlightOnSingleTarget(toggle, id) return end

---@param toggle Bool
function BlindingLight:ToggleHighlightOnTargets(toggle) return end

function BlindingLight:TurnOffDevice() return end

function BlindingLight:TurnOffLights() return end

function BlindingLight:TurnOnDevice() return end

function BlindingLight:TurnOnLights() return end

---@class BlindingLightController : BasicDistractionDeviceController
BlindingLightController = {}

---@return BlindingLightController
function BlindingLightController.new() return end

---@param props table
---@return BlindingLightController
function BlindingLightController.new(props) return end

---@return BlindingLightControllerPS
function BlindingLightController:GetPS() return end

---@class BlindingLightControllerPS : BasicDistractionDeviceControllerPS
---@field reflectorSFX ReflectorSFX
BlindingLightControllerPS = {}

---@return BlindingLightControllerPS
function BlindingLightControllerPS.new() return end

---@param props table
---@return BlindingLightControllerPS
function BlindingLightControllerPS.new(props) return end

---@return Bool
function BlindingLightControllerPS:OnInstantiated() return end

---@return OverloadDevice
function BlindingLightControllerPS:ActionOverloadDevice() return end

---@return Bool
function BlindingLightControllerPS:CanCreateAnyQuickHackActions() return end

---@return TweakDBID
function BlindingLightControllerPS:GetBackgroundTextureTweakDBID() return end

---@return TweakDBID
function BlindingLightControllerPS:GetDeviceIconTweakDBID() return end

---@return CName
function BlindingLightControllerPS:GetDistractionSound() return end

---@param context gameGetActionsContext
---@return gamedeviceAction[]
function BlindingLightControllerPS:GetQuickHackActions(context) return end

---@return CName
function BlindingLightControllerPS:GetTurnOffSound() return end

---@return CName
function BlindingLightControllerPS:GetTurnOnSound() return end

function BlindingLightControllerPS:Initialize() return end

---@param evt OverloadDevice
---@return EntityNotificationType
function BlindingLightControllerPS:OnOverloadDevice(evt) return end

---@class BlinkingEvent : redEvent
---@field requestNumber Int32
BlinkingEvent = {}

---@return BlinkingEvent
function BlinkingEvent.new() return end

---@param props table
---@return BlinkingEvent
function BlinkingEvent.new(props) return end

---@class BlockAndCompensateScalingEvent : redEvent
BlockAndCompensateScalingEvent = {}

---@return BlockAndCompensateScalingEvent
function BlockAndCompensateScalingEvent.new() return end

---@param props table
---@return BlockAndCompensateScalingEvent
function BlockAndCompensateScalingEvent.new(props) return end

---@class BlockHealingConsumableDrop : gameScriptableSystemRequest
BlockHealingConsumableDrop = {}

---@return BlockHealingConsumableDrop
function BlockHealingConsumableDrop.new() return end

---@param props table
---@return BlockHealingConsumableDrop
function BlockHealingConsumableDrop.new(props) return end

---@class BlockReactionFlag : AIbehaviortaskScript
---@field target gameObject
BlockReactionFlag = {}

---@return BlockReactionFlag
function BlockReactionFlag.new() return end

---@param props table
---@return BlockReactionFlag
function BlockReactionFlag.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function BlockReactionFlag:Activate(context) return end

---@param context AIbehaviorScriptExecutionContext
function BlockReactionFlag:Deactivate(context) return end

---@class BlockReactionTask : AIbehaviortaskScript
BlockReactionTask = {}

---@return BlockReactionTask
function BlockReactionTask.new() return end

---@param props table
---@return BlockReactionTask
function BlockReactionTask.new(props) return end

---@param context AIbehaviorScriptExecutionContext
function BlockReactionTask:Deactivate(context) return end

---@class BlockStimProcessingCooldownEvent : redEvent
---@field stimData StimIdentificationData
BlockStimProcessingCooldownEvent = {}

---@return BlockStimProcessingCooldownEvent
function BlockStimProcessingCooldownEvent.new() return end

---@param props table
---@return BlockStimProcessingCooldownEvent
function BlockStimProcessingCooldownEvent.new(props) return end

---@class BloodPuddleEvent : redEvent
---@field slotName CName
---@field cyberBlood Bool
BloodPuddleEvent = {}

---@return BloodPuddleEvent
function BloodPuddleEvent.new() return end

---@param props table
---@return BloodPuddleEvent
function BloodPuddleEvent.new(props) return end

---@class BloodlustHealingEffector : ApplyEffectToDismemberedEffector
---@field poolSystem gameStatPoolsSystem
---@field maxDistanceSquared Float
---@field healAmount Float
---@field usePercent Bool
---@field lastActivationTime Float
BloodlustHealingEffector = {}

---@return BloodlustHealingEffector
function BloodlustHealingEffector.new() return end

---@param props table
---@return BloodlustHealingEffector
function BloodlustHealingEffector.new(props) return end

---@param owner gameObject
function BloodlustHealingEffector:ActionOn(owner) return end

---@param record TweakDBID|string
---@param parentRecord TweakDBID|string
function BloodlustHealingEffector:Initialize(record, parentRecord) return end

---@param owner gameObject
function BloodlustHealingEffector:ProcessAction(owner) return end

---@param owner gameObject
function BloodlustHealingEffector:RepeatedAction(owner) return end

---@class BloodswellCallback : gameDelaySystemScriptedDelayCallbackWrapper
---@field bloodswellEffector BloodswellEffector
BloodswellCallback = {}

---@return BloodswellCallback
function BloodswellCallback.new() return end

---@param props table
---@return BloodswellCallback
function BloodswellCallback.new(props) return end

---@param eff BloodswellEffector
---@return BloodswellCallback
function BloodswellCallback.Construct(eff) return end

---@class BloodswellEffector : gameEffector
---@field deathListener BloodswellEffectorHealthListener
---@field coldBloodListener BloodswellEffectorColdBloodListener
---@field gameInstance ScriptGameInstance
---@field owner gameObject
---@field isImmortal Bool
BloodswellEffector = {}

---@return BloodswellEffector
function BloodswellEffector.new() return end

---@param props table
---@return BloodswellEffector
function BloodswellEffector.new(props) return end

---@param owner gameObject
function BloodswellEffector:ActionOn(owner) return end

function BloodswellEffector:C